/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.bankacct.management;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.am.common.helper.AmParameterHelper;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.am.common.helper.BankAcctManageHelp;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.AcctStyleEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankAcctManageTransferSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("accountbank");
        sic.add("targetorg");
        sic.add("originorg");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Set accountIdSet = Arrays.stream(this.dataEntities).map(data -> data.getDataEntity().getDynamicObject("accountbank").getPkValue()).collect(Collectors.toSet());
        DynamicObject[] accounts = BusinessDataServiceHelper.load((Object[])accountIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_accountbanks"));
        Map idAndAccountMap = Arrays.stream(accounts).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity(), (a, b) -> a));
        for (ExtendedDataEntity data2 : this.dataEntities) {
            DynamicObject originOrg;
            String msg;
            DynamicObject transferInfo = data2.getDataEntity();
            DynamicObject dataAccount = transferInfo.getDynamicObject("accountbank");
            DynamicObject targetOrg = transferInfo.getDynamicObject("targetorg");
            if (EmptyUtil.isEmpty((DynamicObject)targetOrg)) continue;
            DynamicObject account = (DynamicObject)idAndAccountMap.get(dataAccount.getPkValue());
            String acctStyle = account.getString("acctstyle");
            if (StringUtils.equals((CharSequence)acctStyle, (CharSequence)AcctStyleEnum.BASIC.getValue()) && AmParameterHelper.getAppBoolParameter((long)targetOrg.getLong("id"), (String)"ischeckonebasic") && BankAcctHelper.isExistBasicAccount((Object)targetOrg.getLong("id"), (Object)dataAccount.getLong("id"))) {
                this.addErrorMessage(data2, ResManager.loadKDString((String)"\u76ee\u6807\u7ba1\u7406\u6743\u7ec4\u7ec7\u5df2\u5b58\u5728\u4e00\u4e2a\u57fa\u672c\u5b58\u6b3e\u8d26\u6237\u3002", (String)"BankAcctManageTransferSubmitValidator_01", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isNotEmpty((CharSequence)(msg = BankAcctManageHelp.comparePeriod((DynamicObject)(originOrg = transferInfo.getDynamicObject("originorg")), (DynamicObject)targetOrg, (String)dataAccount.getString("number"))))) continue;
            this.addErrorMessage(data2, msg);
        }
    }
}

