/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.elec;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.tmc.bei.extpoint.receipt.IReceiptMatchTransDetail;
import kd.tmc.bei.business.helper.ElecMatchCheckHelper;
import kd.tmc.bei.business.helper.HandMatchServiceHelper;
import kd.tmc.bei.business.helper.TransDetailHelper;
import kd.tmc.bei.business.opservice.elec.ElecMatchDetailService;
import kd.tmc.bei.business.opservice.elec.ViewReceiptService;
import kd.tmc.bei.common.enums.ReceiptMatchTypeEnum;
import kd.tmc.bei.common.helper.BeiHelper;
import kd.tmc.bei.common.helper.CodeRuleHelper;
import kd.tmc.bei.common.helper.SyncAutoBalanceHelper;
import kd.tmc.fbp.common.compare.api.impl.CompareApiImpl;
import kd.tmc.fbp.common.compare.result.CompareResult;
import kd.tmc.fbp.common.enums.MatchRelEnum;
import kd.tmc.fbp.common.helper.GenBankcheckCode;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReceiptMatchEdit
extends AbstractBillPlugIn
implements ListRowClickListener,
HyperLinkClickListener,
TabSelectListener,
SetFilterListener {
    private static final Log logger = LogFactory.getLog(ReceiptMatchEdit.class);
    private static final String IDS = "ids";
    private static final String BILLNO = "billno";
    private static final String DETAILIDS = "detailids";
    private static final String ISMULTI = "ismulti";
    private static final String ORDERBY_STR = "accountbank asc, bizdate desc, currency asc, billno asc";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BillList elecBillList = (BillList)this.getControl("billlistap_elec");
        BillList elecBillListMulti = (BillList)this.getControl("billlistap_elec_multi");
        BillList tranBillList = (BillList)this.getControl("billlistap_tran");
        BillList tranBillListMulti = (BillList)this.getControl("billlistap_tran_multi");
        elecBillList.addListRowClickListener((ListRowClickListener)this);
        elecBillList.addHyperClickListener((HyperLinkClickListener)this);
        elecBillList.addSetFilterListener((SetFilterListener)this);
        elecBillListMulti.addListRowClickListener((ListRowClickListener)this);
        elecBillListMulti.addHyperClickListener((HyperLinkClickListener)this);
        elecBillListMulti.addSetFilterListener((SetFilterListener)this);
        tranBillList.addListRowClickListener((ListRowClickListener)this);
        tranBillList.addHyperClickListener((HyperLinkClickListener)this);
        tranBillList.addSetFilterListener((SetFilterListener)this);
        tranBillListMulti.addListRowClickListener((ListRowClickListener)this);
        tranBillListMulti.addHyperClickListener((HyperLinkClickListener)this);
        tranBillListMulti.addSetFilterListener((SetFilterListener)this);
        Tab tabAp = (Tab)this.getControl("tabap");
        tabAp.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put(ISMULTI, String.valueOf(false));
        QFilter transDetailQfilter = this.getDetailListFilter(this.getElecFilter());
        DynamicObjectCollection details = QueryServiceHelper.query((String)"bei_transdetail", (String)"id", (QFilter[])new QFilter[]{transDetailQfilter});
        this.setTranDetailFilter(details);
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        BillList billList = (BillList)setFilterEvent.getSource();
        if ("bei_elecreceipt".equals(billList.getEntityId())) {
            setFilterEvent.addCustomQFilter(this.getElecFilter());
        } else if ("bei_transdetail".equals(billList.getEntityId())) {
            boolean isMulti = Boolean.parseBoolean(this.getPageCache().get(ISMULTI));
            Control transdetailtab = this.getControl(isMulti ? "transdetailtab_multi" : "transdetailtab");
            boolean includematched = (Boolean)transdetailtab.getModel().getDataEntity().get(isMulti ? "includematched_multi" : "includematched");
            QFilter tranDetailFilter = this.getTranDetailFilter(includematched);
            BillList elecBillList = (BillList)this.getControl(isMulti ? "billlistap_elec_multi" : "billlistap_elec");
            if (!elecBillList.getSelectedRows().isEmpty()) {
                ListSelectedRow listSelectedRow = elecBillList.getSelectedRows().get(0);
                DynamicObject selectedElecReceipt = QueryServiceHelper.queryOne((String)"bei_elecreceipt", (String)"id,currency", (QFilter[])new QFilter[]{new QFilter("id", "=", listSelectedRow.getPrimaryKeyValue())});
                if (EmptyUtil.isEmpty((DynamicObject)selectedElecReceipt)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7535\u5b50\u56de\u5355\u6216\u4ea4\u6613\u660e\u7ec6\u6570\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReceiptMatchEdit_21", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                }
                tranDetailFilter.and("currency", "=", (Object)selectedElecReceipt.getLong("currency"));
            }
            setFilterEvent.addCustomQFilter(tranDetailFilter);
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        boolean isMultiBefore;
        String tabKey = tabSelectEvent.getTabKey();
        boolean isMulti = "multi2oneap".equals(tabKey);
        if (isMulti == (isMultiBefore = Boolean.parseBoolean(this.getPageCache().get(ISMULTI)))) {
            return;
        }
        this.getPageCache().put(ISMULTI, String.valueOf(isMulti));
        if (isMulti) {
            BillList elecBillList = (BillList)this.getControl("billlistap_elec_multi");
            BillList tranBillList = (BillList)this.getControl("billlistap_tran_multi");
            elecBillList.clearSelection();
            tranBillList.clearSelection();
            if (this.getModel().getDataEntity() != null) {
                QFilter transDetailQfilter = this.getDetailListFilter(this.getElecFilter());
                DynamicObjectCollection details = QueryServiceHelper.query((String)"bei_transdetail", (String)"id", (QFilter[])new QFilter[]{transDetailQfilter});
                this.setTranDetailFilter(details);
                elecBillList.setOrderBy(ORDERBY_STR);
                tranBillList.setOrderBy(ORDERBY_STR);
                tranBillList.refresh();
                elecBillList.refresh();
            }
        } else {
            BillList elecBillList = (BillList)this.getControl("billlistap_elec");
            elecBillList.selectRows(elecBillList.getSelectedRows().getRowKeys());
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String ids = (String)formShowParameter.getCustomParam(IDS);
        this.getPageCache().put(IDS, ids);
        BillList elecBillList = (BillList)this.getControl("billlistap_elec");
        if (this.getModel().getDataEntity() != null) {
            elecBillList.setFilter(this.getElecFilter());
            elecBillList.setOrderBy(ORDERBY_STR);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isMulti = Boolean.parseBoolean(this.getPageCache().get(ISMULTI));
        BillList billList = (BillList)this.getControl(isMulti ? "billlistap_elec_multi" : "billlistap_elec");
        if (this.getModel().getDataEntity() != null && EmptyUtil.isNoEmpty((String)this.getPageCache().get(IDS))) {
            billList.selectRows(0);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("viewreceipt".equals(operateKey) || "batchviewreceipt".equals(operateKey)) {
            this.checkBillExist();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (("viewreceipt".equals(args.getOperateKey()) || "batchviewreceipt".equals(args.getOperateKey())) && args.getOperationResult().isSuccess()) {
            boolean isMulti = Boolean.parseBoolean(this.getPageCache().get(ISMULTI));
            BillList elecBillList = (BillList)this.getControl(isMulti ? "billlistap_elec_multi" : "billlistap_elec");
            ListSelectedRowCollection selectedRows = elecBillList.getSelectedRows();
            if (selectedRows == null || selectedRows.isEmpty()) {
                return;
            }
            ViewReceiptService viewReceiptService = new ViewReceiptService();
            String receiptPdfUrl = viewReceiptService.getReceiptPdfUrl(this.getView().getPageId(), selectedRows.getPrimaryKeyValues());
            if (EmptyUtil.isEmpty((String)receiptPdfUrl)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355%s\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReceiptMatchEdit_18", (String)"tmc-bei-formplugin", (Object[])new Object[]{selectedRows.get(0).getBillNo()}));
            } else {
                this.openForm(receiptPdfUrl);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        boolean isMulti = Boolean.parseBoolean(this.getPageCache().get(ISMULTI));
        this.checkBillExist();
        if ("handmatch".equals(key)) {
            BillList elecBillList = (BillList)this.getControl(isMulti ? "billlistap_elec_multi" : "billlistap_elec");
            BillList tranBillList = (BillList)this.getControl(isMulti ? "billlistap_tran_multi" : "billlistap_tran");
            ListSelectedRowCollection elecSelect = elecBillList.getSelectedRows();
            ListSelectedRowCollection tranSelect = tranBillList.getSelectedRows();
            if (elecSelect.isEmpty() || tranSelect.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ReceiptMatchEdit_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                return;
            }
            List<Long> elecIdList = this.getBillIdFromRow(elecSelect);
            List<Long> tranIdList = this.getBillIdFromRow(tranSelect);
            DynamicObjectCollection selectedTransdetail = QueryServiceHelper.query((String)"bei_transdetail", (String)"id,ismatchereceipt,detailid", (QFilter[])new QFilter[]{new QFilter("id", "in", tranIdList)});
            List collect = selectedTransdetail.stream().filter(e -> (Boolean)e.get("ismatchereceipt")).map(t -> t.getString("detailid")).collect(Collectors.toList());
            if (!collect.isEmpty()) {
                String join = String.join((CharSequence)",", collect);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u6d41\u6c34\u53f7\u4e3a%s\u7684\u4ea4\u6613\u660e\u7ec6\u5df2\u5339\u914d\u7535\u5b50\u56de\u5355\uff0c\u4e0d\u80fd\u518d\u6b21\u5339\u914d\u3002", (String)"ReceiptMatchEdit_14", (String)"tmc-bei-formplugin", (Object[])new Object[0]), join));
                return;
            }
            List<Long> elecFileIds = this.checkHandMatchElecFile(elecIdList);
            if (!elecFileIds.isEmpty() && elecFileIds.size() != elecIdList.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u52fe\u9009\u7535\u5b50\u56de\u5355\u6570\u636e\u540c\u65f6\u5305\u542b\u975e\u6587\u4ef6\u7c7b\u4e0e\u6587\u4ef6\u7c7b\u7535\u5b50\u56de\u5355\uff0c\u4e0d\u80fd\u8fdb\u884c\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReceiptMatchEdit_19", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!elecFileIds.isEmpty()) {
                this.showHandMatchFileView(elecFileIds, tranIdList);
            } else {
                this.handCheck(elecIdList, tranIdList, false);
            }
        } else if ("refresh".equals(key)) {
            this.refresh();
            BillList elecBillList = (BillList)this.getControl(isMulti ? "billlistap_elec_multi" : "billlistap_elec");
            if (this.getPageCache().get("selectedElecBeforeIndex") != null && !isMulti) {
                int rowIndex = Integer.parseInt(this.getPageCache().get("selectedElecBeforeIndex"));
                elecBillList.selectRows(rowIndex);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"ReceiptMatchEdit_11", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        } else if ("gentrandetail".equals(key)) {
            this.gentrandetail();
        } else if ("automatch".equals(key)) {
            String ids = this.getPageCache().get(IDS);
            List elecAllList = JSON.parseArray((String)ids, Object.class);
            String detailids = this.getPageCache().get(DETAILIDS);
            List tranAllList = JSON.parseArray((String)detailids, Object.class);
            if (elecAllList == null || elecAllList.isEmpty() || tranAllList == null || tranAllList.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u6570\u636e\u6216\u4ea4\u6613\u660e\u7ec6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReceiptMatchEdit_16", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                return;
            }
            logger.info("\u7535\u5b50\u56de\u5355\u6570\u91cf\uff1a{}, \u4ea4\u6613\u660e\u7ec6\u6570\u91cf\uff1a{}", (Object)elecAllList.size(), (Object)tranAllList.size());
            DynamicObjectCollection elecObjs = QueryServiceHelper.query((String)"bei_elecreceipt", (String)"id,receiptno,detailid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)elecAllList)});
            Set collect = elecObjs.stream().filter(e -> EmptyUtil.isEmpty((Object)e.get("receiptno"))).map(t -> String.valueOf(t.get("detailid"))).collect(Collectors.toSet());
            if (!EmptyUtil.isEmpty(collect)) {
                String str = String.join((CharSequence)",", collect);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u6d41\u6c34\u53f7\u4e3a%s\u7684\u7535\u5b50\u56de\u5355\u7684\u7535\u5b50\u56de\u5355\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5339\u914d\u3002", (String)"ReceiptMatchEdit_15", (String)"tmc-bei-formplugin", (Object[])new Object[0]), str));
                return;
            }
            this.autoCheck(elecAllList, tranAllList);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (BILLNO.equals(fieldName)) {
            BillList billList = (BillList)hyperLinkClickEvent.getSource();
            String entityId = billList.getEntityId();
            boolean isMulti = Boolean.parseBoolean(this.getPageCache().get(ISMULTI));
            this.checkBillExist();
            if ("bei_elecreceipt".equals(entityId)) {
                BillList elecBillList = (BillList)this.getControl(isMulti ? "billlistap_elec_multi" : "billlistap_elec");
                ListSelectedRowCollection selectedRows = elecBillList.getSelectedRows();
                ListSelectedRow listSelectedRow = selectedRows.get(0);
                BillShowParameter showForm = new BillShowParameter();
                showForm.setFormId(entityId);
                showForm.getOpenStyle().setShowType(ShowType.Modal);
                StyleCss styleCss = new StyleCss();
                styleCss.setWidth("1080");
                styleCss.setHeight("750");
                showForm.getOpenStyle().setInlineStyleCss(styleCss);
                showForm.setPkId(listSelectedRow.getPrimaryKeyValue());
                this.getView().showForm((FormShowParameter)showForm);
            } else if ("bei_transdetail".equals(entityId)) {
                BillList tranBillList = (BillList)this.getControl(isMulti ? "billlistap_tran_multi" : "billlistap_tran");
                ListSelectedRowCollection selectedRows = tranBillList.getSelectedRows();
                ListSelectedRow listSelectedRow = selectedRows.get(0);
                BillShowParameter showForm = new BillShowParameter();
                showForm.setFormId(entityId);
                showForm.getOpenStyle().setShowType(ShowType.Modal);
                StyleCss styleCss = new StyleCss();
                styleCss.setWidth("1080");
                styleCss.setHeight("750");
                showForm.getOpenStyle().setInlineStyleCss(styleCss);
                showForm.setPkId(listSelectedRow.getPrimaryKeyValue());
                showForm.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)showForm);
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRowCollection selectedRows;
        super.listRowClick(evt);
        Control source = (Control)evt.getSource();
        boolean isMulti = Boolean.parseBoolean(this.getPageCache().get(ISMULTI));
        BillList elecBillList = (BillList)this.getControl(isMulti ? "billlistap_elec_multi" : "billlistap_elec");
        BillList tranBillList = (BillList)this.getControl(isMulti ? "billlistap_tran_multi" : "billlistap_tran");
        ListSelectedRow transCurrentSelectInfo = tranBillList.getCurrentSelectedRowInfo();
        int rowIndex = 0;
        long pkValueBefore = 0L;
        Long primaryKeyValue = 0L;
        ListSelectedRow currentSelectedRowInfo = elecBillList.getCurrentSelectedRowInfo();
        if (this.getPageCache().get("selectedElecBeforeIndex") != null) {
            rowIndex = Integer.parseInt(this.getPageCache().get("selectedElecBeforeIndex"));
            pkValueBefore = Long.parseLong(this.getPageCache().get("selectedElecBeforePK"));
        }
        if (!(selectedRows = elecBillList.getSelectedRows()).isEmpty()) {
            this.getPageCache().put("selectedElecBeforeIndex", String.valueOf(selectedRows.get(0).getRowKey()));
            this.getPageCache().put("selectedElecBeforePK", String.valueOf(selectedRows.get(0).getPrimaryKeyValue()));
        } else if (isMulti && this.getPageCache().get("multiSelect") != null) {
            this.getPageCache().remove("multiSelect");
        }
        HashSet pkSet = new HashSet(selectedRows.size());
        if (!(currentSelectedRowInfo != null && currentSelectedRowInfo.getPrimaryKeyValue() != null || isMulti)) {
            elecBillList.selectRows(rowIndex);
        }
        if (selectedRows.size() == 1) {
            primaryKeyValue = (Long)selectedRows.get(0).getPrimaryKeyValue();
        } else if (selectedRows.size() > 1 && isMulti) {
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            pkSet.addAll(Arrays.stream(primaryKeyValues).map(pk -> Long.valueOf(pk.toString())).collect(Collectors.toSet()));
        } else {
            primaryKeyValue = pkValueBefore;
        }
        QFilter qFilter = isMulti && selectedRows.isEmpty() ? this.getElecFilter() : new QFilter("id", "in", (Object)(pkSet.isEmpty() ? primaryKeyValue : pkSet));
        DynamicObjectCollection selectedElecReceipt = QueryServiceHelper.query((String)"bei_elecreceipt", (String)"id,debitamount,creditamount,bizdate,accountbank.id,currency", (QFilter[])new QFilter[]{qFilter});
        Control transdetailtab = this.getControl(isMulti ? "transdetailtab_multi" : "transdetailtab");
        boolean includematched = (Boolean)transdetailtab.getModel().getDataEntity().get(isMulti ? "includematched_multi" : "includematched");
        if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)selectedElecReceipt)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u7535\u5b50\u56de\u5355\u6570\u636e\u3002", (String)"ReceiptMatchEdit_12", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter transDetailQfilter = this.getDetailListFilter(qFilter);
        DynamicObjectCollection detailObjs = QueryServiceHelper.query((String)"bei_transdetail", (String)"id", (QFilter[])new QFilter[]{transDetailQfilter});
        this.setTranDetailFilter(detailObjs);
        if (this.getModel().getDataEntity() != null) {
            elecBillList.setFilter(this.getElecFilter());
            tranBillList.setFilter(this.getTranDetailFilter(includematched));
            elecBillList.setOrderBy(ORDERBY_STR);
            tranBillList.setOrderBy(ORDERBY_STR);
        }
        if (StringUtils.equals((CharSequence)(isMulti ? "billlistap_elec_multi" : "billlistap_elec"), (CharSequence)source.getKey())) {
            tranBillList.clearSelection();
            tranBillList.refresh();
            if (isMulti) {
                if (!selectedRows.isEmpty() && this.getPageCache().get("multiSelect") == null) {
                    elecBillList.setFilter(this.getElecMultiFilter());
                    elecBillList.setOrderBy(ORDERBY_STR);
                    this.getPageCache().put("multiSelect", Arrays.toString(selectedRows.getPrimaryKeyValues()));
                    elecBillList.refresh();
                } else if (selectedRows.isEmpty()) {
                    elecBillList.clearSelection();
                    elecBillList.refresh();
                }
            }
        } else if (!(!StringUtils.equals((CharSequence)(isMulti ? "billlistap_tran_multi" : "billlistap_tran"), (CharSequence)source.getKey()) || transCurrentSelectInfo != null && transCurrentSelectInfo.getPrimaryKeyValue() != null || evt.getListSelectedRowCollection().size() == tranBillList.getSelectedRows().size() || transCurrentSelectInfo == null && tranBillList.getSelectedRows().size() == 1)) {
            tranBillList.refresh();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        boolean isMulti = Boolean.parseBoolean(this.getPageCache().get(ISMULTI));
        BillList elecBillList = (BillList)this.getControl(isMulti ? "billlistap_elec_multi" : "billlistap_elec");
        BillList tranBillList = (BillList)this.getControl(isMulti ? "billlistap_tran_multi" : "billlistap_tran");
        Control transdetailtab = this.getControl(isMulti ? "transdetailtab_multi" : "transdetailtab");
        boolean moneyexactmatch = (Boolean)transdetailtab.getModel().getDataEntity().get(isMulti ? "moneyexactmatch_multi" : "moneyexactmatch");
        boolean bizdateexactmatch = (Boolean)transdetailtab.getModel().getDataEntity().get(isMulti ? "bizdateexactmatch_multi" : "bizdateexactmatch");
        boolean includematched = (Boolean)transdetailtab.getModel().getDataEntity().get(isMulti ? "includematched_multi" : "includematched");
        boolean includelessbizmoney = (Boolean)transdetailtab.getModel().getDataEntity().get(isMulti ? "includelessbizmoney_multi" : "includelessbizmoney");
        Set cacheBankIdSet = (Set)JSON.parseObject((String)this.getPageCache().get("cacheBankId"), Set.class);
        Map cacheBizDateMap = (Map)JSON.parseObject((String)this.getPageCache().get("cacheBizDate"), Map.class);
        Map cacheDebitAmtMap = (Map)JSON.parseObject((String)this.getPageCache().get("cacheDebitamount"), Map.class);
        Map cacheCreditAmtMap = (Map)JSON.parseObject((String)this.getPageCache().get("cacheCreditamount"), Map.class);
        QFilter transDetailQfilter = null;
        for (Object object : cacheBankIdSet) {
            Long bankAcctId = (Long)object;
            QFilter subFilter = new QFilter("accountbank", "=", (Object)bankAcctId);
            if (bizdateexactmatch) {
                List bizDateSet = ((JSONArray)cacheBizDateMap.get(bankAcctId)).toJavaList(String.class);
                subFilter.and(new QFilter("bizdate", "in", bizDateSet.stream().map(date -> DateUtils.stringToDate((String)date, (String)"yyyy-MM-dd")).collect(Collectors.toSet())));
            }
            List cacheDebitAmtList = ((JSONArray)cacheDebitAmtMap.get(bankAcctId)).toJavaList(BigDecimal.class);
            List cacheCreditAmtList = ((JSONArray)cacheCreditAmtMap.get(bankAcctId)).toJavaList(BigDecimal.class);
            if (moneyexactmatch || includelessbizmoney) {
                QFilter moneyFilter = null;
                QFilter lessFilter = null;
                for (int i = 0; i < cacheDebitAmtList.size() && i < cacheCreditAmtList.size(); ++i) {
                    BigDecimal debitAmt = (BigDecimal)cacheDebitAmtList.get(i);
                    BigDecimal creditAmt = (BigDecimal)cacheCreditAmtList.get(i);
                    if (moneyexactmatch) {
                        moneyFilter = this.getMoneyFilter(debitAmt, creditAmt, moneyFilter, false);
                    }
                    if (!includelessbizmoney) continue;
                    lessFilter = this.getLessFilter(debitAmt, creditAmt, lessFilter);
                }
                BigDecimal sumDebitAmt = BigDecimal.ZERO;
                BigDecimal sumCreditAmt = BigDecimal.ZERO;
                for (BigDecimal debitAmt : cacheDebitAmtList) {
                    sumDebitAmt = sumDebitAmt.add(debitAmt);
                }
                for (BigDecimal creditAmt : cacheCreditAmtList) {
                    sumCreditAmt = sumCreditAmt.add(creditAmt);
                }
                if (moneyFilter == null) {
                    if (lessFilter != null) {
                        subFilter.and(lessFilter);
                    }
                } else {
                    moneyFilter = this.getMoneyFilter(sumDebitAmt, sumCreditAmt, moneyFilter, cacheDebitAmtList.size() > 1 && cacheCreditAmtList.size() > 1);
                    if (lessFilter != null) {
                        lessFilter.or(moneyFilter);
                        subFilter.and(lessFilter);
                    } else {
                        subFilter.and(moneyFilter);
                    }
                }
            }
            transDetailQfilter = transDetailQfilter == null ? subFilter : transDetailQfilter.or(subFilter);
        }
        if (transDetailQfilter == null) {
            transDetailQfilter = new QFilter("receiptno", "is not null", null);
        }
        if (!includematched) {
            QFilter matchedFilter = new QFilter("ismatchereceipt", "=", (Object)"0");
            transDetailQfilter.and(matchedFilter);
        }
        if (!elecBillList.getSelectedRows().isEmpty()) {
            ListSelectedRow listSelectedRow = elecBillList.getSelectedRows().get(0);
            DynamicObject selectedElecReceipt = QueryServiceHelper.queryOne((String)"bei_elecreceipt", (String)"id,currency", (QFilter[])new QFilter[]{new QFilter("id", "=", listSelectedRow.getPrimaryKeyValue())});
            if (EmptyUtil.isEmpty((DynamicObject)selectedElecReceipt)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7535\u5b50\u56de\u5355\u6216\u4ea4\u6613\u660e\u7ec6\u6570\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReceiptMatchEdit_21", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            }
            transDetailQfilter.and("currency", "=", (Object)selectedElecReceipt.getLong("currency"));
        }
        DynamicObjectCollection detailObjs = QueryServiceHelper.query((String)"bei_transdetail", (String)"id", (QFilter[])new QFilter[]{transDetailQfilter});
        this.setTranDetailFilter(detailObjs);
        if (this.getModel().getDataEntity() != null) {
            elecBillList.setFilter(this.getElecFilter());
            tranBillList.setFilter(this.getTranDetailFilter(includematched));
            elecBillList.setOrderBy(ORDERBY_STR);
            tranBillList.setOrderBy(ORDERBY_STR);
            tranBillList.clearSelection();
            tranBillList.refresh();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnMap;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("handMatchFileCallBack".equals(actionId) && !EmptyUtil.isEmpty((Object)(returnMap = (Map)closedCallBackEvent.getReturnData()))) {
            this.handCheck((List)returnMap.get("elecFileIds"), (List)returnMap.get("transIds"), true);
        }
    }

    private void autoCheck(List<Object> elecAllList, List<Object> tranAllList) {
        CompareApiImpl compareApi = new CompareApiImpl();
        List list = compareApi.compare(elecAllList, tranAllList, "bei_elecreceipt", "bei_transdetail", "company");
        HashSet<Long> removeElecIds = new HashSet<Long>();
        ArrayList<DynamicObject> successElec = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> successTran = new ArrayList<DynamicObject>();
        HashSet matchRelatedBizBillSet = new HashSet(4);
        ElecMatchDetailService elecMatchDetailService = new ElecMatchDetailService();
        for (CompareResult compareResult : list) {
            Set elecIdSet = compareResult.getSrcIdSet();
            Set tranIdSet = compareResult.getTarIdSet();
            if (elecIdSet.isEmpty() || tranIdSet.isEmpty()) continue;
            Object elecId = elecIdSet.iterator().next();
            Object tranId = tranIdSet.iterator().next();
            DynamicObject elecObj = BusinessDataServiceHelper.loadSingle(elecId, (String)"bei_elecreceipt");
            DynamicObject tranObj = BusinessDataServiceHelper.loadSingle(tranId, (String)"bei_transdetail");
            elecObj.set("ismatch", (Object)Boolean.TRUE);
            elecObj.set("currency", (Object)(elecObj.getDynamicObject("currency") == null ? tranObj.getDynamicObject("currency") : elecObj.getDynamicObject("currency")));
            DynamicObjectCollection matchdetailentry = elecObj.getDynamicObjectCollection("matchdetailentry");
            DynamicObject entry = matchdetailentry.addNew();
            entry.set("e_transdetailid", (Object)tranObj.getLong("id"));
            entry.set("e_bankcheckflag", (Object)tranObj.getString("bankcheckflag"));
            elecObj.set("extdata", (Object)tranObj.getString("extdata"));
            BigDecimal debitamount = tranObj.getBigDecimal("debitamount");
            BigDecimal creditamount = tranObj.getBigDecimal("creditamount");
            if (ElecMatchCheckHelper.checkReceiptIsFile((DynamicObject)elecObj)) {
                elecObj.set("debitamount", (Object)debitamount);
                elecObj.set("creditamount", (Object)creditamount);
            }
            if (debitamount.compareTo(BigDecimal.ZERO) > 0) {
                elecObj.set("amount", (Object)debitamount);
                elecObj.set("creditdebitflag", (Object)"1");
            } else if (debitamount.compareTo(BigDecimal.ZERO) < 0) {
                elecObj.set("amount", (Object)debitamount.abs());
                elecObj.set("creditdebitflag", (Object)"2");
            } else if (creditamount.compareTo(BigDecimal.ZERO) < 0) {
                elecObj.set("amount", (Object)creditamount.abs());
                elecObj.set("creditdebitflag", (Object)"1");
            } else {
                elecObj.set("amount", (Object)creditamount);
                elecObj.set("creditdebitflag", (Object)"2");
            }
            ElecMatchCheckHelper.setFieldValue((DynamicObject)tranObj, (DynamicObject)elecObj);
            elecObj.set("oppunit", (Object)(EmptyUtil.isEmpty((String)elecObj.getString("oppunit")) ? tranObj.getString("oppunit") : elecObj.getString("oppunit")));
            elecObj.set("oppbanknumber", (Object)(EmptyUtil.isEmpty((String)elecObj.getString("oppbanknumber")) ? tranObj.getString("oppbanknumber") : elecObj.getString("oppbanknumber")));
            elecObj.set("oppbank", (Object)(EmptyUtil.isEmpty((String)elecObj.getString("oppbank")) ? tranObj.getString("oppbank") : elecObj.getString("oppbank")));
            elecObj.set("description", (Object)(EmptyUtil.isEmpty((String)elecObj.getString("description")) || BeiHelper.isReceiptFileFromBank((DynamicObject)elecObj) ? tranObj.getString("description") : elecObj.getString("description")));
            elecObj.set("bankcheckflag", (Object)tranObj.getString("bankcheckflag"));
            elecObj.set("matchtype", (Object)ReceiptMatchTypeEnum.PARSE.getValue());
            elecObj.set("matcher", (Object)RequestContext.get().getCurrUserId());
            elecObj.set("matchtime", (Object)new Date());
            tranObj.set("ismatchereceipt", (Object)"1");
            tranObj.set("receiptno", elecObj.get("receiptno"));
            HandMatchServiceHelper.setMatchReceiptEntry((DynamicObject)tranObj, (Long)elecObj.getLong("id"), (String)elecObj.getString("receiptno"));
            this.afterMatchFieldValueCover(MatchRelEnum.ONE_TO_ONE, Collections.singletonList(elecObj), Collections.singletonList(tranObj));
            successElec.add(elecObj);
            successTran.add(tranObj);
            removeElecIds.add((Long)elecId);
            Set billIds = elecMatchDetailService.checkBizBillGetReceipt("cas_paybill", "bei_transdetail", Long.valueOf(tranObj.getLong("id")), tranObj.getString("bankcheckflag"));
            if (billIds.isEmpty()) continue;
            matchRelatedBizBillSet.addAll(billIds);
        }
        if (!successElec.isEmpty() && !successTran.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])successElec.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])successTran.toArray(new DynamicObject[0]));
            elecAllList.removeAll(removeElecIds);
            DynamicObjectCollection objs = QueryServiceHelper.query((String)"bei_elecreceipt", (String)"id,accountbank.id,ismatch", (QFilter[])new QFilter[]{new QFilter("id", "in", elecAllList)});
            Set<Object> accountbanks = new HashSet();
            if (!EmptyUtil.isEmpty((DynamicObjectCollection)objs)) {
                accountbanks = objs.stream().map(e -> Long.parseLong(e.get("accountbank.id").toString())).collect(Collectors.toSet());
            }
            QFilter detailFilter = new QFilter("accountbank", "in", accountbanks).and(new QFilter("ismatchereceipt", "=", (Object)"0"));
            DynamicObjectCollection detailObjs = QueryServiceHelper.query((String)"bei_transdetail", (String)"id", (QFilter[])new QFilter[]{detailFilter});
            this.setTranDetailFilter(detailObjs);
            String elecIdsJson = JSON.toJSONString(elecAllList);
            this.getPageCache().put(IDS, elecIdsJson);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5339\u914d\u5b8c\u6210\uff0c\u6210\u529f\u5339\u914d%s\u6761\u6570\u636e\u3002", (String)"ReceiptMatchEdit_6", (String)"tmc-bei-formplugin", (Object[])new Object[]{successElec.size()}));
            this.refresh();
            if (!matchRelatedBizBillSet.isEmpty()) {
                ElecMatchCheckHelper.setBizBillGetReceipt((String)"cas_paybill", matchRelatedBizBillSet, (Boolean)false);
            }
        } else if (successElec.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5339\u914d\u5b8c\u6210\uff0c\u6ca1\u6709\u7b26\u5408\u5339\u914d\u89c4\u5219\u7684\u6570\u636e\u3002", (String)"ReceiptMatchEdit_5", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
    }

    private void gentrandetail() {
        boolean isMulti = Boolean.parseBoolean(this.getPageCache().get(ISMULTI));
        BillList elecBillList = (BillList)this.getControl(isMulti ? "billlistap_elec_multi" : "billlistap_elec");
        ListSelectedRowCollection elecSelect = elecBillList.getSelectedRows();
        if (elecSelect.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u56de\u5355\u6570\u636e\u3002", (String)"ReceiptMatchEdit_3", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Long> ids = this.getSelectedIdList(elecSelect);
        DynamicObject[] receipts = BusinessDataServiceHelper.load((String)"bei_elecreceipt", (String)"id,transdetailid,biztype,company,receiptno,billno,bizdate,currency,bank,description,bizrefno,debitamount,creditamount,oppunit,oppbanknumber,oppbank,detailid,accountbank,ismatch,datasource,bankcheckflag,matchdetailentry,matchdetailentry.e_transdetailid,matchdetailentry.e_bankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        HashMap<String, String> map = new HashMap<String, String>(receipts.length);
        ArrayList<DynamicObject> successReceipt = new ArrayList<DynamicObject>(receipts.length);
        ArrayList<DynamicObject> tranList = new ArrayList<DynamicObject>();
        String downloadMessage = ResManager.loadKDString((String)"\u6765\u6e90\u94f6\u4f01\u63a5\u53e3\u7684\u7535\u5b50\u56de\u5355\u4e0d\u652f\u6301\u624b\u5de5\u751f\u6210\u4ea4\u6613\u660e\u7ec6\uff0c\u8bf7\u8054\u673a\u4e0b\u8f7d\u3002", (String)"ReceiptMatchEdit_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
        String regenMessage = ResManager.loadKDString((String)"\u56de\u5355\u6570\u636e\u4e2d\u5df2\u5b58\u5728\u5bf9\u5e94\u7684\u4ea4\u6613\u660e\u7ec6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ReceiptMatchEdit_4", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
        String matchMessage = ResManager.loadKDString((String)"\u5f53\u524d\u7535\u5b50\u56de\u5355\u7684\u7535\u5b50\u56de\u5355\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5339\u914d\u3002", (String)"ReceiptMatchEdit_8", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
        ArrayList<String> transDetailIdList = new ArrayList<String>(16);
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        String tableName = EntityMetadataCache.getDataEntityType((String)"bei_transdetail").getAlias();
        long[] idArr = DB.genLongIds((String)tableName, (int)receipts.length);
        long count = 0L;
        for (int i = 0; i < receipts.length; ++i) {
            DynamicObject receipt = receipts[i];
            String receiptNo = receipt.getString("receiptno");
            DynamicObjectCollection objEntry = receipt.getDynamicObjectCollection("matchdetailentry");
            if ("frombank".equals(receipt.getString("datasource"))) {
                map.put(receipt.getString(BILLNO), downloadMessage);
                continue;
            }
            if (!objEntry.isEmpty()) {
                map.put(receipt.getString(BILLNO), regenMessage);
                continue;
            }
            if (EmptyUtil.isEmpty((String)receiptNo)) {
                map.put(receipt.getString(BILLNO), matchMessage);
                continue;
            }
            DynamicObject dynamicObject = receipt.getDynamicObject("company");
            DynamicObject accountbank = receipt.getDynamicObject("accountbank");
            Date date = receipt.getDate("bizdate");
            DynamicObject currency = receipt.getDynamicObject("currency");
            DynamicObject bank = receipt.getDynamicObject("bank");
            Object description = receipt.get("description");
            String bizrefno = receipt.getString("bizrefno");
            BigDecimal debitamount = receipt.getBigDecimal("debitamount");
            BigDecimal creditamount = receipt.getBigDecimal("creditamount");
            String oppunit = receipt.getString("oppunit");
            String oppbanknumber = receipt.getString("oppbanknumber");
            String oppbank = receipt.getString("oppbank");
            String detailid = receipt.getString("detailid");
            DynamicObject tran = BusinessDataServiceHelper.newDynamicObject((String)"bei_transdetail");
            String bankcheckflag = GenBankcheckCode.genCode();
            DynamicObjectCollection matchdetailentry = receipt.getDynamicObjectCollection("matchdetailentry");
            DynamicObject entry = matchdetailentry.addNew();
            entry.set("e_transdetailid", (Object)idArr[i]);
            entry.set("e_bankcheckflag", (Object)bankcheckflag);
            receipt.set("bankcheckflag", (Object)bankcheckflag);
            tran.set("id", (Object)idArr[i]);
            tran.set("company", dynamicObject == null ? null : dynamicObject.getPkValue());
            tran.set("accountbank", accountbank == null ? null : accountbank.getPkValue());
            tran.set("biztime", (Object)date);
            tran.set("bizdate", (Object)date);
            tran.set("currency", currency == null ? null : currency.getPkValue());
            tran.set("bank", bank == null ? null : bank.getPkValue());
            tran.set("bizrefno", (Object)bizrefno);
            tran.set("debitamount", (Object)debitamount);
            tran.set("creditamount", (Object)creditamount);
            tran.set("oppunit", (Object)oppunit);
            tran.set("oppbanknumber", (Object)oppbanknumber);
            tran.set("oppbank", (Object)oppbank);
            tran.set("detailid", (Object)detailid);
            tran.set("bankcheckflag", (Object)bankcheckflag);
            if (detailid == null || detailid.length() == 0 || " ".equals(detailid)) {
                tran.set("detailid", (Object)(idArr[i] + ""));
            }
            tran.set("uniqueseq", (Object)idArr[i]);
            tran.set("description", description);
            tran.set("sortno", (Object)(DateUtils.getCurrentTime().getTime() * 100000L + count++ % 100000L));
            tran.set("ismatchereceipt", (Object)"1");
            tran.set("bankcheckflag", (Object)bankcheckflag);
            tran.set("datasource", (Object)"receiptgen");
            tran.set("receiptno", (Object)receiptNo);
            HandMatchServiceHelper.setMatchReceiptEntry((DynamicObject)tran, (Long)receipt.getLong("id"), (String)receipt.getString("receiptno"));
            tran.set("modifytime", (Object)new Date());
            tran.set("createtime", (Object)new Date());
            tran.set("receredtype", (Object)"0");
            tran.set("creator", (Object)RequestContext.get().getCurrUserId());
            tran.set("modifier", (Object)RequestContext.get().getCurrUserId());
            tran.set("biztype", receipt.get("biztype"));
            tran.set("synonym", (Object)TransDetailHelper.updateSynonym((DynamicObject)tran, (DynamicObject)accountbank, (DynamicObject)dynamicObject));
            tran.set("opprelacct", (Object)TransDetailHelper.getOppRelAcct((String)oppbanknumber));
            String tranbillno = CodeRuleHelper.generateNumber((String)"bei_transdetail", (DynamicObject)tran, (String)(dynamicObject == null ? null : dynamicObject.getPkValue().toString()), null);
            tran.set(BILLNO, (Object)tranbillno);
            receipt.set("ismatch", (Object)"1");
            successReceipt.add(receipt);
            String newDetailId = tran.getString("detailid");
            transDetailIdList.add(newDetailId);
            countMap.put(newDetailId, countMap.getOrDefault(newDetailId, 0) + 1);
            tranList.add(tran);
        }
        ArrayList repeatList = new ArrayList();
        String existErr = "";
        Set<Object> detailIdSet = new HashSet();
        if (!tranList.isEmpty()) {
            for (Map.Entry entry : countMap.entrySet()) {
                if ((Integer)entry.getValue() <= 1) continue;
                repeatList.add(entry.getKey());
            }
            DynamicObject[] exist = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"detailid", (QFilter[])new QFilter("detailid", "in", transDetailIdList).toArray());
            if (exist.length > 0) {
                Set<Object> set = detailIdSet = Arrays.stream(exist).map(e -> e.getString("detailid")).collect(Collectors.toSet());
                successReceipt.removeIf(e -> finalDetailSet.contains(e.getString("detailid")));
                existErr = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u660e\u7ec6\u6d41\u6c34\u53f7\u201c%s\u201d\u4ea4\u6613\u6d41\u6c34\uff0c\u4e3a\u4fdd\u8bc1\u6570\u636e\u552f\u4e00\uff0c\u8be5\u6761\u6570\u636e\u751f\u6210\u4ea4\u6613\u6d41\u6c34\u5931\u8d25\u3002", (String)"ReceiptMatchEdit_10", (String)"tmc-bei-formplugin", (Object[])new Object[]{String.join((CharSequence)",", detailIdSet)});
            }
            HashSet hashSet = detailIdSet;
            tranList.removeIf(t -> repeatList.contains(t.getString("detailid")) || finalDetailIdSet.contains(t.getString("detailid")));
            List<DynamicObject> objList = Arrays.stream(receipts).collect(Collectors.toList());
            objList.removeIf(obj -> repeatList.contains(obj.getString("detailid")) || finalDetailIdSet.contains(obj.getString("detailid")));
            if (!tranList.isEmpty()) {
                SaveServiceHelper.save((IDataEntityType)((DynamicObject)tranList.get(0)).getDataEntityType(), (Object[])tranList.toArray());
                Object[] collectIds = tranList.stream().map(s -> s.getLong("id")).toArray();
                DynamicObject[] tranDetails = BusinessDataServiceHelper.load((Object[])collectIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bei_transdetail"));
                logger.info("\u7535\u5b50\u56de\u5355\u751f\u6210\u6d41\u6c34\uff1a\u81ea\u52a8\u751f\u6210\u4f59\u989d\u5f00\u59cb");
                SyncAutoBalanceHelper.checkAndAutoBalance((DynamicObject[])tranDetails, (boolean)false, null);
                logger.info("\u7535\u5b50\u56de\u5355\u751f\u6210\u6d41\u6c34\uff1a\u81ea\u52a8\u751f\u6210\u4f59\u989d\u7ed3\u675f");
            }
            if (!objList.isEmpty()) {
                SaveServiceHelper.save((IDataEntityType)receipts[0].getDataEntityType(), (Object[])objList.toArray(new DynamicObject[0]));
            }
        }
        successReceipt.removeIf(sr -> repeatList.contains(sr.getString("detailid")));
        this.removeReceipt(successReceipt.stream().map(sr -> (Long)sr.getPkValue()).collect(Collectors.toList()));
        StringBuilder context = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            context.append((String)entry.getKey());
            context.append(':');
            context.append((String)entry.getValue());
            context.append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)existErr)) {
            context.append(existErr);
        }
        this.refresh();
        if (context.length() > 0) {
            this.getView().showTipNotification(context.toString());
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u4ea4\u6613\u660e\u7ec6\u6570\u636e\u6210\u529f\u3002", (String)"ReceiptMatchEdit_17", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
    }

    protected List<Long> getSelectedIdList(ListSelectedRowCollection selectedRows) {
        ArrayList<Long> idList = new ArrayList<Long>(selectedRows.size());
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u56de\u5355\u6570\u636e\u3002", (String)"ReceiptMatchEdit_3", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        } else {
            for (ListSelectedRow listSelectedRowValue : selectedRows) {
                idList.add((Long)listSelectedRowValue.getPrimaryKeyValue());
            }
        }
        return idList;
    }

    private void refresh() {
        boolean isMulti = Boolean.parseBoolean(this.getPageCache().get(ISMULTI));
        BillList elecBillList = (BillList)this.getControl(isMulti ? "billlistap_elec_multi" : "billlistap_elec");
        BillList tranBillList = (BillList)this.getControl(isMulti ? "billlistap_tran_multi" : "billlistap_tran");
        Control transdetailtab = this.getControl("transdetailtab");
        boolean includematched = (Boolean)transdetailtab.getModel().getDataEntity().get(isMulti ? "includematched_multi" : "includematched");
        elecBillList.clearSelection();
        tranBillList.clearSelection();
        elecBillList.setFilter(this.getElecFilter());
        elecBillList.setOrderBy(ORDERBY_STR);
        tranBillList.setFilter(this.getTranDetailFilter(includematched));
        tranBillList.setOrderBy(ORDERBY_STR);
        elecBillList.refresh();
        tranBillList.refresh();
    }

    private void handCheck(List<Long> elecIdList, List<Long> tranIdList, boolean isFile) {
        Object[] eleIds = elecIdList.toArray(new Object[0]);
        Object[] tranIds = tranIdList.toArray(new Object[0]);
        DynamicObject[] elecObjs = BusinessDataServiceHelper.load((Object[])eleIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bei_elecreceipt"));
        DynamicObject[] tranObjs = BusinessDataServiceHelper.load((Object[])tranIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bei_transdetail"));
        if (elecObjs.length > 1 && tranObjs.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u540c\u65f6\u591a\u5f20\u7535\u5b50\u56de\u5355\u4e0e\u591a\u5f20\u4ea4\u6613\u660e\u7ec6\u8fdb\u884c\u5339\u914d\u3002", (String)"ReceiptMatchEdit_9", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> elecAccountList = new ArrayList<Long>(10);
        ArrayList<Long> elecCurrencyList = new ArrayList<Long>(10);
        Arrays.stream(elecObjs).forEach(receipt -> {
            elecAccountList.add(receipt.getDynamicObject("accountbank") == null ? 0L : receipt.getDynamicObject("accountbank").getLong("id"));
            elecCurrencyList.add(receipt.getDynamicObject("currency") == null ? 0L : receipt.getDynamicObject("currency").getLong("id"));
        });
        ArrayList<Long> tranAccountList = new ArrayList<Long>(10);
        ArrayList<Long> tranCurrencyList = new ArrayList<Long>(10);
        Arrays.stream(tranObjs).forEach(detail -> {
            tranAccountList.add(detail.getDynamicObject("accountbank") == null ? 0L : detail.getDynamicObject("accountbank").getLong("id"));
            tranCurrencyList.add(detail.getDynamicObject("currency") == null ? 0L : detail.getDynamicObject("currency").getLong("id"));
        });
        List elecDebitList = Arrays.stream(elecObjs).map(receipt -> receipt.getBigDecimal("debitamount")).collect(Collectors.toList());
        List elecCreditList = Arrays.stream(elecObjs).map(receipt -> receipt.getBigDecimal("creditamount")).collect(Collectors.toList());
        List tranDebitList = Arrays.stream(tranObjs).map(detail -> detail.getBigDecimal("debitamount")).collect(Collectors.toList());
        List tranCreditList = Arrays.stream(tranObjs).map(detail -> detail.getBigDecimal("creditamount")).collect(Collectors.toList());
        boolean accountCompareResult = this.dataCompare(elecAccountList, tranAccountList);
        boolean currencyCompareResult = this.dataCompare(elecCurrencyList, tranCurrencyList);
        BigDecimal elecDebitTotal = elecDebitList.stream().reduce(BigDecimal::add).isPresent() ? (BigDecimal)elecDebitList.stream().reduce(BigDecimal::add).get() : BigDecimal.ZERO;
        BigDecimal elecCreditTotal = elecCreditList.stream().reduce(BigDecimal::add).isPresent() ? (BigDecimal)elecCreditList.stream().reduce(BigDecimal::add).get() : BigDecimal.ZERO;
        BigDecimal tranDebitTotal = tranDebitList.stream().reduce(BigDecimal::add).isPresent() ? (BigDecimal)tranDebitList.stream().reduce(BigDecimal::add).get() : BigDecimal.ZERO;
        BigDecimal tranCreditTotal = tranCreditList.stream().reduce(BigDecimal::add).isPresent() ? (BigDecimal)tranCreditList.stream().reduce(BigDecimal::add).get() : BigDecimal.ZERO;
        MatchRelEnum matchRelEnum = null;
        if (accountCompareResult && currencyCompareResult && elecDebitTotal.compareTo(tranDebitTotal) == 0 && elecCreditTotal.compareTo(tranCreditTotal) == 0 || accountCompareResult && currencyCompareResult && elecDebitTotal.subtract(elecCreditTotal).compareTo(tranDebitTotal.subtract(tranCreditTotal)) == 0 || isFile && accountCompareResult && currencyCompareResult) {
            int n;
            Object debitamount;
            DynamicObject elecObj;
            if (tranIdList.size() == 1 && elecIdList.size() == 1) {
                elecObj = elecObjs[0];
                DynamicObject tranObj = tranObjs[0];
                elecObj.set("ismatch", (Object)Boolean.TRUE);
                elecObj.set("currency", (Object)(elecObj.getDynamicObject("currency") == null ? tranObj.getDynamicObject("currency") : elecObj.getDynamicObject("currency")));
                HandMatchServiceHelper.setMatchDetailEntry((DynamicObject)elecObj, (Long)((Long)tranObj.getPkValue()), (String)((String)tranObj.get("bankcheckflag")));
                debitamount = tranObj.getBigDecimal("debitamount");
                BigDecimal creditamount = tranObj.getBigDecimal("creditamount");
                if (isFile) {
                    elecObj.set("debitamount", debitamount);
                    elecObj.set("creditamount", (Object)creditamount);
                }
                if (((BigDecimal)debitamount).compareTo(BigDecimal.ZERO) > 0) {
                    elecObj.set("amount", debitamount);
                    elecObj.set("creditdebitflag", (Object)"1");
                } else if (((BigDecimal)debitamount).compareTo(BigDecimal.ZERO) < 0) {
                    elecObj.set("amount", (Object)((BigDecimal)debitamount).abs());
                    elecObj.set("creditdebitflag", (Object)"2");
                } else if (creditamount.compareTo(BigDecimal.ZERO) < 0) {
                    elecObj.set("amount", (Object)creditamount.abs());
                    elecObj.set("creditdebitflag", (Object)"1");
                } else {
                    elecObj.set("amount", (Object)creditamount);
                    elecObj.set("creditdebitflag", (Object)"2");
                }
                ElecMatchCheckHelper.setFieldValue((DynamicObject)tranObj, (DynamicObject)elecObj);
                elecObj.set("oppunit", (Object)(EmptyUtil.isEmpty((String)elecObj.getString("oppunit")) ? tranObj.getString("oppunit") : elecObj.getString("oppunit")));
                elecObj.set("oppbanknumber", (Object)(EmptyUtil.isEmpty((String)elecObj.getString("oppbanknumber")) ? tranObj.getString("oppbanknumber") : elecObj.getString("oppbanknumber")));
                elecObj.set("oppbank", (Object)(EmptyUtil.isEmpty((String)elecObj.getString("oppbank")) ? tranObj.getString("oppbank") : elecObj.getString("oppbank")));
                elecObj.set("description", (Object)(EmptyUtil.isEmpty((String)elecObj.getString("description")) || BeiHelper.isReceiptFileFromBank((DynamicObject)elecObj) ? tranObj.getString("description") : elecObj.getString("description")));
                elecObj.set("bankcheckflag", (Object)tranObj.getString("bankcheckflag"));
                elecObj.set("extdata", (Object)tranObj.getString("extdata"));
                tranObj.set("ismatchereceipt", (Object)Boolean.TRUE);
                elecObj.set("matchtype", (Object)ReceiptMatchTypeEnum.HANDLE.getValue());
                elecObj.set("matcher", (Object)RequestContext.get().getCurrUserId());
                elecObj.set("matchtime", (Object)new Date());
                tranObj.set("receiptno", (Object)elecObj.getString("receiptno"));
                HandMatchServiceHelper.setMatchReceiptEntry((DynamicObject)tranObj, (Long)elecObj.getLong("id"), (String)elecObj.getString("receiptno"));
                matchRelEnum = MatchRelEnum.ONE_TO_ONE;
            } else if (tranIdList.size() > 1) {
                elecObj = elecObjs[0];
                elecObj.set("ismatch", (Object)Boolean.TRUE);
                elecObj.set("matchtype", (Object)ReceiptMatchTypeEnum.HANDLE.getValue());
                elecObj.set("matcher", (Object)RequestContext.get().getCurrUserId());
                elecObj.set("matchtime", (Object)new Date());
                StringBuilder extData = new StringBuilder();
                debitamount = tranObjs;
                int creditamount = ((DynamicObject[])debitamount).length;
                for (n = 0; n < creditamount; ++n) {
                    DynamicObject detail2 = debitamount[n];
                    HandMatchServiceHelper.setMatchDetailEntry((DynamicObject)elecObj, (Long)detail2.getLong("id"), (String)detail2.getString("bankcheckflag"));
                    HandMatchServiceHelper.setMatchReceiptEntry((DynamicObject)detail2, (Long)elecObj.getLong("id"), (String)elecObj.getString("receiptno"));
                    List bankCheckFlags = Arrays.stream(tranObjs).map(trans -> trans.getString("bankcheckflag")).collect(Collectors.toList());
                    String bankCheckFlagJoin = String.join((CharSequence)",", bankCheckFlags);
                    if (EmptyUtil.isNoEmpty((String)bankCheckFlagJoin)) {
                        bankCheckFlagJoin = bankCheckFlagJoin.substring(0, Math.min(255, bankCheckFlagJoin.length()));
                    }
                    elecObj.set("bankcheckflag", (Object)bankCheckFlagJoin);
                    extData.append(detail2.getString("extdata")).append("\r\n");
                }
                elecObj.set("extdata", (Object)extData.toString());
                Arrays.stream(tranObjs).forEach(e -> {
                    e.set("ismatchereceipt", (Object)Boolean.TRUE);
                    e.set("receiptno", (Object)elecObj.getString("receiptno"));
                });
                if (isFile) {
                    if (tranDebitTotal.compareTo(tranCreditTotal) > 0) {
                        elecObj.set("amount", (Object)tranDebitTotal.subtract(tranCreditTotal));
                        elecObj.set("debitamount", (Object)tranDebitTotal.subtract(tranCreditTotal));
                        elecObj.set("creditdebitflag", (Object)"1");
                    } else {
                        elecObj.set("amount", (Object)tranDebitTotal.subtract(tranCreditTotal).abs());
                        elecObj.set("creditamount", (Object)tranDebitTotal.subtract(tranCreditTotal).abs());
                        elecObj.set("creditdebitflag", (Object)"2");
                    }
                } else {
                    debitamount = elecObj.getBigDecimal("debitamount");
                    BigDecimal creditamount2 = elecObj.getBigDecimal("creditamount");
                    if (((BigDecimal)debitamount).compareTo(BigDecimal.ZERO) > 0) {
                        elecObj.set("amount", debitamount);
                        elecObj.set("creditdebitflag", (Object)"1");
                    } else if (((BigDecimal)debitamount).compareTo(BigDecimal.ZERO) < 0) {
                        elecObj.set("amount", (Object)((BigDecimal)debitamount).abs());
                        elecObj.set("creditdebitflag", (Object)"2");
                    } else if (creditamount2.compareTo(BigDecimal.ZERO) < 0) {
                        elecObj.set("amount", (Object)creditamount2.abs());
                        elecObj.set("creditdebitflag", (Object)"1");
                    } else {
                        elecObj.set("amount", (Object)creditamount2);
                        elecObj.set("creditdebitflag", (Object)"2");
                    }
                }
                matchRelEnum = MatchRelEnum.ONE_TO_MANY;
            } else if (elecIdList.size() > 1) {
                DynamicObject tranObj = tranObjs[0];
                Arrays.stream(elecObjs).forEach(receipt -> {
                    receipt.set("currency", (Object)(receipt.getDynamicObject("currency") == null ? tranObj.getDynamicObject("currency") : receipt.getDynamicObject("currency")));
                    receipt.set("ismatch", (Object)Boolean.TRUE);
                    receipt.set("matchtype", (Object)ReceiptMatchTypeEnum.HANDLE.getValue());
                    receipt.set("matcher", (Object)RequestContext.get().getCurrUserId());
                    receipt.set("matchtime", (Object)new Date());
                    receipt.set("bankcheckflag", (Object)tranObj.getString("bankcheckflag"));
                    receipt.set("extdata", (Object)tranObj.getString("extdata"));
                    HandMatchServiceHelper.setMatchDetailEntry((DynamicObject)receipt, (Long)((Long)tranObj.getPkValue()), (String)tranObj.getString("bankcheckflag"));
                    if (!isFile) {
                        BigDecimal debitamount = receipt.getBigDecimal("debitamount");
                        BigDecimal creditamount = receipt.getBigDecimal("creditamount");
                        if (debitamount.compareTo(BigDecimal.ZERO) > 0) {
                            receipt.set("amount", (Object)debitamount);
                            receipt.set("creditdebitflag", (Object)"1");
                        } else if (debitamount.compareTo(BigDecimal.ZERO) < 0) {
                            receipt.set("amount", (Object)debitamount.abs());
                            receipt.set("creditdebitflag", (Object)"2");
                        } else if (creditamount.compareTo(BigDecimal.ZERO) < 0) {
                            receipt.set("amount", (Object)creditamount.abs());
                            receipt.set("creditdebitflag", (Object)"1");
                        } else {
                            receipt.set("amount", (Object)creditamount);
                            receipt.set("creditdebitflag", (Object)"2");
                        }
                    }
                    receipt.set("oppunit", (Object)(EmptyUtil.isEmpty((String)receipt.getString("oppunit")) ? tranObj.getString("oppunit") : receipt.getString("oppunit")));
                    receipt.set("oppbanknumber", (Object)(EmptyUtil.isEmpty((String)receipt.getString("oppbanknumber")) ? tranObj.getString("oppbanknumber") : receipt.getString("oppbanknumber")));
                    receipt.set("oppbank", (Object)(EmptyUtil.isEmpty((String)receipt.getString("oppbank")) ? tranObj.getString("oppbank") : receipt.getString("oppbank")));
                    receipt.set("description", (Object)(EmptyUtil.isEmpty((String)receipt.getString("description")) || BeiHelper.isReceiptFileFromBank((DynamicObject)receipt) ? tranObj.getString("description") : receipt.getString("description")));
                });
                tranObj.set("ismatchereceipt", (Object)Boolean.TRUE);
                List receiptNos = Arrays.stream(elecObjs).map(receipt -> receipt.getString("receiptno")).collect(Collectors.toList());
                String receiptNoJoin = String.join((CharSequence)";", receiptNos);
                if (EmptyUtil.isNoEmpty((String)receiptNoJoin)) {
                    receiptNoJoin = receiptNoJoin.substring(0, Math.min(255, receiptNoJoin.length()));
                }
                tranObj.set("receiptno", (Object)receiptNoJoin);
                DynamicObject[] dynamicObjectArray = elecObjs;
                n = dynamicObjectArray.length;
                for (int detail2 = 0; detail2 < n; ++detail2) {
                    DynamicObject elecObj2 = dynamicObjectArray[detail2];
                    HandMatchServiceHelper.setMatchReceiptEntry((DynamicObject)tranObj, (Long)elecObj2.getLong("id"), (String)elecObj2.getString("receiptno"));
                }
                matchRelEnum = MatchRelEnum.MANY_TO_ONE;
            }
            HashSet matchRelatedBizBillSet = new HashSet(elecObjs.length);
            ElecMatchDetailService elecMatchDetailService = new ElecMatchDetailService();
            for (DynamicObject tranObj : tranObjs) {
                Set billIds = elecMatchDetailService.checkBizBillGetReceipt("cas_paybill", "bei_transdetail", Long.valueOf(tranObj.getLong("id")), tranObj.getString("bankcheckflag"));
                if (billIds.isEmpty()) continue;
                matchRelatedBizBillSet.addAll(billIds);
            }
            if (!tranIdList.isEmpty() && !elecIdList.isEmpty()) {
                this.afterMatchFieldValueCover(matchRelEnum, Arrays.asList(elecObjs), Arrays.asList(tranObjs));
                SaveServiceHelper.save((DynamicObject[])elecObjs);
                SaveServiceHelper.save((DynamicObject[])tranObjs);
                this.removeReceiptAndTran(elecIdList, tranIdList);
                this.refresh();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5339\u914d\u6210\u529f\u3002", (String)"ReceiptMatchEdit_13", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                if (!matchRelatedBizBillSet.isEmpty()) {
                    ElecMatchCheckHelper.setBizBillGetReceipt((String)"cas_paybill", matchRelatedBizBillSet, (Boolean)false);
                }
            }
        } else if (isFile) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u7535\u5b50\u56de\u5355\u4e0e\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\u7684\u94f6\u884c\u8d26\u6237\u6216\u8005\u5e01\u79cd\u5b57\u6bb5\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u624b\u5de5\u5339\u914d\u3002", (String)"ReceiptMatchEdit_20", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u624b\u5de5\u5339\u914d\u5931\u8d25\uff0c\u539f\u56e0\u5982\u4e0b\uff1a1. \u6240\u9009\u7535\u5b50\u56de\u5355\u4e0e\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\u7684\u201c\u8d26\u6237\u201d\u3001\u201c\u5e01\u79cd\u201d\u3001\u201c\u6c47\u603b\u6536\u6b3e\u91d1\u989d\uff08\u591a\u7b14\uff09\u201d\u3001\u201c\u6c47\u603b\u4ed8\u6b3e\u91d1\u989d\uff08\u591a\u7b14\uff09\u201d\u7b49\u5b57\u6bb5\u4e2d\u5b58\u5728\u4e00\u4e2a\u6216\u591a\u4e2a\u7684\u503c\u4e0d\u4e00\u81f4\uff1b 2. \u6240\u9009\u7535\u5b50\u56de\u5355\u4e0e\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\u7684\u201c\u8d26\u6237\u201d\u3001\u201c\u5e01\u79cd\u201d\u3001\u201c\uff08\u6c47\u603b\u4ed8\u6b3e\u91d1\u989d\uff08\u591a\u7b14\uff09\uff0d\u6c47\u603b\u6536\u6b3e\u91d1\u989d\uff08\u591a\u7b14\uff09\u201d\u7b49\u5b57\u6bb5\u4e2d\u5b58\u5728\u4e00\u4e2a\u6216\u591a\u4e2a\u7684\u503c\u4e0d\u4e00\u81f4\uff1b", (String)"ReceiptMatchEdit_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
    }

    private void removeReceipt(List<Long> elecIdList) {
        if (!elecIdList.isEmpty()) {
            String ids = this.getPageCache().get(IDS);
            List elecIds = (List)JSON.parseObject((String)ids, List.class);
            HashSet allElec = new HashSet(elecIds);
            HashSet<Long> removeList = new HashSet<Long>(elecIdList);
            allElec.removeAll(removeList);
            ArrayList resultList = new ArrayList(allElec.size());
            resultList.addAll(allElec);
            String elecIdsJson = JSON.toJSONString(resultList);
            this.getPageCache().put(IDS, elecIdsJson);
        }
    }

    private boolean dataCompare(List<Long> elecDatas, List<Long> tranDatas) {
        for (Long elecData : elecDatas) {
            for (Long tranData : tranDatas) {
                if (elecData.compareTo(tranData) == 0) continue;
                return false;
            }
        }
        return true;
    }

    private void removeReceiptAndTran(List<Long> elecIdList, List<Long> tranIdList) {
        if (elecIdList != null && !elecIdList.isEmpty()) {
            String ids = this.getPageCache().get(IDS);
            List elecIds = (List)JSON.parseObject((String)ids, List.class);
            elecIdList.forEach(elecIds::remove);
            String elecIdsJson = JSON.toJSONString((Object)elecIds);
            this.getPageCache().put(IDS, elecIdsJson);
        }
        if (tranIdList != null) {
            String detailids = this.getPageCache().get(DETAILIDS);
            Set detailidSet = (Set)JSON.parseObject((String)detailids, Set.class);
            if (EmptyUtil.isNoEmpty((Object)detailidSet)) {
                tranIdList.forEach(detailidSet::remove);
                String detailidJson = JSON.toJSONString((Object)detailidSet);
                this.getPageCache().put(DETAILIDS, detailidJson);
            } else {
                this.getPageCache().put(DETAILIDS, null);
            }
        }
    }

    private QFilter getElecFilter() {
        String ids = this.getPageCache().get(IDS);
        List idsSet = (List)JSON.parseObject((String)ids, List.class);
        return new QFilter("id", "in", (Object)idsSet);
    }

    private QFilter getElecMultiFilter() {
        BillList elecBillList = (BillList)this.getControl("billlistap_elec_multi");
        ListSelectedRowCollection elecSelect = elecBillList.getSelectedRows();
        Object receiptPk = elecSelect.get(0).getPrimaryKeyValue();
        DynamicObject receipt = QueryServiceHelper.queryOne((String)"bei_elecreceipt", (String)"id, accountbank, currency", (QFilter[])new QFilter[]{new QFilter("id", "in", receiptPk)});
        QFilter filter = this.getElecFilter();
        filter.and("accountbank", "=", (Object)receipt.getLong("accountbank"));
        filter.and("currency", "=", (Object)receipt.getLong("currency"));
        return filter;
    }

    private QFilter getTranDetailFilter(boolean includematched) {
        String detailids = this.getPageCache().get(DETAILIDS);
        Set detailidSet = (Set)JSON.parseObject((String)detailids, Set.class);
        return includematched ? new QFilter("id", "in", (Object)detailidSet) : new QFilter("id", "in", (Object)detailidSet).and(new QFilter("ismatchereceipt", "=", (Object)"0"));
    }

    private QFilter getDetailListFilter(QFilter receiptFilter) {
        boolean isMulti = Boolean.parseBoolean(this.getPageCache().get(ISMULTI));
        DynamicObjectCollection selectedElecReceipt = QueryServiceHelper.query((String)"bei_elecreceipt", (String)"id,debitamount,creditamount,bizdate,accountbank.id", (QFilter[])new QFilter[]{receiptFilter});
        logger.info("selectedElecReceipt.size() : " + selectedElecReceipt.size() + " pkValues : " + selectedElecReceipt.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet()));
        Control transdetailtab = this.getControl(isMulti ? "transdetailtab_multi" : "transdetailtab");
        boolean moneyexactmatch = (Boolean)transdetailtab.getModel().getDataEntity().get(isMulti ? "moneyexactmatch_multi" : "moneyexactmatch");
        boolean bizdateexactmatch = (Boolean)transdetailtab.getModel().getDataEntity().get(isMulti ? "bizdateexactmatch_multi" : "bizdateexactmatch");
        boolean includematched = (Boolean)transdetailtab.getModel().getDataEntity().get(isMulti ? "includematched_multi" : "includematched");
        boolean includelessbizmoney = (Boolean)transdetailtab.getModel().getDataEntity().get(isMulti ? "includelessbizmoney_multi" : "includelessbizmoney");
        QFilter transDetailQfilter = null;
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)selectedElecReceipt)) {
            Set accountSet = selectedElecReceipt.stream().map(receipt -> receipt.get("accountbank.id")).collect(Collectors.toSet());
            this.getPageCache().put("cacheBankId", JSON.toJSONString(accountSet));
            Map<Long, List<DynamicObject>> accountGroup = selectedElecReceipt.stream().collect(Collectors.groupingBy(receipt -> (Long)receipt.get("accountbank.id")));
            HashMap bizDateMap = new HashMap(selectedElecReceipt.size());
            HashMap debitAmountMap = new HashMap(selectedElecReceipt.size());
            HashMap creditAmountMap = new HashMap(selectedElecReceipt.size());
            for (Map.Entry<Long, List<DynamicObject>> receiptEntry : accountGroup.entrySet()) {
                Long accountId = receiptEntry.getKey();
                QFilter subFilter = new QFilter("accountbank", "=", (Object)receiptEntry.getKey());
                List<DynamicObject> receipts = receiptEntry.getValue();
                Set bizDateSet = receipts.stream().map(receipt -> DateUtils.formatString((Date)((Date)receipt.get("bizdate")), (String)"yyyy-MM-dd")).collect(Collectors.toSet());
                bizDateMap.put(accountId, bizDateSet);
                List debitAmountList = receipts.stream().map(receipt -> receipt.getBigDecimal("debitamount")).collect(Collectors.toList());
                debitAmountMap.put(accountId, debitAmountList);
                List creditAmountList = receipts.stream().map(receipt -> receipt.getBigDecimal("creditamount")).collect(Collectors.toList());
                creditAmountMap.put(accountId, creditAmountList);
                BigDecimal sumDebitAmt = BigDecimal.ZERO;
                BigDecimal sumCreditAmt = BigDecimal.ZERO;
                if (receipts.size() > 1) {
                    sumDebitAmt = debitAmountList.stream().reduce(BigDecimal::add).isPresent() ? (BigDecimal)debitAmountList.stream().reduce(BigDecimal::add).get() : sumDebitAmt;
                    BigDecimal bigDecimal = sumCreditAmt = creditAmountList.stream().reduce(BigDecimal::add).isPresent() ? (BigDecimal)creditAmountList.stream().reduce(BigDecimal::add).get() : sumCreditAmt;
                }
                if (bizdateexactmatch) {
                    subFilter.and(new QFilter("bizdate", "in", bizDateSet.stream().map(date -> DateUtils.stringToDate((String)date, (String)"yyyy-MM-dd")).collect(Collectors.toSet())));
                }
                if (moneyexactmatch || includelessbizmoney) {
                    QFilter moneyFilter = null;
                    QFilter lessFilter = null;
                    for (DynamicObject receipt2 : receipts) {
                        BigDecimal debitamount = receipt2.getBigDecimal("debitamount");
                        BigDecimal creditamount = receipt2.getBigDecimal("creditamount");
                        if (moneyexactmatch) {
                            moneyFilter = this.getMoneyFilter(debitamount, creditamount, moneyFilter, false);
                        }
                        if (!includelessbizmoney) continue;
                        lessFilter = this.getLessFilter(debitamount, creditamount, lessFilter);
                    }
                    if (moneyFilter == null) {
                        if (lessFilter != null) {
                            subFilter.and(lessFilter);
                        }
                    } else {
                        if (receipts.size() > 1) {
                            moneyFilter = this.getMoneyFilter(sumDebitAmt, sumCreditAmt, moneyFilter, true);
                        }
                        if (lessFilter != null) {
                            lessFilter.or(moneyFilter);
                            subFilter.and(lessFilter);
                        } else {
                            subFilter.and(moneyFilter);
                        }
                    }
                }
                transDetailQfilter = transDetailQfilter == null ? subFilter : transDetailQfilter.or(subFilter);
            }
            if (transDetailQfilter == null) {
                transDetailQfilter = new QFilter("receiptno", "is not null", null);
            }
            if (!includematched) {
                QFilter matchedFilter = new QFilter("ismatchereceipt", "=", (Object)"0");
                transDetailQfilter.and(matchedFilter);
            }
            this.getPageCache().put("cacheBizDate", JSON.toJSONString(bizDateMap));
            this.getPageCache().put("cacheDebitamount", JSON.toJSONString(debitAmountMap));
            this.getPageCache().put("cacheCreditamount", JSON.toJSONString(creditAmountMap));
        }
        return transDetailQfilter;
    }

    private void setTranDetailFilter(DynamicObjectCollection detailObjs) {
        if (detailObjs.isEmpty()) {
            this.getPageCache().put(DETAILIDS, null);
        } else {
            HashSet<Long> set = new HashSet<Long>(10);
            for (DynamicObject obj : detailObjs) {
                set.add((Long)obj.get("id"));
            }
            String detailsJson = JSON.toJSONString(set);
            this.getPageCache().put(DETAILIDS, detailsJson);
        }
    }

    private List<Long> getBillIdFromRow(ListSelectedRowCollection rows) {
        return rows.stream().map(e -> (Long)e.getPrimaryKeyValue()).collect(Collectors.toList());
    }

    private QFilter getMoneyFilter(BigDecimal debitAmt, BigDecimal creditAmt, QFilter moneyFilter, boolean isSum) {
        QFilter subMoneyFilter = null;
        if (isSum) {
            if (debitAmt.compareTo(BigDecimal.ZERO) == 0) {
                subMoneyFilter = new QFilter("creditamount", "=", (Object)creditAmt).or("debitamount", "=", (Object)BigDecimal.ZERO.subtract(creditAmt));
            } else if (creditAmt.compareTo(BigDecimal.ZERO) == 0) {
                subMoneyFilter = new QFilter("debitamount", "=", (Object)debitAmt).or("creditamount", "=", (Object)BigDecimal.ZERO.subtract(debitAmt));
            } else {
                BigDecimal payAmt = debitAmt.subtract(creditAmt);
                if (payAmt.compareTo(BigDecimal.ZERO) != 0) {
                    subMoneyFilter = new QFilter("debitamount", "=", (Object)payAmt).or(new QFilter("creditamount", "=", (Object)BigDecimal.ZERO.subtract(payAmt)));
                }
            }
            return moneyFilter.or(subMoneyFilter);
        }
        if (debitAmt.signum() == -1) {
            BigDecimal bizmoney = debitAmt.abs();
            subMoneyFilter = new QFilter("creditamount", "=", (Object)bizmoney).or(new QFilter("debitamount", "=", (Object)debitAmt));
        } else if (creditAmt.signum() == -1) {
            BigDecimal bizmoney = creditAmt.abs();
            subMoneyFilter = new QFilter("debitamount", "=", (Object)bizmoney).or(new QFilter("creditamount", "=", (Object)creditAmt));
        } else if (debitAmt.signum() == 1) {
            BigDecimal bizmoney = debitAmt;
            subMoneyFilter = new QFilter("debitamount", "=", (Object)bizmoney).or(new QFilter("creditamount", "=", (Object)debitAmt.negate()));
        } else {
            BigDecimal bizmoney = creditAmt;
            subMoneyFilter = new QFilter("creditamount", "=", (Object)bizmoney).or(new QFilter("debitamount", "=", (Object)creditAmt.negate()));
        }
        moneyFilter = moneyFilter == null ? subMoneyFilter : moneyFilter.or(subMoneyFilter);
        return moneyFilter;
    }

    private QFilter getLessFilter(BigDecimal debitAmt, BigDecimal creditAmt, QFilter lessFilter) {
        QFilter subLessFilter;
        if (debitAmt.compareTo(BigDecimal.ZERO) == 0 && creditAmt.compareTo(BigDecimal.ZERO) == 0) {
            return lessFilter;
        }
        if (debitAmt.signum() == -1) {
            BigDecimal bizmoney = debitAmt.abs();
            subLessFilter = new QFilter("creditamount", "<", (Object)bizmoney).and(new QFilter("creditamount", ">", (Object)BigDecimal.ZERO));
            subLessFilter.or(new QFilter("debitamount", "<", (Object)BigDecimal.ZERO).and(new QFilter("debitamount", ">", (Object)debitAmt)));
        } else if (creditAmt.signum() == -1) {
            BigDecimal bizmoney = creditAmt.abs();
            subLessFilter = new QFilter("debitamount", "<", (Object)bizmoney).and(new QFilter("debitamount", ">", (Object)BigDecimal.ZERO));
            subLessFilter.or(new QFilter("creditamount", "<", (Object)BigDecimal.ZERO).and(new QFilter("creditamount", ">", (Object)creditAmt)));
        } else if (debitAmt.signum() == 1) {
            BigDecimal bizmoney = debitAmt;
            subLessFilter = new QFilter("debitamount", "<", (Object)bizmoney).and(new QFilter("debitamount", ">", (Object)BigDecimal.ZERO));
            subLessFilter.or(new QFilter("creditamount", "<", (Object)BigDecimal.ZERO).and(new QFilter("creditamount", ">", (Object)debitAmt.negate())));
        } else {
            BigDecimal bizmoney = creditAmt;
            subLessFilter = new QFilter("creditamount", "<", (Object)bizmoney).and(new QFilter("creditamount", ">", (Object)BigDecimal.ZERO));
            subLessFilter.or(new QFilter("debitamount", "<", (Object)BigDecimal.ZERO).and(new QFilter("debitamount", ">", (Object)creditAmt.negate())));
        }
        lessFilter = lessFilter == null ? subLessFilter : lessFilter.or(subLessFilter);
        return lessFilter;
    }

    private List<Long> checkHandMatchElecFile(List<Long> elecIds) {
        ArrayList<Long> elecFileIds = new ArrayList<Long>(10);
        DynamicObjectCollection receipts = QueryServiceHelper.query((String)"bei_elecreceipt", (String)"id, fileflag, debitamount, creditamount", (QFilter[])new QFilter[]{new QFilter("id", "in", elecIds)});
        elecFileIds.addAll(receipts.stream().filter(receipt -> receipt.getBoolean("fileflag") && receipt.getBigDecimal("debitamount").compareTo(BigDecimal.ZERO) == 0 && receipt.getBigDecimal("creditamount").compareTo(BigDecimal.ZERO) == 0).map(receipt -> receipt.getLong("id")).collect(Collectors.toList()));
        return elecFileIds;
    }

    private void showHandMatchFileView(List<Long> elecFileIds, List<Long> transIds) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bei_receiptmatch_file");
        formShowParameter.getCustomParams().put("elecFileIds", elecFileIds);
        formShowParameter.getCustomParams().put("transIds", transIds);
        formShowParameter.getCustomParams().put("isShowList", transIds.size() > 1);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "handMatchFileCallBack"));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void openForm(String pdfUrl) {
        IFormView mainView = this.getView().getMainView();
        if (mainView == null) {
            this.getView().openUrl(pdfUrl);
        } else {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bos_printpreview");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("1350");
            styleCss.setHeight("810");
            formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
            formShowParameter.setCustomParam("src", (Object)pdfUrl);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u8054\u67e5\u56de\u5355", (String)"ReceiptMatchEdit_7", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            this.getView().getParentView().showForm(formShowParameter);
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private void checkBillExist() {
        boolean isMulti = Boolean.parseBoolean(this.getPageCache().get(ISMULTI));
        BillList elecBillList = (BillList)this.getControl(isMulti ? "billlistap_elec_multi" : "billlistap_elec");
        BillList tranBillList = (BillList)this.getControl(isMulti ? "billlistap_tran_multi" : "billlistap_tran");
        ListSelectedRowCollection elecSelect = elecBillList.getSelectedRows();
        ListSelectedRowCollection tranSelect = tranBillList.getSelectedRows();
        if (elecSelect.isEmpty() || tranSelect.isEmpty()) {
            return;
        }
        DynamicObjectCollection receipts = QueryServiceHelper.query((String)"bei_elecreceipt", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)elecSelect.getPrimaryKeyValues())});
        DynamicObjectCollection details = QueryServiceHelper.query((String)"bei_transdetail", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)tranSelect.getPrimaryKeyValues())});
        if (receipts == null || receipts.isEmpty() || details == null || details.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7535\u5b50\u56de\u5355\u6216\u4ea4\u6613\u660e\u7ec6\u6570\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReceiptMatchEdit_21", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
    }

    private void afterMatchFieldValueCover(MatchRelEnum matchRelEnum, List<DynamicObject> receipts, List<DynamicObject> details) {
        PluginProxy pluginProxy = PluginProxy.create(IReceiptMatchTransDetail.class, (String)"kd.sdk.tmc.bei.extpoint.receipt.IReceiptMatchTransDetail");
        pluginProxy.callReplace(p -> {
            p.afterMatchFieldValueCover(matchRelEnum.getValue(), receipts, details);
            return new Object();
        });
    }
}

