/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.workbench;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.tmc.bei.business.helper.AutoMatchHelper;
import kd.tmc.bei.business.helper.DetailManualMatchHelper;
import kd.tmc.bei.business.service.factory.WorkBenchServiceFactory;
import kd.tmc.bei.common.enums.TabRecordStatusEnum;
import kd.tmc.bei.common.helper.OperateServiceHelper;
import kd.tmc.fbp.common.compare.StopWatchWithSummary;
import kd.tmc.fbp.common.enums.MatchBizTypeEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RecWorkbenchList
extends AbstractListPlugin {
    private static final Log LOGGER = LogFactory.getLog(RecWorkbenchList.class);
    private static final String UP_BILL = "upbill";

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("recedbillnumber".equals(fieldName) || "e_recedbillnumber".equals(fieldName)) {
            args.setCancel(true);
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
            if (selectedRow == null || selectedRow.getPrimaryKeyValue() == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RecWorkbenchList_43", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject detail = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)"bei_transdetail_cas", (String)"id,claimnoticebillno,recedbillnumber,recedbillentry,e_recedbilltype,e_recedbillid");
            String claimBillNo = detail.getString("claimnoticebillno");
            if (EmptyUtil.isEmpty((String)claimBillNo)) {
                DynamicObject recedbill = detail.getDynamicObjectCollection("recedbillentry").stream().filter(o -> selectedRow.getEntryPrimaryKeyValue().equals(o.getPkValue())).findFirst().orElse(null);
                if (recedbill != null) {
                    this.viewBill(recedbill.getString("e_recedbilltype"), recedbill.getLong("e_recedbillid"));
                } else {
                    DynamicObject recBill = TmcBotpHelper.getTargetBill((String)"bei_transdetail_cas", (Object)detail.getPkValue(), (String)"cas_recbill");
                    if (recBill != null) {
                        this.viewBill("cas_recbill", recBill.getPkValue());
                    } else {
                        OperateOption option = OperateOption.create();
                        option.setVariableValue("botp_track_edit_status", "true");
                        this.getView().invokeOperation("trackdown", option);
                    }
                }
            } else {
                Long recedbillid = detail.getDynamicObjectCollection("recedbillentry").stream().filter(o -> selectedRow.getEntryPrimaryKeyValue().equals(o.getPkValue())).filter(o -> "cas_recbill".equals(o.getString("e_recedbilltype"))).map(o -> o.getLong("e_recedbillid")).findFirst().orElse(0L);
                if (QueryServiceHelper.exists((String)"cas_recbill", (Object)recedbillid)) {
                    this.viewBill("cas_recbill", recedbillid);
                }
            }
        }
    }

    private void viewBill(String formId, Object pkValue) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setFormId(formId);
        showParameter.setPkId(pkValue);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        FormOperate operate = (FormOperate)args.getSource();
        operate.getOption().setVariableValue("batchop_batchsize", String.valueOf(0));
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if ("exportlistbyselectfields".equals(operateKey) && selectedRows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RecWorkbenchList_14", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if ("manualmatch".equals(operateKey)) {
            DetailManualMatchHelper.verifySameOrg((ListSelectedRowCollection)selectedRows, (String)"bei_intelrec", (IFormView)this.getView(), (BeforeDoOperationEventArgs)args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if (operationResult != null && operationResult.isSuccess()) {
            String thisOpnumber = DB.genGlobalLongId() + "";
            ListShowParameter showPara = new ListShowParameter();
            switch (operateKey) {
                case "dorule": {
                    this.ruleEnter(selectedRows, thisOpnumber);
                    break;
                }
                case "handmerge": 
                case "dohand": {
                    if (selectedRows.isEmpty()) {
                        return;
                    }
                    Object recordbotn = this.getModel().getDataEntity().get("recordbotn");
                    if (TabRecordStatusEnum.ALRECORD.getValue().equals(recordbotn)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u786e\u8ba4\u201d\u72b6\u6001\u7684\u4ea4\u6613\u660e\u7ec6\u624d\u80fd\u8fdb\u884c\u751f\u5355\u64cd\u4f5c\u3002", (String)"RecWorkbenchList_7", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    Object[] selectedPks = selectedRows.getPrimaryKeyValues();
                    QFilter qFilter = new QFilter("id", "in", (Object)selectedPks);
                    DynamicObjectCollection transDetails = QueryServiceHelper.query((String)"bei_intelrec", (String)"id,claimnoticebillno,billno,company,oppbanknumber,accountbank,kdretflag", (QFilter[])qFilter.toArray());
                    if (transDetails != null && transDetails.size() > 0) {
                        for (DynamicObject transDetail : transDetails) {
                            if (!EmptyUtil.isEmpty((String)transDetail.getString("claimnoticebillno"))) {
                                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u201c%s\u201d\u751f\u5355\u5931\u8d25\uff0c\u8be5\u4ea4\u6613\u660e\u7ec6\u5df2\u8fdb\u884c\u901a\u77e5\u8ba4\u9886\uff0c\u8bf7\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u518d\u751f\u5355\u3002", (String)"PassivePayWorkbenchList_34", (String)"tmc-bei-formplugin", (Object[])new Object[0]), transDetail.getString("billno")));
                                return;
                            }
                            if (!EmptyUtil.isNotEmpty((CharSequence)transDetail.getString("kdretflag"))) continue;
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\uff08\u7f16\u53f7\uff1a%1$s\uff09\u64cd\u4f5c\u5931\u8d25\u3002\u8be5\u4ea4\u6613\u660e\u7ec6\u6709\u201cKD\u6807\u8bc6\u201d\u4fe1\u606f\uff0c\u4e3a\u94f6\u4f01\u4ed8\u6b3e\u7684\u4ea4\u6613\u660e\u7ec6\uff0c\u5e94\u7531\u7cfb\u7edf\u8fdb\u884c\u81ea\u52a8\u5339\u914d\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6309\u89c4\u5219\u751f\u5355\u3001\u624b\u5de5\u751f\u5355\u3001\u76f4\u63a5\u6807\u8bb0\u5df2\u786e\u8ba4\u3001\u6807\u8bb0\u4e3a\u65e0\u9700\u786e\u8ba4\u3001\u901a\u77e5\u8ba4\u9886\u7b49\u64cd\u4f5c\u3002", (String)"RecWorkbenchList_46", (String)"tmc-bei-formplugin", (Object[])new Object[]{transDetail.getString("billno")}));
                            return;
                        }
                    }
                    String closeCallBackId = "dohand".equals(operateKey) ? "cas_recbizinfo" : "cas_recbizinfomerge";
                    Long companyId = null;
                    String oppBankNumber = null;
                    Long accountBankId = null;
                    if (transDetails != null && transDetails.size() > 0) {
                        Set accountBankIdSet;
                        Set oppBankNumberSet;
                        List companyIds = transDetails.stream().map(t -> t.getLong("company")).distinct().collect(Collectors.toList());
                        if (companyIds.size() == 1) {
                            companyId = (Long)companyIds.get(0);
                        }
                        if (EmptyUtil.isNoEmpty(oppBankNumberSet = transDetails.stream().filter(t -> EmptyUtil.isNoEmpty((String)t.getString("oppbanknumber"))).map(t -> t.getString("oppbanknumber")).collect(Collectors.toSet()))) {
                            String string = oppBankNumber = oppBankNumberSet.size() == 1 ? (String)oppBankNumberSet.iterator().next() : "";
                        }
                        if (EmptyUtil.isNoEmpty(accountBankIdSet = transDetails.stream().filter(t -> EmptyUtil.isNoEmpty((Long)t.getLong("accountbank"))).map(t -> t.getLong("accountbank")).collect(Collectors.toSet()))) {
                            accountBankId = accountBankIdSet.size() == 1 ? (Long)accountBankIdSet.iterator().next() : Long.valueOf(0L);
                        }
                    }
                    FormShowParameter fsp = new FormShowParameter();
                    fsp.setCustomParam("call", (Object)closeCallBackId);
                    fsp.setCustomParam("recorg", companyId);
                    fsp.setCustomParam("multiOppBankNumber", (Object)StringUtils.equals(oppBankNumber, (CharSequence)""));
                    fsp.setCustomParam("oppBankNumber", oppBankNumber);
                    fsp.setCustomParam("multiAccountBankId", (Object)(accountBankId != null && accountBankId == 0L ? 1 : 0));
                    fsp.setCustomParam("accountBankId", (Object)accountBankId);
                    fsp.setFormId("cas_recbizinfo");
                    CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, closeCallBackId);
                    fsp.setCloseCallBack(callBack);
                    fsp.getOpenStyle().setShowType(ShowType.Modal);
                    this.getView().showForm(fsp);
                    break;
                }
                case "automatch": {
                    this.matchEnter(selectedRows, thisOpnumber);
                    break;
                }
                case "cancelmatch": {
                    this.cancelMatch();
                    break;
                }
                case "matchrulesetting": {
                    showPara.setBillFormId("cas_smartmatch");
                    showPara.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)showPara);
                    break;
                }
                case "rulesetting": {
                    showPara.setBillFormId("cas_recpayrule");
                    showPara.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)showPara);
                    break;
                }
                case "marknoconfirm": 
                case "recered": 
                case "cancelmark": 
                case "matchrule": {
                    this.refresh();
                    break;
                }
                case "cancelgen": {
                    this.refreshList();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u751f\u5355\u6210\u529f\u3002", (String)"RecWorkbenchList_11", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                }
            }
        } else {
            switch (operateKey) {
                case "cancelmatch": 
                case "cancelrecered": 
                case "dorule": 
                case "matchrule": {
                    this.refresh();
                }
            }
        }
        if ("manualmatch".equals(operateKey)) {
            DetailManualMatchHelper.bizBillMatchDetail((IFormView)this.getView(), (AfterDoOperationEventArgs)args, (ListSelectedRowCollection)selectedRows, (IFormPlugin)this, (String)list.getEntityId(), (String)"company,accountbank,currency");
        }
    }

    public void showForm(String formId, String callBackBtn) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setCustomParam("call", (Object)callBackBtn);
        fsp.setFormId(formId);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, callBackBtn);
        fsp.setCloseCallBack(callBack);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(fsp);
    }

    private void refreshList() {
        this.getView().invokeOperation("refresh");
    }

    private void confirmEnter(ListSelectedRowCollection selectedRows, String thisOpnumber) {
    }

    private void cancelMatch() {
        this.refresh();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5339\u914d\u6210\u529f\u3002", (String)"RecWorkbenchList_16", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
    }

    protected void refresh() {
        this.getView().invokeOperation("refresh");
    }

    private void matchEnter(ListSelectedRowCollection selectedRows, String thisOpnumber) {
        if (selectedRows.isEmpty()) {
            return;
        }
        Object recordbotn = this.getModel().getDataEntity().get("recordbotn");
        if (TabRecordStatusEnum.ALRECORD.getValue().equals(recordbotn)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u786e\u8ba4\u201d\u72b6\u6001\u7684\u4ea4\u6613\u660e\u7ec6\u624d\u80fd\u8fdb\u884c\u751f\u5355\u64cd\u4f5c\u3002", (String)"RecWorkbenchList_17", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection transDetails = QueryServiceHelper.query((String)"bei_intelrec", (String)"id,claimnoticebillno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues())});
        if (transDetails != null && transDetails.size() > 0) {
            for (DynamicObject transDetail : transDetails) {
                if (EmptyUtil.isEmpty((String)transDetail.getString("claimnoticebillno"))) continue;
                selectedRows.removeIf(row -> row.getPrimaryKeyValue().equals(transDetail.get("id")));
            }
        }
        if (EmptyUtil.isEmpty((Collection)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6240\u6709\u6570\u636e\u90fd\u5df2\u8fdb\u884c\u901a\u77e5\u8ba4\u9886\uff0c\u8bf7\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u540e\u518d\u6267\u884c\u64cd\u4f5c\u3002", (String)"RecWorkbenchList_41", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] selectedPks = new Object[selectedRows.size()];
        for (int i = 0; i < selectedRows.size(); ++i) {
            ListSelectedRow row2 = selectedRows.get(i);
            selectedPks[i] = row2.getPrimaryKeyValue();
        }
        boolean isHasMatch = AutoMatchHelper.autoMatch((ListSelectedRowCollection)selectedRows, Arrays.asList(MatchBizTypeEnum.TRANSUP, MatchBizTypeEnum.REC, MatchBizTypeEnum.PAY, MatchBizTypeEnum.EXCHANGE), (String)thisOpnumber, (String)"rec");
        if (!isHasMatch) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u81ea\u52a8\u5339\u914d\u7ed3\u679c\u3002\u53ef\u80fd\u662f\u672a\u914d\u7f6e\u81ea\u52a8\u5339\u914d\u89c4\u5219\uff0c\u6216\u6839\u636e\u89c4\u5219\u672a\u5339\u914d\u5230\u4e1a\u52a1\u5355\u636e\u3002", (String)"RecWorkbenchList_18", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("cas_automatchresult");
        fsp.setCustomParam("thisOpnumber", (Object)thisOpnumber);
        fsp.setCustomParam("selectedSize", (Object)(selectedRows.size() + ""));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "cas_automatchresult");
        fsp.setCloseCallBack(callBack);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(fsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ruleEnter(ListSelectedRowCollection selectedRows, String thisOpnumber) {
        if (selectedRows.isEmpty()) {
            return;
        }
        Object recordbotn = this.getModel().getDataEntity().get("recordbotn");
        if (TabRecordStatusEnum.ALRECORD.getValue().equals(recordbotn)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u786e\u8ba4\u201d\u72b6\u6001\u7684\u4ea4\u6613\u660e\u7ec6\u624d\u80fd\u8fdb\u884c\u6309\u89c4\u5219\u751f\u5355\u64cd\u4f5c\u3002", (String)"RecWorkbenchList_19", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        OperationResult result = new OperationResult();
        int selectedRowCount = selectedRows.getPrimaryKeyValues().length;
        Object[] selectedPks = selectedRows.getPrimaryKeyValues();
        int selectCount = selectedRows.size();
        DynamicObject[] transDetails = BusinessDataServiceHelper.load((Object[])selectedPks, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bei_intelrec"));
        if (transDetails != null && transDetails.length > 0) {
            for (DynamicObject transDetail : transDetails) {
                if (!EmptyUtil.isEmpty((String)transDetail.getString("claimnoticebillno"))) {
                    result.addErrorInfo(this.getOperateErrorInfo(transDetail.getPkValue(), String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u201c%s\u201d\u751f\u5355\u5931\u8d25\uff0c\u8be5\u4ea4\u6613\u660e\u7ec6\u5df2\u8fdb\u884c\u901a\u77e5\u8ba4\u9886\uff0c\u8bf7\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u518d\u751f\u5355\u3002", (String)"RecWorkbenchList_38", (String)"tmc-bei-formplugin", (Object[])new Object[0]), transDetail.getString("billno"))));
                    selectedRows.removeIf(row -> row.getPrimaryKeyValue().equals(transDetail.getPkValue()));
                }
                if (!EmptyUtil.isNotEmpty((CharSequence)transDetail.getString("kdretflag"))) continue;
                result.addErrorInfo(this.getOperateErrorInfo(transDetail.getPkValue(), ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\uff08\u7f16\u53f7\uff1a%1$s\uff09\u64cd\u4f5c\u5931\u8d25\u3002\u8be5\u4ea4\u6613\u660e\u7ec6\u6709\u201cKD\u6807\u8bc6\u201d\u4fe1\u606f\uff0c\u4e3a\u94f6\u4f01\u4ed8\u6b3e\u7684\u4ea4\u6613\u660e\u7ec6\uff0c\u5e94\u7531\u7cfb\u7edf\u8fdb\u884c\u81ea\u52a8\u5339\u914d\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6309\u89c4\u5219\u751f\u5355\u3001\u624b\u5de5\u751f\u5355\u3001\u76f4\u63a5\u6807\u8bb0\u5df2\u786e\u8ba4\u3001\u6807\u8bb0\u4e3a\u65e0\u9700\u786e\u8ba4\u3001\u901a\u77e5\u8ba4\u9886\u7b49\u64cd\u4f5c\u3002", (String)"RecWorkbenchList_46", (String)"tmc-bei-formplugin", (Object[])new Object[]{transDetail.getString("billno")})));
                selectedRows.removeIf(row -> row.getPrimaryKeyValue().equals(transDetail.getPkValue()));
            }
        }
        if (EmptyUtil.isEmpty((Collection)selectedRows)) {
            if (selectCount == 1) {
                List allErrorInfo = result.getAllErrorInfo();
                this.getView().showTipNotification(((OperateErrorInfo)allErrorInfo.get(0)).getMessage());
            } else {
                result.setBillCount(selectCount);
                this.showOperationResultMulti(result, "", false);
            }
            return;
        }
        selectedPks = selectedRows.getPrimaryKeyValues();
        boolean isHasMatch = AutoMatchHelper.autoMatch((ListSelectedRowCollection)selectedRows, Arrays.asList(MatchBizTypeEnum.REC, MatchBizTypeEnum.TRANSUP), (String)thisOpnumber, (String)"rec");
        OperateOption option = OperateOption.create();
        option.setVariableValue("opnumber", thisOpnumber);
        if (!isHasMatch) {
            ArrayList errors = new ArrayList();
            List idList = Arrays.stream(selectedPks).map(String::valueOf).collect(Collectors.toList());
            Map request = MutexServiceHelper.batchRequest(idList, (String)"bei_intelrec", (String)"dorule_mutex");
            List requestIds = MutexServiceHelper.getRequestResultList(idList, errors, (Map)request);
            try {
                if (!errors.isEmpty()) {
                    for (OperateErrorInfo error : errors) {
                        result.addErrorInfo(error);
                    }
                }
                WorkBenchServiceFactory.getWorkBenchService().execute(requestIds.toArray(), "bei_intelrec", result, option, "", "rule");
            }
            finally {
                if (requestIds.size() > 0) {
                    MutexServiceHelper.batchRelease((List)requestIds, (String)"bei_intelrec", (String)"dorule_mutex");
                }
            }
            if (result.getAllErrorOrValidateInfo().size() > 0) {
                result.setBillCount(selectedRowCount);
                this.showOperationResultMulti(result, ResManager.loadKDString((String)"\u751f\u5355", (String)"RecWorkbenchList_37", (String)"tmc-bei-formplugin", (Object[])new Object[0]), false);
                if (result.getBillCount() != result.getAllErrorInfo().size()) {
                    this.refreshList();
                }
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6309\u89c4\u5219\u751f\u5355\u6210\u529f\u3002", (String)"RecWorkbenchList_20", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                this.refreshList();
            }
        } else {
            QFilter numberFilter = new QFilter("number", "=", (Object)thisOpnumber);
            DynamicObjectCollection automatchresultsaves = QueryServiceHelper.query((String)"cas_autocalresult", (String)"id,name,entryentity.billid", (QFilter[])numberFilter.toArray());
            HashSet<Long> successDetailIds = new HashSet<Long>(automatchresultsaves.size());
            HashSet<Object> remainDetailIds = new HashSet<Object>();
            for (DynamicObject automatchresultsave : automatchresultsaves) {
                Long billid = Long.valueOf(automatchresultsave.getString("entryentity.billid"));
                successDetailIds.add(billid);
            }
            for (Object selectedPk : selectedPks) {
                if (successDetailIds.contains(selectedPk)) continue;
                remainDetailIds.add(selectedPk);
            }
            FormShowParameter fsp = new FormShowParameter();
            if (remainDetailIds.size() > 0) {
                WorkBenchServiceFactory.getWorkBenchService().execute(remainDetailIds.toArray(), "bei_intelrec", result, option, "", "rule");
            }
            boolean isRefresh = false;
            if (result.getAllErrorOrValidateInfo().size() > 0) {
                result.setBillCount(selectedRowCount);
                this.showOperationResultMulti(result, ResManager.loadKDString((String)"\u751f\u5355", (String)"RecWorkbenchList_37", (String)"tmc-bei-formplugin", (Object[])new Object[0]), true);
                if (result.getBillCount() != result.getAllErrorInfo().size()) {
                    this.refreshList();
                    isRefresh = true;
                }
            }
            if (!isRefresh && result.getSuccessPkIds().size() > 0) {
                this.refreshList();
            }
            fsp.setFormId("cas_enterconfirm");
            fsp.setCustomParam("opflag", (Object)"rule");
            fsp.setCustomParam("thisOpnumber", (Object)thisOpnumber);
            fsp.setCustomParam("selectedSize", (Object)(selectedRows.size() + ""));
            fsp.setCustomParam("successIds", (Object)(result.getSuccessPkIds().size() + ""));
            fsp.setCustomParam("failIds", (Object)(result.getAllErrorInfo().size() + ""));
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "cas_enterconfirm");
            fsp.setCloseCallBack(callBack);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        }
    }

    private void receredOp(String opName, DynamicObject[] transdetails, DynamicObjectType type) {
    }

    /*
     * WARNING - void declaration
     */
    public void closedCallBack(ClosedCallBackEvent args) {
        Object confirmSuccessPkIds;
        Object returnDatalink;
        Object successPkIds;
        String thisOpnumber;
        DynamicObject[] transDetails;
        Object returnData;
        super.closedCallBack(args);
        String actionId = args.getActionId();
        StopWatchWithSummary watch = StopWatchWithSummary.createUnstarted();
        watch.start(ResManager.loadKDString((String)"closedCallBack - 665", (String)"CompareUnitResultCalcModel_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"cas_recbizinfo")) {
            watch.nextStep(ResManager.loadKDString((String)"\u624b\u5de5\u5165\u8d26 - 669", (String)"CompareUnitResultCalcModel_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
            returnData = (HashMap)args.getReturnData();
            if (!EmptyUtil.isEmpty((Object)returnData)) {
                OperationResult result = new OperationResult();
                BillList list = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = list.getSelectedRows();
                result.setBillCount(selectedRows.getPrimaryKeyValues().length);
                watch.nextStep(ResManager.loadKDString((String)"\u5168\u91cf\u67e5\u8be2\u9009\u4e2d\u5217\u8868\u6570\u636e -676 ", (String)"CompareUnitResultCalcModel_1", (String)"tmc-fbp-common", (Object[])new Object[0]));
                transDetails = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas"));
                watch.nextStep(ResManager.loadKDString((String)"\u901a\u77e5\u8ba4\u9886\u5224\u65ad -679 ", (String)"CompareUnitResultCalcModel_1", (String)"tmc-fbp-common", (Object[])new Object[0]));
                if (transDetails != null && transDetails.length > 0) {
                    for (DynamicObject transDetail : transDetails) {
                        if (EmptyUtil.isEmpty((String)transDetail.getString("claimnoticebillno"))) continue;
                        result.addErrorInfo(this.getOperateErrorInfo(transDetail.getPkValue(), String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u201c%s\u201d\u751f\u5355\u5931\u8d25\uff0c\u8be5\u4ea4\u6613\u660e\u7ec6\u5df2\u8fdb\u884c\u901a\u77e5\u8ba4\u9886\uff0c\u8bf7\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u518d\u751f\u5355\u3002", (String)"RecWorkbenchList_38", (String)"tmc-bei-formplugin", (Object[])new Object[0]), transDetail.getString("billno"))));
                        selectedRows.removeIf(row -> row.getPrimaryKeyValue().equals(transDetail.getPkValue()));
                    }
                }
                Object[] selectedPks = selectedRows.getPrimaryKeyValues();
                OperateOption operateOption = OperateOption.create();
                String returnDataStr = SerializationUtils.toJsonString((Object)returnData);
                operateOption.setVariableValue("returnDataByOpHand", returnDataStr);
                thisOpnumber = DB.genGlobalLongId() + "";
                operateOption.setVariableValue("opnumber", thisOpnumber);
                watch.nextStep(ResManager.loadKDString((String)"\u667a\u80fd\u5339\u914d\u64cd\u4f5c\u7ed3\u675f -701 ", (String)"CompareUnitResultCalcModel_1", (String)"tmc-fbp-common", (Object[])new Object[0]));
                String handleBill = (String)returnData.get("handleBill");
                boolean isHasMatch = true;
                isHasMatch = UP_BILL.equals(handleBill) ? AutoMatchHelper.autoMatch((ListSelectedRowCollection)selectedRows, (MatchBizTypeEnum)MatchBizTypeEnum.TRANSUP, (String)thisOpnumber, (String)"rec") : AutoMatchHelper.autoMatch((ListSelectedRowCollection)selectedRows, (MatchBizTypeEnum)MatchBizTypeEnum.REC, (String)thisOpnumber, (String)"rec");
                if (!isHasMatch) {
                    watch.nextStep(ResManager.loadKDString((String)"\u624b\u5de5\u5165\u8d26\u4e0b\u63a8\u5e76\u4fdd\u5b58 -712 ", (String)"CompareUnitResultCalcModel_1", (String)"tmc-fbp-common", (Object[])new Object[0]));
                    WorkBenchServiceFactory.getWorkBenchService().execute(selectedPks, "bei_intelrec", result, operateOption, handleBill, "hand");
                    if (result.getAllErrorOrValidateInfo().size() > 0) {
                        this.showOperationResultMulti(result, ResManager.loadKDString((String)"\u751f\u5355", (String)"RecWorkbenchList_37", (String)"tmc-bei-formplugin", (Object[])new Object[0]), false);
                    } else {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u624b\u5de5\u751f\u5355\u5df2\u6210\u529f\u3002", (String)"RecWorkbenchList_21", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    QFilter numberFilter = new QFilter("number", "=", (Object)thisOpnumber);
                    DynamicObject[] automatchresultsaves = BusinessDataServiceHelper.load((String)"cas_autocalresult", (String)"id,name,entryentity,entryentity.billid", (QFilter[])new QFilter[]{numberFilter});
                    HashSet<Object> remainDetailIds = new HashSet<Object>();
                    HashSet successDetailIds = new HashSet(automatchresultsaves.length);
                    for (DynamicObject dynamicObject : automatchresultsaves) {
                        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                        Long billid = Long.valueOf(((DynamicObject)entryentity.get(0)).getString("billid"));
                        successDetailIds.add(billid);
                    }
                    for (Object object : selectedPks) {
                        if (successDetailIds.contains(object)) continue;
                        remainDetailIds.add(object);
                    }
                    FormShowParameter formShowParameter = new FormShowParameter();
                    watch.nextStep(ResManager.loadKDString((String)"\u624b\u5de5\u5165\u8d26\u4e0b\u63a8\u5e76\u4fdd\u5b58 -757 ", (String)"CompareUnitResultCalcModel_1", (String)"tmc-fbp-common", (Object[])new Object[0]));
                    if (remainDetailIds.size() > 0) {
                        WorkBenchServiceFactory.getWorkBenchService().execute(remainDetailIds.toArray(), "bei_intelrec", result, operateOption, handleBill, "hand");
                    }
                    if (result.getAllErrorOrValidateInfo().size() > 0) {
                        result.setBillCount(selectedPks.length);
                        this.showOperationResultMulti(result, ResManager.loadKDString((String)"\u751f\u5355", (String)"RecWorkbenchList_37", (String)"tmc-bei-formplugin", (Object[])new Object[0]), true);
                    }
                    formShowParameter.setFormId("cas_enterconfirm");
                    formShowParameter.setCustomParam("opflag", (Object)"hand");
                    formShowParameter.setCustomParam("handparam", (Object)returnDataStr);
                    formShowParameter.setCustomParam("thisOpnumber", (Object)thisOpnumber);
                    formShowParameter.setCustomParam("selectedSize", (Object)(selectedRows.size() + ""));
                    formShowParameter.setCustomParam("successIds", (Object)(result.getSuccessPkIds().size() + ""));
                    formShowParameter.setCustomParam("failIds", (Object)(result.getAllErrorInfo().size() + ""));
                    CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "cas_enterconfirm");
                    formShowParameter.setCloseCallBack(callBack);
                    formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                    this.getView().showForm(formShowParameter);
                }
            }
        }
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"cas_recbizinfomerge")) {
            HashMap returnDataMapmerge = (HashMap)args.getReturnData();
            if (EmptyUtil.isEmpty((Object)returnDataMapmerge)) {
                return;
            }
            BillList listmerge = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = listmerge.getSelectedRows();
            OperationResult result = new OperationResult();
            watch.nextStep(ResManager.loadKDString((String)"\u901a\u77e5\u8ba4\u9886\u6821\u9a8c - 800", (String)"CompareUnitResultCalcModel_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
            try {
                result.setBillCount(selectedRows.getPrimaryKeyValues().length);
                transDetails = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas"));
                if (transDetails != null && transDetails.length > 0) {
                    for (DynamicObject transDetail : transDetails) {
                        if (EmptyUtil.isEmpty((String)transDetail.getString("claimnoticebillno"))) continue;
                        result.addErrorInfo(this.getOperateErrorInfo(transDetail.getPkValue(), String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u201c%s\u201d\u751f\u5355\u5931\u8d25\uff0c\u8be5\u4ea4\u6613\u660e\u7ec6\u5df2\u8fdb\u884c\u901a\u77e5\u8ba4\u9886\uff0c\u8bf7\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u518d\u751f\u5355\u3002", (String)"RecWorkbenchList_38", (String)"tmc-bei-formplugin", (Object[])new Object[0]), transDetail.getString("billno"))));
                        selectedRows.removeIf(row -> row.getPrimaryKeyValue().equals(transDetail.getPkValue()));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.info(e.getMessage());
            }
            watch.nextStep(ResManager.loadKDString((String)"\u5408\u5e76\u5165\u8d261 - 820", (String)"CompareUnitResultCalcModel_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
            ListSelectedRowCollection selectedRowsmerge = selectedRows;
            Object[] selectedPksmerge = selectedRowsmerge.getPrimaryKeyValues();
            OperateOption operateOptionmerge = OperateOption.create();
            String returnDataStrmerge = SerializationUtils.toJsonString((Object)returnDataMapmerge);
            operateOptionmerge.setVariableValue("returnDataByOpHandMerge", returnDataStrmerge);
            thisOpnumber = DB.genGlobalLongId() + "";
            operateOptionmerge.setVariableValue("opnumber", thisOpnumber);
            ConvertRuleElement convertRuleElement = ConvertMetaServiceHelper.loadRule((String)"1216457805070901248");
            HashMap<String, List<Long>> groupMap = new HashMap<String, List<Long>>();
            if (!EmptyUtil.isEmpty((Object)convertRuleElement) && !EmptyUtil.isEmpty((Object)convertRuleElement.getGroupByPolicy())) {
                String groupByField = convertRuleElement.getGroupByPolicy().getGroupByField();
                if (!EmptyUtil.isEmpty((String)groupByField) && !"".equals(groupByField)) {
                    DynamicObject[] ids = BusinessDataServiceHelper.load((String)"bei_intelrec", (String)("id," + groupByField), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedPksmerge)});
                    DynamicObjectCollection split = groupByField.split(",");
                    for (DynamicObject id : ids) {
                        void var22_43;
                        Object var22_42 = null;
                        for (String fileName : split) {
                            Object fileData = id.get(fileName);
                            if (var22_43 == null) {
                                StringBuilder stringBuilder = new StringBuilder(EmptyUtil.isEmpty((Object)fileData) ? "" : fileData.toString());
                                continue;
                            }
                            var22_43.append(EmptyUtil.isEmpty((Object)fileData) ? "" : fileData.toString());
                        }
                        if (var22_43 == null) continue;
                        ArrayList<Long> groupList = (ArrayList<Long>)groupMap.get(var22_43.toString());
                        if (EmptyUtil.isEmpty((Collection)groupList)) {
                            groupList = new ArrayList<Long>();
                        }
                        groupList.add((Long)id.getPkValue());
                        groupMap.put(var22_43.toString(), groupList);
                    }
                } else {
                    List collect = Arrays.stream(selectedPksmerge).map(o -> (Long)o).collect(Collectors.toList());
                    groupMap.put("only", collect);
                }
            }
            watch.nextStep(ResManager.loadKDString((String)"\u5408\u5e76\u5165\u8d262 - 820", (String)"CompareUnitResultCalcModel_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
            for (Map.Entry objectListEntry : groupMap.entrySet()) {
                try {
                    LOGGER.info("\u6536\u6b3e\u5165\u8d26\u4e2d\u5fc3\u4f20\u5165\u53c2\u6570", (Object)returnDataStrmerge);
                    OperationResult pushandsavemerge = OperateServiceHelper.execOperate((String)"pushandsavemerge", (String)"bei_intelrec", (Object[])((List)objectListEntry.getValue()).toArray(), (OperateOption)operateOptionmerge);
                    result.setSuccess(true);
                    List successPkIds2 = result.getSuccessPkIds();
                    if (result.getSuccessPkIds() != null) {
                        successPkIds2.addAll(pushandsavemerge.getSuccessPkIds());
                    }
                    result.setSuccessPkIds(successPkIds2);
                }
                catch (Exception ee) {
                    OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                    operateErrorInfo.setLevel(ErrorLevel.Error);
                    operateErrorInfo.setMessage(ee.getMessage());
                    result.addErrorInfo(operateErrorInfo);
                }
            }
            if (result.getAllErrorOrValidateInfo().size() > 0) {
                this.showOperationResultMulti(result, ResManager.loadKDString((String)"\u751f\u5355", (String)"PassivePayWorkbenchList_30", (String)"tmc-bei-formplugin", (Object[])new Object[0]), false);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u624b\u5de5\u5408\u5e76\u751f\u5355\u6210\u529f\u3002", (String)"PassivePayWorkbenchList_33", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            }
        }
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"cas_enterconfirm")) {
            watch.nextStep(ResManager.loadKDString((String)"\u5165\u8d26\u786e\u8ba4 - 904", (String)"CompareUnitResultCalcModel_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
            returnData = args.getReturnData();
            if (!EmptyUtil.isEmpty((Object)returnData)) {
                Object operateResult;
                successPkIds = ((HashMap)returnData).get("successPkIds");
                if (!EmptyUtil.isEmpty(successPkIds)) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u5355\u6210\u529f\u3002\u5df2\u5bf9\u5269\u4f59\u8bb0\u5f55\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"RecWorkbenchList_22", (String)"tmc-bei-formplugin", (Object[])new Object[0]), Integer.valueOf(4000));
                }
                if (!EmptyUtil.isEmpty(operateResult = ((HashMap)returnData).get("operateResultMap"))) {
                    Map operateResultMap = (Map)operateResult;
                    List allErrorInfoList = (List)operateResultMap.get("allErrorInfoList");
                    int totalCount = (Integer)operateResultMap.get("totalCount");
                    int successCount = (Integer)operateResultMap.get("successCount");
                    String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u5df2\u6210\u529f\u751f\u5355%2$s\u5f20\uff0c\u751f\u5355\u5931\u8d25%3$s\u5f20\u3002", (String)"RecWorkbenchList_23", (String)"tmc-bei-formplugin", (Object[])new Object[0]), totalCount, successCount, totalCount - successCount);
                    StringBuilder detailInfo = new StringBuilder();
                    for (String allErrorInfo : allErrorInfoList) {
                        detailInfo.append(allErrorInfo);
                    }
                    this.getView().showMessage(title, detailInfo.toString(), MessageTypes.Default);
                }
            }
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"confirm")) {
            watch.nextStep(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4 - 932", (String)"CompareUnitResultCalcModel_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
            returnData = args.getReturnData();
            if (!EmptyUtil.isEmpty((Object)returnData) && !EmptyUtil.isEmpty(successPkIds = ((HashMap)returnData).get("successPkIds"))) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u5355\u6210\u529f\u3002\u5df2\u786e\u8ba4\u5269\u4f59\u8bb0\u5f55\u5df2\u751f\u5355\u3002", (String)"RecWorkbenchList_24", (String)"tmc-bei-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            }
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"reccallback") && !EmptyUtil.isEmpty((Object)(returnDatalink = args.getReturnData())) && !EmptyUtil.isEmpty(confirmSuccessPkIds = ((HashMap)returnDatalink).get("flag"))) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u624b\u5de5\u5173\u8054\u751f\u5355\u6210\u529f\u3002", (String)"PassivePayWorkbenchPlugin_17", (String)"tmc-bei-formplugin", (Object[])new Object[0]), Integer.valueOf(4000));
        }
        this.refreshList();
        watch.stop();
        watch.printSummary();
    }

    private void showOperationResultMulti(OperationResult operationResult, String operateName, boolean isHasMatch) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("operateName", (Object)operateName);
        HashMap pkNumbers = new HashMap(16);
        if (operationResult.getSuccessPkIds() != null && !operationResult.getSuccessPkIds().isEmpty() && !operationResult.getBillNos().isEmpty()) {
            pkNumbers.putAll(operationResult.getBillNos());
        }
        parameters.setCustomParam("pkNumbers", pkNumbers);
        IPageCache pageCache = this.getPageCache();
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        pageCache.put("operationresult", serialResult);
        int totalCount = operationResult.getBillCount();
        int successCount = operationResult.getSuccessPkIds().size();
        int errorCount = operationResult.getAllErrorInfo().size();
        String title = "";
        title = !isHasMatch ? String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"RecWorkbenchList_25", (String)"tmc-bei-formplugin", (Object[])new Object[0]), operationResult.getBillCount(), successCount, operationResult.getBillCount() - successCount) : String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\uff0c\u5f85\u751f\u5355\u786e\u8ba4%4$s\u5f20\u3002", (String)"RecWorkbenchList_26", (String)"tmc-bei-formplugin", (Object[])new Object[0]), totalCount, successCount, errorCount, totalCount - successCount - errorCount);
        parameters.setCustomParam("title", (Object)title);
        StringBuilder buf = new StringBuilder();
        buf.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        int count = 0;
        int len = errorInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            IOperateInfo errorItem = (IOperateInfo)errorInfos.get(i);
            if (!EmptyUtil.isNoEmpty((Object)errorItem) || !EmptyUtil.isNoEmpty((String)errorItem.getMessage())) continue;
            String lowerCaseBuf = errorItem.getMessage().toLowerCase();
            if (count == 0 && (lowerCaseBuf.contains("data too long for column 'fbankcheckflag'") || lowerCaseBuf.contains("value too long for"))) {
                buf.append(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u751f\u5355\u6210\u529f%1$s\u7b14\u660e\u7ec6\uff0c\u5931\u8d25%2$s\u7b14\uff0c\u5931\u8d25\u539f\u56e0\u4e3a\u5408\u5e76\u751f\u6210\u7684\u76ee\u6807\u5355\u636e\u3010\u5bf9\u8d26\u6807\u8bc6\u7801\u3011\u5b57\u6bb5\u8fc7\u957f\uff0c\u6700\u5927\u957f\u5ea6\u4e3a1024\uff0c\u8bf7\u51cf\u5c11\u9700\u5408\u5e76\u751f\u5355\u7684\u4ea4\u6613\u660e\u7ec6\u6570\u91cf\u3002", (String)"RecWorkbenchList_45", (String)"tmc-bei-formplugin", (Object[])new Object[0]), successCount, operationResult.getBillCount() - successCount)).append("<br/>");
                ++count;
                continue;
            }
            if (lowerCaseBuf.contains("data too long for column 'fbankcheckflag'")) continue;
            buf.append(((IOperateInfo)errorInfos.get(i)).getMessage()).append("<br/>");
        }
        parameters.setCustomParam("hasMore", (Object)(errorInfos.size() > 5 ? 1 : 0));
        parameters.setCustomParam("errorMsg", (Object)buf.append("</div>").toString().trim());
        this.getView().showForm(parameters);
    }

    public OperateErrorInfo getOperateErrorInfo(Object pk, String meg) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setLevel(ErrorLevel.Error);
        operateErrorInfo.setPkValue(pk);
        operateErrorInfo.setMessage(meg);
        return operateErrorInfo;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if ("CONFIRM_MANUALMATCH".equals(id) && MessageBoxResult.Yes.equals((Object)res)) {
            DetailManualMatchHelper.confirmBizBillMatchDetail((IFormView)this.getView(), (MessageBoxClosedEvent)messageBoxClosedEvent, (String)"company,accountbank,currency");
        }
    }
}

