/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.TCCAdapterService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.business.helper.AutoMatchServiceHelper;
import kd.tmc.bei.common.param.AutoMatchInfoParam;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AutoMatchBankJournalTCCService
extends TCCAdapterService {
    private static final Log LOGGER = LogFactory.getLog(AutoMatchBankJournalTCCService.class);
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("autoMatchRegion");
    private static final Map<String, String> TRACETYPEMAP = new /* Unavailable Anonymous Inner Class!! */;

    public void Try(Object o) throws Exception {
    }

    public DtxResponse confirm(Object param, Object lastReturn) throws Exception {
        CommonParam commonParam = AutoMatchServiceHelper.getCommonParam((Object)param);
        List<AutoMatchInfoParam> autoMatchInfoList = AutoMatchServiceHelper.getAutoMatchInfoList((CommonParam)commonParam);
        autoMatchInfoList = autoMatchInfoList.stream().filter(o -> o.getRecedBillId() != 0L).collect(Collectors.toList());
        boolean doExecute = Boolean.parseBoolean(commonParam.getString((Object)"DoExecute"));
        if (doExecute) {
            this.updateBankJournals(autoMatchInfoList);
        } else {
            this.cancelBankJournals(autoMatchInfoList);
        }
        return null;
    }

    public void cancel(Object param) throws Exception {
    }

    public void updateBankJournals(List<AutoMatchInfoParam> tAutoMatchInfoParamList) {
        Map tRecedBillsIdMap = tAutoMatchInfoParamList.stream().collect(Collectors.groupingBy(AutoMatchInfoParam::getRecedBillType, Collectors.mapping(AutoMatchInfoParam::getRecedBillId, Collectors.toList())));
        HashMap<String, Map<Long, DynamicObject>> tRecedBillsMap = new HashMap<String, Map<Long, DynamicObject>>(tRecedBillsIdMap.size());
        HashMap<String, Set> form_billIds = new HashMap<String, Set>(16);
        for (Map.Entry entry : tRecedBillsIdMap.entrySet()) {
            String key = AutoMatchServiceHelper.getRecedBillType((String)entry.getKey());
            Set form_billId = form_billIds.computeIfAbsent(key, k -> new HashSet(16));
            form_billId.addAll(entry.getValue());
        }
        for (Map.Entry<String, List<Object>> entry : form_billIds.entrySet()) {
            DynamicObject[] tRecedBills = BusinessDataServiceHelper.load((Object[])((Set)((Object)entry.getValue())).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entry.getKey()));
            tRecedBillsMap.put(entry.getKey(), Arrays.stream(tRecedBills).collect(Collectors.toMap(k -> k.getLong("id"), v -> v)));
        }
        Map tExchangeBillFromDbMap = (Map)tRecedBillsMap.get("cas_exchangebill");
        Map<Long, List<AutoMatchInfoParam>> map = tAutoMatchInfoParamList.stream().collect(Collectors.groupingBy(AutoMatchInfoParam::getRecedBillId));
        QFilter billnoQfilter = new QFilter("sourcebillid", "in", map.keySet());
        DynamicObject[] bankjournals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id,bankcheckentity.ebankcheckflag,bankcheckflag,bankcheckflag_tag,batchno,accountbank,currency,debitamount,creditamount,sourcebillid,tracedate", (QFilter[])billnoQfilter.toArray());
        Map<Long, List<DynamicObject>> tSourceBillIdsMap = Arrays.stream(bankjournals).collect(Collectors.groupingBy(k -> k.getLong("sourcebillid")));
        for (Map.Entry<Long, List<DynamicObject>> tSourceBillIdsEntry : tSourceBillIdsMap.entrySet()) {
            List<AutoMatchInfoParam> sourcebillids = map.get(tSourceBillIdsEntry.getKey());
            Map<String, List<AutoMatchInfoParam>> tExchangeBillsMap = sourcebillids.stream().filter(o -> "cas_exchangebill".equals(o.getRecedBillType())).collect(Collectors.groupingBy(AutoMatchInfoParam::getTraceType));
            for (Map.Entry<String, List<AutoMatchInfoParam>> tExchangeBillsEntry : tExchangeBillsMap.entrySet()) {
                String tBankCheckFlag = tExchangeBillsEntry.getValue().stream().map(AutoMatchInfoParam::getBankCheckFlag).filter(EmptyUtil::isNoEmpty).distinct().reduce((a, b) -> String.join((CharSequence)",", a, b)).orElse("");
                Date traceDate = tExchangeBillsEntry.getValue().stream().map(AutoMatchInfoParam::getBizDate).filter(EmptyUtil::isNoEmpty).reduce((a, b) -> a.compareTo((Date)b) > 0 ? a : b).orElse(null);
                DynamicObject busnessBill = (DynamicObject)tExchangeBillFromDbMap.get(tSourceBillIdsEntry.getKey());
                AutoMatchServiceHelper.updataExchangeBill((DynamicObject)busnessBill, (String)tExchangeBillsEntry.getKey(), (String)tBankCheckFlag, (Date)traceDate);
                this.updateExchangeBillBankJournal(tSourceBillIdsEntry.getValue(), busnessBill, tExchangeBillsEntry.getKey(), Boolean.TRUE, tBankCheckFlag);
            }
            if (tExchangeBillsMap.size() >= 1) continue;
            String tBankCheckFlag = sourcebillids.stream().filter(o -> !"cas_exchangebill".equals(o.getRecedBillType())).map(AutoMatchInfoParam::getBankCheckFlag).filter(EmptyUtil::isNoEmpty).distinct().reduce((a, b) -> String.join((CharSequence)",", a, b)).orElse("");
            Date traceDate = sourcebillids.stream().filter(o -> !"cas_exchangebill".equals(o.getRecedBillType())).map(AutoMatchInfoParam::getBizDate).filter(EmptyUtil::isNoEmpty).reduce((a, b) -> a.compareTo((Date)b) > 0 ? a : b).orElse(null);
            tSourceBillIdsEntry.getValue().forEach(tSourceBillIdEntry -> {
                tSourceBillIdEntry.set("bankcheckflag_tag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)tSourceBillIdEntry.getString("bankcheckflag_tag"), (String)tBankCheckFlag, (int)0));
                tSourceBillIdEntry.set("bankcheckflag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)tSourceBillIdEntry.getString("bankcheckflag_tag"), (String)tBankCheckFlag, (int)255));
                tSourceBillIdEntry.set("batchNo", (Object)AutoMatchServiceHelper.getbankcheckBill((String)tSourceBillIdEntry.getString("bankcheckflag_tag"), (String)tBankCheckFlag, (int)1024));
                this.setBankCheckFlagEntity((DynamicObject)tSourceBillIdEntry, tBankCheckFlag, Boolean.TRUE);
                Date exchangedate = tSourceBillIdEntry.getDate("tracedate");
                tSourceBillIdEntry.set("tracedate", (Object)(exchangedate != null && exchangedate.compareTo(traceDate) > 0 ? exchangedate : traceDate));
            });
        }
        this.dealVouchersBankJournal(tAutoMatchInfoParamList, map, Boolean.TRUE);
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])tSourceBillIdsMap.values().stream().flatMap(Collection::stream).toArray(DynamicObject[]::new)));
    }

    public void cancelBankJournals(List<AutoMatchInfoParam> tAutoMatchInfoParamList) {
        Map<Long, List<AutoMatchInfoParam>> collect;
        Object[] tExchangeBillIds = tAutoMatchInfoParamList.stream().filter(o -> "cas_exchangebill".equals(o.getRecedBillType())).map(AutoMatchInfoParam::getRecedBillId).distinct().toArray();
        HashMap<Long, DynamicObject> tExchangeBillFromDbMap = new HashMap<Long, DynamicObject>(tExchangeBillIds.length);
        if (tExchangeBillIds.length > 0) {
            DynamicObject[] tExchangeBills = BusinessDataServiceHelper.load((Object[])tExchangeBillIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_exchangebill"));
            tExchangeBillFromDbMap.putAll(Arrays.stream(tExchangeBills).collect(Collectors.toMap(k -> k.getLong("id"), v -> v)));
        }
        if ((collect = tAutoMatchInfoParamList.stream().filter(a -> a.getRecedBillId() != null && a.getRecedBillId() != 0L).collect(Collectors.groupingBy(AutoMatchInfoParam::getRecedBillId))).isEmpty()) {
            return;
        }
        QFilter billnoQfilter = new QFilter("sourcebillid", "in", collect.keySet());
        DynamicObject[] bankjournals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id,sourcebilltype,bankcheckentity.ebankcheckflag,bankcheckflag,bankcheckflag_tag,batchno,accountbank,currency,debitamount,creditamount,sourcebillid,tracedate", (QFilter[])billnoQfilter.toArray());
        Map<Long, List<DynamicObject>> tSourceBillIdsMap = Arrays.stream(bankjournals).collect(Collectors.groupingBy(k -> k.getLong("sourcebillid")));
        for (Map.Entry<Long, List<DynamicObject>> tSourceBillIdsEntry : tSourceBillIdsMap.entrySet()) {
            List<AutoMatchInfoParam> sourcebillids = collect.get(tSourceBillIdsEntry.getKey());
            List<DynamicObject> billBankJournal = tSourceBillIdsEntry.getValue();
            Map<String, List<AutoMatchInfoParam>> tExchangeBillsMap = sourcebillids.stream().filter(o -> "cas_exchangebill".equals(o.getRecedBillType())).collect(Collectors.groupingBy(AutoMatchInfoParam::getTraceType));
            if (tExchangeBillsMap.size() > 0) {
                for (Map.Entry<String, List<AutoMatchInfoParam>> tExchangeBillsEntry : tExchangeBillsMap.entrySet()) {
                    String tBankCheckFlag = tExchangeBillsEntry.getValue().stream().map(AutoMatchInfoParam::getBankCheckFlag).filter(EmptyUtil::isNoEmpty).distinct().reduce((a, b) -> String.join((CharSequence)",", a, b)).orElse("");
                    Date traceDate = tExchangeBillsEntry.getValue().stream().map(AutoMatchInfoParam::getBizDate).filter(EmptyUtil::isNoEmpty).reduce((a, b) -> a.compareTo((Date)b) > 0 ? a : b).orElse(null);
                    DynamicObject busnessBill = (DynamicObject)tExchangeBillFromDbMap.get(tSourceBillIdsEntry.getKey());
                    AutoMatchServiceHelper.cancelExchangeBill((DynamicObject)busnessBill, (String)tExchangeBillsEntry.getKey(), (String)tBankCheckFlag, (Date)traceDate);
                    LOGGER.info("updateBankJournals cas_exchangebill:{}", (Object)tBankCheckFlag);
                    this.updateExchangeBillBankJournal(billBankJournal, busnessBill, tExchangeBillsEntry.getKey(), Boolean.FALSE, tBankCheckFlag);
                }
                continue;
            }
            String tBankCheckFlag = sourcebillids.stream().filter(o -> !"cas_exchangebill".equals(o.getRecedBillType())).map(AutoMatchInfoParam::getBankCheckFlag).filter(EmptyUtil::isNoEmpty).distinct().reduce((a, b) -> String.join((CharSequence)",", a, b)).orElse("");
            Date traceDate = sourcebillids.stream().filter(o -> !"cas_exchangebill".equals(o.getRecedBillType())).map(AutoMatchInfoParam::getBizDate).filter(EmptyUtil::isNoEmpty).distinct().reduce((a, b) -> a.compareTo((Date)b) > 0 ? a : b).orElse(null);
            billBankJournal.forEach(tSourceBillIdEntry -> {
                tSourceBillIdEntry.set("bankcheckflag_tag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)AutoMatchServiceHelper.dealBankcheckflag((String)tSourceBillIdEntry.getString("bankcheckflag_tag"), (String)tBankCheckFlag), (String)"", (int)0));
                tSourceBillIdEntry.set("bankcheckflag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)AutoMatchServiceHelper.dealBankcheckflag((String)tSourceBillIdEntry.getString("bankcheckflag_tag"), (String)tBankCheckFlag), (String)"", (int)255));
                this.setBankCheckFlagEntity((DynamicObject)tSourceBillIdEntry, tBankCheckFlag, Boolean.FALSE);
                tSourceBillIdEntry.set("tracedate", (Object)traceDate);
            });
        }
        this.dealVouchersBankJournal(tAutoMatchInfoParamList, collect, Boolean.FALSE);
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])tSourceBillIdsMap.values().stream().flatMap(Collection::stream).toArray(DynamicObject[]::new)));
    }

    private void dealVouchersBankJournal(List<AutoMatchInfoParam> tAutoMatchInfoParamList, Map<Long, List<AutoMatchInfoParam>> collect, boolean option) {
        DynamicObjectCollection vouchersDap;
        Map tRecedBillsIdMap = tAutoMatchInfoParamList.stream().collect(Collectors.groupingBy(AutoMatchInfoParam::getRecedBillType, Collectors.mapping(AutoMatchInfoParam::getRecedBillId, Collectors.toList())));
        ArrayList idList = new ArrayList(2);
        for (Map.Entry tRecedBills : tRecedBillsIdMap.entrySet()) {
            idList.addAll(tRecedBills.getValue());
        }
        LOGGER.info("dealVouchersBankJournal idList:{}", idList);
        if (!idList.isEmpty() && !(vouchersDap = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid,voucherid,billtype", (QFilter[])new QFilter("sourcebillid", "in", idList).toArray())).isEmpty()) {
            Map voucheridMap = vouchersDap.stream().collect(Collectors.groupingBy(k -> k.getLong("sourcebillid"), Collectors.mapping(v -> v.getLong("voucherid"), Collectors.toSet())));
            List voucheridList = voucheridMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            QFilter qFilter = new QFilter("sourcebilltype", "=", (Object)"gl_voucher");
            qFilter.and(new QFilter("sourcebillid", "in", voucheridList));
            DynamicObject[] journals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"source,sourcebillid,bankcheckentity.ebankcheckflag,sourcebilltype,bankcheckflag,bankcheckflag_tag,batchNo", (QFilter[])qFilter.toArray());
            if (journals != null && journals.length > 0) {
                Map<Long, String> tBankCheckFlagMap = collect.entrySet().stream().filter(o -> idList.contains(o.getKey())).collect(Collectors.toMap(Map.Entry::getKey, v -> ((List)v.getValue()).stream().map(AutoMatchInfoParam::getBankCheckFlag).filter(StringUtils::isNotEmpty).distinct().reduce((a, b) -> String.join((CharSequence)",", a, b)).orElse("")));
                voucheridMap.forEach((key, value) -> {
                    String bankcheckflagTag = (String)tBankCheckFlagMap.get(key);
                    Arrays.stream(journals).filter(o -> value.contains(o.getLong("sourcebillid"))).forEach(journal -> {
                        LOGGER.info("dealVouchersBankJournal option:{},bankcheckflagTag:{}", (Object)option, (Object)bankcheckflagTag);
                        LOGGER.info("dealVouchersBankJournal journal:{}", journal);
                        if (option) {
                            journal.set("bankcheckflag_tag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)journal.getString("bankcheckflag_tag"), (String)bankcheckflagTag, (int)0));
                            journal.set("bankcheckflag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)journal.getString("bankcheckflag_tag"), (String)bankcheckflagTag, (int)255));
                            journal.set("batchNo", (Object)AutoMatchServiceHelper.getbankcheckBill((String)journal.getString("bankcheckflag_tag"), (String)bankcheckflagTag, (int)1024));
                        } else {
                            journal.set("bankcheckflag_tag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)AutoMatchServiceHelper.dealBankcheckflag((String)journal.getString("bankcheckflag_tag"), (String)bankcheckflagTag), (String)"", (int)0));
                            journal.set("bankcheckflag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)AutoMatchServiceHelper.dealBankcheckflag((String)journal.getString("bankcheckflag_tag"), (String)bankcheckflagTag), (String)"", (int)255));
                            journal.set("batchNo", (Object)AutoMatchServiceHelper.getbankcheckBill((String)journal.getString("bankcheckflag_tag"), (String)bankcheckflagTag, (int)1024));
                        }
                        this.setBankCheckFlagEntity((DynamicObject)journal, bankcheckflagTag, option);
                    });
                });
                SaveServiceHelper.save((DynamicObject[])journals);
            }
        }
    }

    private void updateExchangeBillBankJournal(List<DynamicObject> bankjournals, DynamicObject busnessBill, String tracetype, boolean option, String tBankCheckFlag) {
        if (!TRACETYPEMAP.containsKey(tracetype) || busnessBill == null) {
            return;
        }
        for (DynamicObject bankjournal : bankjournals) {
            BigDecimal commissionamount;
            DynamicObject sellingcurrency;
            DynamicObject sellingaccount;
            Long accountbank = (Long)bankjournal.getDynamicObject("accountbank").getPkValue();
            Long currency = (Long)bankjournal.getDynamicObject("currency").getPkValue();
            BigDecimal creditamount = bankjournal.getBigDecimal("creditamount");
            LOGGER.info("updateBankJournals cas_exchangebill tracetype:{}", (Object)tracetype);
            if ("sell".equals(tracetype)) {
                boolean isCheck;
                sellingaccount = busnessBill.getDynamicObject("sellingaccount");
                sellingcurrency = busnessBill.getDynamicObject("sellingcurrency");
                BigDecimal sellamount = busnessBill.getBigDecimal("sellamount");
                if (!EmptyUtil.isNoEmpty((DynamicObject)sellingaccount) || !EmptyUtil.isNoEmpty((DynamicObject)sellingcurrency) || !EmptyUtil.isNoEmpty((BigDecimal)sellamount) || !(isCheck = accountbank.compareTo((Long)sellingaccount.getPkValue()) == 0 && currency.compareTo((Long)sellingcurrency.getPkValue()) == 0 && creditamount.compareTo(sellamount) == 0)) continue;
                bankjournal.set("bankcheckflag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)busnessBill.getString(TRACETYPEMAP.get(tracetype)), (String)"", (int)255));
                bankjournal.set("bankcheckflag_tag", (Object)busnessBill.getString(TRACETYPEMAP.get(tracetype)));
                bankjournal.set("tracedate", (Object)busnessBill.getDate("acttradedate"));
                LOGGER.info("updateBankJournals cas_exchangebill bankjournal:{}", (Object)bankjournal);
                LOGGER.info("updateBankJournals cas_exchangebill tBankCheckFlag:{}", (Object)tBankCheckFlag);
                LOGGER.info("updateBankJournals cas_exchangebill option:{}", (Object)tBankCheckFlag);
                this.setBankCheckFlagEntity(bankjournal, tBankCheckFlag, option);
                continue;
            }
            if ("fee".equals(tracetype)) {
                sellingaccount = busnessBill.getDynamicObject("paycommissionaccount");
                sellingcurrency = busnessBill.getDynamicObject("commissioncurrency");
                commissionamount = busnessBill.getBigDecimal("commissionamount");
                if (!EmptyUtil.isNoEmpty((DynamicObject)sellingaccount) || !EmptyUtil.isNoEmpty((DynamicObject)sellingcurrency) || !EmptyUtil.isNoEmpty((BigDecimal)creditamount) || !EmptyUtil.isNoEmpty((BigDecimal)commissionamount) || accountbank.compareTo((Long)sellingaccount.getPkValue()) != 0 || currency.compareTo((Long)sellingcurrency.getPkValue()) != 0 || creditamount.compareTo(commissionamount) != 0) continue;
                bankjournal.set("bankcheckflag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)busnessBill.getString(TRACETYPEMAP.get(tracetype)), (String)"", (int)255));
                bankjournal.set("bankcheckflag_tag", (Object)busnessBill.getString(TRACETYPEMAP.get(tracetype)));
                bankjournal.set("tracedate", (Object)busnessBill.getDate("acttradedate"));
                this.setBankCheckFlagEntity(bankjournal, tBankCheckFlag, option);
                continue;
            }
            if (!"buy".equals(tracetype)) continue;
            creditamount = bankjournal.getBigDecimal("debitamount");
            sellingaccount = busnessBill.getDynamicObject("buyingaccount");
            sellingcurrency = busnessBill.getDynamicObject("buyingcurrency");
            commissionamount = busnessBill.getBigDecimal("buyamount");
            if (!EmptyUtil.isNoEmpty((DynamicObject)sellingaccount) || !EmptyUtil.isNoEmpty((DynamicObject)sellingcurrency) || !EmptyUtil.isNoEmpty((BigDecimal)creditamount) || !EmptyUtil.isNoEmpty((BigDecimal)commissionamount) || accountbank.compareTo((Long)sellingaccount.getPkValue()) != 0 || currency.compareTo((Long)sellingcurrency.getPkValue()) != 0 || creditamount.compareTo(commissionamount) != 0) continue;
            bankjournal.set("bankcheckflag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)busnessBill.getString(TRACETYPEMAP.get(tracetype)), (String)"", (int)255));
            bankjournal.set("bankcheckflag_tag", (Object)busnessBill.getString(TRACETYPEMAP.get(tracetype)));
            bankjournal.set("tracedate", (Object)busnessBill.getDate("acttradedate"));
            this.setBankCheckFlagEntity(bankjournal, tBankCheckFlag, option);
        }
    }

    private void setBankCheckFlagEntity(DynamicObject dynamicObject, String strBankCheckFlag, boolean option) {
        if (!EmptyUtil.isEmpty((String)strBankCheckFlag) && dynamicObject.containsProperty("bankcheckentity")) {
            String[] split;
            DynamicObjectCollection bankCheckEntity = dynamicObject.getDynamicObjectCollection("bankcheckentity");
            bankCheckEntity.removeIf(o -> EmptyUtil.isEmpty((String)o.getString("ebankcheckflag")));
            for (String flag : split = strBankCheckFlag.split(",")) {
                if (EmptyUtil.isEmpty((String)flag)) continue;
                if (bankCheckEntity.stream().anyMatch(o -> flag.equalsIgnoreCase(o.getString("ebankcheckflag")))) {
                    List eBankCheckFlag;
                    if (option || (eBankCheckFlag = bankCheckEntity.stream().filter(o -> flag.equalsIgnoreCase(o.getString("ebankcheckflag"))).collect(Collectors.toList())) == null || eBankCheckFlag.size() <= 0) continue;
                    for (DynamicObject entry : eBankCheckFlag) {
                        LOGGER.info("updateBankJournals cas_exchangebill remove entry:{}", (Object)entry);
                        bankCheckEntity.remove((Object)entry);
                    }
                    continue;
                }
                if (!option) continue;
                DynamicObject entry = bankCheckEntity.addNew();
                entry.set("ebankcheckflag", (Object)flag);
            }
        }
    }
}

