/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.ebservice.service.query;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.bei.business.ebservice.request.QueryLinkPayRequestBuilder;
import kd.tmc.bei.business.ebservice.request.datasource.IEBRequestDataSource;
import kd.tmc.bei.business.ebservice.request.datasource.bankpay.BankPayRequestDataSource;
import kd.tmc.bei.business.ebservice.service.query.BankPayQueryService;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusDetail;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.data.EBResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.utils.BeServiceHelper;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayDetail;
import kd.tmc.fbp.webapi.ebentity.biz.querylinkpay.QueryLinkPayDetail;
import kd.tmc.fbp.webapi.ebentity.biz.querylinkpay.QueryLinkPayResponseBody;

public class BankLinkPayQueryService
extends BankPayQueryService {
    private static Log logger = LogFactory.getLog(BankLinkPayQueryService.class);
    private String batchSeqId;

    public BankLinkPayQueryService(List<DynamicObject> bankPayBillList, boolean isForceQuery) {
        super(bankPayBillList, isForceQuery);
        this.batchSeqId = bankPayBillList.get(0).getString("serialnumber");
    }

    @Override
    public IEBRequestBuilder getRequestBuilder() {
        return new QueryLinkPayRequestBuilder((IEBRequestDataSource)new BankPayRequestDataSource(this.batchSeqId, this.bankPayBillList));
    }

    @Override
    public void handleResultBody(String resultBody) {
        List<SyncStatusInfo> syncInfoList;
        QueryLinkPayResponseBody result = (QueryLinkPayResponseBody)JSON.parseObject((String)resultBody, QueryLinkPayResponseBody.class);
        List details = result.getDetails();
        if (details == null || details.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u72b6\u6001\u65f6\uff0c\u94f6\u4f01\u8fd4\u56de\u7684\u4ed8\u6b3e\u660e\u7ec6\u4e3a\u7a7a\u3002\u8be6\u60c5\u8bf7\u67e5\u770b\u540c\u6b65\u65e5\u5fd7\u3002", (String)"BankAgentPayQueryStragety_0", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                syncInfoList = this.handleDetails(details);
                SaveServiceHelper.save((DynamicObject[])this.bankPayBillList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        this.syncRemoteStatus(syncInfoList);
        EBResult ebResult = new EBResult();
        ebResult.setStatusCode(EBResultStatusCode.SUCCESS);
        ebResult.setErrMsg(null);
        this.setEbResult(ebResult);
    }

    protected List<SyncStatusInfo> handleDetails(List<QueryLinkPayDetail> details) {
        ArrayList<SyncStatusInfo> resultList = new ArrayList<SyncStatusInfo>(this.bankPayBillList.size());
        Map idToBankBillMap = this.bankPayBillList.stream().collect(Collectors.toMap(o -> o.getString("id"), Function.identity()));
        for (int i = 0; i < details.size(); ++i) {
            String ebStatusMsg;
            QueryLinkPayDetail detail = details.get(i);
            DynamicObject bankPayBill = (DynamicObject)idToBankBillMap.get(detail.getDetailSeqID());
            if (bankPayBill == null) continue;
            SyncStatusInfo syncInfo = new SyncStatusInfo();
            resultList.add(syncInfo);
            ArrayList<SyncStatusDetail> detailList = new ArrayList<SyncStatusDetail>(details.size());
            syncInfo.setDetailList(detailList);
            SyncStatusDetail syncDetail = new SyncStatusDetail();
            detailList.add(syncDetail);
            String srcBillType = bankPayBill.getString("srcbilltype");
            if (StringUtils.isEmpty((String)srcBillType)) {
                srcBillType = "cas_paybill";
            }
            syncInfo.setEntityType(srcBillType);
            BeBillStatusEnum entryStatus = BeServiceHelper.transferState((String)detail.getStatus());
            String oldState = bankPayBill.getString("bankpaystate");
            boolean needUpdateBankLogState = !oldState.equals(entryStatus.getValue());
            bankPayBill.set("bankpaystate", (Object)entryStatus.getValue());
            StringBuilder msgSb = new StringBuilder();
            if (StringUtils.isNotEmpty((String)detail.getStatusMsg())) {
                msgSb.append(detail.getStatusMsg());
            }
            if (StringUtils.isNotEmpty((String)(ebStatusMsg = msgSb.toString()))) {
                ebStatusMsg = ebStatusMsg.substring(0, Math.min(255, ebStatusMsg.length()));
            }
            bankPayBill.set("bankreturnmsg", (Object)ebStatusMsg);
            List payDetails = detail.getDetails();
            String left = "";
            String middle = "";
            String right = "";
            for (PayDetail oneDetail : payDetails) {
                String type = oneDetail.getType();
                if ("linkPay_transDown".equals(type) || "linkPay_native".equals(type)) {
                    left = oneDetail.getKdFlagID();
                }
                if ("linkPay_pay".equals(type)) {
                    middle = oneDetail.getKdFlagID();
                }
                if (!"linkPay_transUp".equals(type)) continue;
                right = oneDetail.getKdFlagID();
            }
            String flag = left + ";" + middle + ";" + right;
            bankPayBill.set("statementrefno", (Object)flag);
            syncInfo.setBatchSeqId(this.batchSeqId);
            syncInfo.setStatusCode(EBResultStatusCode.SUCCESS);
            syncInfo.setErrMsg(null);
            syncInfo.setBankBillId((Long)bankPayBill.getPkValue());
            syncInfo.setPayBillId(Long.valueOf(bankPayBill.getLong("sourcebillid")));
            syncInfo.setBankPayStatus(bankPayBill.getString("bankpaystate"));
            syncDetail.setEbStatusMsg(ebStatusMsg);
            if (srcBillType.equals("cas_paybill")) {
                if (payDetails.size() == 1) {
                    syncDetail.setBankDetailSeqId(left);
                } else {
                    syncDetail.setBankDetailSeqId(middle);
                }
            } else {
                syncDetail.setBankDetailSeqId(flag);
            }
            if (!needUpdateBankLogState) continue;
            this.updateBankLogWhenSync(bankPayBill, "bankpaystate");
        }
        return resultList;
    }
}

