/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.tmc.bei.business.helper.AutoMatchCalMultiHelper;
import kd.tmc.bei.business.helper.AutoMatchHelper;
import kd.tmc.bei.common.enums.AutoMatchFlagEnum;
import kd.tmc.bei.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.compare.result.CompareResult;
import kd.tmc.fbp.common.enums.MatchBizTypeEnum;
import kd.tmc.fbp.common.enums.MatchRelEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class AutoMatchHelper {
    private static Date doOpDate = DateUtils.getCurrentDate();
    private static final Log logger = LogFactory.getLog(AutoMatchHelper.class);
    private static final String MATCH_AMT = "matchAmount";
    private static final String UN_MATCH_AMT = "unMatchAmount";
    private static final String MATCH_FLAG = "matchFlag";
    private static final String MATCH_FLAG_MSG = "matchFlagMsg";

    public static boolean autoMatchByBizType(ListSelectedRowCollection selectRows, List<String> bizTypeList, String thisOpNumber, String direction) {
        ArrayList<MatchBizTypeEnum> bizTypeEnumList = new ArrayList<MatchBizTypeEnum>(bizTypeList.size());
        for (String bizType : bizTypeList) {
            MatchBizTypeEnum bizTypeEnum = MatchBizTypeEnum.getMatchBizTypeEnum((String)bizType);
            bizTypeEnumList.add(bizTypeEnum);
        }
        return AutoMatchHelper.autoMatch(selectRows, bizTypeEnumList, thisOpNumber, direction);
    }

    public static boolean autoMatch(ListSelectedRowCollection selectRows, List<MatchBizTypeEnum> bizTypeEnumList, String thisOpNumber, String direction) {
        if (selectRows == null || selectRows.size() <= 0) {
            return false;
        }
        HashSet<Object> companyPKs = new HashSet<Object>();
        List pkIds = selectRows.stream().map(row -> row.getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObject[] selObjs = BusinessDataServiceHelper.load((String)"bei_intelpay", (String)"id,company", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
        Map<Object, Object> orgRelationMap = Arrays.asList(selObjs).stream().collect(Collectors.toMap(o -> o.getPkValue(), o -> o.getDynamicObject("company").getPkValue(), (a, b) -> a));
        HashMap<Object, List<Object>> tdIdMap = new HashMap<Object, List<Object>>();
        for (ListSelectedRow row2 : selectRows) {
            Object companyId = orgRelationMap.get(row2.getPrimaryKeyValue());
            companyPKs.add(companyId);
            ArrayList<Object> tdIdList = (ArrayList<Object>)tdIdMap.get(companyId);
            if (tdIdList == null) {
                tdIdList = new ArrayList<Object>();
            }
            tdIdList.add(row2.getPrimaryKeyValue());
            tdIdMap.put(companyId, tdIdList);
        }
        boolean result = false;
        for (MatchBizTypeEnum matchBizTypeEnum : bizTypeEnumList) {
            if (!AutoMatchCalMultiHelper.isExistSmartRule(companyPKs, matchBizTypeEnum, direction)) continue;
            if (DateUtils.getCurrentDate().compareTo(doOpDate) >= 0) {
                ThreadPools.executeOnceIncludeRequestContext((String)"deleteHistoryData", () -> {
                    QFilter datefilter = new QFilter("createtime", "<", (Object)DateUtils.getCurrentDate());
                    DeleteServiceHelper.delete((String)"cas_autocalresult", (QFilter[])new QFilter[]{datefilter});
                    doOpDate = DateUtils.getNextDay((Date)DateUtils.getCurrentDate(), (int)1);
                });
            }
            if (selectRows.size() > 10000) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u8bb0\u5f55\u4e0d\u80fd\u8d85\u8fc7\u4e00\u4e07\u6761\u3002", (String)"AutoMatchHelper_01", (String)"tmc-bei-business", (Object[])new Object[0]));
            }
            List<Pair<Object, List<CompareResult>>> results = AutoMatchCalMultiHelper.autoMatchCal(companyPKs, tdIdMap, matchBizTypeEnum, direction);
            boolean dealResult = AutoMatchHelper.dealMatchResult(results, matchBizTypeEnum, thisOpNumber);
            result = result ? result : dealResult;
        }
        return result;
    }

    public static boolean autoMatch(ListSelectedRowCollection selectRows, MatchBizTypeEnum biztype, String thisOpnumber, String direction) {
        if (selectRows == null || selectRows.size() <= 0) {
            return false;
        }
        HashSet<Object> companyPKs = new HashSet<Object>();
        List pkIds = selectRows.stream().map(row -> row.getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObject[] selObjs = BusinessDataServiceHelper.load((String)"bei_intelpay", (String)"id,company", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
        Map<Object, Object> orgRelationMap = Arrays.asList(selObjs).stream().collect(Collectors.toMap(o -> o.getPkValue(), o -> o.getDynamicObject("company").getPkValue(), (a, b) -> a));
        HashMap<Object, List<Object>> tdIdMap = new HashMap<Object, List<Object>>();
        for (ListSelectedRow row2 : selectRows) {
            Object companyId = orgRelationMap.get(row2.getPrimaryKeyValue());
            companyPKs.add(companyId);
            ArrayList<Object> tdIdList = (ArrayList<Object>)tdIdMap.get(companyId);
            if (tdIdList == null) {
                tdIdList = new ArrayList<Object>();
            }
            tdIdList.add(row2.getPrimaryKeyValue());
            tdIdMap.put(companyId, tdIdList);
        }
        if (!AutoMatchCalMultiHelper.isExistSmartRule(companyPKs, biztype)) {
            return false;
        }
        if (DateUtils.getCurrentDate().compareTo(doOpDate) >= 0) {
            ThreadPools.executeOnceIncludeRequestContext((String)"deleteHistoryData", () -> {
                QFilter datefilter = new QFilter("createtime", "<", (Object)DateUtils.getCurrentDate());
                DeleteServiceHelper.delete((String)"cas_autocalresult", (QFilter[])new QFilter[]{datefilter});
                doOpDate = DateUtils.getNextDay((Date)DateUtils.getCurrentDate(), (int)1);
            });
        }
        if (selectRows.size() > 10000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u8bb0\u5f55\u4e0d\u80fd\u8d85\u8fc7\u4e00\u4e07\u6761\u3002", (String)"AutoMatchHelper_01", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        List<Pair<Object, List<CompareResult>>> results = AutoMatchCalMultiHelper.autoMatchCal(companyPKs, tdIdMap, biztype, direction);
        return AutoMatchHelper.dealMatchResult(results, biztype, thisOpnumber);
    }

    private static boolean dealMatchResult(List<Pair<Object, List<CompareResult>>> results, MatchBizTypeEnum biztype, String thisOpnumber) {
        if (results != null && results.size() > 0) {
            List matchRuleIdList = results.stream().map(item -> item.getLeft()).collect(Collectors.toList());
            DynamicObject[] smartMatchArr = BusinessDataServiceHelper.load((Object[])matchRuleIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_smartmatch"));
            Map smartMatchMap = Arrays.stream(smartMatchArr).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity(), (k1, k2) -> k1));
            ArrayList<DynamicObject> autoSaveList = new ArrayList<DynamicObject>();
            for (Pair<Object, List<CompareResult>> result : results) {
                List rs = (List)result.getRight();
                if (rs == null || rs.size() <= 0) continue;
                DynamicObject smartMatch = (DynamicObject)smartMatchMap.get(result.getLeft());
                DynamicObjectCollection matchEntrys = smartMatch.getDynamicObjectCollection("entryentity");
                boolean matchByEntry = matchEntrys.stream().anyMatch(item -> item.getBoolean("e_matchbyentry"));
                Map<Object, Object> bizBIllEntryMap = new HashMap<Object, Object>(16);
                if (matchByEntry) {
                    DynamicObjectCollection billEntryColl;
                    Set billEntryIdSet = rs.stream().map(item -> item.getTarIdSet()).flatMap(Collection::stream).collect(Collectors.toSet());
                    if (biztype == MatchBizTypeEnum.AGENTPAY) {
                        billEntryColl = QueryServiceHelper.query((String)"cas_agentpaybill", (String)"id,entry.id", (QFilter[])new QFilter[]{new QFilter("entry.id", "in", billEntryIdSet)});
                        bizBIllEntryMap = billEntryColl.stream().collect(Collectors.toMap(item -> item.get("entry.id"), item -> item.get("id")));
                    } else if (biztype == MatchBizTypeEnum.TRANSUP) {
                        billEntryColl = QueryServiceHelper.query((String)"fca_transupbill", (String)"id,entrys.id", (QFilter[])new QFilter[]{new QFilter("entrys.id", "in", billEntryIdSet)});
                        bizBIllEntryMap = billEntryColl.stream().collect(Collectors.toMap(item -> item.get("entrys.id"), item -> item.get("id")));
                    } else if (biztype == MatchBizTypeEnum.TRANSDOWN) {
                        billEntryColl = QueryServiceHelper.query((String)"fca_transdownbill", (String)"id,entrys.id", (QFilter[])new QFilter[]{new QFilter("entrys.id", "in", billEntryIdSet)});
                        bizBIllEntryMap = billEntryColl.stream().collect(Collectors.toMap(item -> item.get("entrys.id"), item -> item.get("id")));
                    }
                }
                Map<Object, List<CompareResult>> group = rs.stream().collect(Collectors.groupingBy(CompareResult::getRuleId));
                AutoMatchHelper.addAutoSaveList(biztype, thisOpnumber, autoSaveList, result, matchEntrys, bizBIllEntryMap, group);
            }
            if (autoSaveList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])autoSaveList.toArray(new DynamicObject[autoSaveList.size()]));
                return true;
            }
        }
        return false;
    }

    private static void addAutoSaveList(MatchBizTypeEnum biztype, String thisOpnumber, List<DynamicObject> autoSaveList, Pair<Object, List<CompareResult>> result, DynamicObjectCollection matchEntrys, Map<Object, Object> bizBIllEntryMap, Map<Object, List<CompareResult>> group) {
        for (Map.Entry<Object, List<CompareResult>> compareEntry : group.entrySet()) {
            Object ruleId = compareEntry.getKey();
            List<CompareResult> compareResults = compareEntry.getValue();
            DynamicObject matchEntry = matchEntrys.stream().filter(v -> ruleId.equals(v.get("id"))).findFirst().get();
            String matchRel = matchEntry.getString("e_matchrel");
            int seq = matchEntry.getInt("seq");
            MatchRelEnum matchRelEnum = MatchRelEnum.getByValue((String)matchRel);
            List<DynamicObject> autoSaveObj = null;
            switch (1.$SwitchMap$kd$tmc$fbp$common$enums$MatchRelEnum[matchRelEnum.ordinal()]) {
                case 1: {
                    autoSaveObj = AutoMatchHelper.createOneToOneAutoSaveObj(thisOpnumber, compareResults, ruleId, seq, biztype, result.getLeft(), matchEntry.getBoolean("e_matchbyentry"), bizBIllEntryMap);
                    break;
                }
                case 2: 
                case 3: {
                    autoSaveObj = AutoMatchHelper.createNotOneToOneAutoSaveObj(thisOpnumber, compareResults, ruleId, seq, biztype, result.getLeft(), matchEntry.getBoolean("e_matchbyentry"), bizBIllEntryMap);
                }
            }
            if (null == autoSaveObj) continue;
            autoSaveList.addAll(autoSaveObj);
        }
    }

    private static List<DynamicObject> createNotOneToOneAutoSaveObj(String thisOpnumber, List<CompareResult> compareResults, Object ruleId, int entrySeq, MatchBizTypeEnum biztype, Object smartMatch, boolean matchByEntry, Map<Object, Object> bizBIllEntryMap) {
        int seq = 1;
        ArrayList<DynamicObject> autoSaveList = new ArrayList<DynamicObject>(10);
        for (CompareResult compareResult : compareResults) {
            DynamicObject autoSaveObj = BusinessDataServiceHelper.newDynamicObject((String)"cas_autocalresult");
            Long pk = DB.genLongId((String)EntityMetadataCache.getDataEntityType((String)"cas_autocalresult").getAlias());
            autoSaveObj.set("id", (Object)pk);
            autoSaveObj.set("number", (Object)thisOpnumber);
            autoSaveObj.set("name", (Object)String.valueOf(pk));
            autoSaveObj.set("matchstatus", (Object)"0");
            autoSaveObj.set("smartmatch", smartMatch);
            autoSaveObj.set("createtime", (Object)new Date());
            autoSaveObj.set("ruleentry", ruleId);
            autoSaveObj.set("entryseq", (Object)entrySeq);
            DynamicObjectCollection entry = autoSaveObj.getDynamicObjectCollection("entryentity");
            for (Object srcId : compareResult.getSrcIdSet()) {
                DynamicObject r1 = entry.addNew();
                r1.set("seq", (Object)seq++);
                r1.set("record", (Object)"0");
                r1.set("billid", srcId);
            }
            for (Object tarId : compareResult.getTarIdSet()) {
                DynamicObject r2 = entry.addNew();
                r2.set("seq", (Object)seq++);
                String record = biztype.getRecord();
                r2.set("record", (Object)record);
                Object billId = tarId;
                r2.set("billid", billId);
                if (!matchByEntry) continue;
                r2.set("billentryid", billId);
                billId = bizBIllEntryMap.get(billId);
                r2.set("billid", billId);
            }
            autoSaveList.add(autoSaveObj);
        }
        return autoSaveList;
    }

    private static List<DynamicObject> createOneToOneAutoSaveObj(String thisOpnumber, List<CompareResult> compareResults, Object ruleId, int seq, MatchBizTypeEnum biztype, Object smartMatch, boolean matchByEntry, Map<Object, Object> bizBIllEntryMap) {
        ArrayList<DynamicObject> autoSaveList = new ArrayList<DynamicObject>(10);
        for (CompareResult compareResult : compareResults) {
            DynamicObject autoSaveObj = BusinessDataServiceHelper.newDynamicObject((String)"cas_autocalresult");
            Long pk = DB.genLongId((String)EntityMetadataCache.getDataEntityType((String)"cas_autocalresult").getAlias());
            autoSaveObj.set("id", (Object)pk);
            autoSaveObj.set("number", (Object)thisOpnumber);
            autoSaveObj.set("name", (Object)String.valueOf(pk));
            autoSaveObj.set("matchstatus", (Object)"0");
            autoSaveObj.set("smartmatch", smartMatch);
            autoSaveObj.set("createtime", (Object)new Date());
            autoSaveObj.set("ruleentry", ruleId);
            autoSaveObj.set("entryseq", (Object)seq);
            DynamicObjectCollection entry = autoSaveObj.getDynamicObjectCollection("entryentity");
            DynamicObject r1 = entry.addNew();
            r1.set("seq", (Object)1);
            r1.set("record", (Object)"0");
            r1.set("billid", compareResult.getSrcIdSet().iterator().next());
            DynamicObject r2 = entry.addNew();
            r2.set("seq", (Object)2);
            String record = biztype.getRecord();
            r2.set("record", (Object)record);
            Object billId = compareResult.getTarIdSet().iterator().next();
            r2.set("billid", billId);
            if (matchByEntry) {
                r2.set("billentryid", billId);
                billId = bizBIllEntryMap.get(billId);
                r2.set("billid", billId);
            }
            autoSaveList.add(autoSaveObj);
        }
        return autoSaveList;
    }

    public static Map<String, Object> getMatchAmount(BigDecimal amount, BigDecimal matchAmount, BigDecimal unMatchAmount) {
        String matchFlag;
        if (amount == null) {
            amount = BigDecimal.ZERO;
        }
        if (matchAmount == null) {
            matchAmount = BigDecimal.ZERO;
        }
        if (unMatchAmount == null) {
            unMatchAmount = BigDecimal.ZERO;
        }
        HashMap<String, Object> tMatchResult = new HashMap<String, Object>(4);
        BigDecimal allAmount = matchAmount.add(unMatchAmount);
        BigDecimal tAmount = matchAmount.add(amount);
        tMatchResult.put(MATCH_AMT, tAmount);
        tMatchResult.put(MATCH_FLAG_MSG, "");
        if (allAmount.compareTo(tAmount) == 0) {
            matchFlag = AutoMatchFlagEnum.ALL.getValue();
        } else if (BigDecimal.ZERO.compareTo(tAmount) == 0) {
            matchFlag = AutoMatchFlagEnum.NONE.getValue();
        } else if (allAmount.abs().compareTo(tAmount.abs()) > 0 && (BigDecimal.ZERO.compareTo(allAmount) > 0 && BigDecimal.ZERO.compareTo(tAmount) > 0 || BigDecimal.ZERO.compareTo(allAmount) < 0 && BigDecimal.ZERO.compareTo(tAmount) < 0)) {
            matchFlag = AutoMatchFlagEnum.SOME.getValue();
        } else {
            logger.error("\u5339\u914d\u5f02\u5e38\u7684\u573a\u666f\uff0d\uff0damount\uff1a{},matchAmount:{},unMatchAmount:{}", new Object[]{amount, matchAmount, unMatchAmount});
            matchFlag = AutoMatchFlagEnum.ERROR.getValue();
            if (allAmount.abs().compareTo(tAmount.abs()) < 0 && (BigDecimal.ZERO.compareTo(allAmount) > 0 && BigDecimal.ZERO.compareTo(tAmount) > 0 || BigDecimal.ZERO.compareTo(allAmount) < 0 && BigDecimal.ZERO.compareTo(tAmount) < 0)) {
                logger.error("\u603b\u91d1\u989d\u548c\u5df2\u5339\u914d\u91d1\u989d\u540c\u53f7\uff0c\u540c\u4e3a\u6b63\u6216\u540c\u4e3a\u8d1f\uff0c\u8d85\u989d\u5339\u914d");
                tMatchResult.put(MATCH_FLAG_MSG, ResManager.loadKDString((String)"\u8d85\u989d\u5339\u914d\u3002", (String)"AutoMatchHelper_02", (String)"tmc-bei-business", (Object[])new Object[0]));
            } else {
                logger.error("\u5339\u914d\u5f02\u5e38");
                tMatchResult.put(MATCH_FLAG_MSG, ResManager.loadKDString((String)"\u5339\u914d\u5f02\u5e38\u3002", (String)"AutoMatchHelper_03", (String)"tmc-bei-business", (Object[])new Object[0]));
            }
        }
        tMatchResult.put(UN_MATCH_AMT, unMatchAmount.subtract(amount));
        tMatchResult.put(MATCH_FLAG, matchFlag);
        return tMatchResult;
    }

    public static Map<String, Object> getMatchAmount(BigDecimal amount, BigDecimal matchAmount, BigDecimal unMatchAmount, Boolean isRelateOtherFlow, BigDecimal oMatchAmount, BigDecimal oUnMatchAmount) {
        Map<String, Object> tMatchResult = AutoMatchHelper.getMatchAmount(amount, matchAmount, unMatchAmount);
        if (tMatchResult != null) {
            if (isRelateOtherFlow.booleanValue()) {
                if (AutoMatchFlagEnum.ALL.getValue().equals(tMatchResult.get(MATCH_FLAG))) {
                    if (BigDecimal.ZERO.compareTo(oUnMatchAmount) != 0) {
                        tMatchResult.put(MATCH_FLAG, AutoMatchFlagEnum.SOME.getValue());
                    }
                } else if (AutoMatchFlagEnum.NONE.getValue().equals(tMatchResult.get(MATCH_FLAG)) && BigDecimal.ZERO.compareTo(oMatchAmount) != 0) {
                    tMatchResult.put(MATCH_FLAG, AutoMatchFlagEnum.SOME.getValue());
                }
            } else if (BigDecimal.ZERO.compareTo(oMatchAmount) != 0) {
                tMatchResult.put(MATCH_FLAG, AutoMatchFlagEnum.ERROR.getValue());
                if (matchAmount.add(unMatchAmount).abs().compareTo(oMatchAmount.abs()) < 0 && BigDecimal.ZERO.compareTo(matchAmount.add(unMatchAmount).multiply(oMatchAmount)) < 0) {
                    tMatchResult.put(MATCH_FLAG_MSG, ResManager.loadKDString((String)"\u8d85\u989d\u5339\u914d\u3002", (String)"AutoMatchHelper_02", (String)"tmc-bei-business", (Object[])new Object[0]));
                } else {
                    tMatchResult.put(MATCH_FLAG_MSG, ResManager.loadKDString((String)"\u672c\u5355\u5b9e\u9645\u65e0\u9700\u5173\u8054\u5bf9\u65b9\u6d41\u6c34\uff0c\u4f46\u5df2\u5b58\u5728\u5bf9\u65b9\u6d41\u6c34\u5173\u8054\u8bb0\u5f55\u3002", (String)"AutoMatchHelper_04", (String)"tmc-bei-business", (Object[])new Object[0]));
                }
            }
        }
        return tMatchResult;
    }

    public static QFilter getBankCheckFlagFilter(MatchBizTypeEnum biztype, boolean isAutoMatch) {
        QFilter bankcheckflagFilter = null;
        String cp = null;
        QFilter entryNullQFilter = QFilter.isNull((String)"bankcheckentity.ebankcheckflag");
        if (isAutoMatch) {
            cp = "=";
        } else {
            cp = "!=";
            entryNullQFilter = QFilter.isNotNull((String)"bankcheckentity.ebankcheckflag");
        }
        if (MatchBizTypeEnum.REC == biztype) {
            bankcheckflagFilter = entryNullQFilter;
        } else if (MatchBizTypeEnum.PAY == biztype) {
            bankcheckflagFilter = entryNullQFilter;
        } else if (MatchBizTypeEnum.AGENTPAY == biztype) {
            bankcheckflagFilter = entryNullQFilter;
        } else if (MatchBizTypeEnum.TRANSUP == biztype) {
            bankcheckflagFilter = new QFilter("entrys.bankcheckflag", cp, (Object)" ");
        } else if (MatchBizTypeEnum.TRANSDOWN == biztype) {
            bankcheckflagFilter = new QFilter("entrys.bankcheckflag", cp, (Object)" ");
        } else if (MatchBizTypeEnum.TRANSHANDLE == biztype) {
            bankcheckflagFilter = new QFilter("beibankcheckflag", cp, (Object)" ");
        }
        return bankcheckflagFilter;
    }

    public static QFilter getBankCheckFlagFilter(MatchBizTypeEnum biztype, Set<String> tBankCheckFlags) {
        QFilter bankcheckflagFilter = null;
        if (MatchBizTypeEnum.REC == biztype) {
            bankcheckflagFilter = new QFilter("bankcheckentity.ebankcheckflag", "in", tBankCheckFlags);
        } else if (MatchBizTypeEnum.PAY == biztype) {
            bankcheckflagFilter = new QFilter("bankcheckentity.ebankcheckflag", "in", tBankCheckFlags);
        } else if (MatchBizTypeEnum.AGENTPAY == biztype) {
            bankcheckflagFilter = new QFilter("bankcheckentity.ebankcheckflag", "in", tBankCheckFlags);
        } else if (MatchBizTypeEnum.TRANSUP == biztype) {
            bankcheckflagFilter = new QFilter("entrys.bankcheckflag", "in", tBankCheckFlags);
        } else if (MatchBizTypeEnum.TRANSDOWN == biztype) {
            bankcheckflagFilter = new QFilter("entrys.bankcheckflag", "in", tBankCheckFlags);
        } else if (MatchBizTypeEnum.TRANSHANDLE == biztype) {
            bankcheckflagFilter = new QFilter("beibankcheckflag", "in", tBankCheckFlags);
        }
        return bankcheckflagFilter;
    }

    public static QFilter getBillFilter(MatchBizTypeEnum biztype, boolean isAutoMatch, Set<Object> accountIdSet, Set<String> oppBankBumberSet, Set<Object> currencyIdSet, Date enableDate, String direction) {
        return AutoMatchHelper.getBillFilter(biztype, isAutoMatch, accountIdSet, oppBankBumberSet, currencyIdSet, enableDate, direction, true);
    }

    public static QFilter getBillFilter(MatchBizTypeEnum biztype, boolean isAutoMatch, Set<Object> accountIdSet, Set<String> oppBankBumberSet, Set<Object> currencyIdSet, Date enableDate, String direction, boolean entryMatch) {
        QFilter matchFlagFilter;
        QFilter tBillFilter = null;
        String accountBankProperty = null;
        String accountBankNumberProp = null;
        String currencyProp = null;
        String bizDateProperty = null;
        if (MatchBizTypeEnum.REC == biztype) {
            tBillFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.CHARGEBANK.getValue());
            accountBankProperty = "accountbank";
            bizDateProperty = "bizdate";
            currencyProp = "currency";
            if (isAutoMatch) {
                if ("pay".equals(direction)) {
                    accountBankNumberProp = "accountbank.bankaccountnumber";
                    accountBankProperty = "payeracctbank";
                    tBillFilter.and("relateotherflow", "=", (Object)"1").and("matchflag", "in", Arrays.asList(AutoMatchFlagEnum.NONE.getValue(), AutoMatchFlagEnum.SOME.getValue())).and("unmatchamountpay", "!=", (Object)0);
                } else {
                    accountBankNumberProp = "payeracctbanknum";
                    matchFlagFilter = new QFilter("relateotherflow", "=", (Object)"1").and("matchflag", "in", Arrays.asList(AutoMatchFlagEnum.NONE.getValue(), AutoMatchFlagEnum.SOME.getValue()));
                    matchFlagFilter.or(new QFilter("relateotherflow", "=", (Object)"0").and("matchflag", "=", (Object)AutoMatchFlagEnum.NONE.getValue()));
                    tBillFilter.and(matchFlagFilter);
                    tBillFilter.and(new QFilter("matchamountrec", "!=", (Object)"actrecamt", true));
                }
            } else {
                tBillFilter.and("matchflag", "in", Arrays.asList(AutoMatchFlagEnum.NONE.getValue(), AutoMatchFlagEnum.SOME.getValue()));
            }
        } else if (MatchBizTypeEnum.PAY == biztype) {
            tBillFilter = new QFilter("billstatus", "not in", Arrays.asList(BillStatusEnum.CHARGEBANK.getValue(), BillStatusEnum.DEAD.getValue(), BillStatusEnum.DRAFTING.getValue())).and("entrustorg", "=", (Object)0);
            accountBankProperty = "payeracctbank";
            bizDateProperty = "bizdate";
            currencyProp = "dpcurrency";
            if (isAutoMatch) {
                if ("rec".equals(direction)) {
                    accountBankNumberProp = "payeracctbank.bankaccountnumber";
                    accountBankProperty = "payeeacctbank";
                    tBillFilter.and("relateotherflow", "=", (Object)"1").and("matchflag", "in", Arrays.asList(AutoMatchFlagEnum.NONE.getValue(), AutoMatchFlagEnum.SOME.getValue())).and("unmatchamountrec", "!=", (Object)0);
                } else {
                    accountBankNumberProp = "payeebanknum";
                    matchFlagFilter = new QFilter("relateotherflow", "=", (Object)"1").and("matchflag", "in", Arrays.asList(AutoMatchFlagEnum.NONE.getValue(), AutoMatchFlagEnum.SOME.getValue()));
                    matchFlagFilter.or(new QFilter("relateotherflow", "=", (Object)"0").and("matchflag", "=", (Object)AutoMatchFlagEnum.NONE.getValue()));
                    tBillFilter.and(matchFlagFilter);
                    tBillFilter.and(new QFilter("matchamountpay", "!=", (Object)"actpayamt", true));
                }
            } else {
                tBillFilter.and("matchflag", "in", Arrays.asList(AutoMatchFlagEnum.NONE.getValue(), AutoMatchFlagEnum.SOME.getValue()));
            }
        } else if (MatchBizTypeEnum.AGENTPAY == biztype) {
            tBillFilter = new QFilter("billstatus", "not in", Arrays.asList(BillStatusEnum.CHARGEBANK.getValue(), BillStatusEnum.DEAD.getValue()));
            accountBankProperty = "payeracctbank";
            bizDateProperty = "bizdate";
            if (isAutoMatch) {
                tBillFilter.and("ismatchbyhead", "=", (Object)"0");
                if (entryMatch) {
                    tBillFilter.and("matchflag", "in", Arrays.asList(AutoMatchFlagEnum.NONE.getValue(), AutoMatchFlagEnum.SOME.getValue())).and("entry.entrymatchflag", "=", (Object)AutoMatchFlagEnum.NONE.getValue());
                } else {
                    tBillFilter.and("matchflag", "=", (Object)AutoMatchFlagEnum.NONE.getValue());
                }
            } else {
                tBillFilter.and("matchflag", "in", Arrays.asList(AutoMatchFlagEnum.NONE.getValue(), AutoMatchFlagEnum.SOME.getValue()));
            }
        } else if (MatchBizTypeEnum.TRANSUP == biztype || MatchBizTypeEnum.TRANSDOWN == biztype) {
            tBillFilter = new QFilter("billstatus", "!=", (Object)"S").and("entrys.state", "=", (Object)"normal").and(QFilter.isNull((String)"entrys.matchresult").or("entrys.matchresult", "=", (Object)"0")).and("matchflag", "in", Arrays.asList(AutoMatchFlagEnum.NONE.getValue(), AutoMatchFlagEnum.SOME.getValue()));
            accountBankProperty = "accountbank";
            bizDateProperty = "transbilldate";
            if (isAutoMatch) {
                tBillFilter.and("ismatchbyhead", "=", (Object)"0").and("entrys.entrymatchflag", "=", (Object)AutoMatchFlagEnum.NONE.getValue());
            }
        } else if (MatchBizTypeEnum.TRANSHANDLE == biztype) {
            tBillFilter = new QFilter("paidstatus", "!=", (Object)"C").and("matchflag", "=", (Object)AutoMatchFlagEnum.NONE.getValue());
            accountBankProperty = "agentpayeraccount";
            bizDateProperty = "bizdate";
        } else if (MatchBizTypeEnum.EXCHANGE == biztype) {
            tBillFilter = new QFilter("rec".equals(direction) ? "buymatchflag" : "sellmatchflag", "in", Arrays.asList(AutoMatchFlagEnum.NONE.getValue(), AutoMatchFlagEnum.SOME.getValue()));
            accountBankProperty = "rec".equals(direction) ? "buyingaccount" : "sellingaccount";
            bizDateProperty = "bizdate";
        }
        if (tBillFilter != null) {
            if (accountIdSet != null && !accountIdSet.isEmpty()) {
                tBillFilter.and(new QFilter(accountBankProperty, "in", accountIdSet));
            }
            if (enableDate != null) {
                tBillFilter.and(new QFilter(bizDateProperty, ">=", (Object)enableDate));
            }
            if (MatchBizTypeEnum.REC == biztype && "pay".equals(direction) || MatchBizTypeEnum.PAY == biztype && "rec".equals(direction)) {
                if (EmptyUtil.isNoEmpty(oppBankBumberSet)) {
                    QFilter acctBnakFilter = new QFilter("virtualentity.virtualaccount", "in", oppBankBumberSet);
                    DynamicObjectCollection acctBanks = QueryServiceHelper.query((String)"am_accountbank", (String)"bankaccountnumber", (QFilter[])new QFilter[]{acctBnakFilter});
                    Set acctBankNumberSet = acctBanks.stream().map(o -> o.getString("bankaccountnumber")).collect(Collectors.toSet());
                    QFilter filter = new QFilter(accountBankNumberProp, "in", oppBankBumberSet);
                    if (EmptyUtil.isNoEmpty(acctBankNumberSet)) {
                        tBillFilter.and(filter.or(new QFilter(accountBankNumberProp, "in", acctBankNumberSet)));
                    } else {
                        tBillFilter.and(filter);
                    }
                }
                if (EmptyUtil.isNoEmpty(currencyIdSet)) {
                    tBillFilter.and(new QFilter(currencyProp, "in", currencyIdSet));
                }
            }
        }
        return tBillFilter;
    }

    public static QFilter getBillFilter(MatchBizTypeEnum biztype, boolean isAutoMatch, Set<Object> accountIdSet, Date enableDate) {
        return AutoMatchHelper.getBillFilter(biztype, isAutoMatch, accountIdSet, null, null, enableDate, null);
    }

    public static void setRecedBillEntry(DynamicObject transdetail, String recedbilltype, String recedbillnumber, Long recedbillid, Long recedbillentryid, String amttype, BigDecimal amount) {
        AutoMatchHelper.setRecedBillEntry(transdetail, recedbilltype, recedbillnumber, recedbillid, recedbillentryid, amttype, amount, " ", " ");
    }

    public static void setRecedBillEntry(DynamicObject transdetail, String recedbilltype, String recedbillnumber, Long recedbillid, Long recedbillentryid, String amttype, BigDecimal amount, String thisOpNumber, String direction) {
        if (!transdetail.getDataEntityType().getProperties().stream().anyMatch(o -> "recedbillentry".equals(o.getName()))) {
            DynamicObjectCollection entry = new DynamicObjectCollection(transdetail.getDynamicObjectType(), (Object)"recedbillentry");
            transdetail.set("recedbillentry", (Object)entry);
        }
        DynamicObjectCollection tRecedBillEntry = transdetail.getDynamicObjectCollection("recedbillentry");
        DynamicObject entry = tRecedBillEntry.addNew();
        entry.set("e_opnumber", (Object)thisOpNumber);
        entry.set("e_recedbilltype", (Object)recedbilltype);
        entry.set("e_recedbillnumber", (Object)recedbillnumber);
        entry.set("e_recedbillid", (Object)recedbillid);
        entry.set("e_amount", (Object)amount);
        entry.set("e_direction", (Object)direction);
        if (recedbillentryid != null && Long.compare(recedbillentryid, 0L) != 0) {
            entry.set("e_recedbillentryid", (Object)recedbillentryid);
        }
        if (amttype != null && amttype.trim().length() > 0) {
            entry.set("e_amttype", (Object)amttype);
        }
    }

    public static void deleteRecedBillEntry(DynamicObject transdetail) {
        transdetail.getDynamicObjectCollection("recedbillentry").clear();
    }

    public static void deleteRecedBillEntry(DynamicObject transdetail, Long recedbillid) {
        transdetail.getDynamicObjectCollection("recedbillentry").removeIf(o -> Long.compare(o.getLong("e_recedbillid"), recedbillid) == 0);
    }

    public static void deleteRecedBillEntry(DynamicObject transdetail, String recedbillnumber) {
        transdetail.getDynamicObjectCollection("recedbillentry").removeIf(o -> recedbillnumber != null && recedbillnumber.equals(o.getString("e_recedbillnumber")));
    }

    public static void deleteRecedBillEntry(DynamicObject transdetail, Long recedbillid, Long recedbillentryid) {
        transdetail.getDynamicObjectCollection("recedbillentry").removeIf(o -> Long.compare(o.getLong("e_recedbillid"), recedbillid) == 0 && Long.compare(o.getLong("e_recedbillentryid"), recedbillid) == 0);
    }

    public static void deleteRecedBillEntry(DynamicObject transdetail, Long recedbillid, String amttype) {
        transdetail.getDynamicObjectCollection("recedbillentry").removeIf(o -> Long.compare(o.getLong("e_recedbillid"), recedbillid) == 0 && amttype != null && amttype.equals(o.getString("e_amttype")));
    }

    public static List<DynamicObject> getRecedBillEntry(DynamicObject transdetail, Long recedbillid) {
        return transdetail.getDynamicObjectCollection("recedbillentry").stream().filter(o -> Long.compare(o.getLong("e_recedbillid"), recedbillid) == 0).collect(Collectors.toList());
    }

    public static List<DynamicObject> getRecedBillEntry(DynamicObject transdetail, String recedbillnumber) {
        return transdetail.getDynamicObjectCollection("recedbillentry").stream().filter(o -> recedbillnumber != null && recedbillnumber.equals(o.getString("e_recedbillnumber"))).collect(Collectors.toList());
    }

    public static DynamicObject getRecedBillEntry(DynamicObject transdetail, Long recedbillid, Long recedbillentryid) {
        return transdetail.getDynamicObjectCollection("recedbillentry").stream().filter(o -> Long.compare(o.getLong("e_recedbillid"), recedbillid) == 0 && Long.compare(o.getLong("e_recedbillentryid"), recedbillid) == 0).findFirst().get();
    }

    public static DynamicObject getRecedBillEntry(DynamicObject transdetail, Long recedbillid, String amttype) {
        return transdetail.getDynamicObjectCollection("recedbillentry").stream().filter(o -> Long.compare(o.getLong("e_recedbillid"), recedbillid) == 0 && amttype != null && amttype.equals(o.getString("e_amttype"))).findFirst().get();
    }

    public static void initMatchAmount(DynamicObject businessBill, Map<String, Object> tMatchResult, String matchAmountProp, String unMatchAmountProp, String matchFlagProp, String matchFlagMsgProp) {
        if (tMatchResult != null) {
            String entityName;
            businessBill.set(matchAmountProp, tMatchResult.get(MATCH_AMT));
            businessBill.set(unMatchAmountProp, tMatchResult.get(UN_MATCH_AMT));
            businessBill.set(matchFlagProp, tMatchResult.get(MATCH_FLAG));
            if (tMatchResult.containsKey(MATCH_FLAG_MSG) && matchFlagMsgProp != null && matchFlagMsgProp.trim().length() > 0) {
                businessBill.set(matchFlagMsgProp, tMatchResult.get(MATCH_FLAG_MSG));
            }
            if ("cas_paybill".equals(entityName = businessBill.getDataEntityType().getName())) {
                boolean isCashOut;
                boolean isCashIn;
                DynamicObject billType = businessBill.getDynamicObject("billtype");
                String businessType = businessBill.getString("businesstype");
                boolean relateOtherFlow = businessBill.getBoolean("relateotherflow");
                boolean bl = isCashIn = "cas_paybill_cash_BT_S".equals(billType.getString("number")) && "cashin".equals(businessType);
                if (isCashIn && relateOtherFlow) {
                    if (EmptyUtil.isEmpty((BigDecimal)businessBill.getBigDecimal("unmatchamountrec"))) {
                        businessBill.set(matchFlagProp, (Object)AutoMatchFlagEnum.ALL.getValue());
                    } else {
                        businessBill.set(matchFlagProp, (Object)AutoMatchFlagEnum.NONE.getValue());
                    }
                }
                boolean bl2 = isCashOut = "cas_paybill_cash_BT_S".equals(billType.getString("number")) && "cashout".equals(businessType);
                if (isCashOut) {
                    if (EmptyUtil.isEmpty((BigDecimal)businessBill.getBigDecimal("unmatchamountpay"))) {
                        businessBill.set(matchFlagProp, (Object)AutoMatchFlagEnum.ALL.getValue());
                    } else {
                        businessBill.set(matchFlagProp, (Object)AutoMatchFlagEnum.NONE.getValue());
                    }
                }
            }
        }
    }

    public static List<String> getRecedBillNumber(DynamicObjectCollection infos) {
        return AutoMatchHelper.getRecedBillNumber(infos.stream());
    }

    public static List<String> getRecedBillNumber(DynamicObject[] infos) {
        return AutoMatchHelper.getRecedBillNumber(Arrays.stream(infos));
    }

    private static List<String> getRecedBillNumber(Stream<DynamicObject> infos) {
        return infos.map(o -> o.getDynamicObjectCollection("recedbillentry")).flatMap(o -> o.stream().map(p -> p.getString("e_recedbillnumber"))).filter(o -> EmptyUtil.isNoEmpty((String)o)).distinct().collect(Collectors.toList());
    }

    public static List<String> getMatchFieldKeys() {
        return Arrays.asList("recedbillentry", "recedbillentry.e_recedbilltype", "recedbillentry.e_recedbillnumber", "recedbillentry.e_recedbillid", "recedbillentry.e_recedbillentryid", "recedbillentry.e_amttype", "recedbillentry.e_amount", "recedbillentry.e_opnumber", "recedbillentry.e_direction");
    }

    public static String getMatchFieldStringKeys() {
        return String.join((CharSequence)",", AutoMatchHelper.getMatchFieldKeys());
    }

    private static boolean releaseOrLockBills(boolean isLock, String billType, List<String> idList) {
        Map request = isLock ? MutexServiceHelper.batchRequest(idList, (String)billType, (String)"releaseOrLockBills") : MutexServiceHelper.batchRelease(idList, (String)billType, (String)"releaseOrLockBills");
        if (request.containsValue(Boolean.FALSE)) {
            logger.info("=================\u6570\u636e" + (isLock ? "\u9501\u5b9a" : "\u89e3\u9501") + "\u5f02\u5e38");
            request.entrySet().stream().filter(o -> (Boolean)o.getValue() == false).forEach(o -> logger.info("=================\u6570\u636e\u7c7b\u578b" + billType + "\uff0cID\uff1a" + (String)o.getKey()));
        }
        return !request.containsValue(Boolean.FALSE);
    }

    public static boolean releaseOrLockBills(boolean isLock, Map<String, List<String>> billMap) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(billMap.size());
        for (Map.Entry<String, List<String>> billEntry : billMap.entrySet()) {
            if (billEntry.getValue() == null || billEntry.getValue().size() <= 0) continue;
            result.put(billEntry.getKey(), AutoMatchHelper.releaseOrLockBills(isLock, billEntry.getKey(), billEntry.getValue()));
        }
        return !result.values().contains(Boolean.FALSE);
    }

    public static boolean releaseOrLockBills(boolean isLock, DynamicObject[] details, DynamicObject[] ... busnessBillArrays) {
        HashMap<String, List<String>> billMap = new HashMap<String, List<String>>(2);
        if (details != null && details.length > 0) {
            billMap.put(details[0].getDataEntityType().getName(), Arrays.stream(details).map(o -> o.getString("id")).collect(Collectors.toList()));
        }
        if (busnessBillArrays != null && busnessBillArrays.length > 0) {
            for (DynamicObject[] busnessBills : busnessBillArrays) {
                if (busnessBills == null || busnessBills.length < 1) continue;
                String tBillType = busnessBills[0].getDataEntityType().getName();
                if (billMap.containsKey(tBillType)) {
                    List tBillIdList = (List)billMap.get(tBillType);
                    tBillIdList.addAll(Arrays.stream(busnessBills).map(o -> o.getString("id")).collect(Collectors.toList()));
                    billMap.put(tBillType, tBillIdList);
                    continue;
                }
                billMap.put(tBillType, Arrays.stream(busnessBills).map(o -> o.getString("id")).collect(Collectors.toList()));
            }
        }
        if (billMap.size() > 0) {
            return AutoMatchHelper.releaseOrLockBills(isLock, billMap);
        }
        return true;
    }

    private static boolean checkCancelMatchToInit(List<Long> transDetailIds, String recedBillType, Long recedBillId) {
        if (transDetailIds == null) {
            return true;
        }
        QFilter tQFilter = new QFilter("recedbillentry.e_recedbillid", "=", (Object)recedBillId);
        tQFilter.and("recedbillentry.e_recedbilltype", "=", (Object)recedBillType);
        tQFilter.and("receredtype", "in", (Object)"1");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"id", (QFilter[])tQFilter.toArray());
        Set idList = collection.stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
        idList.removeAll(new HashSet<Long>(transDetailIds));
        return idList.isEmpty();
    }

    public static void initMatchAmountInCancelMatch(List<Long> transDetailIds, DynamicObject businessBill) {
        String recedBillType = businessBill.getDataEntityType().getName();
        Long recedBillId = businessBill.getLong("id");
        Map<String, Map<String, String>> tBillFieldMap = AutoMatchHelper.getBillFieldMap(recedBillType);
        if (AutoMatchHelper.checkCancelMatchToInit(transDetailIds, recedBillType, recedBillId) && tBillFieldMap != null && !tBillFieldMap.isEmpty()) {
            if (Arrays.asList("cas_paybill", "cas_recbill").contains(recedBillType)) {
                if (AutoMatchFlagEnum.ALL.getValue().equals(businessBill.getString("matchflag"))) {
                    tBillFieldMap.entrySet().forEach(o -> {
                        Map tFieldMap = (Map)o.getValue();
                        Map<String, Object> tMatchResult = AutoMatchHelper.getMatchAmount(BigDecimal.ZERO, BigDecimal.ZERO, businessBill.getBigDecimal((String)tFieldMap.get(MATCH_AMT)).add(businessBill.getBigDecimal((String)tFieldMap.get(UN_MATCH_AMT))));
                        AutoMatchHelper.initMatchAmount(businessBill, tMatchResult, (String)tFieldMap.get(MATCH_AMT), (String)tFieldMap.get(UN_MATCH_AMT), (String)tFieldMap.get(MATCH_FLAG), (String)tFieldMap.get(MATCH_FLAG_MSG));
                    });
                }
            } else if ("cas_agentpaybill".equals(recedBillType)) {
                Map<String, String> tFieldMap = tBillFieldMap.get("head");
                if (AutoMatchFlagEnum.ALL.getValue().equals(businessBill.getString(tFieldMap.get(MATCH_FLAG)))) {
                    Map<String, Object> tMatchResult = AutoMatchHelper.getMatchAmount(BigDecimal.ZERO, BigDecimal.ZERO, businessBill.getBigDecimal(tFieldMap.get(MATCH_AMT)).add(businessBill.getBigDecimal(tFieldMap.get(UN_MATCH_AMT))));
                    AutoMatchHelper.initMatchAmount(businessBill, tMatchResult, tFieldMap.get(MATCH_AMT), tFieldMap.get(UN_MATCH_AMT), tFieldMap.get(MATCH_FLAG), tFieldMap.get(MATCH_FLAG_MSG));
                    Map<String, String> tentryFieldMap = tBillFieldMap.get("entry");
                    businessBill.getDynamicObjectCollection("entry").forEach(o -> {
                        Map<String, Object> tMatchEntryResult = AutoMatchHelper.getMatchAmount(BigDecimal.ZERO, BigDecimal.ZERO, o.getBigDecimal((String)tentryFieldMap.get(MATCH_AMT)).add(o.getBigDecimal((String)tentryFieldMap.get(UN_MATCH_AMT))));
                        AutoMatchHelper.initMatchAmount(o, tMatchEntryResult, (String)tentryFieldMap.get(MATCH_AMT), (String)tentryFieldMap.get(UN_MATCH_AMT), (String)tentryFieldMap.get(MATCH_FLAG), (String)tentryFieldMap.get(MATCH_FLAG_MSG));
                    });
                }
            }
        }
    }

    public static List<String> getBillFieldList(String billtype) {
        Map<String, Map<String, String>> billFieldMap = AutoMatchHelper.getBillFieldMap(billtype);
        List<String> collect = billFieldMap.entrySet().stream().map(o -> ((Map)o.getValue()).entrySet()).flatMap(o -> o.stream()).map(o -> (String)o.getValue()).distinct().collect(Collectors.toList());
        if ("cas_exchangebill".equals(billtype)) {
            collect.add("matchflag");
        } else if ("cas_paybill".equals(billtype) || "cas_recbill".equals(billtype)) {
            collect.add("relateotherflow");
        }
        return collect;
    }

    private static Map<String, Map<String, String>> getBillFieldMap(String billtype) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(1);
        switch (billtype) {
            case "cas_paybill": {
                result.putAll(AutoMatchHelper.getFieldMap("bei_intelpay", "matchamountpay", "unmatchamountpay", "matchflag", "matchflagmsg"));
                result.putAll(AutoMatchHelper.getFieldMap("bei_intelrec", "matchamountrec", "unmatchamountrec", "matchflag", "matchflagmsg"));
                break;
            }
            case "cas_recbill": {
                result.putAll(AutoMatchHelper.getFieldMap("bei_intelrec", "matchamountrec", "unmatchamountrec", "matchflag", "matchflagmsg"));
                result.putAll(AutoMatchHelper.getFieldMap("bei_intelpay", "matchamountpay", "unmatchamountpay", "matchflag", "matchflagmsg"));
                break;
            }
            case "cas_agentpaybill": {
                result.putAll(AutoMatchHelper.getFieldMap("entry", "entrymatchamount", "entryunmatchamount", "entrymatchflag", "entrymatcherrmsg"));
                result.putAll(AutoMatchHelper.getFieldMap("head", "matchamount", "unmatchamount", "matchflag", "matcherrmsg"));
                break;
            }
            case "fca_transupbill": 
            case "fca_transdownbill": {
                result.putAll(AutoMatchHelper.getFieldMap("entrys", "entrymatchamount", "entryunmatchamount", "entrymatchflag", "entrymatcherrmsg"));
                result.putAll(AutoMatchHelper.getFieldMap("head", "matchamount", "unmatchamount", "matchflag", "matcherrmsg"));
                break;
            }
            case "ifm_transhandlebill": {
                result.putAll(AutoMatchHelper.getFieldMap("bei_intelpay", "matchamountpay", "unmatchamountpay", "matchflag", "matchflagmsg"));
                break;
            }
            case "cas_exchangebill": {
                result.putAll(AutoMatchHelper.getFieldMap("buy", "buymatchamount", "buyunmatchamount", "buymatchflag", "buymatchflagmsg"));
                result.putAll(AutoMatchHelper.getFieldMap("sell", "sellmatchamount", "sellunmatchamount", "sellmatchflag", "sellmatchflagmsg"));
                result.putAll(AutoMatchHelper.getFieldMap("fee", "feematchamount", "feeunmatchamount", "feematchflag", "feematchflagmsg"));
            }
        }
        return result;
    }

    private static Map<String, Map<String, String>> getFieldMap(String headProp, String matchAmountProp, String unMatchAmountProp, String matchFlagProp, String matchFlagMsgProp) {
        HashMap<String, String> fieldMap = new HashMap<String, String>(4);
        if (matchAmountProp != null && matchAmountProp.trim().length() > 0) {
            fieldMap.put(MATCH_AMT, matchAmountProp);
        }
        if (unMatchAmountProp != null && unMatchAmountProp.trim().length() > 0) {
            fieldMap.put(UN_MATCH_AMT, unMatchAmountProp);
        }
        if (matchFlagProp != null && matchFlagProp.trim().length() > 0) {
            fieldMap.put(MATCH_FLAG, matchFlagProp);
        }
        if (matchFlagMsgProp != null && matchFlagMsgProp.trim().length() > 0) {
            fieldMap.put(MATCH_FLAG_MSG, matchFlagMsgProp);
        }
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>(1);
        resultMap.put(headProp != null ? headProp.trim() : "", fieldMap);
        return resultMap;
    }
}

