/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.sdk.tmc.bei.extpoint.claim.INoticeClaimSchemeInterface;
import kd.tmc.bei.common.enums.ClaimStatusEnum;
import kd.tmc.bei.common.helper.BeiHelper;
import kd.tmc.bei.common.param.ClaimNoticeMesParam;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RecClaimHelper {
    private static final Log logger = LogFactory.getLog(RecClaimHelper.class);

    public static DynamicObject[] getAuditNotConfirm(Object[] ids) {
        QFilter filter = new QFilter("id", "in", (Object)ids).and("claimstatus", "=", (Object)ClaimStatusEnum.CLAIMED.getValue());
        Object[] claimNoticeBills = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id,billno", (QFilter[])new QFilter[]{filter});
        if (!EmptyUtil.isEmpty((Object[])claimNoticeBills)) {
            return claimNoticeBills;
        }
        return null;
    }

    public static DynamicObject[] getClaimNoticeConfirm(Object[] ids) {
        QFilter filter = new QFilter("id", "in", (Object)ids).and(new QFilter("claimstatus", "!=", (Object)ClaimStatusEnum.SURE.getValue()));
        Object[] claimNoticeBills = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id,claimstatus", (QFilter[])new QFilter[]{filter});
        if (!EmptyUtil.isEmpty((Object[])claimNoticeBills)) {
            return claimNoticeBills;
        }
        return null;
    }

    public static boolean checkEnableUserExist(Map<String, Object> noticeData) {
        List userIds = (List)noticeData.get("userids");
        List groupIds = (List)noticeData.get("usergroupids");
        List orgIds = (List)noticeData.get("orgids");
        List roleIds = (List)noticeData.get("roleids");
        if (EmptyUtil.isNoEmpty((Object)userIds)) {
            Map enableMap = UserServiceHelper.isUserEnable(userIds.stream().map(userId -> Long.valueOf(userId.toString())).collect(Collectors.toList()));
            return enableMap.values().stream().anyMatch(Boolean.TRUE::equals);
        }
        if (EmptyUtil.isNoEmpty((Object)groupIds)) {
            DynamicObjectCollection userGroups = QueryServiceHelper.query((String)"fbd_usergroup", (String)"entryentity.userfield", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)groupIds).and("enable", "=", (Object)"1")}, null);
            List groupUserIds = userGroups.stream().map(o -> o.getLong("entryentity.userfield")).collect(Collectors.toList());
            Map enableMap = UserServiceHelper.isUserEnable(groupUserIds);
            return enableMap.values().stream().anyMatch(Boolean.TRUE::equals);
        }
        if (EmptyUtil.isNoEmpty((Object)orgIds) && EmptyUtil.isNoEmpty((Object)roleIds)) {
            Set orgUserIds = UserServiceHelper.getAllUsersOfOrg((int)0, orgIds.stream().map(org -> Long.valueOf(org.toString())).collect(Collectors.toList()), (boolean)true, (boolean)false);
            List roleUserIds = new ArrayList();
            for (Object roleId : roleIds) {
                roleUserIds.addAll(PermissionServiceHelper.getUsersByRoleID((String)String.valueOf(roleId)));
            }
            roleUserIds = roleUserIds.stream().filter(orgUserIds::contains).collect(Collectors.toCollection(ArrayList::new));
            Map enableMap = UserServiceHelper.isUserEnable(roleUserIds);
            return enableMap.values().stream().anyMatch(Boolean.TRUE::equals);
        }
        if (EmptyUtil.isNoEmpty((Object)orgIds) && EmptyUtil.isEmpty((Collection)roleIds)) {
            Set orgUserIds = UserServiceHelper.getAllUsersOfOrg((int)0, orgIds.stream().map(org -> Long.valueOf(org.toString())).collect(Collectors.toList()), (boolean)true, (boolean)false);
            Map enableMap = UserServiceHelper.isUserEnable(new ArrayList(orgUserIds));
            return enableMap.values().stream().anyMatch(Boolean.TRUE::equals);
        }
        if (EmptyUtil.isNoEmpty((Object)roleIds) && EmptyUtil.isEmpty((Collection)orgIds)) {
            ArrayList roleUserIds = new ArrayList();
            for (Object roleId : roleIds) {
                roleUserIds.addAll(PermissionServiceHelper.getUsersByRoleID((String)String.valueOf(roleId)));
            }
            Map enableMap = UserServiceHelper.isUserEnable(new ArrayList(roleUserIds));
            return enableMap.values().stream().anyMatch(Boolean.TRUE::equals);
        }
        return false;
    }

    public static List<Long> sendClaimNoticeMessage(Map<Object, Map<String, List<Object>>> claimTypeMap, String noticeType) {
        ArrayList<Long> messIds;
        block20: {
            HashSet allUserId;
            HashMap ruleList;
            block21: {
                messIds = new ArrayList<Long>();
                if (EmptyUtil.isEmpty(claimTypeMap)) break block20;
                Map<String, List<Object>> typeValue = null;
                ruleList = new HashMap(claimTypeMap.size());
                allUserId = new HashSet();
                for (Map.Entry<Object, Map<String, List<Object>>> rule : claimTypeMap.entrySet()) {
                    int i;
                    typeValue = rule.getValue();
                    List<Object> userGroupids = typeValue.get("usergroupids");
                    List<Object> orgids = typeValue.get("orgids");
                    List<Object> list = typeValue.get("roleids");
                    List<Object> userids = typeValue.get("userids");
                    HashSet<Object> userIds = new HashSet<Object>();
                    if (!EmptyUtil.isEmpty(userGroupids)) {
                        for (i = 0; i < userGroupids.size(); ++i) {
                            Object userGroupId = userGroupids.get(i) instanceof String && !StringUtils.isBlank((Object)userGroupids.get(i)) ? Long.valueOf((String)userGroupids.get(i)) : userGroupids.get(i);
                            DynamicObjectCollection userGroups = QueryServiceHelper.query((String)"fbd_usergroup", (String)"entryentity.userfield", (QFilter[])new QFilter[]{new QFilter("id", "=", userGroupId).and("enable", "=", (Object)"1")}, null);
                            List groupUserIds = userGroups.stream().map(o -> o.getLong("entryentity.userfield")).collect(Collectors.toList());
                            Map enableMap = UserServiceHelper.isUserEnable(groupUserIds);
                            List enableIds = enableMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
                            userIds.addAll(enableIds);
                        }
                    }
                    if (!EmptyUtil.isEmpty((Collection)orgids) && !EmptyUtil.isEmpty(list)) {
                        Set orguserids = UserServiceHelper.getAllUsersOfOrg((int)0, orgids.stream().map(org -> Long.valueOf(org.toString())).collect(Collectors.toList()), (boolean)true, (boolean)false);
                        List roleuserids = new ArrayList();
                        for (int i2 = 0; i2 < list.size(); ++i2) {
                            roleuserids.addAll(PermissionServiceHelper.getUsersByRoleID((String)String.valueOf(list.get(i2))));
                        }
                        roleuserids = roleuserids.stream().filter(l -> orguserids.contains(l)).collect(Collectors.toCollection(ArrayList::new));
                        userIds.addAll(roleuserids);
                    } else if (!EmptyUtil.isEmpty((Collection)orgids) && EmptyUtil.isEmpty(list)) {
                        userIds.addAll(UserServiceHelper.getAllUsersOfOrg((int)0, orgids.stream().map(org -> Long.valueOf(org.toString())).collect(Collectors.toList()), (boolean)true, (boolean)false));
                    } else if (!EmptyUtil.isEmpty(list) && EmptyUtil.isEmpty((Collection)orgids)) {
                        for (i = 0; i < list.size(); ++i) {
                            List roleUserIds = PermissionServiceHelper.getUsersByRoleID((String)String.valueOf(list.get(i)));
                            Map enableMap = UserServiceHelper.isUserEnable((List)roleUserIds);
                            List enableIds = enableMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
                            userIds.addAll(enableIds);
                        }
                    }
                    if (!EmptyUtil.isEmpty(userids)) {
                        userIds.addAll(userids.stream().filter(EmptyUtil::isNoEmpty).map(u -> Long.valueOf(u.toString())).collect(Collectors.toList()));
                    }
                    ruleList.put(rule.getKey(), userIds);
                    allUserId.addAll(userIds);
                }
                if (!StringUtils.equals((CharSequence)"cancel", (CharSequence)noticeType)) break block21;
                Object param = null;
                Map<String, List<Object>> claimType = null;
                List<Object> noticeMes = null;
                for (Map.Entry entry : ruleList.entrySet()) {
                    MessageInfo messageInfo = new MessageInfo();
                    messageInfo.setTag(ResManager.loadKDString((String)"\u6536\u4ed8\u8ba4\u9886", (String)"ClaimRecWorkbenchPlugin_11", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    claimType = claimTypeMap.get(entry.getKey());
                    noticeMes = claimType.get("title");
                    if (!EmptyUtil.isEmpty((Collection)noticeMes)) {
                        messageInfo.setTitle((String)noticeMes.get(0));
                    }
                    if (!EmptyUtil.isEmpty(noticeMes = claimType.get("content"))) {
                        messageInfo.setContent((String)noticeMes.get(0));
                    }
                    String billType = (String)claimType.get("billtype").get(0);
                    messageInfo.setUserIds(new ArrayList((Collection)entry.getValue()));
                    messageInfo.setType("message");
                    String billFormId = "bei_intelpay_list".equals(billType) ? "bei_intelpay" : "bei_intelrec";
                    messageInfo.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=" + billFormId + "&type=list&list_formId=" + billType);
                    messIds.add(MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo));
                }
                break block20;
            }
            if (!StringUtils.equals((CharSequence)"notice", (CharSequence)noticeType)) break block20;
            HashMap<Long, Integer> userCount = new HashMap<Long, Integer>(ruleList.size());
            int count = 0;
            for (Long userId : allUserId) {
                count = 0;
                for (Set set : ruleList.values()) {
                    if (!set.contains(userId)) continue;
                    ++count;
                }
                userCount.put(userId, count);
            }
            HashMap noticeUsers = new HashMap(userCount.size());
            HashSet users = null;
            for (Map.Entry user : userCount.entrySet()) {
                users = (HashSet)noticeUsers.get(user.getValue());
                if (EmptyUtil.isEmpty((Collection)users)) {
                    users = new HashSet();
                }
                users.add(user.getKey());
                noticeUsers.put(user.getValue(), users);
            }
            Object var10_17 = null;
            List detailList = ruleList.keySet().stream().map(e -> Long.valueOf(e.toString())).collect(Collectors.toList());
            DynamicObjectCollection details = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"claimnoticebillno,creditamount,debitamount,bizdate,oppunit,billno,currency.sign currencysign", (QFilter[])new QFilter("id", "in", detailList).toArray());
            StringBuilder msgContent = new StringBuilder();
            msgContent.append(ResManager.loadKDString((String)"\u8bf7\u8fdb\u5165PC\u7aef\u201c\u6536\u4ed8\u8ba4\u9886->\u8ba4\u9886\u516c\u544a\u201d\u83dc\u5355,\u6216\u70b9\u51fb\u4ee5\u4e0b\u94fe\u63a5\u8fdb\u884c\u5904\u7406\u3002", (String)"RecClaimHelper_0", (String)"tmc-bei-business", (Object[])new Object[0]));
            for (DynamicObject detail : details) {
                msgContent.append("\n");
                BigDecimal recAmount = detail.getBigDecimal("creditamount");
                BigDecimal payAmount = detail.getBigDecimal("debitamount");
                String claimBillNo = detail.getString("claimnoticebillno");
                String bizType = recAmount.compareTo(BigDecimal.ZERO) != 0 ? ResManager.loadKDString((String)"\u6536\u6b3e", (String)"RecClaimHelper_1", (String)"tmc-bei-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed8\u6b3e", (String)"RecClaimHelper_2", (String)"tmc-bei-business", (Object[])new Object[0]);
                BigDecimal amount = recAmount.compareTo(BigDecimal.ZERO) != 0 ? recAmount : payAmount;
                String amountStr = BeiHelper.formatDecimal((BigDecimal)amount, (int)2);
                String msg = String.format(ResManager.loadKDString((String)"\u8ba4\u9886\u901a\u77e5\u5355\uff1a%1$s\uff0c%2$s\u91d1\u989d\uff1a%3$s%4$s\uff0c\u5bf9\u65b9\u6237\u540d\uff1a%5$s\uff0c\u4ea4\u6613\u65f6\u95f4\uff1a%6$s\uff0c\u4ea4\u6613\u660e\u7ec6\u7f16\u53f7\uff1a%7$s\u3002", (String)"RecClaimHelper_3", (String)"tmc-bei-business", (Object[])new Object[0]), claimBillNo, bizType, detail.get("currencysign"), amountStr, detail.getString("oppunit"), DateUtils.formatString((Date)detail.getDate("bizdate"), (String)"yyyy-MM-dd"), detail.getString("billno"));
                msgContent.append(msg);
            }
            for (Map.Entry notice : noticeUsers.entrySet()) {
                ClaimNoticeMesParam claimNoticeMesParam = new ClaimNoticeMesParam();
                claimNoticeMesParam.setTag(ResManager.loadKDString((String)"\u6536\u4ed8\u8ba4\u9886", (String)"RecClaimHelper_4", (String)"tmc-bei-business", (Object[])new Object[0]));
                claimNoticeMesParam.setTitle(ResManager.loadKDString((String)"%s\u7b14\u6b3e\u9879\u9700\u8981\u8ba4\u9886\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406", (String)"RecClaimHelper_5", (String)"tmc-bei-business", (Object[])new Object[]{notice.getKey()}));
                claimNoticeMesParam.setContent(msgContent.toString());
                claimNoticeMesParam.setUserIds((Set)notice.getValue());
                claimNoticeMesParam.setNoticeType(noticeType);
                messIds.add(RecClaimHelper.sendNoticeMessage(claimNoticeMesParam));
            }
        }
        return messIds;
    }

    public static Long sendNoticeMessage(ClaimNoticeMesParam param) {
        MessageInfo message = new MessageInfo();
        message.setTag(param.getTag());
        message.setTitle(param.getTitle());
        message.setContent(param.getContent());
        if (StringUtils.equals((CharSequence)"reject", (CharSequence)param.getNoticeType())) {
            message.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=cas_claimbill&pkId=" + param.getPkId());
            message.setMobContentUrl(UrlService.getDomainContextUrl() + "/mobile.html?form=cas_claimbill_m&app=tr&pkId=" + param.getPkId());
            message.setType("casmessage");
        } else if (StringUtils.equals((CharSequence)"notice", (CharSequence)param.getNoticeType())) {
            message.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=cas_claimannounce&type=list&list_formId=cas_claim");
            String accountId = RequestContext.get().getAccountId();
            String url = String.format("%s/mobile.html?form=cas_claimnotice_m&app=tr&accountId=%s", UrlService.getDomainContextUrl(), accountId);
            message.setMobContentUrl(url);
            message.setType("casmessage");
        } else if (StringUtils.equals((CharSequence)"pay", (CharSequence)param.getNoticeType())) {
            message.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=bei_bankpaybill&pkId=" + param.getPkId());
            message.setType("message");
        } else if (StringUtils.equals((CharSequence)"agentpay", (CharSequence)param.getNoticeType())) {
            message.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=bei_bankagentpay&pkId=" + param.getPkId());
            message.setType("message");
        } else if (StringUtils.equals((CharSequence)"chargeback", (CharSequence)param.getNoticeType())) {
            message.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=cas_claimcenterbill&pkId=" + param.getPkId());
            message.setType("casmessage");
        } else if (StringUtils.equals((CharSequence)"payInfoChg", (CharSequence)param.getNoticeType())) {
            message.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=cas_paychgbill&type=list&list_formId=bos_list");
            message.setType("message");
        }
        message.setUserIds(new ArrayList(param.getUserIds()));
        StringBuilder notifyType = new StringBuilder();
        message.setNotifyType(notifyType.toString());
        return MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }

    public static void updateClaimStatus(String claimNo, Set<String> noUpdateBillNos, String updateStatus) {
        if (EmptyUtil.isNoEmpty((String)claimNo) && EmptyUtil.isNoEmpty((String)updateStatus)) {
            Object[] colls;
            QFilter qFilter = new QFilter("claimno", "=", (Object)claimNo);
            if (EmptyUtil.isNoEmpty(noUpdateBillNos)) {
                qFilter.and(new QFilter("billno", "not in", noUpdateBillNos));
            }
            if (EmptyUtil.isNoEmpty((Object[])(colls = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,claimstatus", (QFilter[])new QFilter[]{qFilter})))) {
                DynamicObject[] dys = new DynamicObject[colls.length];
                Object dynamicObject = null;
                for (int i = 0; i < colls.length; ++i) {
                    dynamicObject = colls[i];
                    if (StringUtils.equals((CharSequence)updateStatus, (CharSequence)dynamicObject.getString("claimstatus"))) {
                        return;
                    }
                    dynamicObject.set("claimstatus", (Object)updateStatus);
                    dys[i] = dynamicObject;
                }
                SaveServiceHelper.save((DynamicObject[])dys);
            }
        }
    }

    public static List<DynamicObject> getAllChildNoticeBill(Object noticePk) {
        ArrayList<DynamicObject> childNoticeSet = new ArrayList<DynamicObject>();
        if (EmptyUtil.isNoEmpty((Object)noticePk)) {
            DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)noticePk, (String)"cas_claimcenterbill");
            Object[] childNotices = RecClaimHelper.getChildNoticeBill(loadSingle.getPkValue());
            if (EmptyUtil.isNoEmpty((Object[])childNotices)) {
                for (Object dynamicObject : childNotices) {
                    childNoticeSet.addAll(RecClaimHelper.getAllChildNoticeBill(dynamicObject.getPkValue()));
                }
            } else {
                childNoticeSet.add(loadSingle);
            }
        }
        return childNoticeSet;
    }

    public static DynamicObject[] getChildNoticeBill(Object noticePk) {
        QFilter margeid = new QFilter("margeid", "=", noticePk);
        return BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id", (QFilter[])new QFilter[]{margeid});
    }

    public static Map<String, Object> getNoticeObjectExt(Map<String, Object> data, String bizType) {
        data.put("isneednotice", true);
        PluginProxy pluginProxy = PluginProxy.create(INoticeClaimSchemeInterface.class, (String)"kd.sdk.tmc.bei.extpoint.claim.INoticeClaimSchemeInterface");
        List resultList = bizType.equals("claim") ? pluginProxy.callReplace(p -> p.noticeObjectExtByRule(data)) : pluginProxy.callReplace(p -> p.cancelNoticeObjectExt(data));
        if (EmptyUtil.isNoEmpty((Object)resultList) && EmptyUtil.isNoEmpty(resultList.get(0))) {
            logger.info("NoticeClaimService.getNoticeObjectExt:" + resultList.get(0));
            return (Map)resultList.get(0);
        }
        logger.info("INoticeClaimSchemeInterface.noticeObjectExt result is empty");
        return data;
    }
}

