/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.tmc.bei.common.enums.AsstActTypeEnum;
import kd.tmc.bei.common.enums.DataTypeEnum;
import kd.tmc.fbp.common.builder.FormulaGetHandle;
import kd.tmc.fbp.common.builder.ISingleTaskContext;
import kd.tmc.fbp.common.builder.SingleTaskContext;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class RecPayRuleHelper {
    private static final Log LOGGER = LogFactory.getLog(RecPayRuleHelper.class);
    private static final String UP_BILL = "upbill";
    private static final String DOWN_BILL = "downbill";
    private static final String EMPTY_REGEX = "\\s+";
    private static final String SYMBOL_REGEX = "[^\\p{L}\\p{N}\\u4e00-\\u9fff]";

    public static Map<Long, Pair<String, Map<String, Object>>> getBillNameByMatchRuleApiFill(Object[] ids, String type, boolean isThrowErr, OperationResult result) {
        HashMap<Long, Pair<String, Map<String, Object>>> pairHashMap = new HashMap<Long, Pair<String, Map<String, Object>>>(ids.length);
        if (StringUtils.isBlank((CharSequence)type) || EmptyUtil.isEmpty((Object[])ids)) {
            return null;
        }
        List list = Arrays.asList(ids).stream().map(o -> Long.valueOf(o.toString())).collect(Collectors.toList());
        DynamicObjectCollection billConFieldConfigs = QueryServiceHelper.query((String)"cas_billconvertfieldcfg", (String)"billtype, datatype, extendname, tarfieldname", null);
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject rule;
            HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>();
            Long aLong = (Long)list.get(i);
            QFilter filter = new QFilter("id", "=", (Object)aLong);
            DynamicObjectCollection detailAllDys = RecPayRuleHelper.getBankDetailDy(fldProperties, new QFilter[]{filter});
            if (detailAllDys == null) {
                pairHashMap.put(aLong, (Pair<String, Map<String, Object>>)Pair.of((Object)type, new HashMap(8)));
                continue;
            }
            String entityName = "rec".equals(type) ? "bei_intelrec" : "bei_intelpay";
            DynamicObject transDetail = QueryServiceHelper.queryOne((String)entityName, (String)"rulename", (QFilter[])new QFilter("id", "=", (Object)aLong).toArray());
            String ruleName = transDetail.getString("rulename");
            if (StringUtils.isNotBlank((CharSequence)ruleName)) {
                DynamicObjectCollection entryentity;
                List ruleEntry;
                QFilter qFilter;
                QFilter commonFilter = RecPayRuleHelper.getRuleCommonFilter((DynamicObject)detailAllDys.get(0), type, false);
                rule = BusinessDataServiceHelper.loadSingle((String)"cas_recpayrule", (QFilter[])new QFilter[]{commonFilter, qFilter = new QFilter("entryentity.e_rulesname", "=", (Object)ruleName)});
                if (rule == null) {
                    QFilter comFilter = RecPayRuleHelper.getRuleCommonFilter((DynamicObject)detailAllDys.get(0), type, true);
                    rule = BusinessDataServiceHelper.loadSingle((String)"cas_recpayrule", (QFilter[])new QFilter[]{comFilter, qFilter});
                }
                if (rule != null && EmptyUtil.isNoEmpty(ruleEntry = (entryentity = rule.getDynamicObjectCollection("entryentity")).stream().filter(e -> ruleName.equals(e.getString("e_rulesname")) && "rule".equals(e.getString("e_handlescheme"))).collect(Collectors.toList()))) {
                    DynamicObject matchRule = (DynamicObject)ruleEntry.get(0);
                    String billType = matchRule.getString("e_handlebill");
                    if (UP_BILL.equals(billType) || DOWN_BILL.equals(billType)) {
                        pairHashMap.put(aLong, (Pair<String, Map<String, Object>>)Pair.of((Object)billType, RecPayRuleHelper.getFillInfo(type, matchRule, (DynamicObject)detailAllDys.get(0), isThrowErr, result)));
                    } else {
                        pairHashMap.put(aLong, (Pair<String, Map<String, Object>>)Pair.of((Object)type, RecPayRuleHelper.getFillInfo(type, matchRule, (DynamicObject)detailAllDys.get(0), isThrowErr, result)));
                    }
                    RecPayRuleHelper.fillConvertFields(pairHashMap, aLong, billConFieldConfigs, matchRule);
                    continue;
                }
            } else {
                rule = RecPayRuleHelper.getMatchingRule((DynamicObject)detailAllDys.get(0), type, "rule", false);
            }
            if (EmptyUtil.isEmpty((DynamicObject)rule)) {
                pairHashMap.put(aLong, (Pair<String, Map<String, Object>>)Pair.of((Object)type, new HashMap(8)));
                continue;
            }
            DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryentity)) {
                pairHashMap.put(aLong, (Pair<String, Map<String, Object>>)Pair.of((Object)type, new HashMap(8)));
                continue;
            }
            String bill = null;
            boolean isMatch = false;
            for (int j = 0; j < entryentity.size(); ++j) {
                DynamicObject entryrule = (DynamicObject)entryentity.get(j);
                if (!"rule".equals(entryrule.getString("e_handlescheme")) || (bill = RecPayRuleHelper.matchRuleBill(entryrule, (DynamicObject)detailAllDys.get(0), fldProperties)) == null) continue;
                isMatch = true;
                if (UP_BILL.equals(bill) || DOWN_BILL.equals(bill)) {
                    pairHashMap.put(aLong, (Pair<String, Map<String, Object>>)Pair.of((Object)bill, RecPayRuleHelper.getFillInfo(type, entryrule, (DynamicObject)detailAllDys.get(0), isThrowErr, result)));
                } else {
                    pairHashMap.put(aLong, (Pair<String, Map<String, Object>>)Pair.of((Object)type, RecPayRuleHelper.getFillInfo(type, entryrule, (DynamicObject)detailAllDys.get(0), isThrowErr, result)));
                }
                RecPayRuleHelper.fillConvertFields(pairHashMap, aLong, billConFieldConfigs, entryrule);
                break;
            }
            if (isMatch) continue;
            pairHashMap.put(aLong, (Pair<String, Map<String, Object>>)Pair.of((Object)type, new HashMap(8)));
        }
        return pairHashMap;
    }

    private static void fillConvertFields(Map<Long, Pair<String, Map<String, Object>>> pairHashMap, Long aLong, DynamicObjectCollection billConFieldConfigs, DynamicObject entryrule) {
        Pair<String, Map<String, Object>> rulMapPair = pairHashMap.get(aLong);
        Map ruleMap = (Map)rulMapPair.getValue();
        String entryRuleBillType = entryrule.getString("e_handlebill");
        billConFieldConfigs.stream().forEach(ruleEntityFieldConfig -> {
            if (ruleEntityFieldConfig.getString("billtype").equals(entryRuleBillType)) {
                Object value;
                String extendName = ruleEntityFieldConfig.getString("extendname");
                String tarFieldName = ruleEntityFieldConfig.getString("tarfieldname");
                int dataType = ruleEntityFieldConfig.getInt("datatype");
                if (entryrule.containsProperty(extendName) && EmptyUtil.isNoEmpty((Object)(value = entryrule.get(extendName))) && DataTypeEnum.getDataTypeByOrdinal((int)dataType) != null) {
                    ruleMap.put(tarFieldName, DataTypeEnum.convertValue((int)DataTypeEnum.getDataTypeByOrdinal((int)dataType).ordinal, (Object)value));
                }
            }
        });
    }

    private static boolean isMatchFcaDefaultRule(DynamicObject dynamicObject) {
        if (EmptyUtil.isEmpty((DynamicObject)dynamicObject)) {
            return false;
        }
        Long company = dynamicObject.getLong("company.id");
        Long account = dynamicObject.getLong("accountbank.id");
        String sonAcct = dynamicObject.getString("oppbanknumber");
        if (EmptyUtil.isEmpty((Long)company) || EmptyUtil.isEmpty((Long)account) || EmptyUtil.isEmpty((String)sonAcct)) {
            return false;
        }
        boolean isUnAcctGroup = RecPayRuleHelper.getFcaParameterBoolean(company, "isunacctgroup");
        return isUnAcctGroup ? RecPayRuleHelper.isUnAcctGroup(account, sonAcct) : RecPayRuleHelper.unAcctGroup(account, sonAcct);
    }

    private static boolean unAcctGroup(Long acctId, String sonAcct) {
        DynamicObject acct = BusinessDataServiceHelper.loadSingle((Object)acctId, (String)"bd_accountbanks", (String)"createorg");
        if (EmptyUtil.isEmpty((DynamicObject)acct)) {
            return false;
        }
        DynamicObject[] son = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)sonAcct)});
        if (son == null || son.length == 0) {
            return false;
        }
        DynamicObject[] acctGroup = BusinessDataServiceHelper.load((String)"fca_acctgroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("accountbank", "=", (Object)acctId)});
        if (acctGroup == null || acctGroup.length == 0) {
            return false;
        }
        List ids = Arrays.stream(acctGroup).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        DynamicObject[] acctGroups = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fca_acctgroup"));
        boolean flag = false;
        for (DynamicObject dynamicObject2 : acctGroups) {
            DynamicObjectCollection sons = dynamicObject2.getDynamicObjectCollection("entrys");
            Set sonIds = sons.stream().map(e -> e.getDynamicObject("bankacct").getLong("id")).collect(Collectors.toSet());
            if (!sonIds.contains(son[0].getLong("id"))) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean isUnAcctGroup(Long acctId, String sonAcct) {
        DynamicObject acct = BusinessDataServiceHelper.loadSingle((Object)acctId, (String)"bd_accountbanks", (String)"createorg");
        if (EmptyUtil.isEmpty((DynamicObject)acct)) {
            return false;
        }
        DynamicObject org = acct.getDynamicObject("createorg");
        DynamicObject[] group = BusinessDataServiceHelper.load((String)"fca_acctgroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("company", "=", (Object)org.getLong("id"))});
        if (group == null || group.length == 0) {
            return false;
        }
        DynamicObject[] son = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)sonAcct)});
        if (son == null || son.length == 0) {
            return false;
        }
        DynamicObject[] acctGroup = BusinessDataServiceHelper.load((String)"fca_acctgroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("entrys.bankacct", "=", (Object)son[0].getLong("id"))});
        return acctGroup != null && acctGroup.length != 0;
    }

    private static boolean getFcaParameterBoolean(long orgId, String key) {
        AppParam appParam = new AppParam();
        appParam.setOrgId(Long.valueOf(orgId));
        appParam.setViewType("08");
        appParam.setAppId("/WJL3RFSDXE9");
        Object value = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)key);
        if (value == null) {
            return false;
        }
        return value instanceof Boolean ? ((Boolean)value).booleanValue() : "true".equals(value);
    }

    private static Map<String, Object> getFillInfo(String type, DynamicObject entryRule, DynamicObject detail, boolean isThrowErr, OperationResult result) {
        String e_remark;
        Object payerValue;
        HashMap<String, Object> ruleMap = new HashMap<String, Object>(8);
        if ("rec".equals(type)) {
            String e_payertype = entryRule.getString("e_payertype");
            ruleMap.put("e_receivingtype", entryRule.getDynamicObject("e_receivingtype"));
            ruleMap.put("e_payertype", e_payertype);
            String e_payer = entryRule.getString("e_payer");
            if (!EmptyUtil.isEmpty((String)e_payer)) {
                ruleMap.put("e_payer", e_payer);
            }
            if (!EmptyUtil.isEmpty((Object)(payerValue = RecPayRuleHelper.dealPayerValue(detail, entryRule, isThrowErr, result)))) {
                ruleMap.put("e_payer", payerValue);
            }
        }
        if ("pay".equals(type)) {
            String payeetype = entryRule.getString("e_payeetype");
            ruleMap.put("e_paymenttype", entryRule.getDynamicObject("e_paymenttype"));
            ruleMap.put("e_payeetype", payeetype);
            String e_recer = entryRule.getString("e_recer");
            if (!EmptyUtil.isEmpty((String)e_recer)) {
                ruleMap.put("e_recer", e_recer);
            }
            if (!EmptyUtil.isEmpty((Object)(payerValue = RecPayRuleHelper.dealPayerValue(detail, entryRule, isThrowErr, result)))) {
                ruleMap.put("e_recer", payerValue);
            }
        }
        String e_rulesname = entryRule.getString("e_rulesname");
        ruleMap.put("e_rulesname", e_rulesname);
        DynamicObject e_fundflowitem = entryRule.getDynamicObject("e_fundflowitem");
        if (!EmptyUtil.isEmpty((DynamicObject)e_fundflowitem)) {
            ruleMap.put("e_fundflowitem", entryRule.getDynamicObject("e_fundflowitem"));
        }
        if (!EmptyUtil.isEmpty((String)(e_remark = entryRule.getString("e_remark")))) {
            ruleMap.put("e_remark", entryRule.getString("e_remark"));
        }
        return ruleMap;
    }

    private static DynamicObjectCollection getBankDetailDy(Map<String, DynamicProperty> fldProperties, QFilter[] filters) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"bei_transdetail_cas");
        ArrayList<String> selProps = new ArrayList<String>();
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            String propName;
            if (StringUtils.isBlank((CharSequence)property.getAlias()) || (propName = property.getName()).contains("_id")) continue;
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                DataEntityPropertyCollection bdProperties = bdProp.getComplexType().getProperties();
                for (IDataEntityProperty prop : bdProperties) {
                    if (StringUtils.isBlank((CharSequence)prop.getAlias()) || prop.getName().contains("_id")) continue;
                    String secPropName = propName + "." + prop.getName();
                    if (prop instanceof BasedataProp) {
                        BasedataProp tProp = (BasedataProp)prop;
                        DataEntityPropertyCollection tProperties = tProp.getComplexType().getProperties();
                        for (IDataEntityProperty tp : tProperties) {
                            if (StringUtils.isBlank((CharSequence)tp.getAlias()) || tp.getName().contains("_id")) continue;
                            selProps.add(secPropName + "." + tp.getName());
                        }
                        continue;
                    }
                    selProps.add(secPropName);
                }
                continue;
            }
            selProps.add(propName);
        }
        String selectString = StringUtils.join((Object[])selProps.toArray(new Object[selProps.size()]), (String)",");
        DynamicObjectCollection rows = null;
        DataSet dsn = QueryServiceHelper.queryDataSet((String)RecPayRuleHelper.class.getName(), (String)"bei_transdetail_cas", (String)selectString, (QFilter[])filters, null);
        Object object = null;
        try {
            rows = ORM.create().toPlainDynamicObjectCollection(dsn);
        }
        catch (Throwable bdProperties) {
            object = bdProperties;
            throw bdProperties;
        }
        finally {
            if (dsn != null) {
                if (object != null) {
                    try {
                        dsn.close();
                    }
                    catch (Throwable bdProperties) {
                        ((Throwable)object).addSuppressed(bdProperties);
                    }
                } else {
                    dsn.close();
                }
            }
        }
        if (rows != null && !rows.isEmpty() && fldProperties != null) {
            DynamicObjectType dType = rows.getDynamicObjectType();
            for (String prop : selProps) {
                fldProperties.put(prop, dType.getProperty(prop));
            }
        }
        int rowsize = rows == null ? 0 : rows.size();
        LOGGER.info("\u5f97\u5230\u8f6c\u6362\u540e\u7684\u4ea4\u6613\u660e\u7ec6\u6570\u91cf\u4e3a: " + rowsize + "");
        return rows;
    }

    private static String matchRuleBill(DynamicObject entryrule, DynamicObject detailDy, Map<String, DynamicProperty> fldProperties) {
        String bill = null;
        String filterStr = entryrule.getString("e_datafilter_TAG");
        if (!EmptyUtil.isEmpty((String)filterStr)) {
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"bei_transdetail_cas");
            String baseFilterStr = filterObj.buildFullFormula(mainEntityType);
            SingleTaskContext taskContext = new SingleTaskContext();
            taskContext.setSrcEntityType(mainEntityType);
            if (!"".equals(baseFilterStr)) {
                try {
                    FormulaGetHandle basebillFilterHandle = new FormulaGetHandle((ISingleTaskContext)taskContext, baseFilterStr, (Object)Boolean.FALSE);
                    Boolean baseBoolean = (Boolean)basebillFilterHandle.GetVchFldValue(fldProperties, detailDy, null);
                    if (baseBoolean.booleanValue()) {
                        bill = entryrule.getString("e_handlebill");
                    }
                }
                catch (Exception ee) {
                    LOGGER.info("\u5339\u914d\u5f02\u5e38\uff0c%s", (Object)ee.toString());
                }
            } else {
                bill = entryrule.getString("e_handlebill");
            }
        } else {
            bill = entryrule.getString("e_handlebill");
        }
        if (bill != null && (UP_BILL.equals(bill) || DOWN_BILL.equals(bill)) && !RecPayRuleHelper.isMatchFcaDefaultRule(detailDy)) {
            return null;
        }
        return bill;
    }

    private static DynamicObject getMatchingRule(DynamicObject detailAllDys, String type, String dealBizType, boolean isWriteBack) {
        QFilter ruleCommonFilter = RecPayRuleHelper.getRuleCommonFilter(detailAllDys, type, false, dealBizType, isWriteBack);
        DynamicObject rule = BusinessDataServiceHelper.loadSingle((String)"cas_recpayrule", (QFilter[])new QFilter[]{ruleCommonFilter});
        if (EmptyUtil.isEmpty((DynamicObject)rule)) {
            ruleCommonFilter = RecPayRuleHelper.getRuleCommonFilter(detailAllDys, type, true, dealBizType, isWriteBack);
            rule = BusinessDataServiceHelper.loadSingle((String)"cas_recpayrule", (QFilter[])new QFilter[]{ruleCommonFilter});
        }
        return rule;
    }

    private static QFilter getRuleCommonFilter(DynamicObject detailDy, String type, Boolean isFaceAllOrg, String dealBizType, Boolean isWriteBack) {
        Object company = detailDy.get("company.id");
        QFilter filter = new QFilter("biztype", "=", (Object)type).and(new QFilter("enable", "=", (Object)"1"));
        if (!isWriteBack.booleanValue() && !"pay".equals(type)) {
            filter.and(new QFilter("entryentity.e_handlescheme", "=", (Object)dealBizType));
        }
        if (!isFaceAllOrg.booleanValue()) {
            filter.and(new QFilter("org_entry.u_org", "=", company));
        } else {
            filter.and(QFilter.isNull((String)"org_entry.u_org").or("org_entry.u_org", "=", null));
        }
        return filter;
    }

    private static QFilter getRuleCommonFilter(DynamicObject detailDy, String type, Boolean isFaceAllOrg) {
        Object company = detailDy.get("company.id");
        QFilter filter = new QFilter("biztype", "=", (Object)type).and(new QFilter("enable", "=", (Object)"1")).and(new QFilter("entryentity.e_handlescheme", "=", (Object)"rule"));
        if (!isFaceAllOrg.booleanValue()) {
            filter.and(new QFilter("org_entry.u_org", "=", company));
        } else {
            filter.and(QFilter.isNull((String)"org_entry.u_org").or("org_entry.u_org", "=", null));
        }
        return filter;
    }

    private static Object dealPayerValue(DynamicObject detailDO, DynamicObject entryrule, boolean isThrowErr, OperationResult result) {
        String filterStr = entryrule.getString("e_datafilter_TAG");
        if (!EmptyUtil.isEmpty((String)filterStr) && (filterStr.contains("IsCustomer") || filterStr.contains("IsSupplier"))) {
            Long companyId;
            String oppunitName;
            Object pkValue;
            DynamicObject detailDY;
            Object dealId;
            String entityName = AsstActTypeEnum.CUSTOMER.getValue();
            String entityNameStr = AsstActTypeEnum.CUSTOMER.getName();
            if (filterStr.contains("IsSupplier")) {
                entityName = AsstActTypeEnum.SUPPLIER.getValue();
                entityNameStr = AsstActTypeEnum.SUPPLIER.getName();
            }
            if ((dealId = RecPayRuleHelper.dealCustomerOrSupplier(entityName, detailDY = QueryServiceHelper.queryOne((String)"bei_transdetail_cas", (String)"company.id,oppunit,oppbanknumber,billno", (QFilter[])new QFilter("id", "=", pkValue = detailDO.get("id")).toArray()), oppunitName = detailDY.getString("oppunit"), companyId = Long.valueOf(detailDY.getLong("company.id")))) != null) {
                return dealId;
            }
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\uff08\u7f16\u53f7\uff1a%1$s\uff09\u751f\u5355\u5931\u8d25\uff0c\u201c%2$s\u201d%3$s\u57fa\u7840\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"RecPayRuleHelper_0", (String)"tmc-bei-business", (Object[])new Object[0]), detailDY.getString("billno"), oppunitName, entityNameStr);
            RecPayRuleHelper.doException(detailDO, errorMsg, isThrowErr, result);
        }
        return null;
    }

    private static Object dealCustomerOrSupplier(String oppType, DynamicObject detail, String matchingText, Long orgId) {
        DynamicObjectCollection customerOrSupplier;
        String oppBankNumber;
        QFilter baseFilter = new QFilter("enable", "=", (Object)"1");
        baseFilter.and("status", "=", (Object)"C");
        if (EmptyUtil.isNoEmpty((DynamicObject)detail) && EmptyUtil.isNotEmpty((CharSequence)(oppBankNumber = detail.getString("oppbanknumber")))) {
            long companyId = detail.getLong("company.id");
            customerOrSupplier = BaseDataServiceHelper.queryBaseData((String)oppType, (Long)companyId, (QFilter)new QFilter("entry_bank.bankaccount", "=", (Object)oppBankNumber).and(baseFilter), (String)"id,entry_bank.accountname");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)customerOrSupplier) && customerOrSupplier.size() == 1) {
                return ((DynamicObject)customerOrSupplier.get(0)).get("id");
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)customerOrSupplier) && customerOrSupplier.size() > 1) {
                if (EmptyUtil.isNoEmpty((String)matchingText)) {
                    List filterNameData = customerOrSupplier.stream().filter(s -> matchingText.equals(s.getString("entry_bank.accountname"))).collect(Collectors.toList());
                    if (EmptyUtil.isNoEmpty(filterNameData) && filterNameData.size() == 1) {
                        return ((DynamicObject)filterNameData.get(0)).get("id");
                    }
                    String cleanedString = matchingText.replaceAll(EMPTY_REGEX, "").replaceAll(SYMBOL_REGEX, "");
                    LOGGER.info("kd.tmc.bei.business.helper.RecPayRuleHelper.dealCustomerOrSupplier#cleanedString:{}", (Object)cleanedString);
                    List nameMatchList = customerOrSupplier.stream().filter(s -> EmptyUtil.isNotEmpty((CharSequence)s.getString("entry_bank.accountname")) && cleanedString.equalsIgnoreCase(s.getString("entry_bank.accountname").replaceAll(EMPTY_REGEX, "").replaceAll(SYMBOL_REGEX, ""))).collect(Collectors.toList());
                    if (EmptyUtil.isNoEmpty(nameMatchList) && nameMatchList.size() == 1) {
                        return ((DynamicObject)nameMatchList.get(0)).get("id");
                    }
                } else {
                    return null;
                }
            }
        }
        if (EmptyUtil.isNoEmpty((String)matchingText)) {
            customerOrSupplier = BaseDataServiceHelper.queryBaseData((String)oppType, (Long)orgId, (QFilter)new QFilter("name", "=", (Object)matchingText).and(baseFilter), (String)"id");
            if (customerOrSupplier != null && customerOrSupplier.size() == 1) {
                return ((DynamicObject)customerOrSupplier.get(0)).get("id");
            }
            if (EmptyUtil.isEmpty((DynamicObjectCollection)customerOrSupplier)) {
                QFilter qFilter = new QFilter("number", "=", (Object)"fi.cas.clean.name");
                qFilter.and("enable", "=", (Object)"1");
                qFilter.and("configvalue", "=", (Object)"true");
                DynamicObject config = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_extend_config", (String)"id", (QFilter[])qFilter.toArray());
                if (config != null) {
                    String cleanedString = matchingText.replaceAll(EMPTY_REGEX, "").replaceAll(SYMBOL_REGEX, "");
                    LOGGER.info("config#kd.tmc.bei.business.helper.RecPayRuleHelper.dealCustomerOrSupplier#cleanedString:{}", (Object)cleanedString);
                    Map oppTypeMap = BaseDataServiceHelper.queryBaseDataFromCache((String)oppType, (Long)orgId, (QFilter)baseFilter, (String)"id,name");
                    if (oppTypeMap != null && oppTypeMap.size() > 0) {
                        List nameMatchList = oppTypeMap.values().stream().filter(s -> EmptyUtil.isNotEmpty((CharSequence)s.getString("name")) && cleanedString.equalsIgnoreCase(s.getString("name").replaceAll(EMPTY_REGEX, "").replaceAll(SYMBOL_REGEX, ""))).collect(Collectors.toList());
                        if (EmptyUtil.isNoEmpty(nameMatchList) && nameMatchList.size() == 1) {
                            return ((DynamicObject)nameMatchList.get(0)).get("id");
                        }
                        return null;
                    }
                }
            }
        }
        return null;
    }

    private static void doException(DynamicObject detailDO, String errorStr, boolean isThrowErr, OperationResult result) {
        LOGGER.info("RecPayRuleHelper.doException");
        if (isThrowErr) {
            throw new KDBizException(errorStr);
        }
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setLevel(ErrorLevel.Error);
        operateErrorInfo.setPkValue(detailDO.getPkValue());
        operateErrorInfo.setMessage(errorStr);
        result.addErrorInfo(operateErrorInfo);
    }
}

