/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.detail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.sdk.tmc.bei.util.MatchResultBean;
import kd.sdk.tmc.bei.util.RecPayRuleMatchUtil;
import kd.tmc.bei.business.helper.AutoMatchHelper;
import kd.tmc.bei.business.helper.CasFlowConfirmLogHelper;
import kd.tmc.bei.business.service.factory.AutoMatchServiceFactory;
import kd.tmc.bei.common.enums.FlowOperateTypeEnum;
import kd.tmc.bei.common.enums.ReceredWayEnum;
import kd.tmc.bei.common.helper.AmountHelper;
import kd.tmc.bei.common.param.AutoMatchInfoParam;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.MatchBizTypeEnum;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.GenBankcheckCode;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TransDetailMatchBillService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(TransDetailMatchBillService.class);
    private static final String SEPARATOR = "_";
    List<AutoMatchInfoParam> tAutoMatchInfoList = new ArrayList<AutoMatchInfoParam>(10);

    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(26);
        lst.add("bankcheckflag");
        lst.add("recedbillnumber");
        lst.add("recedbilltype");
        lst.add("bizdate");
        lst.add("detailid");
        lst.add("debitamount");
        lst.add("creditamount");
        lst.add("receredway");
        lst.add("receredtype");
        lst.add("iskdretflag");
        lst.add("rulename");
        lst.add("accountbank.id");
        lst.add("accountbank");
        lst.add("currency");
        lst.add("isdowntobankstate");
        lst.add("receredtype");
        lst.add("company");
        lst.add("oppbanknumber");
        lst.add("oppunit");
        lst.addAll(AutoMatchHelper.getMatchFieldKeys());
        return lst;
    }

    /*
     * WARNING - void declaration
     */
    public void process(DynamicObject[] dynamicObjects) throws KDException {
        DynamicObject[] transUpBillArr;
        DynamicObject[] recBillArr;
        DynamicObject[] transHandleBillArr;
        DynamicObject[] transDownBillArr;
        DynamicObject[] agentBillArr;
        Map detailBankCheckFlagMap = new HashMap(1);
        boolean isFromDownLoad = false;
        if (this.getOperationVariable().containsKey("fromDownload") && null != this.getOperationVariable().get("fromDownload")) {
            isFromDownLoad = true;
            String detailBankCheckFlagMapJsonStr = (String)this.getOperationVariable().get("detailBankCheckFlagMap");
            if (kd.bos.util.StringUtils.isNotEmpty((String)detailBankCheckFlagMapJsonStr)) {
                detailBankCheckFlagMap = (Map)SerializationUtils.fromJsonString((String)detailBankCheckFlagMapJsonStr, Map.class);
            }
        }
        logger.info("process isFromDownLoad is that:" + isFromDownLoad);
        HashSet<String> bankCheckFlagSet = new HashSet<String>(detailBankCheckFlagMap.size() + dynamicObjects.length);
        bankCheckFlagSet.addAll(detailBankCheckFlagMap.values());
        bankCheckFlagSet.addAll(Arrays.stream(dynamicObjects).map(o -> o.getString("bankcheckflag")).filter(kd.bos.util.StringUtils::isNotEmpty).collect(Collectors.toSet()));
        Set<Object> accountIdSet = Arrays.stream(dynamicObjects).map(d -> {
            Long aId = 0L;
            if (d.get("accountbank") instanceof Long) {
                aId = d.getLong("accountbank");
            } else if (d.get("accountbank") instanceof DynamicObject) {
                aId = d.getDynamicObject("accountbank").getLong("id");
            }
            return aId;
        }).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        DynamicObject[] payBillArr = this.getBills(MatchBizTypeEnum.PAY, bankCheckFlagSet, accountIdSet);
        if (null != payBillArr) {
            logger.info("process payBillArr size is:" + payBillArr.length);
        }
        if (null != (agentBillArr = this.getBills(MatchBizTypeEnum.AGENTPAY, bankCheckFlagSet, accountIdSet))) {
            logger.info("process agentBillArr size is that:" + agentBillArr.length);
        }
        if (null != (transDownBillArr = this.getBills(MatchBizTypeEnum.TRANSDOWN, bankCheckFlagSet, accountIdSet))) {
            logger.info("process transdownBillArr size is that:" + transDownBillArr.length);
        }
        if (null != (transHandleBillArr = this.getBills(MatchBizTypeEnum.TRANSHANDLE, bankCheckFlagSet, accountIdSet))) {
            logger.info("process transhandleBillArr size is that:" + transHandleBillArr.length);
        }
        if (null != (recBillArr = this.getBills(MatchBizTypeEnum.REC, bankCheckFlagSet, accountIdSet))) {
            logger.info("process recBillArr size is:" + recBillArr.length);
        }
        if (null != (transUpBillArr = this.getBills(MatchBizTypeEnum.TRANSUP, bankCheckFlagSet, accountIdSet))) {
            logger.info("process transupBillArr size is that:" + transUpBillArr.length);
        }
        String opNumber = DB.genGlobalLongId() + "";
        if (isFromDownLoad) {
            void var17_25;
            List matchResultBeanList;
            String operationType = (String)this.getOperationVariable().get("operationType");
            logger.info("process operationType is:{}", (Object)operationType);
            Set matchBizDetailIds = new HashSet(1);
            Set matchRuleDetailIds = new HashSet(1);
            if (Objects.equals(operationType, "update")) {
                String string;
                String matchBizDetailIdsStr = (String)this.getOperationVariable().get("matchBizDetailIds");
                if (kd.bos.util.StringUtils.isNotEmpty((String)matchBizDetailIdsStr)) {
                    matchBizDetailIds = (Set)SerializationUtils.fromJsonString((String)matchBizDetailIdsStr, Set.class);
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)(string = (String)this.getOperationVariable().get("matchRuleDetailIds")))) {
                    matchRuleDetailIds = (Set)SerializationUtils.fromJsonString((String)string, Set.class);
                }
            }
            HashMap<String, Set<Object>> fieldValMap = new HashMap<String, Set<Object>>(16);
            for (DynamicObject info : dynamicObjects) {
                logger.info("TransDetailMatchBillService,params:{}", (Object)info.getString("billno"));
                String detailId = info.getString("detailid");
                if (Objects.equals(operationType, "update") && !matchBizDetailIds.contains(detailId) && kd.bos.util.StringUtils.isNotEmpty((String)info.getString("recedbillnumber"))) continue;
                String billNo = info.getString("billno");
                String bankCheckFlagStr = (String)detailBankCheckFlagMap.get(detailId);
                if (kd.bos.util.StringUtils.isNotEmpty((String)bankCheckFlagStr)) {
                    logger.info("\u4ea4\u6613\u660e\u7ec6\u7f16\u7801\uff1a{},\u4e0b\u8f7d\u56de\u6765\u7684\u5bf9\u8d26\u6807\u8bc6\u7801\u4e3a\uff1a{}", (Object)billNo, (Object)bankCheckFlagStr);
                    info.set("iskdretflag", (Object)"1");
                    info.set("bankcheckflag", (Object)bankCheckFlagStr);
                    this.dealDetailDataByCasBills(payBillArr, agentBillArr, recBillArr, transDownBillArr, transHandleBillArr, transUpBillArr, info, opNumber);
                } else {
                    String bankCheckFlag = info.getString("bankcheckflag");
                    logger.info("\u4ea4\u6613\u660e\u7ec6\u7f16\u7801:{},\u5bf9\u8d26\u6807\u8bc6\u7801\uff1a{}", (Object)billNo, (Object)bankCheckFlag);
                    if (kd.bos.util.StringUtils.isEmpty((String)bankCheckFlag)) {
                        String genCode = GenBankcheckCode.genCode();
                        logger.info("\u4ea4\u6613\u660e\u7ec6\u7f16\u7801:{},\u81ea\u5df1\u751f\u6210\u7684\u5bf9\u8d26\u6807\u8bc6\u7801\u4e3a\uff1a{}" + genCode, (Object)billNo, (Object)genCode);
                        info.set("bankcheckflag", (Object)genCode);
                    }
                }
                this.fillFieldValMap(info, fieldValMap);
            }
            this.updateReceivedType(dynamicObjects, fieldValMap);
            Object var17_23 = null;
            List matchIds = this.tAutoMatchInfoList.stream().map(AutoMatchInfoParam::getTransDetailId).collect(Collectors.toList());
            Set finalMatchRuleDetailIds = matchRuleDetailIds;
            Object[] ids = Arrays.stream(dynamicObjects).filter(o -> !o.getString("receredtype").equals(ReceredtypeEnum.ACCOUNTED.getValue()) && !matchIds.contains(o.getLong("id")) && !Objects.equals(operationType, "update") || finalMatchRuleDetailIds.contains(o.getString("detailid"))).map(DataEntityBase::getPkValue).distinct().toArray();
            if (ids.length != 0 && (matchResultBeanList = RecPayRuleMatchUtil.match((Object[])ids)) != null) {
                Map<Object, String> map = matchResultBeanList.stream().collect(Collectors.toMap(MatchResultBean::getId, MatchResultBean::getNewRuleName, (a, b) -> a));
            }
            if (var17_25 != null) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    if (!var17_25.containsKey(dynamicObject.getPkValue())) continue;
                    dynamicObject.set("rulename", var17_25.get(dynamicObject.getPkValue()));
                }
            }
            TmcDataServiceHelper.save((DynamicObject[])dynamicObjects);
        } else {
            logger.info("\u5185\u90e8\u91d1\u878d\u6216\u8005\u5217\u8868\u4fa7\u5904\u7406\u540e\u7684\u4ea4\u6613\u660e\u7ec6\u7684\u96c6\u5408newDetailSet\u6570\u91cf\u4e3a{}", (Object)dynamicObjects.length);
            for (DynamicObject info : dynamicObjects) {
                String string = info.getString("bankcheckflag");
                logger.info("\u4ea4\u6613\u660e\u7ec6\u7f16\u7801:{},\u5185\u90e8\u91d1\u878d\u6216\u8005\u5217\u8868\u4fa7\u8fdb\u6765\u7684\u5bf9\u8d26\u6807\u8bc6\u7801\u4e3a\uff1a{}", (Object)info.getString("billno"), (Object)string);
                if (kd.bos.util.StringUtils.isEmpty((String)string) || kd.bos.util.StringUtils.isNotEmpty((String)info.getString("recedbillnumber"))) continue;
                this.dealDetailDataByCasBills(payBillArr, agentBillArr, recBillArr, transDownBillArr, transHandleBillArr, transUpBillArr, info, opNumber);
            }
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        if (!this.tAutoMatchInfoList.isEmpty()) {
            AutoMatchServiceFactory.getAutoMatchService().execute(this.tAutoMatchInfoList, ReceredWayEnum.BEIPAY.getValue(), null, true, null);
            CasFlowConfirmLogHelper.saveAutoMatchLog(Arrays.asList(dataEntities), this.tAutoMatchInfoList, (String)FlowOperateTypeEnum.BEIPAY.getValue());
        }
    }

    private DynamicObject[] getBills(MatchBizTypeEnum tMatchBizType, Set<String> bankcheckflagSet, Set<Object> accountIdSet) {
        String tBillEntityKey = this.getBillEntityKey(tMatchBizType);
        if (tBillEntityKey == null) {
            return new DynamicObject[0];
        }
        QFilter billFilter = AutoMatchHelper.getBillFilter(tMatchBizType, true, accountIdSet, null);
        QFilter bankcheckflagFilter = AutoMatchHelper.getBankCheckFlagFilter(tMatchBizType, false);
        if (bankcheckflagFilter != null) {
            bankcheckflagFilter.and(AutoMatchHelper.getBankCheckFlagFilter(tMatchBizType, bankcheckflagSet));
        } else {
            bankcheckflagFilter = AutoMatchHelper.getBankCheckFlagFilter(tMatchBizType, bankcheckflagSet);
        }
        String billMatchField = String.join((CharSequence)",", AutoMatchHelper.getBillFieldList(tBillEntityKey));
        String billField = this.getBillField(tBillEntityKey);
        return BusinessDataServiceHelper.load((String)tBillEntityKey, (String)String.join((CharSequence)",", billField, billMatchField), (QFilter[])new QFilter[]{billFilter, bankcheckflagFilter});
    }

    private String getBillField(String tBillEntityKey) {
        if ("cas_paybill".equals(tBillEntityKey)) {
            return "id,billno,billtype,acttradedate,bankcheckflag,actpayamt,paydate,dpcurrency,payeracctbank,bankcheckentity.ebankcheckflag";
        }
        if ("cas_agentpaybill".equals(tBillEntityKey)) {
            return "id,billno,billtype,acttradedate,bankcheckflag,payamount,paytime,dpcurrency,payeracctbank,entry,entry.e_bankcheckflag,entry.e_encryptamount,entry.e_paytime,bankcheckentity.ebankcheckflag";
        }
        if ("fca_transdownbill".equals(tBillEntityKey)) {
            return "id,billno,currency,accountbank,entrys.transamt,entrys.bankcheckflag";
        }
        if ("ifm_transhandlebill".equals(tBillEntityKey)) {
            return "id,billno,currency,agentpayeraccount,actpayamt,beibankcheckflag";
        }
        if ("cas_recbill".equals(tBillEntityKey)) {
            return "id,billno,currency,acttradedate,bankcheckflag,payeedate,actrecamt,accountbank,bankcheckentity.ebankcheckflag";
        }
        if ("fca_transupbill".equals(tBillEntityKey)) {
            return "id,billno,currency,accountbank,entrys.transamt,entrys.bankcheckflag";
        }
        return EntityMetadataCache.getDataEntityType((String)tBillEntityKey).getProperties().stream().map(IMetadata::getName).collect(Collectors.joining(","));
    }

    private String getBillEntityKey(MatchBizTypeEnum tMatchBizType) {
        if (MatchBizTypeEnum.PAY == tMatchBizType) {
            return "cas_paybill";
        }
        if (MatchBizTypeEnum.AGENTPAY == tMatchBizType) {
            return "cas_agentpaybill";
        }
        if (MatchBizTypeEnum.TRANSDOWN == tMatchBizType) {
            return "fca_transdownbill";
        }
        if (MatchBizTypeEnum.TRANSHANDLE == tMatchBizType) {
            return "ifm_transhandlebill";
        }
        if (MatchBizTypeEnum.REC == tMatchBizType) {
            return "cas_recbill";
        }
        if (MatchBizTypeEnum.TRANSUP == tMatchBizType) {
            return "fca_transupbill";
        }
        return null;
    }

    private void dealDetailDataByCasBills(DynamicObject[] payBillArr, DynamicObject[] agentBillArr, DynamicObject[] recBillArr, DynamicObject[] transDownBillArr, DynamicObject[] transHandleBillArr, DynamicObject[] transUpBillArr, DynamicObject info, String opNumber) {
        BigDecimal amount;
        String direction;
        String bankCheckFlagStr = info.getString("bankcheckflag");
        Object accountbank = info.get("accountbank");
        long aId = 0L;
        if (accountbank instanceof Long) {
            aId = (Long)accountbank;
        } else if (accountbank instanceof DynamicObject) {
            aId = ((DynamicObject)accountbank).getLong("id");
        }
        Long accountbankId = aId;
        accountbank = info.get("currency");
        aId = 0L;
        if (accountbank instanceof Long) {
            aId = (Long)accountbank;
        } else if (accountbank instanceof DynamicObject) {
            aId = ((DynamicObject)accountbank).getLong("id");
        }
        Long currencyId = aId;
        logger.info("bankcheckflag:" + bankCheckFlagStr + ",accountbankId:" + accountbankId + ",currencyId:" + currencyId);
        if (info.getBigDecimal("debitamount").compareTo(Constants.ZERO) > 0) {
            DynamicObject agentPayBillEntry;
            direction = "pay";
            amount = info.getBigDecimal("debitamount");
            DynamicObject transDownBill = this.getTransDownData(transDownBillArr, bankCheckFlagStr, amount, accountbankId, currencyId);
            if (transDownBill != null) {
                DynamicObject transDownEntryBill = this.getTransDownEntryData(transDownBill, bankCheckFlagStr, amount);
                if (transDownEntryBill != null) {
                    this.tAutoMatchInfoList.add(new AutoMatchInfoParam("bei_intelpay", info.getString("billno"), Long.valueOf(info.getLong("id")), "fca_transdownbill", transDownBill.getString("billno"), Long.valueOf(transDownBill.getLong("id")), Long.valueOf(transDownEntryBill.getLong("id")), Long.valueOf(info.getLong("currency.id")), null, amount, info.getString("bankcheckflag"), info.getDate("bizdate"), opNumber, direction));
                }
                return;
            }
            DynamicObject payBillDO = Arrays.stream(payBillArr).filter(o -> {
                DynamicObjectCollection bankCheckFlagEntity = o.getDynamicObjectCollection("bankcheckentity");
                boolean bankCheckFlagMatch = Boolean.FALSE;
                if (bankCheckFlagEntity != null && !bankCheckFlagEntity.isEmpty()) {
                    bankCheckFlagMatch = bankCheckFlagEntity.stream().anyMatch(r -> bankCheckFlagStr.equals(r.getString("ebankcheckflag")));
                }
                return bankCheckFlagMatch && amount.compareTo(o.getBigDecimal("actpayamt")) == 0 && currencyId.longValue() == o.getLong("dpcurrency.id") && accountbankId.longValue() == o.getLong("payeracctbank.id");
            }).findFirst().orElse(null);
            if (payBillDO != null) {
                this.tAutoMatchInfoList.add(new AutoMatchInfoParam("bei_intelpay", info.getString("billno"), Long.valueOf(info.getLong("id")), "cas_paybill", payBillDO.getString("billno"), Long.valueOf(payBillDO.getLong("id")), null, Long.valueOf(info.getLong("currency.id")), null, amount, info.getString("bankcheckflag"), info.getDate("bizdate"), opNumber, direction));
                return;
            }
            DynamicObject tTransHandleBill = this.getTransHandleData(transHandleBillArr, bankCheckFlagStr, amount, accountbankId, currencyId);
            if (tTransHandleBill != null) {
                this.tAutoMatchInfoList.add(new AutoMatchInfoParam("bei_intelpay", info.getString("billno"), Long.valueOf(info.getLong("id")), "ifm_transhandlebill", tTransHandleBill.getString("billno"), Long.valueOf(tTransHandleBill.getLong("id")), null, Long.valueOf(info.getLong("currency.id")), null, amount, info.getString("bankcheckflag"), info.getDate("bizdate"), opNumber, direction));
                return;
            }
            String encodeAmountStr = AmountHelper.encodeAmount((BigDecimal)amount);
            DynamicObject agentPayBill = this.getAgentData(agentBillArr, bankCheckFlagStr, encodeAmountStr, accountbankId, currencyId);
            if (agentPayBill != null && (agentPayBillEntry = this.getAgentEntryData(agentPayBill, bankCheckFlagStr, encodeAmountStr)) != null) {
                this.tAutoMatchInfoList.add(new AutoMatchInfoParam("bei_intelpay", info.getString("billno"), Long.valueOf(info.getLong("id")), "cas_agentpaybill", agentPayBill.getString("billno"), Long.valueOf(agentPayBill.getLong("id")), Long.valueOf(agentPayBillEntry.getLong("id")), Long.valueOf(info.getLong("currency.id")), null, amount, info.getString("bankcheckflag"), info.getDate("bizdate"), opNumber, direction));
                return;
            }
        }
        if (info.getBigDecimal("creditamount").compareTo(BigDecimal.ZERO) > 0) {
            direction = "rec";
            amount = info.getBigDecimal("creditamount");
            DynamicObject transUpBill = this.getTransUpData(transUpBillArr, bankCheckFlagStr, amount, accountbankId, currencyId);
            if (transUpBill != null) {
                DynamicObject transUpBillEntry = this.getTransUpEntryData(transUpBill, bankCheckFlagStr, amount);
                if (transUpBillEntry != null) {
                    this.tAutoMatchInfoList.add(new AutoMatchInfoParam("bei_intelrec", info.getString("billno"), Long.valueOf(info.getLong("id")), "fca_transupbill", transUpBill.getString("billno"), Long.valueOf(transUpBill.getLong("id")), Long.valueOf(transUpBillEntry.getLong("id")), Long.valueOf(info.getLong("currency.id")), null, amount, info.getString("bankcheckflag"), info.getDate("bizdate"), opNumber, direction));
                }
                return;
            }
            Arrays.stream(recBillArr).filter(o -> {
                DynamicObjectCollection bankCheckFlagEntity = o.getDynamicObjectCollection("bankcheckentity");
                boolean bankCheckFlagMatch = Boolean.FALSE;
                if (bankCheckFlagEntity != null && !bankCheckFlagEntity.isEmpty()) {
                    bankCheckFlagMatch = bankCheckFlagEntity.stream().anyMatch(r -> bankCheckFlagStr.equals(r.getString("ebankcheckflag")));
                }
                return bankCheckFlagMatch && amount.compareTo(o.getBigDecimal("actrecamt")) == 0 && currencyId.longValue() == o.getLong("currency.id") && accountbankId.longValue() == o.getLong("accountbank.id");
            }).findFirst().ifPresent(recBillDo -> this.tAutoMatchInfoList.add(new AutoMatchInfoParam("bei_intelrec", info.getString("billno"), Long.valueOf(info.getLong("id")), "cas_recbill", recBillDo.getString("billno"), Long.valueOf(recBillDo.getLong("id")), null, Long.valueOf(info.getLong("currency.id")), null, amount, info.getString("bankcheckflag"), info.getDate("bizdate"), opNumber, direction)));
        }
    }

    private DynamicObject getAgentData(DynamicObject[] agentBillArr, String bankCheckFlagStr, String encodeAmountStr, Long accountbankId, Long currencyId) {
        return Arrays.stream(agentBillArr).filter(agentBill -> accountbankId.longValue() == agentBill.getLong("payeracctbank.id") && currencyId.longValue() == agentBill.getLong("dpcurrency.id") && agentBill.getDynamicObjectCollection("entry").stream().anyMatch(entry -> bankCheckFlagStr.equals(entry.getString("e_bankcheckflag")) && encodeAmountStr.equals(entry.getString("e_encryptamount")))).findFirst().orElse(null);
    }

    private DynamicObject getAgentEntryData(DynamicObject agentBill, String bankCheckFlagStr, String encodeAmountStr) {
        return agentBill.getDynamicObjectCollection("entry").stream().filter(entry -> bankCheckFlagStr.equals(entry.getString("e_bankcheckflag")) && encodeAmountStr.equals(entry.getString("e_encryptamount"))).findFirst().orElse(null);
    }

    private DynamicObject getTransUpData(DynamicObject[] tBillArr, String bankCheckFlagStr, BigDecimal amount, Long accountbankId, Long currencyId) {
        return Arrays.stream(tBillArr).filter(tBill -> accountbankId.longValue() == tBill.getLong("accountbank.id") && currencyId.longValue() == tBill.getLong("currency.id") && tBill.getDynamicObjectCollection("entrys").stream().anyMatch(entry -> bankCheckFlagStr.equals(entry.getString("bankcheckflag")) && amount.compareTo(entry.getBigDecimal("transamt")) == 0)).findFirst().orElse(null);
    }

    private DynamicObject getTransUpEntryData(DynamicObject transUpBill, String bankCheckFlagStr, BigDecimal amount) {
        return transUpBill.getDynamicObjectCollection("entrys").stream().filter(entry -> bankCheckFlagStr.equals(entry.getString("bankcheckflag")) && amount.compareTo(entry.getBigDecimal("transamt")) == 0).findFirst().orElse(null);
    }

    private DynamicObject getTransDownData(DynamicObject[] tBillArr, String bankCheckFlagStr, BigDecimal amount, Long accountbankId, Long currencyId) {
        return Arrays.stream(tBillArr).filter(tBill -> accountbankId.longValue() == tBill.getLong("accountbank.id") && currencyId.longValue() == tBill.getLong("currency.id") && tBill.getDynamicObjectCollection("entrys").stream().anyMatch(entry -> bankCheckFlagStr.equals(entry.getString("bankcheckflag")) && amount.compareTo(entry.getBigDecimal("transamt")) == 0)).findFirst().orElse(null);
    }

    private DynamicObject getTransDownEntryData(DynamicObject transDownBill, String bankCheckFlagStr, BigDecimal amount) {
        return transDownBill.getDynamicObjectCollection("entrys").stream().filter(entry -> bankCheckFlagStr.equals(entry.getString("bankcheckflag")) && amount.compareTo(entry.getBigDecimal("transamt")) == 0).findFirst().orElse(null);
    }

    private DynamicObject getTransHandleData(DynamicObject[] tBillArr, String bankCheckFlagStr, BigDecimal amount, Long accountbankId, Long currencyId) {
        return Arrays.stream(tBillArr).filter(tBill -> accountbankId.longValue() == tBill.getLong("agentpayeraccount.id") && currencyId.longValue() == tBill.getLong("currency.id") && bankCheckFlagStr.equals(tBill.getString("beibankcheckflag")) && amount.compareTo(tBill.getBigDecimal("actpayamt")) == 0).findFirst().orElse(null);
    }

    private void fillFieldValMap(DynamicObject detail, Map<String, Set<Object>> fieldValMap) {
        Long companyId = TransDetailMatchBillService.getBaseDataId(detail, "company");
        if (companyId == null) {
            return;
        }
        BigDecimal debitAmount = detail.getBigDecimal("debitamount");
        if (debitAmount != null && debitAmount.compareTo(BigDecimal.ZERO) == 0) {
            boolean isIfm;
            boolean isBookifm = TransDetailMatchBillService.getParameterBoolean(companyId, "is_book_ifm");
            boolean cs1047 = TransDetailMatchBillService.getParameterBoolean(companyId, "cs1047");
            boolean bl = isIfm = !isBookifm || cs1047;
            if (isIfm) {
                Long currencyId = TransDetailMatchBillService.getBaseDataId(detail, "currency");
                if (currencyId != null) {
                    Set currencyIds = fieldValMap.computeIfAbsent("currency", k -> new HashSet());
                    currencyIds.add(currencyId);
                }
                Set creditAmounts = fieldValMap.computeIfAbsent("creditamount", k -> new HashSet());
                creditAmounts.add(detail.getBigDecimal("creditamount"));
                Set oppBankNumbers = fieldValMap.computeIfAbsent("oppbanknumber", k -> new HashSet());
                oppBankNumbers.add(detail.getString("oppbanknumber"));
                Long bankAccountId = TransDetailMatchBillService.getBaseDataId(detail, "accountbank");
                if (bankAccountId != null) {
                    Set accountBanks = fieldValMap.computeIfAbsent("accountbank", k -> new HashSet());
                    accountBanks.add(bankAccountId);
                }
            }
        } else {
            boolean isBookInner = TransDetailMatchBillService.getParameterBoolean(companyId, "is_book_inner");
            if (isBookInner) {
                Set bankCheckFlags = fieldValMap.computeIfAbsent("bankcheckflag", k -> new HashSet());
                bankCheckFlags.add(detail.getString("bankcheckflag"));
                Set debitAmounts = fieldValMap.computeIfAbsent("debitamount", k -> new HashSet());
                debitAmounts.add(debitAmount);
                Set companys = fieldValMap.computeIfAbsent("company", k -> new HashSet());
                companys.add(companyId);
                Set oppUnits = fieldValMap.computeIfAbsent("oppunit", k -> new HashSet());
                oppUnits.add(detail.getString("oppunit"));
            }
        }
    }

    private void updateReceivedType(DynamicObject[] details, Map<String, Set<Object>> fieldValMap) {
        Set transBillSet = null;
        Set<Object> oppBankNumbers = fieldValMap.get("oppbanknumber");
        if (oppBankNumbers != null && !oppBankNumbers.isEmpty()) {
            DynamicObjectCollection transHandleBills = TransDetailMatchBillService.queryTransHandelBill(fieldValMap);
            transBillSet = transHandleBills.stream().map(bill -> StringUtils.join((Object[])new Object[]{bill.get("agentpayeraccount.bankaccountnumber"), bill.get("actpayamt"), bill.get("payeracctbank.id"), bill.get("currency")}, (String)SEPARATOR)).collect(Collectors.toSet());
        }
        Set payBillSet = null;
        Set<Object> oppUnits = fieldValMap.get("oppunit");
        if (oppUnits != null && !oppUnits.isEmpty()) {
            DynamicObjectCollection payBills = TransDetailMatchBillService.queryPayBill(fieldValMap);
            payBillSet = payBills.stream().map(bill -> StringUtils.join((Object[])new Object[]{bill.get("bankcheckentity.ebankcheckflag"), bill.get("payeename"), bill.get("org"), bill.get("actpayamt")}, (String)SEPARATOR)).collect(Collectors.toSet());
        }
        for (DynamicObject detail : details) {
            boolean isExists;
            String detailKey;
            Long companyId = TransDetailMatchBillService.getBaseDataId(detail, "company");
            if (companyId == null) {
                return;
            }
            BigDecimal debitAmount = detail.getBigDecimal("debitamount");
            if (debitAmount != null && debitAmount.compareTo(BigDecimal.ZERO) == 0) {
                detailKey = StringUtils.join((Object[])new Object[]{detail.getString("oppbanknumber"), detail.getBigDecimal("creditamount"), TransDetailMatchBillService.getBaseDataId(detail, "accountbank"), TransDetailMatchBillService.getBaseDataId(detail, "currency")}, (String)SEPARATOR);
                isExists = transBillSet != null && transBillSet.contains(detailKey);
            } else {
                detailKey = StringUtils.join((Object[])new Object[]{detail.getString("bankcheckflag"), detail.getString("oppunit"), companyId, debitAmount}, (String)SEPARATOR);
                boolean bl = isExists = payBillSet != null && payBillSet.contains(detailKey);
            }
            if (!isExists) continue;
            detail.set("receredtype", (Object)ReceredtypeEnum.ACCOUNTED.getValue());
            detail.set("isdowntobankstate", (Object)Character.valueOf('1'));
        }
    }

    private static DynamicObjectCollection queryTransHandelBill(Map<String, Set<Object>> fieldValMap) {
        QFilter qFilter = new QFilter("billstatus", "<>", (Object)"A");
        Set<Object> currencyIds = fieldValMap.get("currency");
        if (currencyIds != null && !currencyIds.isEmpty()) {
            qFilter.and(new QFilter("currency", "in", currencyIds));
        }
        qFilter.and("paidstatus", "<>", (Object)"C");
        qFilter.and("transtype", "=", (Object)"14");
        qFilter.and(new QFilter("actpayamt", "in", fieldValMap.get("creditamount")));
        qFilter.and(new QFilter("agentpayeraccount.bankaccountnumber", "in", fieldValMap.get("oppbanknumber")));
        Set<Object> accountBanks = fieldValMap.get("accountbank");
        if (accountBanks != null && !accountBanks.isEmpty()) {
            qFilter.and(new QFilter("payeracctbank.id", "in", accountBanks));
        }
        return QueryServiceHelper.query((String)"ifm_transhandlebill", (String)"currency,actpayamt,agentpayeraccount.bankaccountnumber,payeracctbank.id", (QFilter[])new QFilter[]{qFilter});
    }

    private static DynamicObjectCollection queryPayBill(Map<String, Set<Object>> fieldValMap) {
        QFilter qFilter = new QFilter("billstatus", "not in", Arrays.asList("A", "G"));
        qFilter.and("bankcheckentity.ebankcheckflag", "in", fieldValMap.get("bankcheckflag"));
        qFilter.and(new QFilter("actpayamt", "in", fieldValMap.get("debitamount")));
        qFilter.and(new QFilter("org", "in", fieldValMap.get("company")));
        qFilter.and(new QFilter("payeename", "in", fieldValMap.get("oppunit")));
        return QueryServiceHelper.query((String)"cas_paybill", (String)"actpayamt,org,payeename,bankcheckentity.ebankcheckflag", (QFilter[])new QFilter[]{qFilter});
    }

    private static Long getBaseDataId(DynamicObject entity, String fieldName) {
        Long baseDataId = null;
        if (entity.get(fieldName) != null) {
            if (entity.get(fieldName) instanceof Long) {
                baseDataId = entity.getLong(fieldName);
            } else if (entity.get(fieldName) instanceof DynamicObject) {
                DynamicObject baseData = entity.getDynamicObject(fieldName);
                baseDataId = baseData.getLong("id");
            }
        }
        return baseDataId;
    }

    private static boolean getParameterBoolean(long orgId, String key) {
        AppParam appParam = new AppParam(TmcAppEnum.CAS.getId(), "08", Long.valueOf(orgId), Long.valueOf(0L));
        Object value = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)key);
        if (value == null) {
            return false;
        }
        return value instanceof Boolean ? ((Boolean)value).booleanValue() : "true".equals(value);
    }
}

