/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.elec;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.UrlUtil;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.matchtpl.MatcherTpl;
import kd.bos.print.matchtpl.ViewType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.print.NotePrintService;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.business.helper.CasBotpHelper;
import kd.tmc.bei.business.ocr.impl.ScanServiceImpl;
import kd.tmc.bei.business.ocr.invoke.ScanSystemFactory;
import kd.tmc.bei.common.constants.ResultRpc;
import kd.tmc.bei.common.enums.ReceiptQueryTypeEnum;
import kd.tmc.bei.common.enums.SourceBillTypeEnum;
import kd.tmc.bei.common.helper.BeiHelper;
import kd.tmc.bei.common.helper.ReceiptPrintHelper;
import kd.tmc.bei.common.resource.BeiBizResource;
import kd.tmc.fbp.common.ofd.OfdConvertUtil;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.graalvm.collections.Pair;

public class ViewReceiptService {
    private static final Log logger = LogFactory.getLog(ViewReceiptService.class);
    private static final String USERNAME = "username";
    private static final String BANKCHECKFLAG = "bankcheckflag";
    private static final String RECEIPTNO = "receiptno";

    @Deprecated
    public List<String> getElec(String viewPageId, Object[] bankcheckflags) {
        ResultRpc result;
        logger.info("\u8054\u67e5\u7535\u5b50\u56de\u5355\u5f00\u59cb");
        Set<Object> flags = new HashSet();
        if (bankcheckflags != null && bankcheckflags.length > 0) {
            logger.info("viewPageId:" + viewPageId + ", \u5bf9\u8d26\u6807\u8bc6\u7801:" + Arrays.asList(bankcheckflags));
            flags = Arrays.stream(bankcheckflags).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        }
        logger.info("\u6839\u636e\u5bf9\u8d26\u6807\u8bc6\u7801\u67e5\u8be2\u7535\u5b50\u56de\u5355");
        DynamicObjectCollection receipts = QueryServiceHelper.query((String)"bei_elecreceipt", (String)"id,bank,fileflag,filepath,biztype,bankcheckflag,fileserverurl,tcpurl,uploadfilename,username,password,matchdetailentry,matchdetailentry.id,matchdetailentry.e_transdetailid,matchdetailentry.e_bankcheckflag,bank.bank_cate bankcate", (QFilter[])new QFilter[]{new QFilter("matchdetailentry.e_bankcheckflag", "in", flags)});
        if (receipts == null || receipts.isEmpty()) {
            logger.info("\u672a\u67e5\u8be2\u5230\u7535\u5b50\u56de\u5355");
            result = this.genErrResult(new BeiBizResource().getGetEreceipturlError());
        } else {
            ArrayList<String> errMsgList = new ArrayList<String>();
            String pdfUrl = this.getPdfUrl(viewPageId, receipts, errMsgList);
            if (pdfUrl != null) {
                result = new ResultRpc();
                result.setUrl(pdfUrl);
                result.setOpenType(0);
            } else if (!errMsgList.isEmpty()) {
                logger.info("\u751f\u6210PDF\u6709\u9519\u8bef\u4fe1\u606f:" + errMsgList);
                result = this.genErrResult(String.join((CharSequence)",", errMsgList));
            } else {
                result = this.genErrResult(new BeiBizResource().getGetEreceipturlError());
            }
        }
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(JSON.toJSONString((Object)result));
        return resultList;
    }

    public List<String> getElecByReceiptno(String viewPageId, Object[] receiptnos) {
        ResultRpc result;
        logger.info("\u8054\u67e5\u7535\u5b50\u56de\u5355\u5f00\u59cb");
        if (receiptnos != null && receiptnos.length > 0) {
            logger.info("viewPageId:" + viewPageId + ", \u7535\u5b50\u56de\u5355\u53f7:" + Arrays.asList(receiptnos));
        }
        logger.info("\u6839\u636e\u7535\u5b50\u56de\u5355\u53f7\u67e5\u8be2\u7535\u5b50\u56de\u5355");
        DynamicObjectCollection receipts = QueryServiceHelper.query((String)"bei_elecreceipt", (String)"id,bank,fileflag,filepath,biztype,bankcheckflag,receiptno,fileserverurl,tcpurl,uploadfilename,username,password,bank.bank_cate bankcate", (QFilter[])new QFilter[]{new QFilter(RECEIPTNO, "in", (Object)receiptnos)});
        if (receipts == null || receipts.isEmpty()) {
            logger.info("\u672a\u67e5\u8be2\u5230\u7535\u5b50\u56de\u5355");
            result = this.genErrResult(new BeiBizResource().getGetEreceipturlError());
        } else {
            ArrayList<String> errMsgList = new ArrayList<String>();
            String pdfUrl = this.getPdfUrl(viewPageId, receipts, errMsgList);
            if (pdfUrl != null) {
                result = new ResultRpc();
                result.setUrl(pdfUrl);
                result.setOpenType(0);
            } else if (!errMsgList.isEmpty()) {
                logger.info("\u751f\u6210PDF\u6709\u9519\u8bef\u4fe1\u606f:" + errMsgList);
                result = this.genErrResult(String.join((CharSequence)",", errMsgList));
            } else {
                result = this.genErrResult(new BeiBizResource().getGetEreceipturlError());
            }
        }
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(JSON.toJSONString((Object)result));
        return resultList;
    }

    public Map<Long, Set<Long>> getReceiptIdByIds(String billType, Set<Long> billIds) {
        if (billIds == null || EmptyUtil.isEmpty((String)billType) || billIds.isEmpty()) {
            logger.warn(billType + " \u8054\u67e5\u5355\u636e\u53c2\u6570\u4e3a\u7a7a\u3002");
            throw new KDBizException(ResManager.loadKDString((String)"\u8054\u67e5\u5355\u636e\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ViewReceiptService_5", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        Map<Long, Set<Long>> returnData = new HashMap<Long, Set<Long>>(billIds.size());
        logger.info("\u5f00\u59cb\u7535\u5b50\u56de\u5355\u8054\u67e5\u670d\u52a1 billType: " + billType + " billCount: " + billIds.size());
        if (billType.startsWith("bos_")) {
            logger.warn(billType + "\u975e\u4e1a\u52a1\u5355\u636e\u8054\u67e5\u3002");
            return returnData;
        }
        ArrayList<Pair> voucherIdPairs = new ArrayList<Pair>(10);
        if (SourceBillTypeEnum.VOUCHER.getValue().equals(billType)) {
            DynamicObjectCollection vouchers = QueryServiceHelper.query((String)billType, (String)"id, sourcebilltype.number, sourcebill", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)vouchers)) {
                String sourceBillType;
                Set sourceBillSet = vouchers.stream().map(v -> v.getString("sourcebilltype.number")).collect(Collectors.toSet());
                if (sourceBillSet.size() != 1) {
                    logger.warn("\u51ed\u8bc1\u8054\u67e5\u7535\u5b50\u56de\u5355\u5931\u8d25 \u6240\u9009\u51ed\u8bc1\u7684\u76f4\u63a5\u6765\u6e90\u5305\u542b\u591a\u79cd\u6e90\u5355\u7c7b\u578b" + sourceBillSet);
                    return returnData;
                }
                billIds.clear();
                billType = sourceBillType = (String)sourceBillSet.iterator().next();
                logger.info("\u51ed\u8bc1\u8054\u67e5\u7535\u5b50\u56de\u5355 \u51ed\u8bc1\u6e90\u5355\u7c7b\u578b " + sourceBillType);
                for (DynamicObject voucher : vouchers) {
                    Long voucherId = voucher.getLong("id");
                    Long sourceBillId = voucher.getLong("sourcebill");
                    Set<Long> dapSourceBillIds = this.getDapSourceBillIds(voucherId);
                    if (!EmptyUtil.isEmpty(dapSourceBillIds)) {
                        billIds.addAll(dapSourceBillIds);
                        for (Long dapSourceBillId : dapSourceBillIds) {
                            voucherIdPairs.add(Pair.create((Object)dapSourceBillId, (Object)voucherId));
                        }
                        continue;
                    }
                    if (EmptyUtil.isEmpty((Long)sourceBillId)) continue;
                    billIds.add(sourceBillId);
                    voucherIdPairs.add(Pair.create((Object)sourceBillId, (Object)voucherId));
                }
                if (billIds.isEmpty()) {
                    logger.warn("\u51ed\u8bc1\u8054\u67e5\u7535\u5b50\u56de\u5355\u5931\u8d25 \u51ed\u8bc1\u6e90\u5355\u4fe1\u606f\u4e3a\u7a7a");
                    return returnData;
                }
            } else {
                logger.warn("\u51ed\u8bc1\u8054\u67e5\u7535\u5b50\u56de\u5355\u5931\u8d25 \u51ed\u8bc1\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
                return returnData;
            }
        }
        List fundBillTypes = QueryServiceHelper.query((String)"bei_fundbilltype", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")}).stream().map(o -> o.getString("number")).collect(Collectors.toList());
        fundBillTypes.remove(SourceBillTypeEnum.VOUCHER.getValue());
        if (!fundBillTypes.contains(billType)) {
            for (Long billId : billIds) {
                Map targetBillMap = BFTrackerServiceHelper.findTargetBills((String)billType, (Long[])new Long[]{billId});
                for (Map.Entry setEntry : targetBillMap.entrySet()) {
                    String billFormId = (String)setEntry.getKey();
                    if (!fundBillTypes.contains(billFormId)) continue;
                    logger.info("BOTP " + billType + "->" + billFormId + " \u8d44\u91d1\u6536\u4ed8\u5355\u636e\u8054\u67e5\u56de\u5355");
                    Map<Long, Set<Long>> receiptIds = this.findReceiptIdByids(billFormId, (Set)setEntry.getValue());
                    if (!receiptIds.isEmpty()) {
                        Set receipts = receiptIds.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
                        returnData.put(billId, receipts);
                        logger.info(billType + billId + " \u8054\u67e5\u7535\u5b50\u56de\u5355\u7ed3\u679c: " + receipts);
                    } else {
                        logger.warn(billType + billId + "\u5355\u636e\u4e0b\u6e38\u6536\u4ed8\u6b3e\u5355\u672a\u5173\u8054\u7535\u5b50\u56de\u5355");
                    }
                    targetBillMap.put("found", setEntry.getValue());
                    break;
                }
                if (targetBillMap.containsKey("found")) continue;
                try {
                    logger.info("\u67e5\u8be2\u7535\u5b50\u56de\u5355\u8054\u67e5\u65b9\u6848" + billType);
                    returnData = this.findReceiptIdByQueryScheme(billType, billIds);
                    logger.info(billType + "\u8054\u67e5\u65b9\u6848\u67e5\u8be2\u56de\u5355\u7ed3\u679c: " + returnData);
                }
                catch (KDBizException e) {
                    logger.warn(e.getMessage());
                }
            }
        } else {
            returnData = this.findReceiptIdByids(billType, billIds);
            logger.info("\u8d44\u91d1\u6536\u4ed8\u5355\u636e\u8054\u67e5\u56de\u5355\u7ed3\u679c " + returnData);
        }
        if (returnData.isEmpty()) {
            logger.warn("\u6682\u65e0\u5173\u8054\u7684\u7535\u5b50\u56de\u5355 sourceBill: " + billType);
            return returnData;
        }
        if (!voucherIdPairs.isEmpty()) {
            for (Pair voucherIdPair : voucherIdPairs) {
                if (!returnData.containsKey(voucherIdPair.getLeft())) continue;
                if (returnData.containsKey(voucherIdPair.getRight())) {
                    Set<Long> receiptIdSet = returnData.get(voucherIdPair.getRight());
                    if (receiptIdSet != null) {
                        receiptIdSet.addAll((Collection<Long>)returnData.get(voucherIdPair.getLeft()));
                        returnData.put((Long)voucherIdPair.getRight(), receiptIdSet);
                    }
                } else {
                    returnData.put((Long)voucherIdPair.getRight(), returnData.get(voucherIdPair.getLeft()));
                }
                returnData.remove(voucherIdPair.getLeft());
            }
        }
        return returnData;
    }

    private ResultRpc genErrResult(String msg) {
        ResultRpc resultRpc = new ResultRpc();
        resultRpc.setMsg(new BeiBizResource().getGetEreceipturlError());
        resultRpc.setOpenType(2);
        return resultRpc;
    }

    public String getReceiptPdfUrl(String pageId, Object[] pks) {
        ArrayList<Long> pkList = new ArrayList<Long>(10);
        for (Object pk : pks) {
            pkList.add(Long.valueOf(pk.toString()));
        }
        AtomicInteger sort = new AtomicInteger();
        sort.set(pkList.size());
        HashMap sortMap = new HashMap(16);
        pkList.forEach(e -> sortMap.put(e, sort.getAndIncrement()));
        DynamicObjectCollection receipts = QueryServiceHelper.query((String)"bei_elecreceipt", (String)"id,bank,fileflag,filepath,biztype,bankcheckflag,fileserverurl,tcpurl,uploadfilename,username,password,bank.bank_cate bankcate", (QFilter[])new QFilter[]{new QFilter("id", "in", pkList)});
        if (receipts == null || receipts.isEmpty()) {
            return "";
        }
        receipts = receipts.stream().sorted(Comparator.comparing(s -> (Integer)sortMap.get(s.getLong("id")))).collect(Collectors.toCollection(DynamicObjectCollection::new));
        ArrayList<String> errList = new ArrayList<String>(4);
        String pdfUrl = this.getPdfUrl(pageId, receipts, errList);
        if (!errList.isEmpty()) {
            logger.error(((Object)errList).toString());
        }
        return pdfUrl;
    }

    public void openReceiptById(IFormView view, Object[] pks) {
        ArrayList<Long> pkList = new ArrayList<Long>(10);
        if (pks == null || pks.length == 0) {
            logger.warn("receiptid is empty.");
            return;
        }
        for (Object pk : pks) {
            pkList.add(Long.valueOf(pk.toString()));
        }
        AtomicInteger sort = new AtomicInteger();
        sort.set(pkList.size());
        HashMap sortMap = new HashMap(16);
        pkList.forEach(e -> sortMap.put(e, sort.getAndIncrement()));
        DynamicObjectCollection receipts = QueryServiceHelper.query((String)"bei_elecreceipt", (String)"id,bank,fileflag,filepath,biztype,bankcheckflag,fileserverurl,tcpurl,uploadfilename,username,password,bank.bank_cate bankcate", (QFilter[])new QFilter[]{new QFilter("id", "in", pkList)});
        if (receipts == null || receipts.isEmpty()) {
            return;
        }
        receipts = receipts.stream().sorted(Comparator.comparing(s -> (Integer)sortMap.get(s.getLong("id")))).collect(Collectors.toCollection(DynamicObjectCollection::new));
        this.showReceipt(view, receipts);
    }

    private void showReceipt(IFormView view, DynamicObjectCollection receipts) {
        ArrayList<String> errMsgList = new ArrayList<String>();
        String pdfUrl = this.getPdfUrl(view.getPageId(), receipts, errMsgList);
        if (!errMsgList.isEmpty()) {
            view.showErrorNotification(String.join((CharSequence)",", errMsgList));
        } else if (pdfUrl != null) {
            this.openForm(view, pdfUrl);
        }
    }

    private String getPdfUrl(String pageId, DynamicObjectCollection receipts, List<String> errMsgList) {
        ArrayList<String> listPdf = new ArrayList<String>(10);
        ArrayList<byte[]> resList = new ArrayList<byte[]>(10);
        String getEreceipturlError = new BeiBizResource().getGetEreceipturlError();
        String templateError = new BeiBizResource().getTemplateError();
        String getTemplateError = new BeiBizResource().getGetTemplateError();
        logger.info("ViewReceiptService.getPdfUrl receipts.size=" + receipts.size());
        if (receipts.size() > 1000) {
            errMsgList.add(ResManager.loadKDString((String)"\u8bf7\u6c42\u6253\u5370\u7535\u5b50\u56de\u5355\u6570\u91cf\u8d85\u8fc71000\u6761\uff0c\u8bf7\u5206\u6279\u5904\u7406\u3002", (String)"ViewReceiptService_6", (String)"tmc-bei-business", (Object[])new Object[0]));
            return null;
        }
        Set pkIds = receipts.stream().map(receipt -> receipt.getLong("id")).collect(Collectors.toSet());
        Map receiptTemplate = ReceiptPrintHelper.getMatchReceiptTemplate((String)"bei", (String)"bei_elecreceipt", pkIds, (ViewType)ViewType.LIST, (String)pageId);
        receiptTemplate.remove("");
        long timeMillis = System.currentTimeMillis();
        for (DynamicObject receipt2 : receipts) {
            Long receiptID = receipt2.getLong("id");
            try {
                logger.info("ViewReceiptService templateForm.size=" + receiptTemplate.size());
                if (!receiptTemplate.isEmpty()) {
                    for (MatcherTpl template : (Set)receiptTemplate.get(receiptID)) {
                        String templateId = template.getTplId();
                        logger.info("ViewReceiptService templateForm.keySet=" + templateId);
                        String templateFormId = "";
                        if (EmptyUtil.isNoEmpty((String)templateId)) {
                            templateFormId = MetadataDao.getNumberById((String)templateId);
                            logger.info("ViewReceiptService templateFormId=" + templateFormId);
                        }
                        String url = PrintServiceHelper.createPdfUrl((String)pageId, (String)"bei_elecreceipt", (String)templateFormId, (Object[])new Long[]{receiptID});
                        logger.info("ViewReceiptService url4old=" + url);
                        if (StringUtils.isNotEmpty((CharSequence)url)) {
                            if (receipt2.getBoolean("fileflag")) {
                                logger.info("\u8bbe\u7f6eusername-------" + receipt2.getString(USERNAME));
                                String uploadFileName = ReceiptPrintHelper.getRealUploadUrl((DynamicObject)receipt2);
                                if (StringUtils.isBlank((CharSequence)uploadFileName)) {
                                    errMsgList.add(getEreceipturlError);
                                }
                                String fileServerUrl = receipt2.getString("fileserverurl");
                                try {
                                    if (!EmptyUtil.isEmpty((String)fileServerUrl)) {
                                        ScanSystemFactory.getScanService();
                                        Long userId = RequestContext.get().getCurrUserId();
                                        DynamicObjectCollection userObj = QueryServiceHelper.query((String)"bos_user", (String)"id,phone", (QFilter[])new QFilter("id", "=", (Object)userId).toArray());
                                        DynamicObjectCollection configObj = QueryServiceHelper.query((String)"bas_imageconfig", (String)"imageurl,clientid,clientsecret", (QFilter[])new QFilter("enable", "=", (Object)"A").toArray());
                                        InputStream image = ScanServiceImpl.getImage((String)((DynamicObject)configObj.get(0)).getString("clientid"), (String)((DynamicObject)configObj.get(0)).getString("clientsecret"), (String)((DynamicObject)configObj.get(0)).getString("imageurl"), (String)((DynamicObject)userObj.get(0)).getString("phone"), (String)fileServerUrl);
                                        ReceiptPrintHelper.imageConvertPdf((String)"", resList, (InputStream)image);
                                        continue;
                                    }
                                    if (uploadFileName.endsWith("pdf") || uploadFileName.endsWith("PDF")) {
                                        logger.info("pdfReceipt url\uff1a" + uploadFileName);
                                        BeiHelper.getPdfPutStream((String)uploadFileName, resList);
                                        continue;
                                    }
                                    if (uploadFileName.endsWith("ofd") || uploadFileName.endsWith("OFD")) {
                                        logger.info("ofdReceipt url\uff1a" + uploadFileName);
                                        byte[] bytes = OfdConvertUtil.convertToPdfNew((byte[])BeiHelper.getPdfPutStream((String)uploadFileName, (String)"old"));
                                        resList.add(bytes);
                                        continue;
                                    }
                                    logger.info("fileReceipt url\uff1a" + uploadFileName);
                                    ReceiptPrintHelper.imageConvertPdf((String)uploadFileName, resList, null);
                                }
                                catch (Exception e) {
                                    logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                                    errMsgList.add(getEreceipturlError);
                                }
                                continue;
                            }
                            return url;
                        }
                        PrtAttach attach = ReceiptPrintHelper.doNewPrint((String)pageId, (String)"bei_elecreceipt", (String)templateId, (Object)receipt2.get("id"));
                        if (!Objects.nonNull(attach)) continue;
                        List attachDetail = attach.getAttachDetail();
                        for (PrtAttach.AttachDetail detail : attachDetail) {
                            byte[] pdfPutStream = BeiHelper.getPdfPutStream((String)detail.getFilePath(), (String)"new");
                            resList.add(pdfPutStream);
                        }
                    }
                    logger.info("ViewReceiptService listPdf = " + listPdf + " resList.size = " + resList.size());
                    continue;
                }
                errMsgList.add(templateError);
            }
            catch (KDBizException k) {
                errMsgList.add(k.getMessage());
            }
            catch (Exception e) {
                logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                errMsgList.add(getTemplateError);
            }
        }
        this.readTemplate(listPdf, resList);
        String pdfUrl = null;
        try {
            pdfUrl = this.finlyOpenForm(resList);
        }
        catch (Exception e) {
            logger.error("mergeMultiPdf Fail\uff1a", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            errMsgList.add(new BeiBizResource().dealPdfError());
        }
        logger.info("printTimeCost: " + (System.currentTimeMillis() - timeMillis) + " generatePdfUrl: " + pdfUrl);
        return pdfUrl;
    }

    private void readTemplate(List<String> listPdf, List<byte[]> resList) {
        if (listPdf == null || listPdf.isEmpty()) {
            return;
        }
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        for (String string : listPdf) {
            try {
                int result;
                InputStream ins = tempFileCache.getInputStream(string);
                byte[] bytes = new byte[ins.available()];
                int bytesToRead = ins.available();
                for (int bytesRead = 0; bytesRead < bytesToRead; bytesRead += result) {
                    result = ins.read(bytes, bytesRead, bytesToRead - bytesRead);
                    if (result != -1) continue;
                    break;
                }
                resList.add(bytes);
                ins.close();
            }
            catch (IOException e) {
                logger.info("IO\u6d41\u5931\u8d25" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
    }

    private String finlyOpenForm(List<byte[]> resList) {
        if (!resList.isEmpty()) {
            byte[] mergeMultiPdf;
            if (resList.size() > 1) {
                try {
                    mergeMultiPdf = ReceiptPrintHelper.mergeMultiPdf(resList);
                }
                catch (Exception e) {
                    throw new KDBizException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            } else {
                mergeMultiPdf = resList.get(0);
            }
            NotePrintService notePrintService = new NotePrintService();
            LocaleString localeString = new LocaleString("receipt");
            return notePrintService.createPdfUrl(localeString, mergeMultiPdf);
        }
        return null;
    }

    private void openForm(IFormView view, String pdfUrl) {
        IFormView mainView = view.getMainView();
        DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));
        String tempFileId = UrlUtil.getParam((String)pdfUrl, (String)"id");
        String appId = view.getFormShowParameter().getAppId();
        String entityNum = view.getEntityId();
        if (view instanceof IListView) {
            BillList list = (BillList)view.getControl("billlistap");
            entityNum = list.getListModel().getEntityId();
        }
        HashMap<String, Object> refEntityMap = new HashMap<String, Object>(4);
        refEntityMap.put("entityNum", entityNum);
        refEntityMap.put("appId", EmptyUtil.isEmpty((String)appId) ? "bei" : appId);
        refEntityMap.put("billPkId", view.getModel().getDataEntity().getPkValue());
        redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntityMap), 7200);
        if (mainView == null) {
            view.openUrl(pdfUrl);
        } else {
            FormShowParameter parm = this.buildParameter(pdfUrl);
            parm.setCaption(ResManager.loadKDString((String)"\u8054\u67e5\u56de\u5355", (String)"ViewReceiptService_0", (String)"tmc-bei-business", (Object[])new Object[0]));
            IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
            parentView.showForm(parm);
            view.sendFormAction(parentView);
        }
    }

    private FormShowParameter buildParameter(String pdfUrl) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bos_printpreview");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.setCustomParam("src", (Object)pdfUrl);
        return para;
    }

    public Map<Long, List<String>> findReceiptUrlByIds(String viewPageId, String billType, Set<Long> ids) {
        HashMap<Long, List<String>> returnData = new HashMap<Long, List<String>>(16);
        if (SourceBillTypeEnum.PAYBILL_SYNONYM.getValue().equals(billType) || SourceBillTypeEnum.PAYBILL_CASH.getValue().equals(billType) || SourceBillTypeEnum.PAYBILL_DCEP.getValue().equals(billType)) {
            billType = SourceBillTypeEnum.PAYBILL.getValue();
        } else if (SourceBillTypeEnum.RECBILLIFM.getValue().equals(billType)) {
            billType = SourceBillTypeEnum.RECBILL.getValue();
        }
        DynamicObjectCollection bills = this.getFundBills(billType, ids);
        ArrayList<DynamicObject> billsListBankCheck = new ArrayList<DynamicObject>(10);
        HashSet detailIds = new HashSet(10);
        for (DynamicObject bill2 : bills) {
            Set idsSet = CasBotpHelper.getBotpRtansDetails((Long)bill2.getLong("id"), (String)billType);
            if (idsSet.isEmpty()) {
                billsListBankCheck.add(bill2);
                continue;
            }
            detailIds.addAll(idsSet);
        }
        DynamicObjectCollection details = QueryServiceHelper.query((String)"bei_transdetail", (String)"id,company,accountbank,currency,matchreceiptentry.e_receiptno receiptno", (QFilter[])new QFilter[]{new QFilter("id", "in", detailIds)});
        List receiptNos = details.stream().map(detail -> detail.getString(RECEIPTNO)).collect(Collectors.toList());
        receiptNos = receiptNos.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List bankCheckFlags0 = billsListBankCheck.stream().map(bill -> bill.getString(BANKCHECKFLAG)).collect(Collectors.toList());
        List<Object> bankCheckFlags = new ArrayList(bankCheckFlags0.size());
        for (String str1 : bankCheckFlags0) {
            if (str1.contains(",")) {
                String[] split = str1.split(",");
                Collections.addAll(bankCheckFlags, split);
                continue;
            }
            bankCheckFlags.add(str1);
        }
        bankCheckFlags = bankCheckFlags.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bei_elecreceipt", (String)"id,bank,fileflag,filepath,biztype,bankcheckflag,receiptno,fileserverurl,tcpurl,uploadfilename,username,password,matchdetailentry,matchdetailentry.e_transdetailid,matchdetailentry.e_bankcheckflag,bank.bank_cate bankcate", (QFilter[])new QFilter[]{new QFilter("matchdetailentry.e_bankcheckflag", "in", bankCheckFlags).or(new QFilter(RECEIPTNO, "in", receiptNos))});
        DynamicObject[] receipts = (DynamicObject[])query.toArray((Object[])new DynamicObject[0]);
        ArrayList<String> errMsgList = new ArrayList<String>();
        this.getPdfUrl(viewPageId, receipts, errMsgList, bills, returnData, billType);
        return returnData;
    }

    public Map<Long, Set<Long>> findReceiptIdByids(String billType, Set<Long> ids) {
        String str;
        if (SourceBillTypeEnum.PAYBILL_SYNONYM.getValue().equals(billType) || SourceBillTypeEnum.PAYBILL_CASH.getValue().equals(billType) || SourceBillTypeEnum.PAYBILL_DCEP.getValue().equals(billType)) {
            billType = SourceBillTypeEnum.PAYBILL.getValue();
        } else if (SourceBillTypeEnum.RECBILLIFM.getValue().equals(billType)) {
            billType = SourceBillTypeEnum.RECBILL.getValue();
        }
        logger.info("findReceiptIdByids \u5f00\u59cb\u8054\u67e5\u7535\u5b50\u56de\u5355 billType: " + billType + " billCount: " + ids.size() + " billIds: " + ids);
        DynamicObjectCollection bills = this.getFundBills(billType, ids);
        HashMap<Long, Set<Long>> returnData = new HashMap<Long, Set<Long>>(bills.size());
        ArrayList<DynamicObject> billsListBankCheck = new ArrayList<DynamicObject>(10);
        HashSet detailIds = new HashSet(10);
        HashMap<Long, Set> detailMap = new HashMap<Long, Set>(16);
        for (DynamicObject bill2 : bills) {
            Set idsSet = CasBotpHelper.getBotpRtansDetails((Long)bill2.getLong("id"), (String)billType);
            detailMap.put(bill2.getLong("id"), idsSet);
            if (idsSet.isEmpty()) {
                billsListBankCheck.add(bill2);
                continue;
            }
            detailIds.addAll(idsSet);
        }
        logger.info("findReceiptIdByids detailIdCount: " + detailIds.size() + " detailIds: " + detailIds);
        DynamicObjectCollection details = QueryServiceHelper.query((String)"bei_transdetail", (String)"id,accountbank,matchreceiptentry.e_receiptno receiptno", (QFilter[])new QFilter[]{new QFilter("id", "in", detailIds)});
        List receiptNos = details.stream().map(detail -> detail.getString(RECEIPTNO)).collect(Collectors.toList());
        receiptNos = receiptNos.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List bankCheckFlags0 = billsListBankCheck.stream().map(bill -> bill.getString(BANKCHECKFLAG)).collect(Collectors.toList());
        List<Object> bankCheckFlags = new ArrayList(bankCheckFlags0.size());
        Iterator iterator = bankCheckFlags0.iterator();
        while (iterator.hasNext() && (str = (String)iterator.next()) != null) {
            if (str.contains(",")) {
                String[] split = str.split(",");
                Collections.addAll(bankCheckFlags, split);
                continue;
            }
            bankCheckFlags.add(str);
        }
        bankCheckFlags = bankCheckFlags.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        logger.info("findReceiptIdByids billsListBankCheckCount: " + billsListBankCheck.size() + " bankCheckFlagCount: " + bankCheckFlags.size() + "bankcheckFlags: " + bankCheckFlags);
        HashSet receipts = new HashSet(bankCheckFlags.size() + receiptNos.size());
        String selectFields = "id,bankcheckflag,receiptno,uploadfilename,matchdetailentry,matchdetailentry.e_transdetailid,matchdetailentry.e_bankcheckflag";
        DynamicObjectCollection receiptsByBankCheckFlag = QueryServiceHelper.query((String)"bei_elecreceipt", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("matchdetailentry.e_bankcheckflag", "in", bankCheckFlags)});
        DynamicObjectCollection receiptsByReceiptno = QueryServiceHelper.query((String)"bei_elecreceipt", (String)selectFields, (QFilter[])new QFilter[]{new QFilter(RECEIPTNO, "in", receiptNos)});
        receipts.addAll(receiptsByBankCheckFlag);
        receipts.addAll(receiptsByReceiptno);
        for (DynamicObject bill3 : bills) {
            Set<Long> interBankReceipts;
            long billId = bill3.getLong("id");
            String bankCheckFlag = bill3.getString(BANKCHECKFLAG);
            if (bankCheckFlag == null) {
                bankCheckFlag = "";
            }
            HashSet<String> splitBankCheckFlag = new HashSet<String>(4);
            String[] split = bankCheckFlag.split(",");
            splitBankCheckFlag.addAll(Arrays.asList(split));
            logger.info("findReceiptIdByids billId: " + bill3.getLong("id") + " bankCheckFlags: " + splitBankCheckFlag);
            Set idsSet = (Set)detailMap.get(bill3.getLong("id"));
            if (EmptyUtil.isEmpty((Collection)idsSet)) {
                Set collectSet = receipts.stream().filter(receipt -> splitBankCheckFlag.contains(receipt.getString("matchdetailentry.e_bankcheckflag"))).map(receipt -> receipt.getLong("id")).collect(Collectors.toSet());
                Set receiptIdSet = returnData.getOrDefault(billId, new HashSet(splitBankCheckFlag.size()));
                receiptIdSet.addAll(collectSet);
                returnData.put(billId, receiptIdSet);
            } else {
                DynamicObjectCollection detailsTemp = this.getDetails(idsSet);
                Set receiptno = detailsTemp.stream().map(detail -> detail.getString(RECEIPTNO)).collect(Collectors.toSet());
                Set collectSet = receipts.stream().filter(receipt -> receiptno.contains(receipt.getString(RECEIPTNO))).map(receipt -> receipt.getLong("id")).collect(Collectors.toSet());
                returnData.put(bill3.getLong("id"), collectSet);
            }
            if (!SourceBillTypeEnum.PAYBILL.getValue().equals(billType) && !SourceBillTypeEnum.RECBILL.getValue().equals(billType) || (interBankReceipts = this.getInterBankReceipts(bill3, SourceBillTypeEnum.PAYBILL.getValue().equals(billType))).isEmpty()) continue;
            if (returnData.containsKey(billId)) {
                Set idSet = (Set)returnData.get(billId);
                idSet.addAll(interBankReceipts);
                returnData.put(billId, idSet);
            } else {
                returnData.put(billId, interBankReceipts);
            }
            returnData.put(bill3.getLong("id"), interBankReceipts);
            logger.info("fundBill: " + billType + bill3.getLong("id") + " getInterBankReceipts: " + interBankReceipts);
        }
        return returnData;
    }

    public Map<Long, Set<Long>> findReceiptIdByQueryScheme(String billType, Set<Long> billIds) {
        DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((String)"bei_receiptqueryscheme", (QFilter[])new QFilter[]{new QFilter("sourcebill", "=", (Object)billType)});
        if (EmptyUtil.isEmpty((DynamicObject)scheme)) {
            String warns = String.format(ResManager.loadKDString((String)"\u6e90\u5355\u7c7b\u578b%s\u6682\u65e0\u7535\u5b50\u56de\u5355\u8054\u67e5\u65b9\u6848\uff0c\u8bf7\u5728\u3010\u94f6\u4f01\u4e92\u8054\u3011->\u3010\u57fa\u7840\u8bbe\u7f6e\u3011->\u3010\u7535\u5b50\u56de\u5355\u8054\u67e5\u65b9\u6848\u3011\u4e2d\u8bbe\u7f6e\u3002", (String)"ViewReceiptService_1", (String)"tmc-bei-business", (Object[])new Object[0]), billType);
            throw new KDBizException(warns);
        }
        if (!scheme.getString("queryfilter").isEmpty()) {
            QFilter qFilter = this.loadQueryFilter(scheme.getString("filtercondition"), billType);
            if (qFilter != null) {
                qFilter.and("id", "in", billIds);
            } else {
                qFilter = new QFilter("id", "in", billIds);
            }
            DynamicObjectCollection bills = QueryServiceHelper.query((String)billType, (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (!bills.isEmpty()) {
                AtomicInteger sort = new AtomicInteger();
                sort.set(billIds.size());
                HashMap sortMap = new HashMap(16);
                billIds.forEach(e -> sortMap.put(e, sort.getAndIncrement()));
                billIds = bills.stream().sorted(Comparator.comparing(s -> (Integer)sortMap.get(s.getLong("id")))).map(b -> b.getLong("id")).collect(Collectors.toCollection(LinkedHashSet::new));
            } else {
                String warns = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u6ee1\u8db3\u5f53\u524d\u7535\u5b50\u56de\u5355\u8054\u67e5\u65b9\u6848%s\u6e90\u5355\u67e5\u8be2\u6761\u4ef6\u7684\u5355\u636e\u3002", (String)"ViewReceiptService_2", (String)"tmc-bei-business", (Object[])new Object[0]), scheme.getString("name"));
                throw new KDBizException(warns);
            }
        }
        HashMap<Long, Set<Long>> returnData = new HashMap<Long, Set<Long>>(billIds.size());
        DynamicObjectCollection linkEntry = scheme.getDynamicObjectCollection("linkentry");
        boolean isToFundBill = scheme.getBoolean("istofundbill");
        logger.info(billType + billIds + " \u6267\u884c\u7535\u5b50\u56de\u5355\u8054\u67e5\u65b9\u6848" + scheme.getString("name"));
        for (Long billId : billIds) {
            String sourceBillType = "";
            String targetBillType = "";
            HashSet<Long> sourceBillIds = new HashSet<Long>(4);
            sourceBillIds.add(billId);
            for (DynamicObject link : linkEntry) {
                sourceBillType = link.getDynamicObject("sourcebillname").getString("number");
                targetBillType = link.getDynamicObject("targetbillname").getString("number");
                String queryRule = link.getString("queryrule");
                if (sourceBillType == null || targetBillType == null || sourceBillType.isEmpty() || targetBillType.isEmpty()) {
                    logger.warn("\u56de\u5355\u67e5\u8be2\u94fe\u8def{}\u6e90\u5355/\u76ee\u6807\u5355\u4fe1\u606f\u4e3a\u7a7a \u8bf7\u68c0\u67e5\u8054\u67e5\u65b9\u6848\u914d\u7f6e\u4fe1\u606f");
                    return returnData;
                }
                if (ReceiptQueryTypeEnum.DAP.getValue().equals(queryRule)) {
                    logger.info(sourceBillType + "\u901a\u8fc7DAP\u5173\u7cfb\u8054\u67e5\u76ee\u6807\u5355" + targetBillType);
                    return returnData;
                }
                if (ReceiptQueryTypeEnum.RELATION.getName().equals(queryRule)) {
                    String sourceQueryField = link.getString("sourcequeryfield");
                    String targetQueryField = link.getString("targetqueryfield");
                    if (EmptyUtil.isEmpty((String)sourceQueryField) || EmptyUtil.isEmpty((String)targetQueryField)) {
                        logger.warn("\u56de\u5355\u67e5\u8be2\u94fe\u8def\u5355\u636e\u5173\u8054\u5b57\u6bb5\u4fe1\u606f\u4e3a\u7a7a \u8bf7\u68c0\u67e5\u8054\u67e5\u65b9\u6848\u914d\u7f6e\u4fe1\u606f");
                        return returnData;
                    }
                    DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)sourceBillType, (String)("id, " + sourceQueryField), (QFilter[])new QFilter[]{new QFilter("id", "in", sourceBillIds)});
                    sourceBillIds.clear();
                    for (DynamicObject sourceBill : sourceBills) {
                        DynamicObjectCollection targetBills = QueryServiceHelper.query((String)targetBillType, (String)("id, " + targetQueryField), (QFilter[])new QFilter[]{new QFilter(targetQueryField, "=", sourceBill.get(sourceQueryField))});
                        if (targetBills == null || targetBills.isEmpty()) continue;
                        sourceBillIds.addAll(targetBills.stream().map(b -> b.getLong("id")).collect(Collectors.toSet()));
                    }
                    if (EmptyUtil.isNoEmpty(sourceBillIds)) {
                        logger.info("\u7535\u5b50\u56de\u5355\u67e5\u8be2\u94fe\u8def \u6e90\u5355" + sourceBillType + "\u901a\u8fc7\u5173\u8054\u5173\u7cfb\u8054\u67e5\u76ee\u6807\u5355" + targetBillType + sourceBillIds);
                        continue;
                    }
                    logger.warn("\u7535\u5b50\u56de\u5355\u67e5\u8be2\u94fe\u8def \u6e90\u5355" + sourceBillType + "\u901a\u8fc7\u5173\u8054\u5173\u7cfb\u8054\u67e5\u627e\u4e0d\u5230\u76ee\u6807\u5355\u636e" + targetBillType);
                    break;
                }
                Map targetBillMap = BFTrackerServiceHelper.findTargetBills((String)sourceBillType, (Long[])sourceBillIds.toArray(new Long[0]));
                for (Map.Entry setEntry : targetBillMap.entrySet()) {
                    if (!targetBillType.equals(setEntry.getKey()) || !((HashSet)setEntry.getValue()).iterator().hasNext()) continue;
                    HashSet next = (HashSet)setEntry.getValue();
                    logger.info("\u7535\u5b50\u56de\u5355\u67e5\u8be2\u94fe\u8def " + sourceBillType + sourceBillIds + "\u901a\u8fc7BOTP\u8054\u67e5\u76ee\u6807\u5355" + targetBillType + next);
                    sourceBillIds.clear();
                    sourceBillIds.addAll(next);
                    targetBillMap.put("found", setEntry.getValue());
                    break;
                }
                if (targetBillMap.containsKey("found")) continue;
                logger.warn(sourceBillType + "\u5355\u636e" + sourceBillIds + "\u901a\u8fc7BOTP\u8054\u67e5\u627e\u4e0d\u5230\u76ee\u6807\u5355\u636e" + targetBillType);
                targetBillType = "";
                break;
            }
            if (targetBillType.isEmpty()) continue;
            if (isToFundBill && !targetBillType.equals("bei_elecreceipt")) {
                List fundBillTypes = QueryServiceHelper.query((String)"bei_fundbilltype", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")}).stream().map(o -> o.getString("number")).collect(Collectors.toList());
                fundBillTypes.remove(SourceBillTypeEnum.VOUCHER.getValue());
                if (fundBillTypes.contains(targetBillType)) {
                    Map<Long, Set<Long>> receiptMap = this.findReceiptIdByids(targetBillType, sourceBillIds);
                    if (receiptMap.isEmpty()) continue;
                    returnData.put(billId, receiptMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
                    continue;
                }
                logger.warn("\u76ee\u6807\u5355\u636e" + targetBillType + "\u975e\u8d44\u91d1\u6536\u4ed8\u5355\u636e");
                continue;
            }
            if (!targetBillType.equals("bei_elecreceipt")) continue;
            returnData.put(billId, sourceBillIds);
        }
        return returnData;
    }

    public List<String> voucherPrintViewReceipts(Set<Long> voucherPks) {
        logger.info("voucherPrintViewReceipts start voucherPks: " + voucherPks);
        Map<Long, Set<Long>> receiptMap = this.getReceiptIdByIds(SourceBillTypeEnum.VOUCHER.getValue(), voucherPks);
        return this.voucherPrintViewReceipts(receiptMap, true);
    }

    public List<String> voucherPrintViewReceipts(Map<Long, Set<Long>> receiptMap, boolean isFromOld) {
        logger.info("voucherPrintViewReceipts start receiptMap: " + receiptMap + " isFromOld: " + isFromOld);
        String errMessage = ResManager.loadKDString((String)"\u5f53\u524d\u51ed\u8bc1\u5173\u8054\u7684\u5355\u636e\u6ca1\u6709\u5bf9\u5e94\u7535\u5b50\u56de\u5355\u3002", (String)"ViewReceiptService_3", (String)"tmc-bei-business", (Object[])new Object[0]);
        ArrayList<String> resultUrlList = new ArrayList<String>(10);
        if (receiptMap == null || receiptMap.isEmpty()) {
            throw new KDBizException(errMessage);
        }
        for (Map.Entry<Long, Set<Long>> receiptEntry : receiptMap.entrySet()) {
            Set<Long> receiptIds = receiptEntry.getValue();
            DynamicObjectCollection receipts = QueryServiceHelper.query((String)"bei_elecreceipt", (String)"id, billno, biztype, matchdetailentry.e_bankcheckflag, receiptno, uploadfilename, fileflag, bank.bank_cate.number", (QFilter[])new QFilter[]{new QFilter("id", "in", receiptIds)});
            if (receipts == null || receipts.isEmpty()) {
                logger.warn(errMessage);
                continue;
            }
            ArrayList<String> realUpLoadUrlList = new ArrayList<String>(receipts.size());
            HashMap<String, DynamicObject> url2ReceiptMap = new HashMap<String, DynamicObject>(receipts.size());
            this.getReceiptUrl(receipts, realUpLoadUrlList, url2ReceiptMap);
            for (String realUploadUrl : realUpLoadUrlList) {
                realUploadUrl = realUploadUrl.trim();
                String suffix = realUploadUrl.substring(realUploadUrl.lastIndexOf("."));
                try {
                    List imagePages;
                    if (".ofd".equals(suffix)) {
                        byte[] bytes = OfdConvertUtil.convertToPdfNew((byte[])BeiHelper.getPdfPutStream((String)realUploadUrl, (String)"old"));
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
                        imagePages = ReceiptPrintHelper.pdfToPng((InputStream)inputStream, null, (String)"pdf", EmptyUtil.isEmpty((DynamicObject)((DynamicObject)url2ReceiptMap.get(realUploadUrl))) ? null : ((DynamicObject)url2ReceiptMap.get(realUploadUrl)).getString("bank.bank_cate.number"));
                    } else {
                        imagePages = ".pdf".equalsIgnoreCase(suffix) ? ReceiptPrintHelper.pdfToPng(null, (String)realUploadUrl, (String)"pdf", EmptyUtil.isEmpty((DynamicObject)((DynamicObject)url2ReceiptMap.get(realUploadUrl))) ? null : ((DynamicObject)url2ReceiptMap.get(realUploadUrl)).getString("bank.bank_cate.number")) : ReceiptPrintHelper.pdfToPng(null, (String)realUploadUrl, (String)"image", EmptyUtil.isEmpty((DynamicObject)((DynamicObject)url2ReceiptMap.get(realUploadUrl))) ? null : ((DynamicObject)url2ReceiptMap.get(realUploadUrl)).getString("bank.bank_cate.number"));
                    }
                    for (int i = 0; i < imagePages.size(); ++i) {
                        String pngStoreRoute;
                        byte[] image = (byte[])imagePages.get(i);
                        String pngFileName = "receipt" + i + ".png";
                        String imagePath = ReceiptPrintHelper.uploadPngToServer((String)pngFileName, (String)(pngStoreRoute = ReceiptPrintHelper.generateUploadPath((String)pngFileName)), (InputStream)new ByteArrayInputStream(image));
                        if (StringUtils.isBlank((CharSequence)imagePath)) {
                            logger.error("voucherPrintViewReceipts upload to imageSever fail: " + pngStoreRoute);
                            continue;
                        }
                        String currentPath = FileServiceExtFactory.getImageFileServiceExt().getRealPath("/" + imagePath);
                        logger.info("pngUrl after convert: " + currentPath);
                        resultUrlList.add(currentPath);
                    }
                }
                catch (Exception e) {
                    throw new KDBizException(e.getMessage());
                }
            }
        }
        return resultUrlList;
    }

    private void getReceiptUrl(DynamicObjectCollection receipts, List<String> pdfUrlList, Map<String, DynamicObject> url2ReceiptMap) {
        for (DynamicObject receipt : receipts) {
            if (receipt.getBoolean("fileflag")) {
                String realUploadUrl = ReceiptPrintHelper.getRealUploadUrl((DynamicObject)receipt, url2ReceiptMap);
                if (StringUtils.isBlank((CharSequence)realUploadUrl)) continue;
                if (realUploadUrl.endsWith("pdf") || realUploadUrl.endsWith("PDF")) {
                    pdfUrlList.add(realUploadUrl);
                    logger.info("\u83b7\u53d6\u7535\u5b50\u56de\u5355\u3010{}\u3011\u6210\u529f PDF\u6587\u4ef6\u8def\u5f84 {}", (Object)receipt.getString("billno"), (Object)realUploadUrl);
                    continue;
                }
                if (realUploadUrl.endsWith("ofd") || realUploadUrl.endsWith("OFD")) {
                    pdfUrlList.add(realUploadUrl);
                    logger.info("\u83b7\u53d6\u7535\u5b50\u56de\u5355\u3010{}\u3011\u6210\u529f OFD\u6587\u4ef6\u8def\u5f84 {}", (Object)receipt.getString("billno"), (Object)realUploadUrl);
                    continue;
                }
                pdfUrlList.add(realUploadUrl);
                logger.info("\u83b7\u53d6\u7535\u5b50\u56de\u5355\u3010{}\u3011\u6210\u529f \u56fe\u7247\u6587\u4ef6\u8def\u5f84 {}", (Object)receipt.getString("billno"), (Object)realUploadUrl);
                continue;
            }
            logger.warn(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u201c%s\u201d\u65e0\u6587\u4ef6\u8def\u5f84\uff0c\u8bf7\u5230\u201c\u53f8\u5e93\u4e91 > \u94f6\u4f01\u4e92\u8054 > \u7535\u5b50\u56de\u5355\u67e5\u8be2\u201d\u4e2d\u67e5\u770b\u3002", (String)"ViewReceiptService_4", (String)"tmc-bei-business", (Object[])new Object[]{receipt.getString("billno")}));
        }
    }

    private Set<Long> getInterBankReceipts(DynamicObject bill, boolean isPay) {
        Long bankId = bill.getLong("accountbank");
        DynamicObject accountBankDy = QueryServiceHelper.queryOne((String)"am_accountbank", (String)"id, finorgtype, authquerpt", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bankId)});
        if (accountBankDy != null) {
            long id;
            Object result;
            String finorgType = accountBankDy.getString("finorgtype");
            boolean authQuerpt = accountBankDy.getBoolean("authquerpt");
            if ("1".equalsIgnoreCase(finorgType) && authQuerpt && (result = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"ifm", (String)"queryBankReceiptService", (String)"getBankReceipts", (Object[])new Object[]{Collections.singleton(id = bill.getLong("id")), isPay})) != null) {
                return QueryServiceHelper.query((String)"bei_elecreceipt", (String)"id, receiptno", (QFilter[])new QFilter[]{new QFilter(RECEIPTNO, "in", result)}).stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
            }
        }
        return Collections.emptySet();
    }

    private DynamicObjectCollection getDetails(Set<Long> idsSet) {
        return QueryServiceHelper.query((String)"bei_transdetail", (String)"id, company, accountbank, currency, matchreceiptentry.e_receiptno receiptno", (QFilter[])new QFilter[]{new QFilter("id", "in", idsSet)});
    }

    private void getPdfUrl(String pageId, DynamicObject[] receipts, List<String> errMsgList, DynamicObjectCollection bills, Map<Long, List<String>> returnData, String billType) {
        Object[] pks = new Object[receipts.length];
        for (int i = 0; i < receipts.length; ++i) {
            pks[i] = receipts[i].getPkValue();
        }
        String templateError = new BeiBizResource().getTemplateError();
        String getTemplateError = new BeiBizResource().getGetTemplateError();
        for (DynamicObject receipt : receipts) {
            ArrayList<String> returnUrls = new ArrayList<String>(10);
            Long receiptID = Long.valueOf(receipt.getString("id"));
            try {
                HashSet<Long> pkIds = new HashSet<Long>(2);
                pkIds.add(receiptID);
                Map receiptTemplate = ReceiptPrintHelper.getMatchReceiptTemplate((String)"bei", (String)"bei_elecreceipt", pkIds, (ViewType)ViewType.LIST, (String)pageId);
                receiptTemplate.remove("");
                if (!receiptTemplate.isEmpty()) {
                    for (MatcherTpl template : (Set)receiptTemplate.get(receiptID)) {
                        String templateId = template.getTplId();
                        String url = PrintServiceHelper.createPdfUrl((String)pageId, (String)"bei_elecreceipt", (String)templateId, (Object[])new Long[]{receiptID});
                        if (StringUtils.isNotEmpty((CharSequence)url)) {
                            if (receipt.getBoolean("fileflag")) {
                                logger.info("\u8bbe\u7f6eusername-------" + receipt.getString(USERNAME));
                                String uploadfilename = ReceiptPrintHelper.getRealUploadUrl((DynamicObject)receipt);
                                logger.info("\u6587\u4ef6\u7c7b\u578b\u56de\u5355uploadfilename\u5b57\u6bb5\u7684\u503c\uff1a" + uploadfilename);
                                returnUrls.add(uploadfilename);
                                continue;
                            }
                            url = url.replaceFirst("print\\.do", "download.do");
                            returnUrls.add(url);
                            continue;
                        }
                        PrtAttach attach = ReceiptPrintHelper.doNewPrint((String)pageId, (String)"bei_elecreceipt", (String)templateId, (Object)receipt.getPkValue());
                        if (!Objects.nonNull(attach)) continue;
                        List attachDetail = attach.getAttachDetail();
                        for (PrtAttach.AttachDetail detail2 : attachDetail) {
                            String filePath = detail2.getFilePath();
                            filePath = filePath.replaceFirst("print\\.do", "download.do");
                            returnUrls.add(filePath);
                        }
                    }
                } else {
                    errMsgList.add(templateError);
                }
            }
            catch (Exception e) {
                logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                errMsgList.add(getTemplateError);
            }
            for (DynamicObject bill : bills) {
                Set idsSet = CasBotpHelper.getBotpRtansDetails((Long)bill.getLong("id"), (String)billType);
                if (!idsSet.isEmpty()) {
                    DynamicObjectCollection detailsTemp = this.getDetails(idsSet);
                    List receiptno = detailsTemp.stream().map(detail -> detail.getString(RECEIPTNO)).collect(Collectors.toList());
                    if (!receiptno.contains(receipt.getString(RECEIPTNO))) continue;
                    List<String> list = returnData.get(bill.getLong("id"));
                    if (list == null) {
                        list = new ArrayList<String>(5);
                        list.addAll(returnUrls);
                    } else {
                        list.addAll(returnUrls);
                    }
                    returnData.put(bill.getLong("id"), list);
                    continue;
                }
                String bankCheckFlag = bill.getString(BANKCHECKFLAG);
                String[] split = null;
                if (bankCheckFlag.contains(",")) {
                    split = bankCheckFlag.split(",");
                }
                String bankCheckFlagStr = receipt.getString("matchdetailentry.e_bankcheckflag");
                logger.info("\u83b7\u53d6\u56de\u5355url\u94fe\u63a5\uff0c\u5bf9\u8d26\u6807\u8bc6\u7801\u4e3a\uff1a{}", (Object)bankCheckFlagStr);
                if ((split != null || !StringUtils.equals((CharSequence)bill.getString(BANKCHECKFLAG), (CharSequence)bankCheckFlagStr)) && (split == null || !Arrays.asList(split).contains(bankCheckFlagStr))) continue;
                List<String> list = returnData.get(bill.getLong("id"));
                if (list == null) {
                    list = new ArrayList<String>(5);
                    list.addAll(returnUrls);
                } else {
                    list.addAll(returnUrls);
                }
                returnData.put(bill.getLong("id"), list);
            }
        }
    }

    private DynamicObjectCollection getFundBills(String billType, Set<Long> ids) {
        DynamicObjectCollection bills;
        if (SourceBillTypeEnum.PAYBILL.getValue().equals(billType) || SourceBillTypeEnum.AGENTPAYBILL.getValue().equals(billType)) {
            bills = QueryServiceHelper.query((String)billType, (String)"id, bankcheckentity.ebankcheckflag bankcheckflag, payeracctbank accountbank", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        } else if (SourceBillTypeEnum.RECBILL.getValue().equals(billType)) {
            bills = QueryServiceHelper.query((String)billType, (String)"id, bankcheckentity.ebankcheckflag bankcheckflag, accountbank", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        } else if (SourceBillTypeEnum.TRANSFERBILL.getValue().equals(billType)) {
            List payBillNos = QueryServiceHelper.query((String)billType, (String)"id, cas_transferapply_entry.e_paybillno paybillno", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}).stream().map(p -> p.getString("paybillno")).collect(Collectors.toList());
            logger.info(billType + ids + " query cas_paybill paybillNos: " + payBillNos);
            bills = QueryServiceHelper.query((String)SourceBillTypeEnum.PAYBILL.getValue(), (String)"id, bankcheckentity.ebankcheckflag bankcheckflag", (QFilter[])new QFilter[]{new QFilter("billno", "in", payBillNos)});
        } else {
            bills = SourceBillTypeEnum.TRANSDOWNBILL.getValue().equals(billType) || SourceBillTypeEnum.TRANSUPBILL.getValue().equals(billType) ? QueryServiceHelper.query((String)billType, (String)"id, entrys.bankcheckflag bankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}) : (SourceBillTypeEnum.EXCHANGEBILL.getValue().equals(billType) ? QueryServiceHelper.query((String)billType, (String)"id, buybankcheckflag || ',' || sellingbankcheckflag || ',' || feebankcheckflag as bankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}) : (SourceBillTypeEnum.TRANSHANDLEBILL.getValue().equals(billType) ? QueryServiceHelper.query((String)billType, (String)"id, beibankcheckflag bankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}) : QueryServiceHelper.query((String)billType, (String)"id, bankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})));
        }
        return bills;
    }

    private QFilter loadQueryFilter(String condition, String entityId) {
        if (StringUtils.isBlank((CharSequence)condition)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)condition, FilterCondition.class);
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)entityId);
        FilterBuilder filterBuilder = new FilterBuilder(dataType, filterCondition, true);
        filterBuilder.buildFilter(true);
        return filterBuilder.getQFilter();
    }

    private Set<Long> getDapSourceBillIds(Long voucherId) {
        HashSet<Long> sourceIds = new HashSet<Long>(4);
        String querySql = "select fsourcebillid as sourcebillid from t_ai_daptracker where fvoucherid = " + voucherId;
        DataSet queryDataSet = DB.queryDataSet((String)"queryDAPtracker", (DBRoute)new DBRoute("fi"), (String)querySql);
        if (queryDataSet != null && !queryDataSet.isEmpty()) {
            for (Row row : queryDataSet) {
                sourceIds.add(row.getLong("sourcebillid"));
            }
        }
        return sourceIds;
    }
}

