/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.business.helper.AutoMatchHelper;
import kd.tmc.bei.business.helper.CasBotpHelper;
import kd.tmc.bei.business.helper.TransDetailHelper;
import kd.tmc.bei.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DealTheSameNameTransHelper {
    private static Log logger = LogFactory.getLog(DealTheSameNameTransHelper.class);
    private static final Set<String> PAY_REC_BILL_TYPE = Stream.of("cas_paybill", "cas_recbill").collect(Collectors.toSet());

    public static void dealCancleRuleSameNameTrans(List<DynamicObject> cas_bei_Details, String entityName) {
        String botpDetailEntityName = "";
        String otherBotpDetailEntityName = "";
        if ("cas_paybill".equalsIgnoreCase(entityName)) {
            botpDetailEntityName = "bei_intelpay";
            otherBotpDetailEntityName = "bei_intelrec";
        } else {
            botpDetailEntityName = "bei_intelrec";
            otherBotpDetailEntityName = "bei_intelpay";
        }
        List detailIds = cas_bei_Details.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        DynamicObject[] thisDetails = BusinessDataServiceHelper.load((Object[])detailIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)botpDetailEntityName));
        Set<DynamicObject> filterThisDetails = DealTheSameNameTransHelper.filterTheSameNameTrans(thisDetails);
        if (CollectionUtils.isEmpty(filterThisDetails)) {
            return;
        }
        HashSet<Long> allotherdetailIds = new HashSet<Long>();
        for (DynamicObject thisDetail : filterThisDetails) {
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)botpDetailEntityName, (Long[])new Long[]{(Long)thisDetail.getPkValue()});
            if (CollectionUtils.isEmpty((Map)targetBills)) {
                return;
            }
            Set bizBillIds = targetBills.entrySet().stream().map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
            String targetEntityName = targetBills.keySet().stream().findFirst().orElseGet(() -> null);
            for (Long bizBillId : bizBillIds) {
                Set otherDetailSet;
                Set detailSet = CasBotpHelper.getSrcBillByDestBill((Long)bizBillId, (String)targetEntityName, (String)botpDetailEntityName);
                if (!CollectionUtils.isEmpty((Collection)detailSet)) {
                    DealTheSameNameTransHelper.updateDetail(detailSet, botpDetailEntityName);
                }
                if (CollectionUtils.isEmpty((Collection)(otherDetailSet = CasBotpHelper.getSrcBillByDestBill((Long)bizBillId, (String)targetEntityName, (String)otherBotpDetailEntityName)))) continue;
                DealTheSameNameTransHelper.updateDetail(otherDetailSet, otherBotpDetailEntityName);
                allotherdetailIds.addAll(otherDetailSet);
            }
        }
        try (TXHandle tx = TX.requiresNew();){
            DealTheSameNameTransHelper.deleteOtherDetailCasBill(otherBotpDetailEntityName, allotherdetailIds);
        }
    }

    private static void deleteOtherDetailCasBill(String otherBotpDetailEntityName, Set<Long> allotherdetailIds) {
        if (allotherdetailIds.size() > 0) {
            QFilter filter = new QFilter("id", "in", allotherdetailIds).and("recedbillentry.e_recedbilltype", "in", PAY_REC_BILL_TYPE);
            DynamicObjectCollection otherDetailRecedEntryList = QueryServiceHelper.query((String)otherBotpDetailEntityName, (String)"id,recedbillentry.e_recedbillid,recedbillentry.e_recedbilltype", (QFilter[])filter.toArray());
            if (CollectionUtils.isEmpty((Collection)otherDetailRecedEntryList)) {
                return;
            }
            Map<String, List<DynamicObject>> needDelRecedDetails = otherDetailRecedEntryList.stream().collect(Collectors.groupingBy(r -> r.getString("recedbillentry.e_recedbilltype")));
            for (Map.Entry<String, List<DynamicObject>> recedBillEntry : needDelRecedDetails.entrySet()) {
                Set recedIds;
                QFilter recedFilter;
                String recedBillType = recedBillEntry.getKey();
                DynamicObjectCollection recedBills = QueryServiceHelper.query((String)recedBillType, (String)"id,billstatus", (QFilter[])(recedFilter = new QFilter("id", "in", recedIds = recedBillEntry.getValue().stream().map(r -> r.getLong("recedbillentry.e_recedbillid")).collect(Collectors.toSet())).and("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue())).toArray());
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)recedBills)) continue;
                Object[] ids = (Long[])recedBills.stream().map(d -> d.getLong("id")).toArray(Long[]::new);
                OperationServiceHelper.executeOperate((String)"deletework", (String)recedBillType, (Object[])ids, (OperateOption)OperateOption.create());
            }
        }
    }

    private static void updateDetail(Set<Long> detailSet, String entityName) {
        DynamicObject[] thisSrcDetails = BusinessDataServiceHelper.load((Object[])detailSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        Arrays.stream(thisSrcDetails).filter(o -> ReceredtypeEnum.ACCOUNTED.getValue().equals(o.getString("receredtype"))).forEach(v -> {
            v.set("receredtype", (Object)ReceredtypeEnum.Pending.getValue());
            v.set("isreced", (Object)"0");
            v.set("recedbilltype", null);
            v.set("recedbillnumber", null);
            v.set("receredway", null);
            AutoMatchHelper.deleteRecedBillEntry(v);
        });
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])thisSrcDetails);
        }
    }

    private static Set<DynamicObject> filterTheSameNameTrans(DynamicObject[] thisSrcDetail) {
        Set sameNameTransList = Arrays.stream(thisSrcDetail).filter(detail -> TransDetailHelper.updateSynonym((DynamicObject)detail, (DynamicObject)detail.getDynamicObject("accountbank"), (DynamicObject)detail.getDynamicObject("company"))).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(sameNameTransList)) {
            return null;
        }
        Set dynamicObjects = sameNameTransList.stream().filter(e -> EmptyUtil.isNoEmpty((String)e.getString("oppbanknumber"))).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return null;
        }
        DynamicObjectCollection acctDynamics = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,bankaccountnumber,company.id", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "in", dynamicObjects.stream().map(a -> a.getString("oppbanknumber")).collect(Collectors.toSet()))});
        HashMap map = new HashMap(dynamicObjects.size());
        acctDynamics.forEach(e -> map.put(e.getString("bankaccountnumber"), e.getLong("company.id")));
        DynamicObjectCollection thisAccts = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,bankaccountnumber,company.id", (QFilter[])new QFilter[]{new QFilter("id", "in", dynamicObjects.stream().map(a -> a.getDynamicObject("accountbank").getLong("id")).collect(Collectors.toSet()))});
        if (CollectionUtils.isEmpty((Collection)thisAccts)) {
            return null;
        }
        HashMap thisMaps = new HashMap(thisAccts.size());
        thisAccts.forEach(e -> thisMaps.put(e.getLong("id"), e.getLong("company.id")));
        return dynamicObjects.stream().filter(e -> (long)((Long)map.get(e.getString("oppbanknumber"))).compareTo((Long)thisMaps.get(e.getDynamicObject("accountbank").getLong("id"))) == 0L).collect(Collectors.toSet());
    }
}

