/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.task.recpayintel;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.business.helper.AutoMatchTaskHelper;
import kd.tmc.bei.business.service.factory.AutoMatchServiceFactory;
import kd.tmc.bei.common.enums.ReceredWayEnum;
import kd.tmc.bei.common.param.AutoMatchInfoParam;
import kd.tmc.fbp.common.compare.result.CompareResult;
import kd.tmc.fbp.common.enums.MatchBizTypeEnum;
import kd.tmc.fbp.common.enums.MatchRelEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class IntelRecPayAutoMatchTaskHelper {
    private static final Log logger = LogFactory.getLog(IntelRecPayAutoMatchTaskHelper.class);

    public static void autoMatch(DynamicObject[] intelRecPayDOs, String type) {
        IntelRecPayAutoMatchTaskHelper.autoMatch(intelRecPayDOs, type, "", "");
    }

    public static void autoMatch(DynamicObject[] intelRecPayDOs, String type, String direction, String opNumber) {
        List pairList = null;
        String autoRecPayFlag = "autoconfirm";
        String billFlag = "cas_paybill";
        String sourceEntityKey = "rec".equals(direction) ? "bei_intelrec" : "bei_intelpay";
        String traceType = "";
        try {
            if ("rec".equals(type)) {
                billFlag = "cas_recbill";
                logger.info("=================\u5339\u914d,\u6536\u6b3e\u5f00\u59cb\u6267\u884c\u5339\u914d\u7b97\u6cd5");
                pairList = AutoMatchTaskHelper.autoMatch(Arrays.stream(intelRecPayDOs).collect(Collectors.toList()), (MatchBizTypeEnum)MatchBizTypeEnum.REC, (String)direction);
            } else if ("pay".equals(type)) {
                logger.info("=================\u5339\u914d,\u4ed8\u6b3e\u5f00\u59cb\u6267\u884c\u5339\u914d\u7b97\u6cd5");
                pairList = AutoMatchTaskHelper.autoMatch(Arrays.stream(intelRecPayDOs).collect(Collectors.toList()), (MatchBizTypeEnum)MatchBizTypeEnum.PAY, (String)direction);
            } else if (MatchBizTypeEnum.AGENTPAY.getValue().equals(type)) {
                billFlag = "cas_agentpaybill";
                logger.info("=================\u5339\u914d,\u4ee3\u53d1\u5355\u5f00\u59cb\u6267\u884c\u5339\u914d\u7b97\u6cd5");
                pairList = AutoMatchTaskHelper.autoMatch(Arrays.stream(intelRecPayDOs).collect(Collectors.toList()), (MatchBizTypeEnum)MatchBizTypeEnum.AGENTPAY, (String)direction);
            } else if (MatchBizTypeEnum.TRANSUP.getValue().equals(type)) {
                billFlag = "fca_transupbill";
                logger.info("=================\u5339\u914d,\u4e0a\u5212\u5355\u5f00\u59cb\u6267\u884c\u5339\u914d\u7b97\u6cd5");
                pairList = AutoMatchTaskHelper.autoMatch(Arrays.stream(intelRecPayDOs).collect(Collectors.toList()), (MatchBizTypeEnum)MatchBizTypeEnum.TRANSUP, (String)direction);
            } else if (MatchBizTypeEnum.TRANSDOWN.getValue().equals(type)) {
                billFlag = "fca_transdownbill";
                logger.info("=================\u5339\u914d,\u4e0b\u62e8\u5355\u5f00\u59cb\u6267\u884c\u5339\u914d\u7b97\u6cd5");
                pairList = AutoMatchTaskHelper.autoMatch(Arrays.stream(intelRecPayDOs).collect(Collectors.toList()), (MatchBizTypeEnum)MatchBizTypeEnum.TRANSDOWN, (String)direction);
            } else if (MatchBizTypeEnum.TRANSHANDLE.getValue().equals(type)) {
                billFlag = "ifm_transhandlebill";
                logger.info("=================\u5339\u914d,\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u5f00\u59cb\u6267\u884c\u5339\u914d\u7b97\u6cd5");
                pairList = AutoMatchTaskHelper.autoMatch(Arrays.stream(intelRecPayDOs).collect(Collectors.toList()), (MatchBizTypeEnum)MatchBizTypeEnum.TRANSHANDLE, (String)direction);
            } else if (MatchBizTypeEnum.EXCHANGE.getValue().equals(type)) {
                billFlag = "cas_exchangebill";
                traceType = "rec".equals(direction) ? "buy" : "sell";
                type = type + "_" + traceType;
                logger.info("=================\u5339\u914d,\u5916\u5e01\u5151\u6362\u5355\u5f00\u59cb\u6267\u884c\u5339\u914d\u7b97\u6cd5");
                pairList = AutoMatchTaskHelper.autoMatch(Arrays.stream(intelRecPayDOs).collect(Collectors.toList()), (MatchBizTypeEnum)MatchBizTypeEnum.EXCHANGE, (String)direction);
            }
            logger.info("=================\u5339\u914d,\u6267\u884c\u5339\u914d\u7b97\u6cd5\u5b8c\u6210");
        }
        catch (Exception e) {
            logger.info("=================\u5339\u914d,\u6267\u884c\u5339\u914d\u7b97\u6cd5\u5931\u8d25");
            throw e;
        }
        if (pairList != null && pairList.size() > 0) {
            logger.info("=================\u5339\u914d,\u7ed3\u679c\u7684\u6570\u636epairList\u6570\u91cf:" + pairList.size());
            String pairListStr = ObjectUtils.isEmpty((Object)pairList) ? "" : pairList.toString();
            logger.info("=================\u5339\u914d,\u7ed3\u679c\u7684\u6570\u636epairList\u503c:" + pairListStr);
            Set smartMatchIdSet = pairList.stream().map(Pair::getLeft).collect(Collectors.toSet());
            String smartMatchIds = ObjectUtils.isEmpty(smartMatchIdSet) ? "" : smartMatchIdSet.toString();
            logger.info("=================\u5339\u914d,\u81ea\u52a8\u5339\u914d\u89c4\u5219\u7684id\u503c:" + smartMatchIds);
            DynamicObject[] smartMatchDOArr = TmcDataServiceHelper.load((Object[])smartMatchIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_smartmatch"));
            Map<Object, Boolean> autoRecPayMap = Arrays.stream(smartMatchDOArr).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v.getBoolean(autoRecPayFlag)));
            Map smartMatchMap = Arrays.stream(smartMatchDOArr).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
            HashSet detailIdSets = new HashSet(10);
            HashSet autoRecPayBizBillIdSet = new HashSet(10);
            HashSet bizBillIdSet = new HashSet(10);
            HashMap detailRuleEntryIdMap = new HashMap(16);
            HashMap<Long, Long> bizBIllEntryMap = new HashMap<Long, Long>(16);
            ArrayList<AutoMatchData> autoMatchDataList = new ArrayList<AutoMatchData>(10);
            for (Pair objectListPair : pairList) {
                List rs = (List)objectListPair.getRight();
                if (rs == null || rs.size() <= 0) continue;
                logger.info("=================\u5339\u914d,\u5339\u914d\u7b97\u6cd5\u6267\u884c\u540e\u7684\u6570\u636e\u904d\u5386\u5904\u7406\u5f00\u59cb\uff1a" + rs.size());
                for (CompareResult cs : rs) {
                    Object left = objectListPair.getLeft();
                    Object entryRuleId = cs.getRuleId();
                    DynamicObject smartObj = (DynamicObject)smartMatchMap.get(left);
                    DynamicObjectCollection dynamicObjectCollection = smartObj.getDynamicObjectCollection("entryentity");
                    DynamicObject entryInfo = dynamicObjectCollection.stream().filter(item -> entryRuleId.equals(item.getLong("id"))).findFirst().get();
                    Set srcIdSet = cs.getSrcIdSet();
                    Set tarIdSet = cs.getTarIdSet();
                    String matchRel = entryInfo.getString("e_matchrel");
                    boolean matchByEntry = entryInfo.getBoolean("e_matchbyentry");
                    for (Object srcId : srcIdSet) {
                        detailRuleEntryIdMap.put(srcId, entryRuleId);
                    }
                    detailIdSets.addAll(srcIdSet);
                    boolean autoRecPay = autoRecPayMap.get(left) != null && autoRecPayMap.get(left) != false;
                    Set<Object> matchByEntryTarIdSet = new HashSet();
                    if ("cas_agentpaybill".equals(billFlag) && matchByEntry) {
                        Set billEntryIdSet = rs.stream().map(CompareResult::getTarIdSet).flatMap(Collection::stream).collect(Collectors.toSet());
                        DynamicObjectCollection billEntryColl = QueryServiceHelper.query((String)"cas_agentpaybill", (String)"id,entry.id", (QFilter[])new QFilter[]{new QFilter("entry.id", "in", (Object)cs.getTarIdSet())});
                        bizBIllEntryMap.putAll(billEntryColl.stream().collect(Collectors.toMap(item -> item.getLong("entry.id"), item -> item.getLong("id"))));
                        matchByEntryTarIdSet = billEntryColl.stream().map(item -> item.getLong("id")).collect(Collectors.toSet());
                        if (autoRecPay) {
                            autoRecPayBizBillIdSet.addAll(matchByEntryTarIdSet);
                        }
                    } else if (("fca_transupbill".equals(billFlag) || "fca_transdownbill".equals(billFlag)) && matchByEntry) {
                        DynamicObjectCollection billEntryColl = QueryServiceHelper.query((String)billFlag, (String)"id,entrys.id", (QFilter[])new QFilter[]{new QFilter("entrys.id", "in", (Object)cs.getTarIdSet())});
                        bizBIllEntryMap.putAll(billEntryColl.stream().collect(Collectors.toMap(item -> item.getLong("entrys.id"), item -> item.getLong("id"))));
                        matchByEntryTarIdSet = billEntryColl.stream().map(item -> item.getLong("id")).collect(Collectors.toSet());
                        if (autoRecPay) {
                            autoRecPayBizBillIdSet.addAll(matchByEntryTarIdSet);
                        }
                    } else if (autoRecPay) {
                        autoRecPayBizBillIdSet.addAll(cs.getTarIdSet());
                    }
                    bizBillIdSet.addAll(matchByEntry ? matchByEntryTarIdSet : tarIdSet);
                    AutoMatchData autoMatchData = new AutoMatchData(matchRel, srcIdSet, tarIdSet);
                    autoMatchDataList.add(autoMatchData);
                }
                logger.info("=================\u5339\u914d,\u5339\u914d\u7b97\u6cd5\u6267\u884c\u540e\u7684\u6570\u636e\u904d\u5386\u5904\u7406\u7ed3\u675f");
            }
            logger.info("============\u5339\u914d,\u5339\u914d\u540e\u7684src\u6570\u91cf:" + detailIdSets.size() + ";\u5339\u914d\u540e\u7684tar\u6570\u91cf:" + bizBillIdSet.size());
            if (detailIdSets.size() <= 0 || bizBillIdSet.size() <= 0) {
                return;
            }
            QFilter idFilter = new QFilter("id", "in", smartMatchIdSet);
            QFilter entryIdFilter = new QFilter("entryentity.id", "in", detailRuleEntryIdMap.values());
            DynamicObjectCollection entryRuleNameCols = QueryServiceHelper.query((String)"cas_smartmatch", (String)"id,entryentity.id,entryentity.e_rulesname,entryentity.e_matchbyentry", (QFilter[])new QFilter[]{idFilter, entryIdFilter});
            Map<Long, String> ruleEntryIdRuleNameMap = entryRuleNameCols.stream().collect(Collectors.toMap(o -> o.getLong("entryentity.id"), o -> o.getString("entryentity.e_rulesname")));
            Map<Long, Boolean> ruleEntryIdByEntryMap = entryRuleNameCols.stream().collect(Collectors.toMap(o -> o.getLong("entryentity.id"), o -> o.getBoolean("entryentity.e_matchbyentry")));
            HashMap detailRuleNameMap = new HashMap(16);
            HashMap detailRuleByEntryMap = new HashMap(16);
            for (Map.Entry entry : detailRuleEntryIdMap.entrySet()) {
                detailRuleNameMap.put(entry.getKey(), ruleEntryIdRuleNameMap.get(entry.getValue()));
                detailRuleByEntryMap.put(entry.getKey(), ruleEntryIdByEntryMap.get(entry.getValue()));
            }
            DynamicObject[] detailArr = TmcDataServiceHelper.load((Object[])detailIdSets.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)sourceEntityKey));
            DynamicObject[] dynamicObjectArray = TmcDataServiceHelper.load((Object[])bizBillIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)billFlag));
            Map<Object, DynamicObject> detailMap = Arrays.stream(detailArr).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
            Map<Object, DynamicObject> bizBillMap = Arrays.stream(dynamicObjectArray).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
            logger.info("=====\u904d\u5386\u4ea4\u6613\u660e\u7ec6\u66f4\u65b0\u5bf9\u5e94\u5b57\u6bb5\u503c\u5f00\u59cb\uff1a" + detailArr.length);
            List<Object> tAutoMatchInfoList = new ArrayList(detailArr.length);
            for (AutoMatchData autoMatchData : autoMatchDataList) {
                Long bizBillEntryId = null;
                MatchRelEnum matchRelEnum = MatchRelEnum.getByValue((String)autoMatchData.matchRel);
                BigDecimal billAmt = BigDecimal.ZERO;
                BigDecimal detailAmt = BigDecimal.ZERO;
                Boolean matchByEntry = false;
                switch (matchRelEnum) {
                    case ONE_TO_ONE: {
                        BigDecimal amount;
                        Object detailId = autoMatchData.getSrcIdSet().iterator().next();
                        DynamicObject detail = detailMap.get(detailId);
                        Object bizBillId = autoMatchData.getTarIdSet().iterator().next();
                        DynamicObject bizBill = bizBillMap.get(bizBillId);
                        matchByEntry = (Boolean)detailRuleByEntryMap.get(detailId);
                        if (Arrays.asList("cas_agentpaybill", "fca_transupbill", "fca_transdownbill").contains(billFlag) && matchByEntry.booleanValue()) {
                            bizBillEntryId = Long.parseLong(String.valueOf(bizBillId));
                            bizBillId = bizBIllEntryMap.get(bizBillEntryId);
                            bizBill = bizBillMap.get(bizBillId);
                        }
                        if ((detailAmt = (amount = "rec".equals(direction) ? detail.getBigDecimal("creditamount") : detail.getBigDecimal("debitamount"))).compareTo(billAmt = IntelRecPayAutoMatchTaskHelper.getBizAmount(bizBill, type, matchByEntry, bizBillEntryId)) != 0) {
                            logger.info("1\u5bf91\u5339\u914d\uff0c\u4ea4\u6613\u660e\u7ec6\u548c\u4e1a\u52a1\u5355\u636e\u7684\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u4e0d\u505a\u5339\u914d\uff0cdetailId\uff1a{}\uff0cbizBillId\uff1a{}", detailId, bizBillId);
                            break;
                        }
                        tAutoMatchInfoList.add(new AutoMatchInfoParam(sourceEntityKey, detail.getString("billno"), Long.valueOf(detail.getLong("id")), billFlag, bizBill.getString("billno"), Long.valueOf(Long.parseLong(String.valueOf(bizBillId))), bizBillEntryId, Long.valueOf(detail.getLong("currency.id")), traceType, amount, detail.getString("bankcheckflag"), detail.getDate("bizdate"), opNumber, direction));
                        break;
                    }
                    case ONE_TO_MANY: {
                        BigDecimal amt;
                        DynamicObject bizBill;
                        Object bizBillId;
                        Object detailId = autoMatchData.getSrcIdSet().iterator().next();
                        DynamicObject detail = detailMap.get(detailId);
                        detailAmt = "rec".equals(direction) ? detail.getBigDecimal("creditamount") : detail.getBigDecimal("debitamount");
                        Iterator<Object> iterator = autoMatchData.getTarIdSet().iterator();
                        while (iterator.hasNext()) {
                            Object bizId;
                            bizBillId = bizId = iterator.next();
                            bizBill = bizBillMap.get(bizId);
                            matchByEntry = (Boolean)detailRuleByEntryMap.get(detailId);
                            if (Arrays.asList("cas_agentpaybill", "fca_transupbill", "fca_transdownbill").contains(billFlag) && matchByEntry.booleanValue()) {
                                bizBillEntryId = Long.parseLong(String.valueOf(bizId));
                                bizBillId = bizBIllEntryMap.get(bizBillEntryId);
                                bizBill = bizBillMap.get(bizBillId);
                            }
                            amt = IntelRecPayAutoMatchTaskHelper.getBizAmount(bizBill, type, matchByEntry, bizBillEntryId);
                            billAmt = billAmt.add(amt);
                            tAutoMatchInfoList.add(new AutoMatchInfoParam(sourceEntityKey, detail.getString("billno"), Long.valueOf(detail.getLong("id")), billFlag, bizBill.getString("billno"), Long.valueOf(Long.parseLong(String.valueOf(bizBillId))), bizBillEntryId, Long.valueOf(detail.getLong("currency.id")), traceType, amt, detail.getString("bankcheckflag"), detail.getDate("bizdate"), opNumber, direction));
                        }
                        if (detailAmt.compareTo(billAmt) == 0) break;
                        logger.info("1\u5bf9\u591a\u5339\u914d\uff0c\u4ea4\u6613\u660e\u7ec6\u548c\u4e1a\u52a1\u5355\u636e\u7684\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u4e0d\u505a\u5339\u914d\uff0cdetailId\uff1a{}\uff0cbizBillIds\uff1a{}", detailId, autoMatchData.getTarIdSet());
                        if (Arrays.asList("cas_agentpaybill", "fca_transupbill", "fca_transdownbill").contains(billFlag) && matchByEntry.booleanValue()) {
                            tAutoMatchInfoList = tAutoMatchInfoList.stream().filter(v -> !autoMatchData.getTarIdSet().contains(v.getRecedBillEntryId())).collect(Collectors.toList());
                            break;
                        }
                        tAutoMatchInfoList = tAutoMatchInfoList.stream().filter(v -> !autoMatchData.getTarIdSet().contains(v.getRecedBillId())).collect(Collectors.toList());
                        break;
                    }
                    case MANY_TO_ONE: {
                        BigDecimal amt;
                        DynamicObject detail;
                        Object bizBillId = autoMatchData.getTarIdSet().iterator().next();
                        DynamicObject bizBill = bizBillMap.get(bizBillId);
                        for (Object detailBillId : autoMatchData.getSrcIdSet()) {
                            detail = detailMap.get(detailBillId);
                            matchByEntry = (Boolean)detailRuleByEntryMap.get(detailBillId);
                            if (Arrays.asList("cas_agentpaybill", "fca_transupbill", "fca_transdownbill").contains(billFlag) && matchByEntry.booleanValue()) {
                                bizBillEntryId = Long.parseLong(String.valueOf(bizBillId));
                                bizBillId = bizBIllEntryMap.get(bizBillEntryId);
                                bizBill = bizBillMap.get(bizBillId);
                            }
                            billAmt = IntelRecPayAutoMatchTaskHelper.getBizAmount(bizBill, type, matchByEntry, bizBillEntryId);
                            amt = "rec".equals(direction) ? detail.getBigDecimal("creditamount") : detail.getBigDecimal("debitamount");
                            detailAmt = detailAmt.add(amt);
                            tAutoMatchInfoList.add(new AutoMatchInfoParam(sourceEntityKey, detail.getString("billno"), Long.valueOf(detail.getLong("id")), billFlag, bizBill.getString("billno"), Long.valueOf(Long.parseLong(String.valueOf(bizBillId))), bizBillEntryId, Long.valueOf(detail.getLong("currency.id")), traceType, amt, detail.getString("bankcheckflag"), detail.getDate("bizdate"), opNumber, direction));
                        }
                        if (detailAmt.compareTo(billAmt) == 0) break;
                        logger.info("\u591a\u5bf91\u5339\u914d\uff0c\u4ea4\u6613\u660e\u7ec6\u548c\u4e1a\u52a1\u5355\u636e\u7684\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u4e0d\u505a\u5339\u914d\uff0cdetailIds\uff1a{}\uff0cbizBillId\uff1a{}", autoMatchData.getSrcIdSet(), bizBillId);
                        Object finalBizBillId = bizBillId;
                        tAutoMatchInfoList = Arrays.asList("cas_agentpaybill", "fca_transupbill", "fca_transdownbill").contains(billFlag) && matchByEntry != false ? tAutoMatchInfoList.stream().filter(v -> !v.getRecedBillEntryId().equals(finalBizBillId)).collect(Collectors.toList()) : tAutoMatchInfoList.stream().filter(v -> !v.getRecedBillId().equals(finalBizBillId)).collect(Collectors.toList());
                    }
                }
            }
            logger.info("\u904d\u5386\u4ea4\u6613\u660e\u7ec6\u66f4\u65b0\u5bf9\u5e94\u5b57\u6bb5\u503c\u7ed3\u675f");
            AutoMatchServiceFactory.getAutoMatchService().execute(tAutoMatchInfoList, ReceredWayEnum.AUTOMATCH.getValue(), detailRuleNameMap, true, autoRecPayBizBillIdSet);
        }
    }

    private static BigDecimal getBizAmount(DynamicObject bizBill, String type, Boolean matchByEntry, Long bizBillEntryId) {
        switch (type) {
            case "rec": {
                return bizBill.getBigDecimal("actrecamt");
            }
            case "pay": {
                return bizBill.getBigDecimal("totalpayamt");
            }
            case "agentpay": {
                AtomicReference<BigDecimal> amount = new AtomicReference<BigDecimal>(bizBill.getBigDecimal("dpamt"));
                if (matchByEntry.booleanValue() && EmptyUtil.isNoEmpty((Long)bizBillEntryId)) {
                    DynamicObjectCollection billEntryColl = bizBill.getDynamicObjectCollection("entry");
                    billEntryColl.stream().filter(item -> bizBillEntryId.equals(item.getLong("id"))).findFirst().ifPresent(item -> amount.set(item.getBigDecimal("e_amount")));
                }
                return amount.get();
            }
            case "transup": 
            case "transdown": {
                AtomicReference amount = new AtomicReference();
                if (matchByEntry.booleanValue() && EmptyUtil.isNoEmpty((Long)bizBillEntryId)) {
                    DynamicObjectCollection billEntryColl = bizBill.getDynamicObjectCollection("entrys");
                    billEntryColl.stream().filter(item -> bizBillEntryId.equals(item.getLong("id"))).findFirst().ifPresent(item -> amount.set(item.getBigDecimal("transamt")));
                }
                return (BigDecimal)amount.get();
            }
            case "transhandle": {
                return bizBill.getBigDecimal("actpayamt");
            }
            case "exchange_buy": {
                return bizBill.getBigDecimal("buyamount");
            }
            case "exchange_sell": {
                return bizBill.getBigDecimal("sellamount");
            }
        }
        return BigDecimal.ZERO;
    }

    private static class AutoMatchData {
        private String matchRel;
        private Set<Object> srcIdSet;
        private Set<Object> tarIdSet;

        public AutoMatchData(String matchRel, Set<Object> srcIdSet, Set<Object> tarIdSet) {
            this.matchRel = matchRel;
            this.srcIdSet = srcIdSet;
            this.tarIdSet = tarIdSet;
        }

        public String getMatchRel() {
            return this.matchRel;
        }

        public void setMatchRel(String matchRel) {
            this.matchRel = matchRel;
        }

        public Set<Object> getSrcIdSet() {
            return this.srcIdSet;
        }

        public void setSrcIdSet(Set<Object> srcIdSet) {
            this.srcIdSet = srcIdSet;
        }

        public Set<Object> getTarIdSet() {
            return this.tarIdSet;
        }

        public void setTarIdSet(Set<Object> tarIdSet) {
            this.tarIdSet = tarIdSet;
        }
    }
}

