/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DiscountApplyBill2TradeBillConvertPlugin
extends AbstractConvertPlugIn {
    private static final BigDecimal PERCENT = new BigDecimal("0.01");
    private static final int PRESION = 10;

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntities;
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity entity : billDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject targetBill = entity.getDataEntity();
            List srcRows = (List)entity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)pkValue, (DynamicObjectType)this.getSrcMainType());
            targetBill.set("poundage", sourceBill.get("bankcharge"));
            targetBill.set("tradetype", (Object)"discount");
            DynamicObject billType = TmcDataServiceHelper.loadSingle((Object)DraftTradeTypeEnum.getType((String)"discount"), (String)"bos_billtype");
            targetBill.set("billtype", (Object)billType);
            targetBill.set("sourcebillid", pkValue);
            targetBill.set("iseditdiscountentry", (Object)"1");
            DynamicObjectCollection discountApplyEntry = sourceBill.getDynamicObjectCollection("entrys");
            Set invalidDraftIdSet = discountApplyEntry.stream().filter(e1 -> e1.getBoolean("isinvalid")).map(e2 -> e2.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet());
            DynamicObjectCollection entrys = targetBill.getDynamicObjectCollection("entrys");
            DynamicObjectCollection discountEntry = targetBill.getDynamicObjectCollection("discountentry");
            boolean remove = entrys.removeIf(e3 -> invalidDraftIdSet.contains(e3.getDynamicObject("draftbill").getLong("id")));
            targetBill.set("draftcount", (Object)entrys.size());
            boolean removeDiscount = discountEntry.removeIf(e3 -> invalidDraftIdSet.contains(e3.getDynamicObject("dis_selectbillid").getLong("id")));
            for (DynamicObject entry : entrys) {
                BigDecimal billAmount;
                BigDecimal amount = entry.getDynamicObject("draftbill").getBigDecimal("amount");
                if (amount.compareTo(billAmount = entry.getBigDecimal("billamt")) <= 0) continue;
                entry.set("isneedsplit", (Object)true);
            }
            DynamicObjectCollection inquiryEntry = sourceBill.getDynamicObjectCollection("inquiryentrys");
            if (inquiryEntry.size() <= 0) continue;
            List inquiryEntryList = inquiryEntry.stream().filter(o -> o.getBoolean("isselect")).collect(Collectors.toList());
            int adjustDays = 0;
            for (DynamicObject entry : discountEntry) {
                adjustDays = ((DynamicObject)inquiryEntryList.get(0)).getInt("adjustdays");
                entry.set("dis_days", (Object)adjustDays);
                this.getDisRoughlyInterest(targetBill, entry);
            }
            if (adjustDays <= 0) continue;
            targetBill.set("discount_days", (Object)0);
            this.calcEntryInterestBySelf(targetBill, discountEntry);
        }
    }

    private void calcEntryInterestBySelf(DynamicObject targetBill, DynamicObjectCollection disEntry) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)disEntry)) {
            return;
        }
        BigDecimal allRoughlyInterest = new BigDecimal(BigInteger.ZERO);
        BigDecimal allInterest = new BigDecimal(BigInteger.ZERO);
        BigDecimal payInterest = new BigDecimal(BigInteger.ZERO);
        BigDecimal discAmt = new BigDecimal(BigInteger.ZERO);
        for (DynamicObject entry : disEntry) {
            BigDecimal dis_roughlyAmount = entry.getBigDecimal("dis_roughlyinterest");
            allRoughlyInterest = allRoughlyInterest.add(dis_roughlyAmount);
            BigDecimal dis_interestAmount = entry.getBigDecimal("dis_interest");
            BigDecimal dis_payAmount = entry.getBigDecimal("dis_payinterestamount");
            BigDecimal disDiscAmt = entry.getBigDecimal("dis_discamt");
            allInterest = allInterest.add(dis_interestAmount);
            payInterest = payInterest.add(dis_payAmount);
            discAmt = discAmt.add(disDiscAmt);
        }
        targetBill.set("roughly_interest", (Object)allRoughlyInterest);
        targetBill.set("payinterestamount", (Object)payInterest);
        targetBill.set("alldiscountinterest", (Object)allInterest.add(payInterest));
        targetBill.set("discount_interest", (Object)allInterest);
        targetBill.set("discamt", (Object)discAmt);
    }

    private BigDecimal getDisRoughlyInterest(DynamicObject targetBill, DynamicObject disEntry) {
        BigDecimal disRoughlyInterest;
        DynamicObject billDy = disEntry.getDynamicObject("dis_selectbillid");
        BigDecimal dis_billAmount = disEntry.getBigDecimal("dis_subamount");
        Date dis_expireDate = billDy.getDate("draftbillexpiredate");
        int dis_days = disEntry.getInt("dis_days");
        Date bizDate = targetBill.getDate("bizdate");
        BigDecimal rate = targetBill.getBigDecimal("rate").multiply(PERCENT).setScale(10, RoundingMode.HALF_UP);
        int interestday = targetBill.getInt("interestday");
        int days = DateUtils.getDiffDays((Date)bizDate, (Date)dis_expireDate) - 1 + dis_days;
        int amtprecision = targetBill.getDynamicObject("currency").getInt("amtprecision");
        BigDecimal dis_ownInterestAmount = disRoughlyInterest = dis_billAmount.multiply(rate).multiply(new BigDecimal(days)).divide(new BigDecimal(interestday), amtprecision, 4);
        boolean ispaybyagree = targetBill.getBoolean("ispaybyagree");
        BigDecimal dis_payinterestamount = BigDecimal.ZERO;
        if (ispaybyagree) {
            BigDecimal agreeRate = targetBill.getBigDecimal("agreerate").multiply(PERCENT);
            dis_payinterestamount = disRoughlyInterest.multiply(agreeRate).setScale(amtprecision, 4);
            dis_ownInterestAmount = disRoughlyInterest.subtract(dis_payinterestamount);
        }
        disEntry.set("dis_roughlyinterest", (Object)disRoughlyInterest);
        disEntry.set("dis_interest", (Object)dis_ownInterestAmount);
        disEntry.set("dis_payinterestamount", (Object)dis_payinterestamount);
        BigDecimal dis_disCamt = disEntry.getBigDecimal("dis_subamount").subtract(dis_ownInterestAmount);
        disEntry.set("dis_discamt", (Object)dis_disCamt);
        return disRoughlyInterest;
    }
}

