/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.ebservice.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.cdm.business.ebservice.EBServiceExecutorFactory;
import kd.tmc.cdm.business.ebservice.EBServiceFactory;
import kd.tmc.cdm.business.ebservice.api.IEBServiceFacade;
import kd.tmc.cdm.business.service.MulThreadQueryHoldHelper;
import kd.tmc.cdm.business.service.allocation.EBDraftAllocarionService;
import kd.tmc.cdm.common.bean.EleBillDiscountCalDetail;
import kd.tmc.cdm.common.bean.EleDraftBillQueryInfo;
import kd.tmc.cdm.common.enums.ElcDraftBillOpEnum;
import kd.tmc.cdm.common.enums.EleDraftExistCatEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.service.ebservice.service.IEBServiceExecutor;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class EBServiceFacadeImpl
implements IEBServiceFacade {
    private static final String OP_DODRAFTALLOCATIONSERVICE = "doDraftAllocationService";
    private static final String ELE_DRAFT_BILL_OP_SYNC = "eleDraftBillOpSync";
    private static final String QUERY_ELE_DRAFT_BILL = "queryEleDraftBill";
    private static final Log logger = LogFactory.getLog(EBServiceFacadeImpl.class);

    public List<NoteResult> draftBillSync(List<Long> draftIdList) {
        ArrayList<NoteResult> resultList = new ArrayList<NoteResult>(8);
        try {
            Map<Object, List<DynamicObject>> groupMap = this.syncGroupingByFields(draftIdList);
            logger.info("EBServiceFacadeImpl.draftBillSync groupMap size = {}", (Object)groupMap.size());
            for (Map.Entry<Object, List<DynamicObject>> groupDynamicObject : groupMap.entrySet()) {
                String batchSeqId = groupDynamicObject.getValue().get(0).getString("batchseqid");
                String tradeType = groupDynamicObject.getValue().get(0).getString("tradetype");
                String applicantAccText = groupDynamicObject.getValue().get(0).getString("applicantacctext");
                String draftType = groupDynamicObject.getValue().get(0).getString("drafttype");
                QFilter eleRecFilter = new QFilter("batchseqid", "=", (Object)batchSeqId).and(new QFilter("tradetype", "=", (Object)tradeType)).and(new QFilter("applicantacctext", "=", (Object)applicantAccText)).and(new QFilter("drafttype", "=", (Object)draftType));
                DynamicObjectCollection sameBatchSeqIdEleBills = QueryServiceHelper.query((String)"cdm_electronicbill", (String)"id", (QFilter[])new QFilter[]{eleRecFilter});
                List<Long> sameBatchSeqIds = sameBatchSeqIdEleBills.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                logger.info("EBServiceFacadeImpl.draftBillSync batchSeqId = {},sameBatchSeqIds = {},sameBatchSeqIdEleBills.size = {}", new Object[]{batchSeqId, sameBatchSeqIds.toString(), sameBatchSeqIdEleBills.size()});
                List<Long> lockSuccessIds = this.batchLockRequest(sameBatchSeqIds, resultList);
                try {
                    if (sameBatchSeqIds.size() == lockSuccessIds.size()) {
                        DynamicObject[] successLockEleBills = BusinessDataServiceHelper.load((Object[])sameBatchSeqIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronicbill"));
                        IEBServiceExecutor executor = EBServiceExecutorFactory.getEBServiceExecutor();
                        IEBService service = EBServiceFactory.getQueryEleService(Arrays.asList(successLockEleBills));
                        List res = (List)executor.execute(service);
                        resultList.addAll(res);
                        continue;
                    }
                    logger.info("EBServiceFacadeImpl.draftBillSync batchLockRequest fail batchSeqId = {},lockSuccessIds.size = {},lockSuccessIds = {}", new Object[]{batchSeqId, lockSuccessIds.size(), lockSuccessIds.toString()});
                }
                catch (Exception e) {
                    logger.error("EBServiceFacadeImpl.draftBillSync executor.execute exception\uff1a", (Throwable)e);
                    throw e;
                }
                finally {
                    this.batchReleaseRequest(lockSuccessIds);
                }
            }
            logger.info("EBServiceFacadeImpl.draftBillSync executor.execute done");
        }
        catch (Exception ex) {
            logger.error("EBServiceFacadeImpl.draftBillSync exception\uff1a", (Throwable)ex);
            throw ex;
        }
        return resultList;
    }

    public List<NoteResult> draftPayBillSync(List<Long> draftIdList) {
        logger.info("draftPayBillSync ====  startTime : {}", (Object)System.currentTimeMillis());
        ArrayList<NoteResult> resultList = new ArrayList<NoteResult>();
        List<Long> lockSuccessIds = this.batchLockRequest(draftIdList, resultList);
        try {
            if (EmptyUtil.isEmpty(lockSuccessIds)) {
                ArrayList<NoteResult> arrayList = resultList;
                return arrayList;
            }
            Map<Object, List<DynamicObject>> objMap = this.syncGroupingByFields(lockSuccessIds);
            logger.info("EBServiceFacadeImpl.draftPayBillSync objMap size = {}", (Object)objMap.size());
            for (Map.Entry<Object, List<DynamicObject>> groupDynamicObject : objMap.entrySet()) {
                IEBServiceExecutor executor = EBServiceExecutorFactory.getEBServiceExecutor();
                IEBService service = EBServiceFactory.getPayQueryEleService(groupDynamicObject.getValue());
                List res = (List)executor.execute(service);
                resultList.addAll(res);
            }
        }
        catch (Exception ex) {
            logger.error("EBServiceFacadeImpl.draftPayBillSync exception\uff1a", (Throwable)ex);
            throw ex;
        }
        finally {
            this.batchReleaseRequest(lockSuccessIds);
        }
        logger.info("draftPayBillSync ====  endTime : {}", (Object)System.currentTimeMillis());
        return resultList;
    }

    public List<NoteResult> queryDraftBill(List<String> draftTypeList, Map<String, List<String>> interfaceTypeMap, List<Long> accountIdList, Date startDate, Date endDate, String querySignal) {
        logger.info("EBServiceFacadeImpl.queryDraftBill param = {}", (Object)(draftTypeList.toString() + "_" + interfaceTypeMap.toString() + "_" + accountIdList.toString()));
        LinkedList<NoteResult> resultList = new LinkedList<NoteResult>();
        LinkedList<String> requestIds = new LinkedList<String>();
        LinkedList<Long> requestFailIds = new LinkedList<Long>();
        Map<String, Boolean> request = this.batchBankAccountLock(accountIdList);
        try {
            List requestDatas;
            Object failDatas;
            for (Map.Entry<String, Boolean> entry : request.entrySet()) {
                String key = entry.getKey();
                if (entry.getValue().booleanValue()) {
                    requestIds.add(key);
                    continue;
                }
                requestFailIds.add(Long.valueOf(key));
            }
            logger.info("EBServiceFacadeImpl.queryDraftBill batchBankAccountLock requestIds size = {}", (Object)requestIds.size());
            if (!requestFailIds.isEmpty()) {
                QFilter failIdQF = new QFilter("id", "in", requestFailIds);
                failDatas = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id, number", (QFilter[])failIdQF.toArray());
                TmcErrorCode tmcErrorCode = new TmcErrorCode();
                for (DynamicObject data : failDatas) {
                    NoteResult result = new NoteResult();
                    result.setStatusCode(EBResultStatusCode.ERROR);
                    result.setErrMsg(tmcErrorCode.BILL_MUTEX_LOCK_WITH_NUMBER(data.getString("number")).getMessage());
                    result.setBillId(Long.valueOf(data.getLong("id")));
                    resultList.add(result);
                }
            }
            if (EmptyUtil.isEmpty(requestDatas = requestIds.stream().map(Long::valueOf).collect(Collectors.toList()))) {
                failDatas = resultList;
                return failDatas;
            }
            DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])requestDatas.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks"));
            IEBService service = null;
            List res = new ArrayList();
            for (Map.Entry<String, List<String>> interfaceType : interfaceTypeMap.entrySet()) {
                String isNewECDS = interfaceType.getKey();
                List<String> statusList = interfaceType.getValue();
                for (String status : statusList) {
                    for (DynamicObject accountBank : objs) {
                        HashSet<String> currencies = new HashSet<String>(2);
                        for (DynamicObject currency : accountBank.getDynamicObjectCollection("currency")) {
                            DynamicObject curr = currency.getDynamicObject("fbasedataid");
                            if (curr == null) continue;
                            currencies.add(curr.getString("number"));
                        }
                        logger.info("EBServiceFacadeImpl.queryDraftBill currencies{}", (Object)((Object)currencies).toString());
                        for (String currencyNumber : currencies) {
                            for (String draftType : draftTypeList) {
                                IEBServiceExecutor executor = EBServiceExecutorFactory.getEBServiceExecutor();
                                EleDraftBillQueryInfo eleDraftBillQueryInfo = new EleDraftBillQueryInfo();
                                eleDraftBillQueryInfo.setObj(accountBank);
                                eleDraftBillQueryInfo.setStatus(status);
                                eleDraftBillQueryInfo.setCurrencyNumber(currencyNumber);
                                eleDraftBillQueryInfo.setDraftType(draftType);
                                eleDraftBillQueryInfo.setStartDate(startDate);
                                eleDraftBillQueryInfo.setEndDate(endDate);
                                eleDraftBillQueryInfo.setAcct(accountBank.getString("number"));
                                eleDraftBillQueryInfo.setBizSubType(querySignal);
                                if (EleDraftExistCatEnum.HOLD.getValue().equals(querySignal)) {
                                    eleDraftBillQueryInfo.setQueryBatchSeq(accountBank.getLong("id") + "_" + System.currentTimeMillis());
                                }
                                eleDraftBillQueryInfo.setIsNewECDS(isNewECDS);
                                if (EleDraftExistCatEnum.HOLD.getValue().equals(querySignal)) {
                                    service = EBServiceFactory.getTicketInfoService((EleDraftBillQueryInfo)eleDraftBillQueryInfo);
                                    res = (List)executor.execute(service);
                                    resultList.addAll(res);
                                    int totalPage = eleDraftBillQueryInfo.getTotalPage();
                                    int concurrent = eleDraftBillQueryInfo.getConcurrent();
                                    if (totalPage > 1 && concurrent > 1) {
                                        MulThreadQueryHoldHelper.batchRunQuerySchedule((EleDraftBillQueryInfo)eleDraftBillQueryInfo, (IEBServiceExecutor)executor, (IEBService)service, resultList);
                                    } else {
                                        int pageSize = this.getConfigPageSize();
                                        while ("0".equals(eleDraftBillQueryInfo.getKeepFlag()) && eleDraftBillQueryInfo.getPageNum() <= pageSize) {
                                            service = EBServiceFactory.getTicketInfoService((EleDraftBillQueryInfo)eleDraftBillQueryInfo);
                                            res = (List)executor.execute(service);
                                            resultList.addAll(res);
                                        }
                                    }
                                } else {
                                    int pageSize = this.getConfigPageSize();
                                    while ("0".equals(eleDraftBillQueryInfo.getKeepFlag()) && eleDraftBillQueryInfo.getPageNum() <= pageSize) {
                                        service = EBServiceFactory.getTicketInfoService((EleDraftBillQueryInfo)eleDraftBillQueryInfo);
                                        res = (List)executor.execute(service);
                                        resultList.addAll(res);
                                    }
                                }
                                logger.info("EBServiceFacadeImpl.queryDraftBill loop end\uff1aeleDraftBillQueryInfo.getKeepFlag() = {},eleDraftBillQueryInfo.acct = {}", (Object)eleDraftBillQueryInfo.getKeepFlag(), (Object)eleDraftBillQueryInfo.getAcct());
                                this.deleteWrongEleDraftCaseQueryHoldError(querySignal, res, accountBank, eleDraftBillQueryInfo);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("EBServiceFacadeImpl.queryDraftBill exception\uff1a", (Throwable)ex);
            throw ex;
        }
        finally {
            this.batchBankAccountRelease(requestIds);
        }
        return resultList;
    }

    public void deleteWrongEleDraftCaseQueryHoldError(String querySignal, List<NoteResult> res, DynamicObject accountBank, EleDraftBillQueryInfo eleDraftBillQueryInfo) {
        if (EleDraftExistCatEnum.HOLD.getValue().equals(querySignal) && EmptyUtil.isNoEmpty(res) && res.size() == 1) {
            DynamicObjectCollection eleDraftColl;
            Set needDeleteEleDraftSet;
            NoteResult noteResult = res.get(0);
            EBResultStatusCode statusCode = noteResult.getStatusCode();
            String errMsg = noteResult.getErrMsg();
            logger.info("EBServiceFacadeImpl.queryDraftBill loop end\uff1astatusCode {},errMsg = {}", (Object)statusCode, (Object)errMsg);
            if (EBResultStatusCode.ERROR.equals((Object)statusCode) && EmptyUtil.isNoEmpty(needDeleteEleDraftSet = (eleDraftColl = QueryServiceHelper.query((String)"cdm_electronicbill", (String)"id,querydrafttype", (QFilter[])new QFilter[]{new QFilter("sourceid", "=", (Object)0L), new QFilter("querybatchseq", "=", (Object)eleDraftBillQueryInfo.getQueryBatchSeq()), new QFilter("rptype", "=", (Object)"receivebill"), new QFilter("conectno", "=", (Object)accountBank.getString("number"))})).stream().filter(e -> EmptyUtil.isEmpty((String)e.getString("querydrafttype"))).map(e -> e.getLong("id")).collect(Collectors.toSet()))) {
                logger.info("EBServiceFacadeImpl.queryDraftBill loop error end\uff1adelete size {}", (Object)needDeleteEleDraftSet.size());
                int n = DeleteServiceHelper.delete((String)"cdm_electronicbill", (QFilter[])new QFilter[]{new QFilter("id", "in", needDeleteEleDraftSet)});
            }
        }
    }

    public List<NoteResult> draftBillOp(String op, List<Long> draftIdList) {
        ArrayList<NoteResult> resultList = new ArrayList<NoteResult>();
        List<Long> lockSuccessIds = this.batchLockRequest(draftIdList, resultList);
        try {
            if (EmptyUtil.isEmpty(lockSuccessIds)) {
                ArrayList<NoteResult> arrayList = resultList;
                return arrayList;
            }
            Map<Object, List<DynamicObject>> objMap = this.opGroupingByFields(op, lockSuccessIds);
            logger.info("EBServiceFacadeImpl.draftBillOp objMap size = {}", (Object)objMap.size());
            for (Map.Entry<Object, List<DynamicObject>> groupDynamic : objMap.entrySet()) {
                IEBServiceExecutor executor = EBServiceExecutorFactory.getEBServiceExecutor();
                IEBService service = EBServiceFactory.getNoteReceOpServie((String)ElcDraftBillOpEnum.getByValue((String)op).getSubBizType(), groupDynamic.getValue());
                List res = (List)executor.execute(service);
                resultList.addAll(res);
            }
        }
        catch (Exception ex) {
            logger.error("EBServiceFacadeImpl.draftBillOp exception\uff1a", (Throwable)ex);
            throw ex;
        }
        finally {
            this.batchReleaseRequest(lockSuccessIds);
        }
        return resultList;
    }

    public List<NoteResult> queryDraftBillByIds(List<Long> ids) {
        ArrayList<NoteResult> resultList = new ArrayList<NoteResult>();
        List<Long> lockSuccessIds = this.batchLockRequest(ids, resultList);
        try {
            DynamicObject[] electDraftBills;
            if (EmptyUtil.isEmpty(lockSuccessIds)) {
                ArrayList<NoteResult> arrayList = resultList;
                return arrayList;
            }
            for (DynamicObject electDraftBill : electDraftBills = BusinessDataServiceHelper.load((Object[])lockSuccessIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronicbill"))) {
                IEBServiceExecutor executor = EBServiceExecutorFactory.getEBServiceExecutor();
                String accountBank = electDraftBill.getString("conectno");
                EleDraftBillQueryInfo eleDraftBillQueryInfo = new EleDraftBillQueryInfo();
                eleDraftBillQueryInfo.setObj(electDraftBill);
                eleDraftBillQueryInfo.setAcct(accountBank);
                eleDraftBillQueryInfo.setBizSubType("info");
                IEBService service = EBServiceFactory.getTicketInfoByNoteNo((EleDraftBillQueryInfo)eleDraftBillQueryInfo);
                List res = (List)executor.execute(service);
                resultList.addAll(res);
            }
        }
        catch (Exception ex) {
            logger.error("EBServiceFacadeImpl.queryDraftBillByIds exception\uff1a", (Throwable)ex);
            throw ex;
        }
        finally {
            this.batchReleaseRequest(lockSuccessIds);
        }
        return resultList;
    }

    public List<NoteResult> draftPayBillOp(String op, List<Long> draftIdList) {
        ArrayList<NoteResult> resultList = new ArrayList<NoteResult>();
        List<Long> lockSuccessIds = this.batchLockRequest(draftIdList, resultList);
        try {
            if (EmptyUtil.isEmpty(lockSuccessIds)) {
                ArrayList<NoteResult> arrayList = resultList;
                return arrayList;
            }
            String subBizType = ElcDraftBillOpEnum.getByValue((String)op).getSubBizType();
            Map<Object, List<DynamicObject>> objMap = this.opGroupingByFields(op, lockSuccessIds);
            logger.info("EBServiceFacadeImpl.draftPayBillOp objMap size = {}", (Object)objMap.size());
            for (Map.Entry<Object, List<DynamicObject>> groupDynamic : objMap.entrySet()) {
                IEBServiceExecutor executor = EBServiceExecutorFactory.getEBServiceExecutor();
                IEBService service = EBServiceFactory.getPayNoteRecOpService((String)subBizType, groupDynamic.getValue());
                List res = (List)executor.execute(service);
                resultList.addAll(res);
            }
        }
        catch (Exception ex) {
            logger.error("EBServiceFacadeImpl.draftPayBillOp exception\uff1a", (Throwable)ex);
            throw ex;
        }
        finally {
            this.batchReleaseRequest(lockSuccessIds);
        }
        return resultList;
    }

    public List<EleBillDiscountCalDetail> getDraftBillDiscountCalResult(List<DynamicObject> eleBills) {
        try {
            IEBServiceExecutor executor = EBServiceExecutorFactory.getEBServiceExecutor();
            IEBService service = EBServiceFactory.getDraftBillDiscountCalResult(eleBills);
            return (List)executor.execute(service);
        }
        catch (Exception ex) {
            logger.error("EBServiceFacadeImpl.getDraftBillDiscountCalResult exception\uff1a", (Throwable)ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Boolean, List<NoteResult>> doDraftAllocationService(DynamicObject paybill) {
        ArrayList<Pair> resultList = new ArrayList<Pair>(0);
        Pair result = Pair.of((Object)Boolean.FALSE, resultList);
        ArrayList requestIds = new ArrayList();
        ArrayList requestFailIds = new ArrayList();
        List draftIdList = paybill.getDynamicObjectCollection("draftbill").stream().filter(draftbill -> draftbill.getDynamicObject("fbasedataid") != null).filter(draft -> StringUtils.equals((CharSequence)ReceivePayTypeEnum.RECEIVEBILL.getValue(), (CharSequence)draft.getDynamicObject("fbasedataid").getString("rptype"))).map(draftbill -> draftbill.getDynamicObject("fbasedataid").getString("id")).collect(Collectors.toList());
        Map request = MutexServiceHelper.batchRequestWithLostTime(draftIdList, (String)"cdm_draftbillf7", (String)OP_DODRAFTALLOCATIONSERVICE);
        try {
            List requestDatas;
            Pair ebResult;
            for (Map.Entry entry : request.entrySet()) {
                if (((Boolean)entry.getValue()).booleanValue()) {
                    requestIds.add(entry.getKey());
                    continue;
                }
                requestFailIds.add(entry.getKey());
            }
            if (requestFailIds.size() > 0) {
                DynamicObject[] failDataArr = BusinessDataServiceHelper.load((Object[])requestFailIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
                ebResult = null;
                TmcErrorCode tmcErrorCode = new TmcErrorCode();
                for (DynamicObject data : failDataArr) {
                    ebResult = new NoteResult();
                    ebResult.setStatusCode(EBResultStatusCode.ERROR);
                    ebResult.setErrMsg(tmcErrorCode.BILL_MUTEX_LOCK_WITH_NUMBER(data.getString("billno")).getMessage());
                    ebResult.setBillId(Long.valueOf(data.getLong("id")));
                    resultList.add(ebResult);
                }
            }
            if (EmptyUtil.isEmpty(requestDatas = requestIds.stream().map(Long::valueOf).collect(Collectors.toList()))) {
                ebResult = result;
                return ebResult;
            }
            Pair serviceResult = EBDraftAllocarionService.getInstance().autoService(paybill, requestDatas);
            ((List)serviceResult.getRight()).addAll(resultList);
            result = serviceResult;
        }
        finally {
            MutexServiceHelper.batchRelease(requestIds, (String)"cdm_draftbillf7", (String)OP_DODRAFTALLOCATIONSERVICE);
        }
        return result;
    }

    public List<NoteResult> queryDraftBillByImportBankData(List<String> draftTypeList, Map<String, List<String>> interfaceTypeMap, List<Long> accountIdList, boolean isFromImportBankData, Date dataDate, String bizTypeStr, long orgId) {
        logger.info("EBServiceFacadeImpl.queryDraftBillByImportBankData param = {}", (Object)(draftTypeList.toString() + "_" + interfaceTypeMap.toString() + "_" + accountIdList.toString()));
        LinkedList<NoteResult> resultList = new LinkedList<NoteResult>();
        LinkedList<String> requestIds = new LinkedList<String>();
        LinkedList<Long> requestFailIds = new LinkedList<Long>();
        Map<String, Boolean> request = this.batchBankAccountLock(accountIdList);
        try {
            List requestDatas;
            Object failDatas;
            for (Map.Entry<String, Boolean> entry : request.entrySet()) {
                String key = entry.getKey();
                if (entry.getValue().booleanValue()) {
                    requestIds.add(key);
                    continue;
                }
                requestFailIds.add(Long.valueOf(key));
            }
            logger.info("EBServiceFacadeImpl.queryDraftBillByImportBankData batchBankAccountLock requestIds size = {}", (Object)requestIds.size());
            if (!requestFailIds.isEmpty()) {
                QFilter failIdQF = new QFilter("id", "in", requestFailIds);
                failDatas = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id, number", (QFilter[])failIdQF.toArray());
                TmcErrorCode tmcErrorCode = new TmcErrorCode();
                for (DynamicObject data : failDatas) {
                    NoteResult result = new NoteResult();
                    result.setStatusCode(EBResultStatusCode.ERROR);
                    result.setErrMsg(tmcErrorCode.BILL_MUTEX_LOCK_WITH_NUMBER(data.getString("number")).getMessage());
                    result.setBillId(Long.valueOf(data.getLong("id")));
                    resultList.add(result);
                }
            }
            if (EmptyUtil.isEmpty(requestDatas = requestIds.stream().map(Long::valueOf).collect(Collectors.toList()))) {
                failDatas = resultList;
                return failDatas;
            }
            DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])requestDatas.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks"));
            IEBService service = null;
            for (Map.Entry<String, List<String>> interfaceType : interfaceTypeMap.entrySet()) {
                String isNewECDS = interfaceType.getKey();
                List<String> statusList = interfaceType.getValue();
                for (String status : statusList) {
                    for (DynamicObject accountBank : objs) {
                        HashSet<String> currencies = new HashSet<String>(2);
                        HashSet<Long> currenyIdSet = new HashSet<Long>(2);
                        for (DynamicObject currency : accountBank.getDynamicObjectCollection("currency")) {
                            DynamicObject curr = currency.getDynamicObject("fbasedataid");
                            if (curr == null || !"CNY".equalsIgnoreCase(curr.getString("number"))) continue;
                            currencies.add(curr.getString("number"));
                            currenyIdSet.add(curr.getLong("id"));
                        }
                        logger.info("EBServiceFacadeImpl.queryDraftBillByImportBankData currencies{}", (Object)((Object)currencies).toString());
                        for (Long currencyId : currenyIdSet) {
                            for (String draftType : draftTypeList) {
                                IEBServiceExecutor executor = EBServiceExecutorFactory.getEBServiceExecutor();
                                EleDraftBillQueryInfo eleDraftBillQueryInfo = new EleDraftBillQueryInfo();
                                eleDraftBillQueryInfo.setObj(accountBank);
                                eleDraftBillQueryInfo.setStatus(status);
                                eleDraftBillQueryInfo.setCurrencyNumber("CNY");
                                eleDraftBillQueryInfo.setDraftType(draftType);
                                eleDraftBillQueryInfo.setStartDate(null);
                                eleDraftBillQueryInfo.setEndDate(null);
                                eleDraftBillQueryInfo.setFromBankImport(isFromImportBankData);
                                eleDraftBillQueryInfo.setDraftBillType(bizTypeStr);
                                eleDraftBillQueryInfo.setBizDate(dataDate);
                                eleDraftBillQueryInfo.setOrgId(orgId);
                                eleDraftBillQueryInfo.setAccountId(accountBank.getLong("id"));
                                eleDraftBillQueryInfo.setCurrencyId(currencyId.longValue());
                                eleDraftBillQueryInfo.setAcct(accountBank.getString("number"));
                                eleDraftBillQueryInfo.setBizSubType(EleDraftExistCatEnum.HOLD.getValue());
                                eleDraftBillQueryInfo.setQueryBatchSeq(accountBank.getLong("id") + "_" + System.currentTimeMillis());
                                eleDraftBillQueryInfo.setIsNewECDS(isNewECDS);
                                service = EBServiceFactory.getTicketInfoService((EleDraftBillQueryInfo)eleDraftBillQueryInfo);
                                List res = (List)executor.execute(service);
                                resultList.addAll(res);
                                int totalPage = eleDraftBillQueryInfo.getTotalPage();
                                int concurrent = eleDraftBillQueryInfo.getConcurrent();
                                if (totalPage > 1 && concurrent > 1) {
                                    MulThreadQueryHoldHelper.batchRunQuerySchedule((EleDraftBillQueryInfo)eleDraftBillQueryInfo, (IEBServiceExecutor)executor, (IEBService)service, resultList);
                                } else {
                                    int pageSize = this.getConfigPageSize();
                                    while ("0".equals(eleDraftBillQueryInfo.getKeepFlag()) && eleDraftBillQueryInfo.getPageNum() <= pageSize) {
                                        service = EBServiceFactory.getTicketInfoService((EleDraftBillQueryInfo)eleDraftBillQueryInfo);
                                        res = (List)executor.execute(service);
                                        resultList.addAll(res);
                                    }
                                }
                                logger.info("EBServiceFacadeImpl.queryDraftBillByImportBankData loop end\uff1aeleDraftBillQueryInfo.getKeepFlag() = {},eleDraftBillQueryInfo.acct = {}", (Object)eleDraftBillQueryInfo.getKeepFlag(), (Object)eleDraftBillQueryInfo.getAcct());
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("EBServiceFacadeImpl.queryDraftBillByImportBankData exception\uff1a", (Throwable)ex);
            throw ex;
        }
        finally {
            this.batchBankAccountRelease(requestIds);
        }
        return resultList;
    }

    private List<Long> batchLockRequest(List<Long> draftIdList, List<NoteResult> resultList) {
        ArrayList<Long> requestFailIds = new ArrayList<Long>();
        ArrayList<String> requestIds = new ArrayList<String>();
        List idLists = draftIdList.stream().map(String::valueOf).collect(Collectors.toList());
        Map request = MutexServiceHelper.batchRequestWithLostTime(idLists, (String)"cdm_electronicbill", (String)ELE_DRAFT_BILL_OP_SYNC);
        for (Map.Entry entry : request.entrySet()) {
            String key = (String)entry.getKey();
            if (((Boolean)entry.getValue()).booleanValue()) {
                requestIds.add(key);
                continue;
            }
            requestFailIds.add(Long.valueOf(key));
        }
        if (requestFailIds.size() > 0) {
            DynamicObject[] failDataArr = BusinessDataServiceHelper.load((Object[])requestFailIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronicbill"));
            TmcErrorCode tmcErrorCode = new TmcErrorCode();
            for (DynamicObject data : failDataArr) {
                NoteResult result = new NoteResult();
                result.setStatusCode(EBResultStatusCode.ERROR);
                String billno = data.getString("billno");
                result.setErrMsg(tmcErrorCode.BILL_MUTEX_LOCK_WITH_NUMBER(billno).getMessage());
                result.setBillId(Long.valueOf(data.getLong("id")));
                resultList.add(result);
            }
        }
        return draftIdList.stream().filter(draft -> requestIds.contains(String.valueOf(draft))).collect(Collectors.toList());
    }

    private void batchReleaseRequest(List<Long> requestIds) {
        List idLists = requestIds.stream().map(String::valueOf).collect(Collectors.toList());
        MutexServiceHelper.batchRelease(idLists, (String)"cdm_electronicbill", (String)ELE_DRAFT_BILL_OP_SYNC);
    }

    private Map<String, Boolean> batchBankAccountLock(List<Long> draftIdList) {
        List idLists = draftIdList.stream().map(String::valueOf).collect(Collectors.toList());
        return MutexServiceHelper.batchRequestWithLostTime(idLists, (String)"bd_accountbanks", (String)QUERY_ELE_DRAFT_BILL);
    }

    private void batchBankAccountRelease(List<String> requestIds) {
        MutexServiceHelper.batchRelease(requestIds, (String)"bd_accountbanks", (String)QUERY_ELE_DRAFT_BILL);
    }

    private Map<Object, List<DynamicObject>> opGroupingByFields(String op, List<Long> requestDatas) {
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])requestDatas.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronicbill"));
        if (ElcDraftBillOpEnum.NOTESIGNIN.getValue().equals(op) || ElcDraftBillOpEnum.NOTESIGNINREJECT.getValue().equals(op)) {
            return Arrays.stream(objs).collect(Collectors.groupingBy(o -> o.getString("applicantacctext") + "_" + o.getString("drafttype") + "_" + o.getString("trantype")));
        }
        return Arrays.stream(objs).collect(Collectors.groupingBy(o -> o.getString("applicantacctext") + "_" + o.getString("drafttype")));
    }

    private Map<Object, List<DynamicObject>> syncGroupingByFields(List<Long> requestDatas) {
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])requestDatas.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronicbill"));
        return Arrays.stream(objs).collect(Collectors.groupingBy(o -> o.getString("batchseqid") + "_" + o.getString("applicantacctext") + "_" + o.getString("tradetype") + "_" + o.getString("drafttype")));
    }

    private int getConfigPageSize() {
        QFilter payWriteNumber = new QFilter("number", "=", (Object)"tmc.cdm.elecbill.pagesize");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        DynamicObject conFig = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_extend_config", (String)"configvalue", (QFilter[])new QFilter[]{payWriteNumber, enable});
        if (conFig != null && !"".equals(conFig.getString("configvalue"))) {
            return Integer.parseInt(conFig.getString("configvalue"));
        }
        return 200;
    }
}

