/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.ebservice.draftbill.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.business.ebservice.draftbill.IEleDraftBillCreator;
import kd.tmc.cdm.business.helper.ElectRecClaimRuleHelper;
import kd.tmc.cdm.business.service.EleBillCommonHelper;
import kd.tmc.cdm.common.enums.DataSourceMethodEnum;
import kd.tmc.cdm.common.enums.DraftBillOpStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftCirStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftExistCatEnum;
import kd.tmc.cdm.common.enums.EleDraftIsNewECDS;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.helper.EleDraftHelper;
import kd.tmc.cdm.common.helper.ReturnNoteSetHelper;
import kd.tmc.fbp.common.helper.DateFormatUtil;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.query.DraftBillInfo;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.query.ReciteInfo;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;
import org.apache.commons.lang3.StringUtils;

public class EleDraftBillCreator
implements IEleDraftBillCreator<DraftBillInfo> {
    private static final Log logger = LogFactory.getLog(EleDraftBillCreator.class);
    private static EleDraftBillCreator instance;

    private EleDraftBillCreator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EleDraftBillCreator getInstance() {
        Class<EleDraftBillCreator> clazz = EleDraftBillCreator.class;
        synchronized (EleDraftBillCreator.class) {
            if (instance == null) {
                instance = new EleDraftBillCreator();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<DynamicObject> createDraftBill(List<DraftBillInfo> queryDataList, String connectNo, String status, String bizSubType) {
        ArrayList<DynamicObject> draftBillList = new ArrayList<DynamicObject>(queryDataList.size());
        if (!CollectionUtils.isEmpty(queryDataList)) {
            MainEntityType draftBillEntityType = EntityMetadataCache.getDataEntityType((String)"cdm_electronic_sign_deal");
            for (DraftBillInfo info : queryDataList) {
                draftBillList.add(this.genDynamicObject(draftBillEntityType, info, connectNo, status, bizSubType));
            }
            if (draftBillList.size() > 0) {
                return draftBillList;
            }
        }
        return Collections.emptyList();
    }

    public DynamicObject createDraftBill(DraftBillInfo queryData, String conectNo, String status) {
        if (queryData != null) {
            MainEntityType draftBillEntityType = EntityMetadataCache.getDataEntityType((String)"cdm_electronicbill");
            return this.genDynamicObject(draftBillEntityType, queryData, conectNo, status, "");
        }
        return null;
    }

    private DynamicObject genDynamicObject(MainEntityType draftBillEntityType, DraftBillInfo info, String connectNo, String status, String bizSubType) {
        boolean isInitSubRange;
        logger.info("EleDraftBillCreator connectNo = {},status = {},bizSubType = {}", new Object[]{connectNo, status, bizSubType});
        long pkId = DB.genLongId((String)draftBillEntityType.getAlias());
        DynamicObject draftBill = new DynamicObject((DynamicObjectType)draftBillEntityType, (Object)pkId);
        if (EleDraftExistCatEnum.REPLY.getValue().equalsIgnoreCase(bizSubType)) {
            draftBill.set("querydrafttype", (Object)EleDraftExistCatEnum.REPLY.getValue());
        }
        if (EleDraftExistCatEnum.HOLD.getValue().equalsIgnoreCase(bizSubType)) {
            draftBill.set("ebstatus", (Object)EbStatus.BANK_SUCCESS.getName());
        }
        draftBill.set("interfacetype", (Object)(EleDraftIsNewECDS.NEW.getValue().equals(info.getIsNewECDS()) ? EleDraftIsNewECDS.NEW.getValue() : EleDraftIsNewECDS.OLD.getValue()));
        if (EleDraftIsNewECDS.NEW.getValue().equals(info.getIsNewECDS())) {
            EleDraftNoteStatusEnum newNoteStatus = EleDraftNoteStatusEnum.getByValue((String)info.getNoteStatus());
            draftBill.set("notestatus", (Object)(null == newNoteStatus ? info.getNoteStatus() : newNoteStatus.getValue()));
            this.newEleInterfaceFields(draftBill, info);
            if (EleDraftNoteStatusEnum.CS01.getValue().equals(draftBill.getString("notestatus")) && EleDraftCirStatusEnum.TF0302.getValue().equals(draftBill.getString("cirstatus"))) {
                draftBill.set("isinsertpayorrec", (Object)Boolean.FALSE);
            } else {
                draftBill.set("isinsertpayorrec", (Object)Boolean.TRUE);
            }
            draftBill.set("uniquecode", (Object)(info.getSubRange().indexOf(",") > 0 ? info.getNoteNo() + "-" + EleDraftHelper.tranSubRangeStyle((String)info.getSubRange()) : info.getNoteNo()));
        } else {
            EleDraftBillStatusEnum byEbValue = EleDraftBillStatusEnum.getByEbValue((String)info.getNoteStatus());
            draftBill.set("ticketstatus", (Object)(null == byEbValue ? info.getNoteStatus() : byEbValue.getValue()));
            if (EleDraftBillStatusEnum.ACCEPTANCE.getValue().equals(draftBill.getString("ticketstatus"))) {
                draftBill.set("isinsertpayorrec", (Object)Boolean.FALSE);
            } else {
                draftBill.set("isinsertpayorrec", (Object)Boolean.TRUE);
            }
            draftBill.set("subrange", (Object)"0");
            draftBill.set("uniquecode", (Object)info.getNoteNo());
        }
        draftBill.set("initsubrange", (Object)EleDraftHelper.tranSubRangeStyle((String)info.getSubRange()));
        boolean bl = isInitSubRange = StringUtils.isEmpty((CharSequence)info.getSubRange()) && StringUtils.isNotEmpty((CharSequence)info.getStartNo()) && StringUtils.isNotEmpty((CharSequence)info.getEndNo());
        if (isInitSubRange) {
            draftBill.set("initsubrange", (Object)EleDraftHelper.tranSubRangeStyle((String)String.join((CharSequence)",", info.getStartNo(), info.getEndNo())));
        }
        draftBill.set("initamount", (Object)info.getAmount());
        draftBill.set("conectno", (Object)connectNo);
        draftBill.set("rptype", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue());
        draftBill.set("backflag", (Object)"0");
        draftBill.set("billstatus", (Object)"C");
        draftBill.set("modifytime", (Object)new Date());
        draftBill.set("createtime", (Object)new Date());
        draftBill.set("creator", (Object)RequestContext.get().getCurrUserId());
        draftBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
        draftBill.set("billno", (Object)info.getNoteNo());
        draftBill.set("amount", (Object)info.getAmount());
        draftBill.set("opstatus", (Object)DraftBillOpStatusEnum.INIT.getValue());
        draftBill.set("drafttype", (Object)info.getDraftType());
        draftBill.set("applicantacctext", (Object)connectNo);
        DynamicObject[] accountBank = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bank,company,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)connectNo)});
        if (accountBank.length > 0) {
            Long directconnchannel;
            draftBill.set("company", (Object)accountBank[0].getDynamicObject("company"));
            draftBill.set("applicanttext", (Object)accountBank[0].getDynamicObject("company").getString("name"));
            draftBill.set("draftaccount", (Object)accountBank[0]);
            DynamicObject electDirectConnectColl = QueryServiceHelper.queryOne((String)"cdm_electicdirconset", (String)"id,directconnchannel,defaultaccount", (QFilter[])new QFilter[]{new QFilter("defaultaccount.id", "=", accountBank[0].getPkValue())});
            if (!ObjectUtils.isEmpty((Object)electDirectConnectColl) && EmptyUtil.isNoEmpty((Long)(directconnchannel = Long.valueOf(electDirectConnectColl.getLong("directconnchannel"))))) {
                logger.info("EleDraftBillCreator directconnchannel is not null");
                draftBill.set("connchannel", (Object)directconnchannel);
            }
        }
        draftBill.set("applicantbanknotext", (Object)info.getApplicantBankCnaps());
        String bizDateStr = info.getApplicationDate();
        Date bizDate = StringUtils.isEmpty((CharSequence)bizDateStr) ? new Date() : (bizDateStr.length() == 8 ? DateUtils.stringToDate((String)bizDateStr, (String)"yyyyMMdd") : DateUtils.stringToDate((String)bizDateStr, (String)"yyyy-MM-dd"));
        draftBill.set("bizdate", (Object)bizDate);
        draftBill.set("bizcode", (Object)info.getBusinessCode());
        draftBill.set("bankconsultno", (Object)info.getBankRefKey());
        draftBill.set("bankrefdate", (Object)info.getBankRefDate());
        draftBill.set("customerconsultno", (Object)info.getCoustomerRefKey());
        draftBill.set("customeropstatus", (Object)info.getCoustomerStutus());
        DynamicObjectCollection currency = QueryServiceHelper.query((String)"bd_currency", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)info.getCurrency())});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currency)) {
            draftBill.set("currency", (Object)((DynamicObject)currency.get(0)).getLong("id"));
            draftBill.set("currencytext", (Object)((DynamicObject)currency.get(0)).getString("name"));
        }
        DynamicObject dynamicObject = new DynamicObject();
        draftBill.set("issueticketdate", (Object)DateFormatUtil.FormatDate((String)info.getIssueDate()));
        draftBill.set("exchangebillexpiredate", (Object)DateFormatUtil.FormatDate((String)info.getDueDate()));
        draftBill.set("istransfer", (Object)("EM01".equals(info.getTransferFlag()) ? "0" : "1"));
        draftBill.set("invoicenumber", (Object)info.getInvoiceNumer());
        draftBill.set("contractnumber", (Object)info.getContractNumber());
        draftBill.set("keepflag", (Object)("1".equals(info.getKeepFlag()) ? "1" : "0"));
        draftBill.set("autoaccept", (Object)("1".equals(info.getAutoAccept()) ? "1" : "0"));
        draftBill.set("autoreceive", (Object)("1".equals(info.getAutoReceive()) ? "1" : "0"));
        draftBill.set("explain", (Object)info.getExplain());
        draftBill.set("remark", (Object)info.getRemark());
        draftBill.set("pretypeflag", (Object)("1".equals(info.getPreTypeFlag()) ? "1" : "0"));
        draftBill.set("indorsename", (Object)info.getIndorseName());
        draftBill.set("discountrate", (Object)info.getDisCountRate());
        draftBill.set("loanamount", (Object)info.getLoanAmount());
        draftBill.set("issueticketertext", (Object)info.getDrawerAccName());
        draftBill.set("issueticketbanktext", (Object)info.getDrawerBankName());
        draftBill.set("issueticketbankno", (Object)info.getDrawerCnapsCode());
        draftBill.set("issueticketacctext", (Object)info.getDrawerAccNo());
        draftBill.set("promiseracctext", (Object)info.getAcceptorAccNo());
        draftBill.set("promisertext", (Object)info.getAcceptorAccName());
        draftBill.set("promiserbanktext", (Object)info.getAcceptorBankName());
        draftBill.set("promiserbankno", (Object)info.getAcceptorCnapsCode());
        draftBill.set("collectionacctext", (Object)info.getPayeeAccNo());
        draftBill.set("collectionertext", (Object)info.getPayeeAccName());
        draftBill.set("collectionbanktext", (Object)info.getPayeeBankName());
        draftBill.set("collectionbankno", (Object)info.getPayeeCnapsCode());
        draftBill.set("holderaccno", (Object)info.getHolderAccNo());
        draftBill.set("holderbankname", (Object)info.getHolderBankName());
        draftBill.set("holdercnapscode", (Object)info.getHolderCnapsCode());
        draftBill.set("applicantbanktext", (Object)info.getApplicantBankName());
        draftBill.set("issueticketpromise", (Object)ResManager.loadKDString((String)"\u672c\u6c47\u7968\u8bf7\u4e88\u4ee5\u627f\u5151\uff0c\u5230\u671f\u65e0\u6761\u4ef6\u4ed8\u6b3e", (String)"EleDraftBillCreator_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
        draftBill.set("promiseinfo", (Object)ResManager.loadKDString((String)"\u672c\u6c47\u7968\u5df2\u7ecf\u627f\u5151\uff0c\u5230\u671f\u65e0\u6761\u4ef6\u4ed8\u6b3e", (String)"EleDraftBillCreator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
        draftBill.set("promisedate", (Object)DateFormatUtil.FormatDate((String)info.getIssueDate()));
        DynamicObjectCollection entry = draftBill.getDynamicObjectCollection("entryentity");
        List sideInfos = info.getNoteSidesInfo();
        logger.info("EleDraftBillCreator sideInfos.size = {}", (Object)sideInfos.size());
        if (sideInfos.size() > 0) {
            sideInfos = sideInfos.stream().sorted(Comparator.comparing(o -> Integer.valueOf(StringUtils.isEmpty((CharSequence)o.getResv1()) ? "0" : o.getResv1()))).collect(Collectors.toList());
            for (int i = 0; i < sideInfos.size(); ++i) {
                ReciteInfo side = (ReciteInfo)sideInfos.get(i);
                DynamicObject newEntry = entry.addNew();
                newEntry.set("seq", (Object)(i + 1));
                newEntry.set("noteno", (Object)side.getNoteNo());
                newEntry.set("detailseq", (Object)side.getDetailSeq());
                newEntry.set("businesscode", (Object)side.getBusinessCode());
                newEntry.set("subtype", (Object)side.getSubType());
                newEntry.set("initiatororg", (Object)side.getInitiatorORG());
                newEntry.set("initiatorname", (Object)side.getInitiatorName());
                newEntry.set("initiatorbankcnaps", (Object)side.getInitiatorBankCnaps());
                newEntry.set("initiatoracno", (Object)side.getInitiatorAcNo());
                newEntry.set("opponentorg", (Object)side.getOpponentORG());
                newEntry.set("opponentname", (Object)side.getOpponentName());
                newEntry.set("opponentbankcnaps", (Object)side.getOpponentBankCnaps());
                newEntry.set("opponentcl", (Object)side.getOpponentCL());
                newEntry.set("opponentlorg", (Object)side.getOpponentLORG());
                newEntry.set("opponentduedate", (Object)side.getOpponentDueDate());
                newEntry.set("signdate", (Object)side.getSignDate());
                newEntry.set("replycode", (Object)side.getReplyCode());
                newEntry.set("dealno", (Object)side.getDealNo());
                newEntry.set("invoiceno", (Object)side.getInvoiceNo());
                newEntry.set("contractno", (Object)side.getContractNo());
                newEntry.set("paymentorder", (Object)side.getPaymentOrder());
                newEntry.set("paymentaccept", (Object)side.getPaymentAccept());
                newEntry.set("transferflag", (Object)side.getTransferFlag());
                newEntry.set("olclearingflag", (Object)side.getOlclearingFlag());
                newEntry.set("discounttype", (Object)side.getDiscountType());
                newEntry.set("discountrateentry", (Object)side.getDiscountRate());
                newEntry.set("discountamount", (Object)side.getDiscountAmount());
                newEntry.set("redemptionsdate", (Object)side.getRedemptionSDate());
                newEntry.set("disredrate", (Object)side.getDisRedRate());
                newEntry.set("disredamount", (Object)side.getDisRedAmount());
                newEntry.set("pre4paydate", (Object)side.getPre4PayDate());
                newEntry.set("currencyentry", (Object)side.getCurrency());
                newEntry.set("tradeamount", (Object)side.getAmount());
                newEntry.set("defaultfpcode", (Object)side.getDefaultFPCode());
                newEntry.set("remarkentry", (Object)side.getRemark());
                newEntry.set("tracktype", (Object)side.getTrackType());
                newEntry.set("trackdate", (Object)side.getTrackDate());
                newEntry.set("cleardate", (Object)side.getClearDate());
                newEntry.set("acountbankcnaps", (Object)side.getAcountBankCnaps());
                newEntry.set("accountno", (Object)side.getAccountNo());
                newEntry.set("endorser", (Object)side.getInitiatorName());
                newEntry.set("endorsee", (Object)side.getOpponentName());
                Date signDate = side.getSignDate() == null ? new Date() : (side.getSignDate().length() == 8 ? DateUtils.stringToDate((String)side.getSignDate(), (String)"yyyyMMdd") : DateUtils.stringToDate((String)side.getSignDate(), (String)"yyyy-MM-dd"));
                newEntry.set("endorsedate", (Object)signDate);
            }
            draftBill.set("backinfoseries", (Object)EleBillCommonHelper.isBackInfoSeries((DynamicObjectCollection)entry));
            draftBill.set("seriescheckdate", (Object)new Date());
        } else {
            draftBill.set("backinfoseries", (Object)Boolean.TRUE);
            draftBill.set("seriescheckdate", (Object)new Date());
        }
        sideInfos = sideInfos.stream().filter(o -> !"02".equals(o.getBusinessCode()) && !"03".equals(o.getBusinessCode())).sorted(Comparator.comparing(o -> Integer.valueOf(StringUtils.isEmpty((CharSequence)o.getResv1()) ? "0" : o.getResv1()))).collect(Collectors.toList());
        if (StringUtil.isEmpty((String)info.getPreHolderName()) && !EleDraftBillStatusEnum.INVOICE.getValue().equals(draftBill.getString("ticketstatus"))) {
            if (sideInfos.size() > 0) {
                String initiatorNameStr = "";
                if (EleDraftExistCatEnum.REPLY.getValue().equalsIgnoreCase(bizSubType)) {
                    initiatorNameStr = "301".equals(EleDraftBillCreator.getBankCateTypeCode(connectNo)) ? ((ReciteInfo)sideInfos.get(0)).getInitiatorName() : ((ReciteInfo)sideInfos.get(0)).getOpponentName();
                } else if (EleDraftExistCatEnum.HOLD.getValue().equalsIgnoreCase(bizSubType)) {
                    initiatorNameStr = ((ReciteInfo)sideInfos.get(0)).getInitiatorName();
                }
                draftBill.set("preholdername", (Object)initiatorNameStr);
            } else if (draftBill.getString("collectionacctext").equals(draftBill.getString("conectno"))) {
                draftBill.set("preholdername", (Object)info.getDrawerAccName());
            } else {
                draftBill.set("preholdername", (Object)info.getPayeeAccName());
            }
        } else if (EleDraftExistCatEnum.HOLD.getValue().equalsIgnoreCase(bizSubType)) {
            if (sideInfos.size() > 0) {
                String initiatorNameStr = ((ReciteInfo)sideInfos.get(0)).getInitiatorName();
                draftBill.set("preholdername", (Object)initiatorNameStr);
            }
        } else {
            draftBill.set("preholdername", (Object)(StringUtil.isEmpty((String)info.getPreHolderName()) ? info.getApplicantAcName() : info.getPreHolderName()));
        }
        draftBill.set("oppaccname", (Object)draftBill.getString("preholdername"));
        logger.info("EleDraftBillCreator sideInfos:PreHolderName=" + draftBill.get("preholdername"));
        DynamicObject ruleResult = ElectRecClaimRuleHelper.getClaimInfoByNoticeRule((DynamicObject)draftBill, (String)"");
        if (!ObjectUtils.isEmpty((Object)ruleResult)) {
            String handleScheme = ruleResult.getString("e_handlescheme");
            String refuseRemark = ruleResult.getString("e_refuseremark");
            draftBill.set("autoexecuteop", (Object)handleScheme);
            if ("notesigninreject".equals(handleScheme) && StringUtils.isNotEmpty((CharSequence)refuseRemark)) {
                draftBill.set("signopinion", (Object)"reject");
            } else if ("notesignin".equals(handleScheme)) {
                draftBill.set("signopinion", (Object)"sign");
            }
        } else {
            boolean isAutoSignIn = EleBillCommonHelper.isInternalUnit((String)draftBill.getString("preholdername"), (DynamicObject)draftBill.getDynamicObject("company"));
            draftBill.set("isautosignin", (Object)isAutoSignIn);
        }
        if (accountBank.length > 0 && !EleDraftBillStatusEnum.ACCEPTANCE.getValue().equals(draftBill.getString("ticketstatus")) && !EleDraftBillStatusEnum.INVOICE.getValue().equals(draftBill.getString("ticketstatus"))) {
            DynamicObject company = accountBank[0].getDynamicObject("company");
            boolean isReturnNote = ReturnNoteSetHelper.isReturnNote((DynamicObject)company, (DynamicObject)draftBill);
            draftBill.set("returnnotetag", (Object)isReturnNote);
        }
        draftBill.set("datasource", (Object)DataSourceMethodEnum.BANK.getValue());
        draftBill.set("explain", (Object)info.getExplain());
        draftBill.set("remark", (Object)(StringUtils.isEmpty((CharSequence)info.getRemark()) && !ObjectUtils.isEmpty((Object)ruleResult) ? ruleResult.getString("e_refuseremark") : info.getRemark()));
        draftBill.set("isnotesideserror", (Object)"Y".equals(info.getIsNoteSidesError()));
        return draftBill;
    }

    private static String getBankCateTypeCode(String connectNo) {
        String bankCateTypeCode = "";
        if (StringUtils.isEmpty((CharSequence)connectNo)) {
            return bankCateTypeCode;
        }
        QFilter qFilter = new QFilter("defaultaccount.bankaccountnumber", "=", (Object)connectNo);
        DynamicObjectCollection eleConSets = QueryServiceHelper.query((String)"cdm_electicdirconset", (String)"id,directconnchannel", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)eleConSets)) {
            Long directconnchannelId;
            Long l = directconnchannelId = EmptyUtil.isEmpty((Long)((DynamicObject)eleConSets.get(0)).getLong("directconnchannel")) ? null : Long.valueOf(((DynamicObject)eleConSets.get(0)).getLong("directconnchannel"));
            if (EmptyUtil.isNoEmpty(directconnchannelId)) {
                logger.info("directconnchannelId is that:{}", (Object)directconnchannelId);
                DynamicObject bankCateTypeCodeDy = QueryServiceHelper.queryOne((String)"bd_bankcgsetting", (String)"type_code", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)directconnchannelId)});
                bankCateTypeCode = EmptyUtil.isEmpty((DynamicObject)bankCateTypeCodeDy) ? "" : bankCateTypeCodeDy.getString("type_code");
            } else {
                logger.info("directconnchannelId is null");
            }
        }
        logger.info("\u6839\u636e\u76f4\u8fde\u8d26\u53f7 {} \u83b7\u53d6\u94f6\u884c\u7c7b\u522b\u7684bankCateTypeCode = {}", (Object)connectNo, (Object)bankCateTypeCode);
        return bankCateTypeCode;
    }
}

