/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.ebservice.request.datasource.draftbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.business.ebservice.request.datasource.draftbill.IEleDraftBillRequestDataSource;
import kd.tmc.cdm.common.bean.DraftBillDiscountCalRequestBody;
import kd.tmc.cdm.common.bean.EleBillDiscountCalDetail;
import kd.tmc.cdm.common.enums.ElcDraftBillOpEnum;
import kd.tmc.cdm.common.enums.ElcNoteSignEnum;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftIsNewECDS;
import kd.tmc.cdm.common.helper.EleDraftHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.utils.BeServiceHelper;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.op.DraftBillOpRequestBody;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.op.DraftPayBillNoteDetail;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.op.DraftPayBillOpRequestBody;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.op.DraftRecBillNoteDetail;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.sync.DraftBillSyncRequestBody;

public class EleDraftBillBatchRequestDataSource
implements IEleDraftBillRequestDataSource {
    private static final Log logger = LogFactory.getLog(EleDraftBillBatchRequestDataSource.class);
    private static final List<String> OP_SING_IN = Arrays.asList(ElcDraftBillOpEnum.NOTESIGNIN.getValue(), ElcDraftBillOpEnum.NOTESIGNINREJECT.getValue());
    private List<DynamicObject> bills;
    private String op;

    public EleDraftBillBatchRequestDataSource(List<DynamicObject> bills) {
        this.bills = bills;
    }

    public EleDraftBillBatchRequestDataSource(String op, List<DynamicObject> bills) {
        this.bills = bills;
        this.op = op;
    }

    public DraftBillSyncRequestBody getSyncRequestBody() {
        DraftBillSyncRequestBody detail = new DraftBillSyncRequestBody();
        detail.setBatchSeqId(this.bills.get(0).getString("batchseqid"));
        if (detail.getBatchSeqId() == null || "".equals(detail.getBatchSeqId())) {
            detail.setBatchSeqId(this.bills.get(0).getString("detailseqid"));
        }
        return detail;
    }

    public String getAcctNo() {
        return this.bills.get(0).getString("applicantacctext");
    }

    public String getAcctName() {
        return this.bills.get(0).getString("applicanttext");
    }

    public String getCurrency() {
        DynamicObject dynamicObject = this.bills.get(0).getDynamicObject("currency");
        if (dynamicObject != null) {
            return dynamicObject.getString("number");
        }
        return "";
    }

    public DraftBillOpRequestBody getReceivableOpRequest() {
        DraftBillOpRequestBody body = new DraftBillOpRequestBody();
        String batchSeqId = this.bills.get(0).getString("batchseqid");
        body.setBatchSeqId(batchSeqId);
        ArrayList<DraftRecBillNoteDetail> detailList = new ArrayList<DraftRecBillNoteDetail>(8);
        for (DynamicObject bill : this.bills) {
            boolean isDiscountFlag;
            boolean isAllowSetSettleWay;
            BigDecimal amount;
            DraftRecBillNoteDetail detail = new DraftRecBillNoteDetail();
            String noteStatus = bill.getString("notestatus");
            String subRange = bill.getString("subrange");
            String isNewECDS = EleDraftHelper.isNewECDs((String)noteStatus, (String)subRange);
            detail.setIsNewECDS(isNewECDS);
            if (EleDraftIsNewECDS.NEW.getValue().equals(isNewECDS)) {
                detail.setGrdBag(bill.getBoolean("grdbag") ? "1" : "0");
                detail.setStartNo(bill.getBoolean("grdbag") ? EleDraftHelper.tranSubRangeStartNo((String)subRange) : "0");
                detail.setEndNo(bill.getBoolean("grdbag") ? EleDraftHelper.tranSubRangeEndNo((String)subRange) : "0");
                detail.setSubRange(bill.getBoolean("grdbag") ? EleDraftHelper.tranSubRangeToYQ((String)subRange) : "0");
                detail.setCirStatus(bill.getString("cirstatus"));
                detail.setSettleWay(bill.getString("settleway"));
                detail.setClearType(bill.getString("cleartype"));
                detail.setNoteStatus(bill.getString("notestatus"));
            } else {
                detail.setNoteStatus(this.getEbNoteStatusVal(bill.getString("ticketstatus")));
            }
            String ticketStatus = bill.getString("ticketstatus");
            if (OP_SING_IN.contains(this.op.replace("_", ""))) {
                if (StringUtils.isNotEmpty((CharSequence)ticketStatus)) {
                    detail.setOperationCode(ElcNoteSignEnum.getByName((String)ticketStatus).getCode());
                } else {
                    detail.setOperationCode(bill.getString("operationcode"));
                }
            } else if (ElcDraftBillOpEnum.NOTECANCLE.getValue().equals(this.op.replace("_", ""))) {
                detail.setOperationCode(ElcDraftBillOpEnum.getByValue((String)bill.getString("tradetype")).getCode());
                if (EleDraftIsNewECDS.NEW.getValue().equals(isNewECDS) && subRange.length() > 1) {
                    BigDecimal locAmt = bill.getBigDecimal("locamt");
                    amount = bill.getBigDecimal("amount");
                    if (locAmt.compareTo(new BigDecimal(0)) > 0 && locAmt.compareTo(amount) != 0) {
                        String startFlag = subRange.substring(0, subRange.indexOf("-"));
                        String endFlag = new BigDecimal(startFlag).add(locAmt.multiply(new BigDecimal(100))).subtract(new BigDecimal(1)).stripTrailingZeros().toPlainString();
                        String subEleBill = startFlag + "-" + endFlag;
                        detail.setSubRange(EleDraftHelper.tranSubRangeToYQ((String)subEleBill));
                        detail.setStartNo(EleDraftHelper.tranSubRangeStartNo((String)subEleBill));
                        detail.setEndNo(EleDraftHelper.tranSubRangeEndNo((String)subEleBill));
                    }
                }
            } else if (ElcDraftBillOpEnum.NOTEDISCOUNT.getValue().equals(this.op.replace("_", ""))) {
                detail.setOperationCode("RM00");
                detail.setContractNo(StringUtils.isEmpty((CharSequence)bill.getString("tradecontractno")) ? DateUtils.formatString((Date)new Date(), (String)"yyyyMMdd") : bill.getString("tradecontractno"));
                detail.setAutoAccept(bill.getBoolean("autoaccept") ? "0" : "1");
                detail.setSettleWay("ST01");
            } else if (ElcDraftBillOpEnum.PRESENTPAYMENT.getValue().equals(this.op.replace("_", ""))) {
                boolean isOverDue;
                detail.setOperationCode(ElcDraftBillOpEnum.getByValue((String)this.op.replace("_", "")).getCode());
                boolean bl = isOverDue = new Date().compareTo(bill.getDate("exchangebillexpiredate")) > 0;
                if (isOverDue) {
                    detail.setOperationCode("21");
                }
            } else if (ElcDraftBillOpEnum.PLEDGENOTE.getValue().equals(this.op.replace("_", ""))) {
                detail.setReserved2(bill.getString("pledgeetype"));
                detail.setReserved3(bill.getString("othercode"));
                detail.setReserveds(bill.getString("oppaccname"));
            }
            detail.setDetailSeqID(bill.getString("id"));
            detail.setDetailBizNo(StringUtils.isEmpty((CharSequence)bill.getString("detailbizno")) ? batchSeqId : bill.getString("detailbizno"));
            if (ElcDraftBillOpEnum.NOTEDISCOUNT.getValue().equals(bill.getString("tradetype")) || ElcDraftBillOpEnum.PRESENTPAYMENT.getValue().equals(bill.getString("tradetype"))) {
                DynamicObject promiseAccount = bill.getDynamicObject("promiseracc");
                detail.setAcceptorAccNo(ObjectUtils.isEmpty((Object)promiseAccount) ? "" : promiseAccount.getString("bankaccountnumber"));
                detail.setAcceptorAccName(ObjectUtils.isEmpty((Object)promiseAccount) ? "" : promiseAccount.getString("acctname"));
                if (!ObjectUtils.isEmpty((Object)promiseAccount)) {
                    DynamicObject finOrgInfo = BusinessDataServiceHelper.loadSingle((Object)promiseAccount.getDynamicObject("bank").getPkValue(), (String)"bd_finorginfo");
                    detail.setAcceptorCnapsCode(ObjectUtils.isEmpty((Object)finOrgInfo) ? "" : finOrgInfo.getString("union_number"));
                    detail.setAcceptorBankName(ObjectUtils.isEmpty((Object)promiseAccount) ? "" : promiseAccount.getDynamicObject("bank").getString("name"));
                    detail.setAcceptorBankAddr(ObjectUtils.isEmpty((Object)finOrgInfo) ? "" : finOrgInfo.getString("address"));
                    detail.setAcceptorCountry(ObjectUtils.isEmpty((Object)finOrgInfo) ? "" : finOrgInfo.getDynamicObject("country").getString("name"));
                    detail.setAcceptorProvince(ObjectUtils.isEmpty((Object)finOrgInfo) ? "" : finOrgInfo.getDynamicObject("province").getString("name"));
                    detail.setAcceptorCity(ObjectUtils.isEmpty((Object)finOrgInfo) ? "" : finOrgInfo.getDynamicObject("city").getString("name"));
                }
                if (ElcDraftBillOpEnum.NOTEDISCOUNT.getValue().equals(this.op.replace("_", "")) && StringUtils.isNotEmpty((CharSequence)bill.getString("promiseorgno"))) {
                    detail.setAcceptorCity(bill.getString("promiseorgno"));
                }
            } else {
                detail.setAcceptorAccNo(bill.getString("promiseracctext"));
                detail.setAcceptorAccName(bill.getString("promisertext"));
                detail.setAcceptorCnapsCode(bill.getString("promiserbankno"));
                detail.setAcceptorBankName(bill.getString("promiserbanktext"));
            }
            detail.setOppAccNo(bill.getString("oppaccno"));
            detail.setOppAccName(bill.getString("oppaccname"));
            detail.setOppCnapsCode(bill.getString("oppcnapscode"));
            if (ElcDraftBillOpEnum.NOTESIGNIN.getValue().equals(this.op.replace("_", "")) || ElcDraftBillOpEnum.NOTESIGNINREJECT.getValue().equals(this.op.replace("_", ""))) {
                detail.setOppCnapsCode(bill.getString("applicantbanknotext"));
            }
            detail.setOppBankName(bill.getString("oppbankname"));
            detail.setOppBankAddr(bill.getString("oppbankaddr"));
            detail.setOppCountry(bill.getString("oppcountry"));
            detail.setOppProvince(bill.getString("oppprovince"));
            detail.setOppCity(bill.getString("oppcity"));
            BigDecimal draftAmount = bill.getBigDecimal("amount").setScale(2, RoundingMode.HALF_UP);
            amount = bill.getBigDecimal("locamt").setScale(2, RoundingMode.HALF_UP);
            boolean isAmountEmpty = amount == null || amount.compareTo(new BigDecimal("0.00")) == 0;
            detail.setOppAmount(isAmountEmpty ? draftAmount.toString() : amount.toString());
            detail.setDraftAmount(draftAmount.toString());
            detail.setBillNo(bill.getString("billno"));
            detail.setDraftType(bill.getString("drafttype"));
            String transfer = bill.getBoolean("istransfer") ? "EM00" : "EM01";
            detail.setTransferFlag(transfer);
            detail.setDueDate(DateUtils.formatString((Date)bill.getDate("exchangebillexpiredate"), (String)"yyyyMMdd"));
            detail.setDesc(bill.getString("explain"));
            if (ElcDraftBillOpEnum.NOTESIGNINREJECT.getValue().equals(this.op.replace("_", ""))) {
                detail.setDesc(bill.getString("remark"));
            }
            if (ElcDraftBillOpEnum.NOTEDISCOUNT.getValue().equals(bill.getString("tradetype")) || ElcDraftBillOpEnum.PRESENTPAYMENT.getValue().equals(bill.getString("tradetype"))) {
                detail.setOtherInfo(bill.getString("otherinfo"));
            } else {
                detail.setOtherInfo(ElcDraftBillOpEnum.getBySub((String)this.op).getOtherInfo());
            }
            detail.setDiscountType(bill.getString("discountpaytype"));
            detail.setIncreaseRate(bill.getString("increaserate"));
            BigDecimal discountRate = bill.getBigDecimal("discountrate");
            detail.setDisCountRate(discountRate.compareTo(BigDecimal.ZERO) == 0 ? "0" : discountRate.setScale(4, RoundingMode.HALF_DOWN).toString());
            detail.setInterest(bill.getString("interest"));
            detail.setDiscountAmount(bill.getString("actdiscountamount"));
            detail.setAddDate(String.valueOf(bill.get("discountdays")));
            detail.setDiscountAccNo(this.getAcctNo());
            detail.setDiscountAccName(this.getAcctName());
            detail.setRegisterName(bill.getString("issueticketertext"));
            detail.setRegisterAcno(bill.getString("issueticketacctext"));
            detail.setRegisterBankName(bill.getString("issueticketbanktext"));
            detail.setBankRefKey(bill.getString("bankconsultno"));
            detail.setBankRefDate(bill.getString("bankrefdate"));
            detail.setBookingDate(DateUtils.formatString((Date)(bill.getDate("bizdate") == null ? new Date() : bill.getDate("bizdate")), (String)"yyyyMMdd"));
            logger.info("\u7968\u636e\u53f7\u7801 = {},\u7968\u636eid = {},\u4e1a\u52a1\u65e5\u671f = {}", new Object[]{bill.get("billno"), bill.get("id"), bill.getDate("bizdate")});
            detail.setIssueDate(DateUtils.formatString((Date)bill.getDate("issueticketdate"), (String)"yyyyMMdd"));
            boolean bl = isAllowSetSettleWay = EleDraftIsNewECDS.NEW.getValue().equals(isNewECDS) && (ElcDraftBillOpEnum.NOTEDISCOUNT.getValue().equals(this.op.replace("_", "")) || ElcDraftBillOpEnum.PRESENTPAYMENT.getValue().equals(this.op.replace("_", "")) || ElcDraftBillOpEnum.NOTEENDORSE.getValue().equals(this.op.replace("_", "")) || ElcDraftBillOpEnum.PLEDGENOTE.getValue().equals(this.op.replace("_", "")));
            if (isAllowSetSettleWay) {
                detail.setSettleWay(EmptyUtil.isEmpty((String)bill.getString("settleway")) ? "ST01" : bill.getString("settleway"));
                detail.setClearType(EmptyUtil.isEmpty((String)bill.getString("cleartype")) ? "CT01" : bill.getString("cleartype"));
            }
            if (isDiscountFlag = ElcDraftBillOpEnum.NOTEDISCOUNT.getValue().equals(this.op.replace("_", ""))) {
                detail.setInvcType(bill.getString("invctype"));
                detail.setInvcNo(bill.getString("invcno"));
                detail.setInvcCode(bill.getString("invccode"));
                detail.setInvcChkNo(bill.getString("invcchkno"));
                BigDecimal invcAmt = bill.getBigDecimal("invcamt");
                if (EmptyUtil.isNoEmpty((BigDecimal)invcAmt)) {
                    detail.setInvcAmt(bill.getString("invcamt"));
                } else {
                    detail.setInvcAmt("");
                }
                Date invcDate = bill.getDate("invcdate");
                String invcDateStr = EmptyUtil.isEmpty((Object)invcDate) ? "" : DateUtils.formatString((Date)invcDate, (String)"yyyyMMdd");
                detail.setInvcDate(invcDateStr);
            }
            detailList.add(detail);
        }
        body.setTotalCount(detailList.size());
        BigDecimal totalAmount = detailList.stream().map(DraftRecBillNoteDetail::getOppAmount).map(BigDecimal::new).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
        body.setTotalAmount(this.transAmount(totalAmount));
        body.setDetails(detailList);
        return body;
    }

    public DraftPayBillOpRequestBody getPayableOpRequest() {
        DraftPayBillOpRequestBody body = new DraftPayBillOpRequestBody();
        String batchSeqId = this.bills.get(0).getString("batchseqid");
        body.setBatchSeqId(batchSeqId);
        ArrayList<DraftPayBillNoteDetail> detailList = new ArrayList<DraftPayBillNoteDetail>(8);
        for (DynamicObject bill : this.bills) {
            DraftPayBillNoteDetail detail = new DraftPayBillNoteDetail();
            String noteStatus = bill.getString("notestatus");
            String subRange = bill.getString("subrange");
            String isNewECDS = EleDraftHelper.isNewECDs((String)noteStatus, (String)subRange);
            detail.setIsNewECDS(isNewECDS);
            if (EleDraftIsNewECDS.NEW.getValue().equals(isNewECDS)) {
                detail.setStartNo(bill.getBoolean("grdbag") ? EleDraftHelper.tranSubRangeStartNo((String)subRange) : "0");
                detail.setEndNo(bill.getBoolean("grdbag") ? EleDraftHelper.tranSubRangeEndNo((String)subRange) : "0");
                detail.setSubRange(bill.getBoolean("grdbag") ? EleDraftHelper.tranSubRangeToYQ((String)subRange) : "0");
                detail.setCirStatus(bill.getString("cirstatus"));
                detail.setDraftAmount(bill.getString("amount"));
                detail.setNoteStatus("preregister".equals(bill.getString("notestatus")) ? "999999" : ("registering".equals(bill.getString("notestatus")) ? "" : bill.getString("notestatus")));
            } else {
                detail.setNoteStatus(this.getEbNoteStatusVal(bill.getString("ticketstatus")));
            }
            detail.setGrdBag(bill.getBoolean("grdbag") ? "1" : "0");
            String ticketStatus = bill.getString("ticketstatus");
            if (ElcDraftBillOpEnum.REMITREVOCATION.getValue().equals(this.op.replace("_", "")) || ElcDraftBillOpEnum.REMITCANCLE.getValue().equals(this.op.replace("_", ""))) {
                if (StringUtils.isNotEmpty((CharSequence)ticketStatus)) {
                    detail.setTranType(ElcNoteSignEnum.getByName((String)ticketStatus).getCode());
                } else {
                    detail.setTranType(bill.getString("operationcode"));
                }
            }
            detail.setDetailSeqID(bill.getString("id"));
            detail.setDetailBizNo(StringUtils.isEmpty((CharSequence)bill.getString("detailbizno")) ? batchSeqId : bill.getString("detailbizno"));
            detail.setAcceptorAccNo(bill.getString("promiseracctext"));
            detail.setAcceptorAccName(bill.getString("promisertext"));
            detail.setAcceptorBankCnaps(bill.getString("promiserbankno"));
            detail.setAcceptorBankName(bill.getString("promiserbanktext"));
            detail.setAcceptorOrg(bill.getString("promiseorgno"));
            String issueTicketAcc = bill.getString("issueticketacctext");
            detail.setDrawerAccNo(issueTicketAcc);
            DynamicObject[] drawerAccountBank = BusinessDataServiceHelper.load((String)"am_accountbank", (String)"id,acctname,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)issueTicketAcc)});
            if (drawerAccountBank.length > 0) {
                detail.setDrawerAccName(drawerAccountBank[0].getString("acctname"));
            }
            detail.setDrawerCnapsCode(bill.getString("issueticketbankno"));
            detail.setDrawerCnapsName(bill.getString("issueticketbanktext"));
            String collectionAcc = bill.getString("collectionacctext");
            detail.setPayeeAccNo(collectionAcc);
            Object[] payeeAccountBank = BusinessDataServiceHelper.load((String)"am_accountbank", (String)"id,acctname,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)collectionAcc)});
            Object[] payeeAccountBank_other = new DynamicObject[]{};
            if (EmptyUtil.isEmpty((Object[])payeeAccountBank) && EmptyUtil.isEmpty((Object[])(payeeAccountBank_other = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,number,name,entry_bank.bankaccount,entry_bank.accountname", (QFilter[])new QFilter[]{new QFilter("entry_bank.bankaccount", "=", (Object)collectionAcc).and("name", "=", (Object)bill.getString("collectionertext"))})))) {
                payeeAccountBank_other = BusinessDataServiceHelper.load((String)"bd_customer", (String)"id,number,name,entry_bank.bankaccount,entry_bank.accountname", (QFilter[])new QFilter[]{new QFilter("entry_bank.bankaccount", "=", (Object)collectionAcc).and("name", "=", (Object)bill.getString("collectionertext"))});
            }
            if (payeeAccountBank.length > 0) {
                detail.setPayeeAccName(payeeAccountBank[0].getString("acctname"));
            } else if (EmptyUtil.isNoEmpty((Object[])payeeAccountBank_other)) {
                DynamicObjectCollection entry_banks = payeeAccountBank_other[0].getDynamicObjectCollection("entry_bank");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entry_banks)) {
                    for (DynamicObject entry_bank : entry_banks) {
                        String bankaccount = entry_bank.getString("bankaccount");
                        if (!StringUtils.isNotEmpty((CharSequence)collectionAcc) || !StringUtils.isNotEmpty((CharSequence)bankaccount) || !collectionAcc.equals(bankaccount)) continue;
                        detail.setPayeeAccName(entry_bank.getString("accountname"));
                        break;
                    }
                }
            } else {
                detail.setPayeeAccName(bill.getString("collectionertext"));
            }
            detail.setPayeeCnapsCode(bill.getString("collectionbankno"));
            detail.setPayeeBankName(bill.getString("collectionbanktext"));
            detail.setPayeeBankAddr(bill.getString("acceptorbankaddr"));
            detail.setPayeeCountry(bill.getString("acceptorcountry"));
            detail.setPayeeProvince(bill.getString("acceptorprovince"));
            detail.setPayeeCity(bill.getString("acceptorcity"));
            detail.setPayeeOrg(bill.getString("collectionorgno"));
            BigDecimal amount = bill.getBigDecimal("amount").setScale(2, RoundingMode.HALF_UP);
            detail.setAmount(amount.toString());
            detail.setBillNo(bill.getString("billno"));
            detail.setDraftType(bill.getString("drafttype"));
            String transfer = bill.getBoolean("istransfer") ? "EM00" : "EM01";
            detail.setTransferFlag(transfer);
            boolean autoAccept = bill.getBoolean("autoaccept");
            detail.setAutoAccept(autoAccept ? "1" : "0");
            boolean autoReceive = bill.getBoolean("autoreceive");
            detail.setAutoReceive(autoReceive ? "1" : "0");
            detail.setBookingDate(DateUtils.formatString((Date)bill.getDate("issueticketdate"), (String)"yyyyMMdd"));
            detail.setDueDate(DateUtils.formatString((Date)bill.getDate("exchangebillexpiredate"), (String)"yyyyMMdd"));
            detail.setFlowSerialNo(bill.getString("flowserialno"));
            detail.setDesc(bill.getString("explain"));
            detail.setReserved1(bill.getString("fileid"));
            detail.setReserved2(bill.getString("filename"));
            detail.setReserved3(bill.getString("filepath"));
            detail.setContractNo(bill.getString("tradecontractno"));
            detail.setReserveds(bill.getString("fileencrypt"));
            detail.setBankRefKey(bill.getString("bankconsultno"));
            detail.setBankRefDate(bill.getString("bankrefdate"));
            detail.setAcpFlg(bill.getString("acpFlg"));
            detail.setAcpFer(bill.getString("acpFer"));
            detail.setBalTyp(bill.getString("balTyp"));
            detail.setBalEac(bill.getString("balEac"));
            detailList.add(detail);
        }
        body.setTotalCount(detailList.size());
        BigDecimal totalAmount = detailList.stream().map(DraftPayBillNoteDetail::getAmount).map(BigDecimal::new).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
        body.setTotalAmount(this.transAmount(totalAmount));
        body.setDetails(detailList);
        return body;
    }

    public DraftBillDiscountCalRequestBody getDiscountCalRequest() {
        DraftBillDiscountCalRequestBody body = new DraftBillDiscountCalRequestBody();
        String batchSeqId = BeServiceHelper.generateSerialNumber();
        body.setBatchSeqId(batchSeqId);
        body.setTotalCount(this.bills.size());
        String noteStatus = this.bills.get(0).getString("notestatus");
        String isNewECDS = EleDraftHelper.isNewECDs((String)noteStatus, (String)"");
        body.setIsNewECDS(isNewECDS);
        ArrayList<EleBillDiscountCalDetail> detailList = new ArrayList<EleBillDiscountCalDetail>(8);
        for (DynamicObject bill : this.bills) {
            EleBillDiscountCalDetail detail = new EleBillDiscountCalDetail();
            detail.setNoteNo(bill.getString("billno"));
            detail.setAmount(bill.getBigDecimal("locamt").setScale(2, 4).toString());
            detail.setDraftType(bill.getString("drafttype"));
            detail.setCurrency(bill.getDynamicObject("currency").getString("number"));
            detail.setIssueDate(DateUtils.formatString((Date)bill.getDate("issueticketdate"), (String)"yyyyMMdd"));
            detail.setDueDate(DateUtils.formatString((Date)bill.getDate("exchangebillexpiredate"), (String)"yyyyMMdd"));
            detail.setDiscountAmount("");
            detail.setPayRateType(bill.getString("discountpaytype"));
            detail.setIncreaseRate(bill.getString("increaserate"));
            String subRange = bill.getString("subrange");
            detail.setStartNo(bill.getBoolean("grdbag") ? EleDraftHelper.tranSubRangeStartNo((String)subRange) : "0");
            detail.setEndNo(bill.getBoolean("grdbag") ? EleDraftHelper.tranSubRangeEndNo((String)subRange) : "0");
            detail.setIntDaysAdjust(bill.getString("discountdays"));
            detail.setIntDays(bill.getString("adddate"));
            detail.setDiscountRate(bill.getBigDecimal("discountrate").setScale(2, 4).toString());
            if (bill.getDynamicObject("promiseracc") != null) {
                long bankId = bill.getDynamicObject("promiseracc").getDynamicObject("bank").getLong("id");
                DynamicObject bank = BusinessDataServiceHelper.loadSingle((Object)bankId, (String)"bd_finorginfo");
                detail.setPayeeCnapsCode(bank.getString("union_number"));
            } else {
                detail.setPayeeCnapsCode("");
            }
            detailList.add(detail);
        }
        body.setTotalCount(this.bills.size());
        body.setDetails(detailList);
        return body;
    }

    public String getSubBizTypeOp() {
        String ticketStatus = this.bills.get(0).getString("ticketstatus");
        logger.info("\u8bf7\u6c42\u94f6\u4f01\u62a5\u6587\u64cd\u4f5cop = {},op\u5bf9\u5e94\u7684\u7968\u636e\u72b6\u6001ticketStatus = {}", (Object)this.op, (Object)ticketStatus);
        if (ElcDraftBillOpEnum.REMITREVOCATION.getValue().equals(this.op.replace("_", "")) && (ticketStatus.equals(EleDraftBillStatusEnum.ACCEPTANCE.getValue()) || ticketStatus.equals(EleDraftBillStatusEnum.ENSURE.getValue()) || ticketStatus.equals(EleDraftBillStatusEnum.INVOICE.getValue()))) {
            return ElcDraftBillOpEnum.REMITCANCLE.getSubBizType();
        }
        return this.op;
    }

    private String getEbNoteStatusVal(String ticketStatus) {
        String ebValStr;
        EleDraftBillStatusEnum noteStatusEnum = EleDraftBillStatusEnum.getByValue((String)ticketStatus);
        if (noteStatusEnum != null && (ebValStr = noteStatusEnum.getEbValueState()) != null && !ebValStr.contains(",")) {
            return ebValStr;
        }
        return null;
    }

    private String transAmount(BigDecimal amount) {
        if (amount == null) {
            return null;
        }
        return amount.setScale(2, 4).toString();
    }
}

