/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.ebservice.service.draftbill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.ebservice.draftbill.impl.EleDraftBillCreator;
import kd.tmc.cdm.business.ebservice.draftbill.impl.EleDraftBillUpdater;
import kd.tmc.cdm.business.ebservice.draftbill.impl.EleDraftPayBillCreator;
import kd.tmc.cdm.business.ebservice.draftbill.impl.EleDraftPayBillUpdater;
import kd.tmc.cdm.business.ebservice.log.BankLogInfoElcFactory;
import kd.tmc.cdm.business.ebservice.request.builder.draftbill.EleDraftBillQueryRequestBuilder;
import kd.tmc.cdm.business.service.EleBillCommonHelper;
import kd.tmc.cdm.business.service.billstorage.RecEleBillStorageService;
import kd.tmc.cdm.common.bean.EleDraftBillQueryInfo;
import kd.tmc.cdm.common.enums.ElcDraftBillOpEnum;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftExistCatEnum;
import kd.tmc.cdm.common.enums.EleDraftIsNewECDS;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.helper.BankCateHelper;
import kd.tmc.cdm.common.helper.EleDraftHelper;
import kd.tmc.fbp.common.helper.DateFormatUtil;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.query.DraftBillInfo;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.query.DraftBillQueryRequestBody;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.query.DraftBillQueryResponseBody;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.query.ReciteInfo;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;

public class EleDraftBillQueryServiceImpl
implements IEBService<List<NoteResult>> {
    private static Log logger = LogFactory.getLog(EleDraftBillQueryServiceImpl.class);
    private List<NoteResult> resultList;
    private EleDraftBillCreator billCreator = EleDraftBillCreator.getInstance();
    private EleDraftBillUpdater billUpdater = EleDraftBillUpdater.getInstance();
    private EleDraftPayBillCreator payBillCreator = EleDraftPayBillCreator.getInstance();
    private EleDraftPayBillUpdater payBillUpdater = EleDraftPayBillUpdater.getInstance();
    private EleDraftBillQueryInfo eleDraftBillQueryInfo;
    private static final List<String> ELECT_PAYBILL_NOT_IN = Arrays.asList(EleDraftBillStatusEnum.REGISTED.getEbValueState(), EleDraftBillStatusEnum.ACCEPTANCE.getEbValueState(), EleDraftBillStatusEnum.ACCEPTANCESIGNED.getEbValueState());

    public EleDraftBillQueryServiceImpl(EleDraftBillQueryInfo eleDraftBillQueryInfo) {
        this.resultList = new ArrayList<NoteResult>(10);
        this.eleDraftBillQueryInfo = eleDraftBillQueryInfo;
    }

    public IEBRequestBuilder getRequestBuilder() {
        logger.info("execute is getRequestBuilder:");
        DraftBillQueryRequestBody body = new DraftBillQueryRequestBody();
        body.setIsNewECDS(this.eleDraftBillQueryInfo.getIsNewECDS());
        body.setTranType(this.eleDraftBillQueryInfo.getStatus());
        body.setDraftType(this.eleDraftBillQueryInfo.getDraftType());
        if (this.eleDraftBillQueryInfo.getStartDate() == null || this.eleDraftBillQueryInfo.getEndDate() == null) {
            body.setStartIssueDate(DateUtils.formatString((Date)DateUtils.getLastYear((Date)DateUtils.getNextDay((Date)new Date(), (int)1), (int)1), (String)"yyyyMMdd"));
            body.setEndIssueDate(DateUtils.formatString((Date)new Date(), (String)"yyyyMMdd"));
            body.setStartDueDate(DateUtils.formatString((Date)new Date(), (String)"yyyyMMdd"));
            body.setEndDueDate(DateUtils.formatString((Date)DateUtils.getNextYear((Date)DateUtils.getLastDay((Date)new Date(), (int)1), (int)1), (String)"yyyyMMdd"));
        } else {
            body.setStartIssueDate(DateUtils.formatString((Date)DateUtils.getLastYear((Date)DateUtils.getNextDay((Date)this.eleDraftBillQueryInfo.getStartDate(), (int)1), (int)1), (String)"yyyyMMdd"));
            body.setEndIssueDate(DateUtils.formatString((Date)this.eleDraftBillQueryInfo.getStartDate(), (String)"yyyyMMdd"));
            body.setStartDueDate(DateUtils.formatString((Date)this.eleDraftBillQueryInfo.getEndDate(), (String)"yyyyMMdd"));
            body.setEndDueDate(DateUtils.formatString((Date)DateUtils.getNextYear((Date)DateUtils.getLastDay((Date)this.eleDraftBillQueryInfo.getEndDate(), (int)1), (int)1), (String)"yyyyMMdd"));
        }
        body.setPageNum(String.valueOf(this.eleDraftBillQueryInfo.getPageNum()));
        this.eleDraftBillQueryInfo.setPageNum(this.eleDraftBillQueryInfo.getPageNum() + 1);
        return new EleDraftBillQueryRequestBuilder(body, this.eleDraftBillQueryInfo);
    }

    public String getEntityName() {
        return "cdm_electronicbill";
    }

    public BankLogInfo getBankLogInfo() {
        DynamicObjectCollection accountBank = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,company", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.eleDraftBillQueryInfo.getAcct())});
        return BankLogInfoElcFactory.generateBankLogInfo((String)"", (Long)((DynamicObject)accountBank.get(0)).getLong("company"), null);
    }

    public List<NoteResult> getEBResult() {
        return this.resultList;
    }

    public boolean validate() {
        NoteResult result = new NoteResult();
        this.resultList.add(result);
        boolean isCorrectTime = EleBillCommonHelper.isCorrectTimeToEB(this.resultList, (Long)this.eleDraftBillQueryInfo.getObj().getDynamicObject("company").getLong("id"));
        if (isCorrectTime) {
            this.resultList.clear();
            return Boolean.TRUE;
        }
        this.eleDraftBillQueryInfo.setKeepFlag("1");
        return Boolean.FALSE;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
        logger.info("execute is rollback:" + errMsg + "e:" + e.getMessage());
        NoteResult result = new NoteResult();
        result.setStatusCode(EBResultStatusCode.ROLLBACK);
        result.setErrMsg(errMsg);
        this.resultList.clear();
        this.resultList.add(result);
        this.eleDraftBillQueryInfo.setKeepFlag("1");
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        logger.info("execute is handleEBException:" + errMsg + "e:" + e.getMessage() + ",querySeq:" + this.eleDraftBillQueryInfo.getQueryBatchSeq());
        NoteResult result = new NoteResult();
        result.setStatusCode(EBResultStatusCode.ERROR);
        result.setErrMsg(errMsg);
        this.resultList.clear();
        this.resultList.add(result);
        this.eleDraftBillQueryInfo.setKeepFlag("1");
    }

    public void handleResultBody(String resultBody) {
        logger.info("EleDraftBillQueryServiceImpl handleResultBody resultBody.length is :" + resultBody.length());
        try (TXHandle tx = TX.requiresNew();){
            DraftBillQueryResponseBody draftBillQueryResponseBody = (DraftBillQueryResponseBody)JSON.parseObject((String)resultBody, DraftBillQueryResponseBody.class);
            if (EleDraftExistCatEnum.HOLD.getValue().equalsIgnoreCase(this.eleDraftBillQueryInfo.getBizSubType())) {
                this.eleDraftBillQueryInfo.setKeepFlag(draftBillQueryResponseBody.getKeepFlag());
                this.eleDraftBillQueryInfo.setTotalPage(StringUtils.isEmpty((CharSequence)draftBillQueryResponseBody.getTotalPage()) ? 0 : Integer.parseInt(draftBillQueryResponseBody.getTotalPage()));
                this.eleDraftBillQueryInfo.setConcurrent(StringUtils.isEmpty((CharSequence)draftBillQueryResponseBody.getConcurrent()) ? 0 : Integer.parseInt(draftBillQueryResponseBody.getConcurrent()));
            } else if (EleDraftExistCatEnum.PREREGISTER.getValue().equalsIgnoreCase(this.eleDraftBillQueryInfo.getBizSubType())) {
                this.eleDraftBillQueryInfo.setKeepFlag(draftBillQueryResponseBody.getKeepFlag());
            } else {
                this.eleDraftBillQueryInfo.setKeepFlag("1");
            }
            List draftInfoList = draftBillQueryResponseBody.getDetails();
            boolean isFromBankImport = this.eleDraftBillQueryInfo.getFromBankImport();
            logger.info("isFromBankImport is\uff1a" + isFromBankImport);
            if (isFromBankImport) {
                this.genDynamicObject(draftInfoList);
                return;
            }
            Set<String> draftBillNoSet = draftInfoList.stream().map(DraftBillInfo::getNoteNo).collect(Collectors.toSet());
            Map<String, DynamicObject> localDraftBillMap = this.getLocalDraftBillMap(draftBillNoSet);
            ArrayList<DraftBillInfo> addNewInfoList = new ArrayList<DraftBillInfo>(10);
            ArrayList<Tuple<DraftBillInfo, Object>> updateInfoList = new ArrayList<Tuple<DraftBillInfo, Object>>(10);
            for (DraftBillInfo draftBillInfo : draftInfoList) {
                if (ELECT_PAYBILL_NOT_IN.contains(draftBillInfo.getNoteStatus()) && EleDraftExistCatEnum.HOLD.getValue().equals(this.eleDraftBillQueryInfo.getBizSubType())) {
                    logger.info("EleDraftBillQueryServiceImpl handleResultBody is paybill and noteNo {},noteStatus {}", (Object)draftBillInfo.getNoteNo(), (Object)draftBillInfo.getNoteStatus());
                    continue;
                }
                String key = this.getUniqueKey(draftBillInfo);
                DynamicObject localBill = localDraftBillMap.get(key);
                logger.info("EleDraftBillQueryServiceImpl handleResultBody noteNo {},noteStatus {},key {},bizSubType = {},localBill is {}", new Object[]{draftBillInfo.getNoteNo(), draftBillInfo.getNoteStatus(), key, this.eleDraftBillQueryInfo.getBizSubType(), localBill == null ? "null" : "not null"});
                if (localBill != null && !EleDraftExistCatEnum.PREREGISTER.getValue().equalsIgnoreCase(this.eleDraftBillQueryInfo.getBizSubType())) {
                    if ("Y".equals(draftBillInfo.getIsNoteSidesError())) {
                        logger.info("EleDraftBillQueryServiceImpl handleResultBody draftBillInfo isNoteSidesError is Y noteNo {}", (Object)draftBillInfo.getNoteNo());
                        continue;
                    }
                    if (!localBill.getBoolean("isnotesideserror")) {
                        int n;
                        int localSize = localBill.getDynamicObjectCollection("entryentity").size();
                        int n2 = n = draftBillInfo.getNoteSidesInfo() == null ? 0 : draftBillInfo.getNoteSidesInfo().size();
                        if (n == localSize + 1) {
                            String opponentName;
                            List sideInfos = draftBillInfo.getNoteSidesInfo().stream().sorted(Comparator.comparing(o -> Integer.valueOf(StringUtils.isEmpty((CharSequence)o.getResv1()) ? "0" : o.getResv1()))).collect(Collectors.toList());
                            String acctName = localBill.getDynamicObject("draftaccount").getString("acctname");
                            if (!acctName.equals(opponentName = ((ReciteInfo)sideInfos.get(0)).getOpponentName())) {
                                localBill = null;
                            }
                        } else if (localSize != n) {
                            localBill = null;
                        }
                        logger.info("EleDraftBillQueryServiceImpl handleResultBody localBill isNoteSidesError is not Y noteNo {},compare noteSidesInfo localSize {},remoteSize {}", new Object[]{draftBillInfo.getNoteNo(), localSize, n});
                    } else {
                        logger.info("EleDraftBillQueryServiceImpl handleResultBody localBill isNoteSidesError is Y noteNo {}", (Object)draftBillInfo.getNoteNo());
                    }
                }
                if (localBill != null && ElcDraftBillOpEnum.NOTESIGNIN.getValue().equals(localBill.getString("tradetype")) && EbStatus.BANK_SUCCESS.getName().equals(localBill.getString("ebstatus")) && EleDraftExistCatEnum.REPLY.getValue().equalsIgnoreCase(this.eleDraftBillQueryInfo.getBizSubType())) {
                    localBill = null;
                    logger.info("EleDraftBillQueryServiceImpl handleResultBody noteNo {},tradeType is note_sign_in,ebStatus is BANK_SUCCESS", (Object)draftBillInfo.getNoteNo());
                }
                logger.info("EleDraftBillQueryServiceImpl handleResultBody noteNo {},compared noteSidesInfo localBill is {}", (Object)draftBillInfo.getNoteNo(), (Object)(localBill == null ? "null" : "not null"));
                if (localBill == null) {
                    addNewInfoList.add(draftBillInfo);
                    continue;
                }
                updateInfoList.add((Tuple<DraftBillInfo, Object>)Tuple.create((Object)draftBillInfo, (Object)localBill.get("id")));
            }
            if (EleDraftExistCatEnum.PREREGISTER.getValue().equalsIgnoreCase(this.eleDraftBillQueryInfo.getBizSubType())) {
                try {
                    this.saveOrUpdatePreRegisterResultBody(addNewInfoList, updateInfoList);
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("EleDraftBillQueryServiceImpl saveOrUpdatePreRegisterResultBody has Exception:", (Throwable)e);
                }
                return;
            }
            logger.info("EleDraftBillQueryServiceImpl handleResultBody bizSubType:" + this.eleDraftBillQueryInfo.getBizSubType());
            if (this.eleDraftBillQueryInfo.getStatus() != null && addNewInfoList.size() > 0) {
                NoteResult result;
                List<DynamicObject> addNewDraftBillList = this.billCreator.createDraftBill(addNewInfoList, this.eleDraftBillQueryInfo.getAcct(), this.eleDraftBillQueryInfo.getStatus(), this.eleDraftBillQueryInfo.getBizSubType());
                logger.info("start to add data");
                for (DynamicObject draftBill : addNewDraftBillList) {
                    long billId = draftBill.getLong("id");
                    draftBill.set("querybatchseq", (Object)this.eleDraftBillQueryInfo.getQueryBatchSeq());
                    if (EleDraftExistCatEnum.REPLY.getValue().equalsIgnoreCase(this.eleDraftBillQueryInfo.getBizSubType())) {
                        draftBill.set("operationcode", (Object)this.eleDraftBillQueryInfo.getStatus());
                        draftBill.set("trantype", (Object)this.eleDraftBillQueryInfo.getStatus());
                    }
                    result = new NoteResult();
                    result.setBillId(Long.valueOf(billId));
                    result.setStatusCode(EBResultStatusCode.SUCCESS);
                    this.resultList.add(result);
                }
                try {
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("ishasright", "true");
                    TmcOperateServiceHelper.execOperateWithoutThrow((String)"save", (String)"cdm_electronic_sign_deal", (DynamicObject[])addNewDraftBillList.toArray(new DynamicObject[0]), (OperateOption)option);
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("EleDraftBillQueryServiceImpl handleResultBody save has Exception:", (Throwable)e);
                    result = new NoteResult();
                    result.setBillId(Long.valueOf(0L));
                    result.setStatusCode(EBResultStatusCode.ERROR);
                    result.setErrMsg(ResManager.loadKDString((String)"\u5f85\u7b7e\u6536\u7968\u636e\u6216\u5728\u624b\u7968\u636e\u66f4\u65b0\u5165\u5e93\u5931\u8d25\u3002", (String)"EleDraftBillQueryServiceImpl_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
            }
            if (updateInfoList.size() > 0) {
                NoteResult result = new NoteResult();
                ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(10);
                DynamicObject[] localDraftBillArr = TmcDataServiceHelper.load((Object[])updateInfoList.stream().map(o -> o.item2).distinct().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronic_sign_deal"));
                Map<Object, DynamicObject> localBillMap = Arrays.stream(localDraftBillArr).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o, (a, b) -> a));
                logger.info("start to update data");
                for (Tuple tuple : updateInfoList) {
                    DynamicObject needUpdateBill = localBillMap.get(tuple.item2);
                    this.billUpdater.queryUpdate(needUpdateBill, (DraftBillInfo)tuple.item1, this.eleDraftBillQueryInfo.getAcct(), this.eleDraftBillQueryInfo.getBizSubType());
                    long billId = needUpdateBill.getLong("id");
                    needUpdateBill.set("querybatchseq", (Object)this.eleDraftBillQueryInfo.getQueryBatchSeq());
                    if (EleDraftExistCatEnum.REPLY.getValue().equalsIgnoreCase(this.eleDraftBillQueryInfo.getBizSubType())) {
                        needUpdateBill.set("operationcode", (Object)this.eleDraftBillQueryInfo.getStatus());
                        needUpdateBill.set("trantype", (Object)this.eleDraftBillQueryInfo.getStatus());
                    }
                    updateList.add(needUpdateBill);
                    result.setBillId(Long.valueOf(billId));
                    result.setStatusCode(EBResultStatusCode.SUCCESS);
                    this.resultList.add(result);
                }
                try {
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("ishasright", "true");
                    TmcOperateServiceHelper.execOperateWithoutThrow((String)"save", (String)"cdm_electronic_sign_deal", (DynamicObject[])updateList.toArray(new DynamicObject[0]), (OperateOption)option);
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("EleDraftBillQueryServiceImpl handleResultBody update has Exception:", (Throwable)e);
                    result.setBillId(Long.valueOf(0L));
                    result.setStatusCode(EBResultStatusCode.ERROR);
                    result.setErrMsg(ResManager.loadKDString((String)"\u5f85\u7b7e\u6536\u7968\u636e\u6216\u5728\u624b\u7968\u636e\u66f4\u65b0\u5165\u5e93\u5931\u8d25\u3002", (String)"EleDraftBillQueryServiceImpl_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
            }
        }
        if ("1".equals(this.eleDraftBillQueryInfo.getKeepFlag()) && this.eleDraftBillQueryInfo.getConcurrent() <= 1) {
            tx = TX.requiresNew();
            var3_3 = null;
            try {
                try {
                    this.updateRemainDataWhenQueryHold(this.eleDraftBillQueryInfo.getQueryBatchSeq(), this.eleDraftBillQueryInfo.getDraftType(), this.eleDraftBillQueryInfo.getIsNewECDS());
                    this.storageQueryHoldBill(this.eleDraftBillQueryInfo.getQueryBatchSeq());
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("EleDraftBillQueryServiceImpl handleResultBody keepFlag = 1 update or storage Exception:", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var3_3 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
    }

    private void saveOrUpdatePreRegisterResultBody(List<DraftBillInfo> addNewInfoList, List<Tuple<DraftBillInfo, Object>> updateInfoList) {
        logger.info("EleDraftBillQueryServiceImpl saveOrUpdatePreRegisterResultBody start.");
        if (this.eleDraftBillQueryInfo.getStatus() != null && addNewInfoList.size() > 0) {
            NoteResult result;
            List addNewDraftBillList = this.payBillCreator.createDraftBill(addNewInfoList, this.eleDraftBillQueryInfo.getAcct(), this.eleDraftBillQueryInfo.getStatus(), this.eleDraftBillQueryInfo.getBizSubType());
            logger.info("start to add data");
            for (DynamicObject draftBill : addNewDraftBillList) {
                long billId = draftBill.getLong("id");
                draftBill.set("querybatchseq", (Object)this.eleDraftBillQueryInfo.getQueryBatchSeq());
                result = new NoteResult();
                result.setBillId(Long.valueOf(billId));
                result.setStatusCode(EBResultStatusCode.SUCCESS);
                this.resultList.add(result);
            }
            try {
                TmcDataServiceHelper.save((DynamicObject[])addNewDraftBillList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                logger.error("EleDraftBillQueryServiceImpl saveOrUpdatePreRegisterResultBody save has Exception:", (Throwable)e);
                result = new NoteResult();
                result.setBillId(Long.valueOf(0L));
                result.setStatusCode(EBResultStatusCode.ERROR);
                result.setErrMsg(ResManager.loadKDString((String)"\u9884\u51fa\u7968\u7968\u636e\u65b0\u589e\u5165\u5e93\u5931\u8d25\u3002", (String)"EleDraftBillQueryServiceImpl_3", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
        }
        if (updateInfoList.size() > 0) {
            NoteResult result = new NoteResult();
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(10);
            DynamicObject[] localDraftBillArr = TmcDataServiceHelper.load((Object[])updateInfoList.stream().map(o -> o.item2).distinct().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronic_pay_deal"));
            Map<Object, DynamicObject> localBillMap = Arrays.stream(localDraftBillArr).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o, (a, b) -> a));
            logger.info("start to update data");
            for (Tuple<DraftBillInfo, Object> needUpdateInfo : updateInfoList) {
                DynamicObject needUpdateBill = localBillMap.get(needUpdateInfo.item2);
                this.payBillUpdater.queryUpdate(needUpdateBill, (DraftBillInfo)needUpdateInfo.item1, this.eleDraftBillQueryInfo.getAcct(), this.eleDraftBillQueryInfo.getBizSubType());
                long billId = needUpdateBill.getLong("id");
                needUpdateBill.set("querybatchseq", (Object)this.eleDraftBillQueryInfo.getQueryBatchSeq());
                updateList.add(needUpdateBill);
                result.setBillId(Long.valueOf(billId));
                result.setStatusCode(EBResultStatusCode.SUCCESS);
                this.resultList.add(result);
            }
            try {
                TmcDataServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                logger.error("EleDraftBillQueryServiceImpl saveOrUpdatePreRegisterResultBody update has Exception:", (Throwable)e);
                result.setBillId(Long.valueOf(0L));
                result.setStatusCode(EBResultStatusCode.ERROR);
                result.setErrMsg(ResManager.loadKDString((String)"\u9884\u51fa\u7968\u7968\u636e\u65b0\u589e\u5165\u5e93\u5931\u8d25\u3002", (String)"EleDraftBillQueryServiceImpl_3", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
        }
        logger.info("EleDraftBillQueryServiceImpl saveOrUpdatePreRegisterResultBody end.");
    }

    /*
     * WARNING - void declaration
     */
    private void updateRemainDataWhenQueryHold(String queryBatchSeq, String draftType, String isNewECDS) {
        if (EleDraftExistCatEnum.HOLD.getValue().equalsIgnoreCase(this.eleDraftBillQueryInfo.getBizSubType())) {
            try (TXHandle tx = TX.requiresNew();){
                void var10_19;
                QFilter queryBatchSeqFilter = new QFilter("querybatchseq", "=", (Object)queryBatchSeq);
                queryBatchSeqFilter.and(new QFilter("interfacetype", "=", (Object)isNewECDS));
                Object[] batchHoldDraftBills = BusinessDataServiceHelper.load((String)"cdm_electronicbill", (String)"id,conectno,ticketstatus,querydrafttype,modifytime,modifier", (QFilter[])new QFilter[]{queryBatchSeqFilter});
                logger.info("EleDraftBillQueryServiceImpl updateRemainDataWhenQueryHold queryBatchSeq = {},batchHoldDraftBills.length = {},isNewECDS = {}", new Object[]{queryBatchSeq, batchHoldDraftBills.length, isNewECDS});
                if (EmptyUtil.isEmpty((Object[])batchHoldDraftBills)) {
                    QFilter noHoldBillFilter = new QFilter("conectno", "=", (Object)this.eleDraftBillQueryInfo.getAcct());
                    noHoldBillFilter.and(new QFilter("querydrafttype", "=", (Object)EleDraftExistCatEnum.HOLD.getValue()));
                    noHoldBillFilter.and(new QFilter("drafttype", "=", (Object)draftType));
                    noHoldBillFilter.and(new QFilter("interfacetype", "=", (Object)isNewECDS));
                    DynamicObject[] noHoldBills = BusinessDataServiceHelper.load((String)"cdm_electronicbill", (String)"id,conectno,ticketstatus,querydrafttype,modifytime,modifier,billno", (QFilter[])new QFilter[]{noHoldBillFilter});
                    if (noHoldBills.length > 0) {
                        for (DynamicObject noHoldBill : noHoldBills) {
                            noHoldBill.set("querydrafttype", (Object)EleDraftExistCatEnum.HISTORYHOLD.getValue());
                            noHoldBill.set("modifytime", (Object)new Date());
                            noHoldBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
                            logger.info("EleDraftBillQueryServiceImpl updateRemainDataWhenQueryHold noHoldBills queryBatchSeq = {},noteNo {},isNewECDS = {},draftType = {}", new Object[]{queryBatchSeq, noHoldBill.getString("billno"), isNewECDS, draftType});
                        }
                        TmcDataServiceHelper.save((DynamicObject[])noHoldBills);
                        logger.info("updateRemainDataWhenQueryHold update hold bill to historyhold bill");
                    } else {
                        logger.info("updateRemainDataWhenQueryHold has not hold bill");
                    }
                    return;
                }
                Object[] noHoldBillFilter = batchHoldDraftBills;
                int n = noHoldBillFilter.length;
                boolean bl = false;
                while (var10_19 < n) {
                    Object batchHoldDraftBill = noHoldBillFilter[var10_19];
                    batchHoldDraftBill.set("querydrafttype", (Object)EleDraftExistCatEnum.HOLD.getValue());
                    batchHoldDraftBill.set("modifytime", (Object)new Date());
                    batchHoldDraftBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    ++var10_19;
                }
                try {
                    TmcDataServiceHelper.save((DynamicObject[])batchHoldDraftBills);
                }
                catch (Exception e) {
                    logger.error("update batchHoldDraftBill data has Exception:", (Throwable)e);
                    tx.markRollback();
                    throw e;
                }
                logger.info("is start to update remain data");
                HashMap mapOfData = new HashMap();
                for (Object batchHoldDraftBill : batchHoldDraftBills) {
                    String connectNo = batchHoldDraftBill.getString("conectno");
                    long billId = batchHoldDraftBill.getLong("id");
                    if (mapOfData.containsKey(connectNo)) {
                        ((Set)mapOfData.get(connectNo)).add(billId);
                        continue;
                    }
                    HashSet<Long> idSet = new HashSet<Long>();
                    idSet.add(billId);
                    mapOfData.put(connectNo, idSet);
                }
                for (Map.Entry entry : mapOfData.entrySet()) {
                    String connectNo = (String)entry.getKey();
                    Set idSet = (Set)entry.getValue();
                    QFilter holdDraftBillUpdateFilter = new QFilter("conectno", "=", (Object)connectNo);
                    holdDraftBillUpdateFilter.and(new QFilter("drafttype", "=", (Object)draftType));
                    holdDraftBillUpdateFilter.and(new QFilter("querydrafttype", "=", (Object)EleDraftExistCatEnum.HOLD.getValue()));
                    holdDraftBillUpdateFilter.and(new QFilter("id", "not in", (Object)idSet));
                    holdDraftBillUpdateFilter.and(new QFilter("interfacetype", "=", (Object)isNewECDS));
                    Object[] holdDraftBillUpdateBills = TmcDataServiceHelper.load((String)"cdm_electronicbill", (String)"id,conectno,ticketstatus,querydrafttype,modifytime,modifier,billno", (QFilter[])new QFilter[]{holdDraftBillUpdateFilter});
                    logger.info("EleDraftBillQueryServiceImpl updateRemainDataWhenQueryHold holdDraftBillUpdateBills queryBatchSeq = {},holdDraftBillUpdateBills.length = {},isNewECDS = {},draftType = {}", new Object[]{queryBatchSeq, holdDraftBillUpdateBills.length, isNewECDS, draftType});
                    if (!EmptyUtil.isNoEmpty((Object[])holdDraftBillUpdateBills)) continue;
                    for (Object dynamicObject : holdDraftBillUpdateBills) {
                        dynamicObject.set("querydrafttype", (Object)EleDraftExistCatEnum.HISTORYHOLD.getValue());
                        dynamicObject.set("modifytime", (Object)new Date());
                        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
                        logger.info("EleDraftBillQueryServiceImpl updateRemainDataWhenQueryHold holdDraftBillUpdateBills queryBatchSeq = {},noteNo {},isNewECDS = {},draftType = {}", new Object[]{queryBatchSeq, dynamicObject.getString("billno"), isNewECDS, draftType});
                    }
                    try {
                        TmcDataServiceHelper.save((DynamicObject[])holdDraftBillUpdateBills);
                    }
                    catch (Exception e) {
                        logger.error("update remain data has Exception:", (Throwable)e);
                        tx.markRollback();
                        throw e;
                    }
                }
                logger.info("update remain end");
            }
        }
    }

    private void storageQueryHoldBill(String queryBatchSeq) {
        if (EleDraftExistCatEnum.HOLD.getValue().equalsIgnoreCase(this.eleDraftBillQueryInfo.getBizSubType())) {
            try {
                QFilter queryBatchSeqFilter = new QFilter("querybatchseq", "=", (Object)queryBatchSeq);
                DynamicObject[] batchHoldDraftBills = BusinessDataServiceHelper.load((String)"cdm_electronicbill", (String)"id,company", (QFilter[])new QFilter[]{queryBatchSeqFilter});
                Map<DynamicObject, List<DynamicObject>> companyGroupMap = Arrays.stream(batchHoldDraftBills).collect(Collectors.groupingBy(o -> o.getDynamicObject("company")));
                for (Map.Entry<DynamicObject, List<DynamicObject>> dynamicObjectListEntry : companyGroupMap.entrySet()) {
                    List<Long> electBillIds = dynamicObjectListEntry.getValue().stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                    String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
                    boolean isStorageRecBill = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)dynamicObjectListEntry.getKey().getLong("id"), (String)"storagerecbill");
                    if (!isStorageRecBill) continue;
                    RecEleBillStorageService.storage(electBillIds, dynamicObjectListEntry.getKey());
                }
            }
            catch (Exception e) {
                logger.error("EleDraftBillQueryServiceImpl storageQueryHoldBill has Exception:", (Throwable)e);
                throw e;
            }
        }
    }

    private Map<String, DynamicObject> getLocalDraftBillMap(Set<String> draftBillNoSet) {
        QFilter queryDraftTypeFilter;
        QFilter rpTypeFilter;
        QFilter numberFilter = new QFilter("billno", "in", draftBillNoSet);
        if (EleDraftExistCatEnum.PREREGISTER.getValue().equalsIgnoreCase(this.eleDraftBillQueryInfo.getBizSubType())) {
            rpTypeFilter = new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.PAYBILL.getValue());
            queryDraftTypeFilter = new QFilter("querydrafttype", "=", (Object)this.eleDraftBillQueryInfo.getBizSubType());
        } else if (EleDraftExistCatEnum.REPLY.getValue().equalsIgnoreCase(this.eleDraftBillQueryInfo.getBizSubType())) {
            rpTypeFilter = new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue());
            queryDraftTypeFilter = new QFilter("querydrafttype", "=", (Object)EleDraftExistCatEnum.REPLY.getValue());
        } else {
            rpTypeFilter = new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue());
            queryDraftTypeFilter = new QFilter("querydrafttype", "in", (Object)new String[]{EleDraftExistCatEnum.REPLY.getValue(), EleDraftExistCatEnum.HOLD.getValue()});
        }
        QFilter connectNoFilter = new QFilter("conectno", "=", (Object)this.eleDraftBillQueryInfo.getAcct());
        DynamicObject[] draftBillList = BusinessDataServiceHelper.load((String)"cdm_electronicbill", (String)"id,rptype,billno,ticketstatus,opstatus,bizdate,conectno,bankconsultno,createtime,entryentity,subrange,isnotesideserror,tradetype,ebstatus,preholdername,company,entryentity,draftaccount,isautosignin", (QFilter[])new QFilter[]{numberFilter, rpTypeFilter, connectNoFilter, queryDraftTypeFilter});
        return Arrays.stream(draftBillList).sorted(Comparator.comparing(dynamicObject -> dynamicObject.getDate("createtime"))).collect(Collectors.toMap(o -> o.getString("billno") + "_" + o.getString("conectno") + "_" + o.getString("rptype") + "_" + o.getString("subrange"), o -> o, (a, b) -> b));
    }

    private String getUniqueKey(DraftBillInfo draftBillInfo) {
        boolean isSubRangeEmpty;
        if (EleDraftExistCatEnum.PREREGISTER.getValue().equalsIgnoreCase(this.eleDraftBillQueryInfo.getBizSubType())) {
            boolean isSubRangeEmpty2;
            String prefixPayBillKey = draftBillInfo.getNoteNo() + "_" + this.eleDraftBillQueryInfo.getAcct() + "_paybill_";
            boolean bl = isSubRangeEmpty2 = StringUtils.isEmpty((CharSequence)draftBillInfo.getSubRange()) && StringUtils.isNotEmpty((CharSequence)draftBillInfo.getStartNo()) && StringUtils.isNotEmpty((CharSequence)draftBillInfo.getEndNo());
            if (StringUtils.isEmpty((CharSequence)draftBillInfo.getSubRange()) && StringUtils.isEmpty((CharSequence)draftBillInfo.getStartNo()) && StringUtils.isEmpty((CharSequence)draftBillInfo.getEndNo()) && StringUtils.isNotEmpty((CharSequence)draftBillInfo.getAmount()) && !"0".equals(draftBillInfo.getGrdBag()) && "0".equals(draftBillInfo.getIsNewECDS())) {
                return prefixPayBillKey + String.join((CharSequence)"-", "1", String.valueOf(new BigDecimal(draftBillInfo.getAmount()).multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString()));
            }
            if (isSubRangeEmpty2) {
                return prefixPayBillKey + EleDraftHelper.tranSubRangeStyle((String)String.join((CharSequence)",", draftBillInfo.getStartNo(), draftBillInfo.getEndNo()));
            }
            return prefixPayBillKey + EleDraftHelper.tranSubRangeStyle((String)draftBillInfo.getSubRange());
        }
        String prefixRecBillKey = draftBillInfo.getNoteNo() + "_" + this.eleDraftBillQueryInfo.getAcct() + "_receivebill_";
        boolean bl = isSubRangeEmpty = StringUtils.isEmpty((CharSequence)draftBillInfo.getSubRange()) && StringUtils.isNotEmpty((CharSequence)draftBillInfo.getStartNo()) && StringUtils.isNotEmpty((CharSequence)draftBillInfo.getEndNo());
        if (isSubRangeEmpty) {
            String subRange = EleDraftHelper.tranSubRangeStyle((String)String.join((CharSequence)",", draftBillInfo.getStartNo(), draftBillInfo.getEndNo()));
            return prefixRecBillKey + (StringUtils.isEmpty((CharSequence)subRange) ? "0" : subRange);
        }
        String subRange = EleDraftHelper.tranSubRangeStyle((String)draftBillInfo.getSubRange());
        return prefixRecBillKey + (StringUtils.isEmpty((CharSequence)subRange) ? "0" : subRange);
    }

    public String getServiceUrl() {
        return "/kapi/app/note/queryNoteDetail";
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId((DynamicObject)this.eleDraftBillQueryInfo.getObj());
    }

    private void genDynamicObject(List<DraftBillInfo> infos) {
        logger.info("EleDraftBillCreator genDynamicObject is start");
        MainEntityType draftBillEntityType = EntityMetadataCache.getDataEntityType((String)"cdm_bankdrafts");
        long pkId = DB.genLongId((String)draftBillEntityType.getAlias());
        DynamicObject draftBill = new DynamicObject((DynamicObjectType)draftBillEntityType, (Object)pkId);
        draftBill.set("id", (Object)pkId);
        long orgId = this.eleDraftBillQueryInfo.getOrgId();
        long accountId = this.eleDraftBillQueryInfo.getAccountId();
        long currencyId = this.eleDraftBillQueryInfo.getCurrencyId();
        DynamicObject accountBankDy = BusinessDataServiceHelper.loadSingle((Object)accountId, (String)"bd_accountbanks");
        DynamicObject orgIdDy = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
        DynamicObject currencyDy = BusinessDataServiceHelper.loadSingle((Object)currencyId, (String)"bd_currency");
        draftBill.set("org", (Object)orgIdDy);
        draftBill.set("bankaccount", (Object)accountBankDy);
        draftBill.set("biztype", (Object)this.eleDraftBillQueryInfo.getDraftBillType());
        draftBill.set("datadate", (Object)this.eleDraftBillQueryInfo.getBizDate());
        draftBill.set("billcurrency", (Object)currencyDy);
        draftBill.set("billstatus", (Object)"A");
        DynamicObjectCollection entrys = draftBill.getDynamicObjectCollection("bankdraftentry");
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (DraftBillInfo info : infos) {
            DynamicObject draftEntry = entrys.addNew();
            draftEntry.set("e_draftbillno", (Object)info.getNoteNo());
            draftEntry.set("e_issplit", (Object)"1".equals(info.getGrdBag()));
            draftEntry.set("e_org", (Object)orgIdDy);
            draftEntry.set("e_datadate", (Object)this.eleDraftBillQueryInfo.getBizDate());
            draftEntry.set("e_biztype", (Object)this.eleDraftBillQueryInfo.getDraftBillType());
            draftEntry.set("e_bankaccount", (Object)accountBankDy);
            draftEntry.set("e_billcurrency", (Object)currencyDy);
            String startNo = info.getStartNo();
            String endNo = info.getEndNo();
            if (EmptyUtil.isNoEmpty((String)startNo)) {
                draftEntry.set("e_subbillstartflag", (Object)Long.parseLong(startNo));
            }
            if (EmptyUtil.isNoEmpty((String)endNo)) {
                draftEntry.set("e_subbillendflag", (Object)Long.parseLong(endNo));
            }
            if (EmptyUtil.isNoEmpty((String)endNo) && EmptyUtil.isNoEmpty((String)startNo)) {
                draftEntry.set("e_subbillrange", (Object)(draftEntry.getLong("e_subbillstartflag") + "-" + draftEntry.getLong("e_subbillendflag")));
            }
            BigDecimal amount = new BigDecimal(info.getAmount());
            draftEntry.set("e_draftamount", (Object)amount);
            sumAmount = sumAmount.add(amount);
            draftEntry.set("e_acceptername", (Object)info.getAcceptorAccName());
            String draftType = info.getDraftType();
            if ("AC99".equals(draftType) || "AC01".equals(draftType)) {
                draftEntry.set("e_drafttype", (Object)"AC01");
            } else if ("AC02".equals(draftType)) {
                draftEntry.set("e_drafttype", (Object)"AC02");
            }
            draftEntry.set("e_issuedate", (Object)DateFormatUtil.FormatDate((String)info.getIssueDate()));
            draftEntry.set("e_draftbillexpiredate", (Object)DateFormatUtil.FormatDate((String)info.getDueDate()));
            draftEntry.set("e_drawername", (Object)(EmptyUtil.isEmpty((String)info.getDrawerAccName()) ? " " : info.getDrawerAccName()));
            draftEntry.set("e_draweraccountname", (Object)(EmptyUtil.isEmpty((String)info.getDrawerAccNo()) ? " " : info.getDrawerAccNo()));
            String issueTicketBankNo = info.getDrawerCnapsCode();
            draftEntry.set("e_drawerbankno", (Object)issueTicketBankNo);
            DynamicObject issueBank = EmptyUtil.isNoEmpty((String)issueTicketBankNo) ? EleDraftHelper.findBeBankByUnionNumber((String)issueTicketBankNo) : EleDraftHelper.findBeBankByName((String)info.getDrawerBankName());
            if (issueBank != null) {
                draftEntry.set("e_drawerbank", (Object)issueBank);
            }
            draftEntry.set("e_receivername", (Object)info.getPayeeAccName());
            draftEntry.set("e_receiveraccount", (Object)info.getPayeeAccNo());
            String collectionBankNo = info.getPayeeCnapsCode();
            DynamicObject recBank = EmptyUtil.isNoEmpty((String)collectionBankNo) ? EleDraftHelper.findBeBankByUnionNumber((String)collectionBankNo) : EleDraftHelper.findBeBankByName((String)info.getPayeeBankName());
            if (recBank != null) {
                draftEntry.set("e_receiverbank", (Object)recBank);
            }
            draftEntry.set("e_receiverbankno", (Object)collectionBankNo);
            String acceptorAccName = info.getAcceptorAccName();
            draftEntry.set("e_acceptername", (Object)acceptorAccName);
            draftEntry.set("e_accepteraccount", (Object)info.getAcceptorAccNo());
            String acceptorCnapsCode = info.getAcceptorCnapsCode();
            draftEntry.set("e_accepterbankno", (Object)acceptorCnapsCode);
            DynamicObject promiseBank = EleDraftHelper.findBeBankByNameAndNo((String)acceptorAccName, (String)acceptorCnapsCode);
            draftEntry.set("e_accepterbebank", (Object)(promiseBank == null ? Integer.valueOf(0) : promiseBank));
            DynamicObject promiseBankNo = EleDraftHelper.findBeBankByUnionNumber((String)acceptorCnapsCode);
            if (promiseBankNo != null) {
                draftEntry.set("e_accepterbank", (Object)promiseBankNo);
            }
            draftEntry.set("e_delivername", (Object)info.getPreHolderName());
            draftEntry.set("e_transferflag", (Object)info.getTransferFlag());
            String isNewECDS = info.getIsNewECDS();
            if (EleDraftIsNewECDS.NEW.getValue().equalsIgnoreCase(isNewECDS)) {
                EleDraftNoteStatusEnum newNoteStatus = EleDraftNoteStatusEnum.getByValue((String)info.getNoteStatus());
                draftEntry.set("e_notestatus", (Object)(null == newNoteStatus ? info.getNoteStatus() : newNoteStatus.getValue()));
            } else {
                EleDraftBillStatusEnum byEbValue = EleDraftBillStatusEnum.getByEbValue((String)info.getNoteStatus());
                draftEntry.set("e_ticketstatus", (Object)(null == byEbValue ? info.getNoteStatus() : byEbValue.getValue()));
            }
            draftEntry.set("e_cirstatus", (Object)info.getCirStatus());
            draftEntry.set("e_datasource", (Object)"bei");
            draftEntry.set("e_inventorystatus", (Object)"A");
            draftEntry.set("e_checkstatus", (Object)"A");
        }
        draftBill.set("count", (Object)entrys.size());
        draftBill.set("totalamount", (Object)sumAmount);
        draftBill.set("creator", (Object)RequestContext.get().getCurrUserId());
        DynamicObjectCollection bankDraftsDbColl = QueryServiceHelper.query((String)"cdm_bankdrafts", (String)"id,bankaccount,datadate,bankdraftentry.e_inventorystatus", (QFilter[])new QFilter[]{new QFilter("bankaccount", "=", (Object)accountId), new QFilter("datadate", "=", (Object)this.eleDraftBillQueryInfo.getBizDate())});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bankDraftsDbColl)) {
            logger.info("will delete data");
            Set repeatBankDraftS = bankDraftsDbColl.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            int n = DeleteServiceHelper.delete((String)"cdm_bankdrafts", (QFilter[])new QFilter[]{new QFilter("id", "in", repeatBankDraftS)});
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{draftBill});
    }
}

