/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.payablebill;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.SystemParameterHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class PayableBillConfirmDrawService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(PayableBillConfirmDrawService.class);
    private Map<Long, Long> customIdAndInternalComMap = new HashMap<Long, Long>(16);
    private Map<Long, Long> supplyIdAndInternalComMap = new HashMap<Long, Long>(16);
    private Set<Long> openParamOrgIdSet = new HashSet<Long>(16);
    private Set<Long> bankrollOrgIdSet = new HashSet<Long>(16);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(19);
        sic.add("payeetype");
        sic.add("receiver");
        sic.add("electag");
        sic.add("draftbilltranstatus");
        sic.add("draftbilltype");
        sic.add("draftbilltype.billmedium");
        sic.add("draftbilltype.settlementtype");
        sic.add("issuedate");
        sic.add("bizdate");
        sic.add("draftbillstatus");
        sic.add("sourcebillid");
        sic.add("basedraftbillno");
        sic.add("source");
        sic.add("eledraftstatus");
        sic.add("issplit");
        sic.add("billidentitycode");
        sic.add("draftbillno");
        sic.add("subbillrange");
        sic.add("supperbillid");
        sic.add("eledraftstatusnew");
        sic.add("releatedcasbillentrys");
        sic.add("releatedcasbillentrys.rel_billtype");
        sic.add("releatedcasbillentrys.rel_billno");
        sic.add("releatedcasbillentrys.rel_billid");
        sic.add("releatedcasbillentrys.rel_bizdate");
        sic.add("releatedcasbillentrys.rel_billamount");
        sic.add("releatedcasbillentrys.rel_createtime");
        sic.add("releatedcasbillentrys.rel_modifytime");
        sic.add("releatedcasbillentrys.rel_isrefuse");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        logger.info("PayableBillConfirmDrawService process is start:" + dataEntities.length);
        HashSet<Long> sightDraftIds = new HashSet<Long>(10);
        this.addSightDraftIds(sightDraftIds, dataEntities, true);
        boolean isInnerBill = Boolean.parseBoolean(this.operationVariable.getOrDefault("isInnerBill", "false"));
        for (DynamicObject data : dataEntities) {
            String failErrorMsg;
            String sourceStr;
            String draftbillNo = data.getString("draftbillno");
            String billidentitycode = data.getString("billidentitycode");
            boolean isSplit = data.getBoolean("issplit");
            if (EmptyUtil.isNoEmpty((String)draftbillNo) && EmptyUtil.isEmpty((String)billidentitycode)) {
                if (isSplit) {
                    String subbillrange = data.getString("subbillrange");
                    String billidentitycodeStr = draftbillNo + "-" + subbillrange;
                    data.set("billidentitycode", (Object)billidentitycodeStr);
                } else {
                    data.set("billidentitycode", (Object)draftbillNo);
                }
            }
            data.set("eledraftstatusnew", (Object)EleDraftNoteStatusEnum.CS03.getValue());
            Long companyId = 0L;
            if (null != data.getDynamicObject("receiver")) {
                String payeeType = data.getString("payeetype");
                DynamicObject receiverObj = data.getDynamicObject("receiver");
                if (null != receiverObj) {
                    long receiverId = receiverObj.getLong("id");
                    switch (payeeType) {
                        case "bos_org": {
                            companyId = receiverId;
                            break;
                        }
                        case "bd_supplier": {
                            companyId = this.supplyIdAndInternalComMap.get(receiverId);
                            break;
                        }
                        case "bd_customer": {
                            companyId = this.customIdAndInternalComMap.get(receiverId);
                            break;
                        }
                    }
                }
            }
            logger.info("PayableBillConfirmDrawService process isInnerBill : {}", (Object)isInnerBill);
            if (EmptyUtil.isNoEmpty((Long)companyId) && !isInnerBill) {
                boolean isReceiveOppNote = this.openParamOrgIdSet.contains(companyId);
                String settlementType = data.getDynamicObject("draftbilltype").getString("settlementtype");
                boolean bankrollDy = EmptyUtil.isNoEmpty(this.bankrollOrgIdSet) && this.bankrollOrgIdSet.contains(companyId);
                logger.info("companyId" + companyId + "is isbankroll that" + bankrollDy);
                logger.info("PayableBillConfirmDrawService.process draftbillNo = {}", (Object)draftbillNo);
                if (bankrollDy && isReceiveOppNote && !StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue())) {
                    QFilter recQFilter = new QFilter("draftbillno", "=", (Object)draftbillNo);
                    recQFilter.and(new QFilter("company.name", "=", (Object)data.getString("receivername")));
                    recQFilter.and(new QFilter("subbillrange", "=", (Object)data.getString("subbillrange")));
                    recQFilter.and(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue()));
                    boolean isExistRecBill = QueryServiceHelper.exists((String)"cdm_receivablebill", (QFilter[])new QFilter[]{recQFilter});
                    logger.info("PayableBillConfirmDrawService.process draftbillNo = {}, recQFilter = {}, isExistRecBill = {}", new Object[]{draftbillNo, recQFilter.toString(), isExistRecBill});
                    if (!isExistRecBill) {
                        OperateOption operateOption = OperateOption.create();
                        operateOption.setVariableValue("draftbillnobydraw", data.getString("draftbillno"));
                        TmcOperateServiceHelper.execOperate((String)"pushrece", (String)"cdm_payablebill", (DynamicObject[])new DynamicObject[]{data}, (OperateOption)operateOption);
                    }
                }
            }
            data.set("draftbilltranstatus", (Object)"success");
            String billmedium = data.getDynamicObject("draftbilltype").getString("billmedium");
            if ("2".equals(billmedium)) {
                data.set("eledraftstatus", (Object)EleDraftBillStatusEnum.INVOICESIGNED.getValue());
            }
            if (EmptyUtil.isEmpty((Long)data.getLong("sourcebillid")) || !"ifm".equalsIgnoreCase(sourceStr = data.getString("source")) || !EmptyUtil.isNoEmpty((String)(failErrorMsg = DraftHelper.callIfmTransBillPayStatus((DynamicObject)data, (String)"D")))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e %1$s \u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u4ed8\u6b3e\u5931\u8d25\uff1a%2$s\u3002", (String)"PayableBillSubmitService_2", (String)"tmc-cdm-business", (Object[])new Object[0]), data.getString("billno"), failErrorMsg));
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        logger.info("PayableBillConfirmDrawService process is end");
    }

    private void book(long sourceBillId) {
        try (TXHandle tx = TX.requiresNew();){
            DynamicObject[] payBills = TmcDataServiceHelper.load((String)"cas_paybill", (String)"id,billstatus,matchflag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceBillId)});
            if (payBills.length > 0) {
                ArrayList<Long> ids = new ArrayList<Long>(payBills.length);
                for (DynamicObject payBill : payBills) {
                    if (!BillStatusEnum.PAYED.getValue().equals(payBill.getString("billstatus"))) continue;
                    ids.add(payBill.getLong("id"));
                }
                if (!ids.isEmpty()) {
                    logger.info("is will to book");
                    OperateOption create = OperateOption.create();
                    TmcOperateServiceHelper.execOperate((String)"manualbook", (String)"cas_paybill", (Object[])ids.toArray(), (OperateOption)create);
                    DynamicObject payBill = payBills[0];
                    String matchflag = payBill.getString("matchflag");
                    if (EmptyUtil.isNoEmpty((String)matchflag) && "8".equals(matchflag)) {
                        payBill.set("matchflag", (Object)"0");
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payBill});
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5f00\u7968\u767b\u8bb0\u786e\u8ba4\u51fa\u7968\u8865\u507f\u767b\u8d26\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)e);
            throw e;
        }
    }

    private void addSightDraftIds(Set<Long> sightDraftIds, DynamicObject[] dataEntities, boolean isNeedPreDbData) {
        HashSet<Long> supplyIdSet = new HashSet<Long>(16);
        HashSet<Long> customerIdSet = new HashSet<Long>(16);
        HashSet<Long> companyIdSet = new HashSet<Long>(16);
        block10: for (DynamicObject data : dataEntities) {
            Object billNo = data.get("basedraftbillno");
            if (!EmptyUtil.isEmpty((Object)billNo) && this.isFromCasPromissory(data)) {
                Date issueDate = data.getDate("issuedate");
                if (DateUtils.getCurrentDate().compareTo(DateUtils.truncateDate((Date)issueDate)) >= 0) {
                    sightDraftIds.add((Long)data.getPkValue());
                }
            }
            if (!isNeedPreDbData) continue;
            String payeeType = data.getString("payeetype");
            DynamicObject receiverObj = data.getDynamicObject("receiver");
            if (!EmptyUtil.isNoEmpty((DynamicObject)receiverObj)) continue;
            long receiverId = receiverObj.getLong("id");
            switch (payeeType) {
                case "bos_org": {
                    companyIdSet.add(receiverId);
                    continue block10;
                }
                case "bd_supplier": {
                    supplyIdSet.add(receiverId);
                    continue block10;
                }
                case "bd_customer": {
                    customerIdSet.add(receiverId);
                    continue block10;
                }
            }
        }
        if (!isNeedPreDbData) {
            return;
        }
        if (EmptyUtil.isNoEmpty(customerIdSet)) {
            DynamicObjectCollection customerDyColl = QueryServiceHelper.query((String)"bd_customer", (String)"id,internal_company", (QFilter[])new QFilter[]{new QFilter("id", "in", customerIdSet)});
            for (DynamicObject customerDy : customerDyColl) {
                long id = customerDy.getLong("id");
                long internal_company = customerDy.getLong("internal_company");
                if (0L == internal_company) continue;
                this.customIdAndInternalComMap.put(id, internal_company);
                companyIdSet.add(internal_company);
            }
        }
        if (EmptyUtil.isNoEmpty(supplyIdSet)) {
            DynamicObjectCollection supplyDyColl = QueryServiceHelper.query((String)"bd_supplier", (String)"id,internal_company", (QFilter[])new QFilter[]{new QFilter("id", "in", supplyIdSet)});
            for (DynamicObject supplyDy : supplyDyColl) {
                long id = supplyDy.getLong("id");
                long internal_company = supplyDy.getLong("internal_company");
                if (0L == internal_company) continue;
                this.supplyIdAndInternalComMap.put(id, internal_company);
                companyIdSet.add(internal_company);
            }
        }
        if (EmptyUtil.isNoEmpty(companyIdSet)) {
            Map paraMaps = SystemParameterHelper.getSysParamMap(companyIdSet);
            for (Map.Entry paraMap : paraMaps.entrySet()) {
                boolean isreceiveoppnote;
                Object isreceiveoppnoteObj;
                String keyId = (String)paraMap.getKey();
                Map valueMap = (Map)paraMap.getValue();
                if (!EmptyUtil.isNoEmpty(paraMap) || !EmptyUtil.isNoEmpty(isreceiveoppnoteObj = valueMap.get("isreceiveoppnote")) || !(isreceiveoppnote = ((Boolean)isreceiveoppnoteObj).booleanValue())) continue;
                this.openParamOrgIdSet.add(Long.parseLong(keyId));
            }
            DynamicObjectCollection bankrollDyColl = QueryServiceHelper.query((String)"bos_org", (String)"id,fisbankroll", (QFilter[])new QFilter[]{new QFilter("id", "in", companyIdSet), new QFilter("fisbankroll", "=", (Object)"1")});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bankrollDyColl)) {
                this.bankrollOrgIdSet = bankrollDyColl.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            }
        }
        logger.info("PayableBillDraw Service preDealDbData is end:");
    }

    private boolean isFromCasPromissory(DynamicObject data) {
        DynamicObject billtypeObj;
        return !EmptyUtil.isEmpty((Long)data.getLong("sourcebillid")) && SourceEnum.CAS.getValue().equals(data.getString("source")) && DraftHelper.isPromissory((Object)(billtypeObj = data.getDynamicObject("draftbilltype")));
    }

    public void genPurPay(long sourceBillId, String draftbillno, Boolean isSighDraft, Date issuedate) {
        try (TXHandle tx = TX.requiresNew();){
            DynamicObject[] payBills = TmcDataServiceHelper.load((String)"cas_paybill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceBillId)});
            if (payBills.length > 0) {
                ArrayList<Long> ids = new ArrayList<Long>(payBills.length);
                for (DynamicObject payBill : payBills) {
                    if (BillStatusEnum.PAYED.getValue().equals(payBill.getString("billstatus"))) continue;
                    ids.add(payBill.getLong("id"));
                }
                if (!ids.isEmpty()) {
                    logger.info("drawsave issuedate is:" + issuedate + ",draftbillno is:" + draftbillno);
                    OperateOption create = OperateOption.create();
                    create.setVariableValue("draftbillno", draftbillno);
                    create.setVariableValue("isfrompaydraft", "Y");
                    create.setVariableValue("bizFinishDate", DateUtils.formatString((Date)issuedate, (String)"yyyy-MM-dd"));
                    if (isSighDraft.booleanValue()) {
                        create.setVariableValue("cdmbook", "Y");
                    }
                    TmcOperateServiceHelper.execOperate((String)"pay", (String)"cas_paybill", (Object[])ids.toArray(), (OperateOption)create);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u786e\u8ba4\u4ed8\u6b3e\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)e);
            throw e;
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        logger.info("PayableBillConfirmDrawService afterProcess is start:");
        super.afterProcess(dataEntities);
        HashSet<Long> sightDraftIds = new HashSet<Long>(10);
        this.addSightDraftIds(sightDraftIds, dataEntities, false);
        HashSet<DynamicObject> needUpdateData = new HashSet<DynamicObject>(8);
        try {
            ArrayList<DynamicObject> needCallCfm = new ArrayList<DynamicObject>(8);
            for (DynamicObject data : dataEntities) {
                long supperbillid;
                DynamicObject billtypeObj;
                Date issuedate;
                Long billId = (Long)data.getPkValue();
                Boolean isSightDraft = Boolean.FALSE;
                logger.error("sight draft ids:" + ((Object)sightDraftIds).toString());
                if (sightDraftIds.contains(billId)) {
                    isSightDraft = Boolean.TRUE;
                }
                if (EmptyUtil.isEmpty((Object)(issuedate = data.getDate("issuedate")))) {
                    issuedate = data.getDate("bizdate");
                }
                long sourceBillId = data.getLong("sourcebillid");
                String draftbillno = data.getString("id");
                if (EmptyUtil.isNoEmpty((Long)sourceBillId)) {
                    this.genPurPay(sourceBillId, draftbillno, isSightDraft, issuedate);
                }
                String sourceBillType = "cas_paybill";
                String sourceStr = data.getString("source");
                if ("ifm".equals(sourceStr)) {
                    sourceBillType = "ifm_transhandlebill";
                } else if ("cas".equals(sourceStr)) {
                    sourceBillType = "cas_paybill";
                }
                HashSet<DynamicObject> billSet = new HashSet<DynamicObject>(1);
                billSet.add(data);
                Set needUpdateDySet = DraftHelper.updateDratBillCasEntry(billSet, (String)sourceBillType, (String)"add", (Long)sourceBillId);
                if (EmptyUtil.isNoEmpty((Object)needUpdateDySet)) {
                    needUpdateData.addAll(needUpdateDySet);
                }
                if (DraftHelper.isPromissory((Object)(billtypeObj = data.getDynamicObject("draftbilltype")))) {
                    Date issueDate = data.getDate("issuedate");
                    if (DateUtils.getCurrentDate().compareTo(DateUtils.truncateDate((Date)issueDate)) >= 0) {
                        data.set("draftbillstatus", (Object)DraftBillStatusEnum.PAYOFFED.getValue());
                        try {
                            long sourceId = data.getLong("sourcebillid");
                            if (EmptyUtil.isNoEmpty((Long)sourceId)) {
                                this.book(sourceId);
                            }
                        }
                        catch (Exception e) {
                            logger.error("book has exception:", (Throwable)e);
                        }
                        needUpdateData.add(data);
                    }
                }
                if (!EmptyUtil.isEmpty((Long)(supperbillid = data.getLong("supperbillid")))) continue;
                needCallCfm.add(data);
            }
            try {
                if (EmptyUtil.isNoEmpty(needCallCfm)) {
                    logger.info("needCallCfm size:" + needCallCfm.size());
                    Object result = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"cfm", (String)"guaranteeService", (String)"confirm", (Object[])needCallCfm.toArray(new Object[0]));
                    logger.info("needCallCfm end");
                }
            }
            catch (Exception e) {
                logger.error("needCallCfm has exception:", (Throwable)e);
            }
            if (EmptyUtil.isNoEmpty(needUpdateData) && needUpdateData.size() > 0) {
                logger.info("will save needUpdateData");
                SaveServiceHelper.save((DynamicObject[])needUpdateData.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            logger.error("PayableBillConfirmDrawService has exception:", (Throwable)e);
        }
        logger.info("PayableBillConfirmDrawService afterProcess is end:");
    }
}

