/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.payablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.enums.PayBillStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.helper.CasWriteBackHelper;
import kd.tmc.cdm.common.helper.ChequeHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.SystemParameterHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillSaveService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayableBillSaveService.class);
    private Set<Long> openParamOrgIdSet = new HashSet<Long>(16);
    private Map<Long, DynamicObject> payIdAndDyMap = new HashMap<Long, DynamicObject>(16);
    private Map<String, List<DynamicObject>> am_billbanknameMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<Long, DynamicObject> bank_idAndDyMap = new HashMap<Long, DynamicObject>(16);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(20);
        sic.add("basedraftbillno");
        sic.add("sourcebillid");
        sic.add("draftbillno");
        sic.add("issuedate");
        sic.add("bizdate");
        sic.add("amount");
        sic.add("supperbillamount");
        sic.add("creditlimit");
        sic.add("creditamount");
        sic.add("id");
        sic.add("company");
        sic.add("currency");
        sic.add("draftbilltype");
        sic.add("draweraccount");
        sic.add("drawerbankname");
        sic.add("drawerbankno");
        sic.add("subbillrange");
        sic.add("billidentitycode");
        sic.add("originalsubbillamount");
        sic.add("originalsubbillrang");
        sic.add("availableamount");
        sic.add("lockedamount");
        sic.add("usedamount");
        sic.add("issplit");
        sic.add("subbillstartflag");
        sic.add("subbillendflag");
        sic.add("source");
        sic.add("relatedelcbillid");
        sic.add("issuedate");
        sic.add("draftbillexpiredate");
        sic.add("draftbilltype");
        sic.add("billno");
        sic.add("receiverbankno");
        sic.add("receiverbank");
        sic.add("eledraftstatusnew");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        logger.info("PayableBillSaveService process is start:");
        Set<Long> exsitPayBillIdSet = this.preDealDbData(dataEntities);
        for (DynamicObject data : dataEntities) {
            BigDecimal creditAmount;
            DynamicObject creditLimit;
            Object billNo = data.get("basedraftbillno");
            BigDecimal billamount = data.getBigDecimal("supperbillamount");
            BigDecimal amount = data.getBigDecimal("amount");
            if (EmptyUtil.isEmpty((BigDecimal)billamount)) {
                data.set("supperbillamount", (Object)amount);
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(creditLimit = data.getDynamicObject("creditlimit"))) && EmptyUtil.isEmpty((BigDecimal)(creditAmount = data.getBigDecimal("creditamount")))) {
                data.set("creditamount", (Object)data.getBigDecimal("amount"));
            }
            if (!EmptyUtil.isEmpty((Object)billNo)) {
                data.set("draftbillno", ((DynamicObject)billNo).get("billno"));
                ArrayList<Long> ids = new ArrayList<Long>();
                ids.add(((DynamicObject)billNo).getLong("id"));
                ChequeHelper.checkCheque(ids, (Long)data.getLong("id"));
                ChequeHelper.updateCheques4Fill(ids, (Long)data.getLong("id"), (String)"cdm_payablebill", (String)data.getString("billno"), (BigDecimal)data.getBigDecimal("amount"));
            }
            this.setDrawerBankNameAndNo(data);
            long id = data.getLong("id");
            boolean isExsit = false;
            if (EmptyUtil.isNoEmpty(exsitPayBillIdSet)) {
                isExsit = exsitPayBillIdSet.contains(id);
            }
            DraftHelper.setBillCodeinfo((DynamicObject)data, (boolean)isExsit);
            DraftHelper.setSubBillInfo((DynamicObject)data);
            long companyId = data.getDynamicObject("company").getLong("id");
            boolean isSucWriteBack = this.openParamOrgIdSet.contains(companyId);
            long sourceBillid = data.getLong("sourcebillid");
            if (EmptyUtil.isEmpty((Long)sourceBillid)) continue;
            String sourceStr = data.getString("source");
            String failErrorMsg = "";
            if (!"ifm".equalsIgnoreCase(sourceStr)) continue;
            if (!isSucWriteBack) {
                failErrorMsg = DraftHelper.callIfmTransBillPayStatus((DynamicObject)data, (String)"D");
                if (EmptyUtil.isEmpty((String)failErrorMsg)) {
                    HashSet<DynamicObject> billSet = new HashSet<DynamicObject>(1);
                    billSet.add(data);
                    DraftHelper.updateDratBillCasEntry(billSet, (String)"ifm_transhandlebill", (String)"add", (Long)sourceBillid);
                }
            } else {
                failErrorMsg = DraftHelper.callIfmTransBillPayStatus((DynamicObject)data, (String)"B");
            }
            if (!EmptyUtil.isNoEmpty((String)failErrorMsg)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e %1$s \u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u4ed8\u6b3e\u5931\u8d25\uff1a%2$s\u3002", (String)"PayableBillSubmitService_2", (String)"tmc-cdm-business", (Object[])new Object[0]), data.getString("billno"), failErrorMsg));
        }
        logger.info("PayableBillSaveService save is end:");
    }

    private Set<Long> preDealDbData(DynamicObject[] dataEntities) {
        DynamicObjectCollection exsitPayBillColl;
        DynamicObjectCollection payBillColl;
        HashSet<Long> companyIdSet = new HashSet<Long>(16);
        HashSet<Long> sourceIdSet = new HashSet<Long>(16);
        HashSet<Long> paybillIdSet = new HashSet<Long>(16);
        Set<Long> exsitPayBillIdSet = new HashSet<Long>(16);
        HashSet<Long> bankIdSet = new HashSet<Long>(16);
        HashSet<String> bankAccountNumberSet = new HashSet<String>(16);
        for (DynamicObject data : dataEntities) {
            DynamicObject bank;
            DynamicObject draweraccount;
            long id;
            DynamicObject company = data.getDynamicObject("company");
            long companyId = company.getLong("id");
            companyIdSet.add(companyId);
            if (!EmptyUtil.isEmpty((Long)data.getLong("sourcebillid"))) {
                long sourcebillid = data.getLong("sourcebillid");
                sourceIdSet.add(sourcebillid);
            }
            if (0L != (id = data.getLong("id"))) {
                paybillIdSet.add(id);
            }
            if (null == (draweraccount = data.getDynamicObject("draweraccount"))) continue;
            String bankAccountNumber = draweraccount.getString("bankaccountnumber");
            if (EmptyUtil.isNoEmpty((String)bankAccountNumber)) {
                bankAccountNumberSet.add(bankAccountNumber);
            }
            if (null == (bank = draweraccount.getDynamicObject("bank"))) continue;
            bankIdSet.add(bank.getLong("id"));
        }
        Map paraMaps = SystemParameterHelper.getSysParamMap(companyIdSet);
        for (Map.Entry paraMap : paraMaps.entrySet()) {
            String keyId = (String)paraMap.getKey();
            Map valueMap = (Map)paraMap.getValue();
            boolean issucwriteback = (Boolean)valueMap.get("issucwriteback");
            if (!issucwriteback) continue;
            this.openParamOrgIdSet.add(Long.parseLong(keyId));
        }
        if (EmptyUtil.isNoEmpty(sourceIdSet) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(payBillColl = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceIdSet)})))) {
            this.payIdAndDyMap = payBillColl.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        }
        if (EmptyUtil.isNoEmpty(paybillIdSet) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(exsitPayBillColl = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", paybillIdSet), new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.PAYBILL.getValue())})))) {
            exsitPayBillIdSet = exsitPayBillColl.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        }
        if (EmptyUtil.isNoEmpty(bankAccountNumberSet)) {
            DynamicObjectCollection am_accountsColl = QueryServiceHelper.query((String)"am_accountmaintenance", (String)"id,billbank,billbank.name,billbankname", (QFilter[])new QFilter[]{new QFilter("account.bankaccountnumber", "in", bankAccountNumberSet)});
            this.am_billbanknameMap = am_accountsColl.stream().collect(Collectors.groupingBy(e -> e.getString("billbankname")));
        }
        if (EmptyUtil.isNoEmpty(bankIdSet)) {
            DynamicObjectCollection bankColls = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id,bebank,bebank.number,bebank.union_number,union_number", (QFilter[])new QFilter[]{new QFilter("id", "in", bankIdSet)});
            this.bank_idAndDyMap = bankColls.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        }
        logger.info("PayableBillSaveService preDealDbData is end:");
        return exsitPayBillIdSet;
    }

    private void setDrawerBankNameAndNo(DynamicObject data) {
        DynamicObject drawerAccount = data.getDynamicObject("draweraccount");
        if (!EmptyUtil.isEmpty((DynamicObject)drawerAccount)) {
            String bankaccountnumber = drawerAccount.getString("bankaccountnumber");
            List<DynamicObject> accountmaintenances = this.am_billbanknameMap.get(bankaccountnumber);
            if (!EmptyUtil.isEmpty(accountmaintenances)) {
                if (!EmptyUtil.isEmpty((Long)accountmaintenances.get(0).getLong("billbank"))) {
                    data.set("drawerbankname", (Object)accountmaintenances.get(0).getString("billbank.name"));
                }
                data.set("drawerbankno", (Object)accountmaintenances.get(0).getString("billbankname"));
                logger.info("PayableBillSaveService accountmaintenances not empty,billbank is \uff1a" + accountmaintenances.get(0).getLong("billbank") + ",billbankname is :" + accountmaintenances.get(0).getString("billbankname"));
            } else if (!EmptyUtil.isEmpty((DynamicObject)drawerAccount.getDynamicObject("bank"))) {
                DynamicObject finOrgInfoDO = this.bank_idAndDyMap.get(drawerAccount.getDynamicObject("bank").getLong("id"));
                data.set("drawerbankname", (Object)drawerAccount.getDynamicObject("bank").getString("name"));
                if (finOrgInfoDO.getLong("bebank") == 0L) {
                    data.set("drawerbankno", (Object)finOrgInfoDO.getString("union_number"));
                } else {
                    String union_number = finOrgInfoDO.getString("bebank.union_number");
                    if (EmptyUtil.isEmpty((String)union_number)) {
                        data.set("drawerbankno", (Object)finOrgInfoDO.getString("bebank.number"));
                    } else {
                        data.set("drawerbankno", (Object)union_number);
                    }
                }
                logger.info("PayableBillSaveService accountmaintenances is empty");
            }
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        logger.info("PayableBillSaveService save afterProcess is start:");
        for (DynamicObject data : dataEntities) {
            long companyId = data.getDynamicObject("company").getLong("id");
            boolean isSucWriteBack = this.openParamOrgIdSet.contains(companyId);
            long sourceBillid = data.getLong("sourcebillid");
            if (EmptyUtil.isEmpty((Long)sourceBillid)) continue;
            if (!isSucWriteBack) {
                Date issuedate = data.getDate("issuedate");
                if (EmptyUtil.isEmpty((Object)issuedate)) {
                    issuedate = data.getDate("bizdate");
                }
                this.genPurPay(sourceBillid, data.getString("id"), issuedate);
                HashSet<DynamicObject> billSet = new HashSet<DynamicObject>(1);
                billSet.add(data);
                Set needUpdaeDy = DraftHelper.updateDratBillCasEntry(billSet, (String)"cas_paybill", (String)"add", (Long)sourceBillid);
                if (!EmptyUtil.isNoEmpty((Object)needUpdaeDy)) continue;
                SaveServiceHelper.save((DynamicObject[])needUpdaeDy.toArray(new DynamicObject[0]));
                continue;
            }
            CasWriteBackHelper.writePayStatus((String)String.valueOf(sourceBillid), (String)PayBillStatusEnum.DRAFTING.getValue());
        }
        this.dealAutoRelatedPrebill(dataEntities);
        Map operationVariable = this.getOperationVariable();
        if (EmptyUtil.isNoEmpty((Object)operationVariable) && "true".equals(operationVariable.get("modifysave"))) {
            logger.info("is start to do confirmGuaranteeUse");
            GuaranteeUseHelper.confirmGuaranteeUse((DynamicObject[])dataEntities);
            logger.info("end do confirmGuaranteeUse");
        }
        logger.info("end do afterProcess");
    }

    private void dealAutoRelatedPrebill(DynamicObject[] dataEntities) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DynamicObject dataEntitie : dataEntities) {
            String source = dataEntitie.getString("source");
            Long relatedelcbillid = dataEntitie.getLong("relatedelcbillid");
            if (!"apply".equals(source) || relatedelcbillid == null || relatedelcbillid == 0L) continue;
            ids.add(dataEntitie.getLong("id"));
        }
        if (EmptyUtil.isNoEmpty(ids)) {
            TmcOperateServiceHelper.execOperate((String)"autorelatedprebill", (String)"cdm_payablebill", (Object[])ids.toArray(new Long[0]), (OperateOption)OperateOption.create());
        }
    }

    public void genPurPay(long sourceBillId, String draftbillno, Date issuedate) {
        try (TXHandle tx = TX.requiresNew();){
            DynamicObject payBill = this.payIdAndDyMap.get(sourceBillId);
            if (null != payBill) {
                ArrayList<Long> ids = new ArrayList<Long>(1);
                if (!BillStatusEnum.PAYED.getValue().equals(payBill.getString("billstatus"))) {
                    ids.add(payBill.getLong("id"));
                }
                if (!ids.isEmpty()) {
                    logger.info("save issuedate is:" + issuedate);
                    OperateOption create = OperateOption.create();
                    create.setVariableValue("draftbillno", draftbillno);
                    create.setVariableValue("isfrompaydraft", "Y");
                    create.setVariableValue("bizFinishDate", DateUtils.formatString((Date)issuedate, (String)"yyyy-MM-dd"));
                    TmcOperateServiceHelper.execOperate((String)"pay", (String)"cas_paybill", (Object[])ids.toArray(), (OperateOption)create);
                }
            }
        }
    }
}

