/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.tradebill;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.helper.TradeBillHelper;
import kd.tmc.cdm.business.lock.DraftLockServiceFactory;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.helper.BotpHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillDeleteService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(TradeBillDeleteService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entrys");
        selector.add("draftbill");
        selector.add("sourcebillid");
        selector.add("source");
        selector.add("tradetype");
        selector.add("billlogid");
        selector.add("billamt");
        selector.add("sourcebilltype");
        selector.add("isrejectrefundgen");
        selector.add("billno");
        selector.add("entryisrejectrefund");
        selector.add("entryisrepay");
        selector.add("isrepaygen");
        selector.add("changeflag");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List<DraftLockInfo> releaseInfoList;
        List<DynamicObject> notChangeTradeBillS;
        List<DraftLockInfo> changeLockInfoList = LockDraftHelper.getChangeLockInfo(dataEntities);
        if (EmptyUtil.isNoEmpty(changeLockInfoList)) {
            List lockResultList = DraftLockServiceFactory.getService().transfer(changeLockInfoList, true);
            LockDraftHelper.checkHasFail(lockResultList);
        }
        if (EmptyUtil.isNoEmpty(notChangeTradeBillS = LockDraftHelper.getNotChangeTradeBills(dataEntities)) && EmptyUtil.isNoEmpty(releaseInfoList = LockDraftHelper.getReleaseInfo(notChangeTradeBillS))) {
            List releaseResultList = DraftLockServiceFactory.getService().lock(releaseInfoList, true);
            LockDraftHelper.checkHasFail(releaseResultList);
        }
        TradeBillHelper.handleSupperDraftBill((DynamicObject[])dataEntities);
        kd.tmc.cdm.common.helper.TradeBillHelper.processRejectRefundGenBill((DynamicObject[])dataEntities);
        kd.tmc.cdm.common.helper.TradeBillHelper.processFailRepayGenBill((DynamicObject[])dataEntities);
        for (DynamicObject tradebill : dataEntities) {
            String sourcePayBillId;
            Long sourcebillId = tradebill.getLong("sourcebillid");
            String source = tradebill.getString("source");
            if ((!SourceEnum.CAS.getValue().equals(source) || null == sourcebillId || sourcebillId == 0L) && EmptyUtil.isNoEmpty((String)(sourcePayBillId = DraftHelper.checkReleatedByPayBillSelectEndorseBill((DynamicObject)tradebill)))) {
                sourcebillId = Long.parseLong(sourcePayBillId);
            }
            if (!EmptyUtil.isNoEmpty((Long)sourcebillId)) continue;
            this.writePayBillStatus(sourcebillId);
            Set draftBillSet = tradebill.getDynamicObjectCollection("entrys").stream().map(e -> e.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet());
            Set payBillDatas = DraftHelper.getPayBillDatas(draftBillSet, (long)sourcebillId, (boolean)false, (boolean)true);
            Set needUpdatePayBillDySet = DraftHelper.updateDratBillCasEntry((Set)payBillDatas, (String)"cas_paybill", (String)"delete", (Long)sourcebillId);
            if (!EmptyUtil.isNoEmpty((Object)needUpdatePayBillDySet)) continue;
            SaveServiceHelper.save((DynamicObject[])needUpdatePayBillDySet.toArray(new DynamicObject[0]));
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        for (DynamicObject tradebill : dataEntities) {
            Long pkValue = (Long)tradebill.getPkValue();
            List linkedBill = BotpHelper.getLinkedBill((Long)pkValue, (boolean)true);
            if (linkedBill.size() <= 0) continue;
            TradeBillDeleteService.deleteRation(String.valueOf(pkValue));
        }
    }

    public static void deleteRation(String tBillId) {
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        String sBuilder = "delete from T_BOTP_BillTracker where FTBillId= ?";
        params.add(new SqlParameter(":FTBillId", -5, (Object)tBillId));
        try (TXHandle tx = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.basedata, (String)sBuilder, (Object[])params.toArray(new SqlParameter[params.size()]));
        }
    }

    private void writePayBillStatus(Long sourceBillId) {
        try (TXHandle tx = TX.requiresNew();){
            ArrayList<DynamicObject> paybills = new ArrayList<DynamicObject>();
            try {
                DynamicObject[] sourcePayBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,billstatus,sourcebillid,sourcebilltype,applyorg,entrustorg", (QFilter[])new QFilter("id", "=", (Object)sourceBillId).toArray());
                if (sourcePayBills.length > 0) {
                    DynamicObject sourcePayBill = sourcePayBills[0];
                    if (Objects.equals(sourcePayBill.getString("billstatus"), "J")) {
                        sourcePayBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                        paybills.add(sourcePayBill);
                        DynamicObject srcPaybill = this.querySourceBills(sourcePayBill);
                        if (null != srcPaybill && "J".equals(srcPaybill.getString("billstatus"))) {
                            srcPaybill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                            paybills.add(srcPaybill);
                        }
                        SaveServiceHelper.save((DynamicObject[])paybills.toArray(new DynamicObject[0]));
                    } else if (Objects.equals(sourcePayBill.getString("billstatus"), "D")) {
                        logger.info("cancelpay  srcPaybill:" + sourceBillId);
                        OperateOption create = OperateOption.create();
                        create.setVariableValue("isfrombill", "y");
                        create.setVariableValue("fromdraw", "y");
                        OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"cancelpay", (String)"cas_paybill", (Object[])new Object[]{sourceBillId}, (OperateOption)create);
                        sourcePayBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourcePayBill});
                    }
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private DynamicObject querySourceBills(DynamicObject paybill) {
        if (EmptyUtil.isEmpty((DynamicObject)paybill)) {
            return null;
        }
        DynamicObject srcPayBill = null;
        String sourcebilltype = paybill.getString("sourcebilltype");
        DynamicObject applyorg = paybill.getDynamicObject("applyorg");
        long sourcebillid = paybill.getLong("sourcebillid");
        if ("cas_paybill".equals(sourcebilltype) && applyorg != null && sourcebillid != 0L) {
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)sourcebillid), new QFilter("entrustorg", "is not null", null), new QFilter("entrustorg", "!=", (Object)0)};
            srcPayBill = TmcDataServiceHelper.loadSingle((String)"cas_paybill", (String)"id,billstatus", (QFilter[])qFilters);
        }
        return srcPayBill;
    }
}

