/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.tradebill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.helper.TradeBillHelper;
import kd.tmc.cdm.business.lock.DraftLockServiceFactory;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.helper.BotpHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillInvalidService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(TradeBillInvalidService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entrys");
        selector.add("draftbill");
        selector.add("sourcebillid");
        selector.add("source");
        selector.add("tradetype");
        selector.add("billlogid");
        selector.add("billamt");
        selector.add("sourcebilltype");
        selector.add("isrejectrefundgen");
        selector.add("billno");
        selector.add("entryisrejectrefund");
        selector.add("entryisrepay");
        selector.add("isrepaygen");
        selector.add("changeflag");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List<DraftLockInfo> releaseInfoList;
        List<DynamicObject> notChangeTradeBillS;
        List<DraftLockInfo> changeLockInfoList = LockDraftHelper.getChangeLockInfo(dataEntities);
        if (EmptyUtil.isNoEmpty(changeLockInfoList)) {
            List lockResultList = DraftLockServiceFactory.getService().transfer(changeLockInfoList, true);
            LockDraftHelper.checkHasFail(lockResultList);
        }
        if (EmptyUtil.isNoEmpty(notChangeTradeBillS = LockDraftHelper.getNotChangeTradeBills(dataEntities)) && EmptyUtil.isNoEmpty(releaseInfoList = LockDraftHelper.getReleaseInfo(notChangeTradeBillS))) {
            List releaseResultList = DraftLockServiceFactory.getService().lock(releaseInfoList, true);
            LockDraftHelper.checkHasFail(releaseResultList);
        }
        String tradeBillType = dataEntities[0].getDataEntityType().getName();
        for (DynamicObject tradebill : dataEntities) {
            String sourcePayBillId;
            this.clearIspushTradeBill(tradebill);
            DynamicObjectCollection entrys = tradebill.getDynamicObjectCollection("entrys");
            if (CollectionUtils.isEmpty((Collection)entrys)) continue;
            String tradeType = tradebill.getString("tradetype");
            long tradeBillId = tradebill.getLong("id");
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            Long sourcebillId = tradebill.getLong("sourcebillid");
            String source = tradebill.getString("source");
            if ((!SourceEnum.CAS.getValue().equals(source) || null == sourcebillId || sourcebillId == 0L) && EmptyUtil.isNoEmpty((String)(sourcePayBillId = DraftHelper.checkReleatedByPayBillSelectEndorseBill((DynamicObject)tradebill)))) {
                sourcebillId = Long.parseLong(sourcePayBillId);
            }
            if (!EmptyUtil.isNoEmpty((Long)sourcebillId)) continue;
            this.writePayBillStatus(sourcebillId);
            Set draftBillSet = tradebill.getDynamicObjectCollection("entrys").stream().map(e -> e.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet());
            Set payBillDatas = DraftHelper.getPayBillDatas(draftBillSet, (long)sourcebillId, (boolean)false, (boolean)true);
            Set needUpdatePayBillDySet = DraftHelper.updateDratBillCasEntry((Set)payBillDatas, (String)"cas_paybill", (String)"delete", (Long)sourcebillId);
            if (!EmptyUtil.isNoEmpty((Object)needUpdatePayBillDySet)) continue;
            SaveServiceHelper.save((DynamicObject[])needUpdatePayBillDySet.toArray(new DynamicObject[0]));
        }
        TradeBillHelper.handleSupperDraftBill((DynamicObject[])dataEntities);
        kd.tmc.cdm.common.helper.TradeBillHelper.processRejectRefundGenBill((DynamicObject[])dataEntities);
        kd.tmc.cdm.common.helper.TradeBillHelper.processFailRepayGenBill((DynamicObject[])dataEntities);
        this.deleteRation(dataEntities);
    }

    private void deleteRation(DynamicObject[] dataEntities) {
        for (DynamicObject tradeBill : dataEntities) {
            Long pkValue;
            List linkedBill;
            if (!tradeBill.getBoolean("isrejectrefundgen") && !tradeBill.getBoolean("isrepaygen") || (linkedBill = BotpHelper.getLinkedBill((Long)(pkValue = (Long)tradeBill.getPkValue()), (boolean)true)).size() <= 0) continue;
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
            String sBuilder = "delete from T_BOTP_BillTracker where FTBillId= ?";
            params.add(new SqlParameter(":FTBillId", -5, (Object)pkValue));
            try (TXHandle tx = TX.requiresNew();){
                DB.execute((DBRoute)DBRoute.basedata, (String)sBuilder, (Object[])params.toArray(new SqlParameter[params.size()]));
            }
        }
    }

    private void clearIspushTradeBill(DynamicObject tradebill) {
        Map botpMap = BFTrackerServiceHelper.findSourceBills((String)"cdm_drafttradebill", (Long[])new Long[]{tradebill.getLong("id")});
        if (!EmptyUtil.isEmpty((Object)botpMap) && botpMap.size() > 0) {
            HashSet pkValues;
            if (botpMap.containsKey("cdm_discount_apply")) {
                pkValues = (HashSet)botpMap.get("cdm_discount_apply");
                if (null != pkValues && pkValues.size() > 0) {
                    DynamicObject[] discountApplyBills;
                    for (DynamicObject discountApply : discountApplyBills = TmcDataServiceHelper.load((String)"cdm_discount_apply", (String)"id,ispushtradebill", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkValues.toArray())})) {
                        discountApply.set("ispushtradebill", (Object)false);
                    }
                    SaveServiceHelper.save((DynamicObject[])discountApplyBills);
                }
                botpMap.remove("cdm_discount_apply");
            }
            if (botpMap.containsKey("cdm_pledge_apply")) {
                pkValues = (HashSet)botpMap.get("cdm_pledge_apply");
                if (null != pkValues && pkValues.size() > 0) {
                    DynamicObject[] pledgeApplyBills;
                    for (DynamicObject pledgeApply : pledgeApplyBills = TmcDataServiceHelper.load((String)"cdm_pledge_apply", (String)"id,ispushtradebill", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkValues.toArray())})) {
                        pledgeApply.set("ispushtradebill", (Object)false);
                    }
                    SaveServiceHelper.save((DynamicObject[])pledgeApplyBills);
                }
                botpMap.remove("cdm_pledge_apply");
            }
        }
    }

    private void writePayBillStatus(Long sourceBillId) {
        try (TXHandle tx = TX.requiresNew();){
            ArrayList<DynamicObject> paybills = new ArrayList<DynamicObject>();
            try {
                DynamicObject[] sourcePayBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,billstatus,sourcebillid,sourcebilltype,applyorg,entrustorg", (QFilter[])new QFilter("id", "=", (Object)sourceBillId).toArray());
                if (sourcePayBills.length > 0) {
                    DynamicObject srcPaybill;
                    DynamicObject sourcePayBill = sourcePayBills[0];
                    if (Objects.equals(sourcePayBill.getString("billstatus"), "D") || Objects.equals(sourcePayBill.getString("billstatus"), "J")) {
                        sourcePayBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                        paybills.add(sourcePayBill);
                    }
                    if (null != (srcPaybill = this.querySourceBills(sourcePayBill)) && ("D".equals(srcPaybill.getString("billstatus")) || "J".equals(srcPaybill.getString("billstatus")))) {
                        srcPaybill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                        paybills.add(srcPaybill);
                    }
                    SaveServiceHelper.save((DynamicObject[])paybills.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private DynamicObject querySourceBills(DynamicObject paybill) {
        if (EmptyUtil.isEmpty((DynamicObject)paybill)) {
            return null;
        }
        DynamicObject srcPayBill = null;
        String sourcebilltype = paybill.getString("sourcebilltype");
        DynamicObject applyorg = paybill.getDynamicObject("applyorg");
        long sourcebillid = paybill.getLong("sourcebillid");
        if ("cas_paybill".equals(sourcebilltype) && applyorg != null && sourcebillid != 0L) {
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)sourcebillid), new QFilter("entrustorg", "is not null", null), new QFilter("entrustorg", "!=", (Object)0)};
            srcPayBill = TmcDataServiceHelper.loadSingle((String)"cas_paybill", (String)"id,billstatus", (QFilter[])qFilters);
        }
        return srcPayBill;
    }
}

