/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.tradebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.tmc.cdm.business.lock.DraftLockServiceFactory;
import kd.tmc.cdm.business.service.DraftAmountLockSubInfo;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.business.service.LockResult;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.enums.LogBizStatusEnum;
import kd.tmc.cdm.common.enums.LogBizTypeEnum;
import kd.tmc.cdm.common.enums.OperateTypeEnum;
import kd.tmc.cdm.common.enums.PayBillStatusEnum;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.helper.BaseDataHelper;
import kd.tmc.cdm.common.helper.CasWriteBackHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.TradeBillAmountHelper;
import kd.tmc.cdm.common.helper.TradeBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class TradeBillSaveService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(TradeBillSaveService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entrys");
        selector.add("source");
        selector.add("tradetype");
        selector.add("draftbill");
        selector.add("oldstatus");
        selector.add("recbody");
        selector.add("recbodyname");
        selector.add("payeetypetext");
        selector.add("beendorsortext");
        selector.add("beendorsor");
        selector.add("sourcebillid");
        selector.add("sourcebilltype");
        selector.add("allocbillentryid");
        selector.add("pledgeebase");
        selector.add("bizdate");
        selector.add("bizfinishdate");
        selector.add("bankacct");
        selector.add("bank");
        selector.add("bankcode");
        selector.add("pledgeetype");
        selector.add("pledgeeaccount");
        selector.add("pledgeeopenbank");
        selector.add("pledgeeopenbanknumber");
        selector.add("payinteramount_bank");
        selector.add("owndiscountinterest");
        selector.add("payinterestamount");
        selector.add("discount_interest");
        selector.add("allbillsamount");
        selector.add("billlogid");
        selector.add("billamt");
        selector.add("isrepaygen");
        selector.add("isrejectrefundgen");
        selector.add("billno");
        selector.add("rptype");
        selector.add("sourcebillid");
        selector.add("source");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List<DraftLockInfo> changeLockInfoList;
        List<DraftLockInfo> lockAndReleaseInfoList;
        logger.info("TradeBillSaveService is start:" + dataEntities[0].getString("billno"));
        Object[] noReCallAddDataEntities = this.isNeedReCallAddLog(dataEntities);
        this.isRejectRefundAddLog((DynamicObject[])noReCallAddDataEntities);
        List<DynamicObject> notChangeTradeBillS = LockDraftHelper.getNotChangeTradeBills((DynamicObject[])noReCallAddDataEntities);
        if (EmptyUtil.isNoEmpty(notChangeTradeBillS) && EmptyUtil.isNoEmpty(lockAndReleaseInfoList = this.getLockAndReleaseInfo(notChangeTradeBillS.toArray(new DynamicObject[0])))) {
            List lockResultList = DraftLockServiceFactory.getService().lock(lockAndReleaseInfoList, true);
            this.checkResultAndFillLog((DynamicObject[])noReCallAddDataEntities, lockResultList, false);
        }
        if (EmptyUtil.isNoEmpty((Object[])noReCallAddDataEntities) && EmptyUtil.isNoEmpty(changeLockInfoList = LockDraftHelper.getChangeLockInfo((DynamicObject[])noReCallAddDataEntities))) {
            List changeLockResultList = DraftLockServiceFactory.getService().transfer(changeLockInfoList, true);
            this.checkResultAndFillLog((DynamicObject[])noReCallAddDataEntities, changeLockResultList, true);
        }
        for (DynamicObject data : dataEntities) {
            DynamicObject draftBill;
            DynamicObjectCollection entrys;
            DynamicObject beendorsor;
            String payeeTypeText;
            DynamicObject recBody = data.getDynamicObject("recbody");
            if (EmptyUtil.isNoEmpty((DynamicObject)recBody)) {
                data.set("recbodyname", (Object)recBody.getString("name"));
            }
            if (!"other".equals(payeeTypeText = data.getString("payeetypetext")) && EmptyUtil.isNoEmpty((DynamicObject)(beendorsor = data.getDynamicObject("beendorsor")))) {
                data.set("beendorsortext", (Object)beendorsor.getString("name"));
            }
            this.setBeendorsorBankAndNo(data);
            this.setPledgeeBankAndNo(data);
            TradeBillAmountHelper.setAllBillAmount((DynamicObject)data);
            String rpType = data.getString("rptype");
            if (!EmptyUtil.isEmpty((String)rpType) || !EmptyUtil.isNoEmpty((DynamicObjectCollection)(entrys = data.getDynamicObjectCollection("entrys"))) || EmptyUtil.isEmpty((DynamicObject)(draftBill = ((DynamicObject)entrys.get(0)).getDynamicObject("draftbill")))) continue;
            data.set("rptype", (Object)draftBill.getString("rptype"));
        }
    }

    private void checkResultAndFillLog(DynamicObject[] noReCallAddDataEntities, List<LockResult> lockResultList, boolean isChange) {
        if (EmptyUtil.isNoEmpty(lockResultList)) {
            List failLockResultList = lockResultList.stream().filter(e -> EmptyUtil.isNoEmpty((Long)e.getSourceBillId()) && !e.isSuccess()).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(failLockResultList)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5360\u7528\u66f4\u65b0\u65e5\u5fd7\u5931\u8d25\u3002", (String)"TradeBillSaveService_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            Map<Long, LockResult> tradeIdAndDyMap = lockResultList.stream().collect(Collectors.toMap(LockResult::getSourceBillId, x -> x));
            for (DynamicObject data : noReCallAddDataEntities) {
                long payBillId = data.getLong("id");
                Long sourcebillId = data.getLong("sourcebillid");
                DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
                for (DynamicObject entry : entrys) {
                    Long draftBillId = entry.getDynamicObject("draftbill").getLong("id");
                    LockResult lockResult = tradeIdAndDyMap.get(payBillId);
                    if (EmptyUtil.isEmpty((Object)lockResult) && EmptyUtil.isNoEmpty((Long)sourcebillId) && isChange) {
                        lockResult = tradeIdAndDyMap.get(sourcebillId);
                    }
                    if (!EmptyUtil.isNoEmpty((Object)lockResult)) continue;
                    Map<Long, Long> billIdLogIdMap = lockResult.getBillIdLogIdMap();
                    boolean success = lockResult.isSuccess();
                    Long billLogId = billIdLogIdMap.get(draftBillId);
                    if (!EmptyUtil.isNoEmpty((Long)billLogId) || !success) continue;
                    entry.set("billlogid", (Object)billLogId);
                }
            }
        }
    }

    private DynamicObject[] isNeedReCallAddLog(DynamicObject[] dataEntities) {
        ArrayList isRePayGenIds = new ArrayList();
        Arrays.stream(dataEntities).filter(v -> v.getBoolean("isrepaygen") || "fromcollect".equals(v.getString("source"))).forEach(v -> isRePayGenIds.add(v.getLong("id")));
        HashMap rePayGentradeBillMap = Arrays.stream(dataEntities).filter(v -> isRePayGenIds.contains(v.getLong("id"))).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
        HashSet notNeedDealIdSet = new HashSet(8);
        for (Map.Entry entry : rePayGentradeBillMap.entrySet()) {
            DynamicObject data = (DynamicObject)entry.getValue();
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
            Set billLogIdSet = entrys.stream().map(e -> e.getLong("billlogid")).collect(Collectors.toSet());
            Object[] billLogIdArr = TmcDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,bizstatus,issplit,draftid", (QFilter[])new QFilter[]{new QFilter("id", "in", billLogIdSet), new QFilter("bizstatus", "=", (Object)"fail"), new QFilter("issplit", "=", (Object)"1")});
            if (!EmptyUtil.isEmpty((Object[])billLogIdArr)) continue;
            notNeedDealIdSet.add(entry.getKey());
        }
        if (EmptyUtil.isNoEmpty(notNeedDealIdSet)) {
            for (Long needRemoveId : notNeedDealIdSet) {
                rePayGentradeBillMap.remove(needRemoveId);
                isRePayGenIds.remove(needRemoveId);
            }
        }
        if (EmptyUtil.isNoEmpty((Object)rePayGentradeBillMap) && rePayGentradeBillMap.size() > 0) {
            for (Map.Entry entry : rePayGentradeBillMap.entrySet()) {
                LockDraftHelper.reCallAddLog((DynamicObject)entry.getValue());
            }
        }
        List<DynamicObject> isNoRePayGenList = Arrays.stream(dataEntities).filter(v -> !isRePayGenIds.contains(v.getLong("id"))).collect(Collectors.toList());
        DynamicObject[] noReCallAddDataEntities = isNoRePayGenList.toArray(new DynamicObject[0]);
        return noReCallAddDataEntities;
    }

    private void isRejectRefundAddLog(DynamicObject[] dataEntities) {
        boolean rejectRefund = Boolean.parseBoolean(this.operationVariable.getOrDefault("rejectRefund", "false"));
        ArrayList isRejectRefundGenIds = new ArrayList();
        Arrays.stream(dataEntities).filter(v -> v.getBoolean("isrejectrefundgen")).forEach(v -> isRejectRefundGenIds.add(v.getLong("id")));
        if (rejectRefund) {
            Arrays.stream(dataEntities).forEach(v -> isRejectRefundGenIds.add(v.getLong("id")));
        }
        HashMap refundGenTradeBillMap = Arrays.stream(dataEntities).filter(v -> isRejectRefundGenIds.contains(v.getLong("id"))).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
        Set sourceBillIdSet = Arrays.stream(dataEntities).filter(v -> isRejectRefundGenIds.contains(v.getLong("id"))).map(x -> x.getLong("sourcebillid")).collect(Collectors.toSet());
        DynamicObject[] draftTradeBills = TmcDataServiceHelper.load((Object[])sourceBillIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_drafttradebill"));
        HashMap draftTradeBillsMap = Arrays.stream(draftTradeBills).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
        for (Map.Entry entry : refundGenTradeBillMap.entrySet()) {
            DynamicObject[] drafts;
            DynamicObject refundGenTradeBill = (DynamicObject)entry.getValue();
            Long sourceBillId = refundGenTradeBill.getLong("sourcebillid");
            DynamicObjectCollection entrys = refundGenTradeBill.getDynamicObjectCollection("entrys");
            Set draftIdSet = entrys.stream().map(e -> e.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet());
            for (DynamicObject draft : drafts = TmcDataServiceHelper.load((Object[])draftIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"))) {
                Long equalTradeBillId = draft.getLong("equaltradebillid");
                Long supperBillId = draft.getLong("supperbillid");
                DynamicObject draftTradeBill = (DynamicObject)draftTradeBillsMap.get(sourceBillId);
                if (!EmptyUtil.isNoEmpty((Long)sourceBillId) || sourceBillId <= 0L || !EmptyUtil.isNoEmpty((DynamicObject)draftTradeBill)) continue;
                Set supperDraftIdSet = draftTradeBill.getDynamicObjectCollection("entrys").stream().map(x -> x.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet());
                Map<Long, Long> draftIdAndBillLogIdMap = draftTradeBill.getDynamicObjectCollection("entrys").stream().collect(Collectors.toMap(o -> o.getDynamicObject("draftbill").getLong("id"), o -> o.getLong("billlogid")));
                Long billLogId = draftIdAndBillLogIdMap.get(supperBillId);
                Object[] draftLogArr = new DynamicObject[]{};
                if (EmptyUtil.isNoEmpty((Long)billLogId) && billLogId > 0L) {
                    QFilter idQf = new QFilter("id", "=", (Object)billLogId);
                    QFilter newChildLogIdQf = new QFilter("newchildlogid", "!=", (Object)0);
                    draftLogArr = BusinessDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,bizstatus,draftid,splitedsubbillid,newchildlogid", (QFilter[])new QFilter[]{idQf, newChildLogIdQf});
                }
                if (sourceBillId.compareTo(equalTradeBillId) != 0 || !supperDraftIdSet.contains(supperBillId) || !EmptyUtil.isNoEmpty((Object[])draftLogArr) || StringUtils.equals((CharSequence)draftLogArr[0].getString("bizstatus"), (CharSequence)LogBizStatusEnum.SUCCESS.getValue())) continue;
                List<DraftLockInfo> releaseInfoList = this.getReleaseInfo(draftTradeBill, supperBillId);
                DraftLockServiceFactory.getService().lock(releaseInfoList, true);
            }
            List<DraftLockInfo> lockAndReleaseInfoList = this.getLockAndReleaseInfo(new DynamicObject[]{refundGenTradeBill});
            if (!EmptyUtil.isNoEmpty(lockAndReleaseInfoList)) continue;
            List lockResultList = DraftLockServiceFactory.getService().lock(lockAndReleaseInfoList, true);
            this.checkResultAndFillLog(new DynamicObject[]{refundGenTradeBill}, lockResultList, false);
        }
    }

    private List<DraftLockInfo> getReleaseInfo(DynamicObject tradeBill, Long draftBillId) {
        String tradeBillType = tradeBill.getDataEntityType().getName();
        ArrayList<DraftLockInfo> releaseInfoList = new ArrayList<DraftLockInfo>(8);
        DraftLockInfo draftLockInfo = new DraftLockInfo();
        long tradeBillId = tradeBill.getLong("id");
        String billno = tradeBill.getString("billno");
        draftLockInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
        draftLockInfo.setSourceBillType(tradeBillType);
        draftLockInfo.setSourceBillId(Long.valueOf(tradeBillId));
        draftLockInfo.setBizBillNo(billno);
        draftLockInfo.setOperateType(OperateTypeEnum.COMPLETE.getValue());
        DynamicObjectCollection entrys = tradeBill.getDynamicObjectCollection("entrys");
        List lockDraftIds = entrys.stream().map(v -> v.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toList());
        HashMap draftIdDealAmountMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbill").getLong("id"), o -> o.getBigDecimal("billamt"), (o1, o2) -> o1, HashMap::new));
        HashMap draftIdLogIdMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbill").getLong("id"), o -> o.getLong("billlogid"), (o1, o2) -> o1, HashMap::new));
        ArrayList<DraftAmountLockSubInfo> releaseSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
        for (Long lockDraftId : lockDraftIds) {
            if (draftBillId.compareTo(lockDraftId) != 0) continue;
            DraftAmountLockSubInfo draftAmountreleaseSubInfo = new DraftAmountLockSubInfo();
            draftAmountreleaseSubInfo.setBillId(lockDraftId);
            Long draftLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
            draftAmountreleaseSubInfo.setBillLogId(draftLogId);
            BigDecimal dealAmount = draftIdDealAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(lockDraftId);
            draftAmountreleaseSubInfo.setDealAmount(dealAmount);
            draftAmountreleaseSubInfo.setOperateType(OperateTypeEnum.COMPLETE.getValue());
            draftAmountreleaseSubInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
            releaseSubInfoList.add(draftAmountreleaseSubInfo);
        }
        draftLockInfo.setLockSubInfoList(releaseSubInfoList);
        releaseInfoList.add(draftLockInfo);
        return releaseInfoList;
    }

    private List<DraftLockInfo> getLockAndReleaseInfo(DynamicObject[] dataEntities) {
        ArrayList<DraftLockInfo> lockAndReleaseInfoList = new ArrayList<DraftLockInfo>(8);
        DynamicObjectType dynamicObjectType = dataEntities[0].getDynamicObjectType();
        String sourceBillTypeStr = dynamicObjectType.getName();
        Set tradeBillIdSet = Arrays.stream(dataEntities).map(e -> e.getLong("id")).collect(Collectors.toSet());
        Object[] tradeBillDyArr = TmcDataServiceHelper.load((Object[])tradeBillIdSet.toArray(), (DynamicObjectType)dynamicObjectType);
        Map<Object, Object> tradeBillIdAndDyMap = new HashMap(8);
        if (EmptyUtil.isNoEmpty((Object[])tradeBillDyArr)) {
            tradeBillIdAndDyMap = Arrays.stream(tradeBillDyArr).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        }
        for (DynamicObject data : dataEntities) {
            Long sourcebillId = data.getLong("sourcebillid");
            String source = data.getString("source");
            List<Object> casDraftIdList = new ArrayList(8);
            boolean isFromCas = false;
            if (SourceEnum.CAS.getValue().equals(source) && EmptyUtil.isNoEmpty((Long)sourcebillId)) {
                isFromCas = true;
                Object[] paybills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,draftbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourcebillId)});
                if (EmptyUtil.isNoEmpty((Object[])paybills)) {
                    casDraftIdList = paybills[0].getDynamicObjectCollection("draftbill").stream().filter(draftbill -> draftbill.getDynamicObject("fbasedataid") != null).map(draftbill -> draftbill.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                }
            }
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            long tradeBillId = data.getLong("id");
            String tradeType = data.getString("tradetype");
            String billNoStr = data.getString("billno");
            draftLockInfo.setBillTrade(tradeType);
            draftLockInfo.setSourceBillId(Long.valueOf(tradeBillId));
            draftLockInfo.setSourceBillType(sourceBillTypeStr);
            draftLockInfo.setBizBillNo(billNoStr);
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
            List lockDraftIds = entrys.stream().map(v -> v.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toList());
            HashMap draftIdDealAmountMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbill").getLong("id"), o -> o.getBigDecimal("billamt"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdLogIdMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbill").getLong("id"), o -> o.getLong("billlogid"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdDealAmountMapDB = new HashMap(8);
            HashMap draftIdLogIdMapDB = new HashMap(8);
            DynamicObject tradeBillDB = (DynamicObject)tradeBillIdAndDyMap.get(tradeBillId);
            if (EmptyUtil.isNoEmpty((DynamicObject)tradeBillDB)) {
                DynamicObjectCollection entrysDB = tradeBillDB.getDynamicObjectCollection("entrys");
                List lockDraftIdsDB = entrysDB.stream().map(v -> v.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toList());
                draftIdDealAmountMapDB = entrysDB.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbill").getLong("id"), o -> o.getBigDecimal("billamt"), (o1, o2) -> o1, HashMap::new));
                draftIdLogIdMapDB = entrysDB.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbill").getLong("id"), o -> o.getLong("billlogid"), (o1, o2) -> o1, HashMap::new));
                ArrayList<DraftAmountLockSubInfo> releaseSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
                for (Long lockDraftIdDB : lockDraftIdsDB) {
                    if (lockDraftIds.contains(lockDraftIdDB)) continue;
                    DraftAmountLockSubInfo draftAmountreleaseSubInfo = new DraftAmountLockSubInfo();
                    draftAmountreleaseSubInfo.setBillId(lockDraftIdDB);
                    Long draftLogId = draftIdLogIdMapDB.get(lockDraftIdDB) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMapDB.get(lockDraftIdDB);
                    draftAmountreleaseSubInfo.setBillLogId(draftLogId);
                    BigDecimal dealAmount = draftIdDealAmountMapDB.get(lockDraftIdDB) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMapDB.get(lockDraftIdDB);
                    draftAmountreleaseSubInfo.setDealAmount(dealAmount);
                    draftAmountreleaseSubInfo.setOperateType(OperateTypeEnum.DELETE.getValue());
                    draftAmountreleaseSubInfo.setBillTrade(tradeType);
                    releaseSubInfoList.add(draftAmountreleaseSubInfo);
                }
                draftLockInfo.getLockSubInfoList().addAll(releaseSubInfoList);
            }
            ArrayList<DraftAmountLockSubInfo> lockSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
            for (Long lockDraftId : lockDraftIds) {
                if (isFromCas && casDraftIdList.contains(lockDraftId)) continue;
                DraftAmountLockSubInfo draftAmountLockSubInfo = new DraftAmountLockSubInfo();
                draftAmountLockSubInfo.setBillId(lockDraftId);
                Long billLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                draftAmountLockSubInfo.setBillLogId(billLogId);
                BigDecimal dealAmount = draftIdDealAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(lockDraftId);
                draftAmountLockSubInfo.setDealAmount(dealAmount);
                BigDecimal transAmountDb = (BigDecimal)draftIdDealAmountMapDB.get(lockDraftId);
                boolean isTransAmountEquals = EmptyUtil.isNoEmpty((BigDecimal)transAmountDb) && dealAmount.compareTo(transAmountDb) == 0;
                Long billLogIdDb = (Long)draftIdLogIdMapDB.get(lockDraftId);
                boolean hasBillLogId = EmptyUtil.isNoEmpty((Long)billLogIdDb);
                if (isTransAmountEquals && hasBillLogId) continue;
                draftAmountLockSubInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                draftAmountLockSubInfo.setBillTrade(tradeType);
                lockSubInfoList.add(draftAmountLockSubInfo);
            }
            draftLockInfo.getLockSubInfoList().addAll(lockSubInfoList);
            if (CollectionUtils.isEmpty((Collection)draftLockInfo.getLockSubInfoList())) continue;
            lockAndReleaseInfoList.add(draftLockInfo);
        }
        return lockAndReleaseInfoList;
    }

    private void setBeendorsorBankAndNo(DynamicObject data) {
        String payeeTypeText = data.getString("payeetypetext");
        String tradeType = data.getString("tradetype");
        DynamicObject obj = data.getDynamicObject("beendorsor");
        String bankAcct = data.getString("bankacct");
        if (tradeType.equals(DraftTradeTypeEnum.ENDORSE.getValue()) && !EmptyUtil.isEmpty((DynamicObject)obj) && !EmptyUtil.isEmpty((String)bankAcct)) {
            QFilter accountNumberFilter;
            Object[] accountmaintenances;
            if (payeeTypeText.equals("bd_supplier") || payeeTypeText.equals("bd_customer")) {
                QFilter accountNumberFilter2;
                Object[] accountmaintenances2;
                DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)obj);
                if (internalOrg != null && !EmptyUtil.isEmpty((Object[])(accountmaintenances2 = TmcDataServiceHelper.load((String)"am_accountmaintenance", (String)"id,bank,billbank,billbankname", (QFilter[])new QFilter[]{accountNumberFilter2 = new QFilter("account.bankaccountnumber", "=", (Object)bankAcct)})))) {
                    if (!EmptyUtil.isEmpty((DynamicObject)accountmaintenances2[0].getDynamicObject("billbank"))) {
                        data.set("bank", (Object)accountmaintenances2[0].getDynamicObject("billbank").getDynamicObject("bebank"));
                    }
                    data.set("bankcode", (Object)accountmaintenances2[0].getString("billbankname"));
                    logger.info("TradeBillSaveService tradeType == endorse,accountmaintenances not empty,bebank is \uff1a" + accountmaintenances2[0].getDynamicObject("billbank") + ",billbankname is :" + accountmaintenances2[0].getString("billbankname"));
                }
            } else if (payeeTypeText.equals("bos_org") && !EmptyUtil.isEmpty((Object[])(accountmaintenances = TmcDataServiceHelper.load((String)"am_accountmaintenance", (String)"id,bank,billbank,billbankname", (QFilter[])new QFilter[]{accountNumberFilter = new QFilter("account.bankaccountnumber", "=", (Object)bankAcct)})))) {
                if (!EmptyUtil.isEmpty((DynamicObject)accountmaintenances[0].getDynamicObject("billbank"))) {
                    data.set("bank", (Object)accountmaintenances[0].getDynamicObject("billbank").getDynamicObject("bebank"));
                }
                data.set("bankcode", (Object)accountmaintenances[0].getString("billbankname"));
                logger.info("TradeBillSaveService tradeType == endorse,accountmaintenances not empty,bebank is \uff1a" + accountmaintenances[0].getDynamicObject("billbank") + ",billbankname is :" + accountmaintenances[0].getString("billbankname"));
            }
        }
    }

    private void setPledgeeBankAndNo(DynamicObject data) {
        QFilter accountNumberFilter;
        Object[] accountmaintenances;
        Object[] bankAccts;
        String pledgeeType = data.getString("pledgeetype");
        String tradeType = data.getString("tradetype");
        DynamicObject pledgeeBase = data.getDynamicObject("pledgeebase");
        if (tradeType.equals(DraftTradeTypeEnum.PLEDGE.getValue()) && !EmptyUtil.isEmpty((DynamicObject)pledgeeBase) && pledgeeType.equals("bos_org") && !EmptyUtil.isEmpty((Object[])(bankAccts = TmcDataServiceHelper.load((String)"bd_accountbanks", (String)"bankaccountnumber,bank", (QFilter[])new QFilter[]{new QFilter("company", "in", pledgeeBase.getPkValue())}))) && !EmptyUtil.isEmpty((Object[])(accountmaintenances = TmcDataServiceHelper.load((String)"am_accountmaintenance", (String)"id,bank,billbank,billbankname", (QFilter[])new QFilter[]{accountNumberFilter = new QFilter("account.bankaccountnumber", "=", (Object)bankAccts[0].getString("bankaccountnumber"))})))) {
            if (!EmptyUtil.isEmpty((DynamicObject)accountmaintenances[0].getDynamicObject("billbank"))) {
                Object[] bd_bebankArr;
                DynamicObject bebankDy = accountmaintenances[0].getDynamicObject("billbank").getDynamicObject("bebank");
                data.set("pledgeeopenbank", (Object)bebankDy);
                if (EmptyUtil.isNoEmpty((DynamicObject)bebankDy) && EmptyUtil.isNoEmpty((Object[])(bd_bebankArr = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,number,union_number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bebankDy.getLong("id"))})))) {
                    String union_number = bd_bebankArr[0].getString("union_number");
                    data.set("pledgeeopenbanknumber", (Object)union_number);
                }
            }
            logger.info("TradeBillSaveService tradeType == pledge,accountmaintenances not empty,bebank is \uff1a" + accountmaintenances[0].getDynamicObject("billbank") + ",billbankname is :" + accountmaintenances[0].getString("billbankname"));
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        Map variables = this.getOperationVariable();
        if ("Y".equals(variables.get("fromdraftschedule"))) {
            DynamicObject[] draftArr;
            Map draftId2TradeBillMap = TradeBillHelper.getDraftId2TradeBillMap((DynamicObject[])dataEntities);
            for (DynamicObject draft : draftArr = TradeBillHelper.getDraftArrByTradeBillArr((DynamicObject[])dataEntities)) {
                String recBodyName;
                DynamicObject tradeBill = (DynamicObject)draftId2TradeBillMap.get(draft.getPkValue());
                String tradeType = tradeBill.getString("tradetype");
                String draftStatus = DraftBillStatusEnum.getValue((String)tradeType);
                draft.set("draftbillstatus", (Object)draftStatus);
                String beendorsor = tradeBill.getString("beendorsortext");
                if (!EmptyUtil.isEmpty((String)beendorsor)) {
                    draft.set("beendorsor", (Object)beendorsor);
                }
                if (EmptyUtil.isNotBlank((CharSequence)(recBodyName = tradeBill.getString("recbodyname")))) {
                    draft.set("recbody", (Object)recBodyName);
                }
                draft.set("use", tradeBill.get("description"));
            }
            TmcDataServiceHelper.save((DynamicObject[])draftArr);
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        for (DynamicObject data : dataEntities) {
            boolean isNeedCallPay;
            String src = data.getString("source");
            Set draftBillSet = data.getDynamicObjectCollection("entrys").stream().map(e -> e.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet());
            String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
            boolean isSucWriteBack = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)data.getLong("company.id"), (String)"issucwriteback");
            String sourcePayBillId = DraftHelper.checkReleatedByPayBillSelectEndorseBill((DynamicObject)data);
            boolean bl = isNeedCallPay = !EmptyUtil.isEmpty((String)data.getString("sourcebillid")) && "cas".equals(src);
            if (!isNeedCallPay && !EmptyUtil.isNoEmpty((String)sourcePayBillId)) continue;
            String sourcebillid = data.getString("sourcebillid");
            if (!isNeedCallPay && EmptyUtil.isNoEmpty((String)sourcePayBillId)) {
                sourcebillid = sourcePayBillId;
            }
            logger.info("sourcebillid is:" + sourcebillid + ",sourcePayBillId :" + sourcePayBillId);
            if (!isSucWriteBack) {
                this.genPurPay(sourcebillid, data.getString("id"), data.getDate("bizdate"));
            } else {
                CasWriteBackHelper.writePayStatus((String)sourcebillid, (String)PayBillStatusEnum.DRAFTING.getValue());
            }
            long sourCasBillId = Long.parseLong(sourcebillid);
            Set payBillDatas = DraftHelper.getPayBillDatas(draftBillSet, (long)sourCasBillId, (boolean)true, (boolean)false);
            Set needUpdatePayBillDySet = DraftHelper.updateDratBillCasEntry((Set)payBillDatas, (String)"cas_paybill", (String)"add", (Long)sourCasBillId);
            if (!EmptyUtil.isNoEmpty((Object)needUpdatePayBillDySet)) continue;
            SaveServiceHelper.save((DynamicObject[])needUpdatePayBillDySet.toArray(new DynamicObject[0]));
        }
    }

    public void genPurPay(String sourceBillId, String draftbillno, Date bizOverDate) {
        logger.info("genPurPay is sourceBillId:" + sourceBillId + ",draftbillno:" + draftbillno + ",bizOverDate:" + bizOverDate);
        try (TXHandle tx = TX.requiresNew();){
            DynamicObject[] payBills = TmcDataServiceHelper.load((String)"cas_paybill", (String)"id,billstatus,billno,bizdate,draftbill,draftbill.fbasedataid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(sourceBillId))});
            if (payBills.length > 0) {
                ArrayList<Long> ids = new ArrayList<Long>(payBills.length);
                for (DynamicObject payBill : payBills) {
                    if (BillStatusEnum.PAYED.getValue().equals(payBill.getString("billstatus"))) continue;
                    ids.add(payBill.getLong("id"));
                }
                if (ids.size() > 0) {
                    logger.info("genPurPay is start to call pay:");
                    OperateOption create = OperateOption.create();
                    create.setVariableValue("draftbillno", draftbillno);
                    create.setVariableValue("endorse", draftbillno);
                    create.setVariableValue("fromdraw", "y");
                    create.setVariableValue("bizFinishDate", DateUtils.formatString((Date)bizOverDate, (String)"yyyy-MM-dd"));
                    TmcOperateServiceHelper.execOperate((String)"pay", (String)"cas_paybill", (Object[])ids.toArray(), (OperateOption)create);
                }
            }
        }
    }
}

