/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.tradebill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.ebservice.draftbill.impl.ElcManagerImpl;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.helper.TradeBillChangeHelper;
import kd.tmc.cdm.common.helper.TradeBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.NoteResult;

public class TradeBillSubmitEleService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(TradeBillSubmitEleService.class);
    private List<String> successLockDraftIdList = new ArrayList<String>(8);
    public static final String BILLTYPE = "draw";

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("draftbilltranstatus");
        selector.add("electag");
        selector.add("entrys");
        selector.add("billno");
        selector.add("tradetype");
        selector.add("electag");
        selector.add("draftbilltranstatus");
        selector.add("beendorsortext");
        selector.add("beendorsor");
        selector.add("transtatus");
        selector.add("bizdate");
        selector.add("beendorsortext");
        selector.add("beendorsor");
        selector.add("bankacct");
        selector.add("bankcode");
        selector.add("bank");
        selector.add("rate");
        selector.add("discount_days");
        selector.add("interestday");
        selector.add("pledgeetype");
        selector.add("pledgeeaccounttext");
        selector.add("pledgeeaccount");
        selector.add("pledgeeopenbank");
        selector.add("pledgeeopenbanknumber");
        selector.add("pledgeenddate");
        selector.add("pledgeetypebase");
        selector.add("pledgeetype");
        selector.add("pledgeetext");
        selector.add("pledgeebase");
        selector.add("description");
        selector.add("busicontractno");
        selector.add("remarks");
        selector.add("ispaybyagree");
        selector.add("agreerate");
        selector.add("isonlinecalc");
        selector.add("billamt");
        selector.add("currency");
        selector.add("draftbill");
        selector.add("isneedsplit");
        selector.add("isrepaygen");
        selector.add("billlogid");
        selector.add("discountentry");
        selector.add("recbody");
        selector.add("bankaccount");
        selector.add("recbodyname");
        selector.add("dis_selectbillid");
        selector.add("discountentry.dis_interest");
        selector.add("discountentry.dis_owninterest_bank");
        selector.add("discountentry.dis_discamt");
        selector.add("discountentry.invctype");
        selector.add("discountentry.invcno");
        selector.add("discountentry.invccode");
        selector.add("discountentry.invcchkno");
        selector.add("discountentry.invcamt");
        selector.add("discountentry.invcdate");
        selector.add("discountentry.dis_roughlyinterest");
        selector.add("discount_interest");
        selector.add("owndiscountinterest");
        selector.add("entrys.transtatus");
        selector.add("settleway");
        selector.add("cleartype");
        selector.add("discamt");
        selector.add("payeetypetext");
        selector.add("oppaccname");
        selector.add("roughly_interest");
        selector.add("e_bankmsg");
        return selector;
    }

    public TradeBillSubmitEleService(List<String> lockDraftIdList) {
        this.successLockDraftIdList = lockDraftIdList;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        logger.info("TradeBillSubmitEleService.process dataEntities billNos that:" + Arrays.toString(Arrays.stream(dataEntities).map(o -> o.getString("billno")).toArray()));
        for (DynamicObject data : dataEntities) {
            LockDraftHelper.reCallAddLog(data);
            DynamicObject[] receivableBillArr = TradeBillHelper.getDraftArrByTradeBillArr2((DynamicObject[])new DynamicObject[]{data});
            Map<Object, DynamicObject> billIdToBillDyMap = data.getDynamicObjectCollection("entrys").stream().collect(Collectors.toMap(e -> e.getDynamicObject("draftbill").getPkValue(), dy -> dy, (m1, m2) -> m1));
            for (DynamicObject receivableBill : receivableBillArr) {
                DynamicObject entry = billIdToBillDyMap.get(receivableBill.getPkValue());
                if (EmptyUtil.isNoEmpty((DynamicObject)entry) && TradeBillChangeHelper.notSubmitEleBill((DynamicObject)entry)) continue;
                receivableBill.set("draftbilltranstatus", (Object)DraftTranStatusEnum.HANDLEING.getValue());
                receivableBill.set("electag", (Object)"1");
            }
            logger.info("TradeBillSubmitEleService.process receivableBillArr length:" + receivableBillArr.length);
            SaveServiceHelper.save((DynamicObject[])receivableBillArr);
            Object[] electBillIds = Arrays.stream(receivableBillArr).filter(e -> !ObjectUtils.isEmpty((Object)e.get("sourcebillid")) && e.getLong("sourcebillid") > 0L).map(e -> e.getLong("sourcebillid")).toArray();
            if (electBillIds.length > 0) {
                DynamicObject[] electBillArray;
                for (DynamicObject dynamicObject : electBillArray = TmcDataServiceHelper.load((Object[])electBillIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronic_rec_deal"))) {
                    dynamicObject.set("backflag", (Object)"0");
                }
                SaveServiceHelper.save((DynamicObject[])electBillArray);
                logger.info("TradeBillSubmitEleService.process clean empty electBillIds:" + Arrays.toString(Arrays.stream(electBillArray).map(DataEntityBase::getPkValue).toArray()));
            }
            data.set("draftbilltranstatus", (Object)DraftTranStatusEnum.HANDLEING.getValue());
            data.set("electag", (Object)"1");
            DynamicObjectCollection entryList = data.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entryList) {
                boolean isRemainBill;
                if (TradeBillChangeHelper.notSubmitEleBill((DynamicObject)entry)) continue;
                entry.set("transtatus", (Object)DraftTranStatusEnum.HANDLEING.getValue());
                DynamicObject[] draftArr = TradeBillHelper.getDraftArrByTradeBillArr((DynamicObject[])new DynamicObject[]{data});
                Map<Long, DynamicObject> idAndbillMap = Arrays.stream(draftArr).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
                DynamicObject draft = entry.getDynamicObject("draftbill");
                long draftBillId = draft.getLong("id");
                DynamicObject newDraft = idAndbillMap.get(draftBillId);
                BigDecimal usedAmount = newDraft.getBigDecimal("usedamount");
                BigDecimal originalsubbillamount = newDraft.getBigDecimal("originalsubbillamount");
                BigDecimal billamt = entry.getBigDecimal("billamt");
                boolean bl = isRemainBill = originalsubbillamount.compareTo(billamt.add(usedAmount)) == 0;
                if (isRemainBill) {
                    entry.set("isneedsplit", (Object)false);
                    continue;
                }
                entry.set("isneedsplit", (Object)true);
            }
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        logger.info("\u63d0\u4ea4\u7535\u7968afterProcess\u6267\u884c\u3002");
        super.afterProcess(dataEntities);
        ArrayList rollbackNotes = new ArrayList(4);
        for (DynamicObject data : dataEntities) {
            DynamicObjectCollection dynamicObjects = data.getDynamicObjectCollection("entrys");
            try {
                ElcManagerImpl elcManager = new ElcManagerImpl();
                List noteResults = elcManager.draftTradeBillToEleRecBill(data);
                List rollbackList = noteResults.stream().filter(o -> !o.getStatusCode().name().equals("SUCCESS")).collect(Collectors.toList());
                if (dynamicObjects.size() == rollbackList.size()) {
                    TradeBillSubmitEleService.rollbackHead(data);
                    this.operationResult.setSuccessPkIds(Collections.emptyList());
                    this.operationResult.setSuccess(false);
                    ArrayList<OperateErrorInfo> operateErrorInfoList = new ArrayList<OperateErrorInfo>(rollbackList.size());
                    for (NoteResult noteResult : rollbackList) {
                        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                        operateErrorInfo.setLevel(ErrorLevel.Error);
                        operateErrorInfo.setMessage(noteResult.getBillId() + ":" + noteResult.getErrMsg());
                        operateErrorInfoList.add(operateErrorInfo);
                    }
                    this.operationResult.setAllErrorInfo(operateErrorInfoList);
                }
                rollbackNotes.addAll(rollbackList);
            }
            catch (Exception e) {
                TradeBillSubmitEleService.rollbackHead(data);
                Object[] pkValues = dynamicObjects.stream().map(o -> o.getDynamicObject("draftbill").getPkValue()).toArray();
                TradeBillSubmitEleService.rollbackEntity(pkValues);
                logger.error("TradeBillSubmitEleService.afterProcess exception ", (Throwable)e);
                throw new KDException((Throwable)e, new ErrorCode("TradeBillSubmitEleServiceException", ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u3010\u63d0\u4ea4\u7535\u7968\u3011\u65f6\uff0c\u6570\u636e\u5904\u7406\u5f02\u5e38\u3002", (String)"TradeBillSubmitEleService_2", (String)"tmc-cdm-business", (Object[])new Object[0])), new Object[0]);
            }
        }
        QFilter qFilter = new QFilter("id", "in", rollbackNotes.stream().map(NoteResult::getBillId).collect(Collectors.toList()));
        DynamicObject[] electBills = TmcDataServiceHelper.load((String)"cdm_electronicbill", (String)"id,sourceid", (QFilter[])new QFilter[]{qFilter});
        Object[] draftBillIds = Arrays.stream(electBills).filter(o -> !ObjectUtils.isEmpty((Object)o.get("sourceid"))).map(o -> o.get("sourceid")).toArray();
        if (draftBillIds.length > 0) {
            TradeBillSubmitEleService.rollbackEntity(draftBillIds);
        }
        logger.info("\u63d0\u4ea4\u7535\u7968afterProcess\u6267\u884c\u5b8c\u6210\u3002");
    }

    private static void rollbackHead(DynamicObject data) {
        if (ObjectUtils.isEmpty((Object)data)) {
            return;
        }
        data.set("draftbilltranstatus", (Object)"");
        data.set("electag", (Object)"0");
        DynamicObjectCollection entryList = data.getDynamicObjectCollection("entrys");
        for (DynamicObject entry : entryList) {
            entry.set("transtatus", (Object)"");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
    }

    private static void rollbackEntity(Object[] recPkValues) {
        DynamicObject[] draftArr;
        if (ArrayUtils.isEmpty((Object[])recPkValues)) {
            return;
        }
        for (DynamicObject dynamicObject : draftArr = TmcDataServiceHelper.load((Object[])recPkValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"))) {
            dynamicObject.set("draftbilltranstatus", (Object)"");
            dynamicObject.set("ebstatus", (Object)"");
            dynamicObject.set("electag", (Object)"0");
        }
        SaveServiceHelper.save((DynamicObject[])draftArr);
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        logger.info("TradeBillSubmitEleService onReturnOperation start");
        if (EmptyUtil.isEmpty(this.successLockDraftIdList)) {
            logger.info("TradeBillSubmitEleService successLockDraftIdList is null");
            return;
        }
        try {
            logger.info("release lock\uff1a" + JSON.toJSONString(this.successLockDraftIdList));
            Map releaseResultMap = MutexServiceHelper.batchRelease(this.successLockDraftIdList, (String)"tmc-cdm-business", (String)BILLTYPE);
            logger.info("releaseResultMap is:", (Object)SerializationUtils.toJsonString((Object)releaseResultMap));
        }
        catch (Exception e1) {
            logger.error("release lock error is:", (Throwable)e1);
            throw new KDBizException(ResManager.loadKDString((String)"\u91ca\u653e\u4e92\u65a5\u9501\u5931\u8d25", (String)"ReceivErrorCode_31", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        finally {
            this.successLockDraftIdList.clear();
        }
    }
}

