/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.BillPoolTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.fbp.common.builder.FormulaGetHandle;
import kd.tmc.fbp.common.builder.ISingleTaskContext;
import kd.tmc.fbp.common.builder.SingleTaskContext;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class IntoPoolHelper {
    private static final Set<String> propSet = new HashSet<String>(16);
    private static final Log logger;

    public static void autoIntoPool(List<Long> receivableBillIds) {
        IntoPoolHelper.autoIntoPool(receivableBillIds, false);
    }

    public static void autoIntoPool(List<Long> receivableBillIds, Boolean isMustInto) {
        if (receivableBillIds == null || receivableBillIds.size() < 1) {
            logger.info("\u5c06\u5e94\u6536\u7968\u636e\u6839\u636e\u5165\u6c60\u89c4\u5219\u81ea\u52a8\u5165\u6c60\u5165\u53c2\u4e0d\u5408\u6cd5\uff0c\u505c\u6b62\u6267\u884c");
            return;
        }
        DynamicObject[] receivableBills = BusinessDataServiceHelper.load((Object[])receivableBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill"));
        if (receivableBills == null || receivableBills.length < 1) {
            logger.info("\u5c06\u5e94\u6536\u7968\u636e\u6839\u636e\u5165\u6c60\u89c4\u5219\u81ea\u52a8\u5165\u6c60\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\uff0c\u505c\u6b62\u6267\u884c");
            return;
        }
        if ((receivableBills = (DynamicObject[])Arrays.stream(receivableBills).filter(receivableBill -> {
            String settlementType = receivableBill.getDynamicObject("draftbilltype").getString("settlementtype");
            if (!Objects.equals(settlementType, SettleMentTypeEnum.BANK.getValue()) && !Objects.equals(settlementType, SettleMentTypeEnum.BUSINESS.getValue())) {
                logger.info(String.format("\u5355\u636e\u7f16\u53f7\u3010%s\u3011\u4e2d\u7968\u636e\u7c7b\u578b\u7684\u7c7b\u522b\u4e3a\u3010%s\u3011\u4e0d\u652f\u6301\u81ea\u52a8\u5165\u6c60", receivableBill.getString("billno"), SettleMentTypeEnum.getName((String)settlementType)));
                return false;
            }
            return true;
        }).toArray(DynamicObject[]::new)).length < 1) {
            return;
        }
        logger.info("IntoPoolHelper autoIntoPool loadIntoPoolRulesByPoolType start");
        DynamicObject[] innerIntoPoolRules = IntoPoolHelper.loadIntoPoolRulesByPoolType(BillPoolTypeEnum.INNER);
        DynamicObject[] bankIntoPoolRules = IntoPoolHelper.loadIntoPoolRulesByPoolType(BillPoolTypeEnum.BANK);
        logger.info("IntoPoolHelper autoIntoPool loadIntoPoolRulesByPoolType end");
        ArrayList<String> errMsg = new ArrayList<String>(0);
        for (DynamicObject receivableBill2 : receivableBills) {
            try {
                logger.info("IntoPoolHelper autoIntoPool filterInnerRules start,billNo = {}", (Object)receivableBill2.getString("draftbillno"));
                Object companyPkValue = receivableBill2.getDynamicObject("company").getPkValue();
                List<DynamicObject> innerBillPoolIntoPoolRules = IntoPoolHelper.filterInnerRules(innerIntoPoolRules, companyPkValue);
                logger.info("IntoPoolHelper autoIntoPool filterInnerRules end,billNo = {}", (Object)receivableBill2.getString("draftbillno"));
                if (!CollectionUtils.isEmpty(innerBillPoolIntoPoolRules)) {
                    DynamicObject innerBillPoolIntoPoolRule = innerBillPoolIntoPoolRules.get(0);
                    logger.info("IntoPoolHelper autoIntoPool filterInnerRules innerBillPoolIntoPoolRule = {}", (Object)innerBillPoolIntoPoolRule.getLong("id"));
                    DynamicObjectCollection rules = innerBillPoolIntoPoolRule.getDynamicObjectCollection("entryentity_ruleitem");
                    if (IntoPoolHelper.isAllMatch(rules, receivableBill2)) {
                        IntoPoolHelper.intoBillPool(innerBillPoolIntoPoolRule, receivableBill2);
                        continue;
                    }
                    if (isMustInto.booleanValue()) {
                        IntoPoolHelper.intoBillPool(receivableBill2);
                        continue;
                    }
                    IntoPoolHelper.bankBillPoolIntoBillPool(bankIntoPoolRules, receivableBill2, companyPkValue);
                    continue;
                }
                if (isMustInto.booleanValue()) {
                    logger.info("IntoPoolHelper autoIntoPool filterInnerRules innerBillPoolIntoPoolRules");
                    IntoPoolHelper.intoBillPool(receivableBill2);
                    continue;
                }
                IntoPoolHelper.bankBillPoolIntoBillPool(bankIntoPoolRules, receivableBill2, companyPkValue);
            }
            catch (Exception e) {
                logger.error("in pool has exception:", (Throwable)e);
                errMsg.add(String.join((CharSequence)receivableBill2.getString("billno"), e.toString()));
            }
        }
        if (errMsg.size() > 0) {
            throw new KDBizException(((Object)errMsg).toString());
        }
    }

    private static void bankBillPoolIntoBillPool(DynamicObject[] bankIntoPoolRules, DynamicObject receivableBill, Object companyPkValue) {
        List<DynamicObject> bankBillPoolIntoPoolRules;
        DynamicObject bankAccount;
        DynamicObject beBank;
        logger.info("IntoPoolHelper autoIntoPool filterInnerRules bankBillPoolIntoBillPool is start");
        if (bankIntoPoolRules.length > 0 && Objects.nonNull(beBank = IntoPoolHelper.getBeBank(bankAccount = receivableBill.getDynamicObject("bankaccount"))) && !(bankBillPoolIntoPoolRules = IntoPoolHelper.filterBankRules(bankIntoPoolRules, companyPkValue, beBank)).isEmpty()) {
            DynamicObject bankBillPoolIntoPoolRule = bankBillPoolIntoPoolRules.get(0);
            logger.info("IntoPoolHelper autoIntoPool filterInnerRules bankBillPoolIntoPoolRules id = {}", (Object)bankBillPoolIntoPoolRule.getLong("id"));
            DynamicObjectCollection rules = bankBillPoolIntoPoolRule.getDynamicObjectCollection("entryentity_ruleitem");
            if (IntoPoolHelper.isAllMatch(rules, receivableBill)) {
                IntoPoolHelper.intoBillPool(bankBillPoolIntoPoolRule, receivableBill);
            }
        }
    }

    private static List<DynamicObject> filterBankRules(DynamicObject[] bankIntoPoolRules, Object companyPkValue, DynamicObject beBank) {
        ArrayList<DynamicObject> bankPoolRules = new ArrayList<DynamicObject>(8);
        for (DynamicObject bankIntoPoolRule : bankIntoPoolRules) {
            DynamicObject pool = bankIntoPoolRule.getDynamicObject("pool");
            HashSet<Object> poolOrgIdSet = new HashSet<Object>(8);
            boolean isSameType = Objects.equals(pool.get("type"), BillPoolTypeEnum.BANK.getValue());
            DynamicObject poolBankDy = pool.getDynamicObject("bank");
            boolean isSameBank = Objects.equals(poolBankDy.getPkValue(), beBank.getPkValue());
            if (!isSameType || !isSameBank) continue;
            Object createPoolId = pool.getDynamicObject("company").getPkValue();
            poolOrgIdSet.add(createPoolId);
            Set memberOrgIdSet = pool.getDynamicObjectCollection("entryentity").stream().map(company -> company.getDynamicObject("e_company").getPkValue()).collect(Collectors.toSet());
            if (EmptyUtil.isNoEmpty(memberOrgIdSet)) {
                poolOrgIdSet.addAll(memberOrgIdSet);
            }
            if (!poolOrgIdSet.contains(companyPkValue)) continue;
            bankPoolRules.add(bankIntoPoolRule);
        }
        return bankPoolRules;
    }

    private static DynamicObject getBeBank(DynamicObject bankAccount) {
        DynamicObject openBank;
        if (Objects.nonNull(bankAccount) && Objects.nonNull(openBank = bankAccount.getDynamicObject("bank"))) {
            DynamicObject openBankFromDB = BusinessDataServiceHelper.loadSingle((Object)openBank.getPkValue(), (String)"bd_finorginfo", (String)"bebank");
            return openBankFromDB.getDynamicObject("bebank");
        }
        return null;
    }

    private static void intoBillPool(DynamicObject receivableBill) {
        DynamicObject pool = BusinessDataServiceHelper.loadSingle((String)"cdm_billpool", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1").and(new QFilter("company", "=", receivableBill.getDynamicObject("company").getPkValue()).or(new QFilter("entryentity.e_company", "=", receivableBill.getDynamicObject("company").getPkValue())))});
        if (pool != null && pool.getLong("id") != 0L) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("billpool", pool.getString("id"));
            TmcOperateServiceHelper.execOperate((String)"pushjoin", (String)"cdm_receivablebill", (Object[])new Object[]{receivableBill.getPkValue()}, (OperateOption)operateOption);
        }
    }

    private static void intoBillPool(DynamicObject innerBillPoolIntoPoolRule, DynamicObject receivableBill) {
        logger.info("IntoPoolHelper autoIntoPool intoBillPool start,billNo = {}", (Object)receivableBill.getString("draftbillno"));
        DynamicObject pool = innerBillPoolIntoPoolRule.getDynamicObject("pool");
        if (pool != null && pool.getLong("id") != 0L) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("billpool", pool.getString("id"));
            TmcOperateServiceHelper.execOperate((String)"pushjoin", (String)"cdm_receivablebill", (Object[])new Object[]{receivableBill.getPkValue()}, (OperateOption)operateOption);
            logger.info("IntoPoolHelper autoIntoPool intoBillPool end,billNo = {}", (Object)receivableBill.getString("draftbillno"));
        } else {
            logger.info("IntoPoolHelper autoIntoPool pool is null");
        }
    }

    private static List<DynamicObject> filterInnerRules(DynamicObject[] innerIntoPoolRules, Object companyPkValue) {
        ArrayList<DynamicObject> innerRules = new ArrayList<DynamicObject>(8);
        for (DynamicObject innerIntoPoolRule : innerIntoPoolRules) {
            DynamicObject pool = innerIntoPoolRule.getDynamicObject("pool");
            HashSet<Object> poolOrgIdSet = new HashSet<Object>(8);
            Object createPoolId = pool.getDynamicObject("company").getPkValue();
            poolOrgIdSet.add(createPoolId);
            Set memberOrgIdSet = pool.getDynamicObjectCollection("entryentity").stream().map(company -> company.getDynamicObject("e_company").getPkValue()).collect(Collectors.toSet());
            if (EmptyUtil.isNoEmpty(memberOrgIdSet)) {
                poolOrgIdSet.addAll(memberOrgIdSet);
            }
            if (!poolOrgIdSet.contains(companyPkValue)) continue;
            innerRules.add(innerIntoPoolRule);
        }
        return innerRules;
    }

    private static DynamicObject[] loadIntoPoolRulesByPoolType(BillPoolTypeEnum billPoolTypeEnum) {
        return BusinessDataServiceHelper.load((String)"cdm_intopoolrule", (String)String.join((CharSequence)",", "e_ruleitemname", "e_applicablecondition", "pool", "e_datafilter_tag", "u_companyid"), (QFilter[])IntoPoolHelper.getQFilters(billPoolTypeEnum));
    }

    private static QFilter[] getQFilters(BillPoolTypeEnum billPoolTypeEnum) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
        QFilter typeFilter = new QFilter("pool.type", "=", (Object)billPoolTypeEnum.getValue());
        return enableFilter.and(typeFilter).toArray();
    }

    private static boolean isAllMatch(DynamicObjectCollection rules, DynamicObject receivableBill) {
        logger.info("IntoPoolHelper autoIntoPool isAllMatch start,billNo = {}", (Object)receivableBill.getString("draftbillno"));
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>(10);
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", receivableBill.getPkValue())};
        DynamicObjectCollection fieldByRules = IntoPoolHelper.getFieldByRules(rules, fldProperties, qFilters);
        logger.info("IntoPoolHelper autoIntoPool isAllMatch getFieldByRules,billNo = {}", (Object)receivableBill.getString("draftbillno"));
        if (CollectionUtils.isEmpty((Collection)fieldByRules)) {
            return true;
        }
        for (DynamicObject intoPoolRule : rules) {
            String filterStr = intoPoolRule.getString("e_datafilter_tag");
            if (IntoPoolHelper.isMatch(filterStr, fldProperties, (DynamicObject)fieldByRules.get(0))) continue;
            return false;
        }
        logger.info("IntoPoolHelper autoIntoPool isAllMatch end,billNo = {}", (Object)receivableBill.getString("draftbillno"));
        return true;
    }

    private static boolean isMatch(String filterStr, Map<String, DynamicProperty> fldProperties, DynamicObject receivableBill) {
        MainEntityType mainEntityType;
        CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
        String baseFilterStr = filterObj.buildFullFormula(mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cdm_receivablebill"));
        if (EmptyUtil.isNotEmpty((CharSequence)baseFilterStr)) {
            try {
                SingleTaskContext taskContext = new SingleTaskContext();
                taskContext.setSrcEntityType(mainEntityType);
                FormulaGetHandle baseBillFilterHandle = new FormulaGetHandle((ISingleTaskContext)taskContext, baseFilterStr, (Object)Boolean.FALSE);
                return (Boolean)baseBillFilterHandle.GetVchFldValue(fldProperties, receivableBill, null);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw e;
            }
        }
        return false;
    }

    private static DynamicObjectCollection getFieldByRules(DynamicObjectCollection rules, Map<String, DynamicProperty> fldProperties, QFilter[] qFilters) {
        HashSet<Object> fieldByRules = new HashSet<Object>();
        for (DynamicObject rule : rules) {
            String expression;
            String dataFilter = rule.getString("e_datafilter_tag");
            CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)dataFilter, CRCondition.class);
            FilterCondition filterCondition = crCondition.getFilterCondition();
            List filterRowList = filterCondition.getFilterRow();
            if (EmptyUtil.isNoEmpty((Object)filterRowList)) {
                Set fields = filterRowList.stream().map(SimpleFilterRow::getFieldName).collect(Collectors.toSet());
                logger.info("--- fields from simpleFilterRow:", fields.toArray());
                fieldByRules.addAll(fields);
            }
            if (!EmptyUtil.isNotEmpty((CharSequence)(expression = crCondition.getExpression()))) continue;
            Set<String> fields = IntoPoolHelper.getFiledFromExpression(expression);
            logger.info("--- fields from expression:", fields.toArray());
            fieldByRules.addAll(fields);
        }
        DynamicObjectCollection rows = new DynamicObjectCollection();
        if (EmptyUtil.isNoEmpty(fieldByRules)) {
            logger.info("--- fieldByRules=", fieldByRules.toArray());
            String selectProps = fieldByRules.parallelStream().filter(s -> !"feedetail".equals(s)).collect(Collectors.joining(","));
            logger.info("--- intopool query,selectProps=", (Object)selectProps);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)IntoPoolHelper.class.getName(), (String)"cdm_receivablebill", (String)selectProps, (QFilter[])qFilters, null);){
                rows = ORM.create().toPlainDynamicObjectCollection(dataSet);
            }
        }
        Optional.ofNullable(rows).filter(o -> !o.isEmpty()).ifPresent(doc -> {
            DynamicObjectType dType = doc.getDynamicObjectType();
            fieldByRules.forEach(elem -> fldProperties.put((String)elem, dType.getProperty(elem)));
            doc.forEach(o -> o.getDynamicObjectType().setName("cdm_receivablebill"));
        });
        return rows;
    }

    private static Set<String> getFiledFromExpression(String expression) {
        HashSet<String> filedSet = new HashSet<String>();
        for (String prop : propSet) {
            if (!expression.contains(prop)) continue;
            filedSet.add(prop);
        }
        return filedSet;
    }

    public static void seekProperties(Set<String> propSets, String propName, DataEntityPropertyCollection properties) {
        for (IDataEntityProperty property : properties) {
            String tempPropName;
            if (StringUtils.isBlank((CharSequence)property.getAlias()) || property.getName().contains("_id") || property.getName().contains("feedetail")) continue;
            String string = tempPropName = StringUtils.isBlank((CharSequence)propName) ? property.getName() : String.format("%s.%s", propName, property.getName()).trim();
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                DataEntityPropertyCollection bdProperties = bdProp.getComplexType().getProperties();
                IntoPoolHelper.seekProperties(propSets, tempPropName, bdProperties);
                continue;
            }
            propSets.add(tempPropName);
        }
    }

    static {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cdm_receivablebill");
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        IntoPoolHelper.seekProperties(propSet, "", properties);
        logger = LogFactory.getLog(IntoPoolHelper.class);
    }
}

