/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.service;

import com.alibaba.fastjson.JSON;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.cdm.business.lock.DraftLockServiceFactory;
import kd.tmc.cdm.business.lock.DraftOperateInfo;
import kd.tmc.cdm.business.lock.DraftOperateSubInfo;
import kd.tmc.cdm.business.lock.IDraftLockService;
import kd.tmc.cdm.business.service.DraftAmountLockSubInfo;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockResult;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.enums.LogBizStatusEnum;
import kd.tmc.cdm.common.enums.OperateTypeEnum;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class LockDraftHelper {
    private static Log logger = LogFactory.getLog(LockDraftHelper.class);
    private static final String SQL_UPDATE_AMOUNT = "update t_cdm_draftbill set flockedamount = flockedamount + ? , favailableamount = favailableamount - ? where fid = ? and favailableamount >= 0 and favailableamount = ? and flockedamount = ? and favailableamount >= ?";
    private static final String SQL_FINISH_UPDATE_AMOUNT = "update t_cdm_draftbill set flockedamount = flockedamount - ? , favailableamount = favailableamount + ? , fusedamount = fusedamount + ? , famount = famount - ? , fsubbillrange = ? , fsubbillquantity = ? , fsubbillstartflag = ? where fid = ? and fusedamount = ? and famount >= 0 and famount = ? and flockedamount >= ?";
    private static final String SQL_CANCEL_UPDATE_AMOUNT = "update t_cdm_draftbill set  flockedamount = flockedamount + ? , favailableamount = favailableamount - ? , fusedamount = fusedamount - ? , famount = famount + ? , fsubbillrange = ? , fsubbillquantity = ? , fsubbillstartflag = ? where fid = ? and fusedamount = ? and fusedamount >= 0 and famount = ? and favailableamount >= ?";
    private static final String SQL_DELETE_UPDATE_AMOUNT = "update t_cdm_draftbill set flockedamount = flockedamount - ? , favailableamount = favailableamount + ? where fid = ? and flockedamount = ? and favailableamount = ? and flockedamount >= ? ";
    private static final List<String> specialTradeType = Arrays.asList(DraftTradeTypeEnum.REFUND.getValue(), DraftTradeTypeEnum.RLSPLEDGE.getValue(), DraftTradeTypeEnum.PAYINTEREST.getValue(), DraftTradeTypeEnum.RETRIEVE.getValue());
    private static final List<String> splitTradeType = Arrays.asList(DraftTradeTypeEnum.PLEDGE.getValue(), DraftTradeTypeEnum.ENDORSE.getValue(), DraftTradeTypeEnum.DISCOUNT.getValue(), DraftTradeTypeEnum.BILLSPLIT.getValue());
    private static final List<String> noSupportPartTransferTradeType = Arrays.asList(DraftTradeTypeEnum.TRUSTEESHIP.getValue(), DraftTradeTypeEnum.RETRIEVE.getValue(), DraftTradeTypeEnum.COLLECT.getValue(), DraftTradeTypeEnum.RLSPLEDGE.getValue());
    private static final String FINISH = "finish";
    private static final String CANCEL = "cancel";
    private static final String DELETE = "delete";
    private static final String COMPLETE = "complete";
    private static final String CANCELCOMPLETE = "cancelcomplete";
    private static final String ROLLBACKDELETE = "rollbackdelete";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseOrLockDrafts(List<DraftLockInfo> draftLockInfos) {
        logger.info("releaseOrLockDrafts is start" + JSON.toJSONString(draftLockInfos));
        ArrayList lockDraftIds = new ArrayList(10);
        ArrayList releaseDraftIds = new ArrayList(10);
        HashMap lockInfoMap = new HashMap(16);
        HashMap releaseInfoMap = new HashMap(16);
        IDraftLockService service = DraftLockServiceFactory.getService();
        for (DraftLockInfo draftLockInfo : draftLockInfos) {
            List releaseBillIdList;
            List lockBillIdList = draftLockInfo.getLockBillIdList();
            if (!CollectionUtils.isEmpty((Collection)lockBillIdList)) {
                lockDraftIds.addAll(lockBillIdList);
                lockBillIdList.stream().forEach(v -> lockInfoMap.put(v, draftLockInfo));
            }
            if (CollectionUtils.isEmpty((Collection)(releaseBillIdList = draftLockInfo.getReleaseBillIdList()))) continue;
            releaseDraftIds.addAll(releaseBillIdList);
            releaseBillIdList.stream().forEach(v -> releaseInfoMap.put(v, draftLockInfo));
        }
        logger.info("releaseOrLockDrafts lockDraftIds size is:" + lockDraftIds.size() + ",releaseDraftIds size is:" + releaseDraftIds.size());
        ArrayList sumDraftIds = new ArrayList(10);
        sumDraftIds.addAll(lockDraftIds);
        sumDraftIds.addAll(releaseDraftIds);
        if (!CollectionUtils.isEmpty(sumDraftIds)) {
            List idList = sumDraftIds.stream().map(a -> String.valueOf(a)).collect(Collectors.toList());
            Map request = MutexServiceHelper.batchRequestWithLostTime(idList, (String)"cdm_draftbillf7", (String)"releaseOrLockDrafts");
            try {
                if (request.containsValue(Boolean.FALSE)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7968\u636e\u5df2\u88ab\u5176\u4ed6\u64cd\u4f5c\u9501\u5b9a", (String)"releaseOrLockDrafts_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isNoEmpty(lockDraftIds)) {
                    service.lock(draftLockInfos, true);
                }
                if (EmptyUtil.isNoEmpty(releaseDraftIds)) {
                    // empty if block
                }
            }
            finally {
                MutexServiceHelper.batchRelease(idList, (String)"cdm_draftbillf7", (String)"releaseOrLockDrafts");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changeLockInfo(List<DraftLockInfo> draftLockInfos) {
        logger.info("changeLockInfo is start" + JSON.toJSONString(draftLockInfos));
        ArrayList draftIds = new ArrayList(10);
        draftLockInfos.stream().forEach(p -> draftIds.addAll(p.getLockBillIdList()));
        if (CollectionUtils.isEmpty(draftIds)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u9501\u5b9a\u7684\u7968\u636e\u3002", (String)"LockDraftHelper_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        List idList = draftIds.stream().map(a -> String.valueOf(a)).collect(Collectors.toList());
        Map request = MutexServiceHelper.batchRequestWithLostTime(idList, (String)"cdm_draftbillf7", (String)"changeLockInfo");
        try {
            if (request.containsValue(Boolean.FALSE)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7968\u636e\u5df2\u88ab\u5176\u4ed6\u64cd\u4f5c\u9501\u5b9a", (String)"releaseOrLockDrafts_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            DynamicObject[] drafts = TmcDataServiceHelper.load((Object[])draftIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
            Map<Long, DynamicObject> draftMap = Stream.of(drafts).collect(Collectors.toMap(p -> p.getLong("id"), o -> o));
            ArrayList<DynamicObject> failOpDrafts = new ArrayList<DynamicObject>(10);
            for (DraftLockInfo draftLockInfo : draftLockInfos) {
                List lockBillIdList = draftLockInfo.getLockBillIdList();
                for (Long lockBillId : lockBillIdList) {
                    DynamicObject draft = draftMap.get(lockBillId);
                    String sourceBillType = draft.getString("locksourcebilltype");
                    long sourceBillId = draft.getLong("locksourcebillid");
                    boolean isLock = draft.getBoolean("isendorsepay");
                    boolean isLockByCurrObj = sourceBillType.equals(draftLockInfo.getSourceBillType()) && sourceBillId == draftLockInfo.getSourceBillId();
                    boolean isNotLock = !isLock && EmptyUtil.isEmpty((Long)sourceBillId) && EmptyUtil.isEmpty((String)sourceBillType);
                    logger.info("isLockByCurrObj :" + isLockByCurrObj + ",isNotLock:" + isNotLock);
                    if (isLockByCurrObj || isNotLock) {
                        draft.set("isendorsepay", (Object)"1");
                        draft.set("locksourcebilltype", (Object)draftLockInfo.getTargetBillType());
                        draft.set("locksourcebillid", (Object)draftLockInfo.getTargetBillId());
                        continue;
                    }
                    logger.info(String.format("\u83b7\u53d6\u9501\u5b9a\u7968\u636e\u5931\u8d25\u4fe1\u606f,HEAD_LOCKSOURCEBILLTYPE:%s", draft.getString("locksourcebilltype")));
                    failOpDrafts.add(draft);
                }
            }
            logger.info("changeLockInfo is start");
            if (!CollectionUtils.isEmpty(failOpDrafts)) {
                throw new KDBizException(LockDraftHelper.getErrorMsg(failOpDrafts));
            }
            logger.info("changeLockInfo is end");
            SaveServiceHelper.save((DynamicObject[])drafts);
        }
        finally {
            MutexServiceHelper.batchRelease(idList, (String)"cdm_draftbillf7", (String)"changeLockInfo");
        }
    }

    public static List<LockResult> lockBills(List<DraftLockInfo> draftAmountLockInfos, boolean strictMode) {
        logger.info("lockBills is start," + JSON.toJSONString(draftAmountLockInfos));
        ArrayList<LockResult> lockResults = new ArrayList<LockResult>(10);
        for (DraftLockInfo draftAmountLockNewInfo : draftAmountLockInfos) {
            try {
                LockResult lockResult = LockDraftHelper.lockBills(draftAmountLockNewInfo, strictMode);
                lockResults.add(lockResult);
            }
            catch (Exception ex) {
                if (!strictMode) continue;
                logger.error("lockBills is error,strictMode is true," + ex.getMessage());
                throw ex;
            }
        }
        logger.info("lockBills is end,lockResults," + JSON.toJSONString(lockResults));
        return lockResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LockResult lockBills(DraftLockInfo draftAmountLockNewInfo, boolean strictMode) {
        LockResult lockResult = new LockResult();
        List lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        List lockDraftIds = lockSubInfoList.stream().map(item -> item.getBillId()).collect(Collectors.toList());
        logger.info("lockBills lockDraftIds size is:" + lockDraftIds.size());
        if (!CollectionUtils.isEmpty(lockDraftIds)) {
            List idList = lockDraftIds.stream().map(a -> String.valueOf(a)).collect(Collectors.toList());
            Map request = MutexServiceHelper.batchRequestWithLostTime(idList, (String)"cdm_draftbillf7", (String)"lockBills");
            try {
                if (request.containsValue(Boolean.FALSE)) {
                    List<String> lockSuccessIdList = LockDraftHelper.getLockSuccessBillId(request);
                    MutexServiceHelper.batchRelease(lockSuccessIdList, (String)"cdm_draftbillf7", (String)"lockBills");
                    LockResult lockResult2 = LockDraftHelper.getFailResult(draftAmountLockNewInfo);
                    return lockResult2;
                }
                DynamicObject[] drafts = TmcDataServiceHelper.load((Object[])lockDraftIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
                HashMap draftBillMap = Arrays.stream(drafts).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
                lockResult = LockDraftHelper.lockBills(draftBillMap, draftAmountLockNewInfo, false);
            }
            finally {
                MutexServiceHelper.batchRelease(idList, (String)"cdm_draftbillf7", (String)"lockBills");
            }
        }
        logger.info("lockBills is end," + JSON.toJSONString((Object)lockResult));
        return lockResult;
    }

    private static List<String> getLockSuccessBillId(Map<String, Boolean> request) {
        ArrayList<String> lockSuccessIdList = new ArrayList<String>();
        for (Map.Entry<String, Boolean> entry : request.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            lockSuccessIdList.add(entry.getKey());
        }
        return lockSuccessIdList;
    }

    private static LockResult getFailResult(DraftLockInfo draftAmountLockNewInfo) {
        LockResult failLockResult = new LockResult();
        failLockResult.setSourceBillId(draftAmountLockNewInfo.getSourceBillId());
        failLockResult.setSuccess(false);
        failLockResult.setBillIdLogIdMap(new HashMap<Long, Long>());
        return failLockResult;
    }

    public static LockResult lockBills(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo, boolean isFromUpdateFlag) {
        LockResult lockResult = new LockResult();
        LockDraftHelper.checkBillLogIds(draftAmountLockNewInfo);
        LockDraftHelper.checkDealAmount(draftBillMap, draftAmountLockNewInfo, isFromUpdateFlag);
        try (TXHandle tx = TX.required();){
            try {
                LockDraftHelper.updateDraftBillAmount(draftBillMap, draftAmountLockNewInfo, isFromUpdateFlag);
                lockResult = LockDraftHelper.saveDraftBillLog(draftBillMap, draftAmountLockNewInfo);
                LockDraftHelper.reGenerateLog(draftBillMap, draftAmountLockNewInfo, isFromUpdateFlag);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("lockBills tx-> has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw e;
            }
        }
        return lockResult;
    }

    private static LockResult reGenerateLog(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo, boolean isFromUpdateFlag) {
        LockDraftHelper.reUpdateDraftBillAmount(draftBillMap, draftAmountLockNewInfo, isFromUpdateFlag);
        return LockDraftHelper.reSaveDraftBillLog(draftBillMap, draftAmountLockNewInfo);
    }

    private static void reUpdateDraftBillAmount(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo, boolean isFromUpdateFlag) {
        List lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoList) {
            boolean isReGenerate = draftAmountLockSubInfo.isReGenerate();
            if (!isReGenerate) continue;
            Long billId = draftAmountLockSubInfo.getBillId();
            BigDecimal dealAmount = draftAmountLockSubInfo.getDealAmount();
            DynamicObject draftBill = draftBillMap.get(billId);
            BigDecimal lockedAmountDB = draftBill.getBigDecimal("lockedamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("lockedamount");
            BigDecimal availableAmountDB = draftBill.getBigDecimal("availableamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("availableamount");
            BigDecimal updateLockedAmount = lockedAmountDB.add(dealAmount);
            BigDecimal udpateAvailableAmount = availableAmountDB.subtract(dealAmount);
            int result = DB.update((DBRoute)DBRouteConst.TMC, (String)SQL_UPDATE_AMOUNT, (Object[])new Object[]{dealAmount, dealAmount, billId, availableAmountDB, lockedAmountDB, dealAmount});
            if (result > 0) {
                draftBill.set("lockedamount", (Object)updateLockedAmount);
                draftBill.set("availableamount", (Object)udpateAvailableAmount);
                continue;
            }
            if (isFromUpdateFlag) {
                logger.error("isFromUpdateFlag is true,reUpdateDraftBillAmount update sql fail,billId:" + billId + ",dealAmount:" + dealAmount);
                continue;
            }
            logger.error("isFromUpdateFlag is false,reUpdateDraftBillAmount update sql fail,billId:" + billId + ",dealAmount:" + dealAmount);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u201c%s\u201d\u66f4\u65b0\u76f8\u5173\u91d1\u989d\u4e0d\u6210\u529f,\u53ef\u80fd\u5b58\u5728\u5176\u4ed6\u5355\u636e\u5360\u7528\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"LockDraftHelper_7_1", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBill.getString("draftbillno")));
        }
    }

    private static LockResult reSaveDraftBillLog(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo) {
        LockResult lockResult = new LockResult();
        ArrayList<DynamicObject> saveDraftBillLogList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> updateOldDraftBillLogList = new ArrayList<DynamicObject>(10);
        List lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        Long sourceBillId = draftAmountLockNewInfo.getSourceBillId();
        for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoList) {
            DynamicObject oldDraftBillLog;
            boolean isReGenerate = draftAmountLockSubInfo.isReGenerate();
            if (!isReGenerate) continue;
            Long oldBillLogId = draftAmountLockSubInfo.getBillLogId();
            Long billId = draftAmountLockSubInfo.getBillId();
            DynamicObject draftBill = draftBillMap.get(billId);
            DynamicObject saveDraftBillLog = LockDraftHelper.generateDraftBillLog(draftBill, draftAmountLockSubInfo, draftAmountLockNewInfo);
            saveDraftBillLog.set("oldlogid", (Object)oldBillLogId);
            saveDraftBillLog.set("bizstatus", (Object)LogBizStatusEnum.FAIL.getValue());
            boolean isExists = TmcDataServiceHelper.exists((Object)oldBillLogId, (String)"cdm_draftbill_log");
            if (isExists && EmptyUtil.isNoEmpty((DynamicObject)(oldDraftBillLog = TmcDataServiceHelper.loadSingle((Object)oldBillLogId, (String)"cdm_draftbill_log")))) {
                saveDraftBillLog.set("issplit", (Object)oldDraftBillLog.getBoolean("issplit"));
                saveDraftBillLog.set("splitedsubbillid", (Object)oldDraftBillLog.getString("splitedsubbillid"));
                oldDraftBillLog.set("splitedsubbillid", (Object)"0");
                oldDraftBillLog.set("issplit", (Object)false);
                oldDraftBillLog.set("bizstatus", (Object)LogBizStatusEnum.PROCESS.getValue());
                oldDraftBillLog.set("newchildlogid", (Object)saveDraftBillLog.getLong("id"));
                updateOldDraftBillLogList.add(oldDraftBillLog);
            }
            saveDraftBillLogList.add(saveDraftBillLog);
            LockDraftHelper.getSuccessResult(lockResult, sourceBillId, billId, saveDraftBillLog.getLong("id"));
        }
        if (!EmptyUtil.isEmpty(saveDraftBillLogList)) {
            TmcDataServiceHelper.save((DynamicObject[])saveDraftBillLogList.toArray(new DynamicObject[0]));
        }
        if (!EmptyUtil.isEmpty(updateOldDraftBillLogList)) {
            SaveServiceHelper.update((DynamicObject[])updateOldDraftBillLogList.toArray(new DynamicObject[0]));
        }
        return lockResult;
    }

    private static void checkDealAmount(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo, boolean isFromUpdateFlag) {
        logger.info("checkDealAmount start,isFromUpdateFlag:" + isFromUpdateFlag);
        List lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoList) {
            boolean lockedAmountFlag;
            Long billId = draftAmountLockSubInfo.getBillId();
            Long sourceBillId = draftAmountLockNewInfo.getSourceBillId();
            DynamicObject draftBill = draftBillMap.get(billId);
            BigDecimal dealAmount = draftAmountLockSubInfo.getDealAmount();
            boolean isReGenerate = draftAmountLockSubInfo.isReGenerate();
            String billTrade = draftAmountLockSubInfo.getBillTrade();
            BigDecimal originalSubbillAmount = draftBill.getBigDecimal("originalsubbillamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("originalsubbillamount");
            BigDecimal lockedAmount = draftBill.getBigDecimal("lockedamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("lockedamount");
            BigDecimal usedAmount = draftBill.getBigDecimal("usedamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("usedamount");
            BigDecimal availableAmount = draftBill.getBigDecimal("availableamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("availableamount");
            boolean dealAmountFlag = dealAmount.compareTo(availableAmount) > 0;
            boolean originalSubbillAmountFlag = originalSubbillAmount.compareTo(lockedAmount.add(availableAmount)) != 0;
            boolean bl = lockedAmountFlag = lockedAmount.compareTo(usedAmount) < 0;
            if (dealAmountFlag && !isReGenerate) {
                logger.info("dealAmountFlag:" + dealAmountFlag + ",isReGenerate:" + isReGenerate);
                QFilter qFilter = new QFilter("sourcebillid", "=", (Object)sourceBillId);
                qFilter.and("draftid", "=", (Object)billId);
                qFilter.and("deleteflag", "=", (Object)Character.valueOf('0'));
                Object[] draftBillLogs = TmcDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,dealamount,availableamount", (QFilter[])qFilter.toArray());
                if (!EmptyUtil.isEmpty((Object[])draftBillLogs)) {
                    BigDecimal dealAmountDB = draftBillLogs[0].getBigDecimal("dealamount") == null ? BigDecimal.ZERO : draftBillLogs[0].getBigDecimal("dealamount");
                    BigDecimal availableAmountDB = draftBillLogs[0].getBigDecimal("availableamount") == null ? BigDecimal.ZERO : draftBillLogs[0].getBigDecimal("availableamount");
                    boolean bl2 = dealAmountFlag = dealAmount.compareTo(dealAmountDB.add(availableAmountDB)) > 0;
                }
            }
            if (isFromUpdateFlag && isReGenerate && (dealAmountFlag || originalSubbillAmountFlag || lockedAmountFlag)) {
                draftAmountLockSubInfo.setReGenerate(false);
                LockDraftHelper.clearOldLogNewChildLogid(draftAmountLockSubInfo);
                logger.info("isFromUpdateFlag\u3001isReGenerate is true,dealAmountFlag:" + dealAmountFlag + ",originalSubbillAmountFlag:" + originalSubbillAmountFlag + ",lockedAmountFlag:" + lockedAmountFlag + ",draftbillno:" + draftBill.getString("draftbillno"));
            } else if (!isFromUpdateFlag && (dealAmountFlag || originalSubbillAmountFlag || lockedAmountFlag)) {
                logger.error("dealAmountFlag:" + dealAmountFlag + ",originalSubbillAmountFlag:" + originalSubbillAmountFlag + ",lockedAmountFlag:" + lockedAmountFlag + ",draftbillno:" + draftBill.getString("draftbillno"));
                logger.error("lockedAmount:" + lockedAmount + ",usedAmount:" + usedAmount + ",dealAmount:" + dealAmount + ",originalSubbillAmount:" + originalSubbillAmount);
                throw new KDBizException(ResManager.loadKDString((String)"\u7968\u636e\u201c%s\u201d\u8f6c\u8ba9\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u53ef\u7528\u91d1\u989d\u3002", (String)"LockDraftHelper_5", (String)"tmc-cdm-business", (Object[])new Object[]{draftBill.getString("draftbillno")}));
            }
            boolean isLockAmountNotZero = false;
            boolean isNotEqualFlag = false;
            if (noSupportPartTransferTradeType.contains(billTrade)) {
                isLockAmountNotZero = lockedAmount.compareTo(BigDecimal.ZERO) != 0;
                boolean bl3 = isNotEqualFlag = originalSubbillAmount.compareTo(usedAmount.add(dealAmount)) != 0;
            }
            if (!isLockAmountNotZero || !isNotEqualFlag) continue;
            logger.error("billTrade:" + billTrade + ",\u4e0d\u652f\u6301\u90e8\u5206\u8f6c\u8ba9\u7684\u4e1a\u52a1\u7c7b\u578b\uff0c\u9501\u5b9a\u91d1\u989d\u5fc5\u987b\u4e3a0\uff0c\u6216\u8f6c\u8ba9\u91d1\u989d=\u539f\u59cb\u5b50\u7968\u636e\u91d1\u989d-\u5df2\u7528\u91d1\u989d,draftbillno:" + draftBill.getString("draftbillno"));
            logger.error("lockedAmount:" + lockedAmount + ",usedAmount:" + usedAmount + ",dealAmount:" + dealAmount + ",originalSubbillAmount:" + originalSubbillAmount);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u652f\u6301\u90e8\u5206\u8f6c\u8ba9\uff0c\u8bf7\u786e\u4fdd\u7968\u636e\u5168\u90e8\u91d1\u989d\u8f6c\u8ba9\u3002", (String)"LockDraftHelper_8", (String)"tmc-cdm-business", (Object[])new Object[0]), DraftTradeTypeEnum.getName((String)billTrade)));
        }
        logger.info("checkDealAmount end");
    }

    private static void clearOldLogNewChildLogid(DraftAmountLockSubInfo draftAmountLockSubInfo) {
        DynamicObject oldDraftBillLog;
        Long oldBillLogId = draftAmountLockSubInfo.getBillLogId();
        if (EmptyUtil.isNoEmpty((Long)oldBillLogId) && oldBillLogId > 0L && EmptyUtil.isNoEmpty((DynamicObject)(oldDraftBillLog = TmcDataServiceHelper.loadSingle((Object)oldBillLogId, (String)"cdm_draftbill_log")))) {
            oldDraftBillLog.set("newchildlogid", (Object)0L);
            SaveServiceHelper.update((DynamicObject)oldDraftBillLog);
        }
    }

    private static void checkBillLogIds(DraftLockInfo draftAmountLockNewInfo) {
        DynamicObject[] draftBillLogs = null;
        List lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        Set billLogIdSet = lockSubInfoList.stream().filter(e -> !EmptyUtil.isEmpty((Long)e.getBillLogId()) && e.getBillLogId() > 0L).map(o -> o.getBillLogId()).collect(Collectors.toSet());
        if (!EmptyUtil.isEmpty(billLogIdSet)) {
            QFilter qFilter = new QFilter("id", "in", billLogIdSet);
            qFilter.and("deleteflag", "=", (Object)Character.valueOf('0'));
            draftBillLogs = TmcDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,sourcebilltype,bizbillno,sourcebillid", (QFilter[])qFilter.toArray());
        }
        if (!EmptyUtil.isEmpty(draftBillLogs)) {
            block0: for (Long billLogId : billLogIdSet) {
                List draftBillLogList = Arrays.stream(draftBillLogs).collect(Collectors.toList());
                for (DynamicObject draftBillLog : draftBillLogList) {
                    if (draftBillLog.getLong("id") != billLogId.longValue()) continue;
                    draftAmountLockNewInfo.setSourceBillId(Long.valueOf(draftBillLog.getLong("sourcebillid")));
                    draftAmountLockNewInfo.setSourceBillType(draftBillLog.getString("sourcebilltype"));
                    draftAmountLockNewInfo.setBizBillNo(draftBillLog.getString("bizbillno"));
                    continue block0;
                }
            }
        }
    }

    private static void updateDraftBillAmount(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo, boolean isFromUpdateFlag) {
        List lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoList) {
            Long billId = draftAmountLockSubInfo.getBillId();
            Long sourceBillId = draftAmountLockNewInfo.getSourceBillId();
            BigDecimal dealAmount = draftAmountLockSubInfo.getDealAmount();
            DynamicObject draftBill = draftBillMap.get(billId);
            BigDecimal lockedAmountDB = draftBill.getBigDecimal("lockedamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("lockedamount");
            BigDecimal availableAmountDB = draftBill.getBigDecimal("availableamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("availableamount");
            QFilter qFilter = new QFilter("sourcebillid", "=", (Object)sourceBillId);
            qFilter.and("draftid", "=", (Object)billId);
            qFilter.and("deleteflag", "=", (Object)Character.valueOf('0'));
            Object[] draftBillLogs = TmcDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,dealamount", (QFilter[])qFilter.toArray());
            if (EmptyUtil.isEmpty((Object[])draftBillLogs)) {
                BigDecimal updateLockedAmount = lockedAmountDB.add(dealAmount);
                BigDecimal udpateAvailableAmount = availableAmountDB.subtract(dealAmount);
                int result = DB.update((DBRoute)DBRouteConst.TMC, (String)SQL_UPDATE_AMOUNT, (Object[])new Object[]{dealAmount, dealAmount, billId, availableAmountDB, lockedAmountDB, dealAmount});
                if (result > 0) {
                    draftBill.set("lockedamount", (Object)updateLockedAmount);
                    draftBill.set("availableamount", (Object)udpateAvailableAmount);
                    continue;
                }
                if (isFromUpdateFlag) {
                    logger.error("isFromUpdateFlag is true,updateDraftBillAmount update sql fail,billId:" + billId + ",dealAmount:" + dealAmount);
                    continue;
                }
                logger.error("isFromUpdateFlag is false,updateDraftBillAmount update sql fail,billId:" + billId + ",dealAmount:" + dealAmount);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u201c%s\u201d\u66f4\u65b0\u76f8\u5173\u91d1\u989d\u4e0d\u6210\u529f,\u53ef\u80fd\u5b58\u5728\u5176\u4ed6\u5355\u636e\u5360\u7528\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"LockDraftHelper_7_1", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBill.getString("draftbillno")));
            }
            BigDecimal dealAmountDB = draftBillLogs[0].getBigDecimal("dealamount") == null ? BigDecimal.ZERO : draftBillLogs[0].getBigDecimal("dealamount");
            boolean isChangedFlag = dealAmountDB.compareTo(dealAmount) != 0;
            if (!isChangedFlag) continue;
            BigDecimal diffDealAmount = dealAmount.subtract(dealAmountDB);
            BigDecimal updateDiffLockedAmount = lockedAmountDB.add(diffDealAmount);
            BigDecimal udpateDiffAvailableAmount = availableAmountDB.subtract(diffDealAmount);
            int result = DB.update((DBRoute)DBRouteConst.TMC, (String)SQL_UPDATE_AMOUNT, (Object[])new Object[]{diffDealAmount, diffDealAmount, billId, availableAmountDB, lockedAmountDB, diffDealAmount});
            if (result > 0) {
                draftBill.set("lockedamount", (Object)updateDiffLockedAmount);
                draftBill.set("availableamount", (Object)udpateDiffAvailableAmount);
                continue;
            }
            if (isFromUpdateFlag) {
                logger.error("isFromUpdateFlag is true,updateDraftBillAmount update sql fail,billId:" + billId + ",dealAmount:" + dealAmount);
                continue;
            }
            logger.error("isFromUpdateFlag is false,updateDraftBillAmount update sql fail,billId:" + billId + ",diffDealAmount:" + diffDealAmount);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u201c%s\u201d\u66f4\u65b0\u76f8\u5173\u91d1\u989d\u4e0d\u6210\u529f,\u53ef\u80fd\u5b58\u5728\u5176\u4ed6\u5355\u636e\u5360\u7528\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"LockDraftHelper_7_1", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBill.getString("draftbillno")));
        }
    }

    private static LockResult saveDraftBillLog(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo) {
        LockResult lockResult = new LockResult();
        ArrayList<DynamicObject> saveDraftBillLogList = new ArrayList<DynamicObject>(10);
        ArrayList<Object> updateDraftBillLogList = new ArrayList<Object>(10);
        List lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        Long sourceBillId = draftAmountLockNewInfo.getSourceBillId();
        for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoList) {
            boolean isChangedFlag;
            Long billId = draftAmountLockSubInfo.getBillId();
            DynamicObject draftBill = draftBillMap.get(billId);
            BigDecimal dealAmount = draftAmountLockSubInfo.getDealAmount();
            QFilter qFilter = new QFilter("sourcebillid", "=", (Object)sourceBillId);
            qFilter.and("draftid", "=", (Object)billId);
            qFilter.and("deleteflag", "=", (Object)Character.valueOf('0'));
            Object[] draftBillLogs = TmcDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,dealamount,lockedamount,availableamount,", (QFilter[])qFilter.toArray());
            if (EmptyUtil.isEmpty((Object[])draftBillLogs)) {
                DynamicObject saveDraftBillLog = LockDraftHelper.generateDraftBillLog(draftBill, draftAmountLockSubInfo, draftAmountLockNewInfo);
                saveDraftBillLogList.add(saveDraftBillLog);
                LockDraftHelper.getSuccessResult(lockResult, sourceBillId, billId, saveDraftBillLog.getLong("id"));
                lockResult.getBillIdDiffAmountMap().put(billId, BigDecimal.ZERO);
                continue;
            }
            BigDecimal dealAmountDB = draftBillLogs[0].getBigDecimal("dealamount") == null ? BigDecimal.ZERO : draftBillLogs[0].getBigDecimal("dealamount");
            boolean bl = isChangedFlag = dealAmountDB.compareTo(dealAmount) != 0;
            if (isChangedFlag) {
                draftBillLogs[0].set("lockedamount", (Object)draftBill.getBigDecimal("lockedamount"));
                draftBillLogs[0].set("availableamount", (Object)draftBill.getBigDecimal("availableamount"));
                draftBillLogs[0].set("dealamount", (Object)draftAmountLockSubInfo.getDealAmount());
                updateDraftBillLogList.add(draftBillLogs[0]);
                lockResult.getBillIdDiffAmountMap().put(billId, dealAmountDB);
            }
            LockDraftHelper.getSuccessResult(lockResult, sourceBillId, billId, draftBillLogs[0].getLong("id"));
        }
        if (!EmptyUtil.isEmpty(saveDraftBillLogList)) {
            TmcDataServiceHelper.save((DynamicObject[])saveDraftBillLogList.toArray(new DynamicObject[0]));
        }
        if (!EmptyUtil.isEmpty(updateDraftBillLogList)) {
            SaveServiceHelper.update((DynamicObject[])updateDraftBillLogList.toArray(new DynamicObject[0]));
        }
        return lockResult;
    }

    private static void getSuccessResult(LockResult lockResult, Long sourceBillId, Long billId, Long logId) {
        Long existSourceBillId = lockResult.getSourceBillId();
        if (EmptyUtil.isNoEmpty((Long)existSourceBillId) && existSourceBillId > 0L) {
            Map<Long, Long> billIdLogIdMap = lockResult.getBillIdLogIdMap();
            billIdLogIdMap.put(billId, logId);
        } else {
            lockResult.setSourceBillId(sourceBillId);
            lockResult.setSuccess(true);
            HashMap<Long, Long> billIdLogIdMap = new HashMap<Long, Long>();
            billIdLogIdMap.put(billId, logId);
            lockResult.setBillIdLogIdMap(billIdLogIdMap);
        }
    }

    private static DynamicObject generateDraftBillLog(DynamicObject draftBill, DraftAmountLockSubInfo draftAmountLockSubInfo, DraftLockInfo draftAmountLockNewInfo) {
        MainEntityType draftBillLogType = EntityMetadataCache.getDataEntityType((String)"cdm_draftbill_log");
        long pkId = DB.genLongId((String)draftBillLogType.getAlias());
        DynamicObject draftBillLog = new DynamicObject((DynamicObjectType)draftBillLogType, (Object)pkId);
        draftBillLog.set("sourcebilltype", (Object)draftAmountLockNewInfo.getSourceBillType());
        draftBillLog.set("bizbillno", (Object)draftAmountLockNewInfo.getBizBillNo());
        draftBillLog.set("org", (Object)draftBill.getDynamicObject("company").getLong("id"));
        draftBillLog.set("draftbillnumber", (Object)draftBill.getString("billno"));
        draftBillLog.set("draftbillno", (Object)draftBill.getString("draftbillno"));
        draftBillLog.set("billidentitycode", (Object)draftBill.getString("billidentitycode"));
        draftBillLog.set("originalsubbillrang", (Object)draftBill.getString("originalsubbillrang"));
        draftBillLog.set("originalsubbillamount", (Object)draftBill.getBigDecimal("originalsubbillamount"));
        draftBillLog.set("subbillrange", (Object)draftBill.getString("subbillrange"));
        draftBillLog.set("amount", (Object)draftBill.getBigDecimal("amount"));
        draftBillLog.set("lockedamount", (Object)draftBill.getBigDecimal("lockedamount"));
        draftBillLog.set("availableamount", (Object)draftBill.getBigDecimal("availableamount"));
        draftBillLog.set("usedamount", (Object)draftBill.getBigDecimal("usedamount"));
        draftBillLog.set("dealamount", (Object)draftAmountLockSubInfo.getDealAmount());
        draftBillLog.set("currency", (Object)draftBill.getDynamicObject("currency"));
        draftBillLog.set("biztype", (Object)draftAmountLockSubInfo.getBillTrade());
        draftBillLog.set("bizstatus", (Object)LogBizStatusEnum.PROCESS.getValue());
        draftBillLog.set("deleteflag", (Object)false);
        draftBillLog.set("sourcebillid", (Object)draftAmountLockNewInfo.getSourceBillId());
        draftBillLog.set("draftid", (Object)draftBill.getLong("id"));
        draftBillLog.set("rptype", (Object)draftBill.getString("rptype"));
        draftBillLog.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        return draftBillLog;
    }

    public static List<LockResult> updateBills(List<DraftLockInfo> draftAmountLockInfos, boolean strictMode) {
        logger.info("updateBills is start," + JSON.toJSONString(draftAmountLockInfos));
        ArrayList<LockResult> lockResults = new ArrayList<LockResult>(10);
        for (DraftLockInfo draftAmountLockNewInfo : draftAmountLockInfos) {
            try {
                LockResult lockResult = LockDraftHelper.updateBills(draftAmountLockNewInfo, strictMode);
                lockResults.add(lockResult);
            }
            catch (Exception ex) {
                logger.error("updateBills is error,strictMode is true," + ex.getMessage());
                throw ex;
            }
        }
        logger.info("updateBills is end,lockResults," + JSON.toJSONString(lockResults));
        return lockResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static LockResult updateBills(DraftLockInfo draftAmountLockNewInfo, boolean strictMode) {
        lockResult = new LockResult();
        lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        lockDraftIds = lockSubInfoList.stream().map((Function<DraftAmountLockSubInfo, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateBills$14(kd.tmc.cdm.business.service.DraftAmountLockSubInfo ), (Lkd/tmc/cdm/business/service/DraftAmountLockSubInfo;)Ljava/lang/Long;)()).collect(Collectors.toList());
        LockDraftHelper.logger.info("updateBills lockDraftIds size is:" + lockDraftIds.size());
        if (!CollectionUtils.isEmpty(lockDraftIds)) {
            idList = lockDraftIds.stream().map((Function<Long, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateBills$15(java.lang.Long ), (Ljava/lang/Long;)Ljava/lang/String;)()).collect(Collectors.toList());
            request = MutexServiceHelper.batchRequestWithLostTime(idList, (String)"cdm_draftbillf7", (String)"updateBills");
            try {
                if (request.containsValue(Boolean.FALSE)) {
                    lockSuccessIdList = LockDraftHelper.getLockSuccessBillId(request);
                    MutexServiceHelper.batchRelease(lockSuccessIdList, (String)"cdm_draftbillf7", (String)"updateBills");
                    var8_9 = LockDraftHelper.getFailResult(draftAmountLockNewInfo);
                    return var8_9;
                }
                drafts = TmcDataServiceHelper.load((Object[])lockDraftIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
                draftBillMap = Arrays.stream(drafts).collect(Collectors.toMap((Function<DynamicObject, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateBills$16(kd.bos.dataentity.entity.DynamicObject ), (Lkd/bos/dataentity/entity/DynamicObject;)Ljava/lang/Long;)(), (Function<DynamicObject, DynamicObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateBills$17(kd.bos.dataentity.entity.DynamicObject ), (Lkd/bos/dataentity/entity/DynamicObject;)Lkd/bos/dataentity/entity/DynamicObject;)(), (BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateBills$18(kd.bos.dataentity.entity.DynamicObject kd.bos.dataentity.entity.DynamicObject ), (Lkd/bos/dataentity/entity/DynamicObject;Lkd/bos/dataentity/entity/DynamicObject;)Lkd/bos/dataentity/entity/DynamicObject;)(), (Supplier<HashMap>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/util/HashMap;)()));
                LockDraftHelper.checkAmount(draftBillMap, draftAmountLockNewInfo);
                operateType = draftAmountLockNewInfo.getOperateType();
                LockDraftHelper.logger.info("operateType == " + operateType);
                var10_12 = operateType;
                var11_13 = -1;
                switch (var10_12.hashCode()) {
                    case -1274442605: {
                        if (!var10_12.equals("finish")) break;
                        var11_13 = 0;
                        break;
                    }
                    case -1367724422: {
                        if (!var10_12.equals("cancel")) break;
                        var11_13 = 1;
                        break;
                    }
                    case -1335458389: {
                        if (!var10_12.equals("delete")) break;
                        var11_13 = 2;
                        break;
                    }
                    case -599445191: {
                        if (!var10_12.equals("complete")) break;
                        var11_13 = 3;
                        break;
                    }
                    case 1699628467: {
                        if (!var10_12.equals("cancelcomplete")) break;
                        var11_13 = 4;
                        break;
                    }
                    case -1178482289: {
                        if (!var10_12.equals("rollbackdelete")) break;
                        var11_13 = 5;
                    }
                }
                switch (var11_13) {
                    case 0: {
                        lockResult = LockDraftHelper.handleFinishBizBills(draftBillMap, draftAmountLockNewInfo);
                        ** break;
lbl50:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        lockResult = LockDraftHelper.handleCancelBizBills(draftBillMap, draftAmountLockNewInfo);
                        ** break;
lbl54:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        lockResult = LockDraftHelper.handleDeleteBizBills(draftBillMap, draftAmountLockNewInfo);
                        ** break;
lbl58:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        lockResult = LockDraftHelper.handleCompleteBizBills(draftBillMap, draftAmountLockNewInfo);
                        ** break;
lbl62:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        lockResult = LockDraftHelper.handleCancelCompleteBizBills(draftBillMap, draftAmountLockNewInfo);
                        ** break;
lbl66:
                        // 1 sources

                        break;
                    }
                    case 5: {
                        lockResult = LockDraftHelper.handleRollBackDeleteBizBills(draftBillMap, draftAmountLockNewInfo);
                        break;
                    }
                    ** default:
lbl71:
                    // 1 sources

                    break;
                }
            }
            finally {
                MutexServiceHelper.batchRelease(idList, (String)"cdm_draftbillf7", (String)"updateBills");
            }
        }
        LockDraftHelper.logger.info("updateBills is end," + JSON.toJSONString((Object)lockResult));
        return lockResult;
    }

    private static void checkAmount(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo) {
        List lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoList) {
            boolean lockedAmountFlag;
            Long billId = draftAmountLockSubInfo.getBillId();
            boolean isReGenerate = draftAmountLockSubInfo.isReGenerate();
            DynamicObject draftBill = draftBillMap.get(billId);
            BigDecimal originalSubbillAmount = draftBill.getBigDecimal("originalsubbillamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("originalsubbillamount");
            BigDecimal lockedAmount = draftBill.getBigDecimal("lockedamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("lockedamount");
            BigDecimal usedAmount = draftBill.getBigDecimal("usedamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("usedamount");
            BigDecimal availableAmount = draftBill.getBigDecimal("availableamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("availableamount");
            boolean originalSubbillAmountFlag = originalSubbillAmount.compareTo(lockedAmount.add(availableAmount)) != 0;
            boolean bl = lockedAmountFlag = lockedAmount.compareTo(usedAmount) < 0;
            if (isReGenerate && (originalSubbillAmountFlag || lockedAmountFlag)) {
                logger.error("isReGenerate is true,originalSubbillAmountFlag:" + originalSubbillAmountFlag + ",lockedAmountFlag:" + lockedAmountFlag + ",draftbillno:" + draftBill.getString("draftbillno"));
                continue;
            }
            if (isReGenerate || !originalSubbillAmountFlag && !lockedAmountFlag) continue;
            logger.error("originalSubbillAmountFlag:" + originalSubbillAmountFlag + ",lockedAmountFlag:" + lockedAmountFlag + ",draftbillno:" + draftBill.getString("draftbillno"));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u201c%1$s\u201d\u5fc5\u987b\u540c\u65f6\u6ee1\u8db3\uff1a\u539f\u59cb\u5b50\u7968\u5305\u91d1\u989d=\u9501\u5b9a\u91d1\u989d+\u53ef\u7528\u91d1\u989d\u4e14\u9501\u5b9a\u91d1\u989d>=\u4f7f\u7528\u91d1\u989d\u3002", (String)"LockDraftHelper_6", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBill.getString("draftbillno")));
        }
    }

    private static LockResult handleFinishBizBills(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo) {
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            LockDraftHelper.updateFinishDraftBill(draftBillMap, draftAmountLockNewInfo);
            LockDraftHelper.updateFinishDraftBillLog(draftBillMap, draftAmountLockNewInfo);
            LockResult lockResult = LockDraftHelper.isReGenerate(draftBillMap, draftAmountLockNewInfo);
            return lockResult;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                logger.error("handleFinishBizBills tx-> has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static LockResult isReGenerate(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo) {
        LockResult lockResult = new LockResult();
        List lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        List allDraftIds = lockSubInfoList.stream().map(item -> item.getBillId()).collect(Collectors.toList());
        List reGenerateDraftIds = lockSubInfoList.stream().filter(v -> v.isReGenerate()).map(item -> item.getBillId()).collect(Collectors.toList());
        allDraftIds.removeAll(reGenerateDraftIds);
        for (Long noReGeneratedraft : allDraftIds) {
            draftBillMap.remove(noReGeneratedraft);
        }
        if (!EmptyUtil.isEmpty(reGenerateDraftIds)) {
            logger.info("isReGenerate lockBills is start" + JSON.toJSONString((Object)draftAmountLockNewInfo));
            lockResult = LockDraftHelper.lockBills(draftBillMap, draftAmountLockNewInfo, true);
            logger.info("isReGenerate lockBills is end" + JSON.toJSONString((Object)lockResult));
        } else {
            Long sourceBillId = draftAmountLockNewInfo.getSourceBillId();
            for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoList) {
                LockDraftHelper.getSuccessResult(lockResult, sourceBillId, draftAmountLockSubInfo.getBillId(), draftAmountLockSubInfo.getBillLogId());
            }
        }
        return lockResult;
    }

    private static void updateFinishDraftBill(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo) {
        String billTrade = draftAmountLockNewInfo.getBillTrade();
        List lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoList) {
            long newStartflag;
            long newQuantity;
            Long billId = draftAmountLockSubInfo.getBillId();
            DynamicObject draftBill = draftBillMap.get(billId);
            BigDecimal dealAmount = draftAmountLockSubInfo.getDealAmount();
            boolean isReGenerate = draftAmountLockSubInfo.isReGenerate();
            BigDecimal usedAmount = draftBill.getBigDecimal("usedamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("usedamount");
            BigDecimal amount = draftBill.getBigDecimal("amount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("amount");
            String originalSubBillRange = draftBill.getString("subbillrange") == null ? "" : draftBill.getString("subbillrange");
            BigDecimal updateUsedAmount = usedAmount.add(dealAmount);
            BigDecimal updateAmount = amount.subtract(dealAmount);
            BigDecimal newDealAmount = dealAmount;
            String updateOriginalSubBillRange = LockDraftHelper.calculateOriginalSubBillRange(originalSubBillRange, dealAmount);
            long subBillStartFlag = 0L;
            long subBillQuantity = 0L;
            if (EmptyUtil.isNoEmpty((String)updateOriginalSubBillRange) && updateOriginalSubBillRange.contains("-")) {
                subBillStartFlag = Long.parseLong(updateOriginalSubBillRange.split("-")[0]);
                subBillQuantity = LockDraftHelper.calculateSubBillQuantity(updateOriginalSubBillRange);
            }
            BigDecimal udpateLockedAmount = BigDecimal.ZERO;
            BigDecimal udpateAvailableAmount = BigDecimal.ZERO;
            BigDecimal udpateUsedAmount = dealAmount;
            if (specialTradeType.contains(billTrade)) {
                newQuantity = draftBill.getLong("subbillquantity");
                newStartflag = draftBill.getLong("subbillstartflag");
                updateOriginalSubBillRange = originalSubBillRange;
                subBillStartFlag = newStartflag;
                subBillQuantity = newQuantity;
                udpateLockedAmount = dealAmount;
                udpateAvailableAmount = dealAmount;
                udpateUsedAmount = BigDecimal.ZERO;
                newDealAmount = BigDecimal.ZERO;
            }
            if (amount.compareTo(dealAmount) == 0) {
                newQuantity = draftBill.getLong("subbillquantity");
                newStartflag = draftBill.getLong("subbillstartflag");
                updateOriginalSubBillRange = originalSubBillRange;
                subBillStartFlag = newStartflag;
                subBillQuantity = newQuantity;
                newDealAmount = BigDecimal.ZERO;
                udpateLockedAmount = dealAmount;
                udpateAvailableAmount = dealAmount;
                udpateUsedAmount = BigDecimal.ZERO;
            }
            BigDecimal lockedAmount = draftBill.getBigDecimal("lockedamount");
            logger.error("updateFinishDraftBill update sql fail,billId:" + billId + ",lockedAmount:" + lockedAmount);
            if (null == lockedAmount || lockedAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            int result = DB.update((DBRoute)DBRouteConst.TMC, (String)SQL_FINISH_UPDATE_AMOUNT, (Object[])new Object[]{udpateLockedAmount, udpateAvailableAmount, udpateUsedAmount, newDealAmount, updateOriginalSubBillRange, subBillQuantity, subBillStartFlag, billId, usedAmount, amount, udpateLockedAmount});
            if (result > 0) {
                draftBill.set("usedamount", (Object)usedAmount.add(udpateUsedAmount));
                continue;
            }
            if (isReGenerate) {
                logger.error("isReGenerate is true,updateFinishDraftBill update sql fail,billId:" + billId + ",dealAmount:" + dealAmount);
                continue;
            }
            logger.error("isReGenerate is false,updateFinishDraftBill update sql fail,billId:" + billId + ",dealAmount:" + dealAmount);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u201c%1$s\u201d\u66f4\u65b0\u76f8\u5173\u91d1\u989d\u4e0d\u6210\u529f\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"LockDraftHelper_7", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBill.getString("draftbillno")));
        }
    }

    private static String calculateOriginalSubBillRange(String originalSubBillRange, BigDecimal updateUsedAmount) {
        String range = "";
        if (EmptyUtil.isNoEmpty((String)originalSubBillRange) && originalSubBillRange.contains("-")) {
            String[] ranges = originalSubBillRange.split("-");
            long startRange = updateUsedAmount.multiply(new BigDecimal("100")).add(BigDecimal.valueOf(Long.parseLong(ranges[0]))).longValue();
            range = startRange + "-" + ranges[1];
        }
        return range;
    }

    private static long calculateSubBillQuantity(String updateSubbillRange) {
        long subbillRange = 0L;
        if (EmptyUtil.isNoEmpty((String)updateSubbillRange) && updateSubbillRange.contains("-")) {
            String[] ranges = updateSubbillRange.split("-");
            long subBillEndFlag = Long.parseLong(ranges[1]);
            long subBillStartFlag = Long.parseLong(ranges[0]);
            subbillRange = subBillEndFlag - subBillStartFlag + 1L;
        }
        return subbillRange;
    }

    private static LockResult updateFinishDraftBillLog(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo) {
        LockResult lockResult = new LockResult();
        ArrayList<DynamicObject> updateDraftBillLogList = new ArrayList<DynamicObject>(10);
        String billTrade = draftAmountLockNewInfo.getBillTrade();
        List lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        Long sourceBillId = draftAmountLockNewInfo.getSourceBillId();
        for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoList) {
            Long billId = draftAmountLockSubInfo.getBillId();
            DynamicObject draftBill = draftBillMap.get(billId);
            Long billLogId = draftAmountLockSubInfo.getBillLogId();
            BigDecimal dealAmount = draftAmountLockSubInfo.getDealAmount();
            BigDecimal usedAmount = draftBill.getBigDecimal("usedamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("usedamount");
            BigDecimal amount = draftBill.getBigDecimal("amount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("amount");
            BigDecimal availableAmount = draftBill.getBigDecimal("availableamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("availableamount");
            BigDecimal lockedAmount = draftBill.getBigDecimal("lockedamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("lockedamount");
            DynamicObject draftBillLog = TmcDataServiceHelper.loadSingle((Object)billLogId, (String)"cdm_draftbill_log");
            if (EmptyUtil.isNoEmpty((DynamicObject)draftBillLog)) {
                BigDecimal updateLockedAmount = lockedAmount;
                BigDecimal updateAvailableAmount = availableAmount;
                BigDecimal updateUsedAmount = usedAmount;
                if (specialTradeType.contains(billTrade)) {
                    updateLockedAmount = lockedAmount.subtract(dealAmount);
                    updateAvailableAmount = availableAmount.add(dealAmount);
                }
                if (amount.compareTo(dealAmount) == 0) {
                    updateLockedAmount = lockedAmount.subtract(dealAmount);
                    updateAvailableAmount = availableAmount.add(dealAmount);
                    updateUsedAmount = usedAmount;
                }
                if (draftAmountLockNewInfo.isDrawfail()) {
                    draftBillLog.set("bizstatus", (Object)LogBizStatusEnum.FAIL.getValue());
                } else {
                    draftBillLog.set("bizstatus", (Object)LogBizStatusEnum.SUCCESS.getValue());
                }
                draftBillLog.set("lockedamount", (Object)updateLockedAmount);
                draftBillLog.set("availableamount", (Object)updateAvailableAmount);
                draftBillLog.set("usedamount", (Object)updateUsedAmount);
                updateDraftBillLogList.add(draftBillLog);
            }
            LockDraftHelper.getSuccessResult(lockResult, sourceBillId, billId, billLogId);
        }
        if (!EmptyUtil.isEmpty(updateDraftBillLogList)) {
            SaveServiceHelper.update((DynamicObject[])updateDraftBillLogList.toArray(new DynamicObject[0]));
        }
        return lockResult;
    }

    private static LockResult handleCancelBizBills(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo) {
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            LockDraftHelper.updateCancelDraftBill(draftBillMap, draftAmountLockNewInfo);
            LockResult lockResult = LockDraftHelper.updateCancelDraftBillLog(draftBillMap, draftAmountLockNewInfo);
            return lockResult;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                logger.error("handleCancelBizBills tx-> has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static void updateCancelDraftBill(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo) {
        List lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoList) {
            int result;
            Long billId = draftAmountLockSubInfo.getBillId();
            DynamicObject draftBill = draftBillMap.get(billId);
            BigDecimal dealAmount = draftAmountLockSubInfo.getDealAmount();
            BigDecimal usedAmount = draftBill.getBigDecimal("usedamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("usedamount");
            BigDecimal originalsubbillamount = draftBill.getBigDecimal("originalsubbillamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("originalsubbillamount");
            BigDecimal amount = draftBill.getBigDecimal("amount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("amount");
            String originalSubBillRange = draftBill.getString("subbillrange") == null ? "" : draftBill.getString("subbillrange");
            BigDecimal updateUsedAmount = BigDecimal.ZERO.subtract(dealAmount);
            BigDecimal updateAmount = amount.add(dealAmount);
            BigDecimal newDealAmount = dealAmount;
            String updateOriginalSubBillRange = LockDraftHelper.calculateOriginalSubBillRange(originalSubBillRange, updateUsedAmount);
            long subBillStartFlag = 0L;
            long subBillQuantity = 0L;
            String draftBillStatusStr = draftBill.getString("draftbillstatus");
            String billTrade = draftAmountLockNewInfo.getBillTrade();
            boolean isDrawfail = draftAmountLockNewInfo.isDrawfail();
            Long billLogId = draftAmountLockSubInfo.getBillLogId();
            if (EmptyUtil.isNoEmpty((String)updateOriginalSubBillRange) && updateOriginalSubBillRange.contains("-") && !LockDraftHelper.isWholeBillTrade(amount, dealAmount, draftBillStatusStr, billTrade, isDrawfail, billLogId)) {
                subBillStartFlag = Long.parseLong(updateOriginalSubBillRange.split("-")[0]);
                subBillQuantity = LockDraftHelper.calculateSubBillQuantity(updateOriginalSubBillRange);
            }
            BigDecimal udpateLockedAmount = BigDecimal.ZERO;
            BigDecimal udpateAvailableAmount = BigDecimal.ZERO;
            BigDecimal udpateUsedAmount = dealAmount;
            if (LockDraftHelper.isWholeBillTrade(amount, dealAmount, draftBillStatusStr, billTrade, isDrawfail, billLogId)) {
                long newQuantity = draftBill.getLong("subbillquantity");
                long newStartflag = draftBill.getLong("subbillstartflag");
                updateOriginalSubBillRange = originalSubBillRange;
                subBillStartFlag = newStartflag;
                subBillQuantity = newQuantity;
                newDealAmount = BigDecimal.ZERO;
                udpateLockedAmount = dealAmount;
                udpateAvailableAmount = dealAmount;
                udpateUsedAmount = BigDecimal.ZERO;
            }
            if ((result = DB.update((DBRoute)DBRouteConst.TMC, (String)SQL_CANCEL_UPDATE_AMOUNT, (Object[])new Object[]{udpateLockedAmount, udpateAvailableAmount, udpateUsedAmount, newDealAmount, updateOriginalSubBillRange, subBillQuantity, subBillStartFlag, billId, usedAmount, amount, udpateAvailableAmount})) > 0) continue;
            logger.info("updateCancelDraftBill update sql fail,billId:" + billId + ",dealAmount:" + dealAmount);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u201c%s\u201d\u66f4\u65b0\u76f8\u5173\u91d1\u989d\u4e0d\u6210\u529f,\u53ef\u80fd\u5b58\u5728\u5176\u4ed6\u5355\u636e\u5360\u7528\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"LockDraftHelper_7_1", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBill.getString("draftbillno")));
        }
    }

    private static boolean isWholeBillTrade(BigDecimal amount, BigDecimal dealAmount, String draftBillStatusStr, String billTrade, boolean isDrawFail, Long billlogId) {
        List<String> specialTradeType = Arrays.asList(DraftTradeTypeEnum.REFUND.getValue(), DraftTradeTypeEnum.RLSPLEDGE.getValue(), DraftTradeTypeEnum.PAYINTEREST.getValue(), DraftTradeTypeEnum.RETRIEVE.getValue());
        if (isDrawFail && EmptyUtil.isNoEmpty((Long)billlogId)) {
            DynamicObject draftBillLog = QueryServiceHelper.queryOne((String)"cdm_draftbill_log", (String)"id,issplit", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billlogId)});
            boolean issplit = draftBillLog.getBoolean("issplit");
            return !issplit;
        }
        return amount.compareTo(dealAmount) == 0 && (!"registered".equals(draftBillStatusStr) || "registered".equals(draftBillStatusStr) && specialTradeType.contains(billTrade));
    }

    private static LockResult updateCancelDraftBillLog(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo) {
        LockResult lockResult = new LockResult();
        ArrayList<DynamicObject> updateDraftBillLogList = new ArrayList<DynamicObject>(10);
        List lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        Long sourceBillId = draftAmountLockNewInfo.getSourceBillId();
        for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoList) {
            Long billId = draftAmountLockSubInfo.getBillId();
            DynamicObject draftBill = draftBillMap.get(billId);
            BigDecimal dealAmount = draftAmountLockSubInfo.getDealAmount();
            Long billLogId = draftAmountLockSubInfo.getBillLogId();
            DynamicObject draftBillLog = TmcDataServiceHelper.loadSingle((Object)billLogId, (String)"cdm_draftbill_log");
            if (EmptyUtil.isNoEmpty((DynamicObject)draftBillLog)) {
                BigDecimal usedAmount = draftBill.getBigDecimal("usedamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("usedamount");
                BigDecimal originalsubbillamount = draftBill.getBigDecimal("originalsubbillamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("originalsubbillamount");
                BigDecimal amount = draftBill.getBigDecimal("amount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("amount");
                String originalSubBillRange = draftBill.getString("originalsubbillrang") == null ? "" : draftBill.getString("originalsubbillrang");
                BigDecimal lockedAmount = draftBill.getBigDecimal("lockedamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("lockedamount");
                BigDecimal availableAmount = draftBill.getBigDecimal("availableamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("availableamount");
                BigDecimal updateUsedAmount = usedAmount.subtract(dealAmount);
                BigDecimal newDealAmount = dealAmount;
                String updateSubbillRange = LockDraftHelper.calculateOriginalSubBillRange(originalSubBillRange, updateUsedAmount);
                String draftBillStatusStr = draftBill.getString("draftbillstatus");
                boolean isDrawfail = draftAmountLockNewInfo.isDrawfail();
                BigDecimal updateLockedAmount = lockedAmount;
                BigDecimal updateAvailableAmount = availableAmount;
                String billTrade = draftAmountLockNewInfo.getBillTrade();
                if (LockDraftHelper.isWholeBillTrade(amount, dealAmount, draftBillStatusStr, billTrade, isDrawfail, billLogId)) {
                    updateSubbillRange = originalSubBillRange;
                    newDealAmount = BigDecimal.ZERO;
                    updateUsedAmount = BigDecimal.ZERO;
                    updateLockedAmount = lockedAmount.add(dealAmount);
                    updateAvailableAmount = BigDecimal.ZERO;
                }
                BigDecimal updateAmount = amount.add(newDealAmount);
                draftBillLog.set("bizstatus", (Object)LogBizStatusEnum.PROCESS.getValue());
                draftBillLog.set("issplit", (Object)false);
                draftBillLog.set("splitedsubbillid", (Object)0L);
                draftBillLog.set("usedamount", (Object)updateUsedAmount);
                draftBillLog.set("amount", (Object)updateAmount);
                draftBillLog.set("lockedamount", (Object)updateLockedAmount);
                draftBillLog.set("availableamount", (Object)updateAvailableAmount);
                draftBillLog.set("subbillrange", (Object)updateSubbillRange);
                updateDraftBillLogList.add(draftBillLog);
            }
            LockDraftHelper.getSuccessResult(lockResult, sourceBillId, billId, billLogId);
        }
        if (!EmptyUtil.isEmpty(updateDraftBillLogList)) {
            SaveServiceHelper.update((DynamicObject[])updateDraftBillLogList.toArray(new DynamicObject[0]));
        }
        return lockResult;
    }

    private static LockResult handleDeleteBizBills(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo) {
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            LockDraftHelper.updateDeleteDraftBill(draftBillMap, draftAmountLockNewInfo);
            LockResult lockResult = LockDraftHelper.updateDeleteDraftBillLog(draftAmountLockNewInfo);
            return lockResult;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                logger.error("handleDeleteBizBills tx-> has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static LockResult handleCompleteBizBills(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo) {
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            LockDraftHelper.updateCompleteDraftBill(draftBillMap, draftAmountLockNewInfo);
            LockResult lockResult = LockDraftHelper.updateCompleteDraftBillLog(draftBillMap, draftAmountLockNewInfo);
            return lockResult;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                logger.error("handleCompleteBizBills tx-> has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static LockResult handleCancelCompleteBizBills(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo) {
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            LockDraftHelper.updateCancelCompleteDraftBill(draftBillMap, draftAmountLockNewInfo);
            LockResult lockResult = LockDraftHelper.updateCancelCompleteDraftBillLog(draftBillMap, draftAmountLockNewInfo);
            return lockResult;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                logger.error("handleCancelCompleteBizBills tx-> has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static LockResult handleRollBackDeleteBizBills(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo) {
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            LockDraftHelper.updateRollBackDeleteDraftBill(draftBillMap, draftAmountLockNewInfo);
            LockResult lockResult = LockDraftHelper.updateRollBackDeleteDraftBillLog(draftBillMap, draftAmountLockNewInfo);
            return lockResult;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                logger.error("handleRollBackDeleteBizBills tx-> has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static void updateDeleteDraftBill(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo) {
        List lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        Long sourceBillId = draftAmountLockNewInfo.getSourceBillId();
        for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoList) {
            int result;
            Long billId = draftAmountLockSubInfo.getBillId();
            boolean changeRelease = draftAmountLockSubInfo.isChangeRelease();
            if (!EmptyUtil.isNoEmpty((Long)billId) || !EmptyUtil.isNoEmpty((Long)sourceBillId)) continue;
            QFilter qFilter = new QFilter("sourcebillid", "=", (Object)sourceBillId);
            qFilter.and("draftid", "=", (Object)billId);
            qFilter.and("deleteflag", "=", (Object)Character.valueOf('0'));
            qFilter.and("issplit", "=", (Object)Character.valueOf('0'));
            DynamicObjectCollection draftBillLogs = QueryServiceHelper.query((String)"cdm_draftbill_log", (String)"id", (QFilter[])qFilter.toArray());
            if (EmptyUtil.isEmpty((DynamicObjectCollection)draftBillLogs) && changeRelease) {
                QFilter qFilterNew = new QFilter("draftid", "=", (Object)billId);
                qFilterNew.and("deleteflag", "=", (Object)Character.valueOf('0'));
                draftBillLogs = QueryServiceHelper.query((String)"cdm_draftbill_log", (String)"id", (QFilter[])qFilterNew.toArray());
            }
            if (EmptyUtil.isEmpty((DynamicObjectCollection)draftBillLogs)) continue;
            DynamicObject draftBill = draftBillMap.get(billId);
            BigDecimal dealAmount = draftAmountLockSubInfo.getDealAmount();
            BigDecimal availableAmount = draftBill.getBigDecimal("availableamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("availableamount");
            BigDecimal lockedAmount = draftBill.getBigDecimal("lockedamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("lockedamount");
            BigDecimal updateAvailableAmount = availableAmount.add(dealAmount);
            BigDecimal updateLockedAmount = lockedAmount.subtract(dealAmount);
            logger.error("updateFinishDraftBill update sql fail,billId:" + billId + ",lockedAmount:" + lockedAmount);
            if (lockedAmount.compareTo(BigDecimal.ZERO) <= 0 || (result = DB.update((DBRoute)DBRouteConst.TMC, (String)SQL_DELETE_UPDATE_AMOUNT, (Object[])new Object[]{dealAmount, dealAmount, billId, lockedAmount, availableAmount, dealAmount})) > 0) continue;
            logger.info("updateDeleteDraftBill update sql fail,billId:" + billId + ",dealAmount:" + dealAmount);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u201c%1$s\u201d\u66f4\u65b0\u76f8\u5173\u91d1\u989d\u4e0d\u6210\u529f\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"LockDraftHelper_7", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBill.getString("draftbillno")));
        }
    }

    private static LockResult updateDeleteDraftBillLog(DraftLockInfo draftAmountLockNewInfo) {
        LockResult lockResult = new LockResult();
        ArrayList<DynamicObject> updateDraftBillLogList = new ArrayList<DynamicObject>(10);
        List lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        Long sourceBillId = draftAmountLockNewInfo.getSourceBillId();
        for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoList) {
            Long billId = draftAmountLockSubInfo.getBillId();
            Long billLogId = draftAmountLockSubInfo.getBillLogId();
            boolean changeRelease = draftAmountLockSubInfo.isChangeRelease();
            if (!EmptyUtil.isNoEmpty((Long)billId) || !EmptyUtil.isNoEmpty((Long)sourceBillId)) continue;
            QFilter qFilter = new QFilter("sourcebillid", "=", (Object)sourceBillId);
            qFilter.and("draftid", "=", (Object)billId);
            qFilter.and("deleteflag", "=", (Object)Character.valueOf('0'));
            Object[] draftBillLogs = TmcDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id", (QFilter[])qFilter.toArray());
            if (EmptyUtil.isEmpty((Object[])draftBillLogs) && changeRelease) {
                QFilter qFilterNew = new QFilter("draftid", "=", (Object)billId);
                qFilterNew.and("deleteflag", "=", (Object)Character.valueOf('0'));
                draftBillLogs = TmcDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id", (QFilter[])qFilterNew.toArray());
            }
            if (EmptyUtil.isEmpty((Object[])draftBillLogs)) continue;
            DynamicObject draftBillLog = TmcDataServiceHelper.loadSingle((Object)billLogId, (String)"cdm_draftbill_log");
            if (EmptyUtil.isNoEmpty((DynamicObject)draftBillLog)) {
                draftBillLog.set("deleteflag", (Object)true);
                updateDraftBillLogList.add(draftBillLog);
            }
            LockDraftHelper.getSuccessResult(lockResult, sourceBillId, billId, billLogId);
        }
        if (!EmptyUtil.isEmpty(updateDraftBillLogList)) {
            SaveServiceHelper.update((DynamicObject[])updateDraftBillLogList.toArray(new DynamicObject[0]));
        }
        return lockResult;
    }

    private static void updateCompleteDraftBill(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo) {
        List lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        Long sourceBillId = draftAmountLockNewInfo.getSourceBillId();
        List billLogIds = lockSubInfoList.stream().map(item -> item.getBillLogId()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", billLogIds);
        qFilter.and("deleteflag", "=", (Object)Character.valueOf('0'));
        DynamicObject[] draftBillLogs = TmcDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,bizstatus", (QFilter[])qFilter.toArray());
        Map draftBillLogsMap = Arrays.stream(draftBillLogs).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
        if (!EmptyUtil.isEmpty((Object)draftBillLogsMap) && draftBillLogsMap.size() > 0) {
            for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoList) {
                int result;
                Long billId = draftAmountLockSubInfo.getBillId();
                Long billLogId = draftAmountLockSubInfo.getBillLogId();
                DynamicObject draftBillLog = (DynamicObject)draftBillLogsMap.get(billLogId);
                if (EmptyUtil.isEmpty((DynamicObject)draftBillLog) || StringUtils.equals((CharSequence)draftBillLog.getString("bizstatus"), (CharSequence)LogBizStatusEnum.SUCCESS.getValue())) continue;
                DynamicObject draftBill = draftBillMap.get(billId);
                BigDecimal dealAmount = draftAmountLockSubInfo.getDealAmount();
                BigDecimal availableAmount = draftBill.getBigDecimal("availableamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("availableamount");
                BigDecimal lockedAmount = draftBill.getBigDecimal("lockedamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("lockedamount");
                BigDecimal updateAvailableAmount = availableAmount.add(dealAmount);
                BigDecimal updateLockedAmount = lockedAmount.subtract(dealAmount);
                logger.error("updateFinishDraftBill update sql fail,billId:" + billId + ",lockedAmount:" + lockedAmount);
                if (lockedAmount.compareTo(BigDecimal.ZERO) <= 0 || (result = DB.update((DBRoute)DBRouteConst.TMC, (String)SQL_DELETE_UPDATE_AMOUNT, (Object[])new Object[]{dealAmount, dealAmount, billId, lockedAmount, availableAmount, dealAmount})) > 0) continue;
                logger.info("updateCompleteDraftBill update sql fail,billId:" + billId + ",dealAmount:" + dealAmount);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u201c%1$s\u201d\u66f4\u65b0\u76f8\u5173\u91d1\u989d\u4e0d\u6210\u529f\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"LockDraftHelper_7", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBill.getString("draftbillno")));
            }
        }
    }

    private static LockResult updateCompleteDraftBillLog(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo) {
        LockResult lockResult = new LockResult();
        ArrayList<DynamicObject> updateDraftBillLogList = new ArrayList<DynamicObject>(10);
        List lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        Long sourceBillId = draftAmountLockNewInfo.getSourceBillId();
        List billLogIds = lockSubInfoList.stream().map(item -> item.getBillLogId()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", billLogIds);
        qFilter.and("deleteflag", "=", (Object)Character.valueOf('0'));
        DynamicObject[] draftBillLogs = TmcDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,bizstatus,lockedamount,availableamount", (QFilter[])qFilter.toArray());
        Map draftBillLogsMap = Arrays.stream(draftBillLogs).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
        if (!EmptyUtil.isEmpty((Object)draftBillLogsMap) && draftBillLogsMap.size() > 0) {
            for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoList) {
                Long billId = draftAmountLockSubInfo.getBillId();
                Long billLogId = draftAmountLockSubInfo.getBillLogId();
                DynamicObject draftBillLog = (DynamicObject)draftBillLogsMap.get(billLogId);
                if (EmptyUtil.isNoEmpty((DynamicObject)draftBillLog) && !StringUtils.equals((CharSequence)draftBillLog.getString("bizstatus"), (CharSequence)LogBizStatusEnum.SUCCESS.getValue())) {
                    DynamicObject draftBill = draftBillMap.get(billId);
                    BigDecimal dealAmount = draftAmountLockSubInfo.getDealAmount();
                    BigDecimal availableAmount = draftBill.getBigDecimal("availableamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("availableamount");
                    BigDecimal lockedAmount = draftBill.getBigDecimal("lockedamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("lockedamount");
                    BigDecimal updateAvailableAmount = availableAmount.add(dealAmount);
                    BigDecimal updateLockedAmount = lockedAmount.subtract(dealAmount);
                    draftBillLog.set("lockedamount", (Object)updateLockedAmount);
                    draftBillLog.set("availableamount", (Object)updateAvailableAmount);
                    draftBillLog.set("bizstatus", (Object)LogBizStatusEnum.SUCCESS.getValue());
                    updateDraftBillLogList.add(draftBillLog);
                }
                LockDraftHelper.getSuccessResult(lockResult, sourceBillId, billId, billLogId);
            }
        }
        if (!EmptyUtil.isEmpty(updateDraftBillLogList)) {
            SaveServiceHelper.update((DynamicObject[])updateDraftBillLogList.toArray(new DynamicObject[0]));
        }
        return lockResult;
    }

    private static void updateCancelCompleteDraftBill(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo) {
        List lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        Long sourceBillId = draftAmountLockNewInfo.getSourceBillId();
        List billLogIds = lockSubInfoList.stream().map(item -> item.getBillLogId()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", billLogIds);
        qFilter.and("deleteflag", "=", (Object)Character.valueOf('0'));
        DynamicObject[] draftBillLogs = TmcDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id", (QFilter[])qFilter.toArray());
        Map draftBillLogsMap = Arrays.stream(draftBillLogs).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
        if (!EmptyUtil.isEmpty((Object)draftBillLogsMap) && draftBillLogsMap.size() > 0) {
            for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoList) {
                Long billId = draftAmountLockSubInfo.getBillId();
                Long billLogId = draftAmountLockSubInfo.getBillLogId();
                DynamicObject draftBillLog = (DynamicObject)draftBillLogsMap.get(billLogId);
                if (EmptyUtil.isEmpty((DynamicObject)draftBillLog)) continue;
                DynamicObject draftBill = draftBillMap.get(billId);
                BigDecimal dealAmount = draftAmountLockSubInfo.getDealAmount();
                BigDecimal availableAmount = draftBill.getBigDecimal("availableamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("availableamount");
                BigDecimal lockedAmount = draftBill.getBigDecimal("lockedamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("lockedamount");
                BigDecimal updateAvailableAmount = availableAmount.subtract(dealAmount);
                BigDecimal updateLockedAmount = lockedAmount.add(dealAmount);
                int result = DB.update((DBRoute)DBRouteConst.TMC, (String)SQL_UPDATE_AMOUNT, (Object[])new Object[]{dealAmount, dealAmount, billId, availableAmount, lockedAmount, dealAmount});
                if (result > 0) continue;
                logger.info("updateCancelCompleteDraftBill update sql fail,billId:" + billId + ",dealAmount:" + dealAmount);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u201c%s\u201d\u66f4\u65b0\u76f8\u5173\u91d1\u989d\u4e0d\u6210\u529f,\u53ef\u80fd\u5b58\u5728\u5176\u4ed6\u5355\u636e\u5360\u7528\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"LockDraftHelper_7_1", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBill.getString("draftbillno")));
            }
        }
    }

    private static LockResult updateCancelCompleteDraftBillLog(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo) {
        LockResult lockResult = new LockResult();
        ArrayList<DynamicObject> updateDraftBillLogList = new ArrayList<DynamicObject>(10);
        List lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        Long sourceBillId = draftAmountLockNewInfo.getSourceBillId();
        List billLogIds = lockSubInfoList.stream().map(item -> item.getBillLogId()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", billLogIds);
        qFilter.and("deleteflag", "=", (Object)Character.valueOf('0'));
        DynamicObject[] draftBillLogs = TmcDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,bizstatus,lockedamount,availableamount", (QFilter[])qFilter.toArray());
        Map draftBillLogsMap = Arrays.stream(draftBillLogs).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
        if (!EmptyUtil.isEmpty((Object)draftBillLogsMap) && draftBillLogsMap.size() > 0) {
            for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoList) {
                Long billId = draftAmountLockSubInfo.getBillId();
                Long billLogId = draftAmountLockSubInfo.getBillLogId();
                DynamicObject draftBillLog = (DynamicObject)draftBillLogsMap.get(billLogId);
                if (EmptyUtil.isNoEmpty((DynamicObject)draftBillLog)) {
                    DynamicObject draftBill = draftBillMap.get(billId);
                    BigDecimal dealAmount = draftAmountLockSubInfo.getDealAmount();
                    BigDecimal availableAmount = draftBill.getBigDecimal("availableamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("availableamount");
                    BigDecimal lockedAmount = draftBill.getBigDecimal("lockedamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("lockedamount");
                    BigDecimal updateAvailableAmount = availableAmount.subtract(dealAmount);
                    BigDecimal updateLockedAmount = lockedAmount.add(dealAmount);
                    draftBillLog.set("lockedamount", (Object)updateLockedAmount);
                    draftBillLog.set("availableamount", (Object)updateAvailableAmount);
                    draftBillLog.set("bizstatus", (Object)LogBizStatusEnum.PROCESS.getValue());
                    updateDraftBillLogList.add(draftBillLog);
                }
                LockDraftHelper.getSuccessResult(lockResult, sourceBillId, billId, billLogId);
            }
        }
        if (!EmptyUtil.isEmpty(updateDraftBillLogList)) {
            SaveServiceHelper.update((DynamicObject[])updateDraftBillLogList.toArray(new DynamicObject[0]));
        }
        return lockResult;
    }

    private static void updateRollBackDeleteDraftBill(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo) {
        List lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        Long sourceBillId = draftAmountLockNewInfo.getSourceBillId();
        List billLogIds = lockSubInfoList.stream().map(item -> item.getBillLogId()).collect(Collectors.toList());
        List billIds = lockSubInfoList.stream().map(item -> item.getBillId()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("sourcebillid", "=", (Object)sourceBillId);
        qFilter.and("draftid", "in", billIds);
        qFilter.and("deleteflag", "=", (Object)Character.valueOf('0'));
        DynamicObject[] draftBillLogs = TmcDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id", (QFilter[])qFilter.toArray());
        Map draftBillLogsMap = Arrays.stream(draftBillLogs).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
        if (!EmptyUtil.isEmpty((Object)draftBillLogsMap) && draftBillLogsMap.size() > 0) {
            for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoList) {
                Long billId = draftAmountLockSubInfo.getBillId();
                Long billLogId = draftAmountLockSubInfo.getBillLogId();
                DynamicObject draftBillLog = (DynamicObject)draftBillLogsMap.get(billLogId);
                if (EmptyUtil.isEmpty((DynamicObject)draftBillLog)) continue;
                DynamicObject draftBill = draftBillMap.get(billId);
                BigDecimal dealAmount = draftAmountLockSubInfo.getDealAmount();
                BigDecimal availableAmount = draftBill.getBigDecimal("availableamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("availableamount");
                BigDecimal lockedAmount = draftBill.getBigDecimal("lockedamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("lockedamount");
                BigDecimal updateAvailableAmount = availableAmount.subtract(dealAmount);
                BigDecimal updateLockedAmount = lockedAmount.add(dealAmount);
                int result = DB.update((DBRoute)DBRouteConst.TMC, (String)SQL_UPDATE_AMOUNT, (Object[])new Object[]{dealAmount, dealAmount, billId, availableAmount, lockedAmount, dealAmount});
                if (result > 0) continue;
                logger.info("updateRollBackDeleteDraftBill update sql fail,billId:" + billId + ",dealAmount:" + dealAmount);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u201c%s\u201d\u66f4\u65b0\u76f8\u5173\u91d1\u989d\u4e0d\u6210\u529f,\u53ef\u80fd\u5b58\u5728\u5176\u4ed6\u5355\u636e\u5360\u7528\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"LockDraftHelper_7_1", (String)"tmc-cdm-business", (Object[])new Object[0]), draftBill.getString("draftbillno")));
            }
        }
    }

    private static LockResult updateRollBackDeleteDraftBillLog(HashMap<Long, DynamicObject> draftBillMap, DraftLockInfo draftAmountLockNewInfo) {
        LockResult lockResult = new LockResult();
        ArrayList<DynamicObject> updateDraftBillLogList = new ArrayList<DynamicObject>(10);
        List lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
        Long sourceBillId = draftAmountLockNewInfo.getSourceBillId();
        List billLogIds = lockSubInfoList.stream().map(item -> item.getBillLogId()).collect(Collectors.toList());
        List billIds = lockSubInfoList.stream().map(item -> item.getBillId()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("sourcebillid", "=", (Object)sourceBillId);
        qFilter.and("draftid", "in", billIds);
        qFilter.and("deleteflag", "=", (Object)Character.valueOf('0'));
        DynamicObject[] draftBillLogs = TmcDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,bizstatus,lockedamount,availableamount,deleteflag", (QFilter[])qFilter.toArray());
        Map draftBillLogsMap = Arrays.stream(draftBillLogs).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
        if (!EmptyUtil.isEmpty((Object)draftBillLogsMap) && draftBillLogsMap.size() > 0) {
            for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoList) {
                Long billId = draftAmountLockSubInfo.getBillId();
                Long billLogId = draftAmountLockSubInfo.getBillLogId();
                DynamicObject draftBillLog = (DynamicObject)draftBillLogsMap.get(billLogId);
                if (EmptyUtil.isNoEmpty((DynamicObject)draftBillLog)) {
                    DynamicObject draftBill = draftBillMap.get(billId);
                    BigDecimal dealAmount = draftAmountLockSubInfo.getDealAmount();
                    BigDecimal availableAmount = draftBill.getBigDecimal("availableamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("availableamount");
                    BigDecimal lockedAmount = draftBill.getBigDecimal("lockedamount") == null ? BigDecimal.ZERO : draftBill.getBigDecimal("lockedamount");
                    BigDecimal updateAvailableAmount = availableAmount.subtract(dealAmount);
                    BigDecimal updateLockedAmount = lockedAmount.add(dealAmount);
                    draftBillLog.set("lockedamount", (Object)updateLockedAmount);
                    draftBillLog.set("availableamount", (Object)updateAvailableAmount);
                    draftBillLog.set("bizstatus", (Object)LogBizStatusEnum.PROCESS.getValue());
                    draftBillLog.set("deleteflag", (Object)false);
                    updateDraftBillLogList.add(draftBillLog);
                }
                LockDraftHelper.getSuccessResult(lockResult, sourceBillId, billId, billLogId);
            }
        }
        if (!EmptyUtil.isEmpty(updateDraftBillLogList)) {
            SaveServiceHelper.update((DynamicObject[])updateDraftBillLogList.toArray(new DynamicObject[0]));
        }
        return lockResult;
    }

    private static String getErrorMsg(List<DynamicObject> failOpDrafts) {
        logger.info(String.format("\u83b7\u53d6\u9501\u5b9a\u7968\u636e\u5931\u8d25\u4fe1\u606f,failOpDrafts-size:%s", failOpDrafts.size()));
        StringBuilder errorMsg = new StringBuilder();
        Map<String, List<DynamicObject>> draftMap = failOpDrafts.stream().collect(Collectors.groupingBy(o -> o.getString("locksourcebilltype")));
        logger.info(String.format("\u83b7\u53d6\u9501\u5b9a\u7968\u636e\u5931\u8d25\u4fe1\u606f,draftMap-size:%s", draftMap.size()));
        HashMap lockBillMap = new HashMap(16);
        for (Map.Entry<String, List<DynamicObject>> entrySet : draftMap.entrySet()) {
            String key = entrySet.getKey();
            List<DynamicObject> value = entrySet.getValue();
            logger.info(String.format("\u83b7\u53d6\u9501\u5b9a\u7968\u636e\u5931\u8d25\u4fe1\u606f,draftMap-key:%s,value:%s", key, value.size()));
            List ids = value.stream().map(o -> o.getString("locksourcebillid")).filter(EmptyUtil::isNoEmpty).map(Long::valueOf).collect(Collectors.toList());
            logger.info(String.format("\u83b7\u53d6\u9501\u5b9a\u7968\u636e\u5931\u8d25\u4fe1\u606f,ids:%s", JSON.toJSONString(ids)));
            if (EmptyUtil.isNoEmpty((String)key)) {
                DynamicObject[] lockBills = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)key));
                BusinessDataServiceHelper.load((String)key, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                Stream.of(lockBills).forEach(temp -> lockBillMap.put(key + temp.getString("id"), temp));
            }
            for (DynamicObject failOpDraft : failOpDrafts) {
                String lockSourceBillType = failOpDraft.getString("locksourcebilltype");
                String lockSourceBillId = failOpDraft.getString("locksourcebillid");
                DynamicObject lockBill = (DynamicObject)lockBillMap.get(lockSourceBillType + lockSourceBillId);
                if (null == lockBill) {
                    errorMsg.append(String.format(ResManager.loadKDString((String)"\u7968\u636e\u201c%1$s\u201d\u5df2\u88ab\u5360\u7528\uff0c\u88ab\u5360\u7528\u5355\u636e\u5df2\u88ab\u5220\u9664\u3002", (String)"LockDraftHelper_3", (String)"tmc-cdm-business", (Object[])new Object[0]), failOpDraft.getString("draftbillno")));
                    continue;
                }
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7968\u636e\u3010%1$s\u3011\u88ab\u3010%2$s\u3011\u5360\u7528\u3002", (String)"LockDraftHelper_1", (String)"tmc-cdm-business", (Object[])new Object[0]), failOpDraft.getString("draftbillno"), lockBill.getString("billno")));
            }
            if (errorMsg.length() <= 0) continue;
            errorMsg.append(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u7968\u636e\u8fdb\u884c\u63d0\u4ea4", (String)"LockDraftHelper_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        logger.info(String.format("\u83b7\u53d6\u9501\u5b9a\u7968\u636e\u5931\u8d25\u4fe1\u606f,msg:%s", errorMsg));
        return errorMsg.toString();
    }

    public static Boolean draftIsQuoteCas(Long draftId) {
        QFilter filter = new QFilter("draftbill.fbasedataid", "in", (Object)draftId);
        QFilter filter1 = new QFilter("billstatus", "=", (Object)BillStatusEnum.PAYED.getValue());
        Object[] objs = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id", (QFilter[])new QFilter[]{filter, filter1});
        if (EmptyUtil.isNoEmpty((Object[])objs) && objs.length > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean draftIsQuoteRec(Long draftId) {
        QFilter filter = new QFilter("draftbill.fbasedataid.id", "=", (Object)draftId);
        filter.and("billstatus", "!=", (Object)BillStatusEnum.PAYED.getValue());
        if (TmcDataServiceHelper.exists((String)"cas_recbill", (QFilter[])new QFilter[]{filter})) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String draftIsQuoteCasBill(List<Long> draftId, long companyid, long drafttradeId) {
        logger.info("draftIsQuoteCasBill companyid:" + companyid + ",drafttradeId:" + drafttradeId);
        QFilter filter = new QFilter("draftbill.fbasedataid.id", "in", draftId);
        filter.and("sourcebilltype", "!=", (Object)"cdm_drafttradebill");
        filter.and("sourcebillid", "!=", (Object)drafttradeId);
        if (QueryServiceHelper.exists((String)"cas_paybill", (QFilter[])new QFilter[]{filter})) {
            return ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355", (String)"LockDraftHelper_10", (String)"tmc-cdm-business", (Object[])new Object[0]);
        }
        if (QueryServiceHelper.exists((String)"cas_recbill", (QFilter[])new QFilter[]{filter, new QFilter("org", "=", (Object)companyid)})) {
            return ResManager.loadKDString((String)"\u6536\u6b3e\u5355", (String)"LockDraftHelper_11", (String)"tmc-cdm-business", (Object[])new Object[0]);
        }
        QFilter filterPayApply = new QFilter("cas_payinfo.entry_draftbill.fbasedataid.id", "in", draftId);
        if (QueryServiceHelper.exists((String)"cas_payapplybill", (QFilter[])new QFilter[]{filterPayApply})) {
            return ResManager.loadKDString((String)"\u8d44\u91d1\u652f\u4ed8\u7533\u8bf7\u5355", (String)"LockDraftHelper_12", (String)"tmc-cdm-business", (Object[])new Object[0]);
        }
        QFilter filterPsd = new QFilter("draftno.fbasedataid.id", "in", draftId);
        filterPsd.and("company", "=", (Object)companyid);
        if (QueryServiceHelper.exists((String)"psd_schedulebill", (QFilter[])new QFilter[]{filterPsd})) {
            return ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355", (String)"LockDraftHelper_13", (String)"tmc-cdm-business", (Object[])new Object[0]);
        }
        return "";
    }

    public static Set<Long> draftIsQuoteRecs(Set<Long> draftIds) {
        QFilter filter = new QFilter("draftbill.fbasedataid.id", "in", draftIds);
        filter.and("billstatus", "!=", (Object)BillStatusEnum.PAYED.getValue());
        Object[] payBills = TmcDataServiceHelper.load((String)"cas_recbill", (String)"draftbill.fbasedataid.id", (QFilter[])new QFilter[]{filter});
        HashSet<Long> exsitPaySet = new HashSet<Long>(8);
        if (EmptyUtil.isNoEmpty((Object[])payBills)) {
            for (Object payBill : payBills) {
                DynamicObjectCollection draftbills = payBill.getDynamicObjectCollection("draftbill");
                for (DynamicObject draftbill : draftbills) {
                    exsitPaySet.add(draftbill.getLong("fbasedataid.id"));
                }
            }
        }
        return exsitPaySet;
    }

    public static Boolean draftDtIsQuoteCas(DynamicObject draft) {
        Long draftId = draft.getLong("id");
        String source = draft.getString("source");
        if ("cas".equals(source)) {
            return Boolean.FALSE;
        }
        return LockDraftHelper.draftIsQuoteCas(draftId);
    }

    public static Boolean draftDtIsQuoteRec(DynamicObject draft) {
        Long draftId = draft.getLong("id");
        String source = draft.getString("source");
        if ("cas".equals(source)) {
            return Boolean.FALSE;
        }
        return LockDraftHelper.draftIsQuoteRec(draftId);
    }

    public static Long findBillLogIdFromResult(List<LockResult> lockResults, Long draftBillId, Long bizBillId) {
        Long billLogId = null;
        for (LockResult lockResult : lockResults) {
            boolean isSuccess = lockResult.isSuccess();
            if (!isSuccess || lockResult.getSourceBillId().longValue() != bizBillId.longValue()) continue;
            Map<Long, Long> billIdLogIdMap = lockResult.getBillIdLogIdMap();
            billLogId = billIdLogIdMap.get(draftBillId);
            return billLogId;
        }
        return billLogId;
    }

    public static Map<String, String> getParamType(String dataTypeStr) {
        HashMap<String, String> billParamMap = new HashMap<String, String>();
        switch (dataTypeStr) {
            case "cdm_pledge_apply": 
            case "cdm_discount_apply": 
            case "cdm_drafttradebill": {
                billParamMap.put("entry", "entrys");
                billParamMap.put("draftbill", "draftbill");
                billParamMap.put("billlog", "billlogid");
                break;
            }
            case "cdm_draftallocation": 
            case "cdm_billpoolbiz": {
                billParamMap.put("entry", "entryentity");
                billParamMap.put("draftbill", "e_draftbill");
                billParamMap.put("billlog", "draftbilllogid");
            }
        }
        return billParamMap;
    }

    public static void reCallAddLog(DynamicObject data) {
        String draftBillTranstatus = data.getString("draftbilltranstatus");
        Boolean isRepayGen = data.getBoolean("isrepaygen");
        DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
        Set billLogIdSet = entrys.stream().map(e -> e.getLong("billlogid")).collect(Collectors.toSet());
        Object[] billLogIdArr = TmcDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,bizstatus,issplit,draftid", (QFilter[])new QFilter[]{new QFilter("id", "in", billLogIdSet), new QFilter("bizstatus", "=", (Object)"fail"), new QFilter("issplit", "=", (Object)"1")});
        HashSet needRegenBIllLogBillSet = new HashSet();
        if (EmptyUtil.isNoEmpty((Object[])billLogIdArr)) {
            Set draftidSet = Arrays.stream(billLogIdArr).map(e -> e.getLong("draftid")).collect(Collectors.toSet());
            needRegenBIllLogBillSet.addAll(draftidSet);
        }
        if ("failing".equals(draftBillTranstatus) || isRepayGen.booleanValue() || EmptyUtil.isNoEmpty(needRegenBIllLogBillSet)) {
            String tradeType = data.getString("tradetype");
            ArrayList<DraftLockInfo> saveDraftAmountLockInfos = new ArrayList<DraftLockInfo>(10);
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            draftLockInfo.setSourceBillType(data.getDataEntityType().getName());
            draftLockInfo.setBizBillNo(data.getString("billno"));
            draftLockInfo.setSourceBillId(Long.valueOf(data.getLong("id")));
            ArrayList<DraftAmountLockSubInfo> draftAmountLockInfolist = new ArrayList<DraftAmountLockSubInfo>(8);
            for (DynamicObject entry : entrys) {
                long draftBillId = entry.getDynamicObject("draftbill").getLong("id");
                if (!needRegenBIllLogBillSet.contains(draftBillId)) continue;
                DraftAmountLockSubInfo draftAmountLockInfo = new DraftAmountLockSubInfo();
                draftAmountLockInfo.setBillId(draftBillId);
                BigDecimal dealAmount = entry.getBigDecimal("billamt");
                draftAmountLockInfo.setDealAmount(dealAmount);
                long billLogId = entry.getLong("billlogid");
                draftAmountLockInfo.setBillLogId(billLogId);
                draftAmountLockInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                draftAmountLockInfo.setBillTrade(tradeType);
                draftAmountLockInfo.setReGenerate(true);
                draftAmountLockInfolist.add(draftAmountLockInfo);
            }
            if (EmptyUtil.isNoEmpty(draftAmountLockInfolist)) {
                draftLockInfo.getLockSubInfoList().addAll(draftAmountLockInfolist);
                saveDraftAmountLockInfos.add(draftLockInfo);
                logger.info("PledgeApplySaveService lockBillsByLog is start," + JSON.toJSONString(saveDraftAmountLockInfos));
                LockDraftHelper.lockBills(saveDraftAmountLockInfos, true);
                logger.info("PledgeApplySaveService lockBillsByLog is end,");
            }
        }
    }

    public static void checkHasFail(List<LockResult> lockResultList) {
        List failLockResultList;
        if (EmptyUtil.isNoEmpty(lockResultList) && EmptyUtil.isNoEmpty(failLockResultList = lockResultList.stream().filter(e -> EmptyUtil.isNoEmpty((Long)e.getSourceBillId()) && !e.isSuccess()).collect(Collectors.toList()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5360\u7528\u66f4\u65b0\u65e5\u5fd7\u5931\u8d25\u3002", (String)"LockDraftHelper_9", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
    }

    public static List<DraftLockInfo> getAllocateLockAndReleaseInfo(DynamicObject[] dataEntities) {
        ArrayList<DraftLockInfo> lockAndReleaseInfoList = new ArrayList<DraftLockInfo>(8);
        DynamicObjectType dynamicObjectType = dataEntities[0].getDynamicObjectType();
        String sourceBillTypeStr = dynamicObjectType.getName();
        Set tradeBillIdSet = Arrays.stream(dataEntities).map(e -> e.getLong("id")).collect(Collectors.toSet());
        Object[] tradeBillDyArr = TmcDataServiceHelper.load((Object[])tradeBillIdSet.toArray(), (DynamicObjectType)dynamicObjectType);
        Map<Object, Object> tradeBillIdAndDyMap = new HashMap(8);
        if (EmptyUtil.isNoEmpty((Object[])tradeBillDyArr)) {
            tradeBillIdAndDyMap = Arrays.stream(tradeBillDyArr).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        }
        for (DynamicObject data : dataEntities) {
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            String bizType = data.getString("biztype");
            long tradeBillId = data.getLong("id");
            String billNoStr = data.getString("billno");
            draftLockInfo.setBillTrade(bizType);
            draftLockInfo.setSourceBillId(Long.valueOf(tradeBillId));
            draftLockInfo.setSourceBillType(sourceBillTypeStr);
            draftLockInfo.setBizBillNo(billNoStr);
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("entryentity");
            List lockDraftIds = entrys.stream().map(v -> v.getDynamicObject("e_draftbill").getLong("id")).collect(Collectors.toList());
            HashMap draftIdDealAmountMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("e_draftbill").getLong("id"), o -> o.getBigDecimal("e_subbillamt"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdLogIdMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("e_draftbill").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
            ArrayList<DraftAmountLockSubInfo> lockSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
            for (Long lockDraftId : lockDraftIds) {
                DraftAmountLockSubInfo draftAmountLockSubInfo = new DraftAmountLockSubInfo();
                draftAmountLockSubInfo.setBillId(lockDraftId);
                Long billLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                draftAmountLockSubInfo.setBillLogId(billLogId);
                BigDecimal dealAmount = draftIdDealAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(lockDraftId);
                draftAmountLockSubInfo.setDealAmount(dealAmount);
                draftAmountLockSubInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                draftAmountLockSubInfo.setBillTrade(bizType);
                lockSubInfoList.add(draftAmountLockSubInfo);
            }
            draftLockInfo.getLockSubInfoList().addAll(lockSubInfoList);
            DynamicObject tradeBillDB = (DynamicObject)tradeBillIdAndDyMap.get(tradeBillId);
            if (EmptyUtil.isNoEmpty((DynamicObject)tradeBillDB)) {
                DynamicObjectCollection entrysDB = tradeBillDB.getDynamicObjectCollection("entryentity");
                List lockDraftIdsDB = entrysDB.stream().map(v -> v.getDynamicObject("e_draftbill").getLong("id")).collect(Collectors.toList());
                HashMap draftIdDealAmountMapDB = entrysDB.stream().collect(Collectors.toMap(v -> v.getDynamicObject("e_draftbill").getLong("id"), o -> o.getBigDecimal("e_subbillamt"), (o1, o2) -> o1, HashMap::new));
                HashMap draftIdLogIdMapDB = entrysDB.stream().collect(Collectors.toMap(v -> v.getDynamicObject("e_draftbill").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
                ArrayList<DraftAmountLockSubInfo> releaseSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
                for (Long lockDraftIdDB : lockDraftIdsDB) {
                    if (lockDraftIds.contains(lockDraftIdDB)) continue;
                    DraftAmountLockSubInfo draftAmountreleaseSubInfo = new DraftAmountLockSubInfo();
                    draftAmountreleaseSubInfo.setBillId(lockDraftIdDB);
                    Long draftLogId = draftIdLogIdMapDB.get(lockDraftIdDB) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMapDB.get(lockDraftIdDB);
                    draftAmountreleaseSubInfo.setBillLogId(draftLogId);
                    BigDecimal dealAmount = draftIdDealAmountMapDB.get(lockDraftIdDB) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMapDB.get(lockDraftIdDB);
                    draftAmountreleaseSubInfo.setDealAmount(dealAmount);
                    draftAmountreleaseSubInfo.setOperateType(OperateTypeEnum.DELETE.getValue());
                    draftAmountreleaseSubInfo.setBillTrade(bizType);
                    releaseSubInfoList.add(draftAmountreleaseSubInfo);
                }
                draftLockInfo.getLockSubInfoList().addAll(releaseSubInfoList);
            }
            lockAndReleaseInfoList.add(draftLockInfo);
        }
        return lockAndReleaseInfoList;
    }

    public static List<DraftLockInfo> getPoolLockAndReleaseInfo(DynamicObject[] dataEntities, boolean autoAllocation, Map<Long, DynamicObject> draftIdAndEntryMap) {
        ArrayList<DraftLockInfo> lockAndReleaseInfoList = new ArrayList<DraftLockInfo>(8);
        DynamicObjectType dynamicObjectType = dataEntities[0].getDynamicObjectType();
        String sourceBillTypeStr = dynamicObjectType.getName();
        Set tradeBillIdSet = Arrays.stream(dataEntities).map(e -> e.getLong("id")).collect(Collectors.toSet());
        Object[] tradeBillDyArr = TmcDataServiceHelper.load((Object[])tradeBillIdSet.toArray(), (DynamicObjectType)dynamicObjectType);
        Map<Object, Object> tradeBillIdAndDyMap = new HashMap(8);
        if (EmptyUtil.isNoEmpty((Object[])tradeBillDyArr)) {
            tradeBillIdAndDyMap = Arrays.stream(tradeBillDyArr).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        }
        for (DynamicObject data : dataEntities) {
            DynamicObject tradeBillDB;
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            long tradeBillId = data.getLong("id");
            String billNoStr = data.getString("billno");
            String bussinessType = data.getString("businesstype");
            bussinessType = "join".equals(bussinessType) ? "intopool" : "outpool";
            draftLockInfo.setBillTrade(bussinessType);
            draftLockInfo.setSourceBillId(Long.valueOf(tradeBillId));
            draftLockInfo.setSourceBillType(sourceBillTypeStr);
            draftLockInfo.setBizBillNo(billNoStr);
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("entryentity");
            List lockDraftIds = entrys.stream().map(v -> v.getDynamicObject("e_draftbill").getLong("id")).collect(Collectors.toList());
            HashMap draftIdDealAmountMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("e_draftbill").getLong("id"), o -> o.getBigDecimal("e_billamt"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdLogIdMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("e_draftbill").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
            ArrayList<DraftAmountLockSubInfo> lockSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
            for (Long lockDraftId : lockDraftIds) {
                DynamicObject allocBillEntry;
                if (autoAllocation && EmptyUtil.isNoEmpty((DynamicObject)(allocBillEntry = draftIdAndEntryMap.get(lockDraftId)))) continue;
                DraftAmountLockSubInfo draftAmountLockSubInfo = new DraftAmountLockSubInfo();
                draftAmountLockSubInfo.setBillId(lockDraftId);
                Long billLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                draftAmountLockSubInfo.setBillLogId(billLogId);
                BigDecimal dealAmount = draftIdDealAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(lockDraftId);
                draftAmountLockSubInfo.setDealAmount(dealAmount);
                draftAmountLockSubInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                draftAmountLockSubInfo.setBillTrade(bussinessType);
                lockSubInfoList.add(draftAmountLockSubInfo);
            }
            if (EmptyUtil.isNoEmpty(lockSubInfoList)) {
                draftLockInfo.getLockSubInfoList().addAll(lockSubInfoList);
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(tradeBillDB = (DynamicObject)tradeBillIdAndDyMap.get(tradeBillId)))) {
                DynamicObjectCollection entrysDB = tradeBillDB.getDynamicObjectCollection("entryentity");
                List lockDraftIdsDB = entrysDB.stream().map(v -> v.getDynamicObject("e_draftbill").getLong("id")).collect(Collectors.toList());
                HashMap draftIdDealAmountMapDB = entrysDB.stream().collect(Collectors.toMap(v -> v.getDynamicObject("e_draftbill").getLong("id"), o -> o.getBigDecimal("e_billamt"), (o1, o2) -> o1, HashMap::new));
                HashMap draftIdLogIdMapDB = entrysDB.stream().collect(Collectors.toMap(v -> v.getDynamicObject("e_draftbill").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
                ArrayList<DraftAmountLockSubInfo> releaseSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
                for (Long lockDraftIdDB : lockDraftIdsDB) {
                    if (lockDraftIds.contains(lockDraftIdDB)) continue;
                    DraftAmountLockSubInfo draftAmountreleaseSubInfo = new DraftAmountLockSubInfo();
                    draftAmountreleaseSubInfo.setBillId(lockDraftIdDB);
                    Long draftLogId = draftIdLogIdMapDB.get(lockDraftIdDB) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMapDB.get(lockDraftIdDB);
                    draftAmountreleaseSubInfo.setBillLogId(draftLogId);
                    BigDecimal dealAmount = draftIdDealAmountMapDB.get(lockDraftIdDB) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMapDB.get(lockDraftIdDB);
                    draftAmountreleaseSubInfo.setDealAmount(dealAmount);
                    draftAmountreleaseSubInfo.setOperateType(OperateTypeEnum.DELETE.getValue());
                    draftAmountreleaseSubInfo.setBillTrade(bussinessType);
                    releaseSubInfoList.add(draftAmountreleaseSubInfo);
                }
                if (EmptyUtil.isNoEmpty(releaseSubInfoList)) {
                    draftLockInfo.getLockSubInfoList().addAll(releaseSubInfoList);
                }
            }
            if (!EmptyUtil.isNoEmpty((Object)draftLockInfo.getLockSubInfoList())) continue;
            lockAndReleaseInfoList.add(draftLockInfo);
        }
        return lockAndReleaseInfoList;
    }

    public static DraftOperateInfo fillOperateInfoForRejectRefund(boolean formEleUpdate, DynamicObject data) {
        DynamicObjectCollection entries = data.getDynamicObjectCollection("entrys");
        DraftOperateInfo draftOperateInfo = new DraftOperateInfo();
        draftOperateInfo.setDraftBillIdFromEle(0L);
        draftOperateInfo.setTradeBillId(data.getLong("id"));
        draftOperateInfo.setFormEleUpdate(formEleUpdate);
        draftOperateInfo.setNumber(data.getString("billno"));
        draftOperateInfo.setDyTypename(data.getDynamicObjectType().getName());
        String tradeType = data.getString("tradetype");
        draftOperateInfo.setTradetype(tradeType);
        boolean isSplitType = splitTradeType.contains(tradeType);
        draftOperateInfo.setIsequalsplit(data.getBoolean("isequalsplit"));
        draftOperateInfo.setRejectRefundGen(data.getBoolean("isrejectrefundgen"));
        ArrayList<DraftOperateSubInfo> draftOperateSubInfoList = new ArrayList<DraftOperateSubInfo>(10);
        for (DynamicObject entry : entries) {
            DynamicObject draft = entry.getDynamicObject("draftbill");
            if (!EmptyUtil.isNoEmpty((DynamicObject)draft) || !StringUtils.equals((CharSequence)entry.getString("transtatus"), (CharSequence)"success") || !StringUtils.equals((CharSequence)draft.getString("draftbillstatus"), (CharSequence)DraftBillStatusEnum.ENDORSED.getValue())) continue;
            DraftOperateSubInfo draftOperateSubInfo = new DraftOperateSubInfo();
            boolean isEntrySplit = entry.getBoolean("isneedsplit");
            boolean isNeedSplit = isEntrySplit && isSplitType;
            draftOperateSubInfo.setBillamt(entry.getBigDecimal("billamt"));
            draftOperateSubInfo.setDraftbillId(draft.getLong("id"));
            draftOperateSubInfo.setDraftbilltranstatus(draft.getString("draftbilltranstatus"));
            draftOperateSubInfo.setTranstatus(entry.getString("transtatus"));
            draftOperateSubInfo.setBilllog(entry.getLong("billlogid"));
            draftOperateSubInfo.setIsneedsplit(isNeedSplit);
            draftOperateSubInfo.setSourcebillid(draft.getLong("sourcebillid"));
            draftOperateSubInfo.setSubbillendflag(draft.getLong("subbillendflag"));
            draftOperateSubInfoList.add(draftOperateSubInfo);
        }
        draftOperateInfo.setDraftOperateSubInfoList(draftOperateSubInfoList);
        return draftOperateInfo;
    }

    public static DraftOperateInfo fillOperateInfo(boolean formEleUpdate, DynamicObject data, long draftBillIdFromEle, boolean isRepayOrReJect) {
        DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
        DraftOperateInfo draftOperateInfo = new DraftOperateInfo();
        draftOperateInfo.setDraftBillIdFromEle(draftBillIdFromEle);
        draftOperateInfo.setTradeBillId(data.getLong("id"));
        draftOperateInfo.setFormEleUpdate(formEleUpdate);
        draftOperateInfo.setNumber(data.getString("billno"));
        draftOperateInfo.setDyTypename(data.getDynamicObjectType().getName());
        String tradeType = data.getString("tradetype");
        draftOperateInfo.setTradetype(tradeType);
        boolean isSpliType = splitTradeType.contains(tradeType);
        draftOperateInfo.setIsequalsplit(data.getBoolean("isequalsplit"));
        draftOperateInfo.setRejectRefundGen(data.getBoolean("isrejectrefundgen"));
        ArrayList<DraftOperateSubInfo> draftOperateSubInfoList = new ArrayList<DraftOperateSubInfo>(8);
        for (DynamicObject entry : entrys) {
            boolean isNoNeedDealLock;
            DraftOperateSubInfo draftOperateSubInfo = new DraftOperateSubInfo();
            DynamicObject draft = entry.getDynamicObject("draftbill");
            boolean entryIsrepay = entry.getBoolean("entryisrepay");
            boolean entryIsreject = entry.getBoolean("entryisrejectrefund");
            long billLog = entry.getLong("billlogid");
            boolean isEntrySplit = entry.getBoolean("isneedsplit");
            boolean isNeedSplit = isEntrySplit && isSpliType;
            BigDecimal billAmount = entry.getBigDecimal("billamt");
            String transtatus = entry.getString("transtatus");
            String transStatus = draft.getString("draftbilltranstatus");
            long sourcebillid = draft.getLong("sourcebillid");
            long subbillendflag = draft.getLong("subbillendflag");
            draftOperateSubInfo.setBillamt(billAmount);
            draftOperateSubInfo.setDraftbillId(draft.getLong("id"));
            draftOperateSubInfo.setDraftbilltranstatus(transStatus);
            draftOperateSubInfo.setTranstatus(transtatus);
            draftOperateSubInfo.setBilllog(billLog);
            draftOperateSubInfo.setIsneedsplit(isNeedSplit);
            draftOperateSubInfo.setSourcebillid(sourcebillid);
            draftOperateSubInfo.setSubbillendflag(subbillendflag);
            boolean bl = isNoNeedDealLock = isRepayOrReJect && (entryIsrepay || entryIsreject);
            if (isNoNeedDealLock && (!StringUtils.equals((CharSequence)transtatus, (CharSequence)"success") || !StringUtils.equals((CharSequence)draft.getString("draftbillstatus"), (CharSequence)DraftBillStatusEnum.REGISTERED.getValue()))) continue;
            draftOperateSubInfoList.add(draftOperateSubInfo);
        }
        draftOperateInfo.setDraftOperateSubInfoList(draftOperateSubInfoList);
        return draftOperateInfo;
    }

    public static List<DynamicObject> getNotChangeTradeBills(DynamicObject[] dataEntities) {
        HashSet<String> notChangeSet = new HashSet<String>(4);
        notChangeSet.add("hand");
        notChangeSet.add("receiablebill");
        notChangeSet.add("payablebill");
        notChangeSet.add("cas");
        notChangeSet.add("fromcollect");
        List<DynamicObject> notChangeTradeBillS = Arrays.stream(dataEntities).filter(e -> notChangeSet.contains(e.getString("source"))).collect(Collectors.toList());
        notChangeTradeBillS = LockDraftHelper.findFromAllocButNeedLockTrade(dataEntities, notChangeTradeBillS);
        return notChangeTradeBillS;
    }

    private static List<DynamicObject> findFromAllocButNeedLockTrade(DynamicObject[] dataEntities, List<DynamicObject> notChangeTradeBillS) {
        List needLockAllocTradeDraftList;
        Set alloBillIdSet;
        DynamicObjectCollection allocDraftColls;
        Map<Long, Long> allocIdAndCreatePoolIdMap;
        List fromAllocTradeBillS = Arrays.stream(dataEntities).filter(e -> "cdm-draftallocate".equals(e.getString("source"))).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(fromAllocTradeBillS) && EmptyUtil.isNoEmpty(allocIdAndCreatePoolIdMap = (allocDraftColls = QueryServiceHelper.query((String)"cdm_draftallocation", (String)"id,billpool,billpool.company", (QFilter[])new QFilter[]{new QFilter("id", "in", alloBillIdSet = fromAllocTradeBillS.stream().map(e -> e.getLong("sourcebillid")).collect(Collectors.toSet())), new QFilter("biztype", "=", (Object)"allocate"), new QFilter("billpool.dispatchrule", "=", (Object)"indirect")})).stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getLong("billpool.company")))) && allocIdAndCreatePoolIdMap.size() > 0 && EmptyUtil.isNoEmpty(needLockAllocTradeDraftList = fromAllocTradeBillS.stream().filter(e -> allocIdAndCreatePoolIdMap.containsKey(e.getLong("sourcebillid")) && ((Long)allocIdAndCreatePoolIdMap.get(e.getLong("sourcebillid"))).longValue() == e.getDynamicObject("company").getLong("id")).collect(Collectors.toList()))) {
            if (EmptyUtil.isNoEmpty(notChangeTradeBillS)) {
                notChangeTradeBillS.addAll(needLockAllocTradeDraftList);
            } else {
                notChangeTradeBillS = needLockAllocTradeDraftList;
            }
        }
        return notChangeTradeBillS;
    }

    public static List<DraftLockInfo> getChangeLockInfo(DynamicObject[] dataEntities) {
        ArrayList<DraftLockInfo> changeInfoList = new ArrayList<DraftLockInfo>(8);
        DynamicObjectType dynamicObjectType = dataEntities[0].getDynamicObjectType();
        String sourceBillTypeStr = dynamicObjectType.getName();
        Set tradeBillIdSet = Arrays.stream(dataEntities).map(e -> e.getLong("id")).collect(Collectors.toSet());
        Object[] tradeBillDyArr = TmcDataServiceHelper.load((Object[])tradeBillIdSet.toArray(), (DynamicObjectType)dynamicObjectType);
        Map<Object, Object> tradeBillIdAndDyMap = new HashMap(8);
        if (EmptyUtil.isNoEmpty((Object[])tradeBillDyArr)) {
            tradeBillIdAndDyMap = Arrays.stream(tradeBillDyArr).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        }
        List<DynamicObject> fromAllocButNeedLockTradeList = LockDraftHelper.findFromAllocButNeedLockTrade(dataEntities, new ArrayList<DynamicObject>());
        Set<Object> needLockAllocTradeIdSet = new HashSet(16);
        if (EmptyUtil.isNoEmpty(fromAllocButNeedLockTradeList)) {
            needLockAllocTradeIdSet = fromAllocButNeedLockTradeList.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        }
        for (DynamicObject data : dataEntities) {
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            long tradeBillId = data.getLong("id");
            String tradeType = data.getString("tradetype");
            String billNoStr = data.getString("billno");
            draftLockInfo.setBillTrade(tradeType);
            draftLockInfo.setTargetBillId(Long.valueOf(tradeBillId));
            draftLockInfo.setTargetBillType(sourceBillTypeStr);
            draftLockInfo.setBizBillNo(billNoStr);
            Long sourcebillId = data.getLong("sourcebillid");
            String source = data.getString("source");
            List<Object> draftIdList = new ArrayList(8);
            boolean isFromCas = false;
            if (SourceEnum.CAS.getValue().equals(source) && EmptyUtil.isNoEmpty((Long)sourcebillId)) {
                draftLockInfo.setSourceBillId(sourcebillId);
                draftLockInfo.setSourceBillType("cas_paybill");
                isFromCas = true;
                Object[] paybills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,draftbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourcebillId)});
                if (EmptyUtil.isNoEmpty((Object[])paybills)) {
                    draftIdList = paybills[0].getDynamicObjectCollection("draftbill").stream().filter(draftbill -> draftbill.getDynamicObject("fbasedataid") != null).map(draftbill -> draftbill.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                }
            } else if ("bizapply".equals(source) && EmptyUtil.isNoEmpty((Long)sourcebillId)) {
                if (DraftTradeTypeEnum.DISCOUNT.getValue().equals(tradeType)) {
                    draftLockInfo.setSourceBillId(sourcebillId);
                    draftLockInfo.setSourceBillType("cdm_discount_apply");
                } else {
                    if (!DraftTradeTypeEnum.PLEDGE.getValue().equals(tradeType)) continue;
                    draftLockInfo.setSourceBillId(sourcebillId);
                    draftLockInfo.setSourceBillType("cdm_pledge_apply");
                }
            } else if ((SourceEnum.CDM_DRAFTTRADEBILL.getValue().equals(source) || "repay".equals(source) || "fromcollect".equals(source)) && EmptyUtil.isNoEmpty((Long)sourcebillId)) {
                draftLockInfo.setSourceBillId(sourcebillId);
                draftLockInfo.setSourceBillType("cdm_drafttradebill");
            } else {
                if (!"cdm-draftallocate".equals(source) || !EmptyUtil.isNoEmpty((Long)sourcebillId)) continue;
                if (EmptyUtil.isEmpty(needLockAllocTradeIdSet) || !needLockAllocTradeIdSet.contains(tradeBillId)) {
                    draftLockInfo.setSourceBillId(sourcebillId);
                    draftLockInfo.setSourceBillType("cdm_draftallocation");
                }
            }
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
            List lockDraftIds = entrys.stream().map(v -> v.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toList());
            HashMap draftIdDealAmountMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbill").getLong("id"), o -> o.getBigDecimal("billamt"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdLogIdMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbill").getLong("id"), o -> o.getLong("billlogid"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdDealAmountMapDB = new HashMap(8);
            HashMap draftIdLogIdMapDB = new HashMap(8);
            DynamicObject tradeBillDB = (DynamicObject)tradeBillIdAndDyMap.get(tradeBillId);
            if (EmptyUtil.isNoEmpty((DynamicObject)tradeBillDB)) {
                DynamicObjectCollection entrysDB = tradeBillDB.getDynamicObjectCollection("entrys");
                draftIdDealAmountMapDB = entrysDB.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbill").getLong("id"), o -> o.getBigDecimal("billamt"), (o1, o2) -> o1, HashMap::new));
                draftIdLogIdMapDB = entrysDB.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbill").getLong("id"), o -> o.getLong("billlogid"), (o1, o2) -> o1, HashMap::new));
            }
            ArrayList<DraftAmountLockSubInfo> lockSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
            for (Long lockDraftId : lockDraftIds) {
                if (isFromCas && !draftIdList.contains(lockDraftId)) continue;
                DraftAmountLockSubInfo draftAmountLockSubInfo = new DraftAmountLockSubInfo();
                draftAmountLockSubInfo.setBillId(lockDraftId);
                Long billLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                draftAmountLockSubInfo.setBillLogId(billLogId);
                BigDecimal dealAmount = draftIdDealAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(lockDraftId);
                draftAmountLockSubInfo.setDealAmount(dealAmount);
                BigDecimal transAmountDb = (BigDecimal)draftIdDealAmountMapDB.get(lockDraftId);
                boolean isTransAmountEquals = EmptyUtil.isNoEmpty((BigDecimal)transAmountDb) && dealAmount.compareTo(transAmountDb) == 0;
                Long billLogIdDb = (Long)draftIdLogIdMapDB.get(lockDraftId);
                boolean hasBillLogId = EmptyUtil.isNoEmpty((Long)billLogIdDb);
                if (isTransAmountEquals && hasBillLogId) continue;
                draftAmountLockSubInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                draftAmountLockSubInfo.setBillTrade(tradeType);
                lockSubInfoList.add(draftAmountLockSubInfo);
            }
            draftLockInfo.setLockSubInfoList(lockSubInfoList);
            if (CollectionUtils.isEmpty((Collection)draftLockInfo.getLockSubInfoList())) continue;
            changeInfoList.add(draftLockInfo);
        }
        return changeInfoList;
    }

    public static List<DraftLockInfo> getReleaseInfo(List<DynamicObject> dataEntities) {
        String tradeBillType = dataEntities.get(0).getDataEntityType().getName();
        ArrayList<DraftLockInfo> releaseInfoList = new ArrayList<DraftLockInfo>(8);
        for (DynamicObject tradebill : dataEntities) {
            Long sourcebillId = tradebill.getLong("sourcebillid");
            String source = tradebill.getString("source");
            List<Object> draftIdList = new ArrayList(8);
            boolean isFromCas = false;
            if (SourceEnum.CAS.getValue().equals(source) && EmptyUtil.isNoEmpty((Long)sourcebillId)) {
                isFromCas = true;
                Object[] paybills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,draftbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourcebillId)});
                if (EmptyUtil.isNoEmpty((Object[])paybills)) {
                    draftIdList = paybills[0].getDynamicObjectCollection("draftbill").stream().filter(draftbill -> draftbill.getDynamicObject("fbasedataid") != null).map(draftbill -> draftbill.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                }
            }
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            long tradeBillId = tradebill.getLong("id");
            String billno = tradebill.getString("billno");
            String tradeType = tradebill.getString("tradetype");
            draftLockInfo.setBillTrade(tradeType);
            draftLockInfo.setSourceBillType(tradeBillType);
            if ("fromcollect".equals(source)) {
                long sourceBillId = tradebill.getLong("sourcebillid");
                draftLockInfo.setSourceBillId(Long.valueOf(sourceBillId));
            } else {
                draftLockInfo.setSourceBillId(Long.valueOf(tradeBillId));
            }
            draftLockInfo.setBizBillNo(billno);
            draftLockInfo.setOperateType(OperateTypeEnum.DELETE.getValue());
            DynamicObjectCollection entrys = tradebill.getDynamicObjectCollection("entrys");
            ArrayList<Long> lockDraftIds = new ArrayList<Long>(16);
            HashMap<Long, BigDecimal> draftIdDealAmountMap = new HashMap<Long, BigDecimal>(16);
            HashMap<Long, Long> draftIdLogIdMap = new HashMap<Long, Long>(16);
            HashSet<Long> changeDraftSet = new HashSet<Long>(16);
            for (DynamicObject entry : entrys) {
                long draftId = entry.getDynamicObject("draftbill").getLong("id");
                lockDraftIds.add(draftId);
                BigDecimal billamount = entry.getBigDecimal("billamt");
                long billLogId = entry.getLong("billlogid");
                draftIdDealAmountMap.put(draftId, billamount);
                draftIdLogIdMap.put(draftId, billLogId);
                if (!entry.getBoolean("changeflag")) continue;
                changeDraftSet.add(draftId);
            }
            ArrayList<DraftAmountLockSubInfo> releaseSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
            for (Long lockDraftId : lockDraftIds) {
                if (isFromCas && draftIdList.contains(lockDraftId)) continue;
                DraftAmountLockSubInfo draftAmountreleaseSubInfo = new DraftAmountLockSubInfo();
                draftAmountreleaseSubInfo.setBillId(lockDraftId);
                Long draftLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                draftAmountreleaseSubInfo.setBillLogId(draftLogId);
                BigDecimal dealAmount = draftIdDealAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(lockDraftId);
                draftAmountreleaseSubInfo.setDealAmount(dealAmount);
                draftAmountreleaseSubInfo.setOperateType(OperateTypeEnum.DELETE.getValue());
                draftAmountreleaseSubInfo.setBillTrade(tradeType);
                releaseSubInfoList.add(draftAmountreleaseSubInfo);
                if (!changeDraftSet.contains(lockDraftId)) continue;
                draftAmountreleaseSubInfo.setChangeRelease(true);
            }
            if (!EmptyUtil.isNoEmpty(releaseSubInfoList)) continue;
            draftLockInfo.getLockSubInfoList().addAll(releaseSubInfoList);
            releaseInfoList.add(draftLockInfo);
        }
        return releaseInfoList;
    }

    private static /* synthetic */ DynamicObject lambda$updateBills$18(DynamicObject o1, DynamicObject o2) {
        return o1;
    }

    private static /* synthetic */ DynamicObject lambda$updateBills$17(DynamicObject o) {
        return o;
    }

    private static /* synthetic */ Long lambda$updateBills$16(DynamicObject v) {
        return v.getLong("id");
    }

    private static /* synthetic */ String lambda$updateBills$15(Long a) {
        return String.valueOf(a);
    }

    private static /* synthetic */ Long lambda$updateBills$14(DraftAmountLockSubInfo item) {
        return item.getBillId();
    }
}

