/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.service;

import java.util.Arrays;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.EventualConsistencyService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cdm.business.service.param.TxServiceParam;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class StorageRecBillTxService
extends EventualConsistencyService {
    private static final Log logger = LogFactory.getLog(StorageRecBillTxService.class);
    private static final String UPDATE_DRAFT_TRADEBILL_SQL = "update t_cdm_drafttradebill set fdraftbilltranstatus = ? where fid = ? and fdraftbilltranstatus = ?";

    public DtxResponse execute(Object o, Object o1) throws Exception {
        logger.info("StorageRecBillTxService.execute do");
        TxServiceParam param = (TxServiceParam)o;
        Object[] params = param.getParams();
        logger.info("StorageRecBillTxService.execute params = {}", (Object)Arrays.toString(params));
        Long draftId = params[0] == null ? 0L : Long.parseLong(params[0].toString());
        DynamicObject draftTradeBill = (DynamicObject)params[1];
        String draftbillTranstatus = draftTradeBill.getString("draftbilltranstatus");
        int upCount = DB.update((DBRoute)DBRouteConst.TMC, (String)UPDATE_DRAFT_TRADEBILL_SQL, (Object[])new Object[]{draftbillTranstatus, draftTradeBill.getLong("id"), DraftTranStatusEnum.HANDLEING.getValue()});
        logger.info("StorageRecBillTxService operate draftId = {},draftTradeBillNo = {},upCount = {},draftbillTranstatus = {}", new Object[]{draftId, draftTradeBill.getString("billno"), upCount, draftbillTranstatus});
        if (upCount > 0 || upCount == 0 && DraftTranStatusEnum.PORSUCCESS.getValue().equals(draftbillTranstatus) && draftTradeBill.getBoolean("isrepay")) {
            DynamicObjectCollection dynamicObjects = draftTradeBill.getDynamicObjectCollection("entrys");
            long countNotRepay = dynamicObjects.stream().filter(e -> !e.getBoolean("entryisrepay")).count();
            long successCount = dynamicObjects.stream().filter(e -> "success".equals(e.getString("transtatus"))).count();
            logger.info("StorageRecBillTxService.execute successCount:" + successCount + ",countNotRepay:" + countNotRepay);
            if (successCount == countNotRepay) {
                logger.info("StorageRecBillTxService drawbillsave operate draftId = {},draftTradeBillNo = {}", (Object)draftId, (Object)draftTradeBill.getString("billno"));
                OperateOption option = OperateOption.create();
                option.setVariableValue("COMPLETEFROM_ELEUPDATE", "true");
                TmcOperateServiceHelper.execOperate((String)"drawbillsave", (String)"cdm_drafttradebill", (Object[])new Object[]{draftTradeBill.getPkValue()}, (OperateOption)option);
            }
        }
        logger.info("StorageRecBillTxService.execute done");
        return null;
    }
}

