/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.task.elecdraft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftCirStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class NoteSignInAutoTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(NoteSignInAutoTask.class);
    private static final List<String> WAIT_SING = Arrays.asList(EleDraftBillStatusEnum.ACCEPTANCE.getValue(), EleDraftBillStatusEnum.INVOICE.getValue(), EleDraftBillStatusEnum.RECITE.getValue(), EleDraftBillStatusEnum.PLEDGE.getValue(), EleDraftBillStatusEnum.RELEASEPLEDGE.getValue(), EleDraftBillStatusEnum.PAYMENT.getValue());

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("\u7535\u7968\u81ea\u52a8\u7b7e\u6536\u4efb\u52a1\u5f00\u59cb");
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
        qFilterList.add(new QFilter("ticketstatus", "in", WAIT_SING).or(new QFilter("cirstatus", "=", (Object)EleDraftCirStatusEnum.TF0101.getValue())));
        qFilterList.add(new QFilter("datasource", "=", (Object)"bank"));
        qFilterList.add(new QFilter("ebstatus", "is null", null).or(new QFilter("ebstatus", "=", (Object)" ")));
        qFilterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        DynamicObjectCollection signBills = QueryServiceHelper.query((String)"cdm_electronic_sign_deal", (String)"id,company,signopinion", (QFilter[])qFilterList.toArray(new QFilter[0]));
        logger.info("\u7535\u7968\u81ea\u52a8\u7b7e\u6536\u4efb\u52a1\u6267\u884c\u6570\u636esignBills.length={}", (Object)signBills.size());
        if (signBills.size() > 0) {
            Object[] pkValues = signBills.stream().map(e -> e.getLong("id")).toArray();
            logger.info("\u7535\u7968\u81ea\u52a8\u7b7e\u6536\u4efb\u52a1\u6267\u884c\u6570\u636eid={}", (Object)Arrays.toString(pkValues));
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ishasright", "true");
            OperationResult operationResult = TmcOperateServiceHelper.executeOperate((String)"notesignin", (String)"cdm_electronic_sign_deal", (Object[])pkValues, (OperateOption)operateOption);
            if (!operationResult.isSuccess()) {
                logger.info(String.format("\u7535\u7968\u81ea\u52a8\u7b7e\u6536\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff1a%s", TmcOperateServiceHelper.decodeErrorMsg((OperationResult)operationResult)));
                throw new KDBizException(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)operationResult));
            }
            logger.info("\u7535\u7968\u81ea\u52a8\u7b7e\u6536\u4efb\u52a1\u6267\u884c\u6210\u529f\uff0c\u6210\u529fid={}", (Object)operationResult.getSuccessPkIds().toString());
            logger.info("\u7535\u7968\u81ea\u52a8\u7b7e\u6536\u4efb\u52a1\u7ed3\u675f");
        }
    }
}

