/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.task.elecdraft;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.form.MessageTypes;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.business.helper.ElectRecClaimRuleHelper;
import kd.tmc.cdm.common.enums.EleDraftExistCatEnum;
import kd.tmc.fbp.common.helper.TmcAppCache;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class NoticeClaimAutoTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(NoticeClaimAutoTask.class);
    private static IAppCache cache = TmcAppCache.get((String)"cas", (String)"intelrec", (String)"claim");

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("\u7535\u7968\u81ea\u52a8\u901a\u77e5\u7b7e\u6536\u4efb\u52a1\u5f00\u59cb");
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
        qFilterList.add(new QFilter("tradetype", "is null", null).or(new QFilter("tradetype", "=", (Object)" ")));
        qFilterList.add(new QFilter("ebstatus", "is null", null).or(new QFilter("ebstatus", "=", (Object)" ")));
        qFilterList.add(new QFilter("querydrafttype", "=", (Object)EleDraftExistCatEnum.REPLY.getValue()));
        DynamicObjectCollection signBills = QueryServiceHelper.query((String)"cdm_electronic_sign_deal", (String)"id,signnoticebill,billno", (QFilter[])qFilterList.toArray(new QFilter[0]));
        logger.info("\u7535\u7968\u81ea\u52a8\u901a\u77e5\u7b7e\u6536\u4efb\u52a1\u6267\u884c\u6570\u636esignBills.length={}", (Object)signBills.size());
        if (signBills.size() > 0) {
            Set idSet = signBills.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            logger.info("\u7535\u7968\u81ea\u52a8\u901a\u77e5\u7b7e\u6536\u4efb\u52a1\u6267\u884cid={}", idSet);
            this.noticeClaim(signBills);
            logger.info("\u7535\u7968\u81ea\u52a8\u901a\u77e5\u7b7e\u6536\u4efb\u52a1\u7ed3\u675f");
        }
    }

    private void noticeClaim(DynamicObjectCollection electRecBills) {
        ArrayList<DynamicObject> notifiedList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> unNotifiedList = new ArrayList<DynamicObject>(10);
        for (DynamicObject electRecBill : electRecBills) {
            if (StringUtils.isEmpty((CharSequence)electRecBill.getString("signnoticebill"))) {
                unNotifiedList.add(electRecBill);
                continue;
            }
            notifiedList.add(electRecBill);
        }
        StringBuilder recPayRuleFailMessage = new StringBuilder();
        int failedCount = 0;
        for (DynamicObject unNotified : unNotifiedList) {
            String tag;
            DynamicObject ruleResult = ElectRecClaimRuleHelper.getClaimInfoByNoticeRule((Long)unNotified.getLong("id"), (String)"noticeclaim");
            if (ruleResult == null) {
                ++failedCount;
                recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u672a\u627e\u5230\u5bf9\u5e94\u8d44\u91d1\u7ec4\u7ec7\u7684\u6536\u4ed8\u5165\u8d26\u89c4\u5219\uff0c\u8bf7\u914d\u7f6e\u540e\u91cd\u8bd5\u3002\r\n", (String)"NoticeClaimAutoTask_0", (String)"tmc-cdm-business", (Object[])new Object[0]), unNotified.get("billno")));
                continue;
            }
            String string = tag = ruleResult.get("e_savenotifi_TAG") == null ? "" : ruleResult.getString("e_savenotifi_TAG");
            if ("noticeclaim".equals(ruleResult.get("e_handlescheme")) && !StringUtils.isEmpty((CharSequence)tag)) {
                String idStr = String.valueOf(unNotified.getLong("id"));
                cache.put(idStr, (Object)tag);
            }
            if ("noticeclaim".equals(ruleResult.get("e_handlescheme")) && !StringUtils.isEmpty((CharSequence)ruleResult.getString("e_rulesname"))) {
                cache.put(unNotified.getLong("id") + "rulesname", ruleResult.get("e_rulesname"));
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            OperationResult operationResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"pushclaimcenterbill", (String)"cdm_electronic_sign_deal", (Object[])new Object[]{unNotified.getLong("id")}, (OperateOption)option);
            if (operationResult.isSuccess()) continue;
            ++failedCount;
            recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u65e0\u6cd5\u6309\u65b9\u6848\u901a\u77e5\u8ba4\u9886\uff0c\u53ef\u80fd\u662f\u672a\u8fdb\u884c\u89c4\u5219\u8bbe\u7f6e\uff0c\u6216\u672a\u9002\u914d\u5230\u65b9\u6848\u3002\u53ef\u6307\u5b9a\u53c2\u4e0e\u8ba4\u9886\u7528\u6237\u4fe1\u606f\u540e\u53d1\u8d77\u901a\u77e5\u3002\r\n", (String)"NoticeClaimAutoTask_1", (String)"tmc-cdm-business", (Object[])new Object[0]), unNotified.get("billno")));
        }
        if (notifiedList.isEmpty() && StringUtils.isEmpty((CharSequence)recPayRuleFailMessage.toString())) {
            logger.info(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"EleDraftRecClaimList_5", (String)"tmc-cdm-business", (Object[])new Object[0]));
        } else {
            notifiedList.forEach(detail -> recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5df2\u53d1\u8d77\u8fc7\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\uff0c\u65e0\u9700\u518d\u901a\u77e5\u8ba4\u9886\u3002\r\n", (String)"NoticeClaimAutoTask_2", (String)"tmc-cdm-business", (Object[])new Object[0]), detail.get("billno"))));
            logger.info(String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u8bb0\u5f55\uff0c\u5df2\u901a\u77e5\u8ba4\u9886%2$s\u6761\uff0c\u65e0\u9700\u901a\u77e5%3$s\u6761", (String)"NoticeClaimAutoTask_3", (String)"tmc-cdm-business", (Object[])new Object[0]), electRecBills.size(), unNotifiedList.size() - failedCount, notifiedList.size()), (Object)recPayRuleFailMessage.toString(), (Object)MessageTypes.Default);
        }
    }
}

