/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.tradebill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cdm.common.helper.TradeBillHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class TradeBillRejectRefundValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("draftbilltranstatus");
        selector.add("isrepay");
        selector.add("isrepaygen");
        selector.add("source");
        selector.add("isrejectrefund");
        selector.add("sourcebillid");
        selector.add("entrys");
        selector.add("transtatus");
        selector.add("isdrawfail");
        selector.add("entrys.transtatus");
        selector.add("entrys.billamt");
        selector.add("entrys.entryisrejectrefund");
        selector.add("entrys.entryisrepay");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity data : dataEntity) {
            boolean isNeedCallRefund;
            String source;
            DynamicObjectCollection entries;
            boolean validateEntryTranStatus;
            boolean isdrawfail;
            DynamicObject tradeBill = data.getDataEntity();
            String tranStatus = tradeBill.getString("draftbilltranstatus");
            if (!TradeBillHelper.canRepayTranStatus((String)tranStatus)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u64cd\u4f5c\u7968\u636e\u4ea4\u6613\u72b6\u6001\u662f\u201c\u4ea4\u6613\u5931\u8d25\u201d\u6216\u201c\u90e8\u5206\u6210\u529f\u201d\u7684\u6570\u636e\u3002", (String)"TradeBillRejectRefundValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if (isdrawfail = tradeBill.getBoolean("isdrawfail")) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u786e\u8ba4\u5931\u8d25\u7684\u4e1a\u52a1\u5904\u7406\u5355\u4e0d\u80fd\u64cd\u4f5c\u62d2\u6536\u9000\u7968\u3002", (String)"TradeBillRejectRefundValidator_6", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if (!(validateEntryTranStatus = (entries = tradeBill.getDynamicObjectCollection("entrys")).stream().anyMatch(TradeBillHelper::canRepayOrRejectRefundDraftEntry))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u64cd\u4f5c\u7968\u636e\u72b6\u6001\u662f\u201c\u4ea4\u6613\u5931\u8d25\u201d\u7684\u5e76\u4e14\u6ca1\u6709\u53d1\u751f \u201c\u62d2\u6536\u9000\u7968\u201d\u6216 \u201c\u5931\u8d25\u91cd\u4ed8\u201d\u7684\u6570\u636e\u3002", (String)"TradeBillRejectRefundValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            if (StringUtils.equals((CharSequence)(source = tradeBill.getString("source")), (CharSequence)"cdm-draftallocate")) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u6765\u6e90\u662f\u7968\u636e\u8c03\u5ea6\uff0c\u4e0d\u80fd\u64cd\u4f5c\u62d2\u6536\u9000\u7968", (String)"TradeBillRejectRefundValidator_4", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            boolean isRepay = tradeBill.getBoolean("isrepay");
            boolean isRepayGen = tradeBill.getBoolean("isrepaygen");
            long sourceId = tradeBill.getLong("sourcebillid");
            if (!isRepay && !isRepayGen || !EmptyUtil.isNoEmpty((Long)sourceId) || !StringUtils.equals((CharSequence)source, (CharSequence)"cas") || (isNeedCallRefund = TradeBillHelper.checkCasPayAmountAndDraftAmount((long)sourceId, (boolean)true, (DynamicObject)tradeBill))) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u4ed8\u6b3e\u5355\u6240\u5173\u8054\u7684\u6240\u6709\u4e0b\u6e38\u80cc\u4e66\u4e1a\u52a1\u5904\u7406\u5355\u4e2d\uff0c\u6210\u529f\u7684\u5206\u5f55\u4ee5\u53ca\u672c\u4e1a\u52a1\u5904\u7406\u5355\u4e2d\u6210\u529f\u548c\u5931\u8d25\u72b6\u6001\u7684\u7968\u636e\u5206\u5f55\u7684\u8f6c\u8ba9\u91d1\u989d\u5408\u8ba1\u4e0e\u4ed8\u6b3e\u5355\u7684\u4ed8\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u64cd\u4f5c\u62d2\u6536\u9000\u7968\u3002", (String)"TradeBillRejectRefundValidator_7", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
    }
}

