/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.tradebill;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.errorcode.DraftBillErrorCode;
import kd.tmc.cdm.common.exception.CdmException;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.PayableBillHelp;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang.StringUtils;

public class TradeBillSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entrys");
        selector.add("draftbill");
        selector.add("source");
        selector.add("tradetype");
        selector.add("drafttype");
        selector.add("payeetypetext");
        selector.add("beendorsor");
        selector.add("tradetype");
        selector.add("bankacct");
        selector.add("deposit");
        selector.add("depositaccount");
        selector.add("depositamount");
        selector.add("pledgeenddate");
        selector.add("recbody");
        selector.add("bankaccount");
        selector.add("subentrys");
        selector.add("e_subbillamount");
        selector.add("amount");
        selector.add("amount");
        selector.add("refunddesc");
        selector.add("pledgeebase");
        selector.add("pledgeetype");
        selector.add("pledgeetext");
        selector.add("beendorsortext");
        selector.add("depositdeduct");
        selector.add("deductamount");
        selector.add("discount_interest");
        selector.add("payinteramount_bank");
        selector.add("owndiscountinterest");
        selector.add("payinterestamount");
        selector.add("ispaybyagree");
        selector.add("rptype");
        selector.add("poundage");
        selector.add("discamt");
        selector.add("bankacct");
        selector.add("isequalsplit");
        selector.add("billamt");
        selector.add("billlogid");
        selector.add("invctype");
        selector.add("invcno");
        selector.add("invccode");
        selector.add("invcchkno");
        selector.add("invcdate");
        selector.add("invcamt");
        selector.add("isrejectrefundgen");
        selector.add("depositentry.dpbillno");
        selector.add("depositentry.dpdeductamount");
        selector.add("depositentry.dpbillnos_tag");
        selector.add("depositentry.dpbillnos");
        selector.add("depositentry.revenueway");
        selector.add("deducttype");
        selector.add("depositentry.dinterestamount");
        selector.add("amount");
        selector.add("sourcebillid");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        DraftBillErrorCode draftBillErrorCode = new DraftBillErrorCode();
        CdmBizResource cdmBizResource = new CdmBizResource();
        for (ExtendedDataEntity data : dataEntity) {
            boolean isReceiveOppNote;
            Object companyId;
            BigDecimal discountInterest;
            Set draweracctSet;
            DynamicObject tradeBill = data.getDataEntity();
            DynamicObjectCollection entrys = tradeBill.getDynamicObjectCollection("entrys");
            String tradeType = tradeBill.getString("tradetype");
            DynamicObject draftType = tradeBill.getDynamicObject("drafttype");
            String rpType = tradeBill.getString("rptype");
            String settlementType = draftType.getString("settlementtype");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys) || entrys.size() == 1 && null == ((DynamicObject)entrys.get(0)).getDynamicObject("draftbill")) {
                throw new CdmException(draftBillErrorCode.ERRORMISSDRAFT());
            }
            Set accepterNameSet = entrys.stream().map(e -> e.getDynamicObject("draftbill").getString("acceptername")).collect(Collectors.toSet());
            if (Objects.equals(tradeType, DraftTradeTypeEnum.PAYOFF.getValue()) && accepterNameSet.size() > 1) {
                this.addErrorMessage(data, cdmBizResource.getTipAccepterNameDiff());
            }
            if (tradeBill.getBoolean("deposit") && Objects.equals(tradeType, DraftTradeTypeEnum.PAYOFF.getValue()) && (draweracctSet = entrys.stream().map(e -> e.getDynamicObject("draftbill").getString("draweraccountname")).collect(Collectors.toSet())).size() > 1) {
                this.addErrorMessage(data, cdmBizResource.getDrawerAcctDiff());
            }
            HashSet companyIds = new HashSet();
            entrys.stream().filter(o -> !EmptyUtil.isEmpty((DynamicObject)o.getDynamicObject("draftbill"))).forEach(v -> companyIds.add(v.getDynamicObject("draftbill").getDynamicObject("company").getPkValue()));
            if (companyIds.size() > 1) {
                this.addErrorMessage(data, cdmBizResource.getTipCompanyDiff());
            }
            String payeeType = tradeBill.getString("payeetypetext");
            if ("endorse".equals(tradeType)) {
                if ("other".equals(payeeType) && StringUtils.isEmpty((String)tradeBill.getString("beendorsortext"))) {
                    this.addErrorMessage(data, cdmBizResource.getTipPayerShortEd());
                }
                if (!"other".equals(payeeType) && StringUtils.isEmpty((String)tradeBill.getString("beendorsor"))) {
                    this.addErrorMessage(data, cdmBizResource.getTipPayerShortEd());
                }
            } else if (DraftTradeTypeEnum.PAYOFF.getValue().equals(tradeType)) {
                BigDecimal deductamount;
                if (tradeBill.getBoolean("deposit")) {
                    BigDecimal depositAmount;
                    if (Objects.isNull(tradeBill.get("depositaccount"))) {
                        this.addErrorMessage(data, cdmBizResource.getDepositAccountNonNull());
                    }
                    if ((depositAmount = tradeBill.getBigDecimal("depositamount")).compareTo(BigDecimal.ZERO) <= 0) {
                        this.addErrorMessage(data, cdmBizResource.getDepositAmountGreaterThanZero());
                    }
                    if (depositAmount.compareTo(tradeBill.getBigDecimal("amount")) > 0) {
                        this.addErrorMessage(data, cdmBizResource.getDepositAmountGreaterThanAmount());
                    }
                }
                if (tradeBill.getBoolean("depositdeduct") && (deductamount = tradeBill.getBigDecimal("deductamount")).compareTo(BigDecimal.ZERO) <= 0) {
                    this.addErrorMessage(data, cdmBizResource.getDeductAmountThanZero());
                }
            } else if (DraftTradeTypeEnum.REFUND.getValue().equals(tradeType)) {
                boolean ishaveSameBill;
                String refunddesc = tradeBill.getString("refunddesc");
                if (EmptyUtil.isEmpty((String)refunddesc)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9000\u7968\u539f\u56e0\u3002", (String)"CdmBizResource_126", (String)"tmc-cdm-common", (Object[])new Object[0]));
                }
                if (ishaveSameBill = this.validateOtherBill(tradeBill)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u9000\u7968\u7684\u7968\u636e\u5b58\u5728\u5bf9\u5e94\u7684\u5e94\u6536\u7968\u636e\uff0c\u4e0d\u80fd\u9000\u7968\u3002", (String)"CdmBizResource_169", (String)"tmc-cdm-common", (Object[])new Object[0]));
                }
                HashSet paybillIds = new HashSet(0);
                entrys.stream().map(item -> item.getDynamicObject("draftbill").getLong("id")).forEach(draftBillId -> {
                    List tBillIds = DraftHelper.getBillIds((Long)draftBillId, (boolean)true, (String)"cas_paybill");
                    if (tBillIds.size() < 1 && EmptyUtil.isNoEmpty((String)rpType) && rpType.equals("paybill")) {
                        this.addErrorMessage(data, cdmBizResource.getNoReFund());
                    }
                    paybillIds.addAll(tBillIds);
                });
                if (entrys.size() > 1 && paybillIds.size() > 1) {
                    this.addErrorMessage(data, cdmBizResource.getSamePayBill());
                }
                if (entrys.size() > 1 && "receivebill".equals(rpType)) {
                    this.addErrorMessage(data, cdmBizResource.getNobatchReFund());
                }
            } else if (DraftTradeTypeEnum.BILLSPLIT.getValue().equals(tradeType)) {
                boolean isEqualSplit;
                DynamicObjectCollection subentrys = tradeBill.getDynamicObjectCollection("subentrys");
                DynamicObjectCollection selectEntrys = tradeBill.getDynamicObjectCollection("entrys");
                DynamicObject draftDy = ((DynamicObject)selectEntrys.get(0)).getDynamicObject("draftbill");
                long draftId = draftDy.getLong("id");
                DynamicObject draftBillDyDbNew = QueryServiceHelper.queryOne((String)"cdm_draftbillf7", (String)String.join((CharSequence)",", "id", "standardbillamount", "subbillrange", "amount", "availableamount", "subbillendflag", "subbillstartflag", "subbillquantity", "supperbillamount"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)draftId)});
                BigDecimal selectSubAmount = draftBillDyDbNew.getBigDecimal("amount");
                BigDecimal subAmountAll = new BigDecimal(BigInteger.ZERO);
                for (DynamicObject subEntry : subentrys) {
                    subAmountAll = subAmountAll.add(subEntry.getBigDecimal("e_subbillamount"));
                }
                if (selectSubAmount.compareTo(subAmountAll) != 0) {
                    this.addErrorMessage(data, cdmBizResource.getDraftBillSubAmountWrong());
                }
                if (isEqualSplit = tradeBill.getBoolean("isequalsplit")) {
                    if (EmptyUtil.isEmpty((DynamicObjectCollection)subentrys) || subentrys.size() != 2) {
                        this.addErrorMessage(data, cdmBizResource.getEqualSplitEntrySizeWrong());
                    }
                    DynamicObject selectEntry = (DynamicObject)selectEntrys.get(0);
                    BigDecimal splitAmount = ((DynamicObject)subentrys.get(1)).getBigDecimal("e_subbillamount");
                    BigDecimal billAmount = selectEntry.getBigDecimal("billamt");
                    if (billAmount.compareTo(splitAmount) != 0) {
                        this.addErrorMessage(data, cdmBizResource.getEqualSplitAmountWrong());
                    }
                }
            }
            HashSet currencyIds = new HashSet();
            entrys.stream().filter(o -> !EmptyUtil.isEmpty((DynamicObject)o.getDynamicObject("draftbill"))).forEach(v -> currencyIds.add(v.getDynamicObject("draftbill").getDynamicObject("currency").getPkValue()));
            if (currencyIds.size() > 1) {
                this.addErrorMessage(data, cdmBizResource.getTipCurrencyDiff());
            }
            if (tradeType.equals(DraftTradeTypeEnum.PAYINTEREST.getValue()) && (discountInterest = tradeBill.getBigDecimal("discount_interest")).compareTo(new BigDecimal(BigInteger.ZERO)) <= 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b9e\u4ed8\u8d34\u73b0\u5229\u606f\u91d1\u989d\u53ea\u80fd\u5927\u4e8e\u96f6\u3002", (String)"CdmBizResource_168", (String)"tmc-cdm-common", (Object[])new Object[0]));
            }
            if (tradeType.equals(DraftTradeTypeEnum.PLEDGE.getValue())) {
                Object pledgeenddate = data.getValue("pledgeenddate");
                if (EmptyUtil.isEmpty((Object)pledgeenddate)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d28\u62bc\u5230\u671f\u65e5\u671f\u3002", (String)"BankAgentErrorCode_3_1", (String)"tmc-cdm-common", (Object[])new Object[0]));
                } else {
                    Date pledgeend = (Date)pledgeenddate;
                    for (DynamicObject entry : entrys) {
                        String entryBillName = entry.getDynamicObject("draftbill").getString("draftbillno");
                        if (entry.getDynamicObject("draftbill").getDate("issuedate").compareTo(pledgeend) <= 0) continue;
                        this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"%s\u7968\u636e\u51fa\u7968\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u8d28\u62bc\u5230\u671f\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7968\u636e\u8d28\u62bc\u5230\u671f\u65e5\u671f\u3002", (String)"CdmBizResource_102", (String)"tmc-cdm-common", (Object[])new Object[0]), entryBillName));
                    }
                }
                Object pledgeType = data.getValue("pledgeetype");
                if (EmptyUtil.isNoEmpty((Object)pledgeType)) {
                    if ("other".equals(pledgeType)) {
                        Object pledgeTypeText = data.getValue("pledgeetext");
                        if (EmptyUtil.isEmpty((Object)pledgeTypeText)) {
                            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d28\u6743\u4eba\u3002", (String)"CdmBizResource_106", (String)"tmc-cdm-common", (Object[])new Object[0]));
                        }
                    } else {
                        Object pledgeTypeBase = data.getValue("pledgeebase");
                        if (EmptyUtil.isEmpty((Object)pledgeTypeBase)) {
                            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d28\u6743\u4eba\u3002", (String)"CdmBizResource_106", (String)"tmc-cdm-common", (Object[])new Object[0]));
                        }
                    }
                }
            }
            if (tradeType.equals(DraftTradeTypeEnum.DISCOUNT.getValue()) || tradeType.equals(DraftTradeTypeEnum.COLLECT.getValue()) || tradeType.equals(DraftTradeTypeEnum.PAYOFF.getValue())) {
                BigDecimal poundage = tradeBill.getBigDecimal("poundage");
                BigDecimal amount = tradeBill.getBigDecimal("amount");
                if (poundage != null && amount != null && poundage.floatValue() > amount.floatValue()) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u624b\u7eed\u8d39\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5408\u8ba1\u91d1\u989d\u3002", (String)"CdmBizResource_76", (String)"tmc-cdm-common", (Object[])new Object[0]));
                }
            }
            if (tradeType.equals(DraftTradeTypeEnum.DISCOUNT.getValue()) || tradeType.equals(DraftTradeTypeEnum.COLLECT.getValue())) {
                DynamicObject bankAccount = tradeBill.getDynamicObject("bankaccount");
                DynamicObject recbody = tradeBill.getDynamicObject("recbody");
                if (EmptyUtil.isEmpty((DynamicObject)bankAccount)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u94f6\u884c\u8d26\u53f7\uff01", (String)"CdmBizResource_123", (String)"tmc-cdm-common", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((DynamicObject)recbody)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u53d7\u7406\u673a\u6784\uff01", (String)"CdmBizResource_124", (String)"tmc-cdm-common", (Object[])new Object[0]));
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)bankAccount) && EmptyUtil.isNoEmpty((DynamicObject)recbody)) {
                    String recBodyUionNum = "";
                    String bankAccUionNum = "";
                    DynamicObject bankAccBebank = bankAccount.getDynamicObject("bank");
                    HashSet<Long> pkIds = new HashSet<Long>();
                    pkIds.add(recbody.getLong("id"));
                    pkIds.add(bankAccBebank.getLong("id"));
                    DynamicObject[] dyArr = BusinessDataServiceHelper.load((String)"bd_finorginfo", (String)"id,union_number", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
                    Map<Long, List<DynamicObject>> map = Arrays.stream(dyArr).collect(Collectors.groupingBy(e -> e.getLong("id")));
                    List<DynamicObject> recbodyList = map.get(recbody.getLong("id"));
                    List<DynamicObject> bankAccList = map.get(bankAccBebank.getLong("id"));
                    if (EmptyUtil.isNoEmpty(recbodyList)) {
                        recBodyUionNum = recbodyList.get(0).getString("union_number");
                    }
                    if (EmptyUtil.isNoEmpty(bankAccList)) {
                        bankAccUionNum = bankAccList.get(0).getString("union_number");
                    }
                    if (EmptyUtil.isEmpty((String)recBodyUionNum) || EmptyUtil.isEmpty((String)bankAccUionNum)) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u53d7\u7406\u673a\u6784\u6216\u8005\u94f6\u884c\u8d26\u6237\u5f00\u6237\u884c\u7684\u8054\u884c\u53f7\u4e3a\u7a7a\u3002", (String)"CdmBizResource_105", (String)"tmc-cdm-common", (Object[])new Object[0]));
                    }
                }
            }
            if (tradeType.equals(DraftTradeTypeEnum.DISCOUNT.getValue())) {
                BigDecimal payInterestAmount;
                boolean ispayByAgree;
                BigDecimal discamt = tradeBill.getBigDecimal("discamt");
                if (discamt == null || discamt.floatValue() <= 0.0f) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8d34\u73b0\u6536\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"CdmBizResource_78", (String)"tmc-cdm-common", (Object[])new Object[0]));
                }
                if ((ispayByAgree = tradeBill.getBoolean("ispaybyagree")) && (EmptyUtil.isEmpty((BigDecimal)(payInterestAmount = tradeBill.getBigDecimal("payinterestamount"))) || BigDecimal.ZERO.compareTo(payInterestAmount) == 0)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u534f\u8bae\u4ed8\u606f\u65f6\uff0c\u8bf7\u586b\u5199\u4ed8\u606f\u4eba\u627f\u62c5\u8d34\u73b0\u5229\u606f\u3002", (String)"CdmBizResource_78_2", (String)"tmc-cdm-common", (Object[])new Object[0]));
                }
            }
            HashSet draftIds = new HashSet();
            entrys.stream().filter(p -> !EmptyUtil.isEmpty((DynamicObject)p.getDynamicObject("draftbill"))).forEach(v -> draftIds.add(v.getDynamicObject("draftbill").getPkValue()));
            String string = tradeBill.getString("source");
            if (!"endorse".equals(tradeType) || !EmptyUtil.isNoEmpty((Object)(companyId = PayableBillHelp.getCompanyIdByBeen((DynamicObject)tradeBill))) || !(isReceiveOppNote = DraftHelper.getCdmParameterBoolean((long)((Long)companyId), (String)"isreceiveoppnote"))) continue;
            String bankAcct = tradeBill.getString("bankacct");
            DynamicObject drafttypedata = BusinessDataServiceHelper.loadSingle((Object)draftType.getLong("id"), (String)"cdm_billtype");
            String billMedium = drafttypedata.getString("billmedium");
            if (EmptyUtil.isEmpty((String)bankAcct) && !"1".equals(billMedium)) continue;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean validateOtherBill(DynamicObject tradeBill) {
        block35: {
            DynamicObject[] otherPaybills;
            Object[] paybills;
            Set<Long> draftIds;
            DynamicObjectCollection entrys;
            String rptype;
            HashMap<String, Object> orgRecbill;
            block34: {
                if (EmptyUtil.isEmpty((DynamicObject)tradeBill)) {
                    return false;
                }
                HashMap<String, Object> orgPaybill = new HashMap<String, Object>();
                orgRecbill = new HashMap<String, Object>();
                rptype = tradeBill.getString("rptype");
                entrys = tradeBill.getDynamicObjectCollection("entrys");
                if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys) || entrys.size() == 0) {
                    return false;
                }
                draftIds = entrys.stream().map(e -> e.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet());
                QFilter qFilter = new QFilter("id", "in", (Object)draftIds.toArray(new Long[0]));
                paybills = ReceivePayTypeEnum.PAYBILL.getValue().equals(rptype) ? TmcDataServiceHelper.load((String)"cdm_payablebill", (String)"id,payeetype,draftbillno,subbillrange,receiver,receivername,company", (QFilter[])qFilter.toArray()) : TmcDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,payeetype,draftbillno,subbillrange,receiver,receivername,company", (QFilter[])qFilter.toArray());
                if (paybills == null || paybills.length < 1) {
                    return false;
                }
                Set<String> draftbillnos = Arrays.stream(paybills).map(o -> o.getString("draftbillno")).collect(Collectors.toSet());
                QFilter otherqFilter = new QFilter("draftbillno", "in", (Object)draftbillnos.toArray(new String[0]));
                otherqFilter.and("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue());
                otherqFilter.and("id", "not in", (Object)draftIds.toArray(new Long[0]));
                otherPaybills = TmcDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,payeetype,draftbillno,subbillrange,receiver,company,delivername", (QFilter[])otherqFilter.toArray());
                if (!ReceivePayTypeEnum.PAYBILL.getValue().equals(rptype)) break block34;
                if (EmptyUtil.isEmpty((Object[])paybills) || paybills.length < 1) {
                    return false;
                }
                for (Object paybill : paybills) {
                    DynamicObject innerOrg;
                    String payeetype = paybill.getString("payeetype");
                    String draftbillno = paybill.getString("draftbillno");
                    String string = paybill.getString("subbillrange");
                    String receivername = paybill.getString("receivername");
                    String companyname = paybill.getDynamicObject("company").getString("name");
                    DynamicObject receiver = paybill.getDynamicObject("receiver");
                    if ("bos_org".equals(payeetype)) {
                        String orgkey = draftbillno + string + receivername + companyname;
                        orgPaybill.put(orgkey, paybill);
                        continue;
                    }
                    if (!"bd_customer".equals(payeetype) && !"bd_supplier".equals(payeetype) || EmptyUtil.isEmpty((DynamicObject)receiver)) continue;
                    long receiverid = receiver.getLong("id");
                    if ("bd_customer".equals(payeetype)) {
                        DynamicObject customer = BusinessDataServiceHelper.loadSingle((Object)receiverid, (String)"bd_customer");
                        innerOrg = customer.getDynamicObject("internal_company");
                    } else {
                        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)receiverid, (String)"bd_supplier");
                        innerOrg = supplier.getDynamicObject("internal_company");
                    }
                    if (EmptyUtil.isEmpty((DynamicObject)innerOrg)) continue;
                    String innerOrgname = innerOrg.getString("name");
                    String supplierKey = draftbillno + string + innerOrgname + companyname;
                    orgPaybill.put(supplierKey, paybill);
                }
                if (otherPaybills == null || otherPaybills.length <= 0) break block35;
                for (int k = 0; k < otherPaybills.length; ++k) {
                    String otherDraftbillno = otherPaybills[k].getString("draftbillno");
                    String otherSubbillrange = otherPaybills[k].getString("subbillrange");
                    String otherDelivername = otherPaybills[k].getString("delivername");
                    String otherCompanyname = otherPaybills[k].getDynamicObject("company").getString("name");
                    String orgKey = otherDraftbillno + otherSubbillrange + otherCompanyname + otherDelivername;
                    if (!orgPaybill.containsKey(orgKey)) continue;
                    return true;
                }
                break block35;
            }
            if (ReceivePayTypeEnum.RECEIVEBILL.getValue().equals(rptype)) {
                HashMap allDraftBills = new HashMap();
                HashSet<Long> allTradBills = new HashSet<Long>();
                HashSet<Long> sonIds = new HashSet<Long>();
                if (EmptyUtil.isEmpty((Object[])paybills) || paybills.length < 1) {
                    return false;
                }
                QFilter tradFilter = new QFilter("entrys.draftbill", "in", (Object)draftIds.toArray(new Long[0]));
                tradFilter.and("tradetype", "=", (Object)DraftTradeTypeEnum.ENDORSE.getValue());
                Object[] draftBills = TmcDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id,beendorsor,payeetypetext,beendorsortext,entrys,entrys.draftbill", (QFilter[])tradFilter.toArray());
                if (draftBills == null || draftBills.length < 1) {
                    for (DynamicObject dynamicObject : entrys) {
                        Long dratId = dynamicObject.getDynamicObject("draftbill").getLong("equaltradebillid");
                        if (dratId == 0L) continue;
                        allTradBills.add(dratId);
                    }
                } else {
                    for (Object draftBill : draftBills) {
                        DynamicObjectCollection dynamicObjectCollection = draftBill.getDynamicObjectCollection("entrys");
                        if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) continue;
                        Iterator receiverid = dynamicObjectCollection.iterator();
                        while (receiverid.hasNext()) {
                            List<Object> list;
                            DynamicObject dynamicObject = (DynamicObject)receiverid.next();
                            DynamicObject receBill = dynamicObject.getDynamicObject("draftbill");
                            if (allDraftBills.containsKey(receBill)) {
                                list = (List)allDraftBills.get(receBill);
                                list.add(draftBill);
                                allDraftBills.put(receBill, list);
                                continue;
                            }
                            list = new ArrayList();
                            list.add(draftBill);
                            allDraftBills.put(receBill, list);
                        }
                    }
                }
                for (Map.Entry entry : allDraftBills.entrySet()) {
                    List list = (List)entry.getValue();
                    if (list.size() == 0) {
                        long equaltradebillid = ((DynamicObject)entry.getKey()).getLong("equaltradebillid");
                        allTradBills.add(equaltradebillid);
                    }
                    if (list.size() == 1) {
                        Long id = ((DynamicObject)list.get(0)).getLong("id");
                        allTradBills.add(id);
                    }
                    if (list.size() <= 1) continue;
                    Long recid = ((DynamicObject)entry.getKey()).getLong("id");
                    sonIds.add(recid);
                    for (DynamicObject bill : list) {
                        allTradBills.add(bill.getLong("id"));
                    }
                }
                if (EmptyUtil.isNoEmpty(sonIds)) {
                    Set receivableIds;
                    QFilter recFilter = new QFilter("supperbillid", "in", (Object)sonIds.toArray(new Long[0]));
                    recFilter.and("equaltradebillid", "!=", (Object)0L);
                    Object[] objectArray = TmcDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,equaltradebillid", (QFilter[])recFilter.toArray());
                    if (EmptyUtil.isNoEmpty((Object[])objectArray) && EmptyUtil.isNoEmpty(receivableIds = ((Stream)Arrays.stream(objectArray).parallel()).map(o -> o.getLong("equaltradebillid")).collect(Collectors.toSet()))) {
                        for (Long receivableId : receivableIds) {
                            allTradBills.remove(receivableId);
                        }
                    }
                }
                QFilter filter = new QFilter("id", "in", (Object)allTradBills.toArray(new Long[0]));
                tradFilter.and("tradetype", "=", (Object)DraftTradeTypeEnum.ENDORSE.getValue());
                draftBills = TmcDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id,beendorsor,payeetypetext,beendorsortext,entrys,entrys.draftbill", (QFilter[])filter.toArray());
                if (EmptyUtil.isEmpty((Object[])draftBills)) {
                    return false;
                }
                for (Object draftBill : draftBills) {
                    Object[] draftsentrys = draftBill.getDynamicObjectCollection("entrys");
                    if (draftsentrys != null && draftsentrys.size() >= 1) continue;
                    return false;
                }
                for (Object paybill : paybills) {
                    for (Object endroseTradBill : draftBills) {
                        DynamicObject innerOrg;
                        String payeetypetext = endroseTradBill.getString("payeetypetext");
                        String beendorsortext = endroseTradBill.getString("beendorsortext");
                        DynamicObject beendorsor = endroseTradBill.getDynamicObject("beendorsor");
                        String draftbillno = paybill.getString("draftbillno");
                        String subbillrange = paybill.getString("subbillrange");
                        String companyname = paybill.getDynamicObject("company").getString("name");
                        if ("bos_org".equals(payeetypetext)) {
                            String orgkey = draftbillno + subbillrange + beendorsortext + companyname;
                            orgRecbill.put(orgkey, paybill);
                            continue;
                        }
                        if (!"bd_customer".equals(payeetypetext) && !"bd_supplier".equals(payeetypetext) || EmptyUtil.isEmpty((DynamicObject)beendorsor)) continue;
                        long receiverid = beendorsor.getLong("id");
                        if ("bd_customer".equals(payeetypetext)) {
                            DynamicObject customer = BusinessDataServiceHelper.loadSingle((Object)receiverid, (String)"bd_customer");
                            innerOrg = customer.getDynamicObject("internal_company");
                        } else {
                            DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)receiverid, (String)"bd_supplier");
                            innerOrg = supplier.getDynamicObject("internal_company");
                        }
                        if (EmptyUtil.isEmpty((DynamicObject)innerOrg)) continue;
                        String innerOrgname = innerOrg.getString("name");
                        String supplierKey = draftbillno + subbillrange + innerOrgname + companyname;
                        orgRecbill.put(supplierKey, paybill);
                    }
                }
                if (otherPaybills != null && otherPaybills.length > 0) {
                    void var18_35;
                    boolean bl = false;
                    while (var18_35 < otherPaybills.length) {
                        String otherDraftbillno = otherPaybills[var18_35].getString("draftbillno");
                        String otherSubbillrange = otherPaybills[var18_35].getString("subbillrange");
                        String otherDelivername = otherPaybills[var18_35].getString("delivername");
                        String otherCompanyname = otherPaybills[var18_35].getDynamicObject("company").getString("name");
                        String orgKey = otherDraftbillno + otherSubbillrange + otherCompanyname + otherDelivername;
                        if (orgRecbill.containsKey(orgKey)) {
                            return true;
                        }
                        ++var18_35;
                    }
                }
            }
        }
        return false;
    }
}

