/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.writeback;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.DTX;
import kd.bos.kdtx.sdk.session.DTXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.tmc.cdm.business.lock.DraftOperateInfo;
import kd.tmc.cdm.business.lock.DraftOperateResultInfo;
import kd.tmc.cdm.business.lock.IDraftOperateService;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.business.service.param.TxServiceParam;
import kd.tmc.cdm.business.service.tradebill.TradeChangeBillHelper;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.ElcDraftBillOpEnum;
import kd.tmc.cdm.common.enums.LogBizStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;

public class ElcDraftBillWriteBackDraftBill {
    private static final Log logger = LogFactory.getLog(ElcDraftBillWriteBackDraftBill.class);

    public static Map<String, Object> validateAndWriteBack(Long draftId) {
        logger.info("ElcDraftBillWriteBackDraftBill validateAndWriteBack recBill draftId = {}", (Object)draftId);
        HashMap<String, Object> resMap = new HashMap<String, Object>(4);
        try {
            String draftBillTranStatus;
            resMap.put("issuccess", false);
            resMap.put("message", "");
            QFilter qFilter = new QFilter("entrys.draftbill.id", "=", (Object)draftId);
            qFilter.and(new QFilter("entrys.transtatus", "not in", (Object)new String[]{"failing", "success"}).or(new QFilter("draftbilltranstatus", "=", (Object)"handleing")));
            qFilter.and(new QFilter("entrys.entryisrepay", "=", (Object)"0"));
            qFilter.and(new QFilter("billstatus", "!=", (Object)"S"));
            qFilter.and(new QFilter("electag", "=", (Object)Boolean.TRUE));
            DynamicObject draftTradeBill = BusinessDataServiceHelper.loadSingle((String)"cdm_drafttradebill", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (draftTradeBill == null) {
                logger.info("ElcDraftBillWriteBackDraftBill validateAndWriteBack draftTradeBill is not exist draftId = {}", (Object)draftId);
                resMap.put("issuccess", false);
                resMap.put("message", ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u7968\u636e\u7ba1\u7406\u4e1a\u52a1\u5904\u7406\u5355", (String)"ElcDraftBillWriteBackDraftBill_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
                return resMap;
            }
            draftTradeBill = TmcDataServiceHelper.loadSingle((Object)draftTradeBill.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_drafttradebill"));
            switch (draftBillTranStatus = draftTradeBill.getString("draftbilltranstatus")) {
                case "success": {
                    logger.info("ElcDraftBillWriteBackDraftBill validateAndWriteBack draftTradeBill is success draftId = {},draftTradeBillNo = {}", (Object)draftId, (Object)draftTradeBill.getString("billno"));
                    resMap.put("issuccess", false);
                    resMap.put("message", ResManager.loadKDString((String)"\u7968\u636e\u7ba1\u7406\u4e1a\u52a1\u5904\u7406\u5355\u7684\u7968\u636e\u4ea4\u6613\u72b6\u6001\u4e3a\u4ea4\u6613\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u4fee\u6539\u3002", (String)"ElcDraftBillWriteBackDraftBill_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    break;
                }
                case "failing": {
                    logger.info("ElcDraftBillWriteBackDraftBill validateAndWriteBack draftTradeBill is failing draftId = {},draftTradeBillNo = {}", (Object)draftId, (Object)draftTradeBill.getString("billno"));
                    resMap.put("issuccess", false);
                    resMap.put("message", ResManager.loadKDString((String)"\u7968\u636e\u7ba1\u7406\u4e1a\u52a1\u5904\u7406\u5355\u7968\u636e\u4ea4\u6613\u72b6\u6001\u4e3a\u4ea4\u6613\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u4fee\u6539", (String)"ElcDraftBillWriteBackDraftBill_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    break;
                }
                case "porsuccess": {
                    logger.info("ElcDraftBillWriteBackDraftBill validateAndWriteBack draftTradeBill is porsuccess draftId = {},draftTradeBillNo = {}", (Object)draftId, (Object)draftTradeBill.getString("billno"));
                    resMap.put("issuccess", false);
                    resMap.put("message", ResManager.loadKDString((String)"\u7968\u636e\u7ba1\u7406\u4e1a\u52a1\u5904\u7406\u5355\u7684\u7968\u636e\u4ea4\u6613\u72b6\u6001\u4e3a\u90e8\u5206\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u4fee\u6539\u3002", (String)"ElcDraftBillWriteBackDraftBill_5", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    break;
                }
                default: {
                    logger.info("ElcDraftBillWriteBackDraftBill validateAndWriteBack do method writeBack draftId = {},draftTradeBillNo = {}", (Object)draftId, (Object)draftTradeBill.getString("billno"));
                    ElcDraftBillWriteBackDraftBill.writeBack(draftId, draftTradeBill);
                    resMap.put("issuccess", true);
                    resMap.put("message", ResManager.loadKDString((String)"\u7968\u636e\u7ba1\u7406\u4e1a\u52a1\u5904\u7406\u5355\u7968\u636e\u4ea4\u6613\u72b6\u6001\u66f4\u65b0\u6210\u529f", (String)"ElcDraftBillWriteBackDraftBill_3", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u7535\u7968\u540c\u6b65\u3001\u67e5\u8be2\u53ca\u64cd\u4f5c\u540e\u53cd\u5199\u66f4\u65b0\u7968\u636e\u4e1a\u52a1\u5904\u7406\u5355\u636e\u5934\u7968\u636e\u4ea4\u6613\u72b6\u6001\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
        return resMap;
    }

    private static void updateLogBizStatus(Long draftId, DynamicObject draftTradeBill) {
        String draftBillTranStatus = draftTradeBill.getString("draftbilltranstatus");
        logger.info("updateLogBizStatus start..." + draftBillTranStatus);
        if (StringUtils.equals((CharSequence)draftBillTranStatus, (CharSequence)"failing")) {
            DynamicObjectCollection dynamicObjects = draftTradeBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : dynamicObjects) {
                DynamicObject draftBill = entry.getDynamicObject("draftbill");
                BigDecimal billAmt = entry.getBigDecimal("billamt");
                DynamicObject receivableBill = TmcDataServiceHelper.loadSingle((Object)draftBill.getPkValue(), (String)"cdm_receivablebill");
                BigDecimal billAmountAvailable = BigDecimal.ZERO;
                if (EmptyUtil.isNoEmpty((DynamicObject)receivableBill)) {
                    billAmountAvailable = receivableBill.getBigDecimal("amount");
                }
                boolean isAllTransfer = billAmt.compareTo(billAmountAvailable) == 0;
                Long billLogId = entry.getLong("billlogid");
                if (!Objects.equals(draftId, draftBill.getPkValue()) || !EmptyUtil.isNoEmpty((Long)billLogId) || billLogId <= 0L) continue;
                QFilter qFilter = new QFilter("id", "=", (Object)billLogId);
                qFilter.and("deleteflag", "=", (Object)Character.valueOf('0'));
                Object[] draftBillLogs = TmcDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,bizstatus", (QFilter[])qFilter.toArray());
                if (EmptyUtil.isEmpty((Object[])draftBillLogs)) continue;
                Object draftBillLog = draftBillLogs[0];
                String bizstatus = draftBillLog.getString("bizstatus");
                if (!LogBizStatusEnum.FAIL.getValue().equalsIgnoreCase(bizstatus)) {
                    draftBillLog.set("bizstatus", (Object)LogBizStatusEnum.FAIL.getValue());
                    SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{draftBillLog});
                }
                logger.info("updateLogBizStatus update log set fail status,draftId = {},billLogId = {}", (Object)draftId, (Object)billLogId);
            }
        }
    }

    private static void writeBack(Long draftId, DynamicObject draftTradeBill) {
        try {
            DynamicObjectCollection dynamicObjects = draftTradeBill.getDynamicObjectCollection("entrys");
            HashMap<Object, Map> changeBillParamMap = new HashMap<Object, Map>(8);
            for (DynamicObject entry : dynamicObjects) {
                DynamicObject draftBill = entry.getDynamicObject("draftbill");
                String transStatus = entry.getString("transtatus");
                if (Objects.equals(draftId, draftBill.getPkValue())) {
                    QFilter findEleBillFilter = new QFilter("sourceid", "=", (Object)draftId);
                    DynamicObjectCollection eleBill = QueryServiceHelper.query((String)"cdm_electronic_rec_deal", (String)"id,ebstatus,subrange,cirstatus,tradetype,bankmsg", (QFilter[])new QFilter[]{findEleBillFilter});
                    if (eleBill.size() > 0) {
                        transStatus = ElcDraftBillWriteBackDraftBill.getDraftBillTranStatus(((DynamicObject)eleBill.get(0)).getString("ebstatus"));
                        String tradeType = ((DynamicObject)eleBill.get(0)).getString("tradetype");
                        if (ElcDraftBillOpEnum.NOTECANCLE.getValue().equals(tradeType) && DraftTranStatusEnum.SUCCESS.getValue().equals(transStatus)) {
                            entry.set("transtatus", (Object)DraftTranStatusEnum.FAILING.getValue());
                        } else {
                            entry.set("transtatus", (Object)transStatus);
                        }
                        String bankMsg = ((DynamicObject)eleBill.get(0)).getString("bankmsg");
                        entry.set("e_bankmsg", (Object)bankMsg);
                        logger.info("ElcDraftBillWriteBackDraftBill writeBack draftId = {},draftTradeBillNo = {},draftBillTranStatus = {},tranStatus = {},eleBillId = {},eleBillEbStatus = {}", new Object[]{draftId, draftTradeBill.getString("billno"), draftBill.getString("draftbilltranstatus"), entry.getString("transtatus"), ((DynamicObject)eleBill.get(0)).getLong("id"), ((DynamicObject)eleBill.get(0)).getString("ebstatus")});
                    } else {
                        logger.info("ElcDraftBillWriteBackDraftBill writeBack draftId = {},draftTradeBillNo = {},draftBillTranStatus = {},tranStatus = {} has not ele bill", new Object[]{draftId, draftTradeBill.getString("billno"), draftBill.getString("draftbilltranstatus"), entry.getString("transtatus")});
                    }
                    String eleSubRange = draftBill.getString("subbillrange");
                    String recBillSubRange = ((DynamicObject)eleBill.get(0)).getString("subrange");
                    logger.info("elebill or recbill subrange:eleSubRange:" + eleSubRange + ",recBillSubRange:" + recBillSubRange + ", billId:" + draftId + ",biltradenumber:" + draftTradeBill.getString("billno"));
                    boolean isSameSubRange = eleSubRange.equals(recBillSubRange);
                    if (!isSameSubRange && ElcDraftBillWriteBackDraftBill.isNonSplitSubRange(eleSubRange) && ElcDraftBillWriteBackDraftBill.isNonSplitSubRange(recBillSubRange)) {
                        logger.info("elebill or recbill subrange is 0 or null:eleSubRange:" + eleSubRange + ",recBillSubRange:" + recBillSubRange);
                        isSameSubRange = true;
                    }
                    String ebstatusStr = ((DynamicObject)eleBill.get(0)).getString("ebstatus");
                    boolean isFinishEbstatus = EbStatus.BANK_SUCCESS.getName().equals(ebstatusStr) || EbStatus.BANK_FAIL.getName().equals(ebstatusStr) || EbStatus.BANK_PROCESSING.getName().equals(ebstatusStr) || "BANK_UNKNOWN".equals(ebstatusStr);
                    logger.info("isSameSubRange:" + isSameSubRange + ",isFinishEbstatus:" + isFinishEbstatus);
                    if (!isSameSubRange && isFinishEbstatus) {
                        boolean isprocessSplit = EbStatus.BANK_PROCESSING.getName().equals(ebstatusStr) || "BANK_UNKNOWN".equals(ebstatusStr);
                        long orgId = draftTradeBill.getDynamicObject("company").getLong("id");
                        boolean splitChangeBillParam = (Boolean)SystemParamServiceHelper.getAppParameter((String)AppMetadataCache.getAppInfo((String)"cdm").getId(), (String)"08", (Long)orgId, (String)"splitchangebill");
                        boolean isFinishSplit = EbStatus.BANK_SUCCESS.getName().equals(ebstatusStr) || EbStatus.BANK_FAIL.getName().equals(ebstatusStr);
                        boolean isNeedChangeBill = isFinishSplit && splitChangeBillParam || isprocessSplit;
                        logger.info("isprocessSplit is:" + isprocessSplit + ",splitChangeBillParam:" + splitChangeBillParam + ",isFinishSplit:" + isFinishSplit + ",isNeedChangeBill:" + isNeedChangeBill);
                        IDraftOperateService instance = IDraftOperateService.getInstance();
                        DraftOperateInfo draftOperateInfo = LockDraftHelper.fillOperateInfo(Boolean.TRUE, draftTradeBill, draftId, false);
                        draftOperateInfo.setIsneedchangebill(isNeedChangeBill);
                        draftOperateInfo.setEbStatusStr(ebstatusStr);
                        List draftOperateResultInfoList = instance.confirm(draftOperateInfo);
                        logger.info("is empty draftOperateResultInfoList: + " + EmptyUtil.isNoEmpty((Object)draftOperateResultInfoList));
                        ElcDraftBillWriteBackDraftBill.fillBillLogId(draftTradeBill, draftOperateResultInfoList);
                        Object draftTradeBillId = draftTradeBill.getPkValue();
                        if (isNeedChangeBill && EmptyUtil.isNoEmpty((Object)draftOperateResultInfoList)) {
                            Map draftIdMap = changeBillParamMap.getOrDefault(draftTradeBillId, new HashMap(8));
                            for (DraftOperateResultInfo draftOperateResultInfo : draftOperateResultInfoList) {
                                long supperDraftId = draftOperateResultInfo.getDraftId();
                                DynamicObject subBillDy = draftOperateResultInfo.getSubBillDy();
                                if (!EmptyUtil.isNoEmpty((DynamicObject)subBillDy)) continue;
                                draftIdMap.put(supperDraftId, subBillDy.getPkValue());
                            }
                            changeBillParamMap.put(draftTradeBillId, draftIdMap);
                            logger.info("ElcDraftBillWriteBackDraftBill writeBack paramMap = {}", (Object)SerializationUtils.toJsonString(changeBillParamMap));
                        }
                        logger.info("ElcDraftBillWriteBackDraftBill writeBack draftId = {},draftTradeBillNo = {},subBillRange = {},subRange = {}", new Object[]{draftId, draftTradeBill.getString("billno"), draftBill.getString("subbillrange"), ((DynamicObject)eleBill.get(0)).getString("subrange")});
                    }
                }
                logger.info("ElcDraftBillWriteBackDraftBill writeBack loop draftId = {},draftTradeBillNo = {},transStatus = {}", new Object[]{draftBill.getPkValue(), draftTradeBill.getString("billno"), transStatus});
            }
            List failedList = dynamicObjects.stream().filter(o -> DraftTranStatusEnum.FAILING.getValue().equals(o.getString("transtatus"))).collect(Collectors.toList());
            List successList = dynamicObjects.stream().filter(o -> DraftTranStatusEnum.SUCCESS.getValue().equals(o.getString("transtatus"))).collect(Collectors.toList());
            if (failedList.size() > 0 && failedList.size() == dynamicObjects.size()) {
                draftTradeBill.set("draftbilltranstatus", (Object)DraftTranStatusEnum.FAILING.getValue());
            } else if (successList.size() > 0 && failedList.size() > 0 && successList.size() + failedList.size() == dynamicObjects.size()) {
                draftTradeBill.set("draftbilltranstatus", (Object)DraftTranStatusEnum.PORSUCCESS.getValue());
            }
            if (DraftTranStatusEnum.FAILING.getValue().equals(draftTradeBill.getString("draftbilltranstatus"))) {
                draftTradeBill.set("electag", (Object)"0");
            }
            logger.info("ElcDraftBillWriteBackDraftBill writeBack draftId = {},draftTradeBillNo = {},successList.size = {},failedList.size={}", new Object[]{draftId, draftTradeBill.getString("billno"), successList.size(), failedList.size()});
            ElcDraftBillWriteBackDraftBill.updateLogBizStatus(draftId, draftTradeBill);
            try (DTXHandle dtx = DTX.requiresNew((String)"cdm_storage_rec", (DBRoute)DBRoute.of((String)"tmc"));){
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{draftTradeBill});
                if (changeBillParamMap.size() > 0) {
                    logger.info("ElcDraftBillWriteBackDraftBill tradeAutoChangeBill paramMap = {}", (Object)SerializationUtils.toJsonString(changeBillParamMap));
                    TradeChangeBillHelper.tradeAutoChangeBill(changeBillParamMap);
                    draftTradeBill = TmcDataServiceHelper.loadSingle((Object)draftTradeBill.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_drafttradebill"));
                }
                try {
                    TxServiceParam param = new TxServiceParam();
                    param.setParams(new Object[]{draftId, draftTradeBill});
                    dtx.register("tmc", "cdm", "StorageRecBillTxService", (Param)param, "", draftTradeBill.getPkValue().toString());
                }
                catch (Exception e) {
                    logger.error("ElcDraftBillWriteBackDraftBill.writeBack drawbillsave error", (Throwable)e);
                    dtx.markRollback();
                    throw new RuntimeException(e);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u7535\u7968\u540c\u6b65\u3001\u67e5\u8be2\u53ca\u64cd\u4f5c\u540e\u53cd\u5199\u66f4\u65b0\u7968\u636e\u4e1a\u52a1\u5904\u7406\u5355\u636e\u5934\u7968\u636e\u4ea4\u6613\u72b6\u6001\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static boolean isNonSplitSubRange(String eleSubRange) {
        return "0".equals(eleSubRange) || EmptyUtil.isEmpty((String)eleSubRange);
    }

    private static String getDraftBillTranStatus(String ebstatus) {
        switch (ebstatus) {
            case "BANK_PROCESSING": {
                return "handleing";
            }
            case "BANK_SUCCESS": {
                return "success";
            }
            case "BANK_FAIL": {
                return "failing";
            }
            case "BANK_EXCEPTION": {
                return "handleing";
            }
            case "EB_PROCESSING": 
            case "BANK_UNKNOWN": {
                return "handleing";
            }
        }
        return "";
    }

    private static void fillBillLogId(DynamicObject draftTradeBill, List<DraftOperateResultInfo> draftOperateResultInfoList) {
        long draftTradeBillId = draftTradeBill.getLong("id");
        DynamicObject draftTradeBillNew = BusinessDataServiceHelper.loadSingle((Object)draftTradeBillId, (String)"cdm_drafttradebill");
        Map<Long, Long> draftIdAndLogIdMap = draftOperateResultInfoList.stream().filter(e -> EmptyUtil.isNoEmpty((Long)e.getDraftId()) && EmptyUtil.isNoEmpty((Long)e.getLogid())).collect(Collectors.toMap(DraftOperateResultInfo::getDraftId, DraftOperateResultInfo::getLogid));
        DynamicObjectCollection dynamicObjectCollection = draftTradeBillNew.getDynamicObjectCollection("entrys");
        for (DynamicObject entry : dynamicObjectCollection) {
            Long logIdFromNewAdd;
            long draftId = entry.getDynamicObject("draftbill").getLong("id");
            long logId = entry.getLong("billlogid");
            if (!EmptyUtil.isEmpty((Long)logId) || !EmptyUtil.isNoEmpty(draftIdAndLogIdMap) || !EmptyUtil.isNoEmpty((Long)(logIdFromNewAdd = draftIdAndLogIdMap.get(draftId)))) continue;
            entry.set("billlogid", (Object)logIdFromNewAdd);
        }
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{draftTradeBillNew});
    }
}

