/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BillPoolHelper {
    public static Map<Long, String> getAuthorizedBillPool(List<Long> authOrgIds) {
        DataSet query;
        HashMap<Long, String> map = new HashMap<Long, String>(32);
        int top = 20;
        if (EmptyUtil.isEmpty(authOrgIds)) {
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            query = QueryServiceHelper.queryDataSet((String)"BillPoolHelper_BILLPOOL", (String)"cdm_billpool", (String)"id,name", (QFilter[])qFilter.toArray(), null, (int)top);
        } else {
            ArrayList<Long> poolIds = new ArrayList<Long>(10);
            String distinctPoll = "select distinct t.fid id from t_cdm_billpool t left join t_cdm_billpool_entry e on t.fid = e.fid where t.fenable = '1' and (t.fcompanyid in (%s) or e.fcompanyid in (%s));";
            String ids = TmcBusinessBaseHelper.idListToString(new ArrayList<Long>(authOrgIds));
            DataSet distinctBillpoll = DB.queryDataSet((String)"queryGuaranteeData", (DBRoute)DBRouteConst.TMC, (String)String.format(distinctPoll, ids, ids));
            if (!distinctBillpoll.isEmpty()) {
                int count = 0;
                for (Row row : distinctBillpoll) {
                    poolIds.add(row.getLong("id"));
                    if (++count < top) continue;
                    break;
                }
            }
            QFilter qFilter = new QFilter("id", "in", poolIds);
            query = QueryServiceHelper.queryDataSet((String)"BillPoolHelper_BILLPOOL", (String)"cdm_billpool", (String)"id,name", (QFilter[])qFilter.toArray(), null, (int)top);
        }
        for (Row row : query) {
            map.put(row.getLong("id"), row.getString("name"));
        }
        return map;
    }

    public static QFilter getBillPoolQFilter(List<Long> companyIds) {
        QFilter billPoolFilter = new QFilter("enable", "=", (Object)"1");
        QFilter memberFilter = new QFilter("entryentity.e_company", "in", companyIds).or(new QFilter("company", "in", companyIds));
        return billPoolFilter.and(memberFilter);
    }

    public static List<ComboItem> initBillPoolList(Map<Long, String> billPools) {
        ArrayList<ComboItem> billPoolItems = new ArrayList<ComboItem>(10);
        for (Map.Entry<Long, String> entry : billPools.entrySet()) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(entry.getValue()));
            item.setValue(String.valueOf(entry.getKey()));
            billPoolItems.add(item);
        }
        return billPoolItems;
    }
}

