/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.tmc.cdm.common.enums.BillMediumEnum;
import kd.tmc.cdm.common.enums.BillStatusEnum;
import kd.tmc.cdm.common.enums.BillTypeUnitEnum;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.helper.BotpHelper;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.common.bean.TransBillUpdatePaidInfo;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitInfo;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DraftHelper {
    private static final Log logger = LogFactory.getLog(DraftHelper.class);
    private static final String BANKBILLTYPE = "6";
    private static final String BUSSINESSBILLTYPE = "5";
    private static final String BILLTYPE = "3";

    public static boolean isPromissory(Object draftType) {
        return draftType instanceof DynamicObject && StringUtils.equals((CharSequence)SettleMentTypeEnum.PROMISSORY.getValue(), (CharSequence)((DynamicObject)draftType).getString("settlementtype"));
    }

    public static void deleteRation(String sBillId, String tBillId) {
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        String sBuilder = "delete from T_BOTP_BillTracker where FSBillId= ? and FTBillId= ?";
        params.add(new SqlParameter(":FSBillId", -5, (Object)sBillId));
        params.add(new SqlParameter(":FTBillId", -5, (Object)tBillId));
        try (TXHandle tx = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.basedata, (String)sBuilder, (Object[])params.toArray(new SqlParameter[params.size()]));
        }
    }

    public static boolean getCdmParameterBoolean(long orgId, String key) {
        Object value = SystemParamServiceHelper.getAppParameter((String)"0=GV6L3QZ3D+", (String)"08", (Long)orgId, (String)key);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return "true".equals(value);
    }

    public static boolean isElectricDraft(DynamicObject draftBillType) {
        return BillMediumEnum.ELECTRIC.getValue().equals(draftBillType.getString("billmedium"));
    }

    public static boolean existsRecBill(Long draftBillId) {
        QFilter filter = new QFilter("draftbill.fbasedataid.id", "in", (Object)draftBillId);
        filter.and("billstatus", "=", (Object)BillStatusEnum.PAY.getValue());
        filter.and("hotaccount", "=", (Object)"");
        DynamicObject objs = BusinessDataServiceHelper.loadSingle((String)"cas_recbill", (String)"id", (QFilter[])new QFilter[]{filter});
        return objs != null && objs.getLong("id") != 0L;
    }

    public static Map<Long, Boolean> existsRecBillByBatch(Object[] draftBillId) {
        DynamicObject[] objs;
        HashMap<Long, Boolean> billIdAndExsitMap = new HashMap<Long, Boolean>(8);
        QFilter filter = new QFilter("draftbill.fbasedataid.id", "in", (Object)draftBillId);
        filter.and("billstatus", "=", (Object)BillStatusEnum.PAY.getValue());
        filter.and("hotaccount", "=", (Object)"");
        for (DynamicObject recBill : objs = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,draftbill.fbasedataid.id", (QFilter[])new QFilter[]{filter})) {
            DynamicObjectCollection draftbills = recBill.getDynamicObjectCollection("draftbill");
            for (DynamicObject draftbill : draftbills) {
                billIdAndExsitMap.put(draftbill.getLong("fbasedataid.id"), true);
            }
        }
        return billIdAndExsitMap;
    }

    public static List<Long> getBillIds(Long draftBillId, boolean isLinkUp, String entityName) {
        boolean isEqualBill;
        DynamicObjectCollection draftDyColl;
        if ("cas_paybill".equals(entityName) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(draftDyColl = QueryServiceHelper.query((String)"cdm_draftbillf7", (String)"id,rptype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)draftBillId)})))) {
            List<Long> casPayBillList;
            DynamicObject draftDy = (DynamicObject)draftDyColl.get(0);
            String rptype = draftDy.getString("rptype");
            DynamicObjectCollection draftBillArr = new DynamicObjectCollection();
            draftBillArr = "paybill".equals(rptype) ? QueryServiceHelper.query((String)"cdm_payablebill", (String)"id,releatedcasbillentrys,releatedcasbillentrys.rel_billtype,releatedcasbillentrys.rel_billno,releatedcasbillentrys.rel_billid,releatedcasbillentrys.rel_bizdate,releatedcasbillentrys.rel_billamount,releatedcasbillentrys.rel_isrefuse,releatedcasbillentrys.rel_modifytime,releatedcasbillentrys.rel_createtime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)draftBillId), new QFilter("rptype", "=", (Object)"paybill")}) : QueryServiceHelper.query((String)"cdm_receivablebill", (String)"id,releatedcasbillentrys,releatedcasbillentrys.rel_billtype,releatedcasbillentrys.rel_billno,releatedcasbillentrys.rel_billid,releatedcasbillentrys.rel_bizdate,releatedcasbillentrys.rel_billamount,releatedcasbillentrys.rel_isrefuse,releatedcasbillentrys.rel_modifytime,releatedcasbillentrys.rel_createtime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)draftBillId), new QFilter("rptype", "=", (Object)"receivebill")});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)draftBillArr) && draftBillArr.size() > 0 && EmptyUtil.isNoEmpty(casPayBillList = draftBillArr.stream().filter(e -> !e.getBoolean("releatedcasbillentrys.rel_isrefuse") && "cas_paybill".equalsIgnoreCase(e.getString("releatedcasbillentrys.rel_billtype"))).map(e -> e.getLong("releatedcasbillentrys.rel_billid")).collect(Collectors.toList()))) {
                return casPayBillList;
            }
        }
        ArrayList<Long> paybillIds = new ArrayList<Long>(0);
        DynamicObject drafttradebill = TmcDataServiceHelper.loadSingle((String)"cdm_drafttradebill", (String)"id", (QFilter[])new QFilter("entrys.draftbill.id", "=", (Object)draftBillId).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("tradetype", "=", (Object)DraftTradeTypeEnum.ENDORSE.getValue()).and("draftbilltranstatus", "=", (Object)DraftTranStatusEnum.SUCCESS.getValue()).toArray());
        logger.info("getBillIds -> query drafttradebill is:" + EmptyUtil.isEmpty((DynamicObject)drafttradebill));
        DynamicObject receivableBill = TmcDataServiceHelper.loadSingle((String)"cdm_receivablebill", (String)"id,draftbillno,company,isequalbill,supperbillid,equaltradebillid", (QFilter[])new QFilter("id", "=", (Object)draftBillId).toArray());
        if (null == drafttradebill && (isEqualBill = receivableBill.getBoolean("isequalbill"))) {
            long splitTradeId = receivableBill.getLong("equaltradebillid");
            logger.info("getBillIds -> query splitTradeId is:" + splitTradeId);
            if (EmptyUtil.isNoEmpty((Long)splitTradeId)) {
                drafttradebill = TmcDataServiceHelper.loadSingle((String)"cdm_drafttradebill", (String)"id", (QFilter[])new QFilter("id", "=", (Object)splitTradeId).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("tradetype", "=", (Object)DraftTradeTypeEnum.ENDORSE.getValue()).and("draftbilltranstatus", "=", (Object)DraftTranStatusEnum.SUCCESS.getValue()).toArray());
            } else {
                long supperBillId = receivableBill.getLong("supperbillid");
                drafttradebill = TmcDataServiceHelper.loadSingle((String)"cdm_drafttradebill", (String)"id", (QFilter[])new QFilter("entrys.draftbill.id", "=", (Object)supperBillId).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("tradetype", "=", (Object)DraftTradeTypeEnum.ENDORSE.getValue()).and("draftbilltranstatus", "=", (Object)DraftTranStatusEnum.SUCCESS.getValue()).toArray());
            }
            logger.info("getBillIds -> query drafttradebill is:" + EmptyUtil.isEmpty((DynamicObject)drafttradebill));
            if (drafttradebill != null) {
                paybillIds.addAll(BotpHelper.getLinkedBillIds((Long)drafttradebill.getLong("id"), (boolean)isLinkUp, (String)entityName));
                if (EmptyUtil.isEmpty(paybillIds)) {
                    Set<Long> payBillIds = DraftHelper.foundPayBillByLog(draftBillId);
                    paybillIds.addAll(payBillIds);
                }
                logger.info("paybillIds is Empty after tradebill:" + EmptyUtil.isEmpty(paybillIds));
                return paybillIds;
            }
        }
        if (drafttradebill != null) {
            paybillIds.addAll(BotpHelper.getLinkedBillIds((Long)drafttradebill.getLong("id"), (boolean)isLinkUp, (String)entityName));
            logger.info("paybillIds is Empty after tradebill:" + EmptyUtil.isEmpty(paybillIds));
        }
        paybillIds.addAll(BotpHelper.getLinkedBillIds((Long)draftBillId, (boolean)isLinkUp, (String)entityName));
        logger.info("paybillIds is Empty after bill:" + EmptyUtil.isEmpty(paybillIds));
        if ("cas_paybill".equals(entityName)) {
            String draftbillno = receivableBill.getString("draftbillno");
            DynamicObject company = receivableBill.getDynamicObject("company");
            logger.info("query receivableBill by id, draftBillId=" + draftBillId + ",draftbillno=" + draftbillno);
            DynamicObjectCollection paybillsById = QueryServiceHelper.query((String)"cas_paybill", (String)"id", (QFilter[])new QFilter("draftbill.fbasedataid.id", "=", (Object)draftBillId).and("org.id", "=", (Object)company.getLong("id")).and("billstatus", "=", (Object)BillStatusEnum.PAY.getValue()).and("actpayamt", ">", (Object)0).toArray());
            logger.info("query paybills by draftbillId org:" + EmptyUtil.isEmpty((DynamicObjectCollection)paybillsById));
            if (paybillsById != null && paybillsById.size() > 0) {
                paybillIds.addAll(paybillsById.stream().map(item -> item.getLong("id")).collect(Collectors.toList()));
                logger.info("paybillIds is Empty after cas:" + EmptyUtil.isEmpty(paybillIds));
            } else {
                DynamicObjectCollection paybills = QueryServiceHelper.query((String)"cas_paybill", (String)"id", (QFilter[])new QFilter("draftbill.fbasedataid.draftbillno", "=", (Object)draftbillno).and("org.id", "=", (Object)company.getLong("id")).and("billstatus", "=", (Object)BillStatusEnum.PAY.getValue()).and("actpayamt", ">", (Object)0).toArray());
                logger.info("query paybills by draftbillno org:" + EmptyUtil.isEmpty((DynamicObjectCollection)paybills));
                if (paybills != null && paybills.size() > 0) {
                    paybillIds.addAll(paybills.stream().map(item -> item.getLong("id")).collect(Collectors.toList()));
                    logger.info("paybillIds is Empty after cas:" + EmptyUtil.isEmpty(paybillIds));
                }
            }
        }
        if (EmptyUtil.isEmpty(paybillIds)) {
            Set<Long> refundTradeBill = DraftHelper.isRefundTradeBill(draftBillId);
            paybillIds.addAll(refundTradeBill);
        }
        paybillIds = paybillIds.stream().distinct().collect(Collectors.toList());
        return paybillIds;
    }

    private static Set<Long> foundPayBillByLog(Long draftBillId) {
        Long id;
        QFilter payMentFilter;
        Object[] payMentBills;
        HashSet<Long> payBillSet = new HashSet<Long>();
        QFilter qFilter = new QFilter("splitedsubbillid", "=", (Object)draftBillId);
        DynamicObject draftBillLog = BusinessDataServiceHelper.loadSingle((String)"cdm_draftbill_log", (String)"id,draftid", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObject)draftBillLog) && EmptyUtil.isNoEmpty((Object[])(payMentBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id", (QFilter[])(payMentFilter = new QFilter("cas_draftinfo.draftbilllogid", "=", (Object)(id = Long.valueOf(draftBillLog.getLong("id"))))).toArray())))) {
            for (Object payMentBill : payMentBills) {
                payBillSet.add(payMentBill.getLong("id"));
            }
        }
        return payBillSet;
    }

    public static boolean existsEntityBill(Long draftBillId, boolean isLinkUp, String entityName) {
        List<Long> tBillIds = DraftHelper.getBillIds(draftBillId, isLinkUp, entityName);
        return tBillIds != null && tBillIds.size() > 0;
    }

    public static boolean isRefund(Object[] selectedPKValues, boolean isCheckCasPaybill) {
        boolean result = QueryServiceHelper.exists((String)"cdm_draftbillf7", (QFilter[])new QFilter("id", "in", (Object)selectedPKValues).and(new QFilter("rptype", "=", (Object)"receivebill").and("draftbillstatus", "=", (Object)DraftBillStatusEnum.ENDORSED.getValue()).or(new QFilter("rptype", "=", (Object)"paybill").and("draftbillstatus", "=", (Object)DraftBillStatusEnum.REGISTERED.getValue()))).toArray());
        boolean isRefund = QueryServiceHelper.exists((String)"cdm_drafttradebill", (QFilter[])new QFilter("entrys.draftbill.id", "in", (Object)selectedPKValues).and("tradetype", "=", (Object)DraftTradeTypeEnum.REFUND.getValue()).and("billstatus", "!=", (Object)"S").and("draftbilltranstatus", "!=", (Object)"success").toArray());
        logger.info("result is:" + result + ",isRefund:" + isRefund);
        if (result && !isRefund) {
            for (Object selectedPKValue : selectedPKValues) {
                if (selectedPKValue != null && (!isCheckCasPaybill || DraftHelper.existsEntityBill(Long.parseLong(selectedPKValue.toString()), true, "cas_paybill"))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Set<Long> isRefundTradeBill(Long selectedPKValue) {
        logger.info("isRefundTradeBill is start!");
        HashSet<Long> payBillSet = new HashSet<Long>();
        DynamicObject drafttradebill = TmcDataServiceHelper.loadSingle((String)"cdm_drafttradebill", (String)"id,sourcebillid", (QFilter[])new QFilter("entrys.draftbill.id", "=", (Object)selectedPKValue).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("tradetype", "=", (Object)DraftTradeTypeEnum.ENDORSE.getValue()).and("isrepaygen", "=", (Object)"1").and("draftbilltranstatus", "=", (Object)DraftTranStatusEnum.SUCCESS.getValue()).toArray());
        if (drafttradebill != null) {
            DynamicObjectCollection paybills;
            long sourcebillid = drafttradebill.getLong("sourcebillid");
            logger.info("isRefundTradeBill drafttradebill is" + drafttradebill.getLong("id") + ",sourcebillid is:" + sourcebillid);
            if (EmptyUtil.isNoEmpty((Long)sourcebillid) && (paybills = QueryServiceHelper.query((String)"cas_paybill", (String)"id", (QFilter[])new QFilter("id", "=", (Object)sourcebillid).and("billstatus", "=", (Object)BillStatusEnum.PAY.getValue()).and("actpayamt", ">", (Object)0).toArray())) != null && paybills.size() > 0) {
                logger.info("isRefundTradeBill is true");
                Set paybillId = paybills.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
                payBillSet.addAll(paybillId);
            }
        }
        logger.info("isRefundTradeBill is payBillSet:" + SerializationUtils.toJsonString(payBillSet));
        return payBillSet;
    }

    public static QFilter getAuditRegisterRecBill() {
        QFilter qFilterStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter qFilterRptype = new QFilter("rptype", "=", (Object)"receivebill");
        QFilter qFilterDraftBIllStatus = new QFilter("draftbillstatus", "=", (Object)"registered");
        QFilter qFilterDraftBIllTranStatus = new QFilter("draftbilltranstatus", "=", (Object)"success");
        return qFilterStatus.and(qFilterRptype).and(qFilterDraftBIllStatus).and(qFilterDraftBIllTranStatus);
    }

    public static String tradeTypeStatus(String tradeType) {
        switch (tradeType) {
            case "endorse": {
                return DraftBillStatusEnum.ENDORSED.getValue();
            }
            case "discount": {
                return DraftBillStatusEnum.DISCOUNTED.getValue();
            }
            case "pledge": {
                return DraftBillStatusEnum.PLEDGED.getValue();
            }
            case "billsplit": {
                return DraftBillStatusEnum.REGISTERED.getValue();
            }
        }
        return "";
    }

    public static boolean isNeedContorlApply(Long orgId, String billTypeStr) {
        String appId;
        String applybilltype;
        boolean isNeedContorl = false;
        boolean isapply = DraftHelper.getCdmParameterBoolean(orgId, "isapply");
        if (isapply && EmptyUtil.isNoEmpty((String)(applybilltype = (String)SystemParamServiceHelper.getAppParameter((String)(appId = AppMetadataCache.getAppInfo((String)"cdm").getId()), (String)"08", (Long)orgId, (String)"applybilltype")))) {
            Set applybilltypeArr = Arrays.stream(applybilltype.split(",", -1)).collect(Collectors.toSet());
            if (applybilltypeArr.contains(billTypeStr)) {
                isNeedContorl = true;
            } else if ((BANKBILLTYPE.equals(billTypeStr) || BUSSINESSBILLTYPE.equals(billTypeStr)) && applybilltypeArr.contains(BILLTYPE)) {
                isNeedContorl = true;
            }
        }
        return isNeedContorl;
    }

    public static boolean isNeedContorlApply(Set<String> applybilltypeArr, String billTypeStr) {
        boolean isNeedContorl = false;
        if (EmptyUtil.isNoEmpty(applybilltypeArr)) {
            if (applybilltypeArr.contains(billTypeStr)) {
                isNeedContorl = true;
            } else if ((BANKBILLTYPE.equals(billTypeStr) || BUSSINESSBILLTYPE.equals(billTypeStr)) && applybilltypeArr.contains(BILLTYPE)) {
                isNeedContorl = true;
            }
        }
        return isNeedContorl;
    }

    public static void setBillCodeinfo(DynamicObject bill) {
        long billId;
        BigDecimal amount = bill.getBigDecimal("amount");
        String originalsubbillrang = bill.getString("originalsubbillrang");
        String billidentitycode = bill.getString("billidentitycode");
        String draftbillno = bill.getString("draftbillno");
        BigDecimal originalsubbillamount = bill.getBigDecimal("originalsubbillamount");
        String subbillrange = bill.getString("subbillrange");
        String sourceStr = bill.getString("source");
        if (EmptyUtil.isEmpty((String)originalsubbillrang) && EmptyUtil.isNoEmpty((String)subbillrange)) {
            bill.set("originalsubbillrang", (Object)subbillrange);
        }
        if (EmptyUtil.isEmpty((BigDecimal)originalsubbillamount)) {
            bill.set("originalsubbillamount", (Object)amount);
        }
        String newOriginalsubbillrang = bill.getString("originalsubbillrang");
        if (EmptyUtil.isEmpty((String)billidentitycode) && EmptyUtil.isNoEmpty((String)draftbillno)) {
            if (EmptyUtil.isEmpty((String)newOriginalsubbillrang) || "0".equals(newOriginalsubbillrang)) {
                bill.set("billidentitycode", (Object)draftbillno);
            } else {
                bill.set("billidentitycode", (Object)(draftbillno + "-" + newOriginalsubbillrang));
            }
        }
        if (0L == (billId = bill.getLong("id"))) {
            DraftHelper.setBillEqualInfo(bill, amount);
        } else {
            boolean isExists = QueryServiceHelper.exists((String)"cdm_draftbillf7", (Object)billId);
            if (!isExists) {
                DraftHelper.setBillEqualInfo(bill, amount);
            }
        }
    }

    public static void setBillCodeinfo(DynamicObject bill, boolean isExists) {
        long billId;
        BigDecimal amount = bill.getBigDecimal("amount");
        String originalsubbillrang = bill.getString("originalsubbillrang");
        String billidentitycode = bill.getString("billidentitycode");
        String draftbillno = bill.getString("draftbillno");
        BigDecimal originalsubbillamount = bill.getBigDecimal("originalsubbillamount");
        String subbillrange = bill.getString("subbillrange");
        if (EmptyUtil.isEmpty((String)originalsubbillrang) && EmptyUtil.isNoEmpty((String)subbillrange)) {
            bill.set("originalsubbillrang", (Object)subbillrange);
        }
        if (EmptyUtil.isEmpty((BigDecimal)originalsubbillamount)) {
            bill.set("originalsubbillamount", (Object)amount);
        }
        String newOriginalsubbillrang = bill.getString("originalsubbillrang");
        if (EmptyUtil.isEmpty((String)billidentitycode) && EmptyUtil.isNoEmpty((String)draftbillno)) {
            if (EmptyUtil.isEmpty((String)newOriginalsubbillrang) || "0".equals(newOriginalsubbillrang)) {
                bill.set("billidentitycode", (Object)draftbillno);
            } else {
                bill.set("billidentitycode", (Object)(draftbillno + "-" + newOriginalsubbillrang));
            }
        }
        if (0L == (billId = bill.getLong("id"))) {
            DraftHelper.setBillEqualInfo(bill, amount);
        } else if (!isExists) {
            DraftHelper.setBillEqualInfo(bill, amount);
        }
    }

    private static void setBillEqualInfo(DynamicObject bill, BigDecimal amount) {
        bill.set("availableamount", (Object)amount);
        BigDecimal newOriginalsubbillamount = bill.getBigDecimal("originalsubbillamount");
        BigDecimal lockAmount = newOriginalsubbillamount.subtract(amount);
        bill.set("availableamount", (Object)amount);
        bill.set("lockedamount", (Object)lockAmount);
    }

    public static void setSubBillInfo(DynamicObject bill) {
        boolean isSplit = bill.getBoolean("issplit");
        if (!isSplit) {
            bill.set("subbillstartflag", (Object)0);
            bill.set("subbillendflag", (Object)0);
        } else {
            DynamicObject draftBillType = bill.getDynamicObject("draftbilltype");
            if (EmptyUtil.isNoEmpty((DynamicObject)draftBillType)) {
                String eledraftstatusnew;
                String billMedium = draftBillType.getString("billmedium");
                if (BillMediumEnum.ELECTRIC.getValue().equals(billMedium) && EmptyUtil.isEmpty((String)(eledraftstatusnew = bill.getString("eledraftstatusnew")))) {
                    bill.set("eledraftstatusnew", (Object)"registering");
                }
            }
        }
    }

    public static boolean needToHideToolForRecAndPayBill(String sourceBill) {
        return StringUtils.equals((CharSequence)sourceBill, (CharSequence)"cdm_report_bill_dy_detail");
    }

    public static void resetGuaranteeInfo(IDataModel model) {
        model.setValue("guarantflag", (Object)"0");
        model.setValue("guarantbizdate", null);
        model.setValue("guaranttype", null);
        model.setValue("guarantortext", null);
        model.setValue("guarantcreditlimitorg", null);
        model.setValue("guarantcreditlimit", null);
        model.setValue("guarantcreditcurrency", null);
        model.setValue("guarantcreditamount", null);
        model.setValue("guaranteeid", null);
        model.setValue("unguarantbizdate", null);
    }

    public static String checkReleatedByPayBillSelectEndorseBill(DynamicObject tradebill) {
        Object draftBillLog;
        String sourcebilltype;
        DynamicObjectCollection entrys;
        long billlogid;
        Object[] draftBillLogs;
        String sourceBillId = "";
        String source = tradebill.getString("source");
        String draftType = tradebill.getString("tradetype");
        boolean isEndorse = DraftTradeTypeEnum.ENDORSE.getValue().equals(draftType);
        if (!"cas".equalsIgnoreCase(source) && !"cdm-draftallocate".equalsIgnoreCase(source) && isEndorse && EmptyUtil.isNoEmpty((Object[])(draftBillLogs = BusinessDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,sourcebilltype,bizbillno,sourcebillid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(billlogid = ((DynamicObject)(entrys = tradebill.getDynamicObjectCollection("entrys")).get(0)).getLong("billlogid")))}))) && "cas_paybill".equalsIgnoreCase(sourcebilltype = (draftBillLog = draftBillLogs[0]).getString("sourcebilltype"))) {
            sourceBillId = draftBillLog.getString("sourcebillid");
        }
        logger.info("sourceBillId is that:" + sourceBillId);
        return sourceBillId;
    }

    public static Set<DynamicObject> updateDratBillCasEntry(Set<DynamicObject> billSet, String sourceBillType, String deleteOrAdd, Long sourCasBillId) {
        HashSet<DynamicObject> needUpdateDySet = new HashSet<DynamicObject>(8);
        if (EmptyUtil.isEmpty(billSet)) {
            return needUpdateDySet;
        }
        if (EmptyUtil.isNoEmpty((Long)sourCasBillId)) {
            ArrayList<DynamicObject> draftList = new ArrayList<DynamicObject>(billSet);
            String draftbillType = ((DynamicObject)draftList.get(0)).getDataEntityType().getName();
            DynamicObjectCollection casBills = new DynamicObjectCollection();
            switch (sourceBillType) {
                case "cas_paybill": {
                    casBills = QueryServiceHelper.query((String)sourceBillType, (String)"id,billstatus,billno,bizdate,actpayamt", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourCasBillId)});
                    break;
                }
                case "cas_recbill": {
                    casBills = QueryServiceHelper.query((String)sourceBillType, (String)"id,billstatus,billno,bizdate,actrecamt", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourCasBillId)});
                    break;
                }
                case "ifm_transhandlebill": {
                    casBills = QueryServiceHelper.query((String)sourceBillType, (String)"id,paidstatus,billno,bizdate,actpayamt", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourCasBillId)});
                    break;
                }
            }
            DynamicObject casBill = null;
            String billStatus = "";
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)casBills)) {
                casBill = (DynamicObject)casBills.get(0);
                billStatus = "ifm_transhandlebill".equalsIgnoreCase(sourceBillType) ? casBill.getString("paidstatus") : casBill.getString("billstatus");
            }
            Set draftBillIdSet = billSet.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            DynamicObjectCollection hasExsitCasEntryRecBillColl = QueryServiceHelper.query((String)draftbillType, (String)"id,releatedcasbillentrys,releatedcasbillentrys.rel_billtype,releatedcasbillentrys.rel_billno,releatedcasbillentrys.rel_billid,releatedcasbillentrys.rel_bizdate,releatedcasbillentrys.rel_billamount,releatedcasbillentrys.rel_isrefuse,releatedcasbillentrys.rel_modifytime,releatedcasbillentrys.rel_createtime", (QFilter[])new QFilter[]{new QFilter("id", "in", draftBillIdSet)});
            Map<Long, List<DynamicObject>> draftIdAndMapNew = hasExsitCasEntryRecBillColl.stream().collect(Collectors.groupingBy(e -> e.getLong("id")));
            for (DynamicObject data : billSet) {
                Set newMatchDraftDy;
                List<DynamicObject> draftBillDyList;
                long draftBillId = data.getLong("id");
                if (EmptyUtil.isNoEmpty(draftIdAndMapNew) && draftIdAndMapNew.size() > 0 && EmptyUtil.isNoEmpty(draftBillDyList = draftIdAndMapNew.get(draftBillId)) && (EmptyUtil.isNoEmpty(newMatchDraftDy = draftBillDyList.stream().filter(e -> sourCasBillId.longValue() == e.getLong("releatedcasbillentrys.rel_billid") && !e.getBoolean("releatedcasbillentrys.rel_isrefuse")).collect(Collectors.toSet())) && "add".equals(deleteOrAdd) || EmptyUtil.isEmpty(newMatchDraftDy) && "delete".equals(deleteOrAdd))) continue;
                DynamicObjectCollection releatedcasbillEntrys = data.getDynamicObjectCollection("releatedcasbillentrys");
                Set matchCasBills = releatedcasbillEntrys.stream().filter(e -> sourCasBillId.longValue() == e.getLong("rel_billid") && !e.getBoolean("rel_isrefuse")).collect(Collectors.toSet());
                if ((EmptyUtil.isEmpty(matchCasBills) || matchCasBills.size() == 0) && "add".equals(deleteOrAdd)) {
                    if (null == casBill || !"D".equals(billStatus)) continue;
                    String billno = casBill.getString("billno");
                    Date bizdate = casBill.getDate("bizdate");
                    BigDecimal actpayamt = BigDecimal.ZERO;
                    if (sourceBillType.equalsIgnoreCase("cas_paybill") || sourceBillType.equalsIgnoreCase("ifm_transhandlebill")) {
                        actpayamt = casBill.getBigDecimal("actpayamt");
                    } else if (sourceBillType.equalsIgnoreCase("cas_recbill")) {
                        actpayamt = casBill.getBigDecimal("actrecamt");
                    }
                    DynamicObject newCasBillEntry = releatedcasbillEntrys.addNew();
                    newCasBillEntry.set("rel_billid", (Object)sourCasBillId);
                    newCasBillEntry.set("rel_billno", (Object)billno);
                    newCasBillEntry.set("rel_billtype", (Object)sourceBillType);
                    newCasBillEntry.set("rel_bizdate", (Object)bizdate);
                    newCasBillEntry.set("rel_billamount", (Object)actpayamt);
                    newCasBillEntry.set("rel_createtime", (Object)new Date());
                    newCasBillEntry.set("rel_modifytime", (Object)new Date());
                    needUpdateDySet.add(data);
                    continue;
                }
                if (!EmptyUtil.isNoEmpty(matchCasBills) || !"delete".equals(deleteOrAdd)) continue;
                releatedcasbillEntrys.removeAll(matchCasBills);
                needUpdateDySet.add(data);
            }
        }
        return needUpdateDySet;
    }

    public static Set<Long> getCasBillId(Object[] cdmPayBillIdArr, String rpTypeStr, String casBillType, ListShowParameter parameter) {
        QFilter qFilterRpType = new QFilter("rptype", "=", (Object)rpTypeStr);
        QFilter qFilterId = new QFilter("id", "in", (Object)cdmPayBillIdArr);
        DynamicObjectCollection payBills = new DynamicObjectCollection();
        payBills = "paybill".equals(rpTypeStr) ? QueryServiceHelper.query((String)"cdm_payablebill", (String)"id,company,releatedcasbillentrys.rel_billtype,releatedcasbillentrys.rel_billno,releatedcasbillentrys.rel_billid,releatedcasbillentrys.rel_bizdate", (QFilter[])new QFilter[]{qFilterRpType, qFilterId}) : QueryServiceHelper.query((String)"cdm_receivablebill", (String)"id,company,releatedcasbillentrys.rel_billtype,releatedcasbillentrys.rel_billno,releatedcasbillentrys.rel_billid,releatedcasbillentrys.rel_bizdate", (QFilter[])new QFilter[]{qFilterRpType, qFilterId});
        HashSet<Long> casPayBillIdSetAll = new HashSet<Long>(8);
        HashSet<Long> casPayBillIdSet = new HashSet<Long>(8);
        HashSet<Long> casPayOrgIdSet = new HashSet<Long>(8);
        for (DynamicObject payBill : payBills) {
            String rel_billtype = payBill.getString("releatedcasbillentrys.rel_billtype");
            if (!casBillType.equals(rel_billtype)) continue;
            Long rel_billid = payBill.getLong("releatedcasbillentrys.rel_billid");
            Long companyId = payBill.getLong("company");
            casPayBillIdSet.add(rel_billid);
            casPayOrgIdSet.add(companyId);
        }
        if (EmptyUtil.isNoEmpty(casPayBillIdSet)) {
            casPayBillIdSetAll.addAll(casPayBillIdSet);
            if (EmptyUtil.isNoEmpty((Object)parameter)) {
                parameter.setBillFormId(casBillType);
                parameter.setFormId("bos_list");
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.getListFilterParameter().setFilter(new QFilter("id", "in", casPayBillIdSetAll));
                parameter.getCustomParams().put("isFromDraftBill", "Y");
                parameter.getCustomParams().put("orgIdrange", casPayOrgIdSet);
                parameter.getCustomParams().put("statusrange", "D");
            }
        }
        return casPayBillIdSetAll;
    }

    public static DynamicObject updateCasEntryIsRefuse(Set<Long> draftIdSet, Long casCorrectId, String refuse) {
        Object[] recBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,releatedcasbillentrys,releatedcasbillentrys.rel_billtype,releatedcasbillentrys.rel_billno,releatedcasbillentrys.rel_billid,releatedcasbillentrys.rel_bizdate,releatedcasbillentrys.rel_billamount,releatedcasbillentrys.rel_modifytime,releatedcasbillentrys.rel_isrefuse", (QFilter[])new QFilter[]{new QFilter("id", "in", draftIdSet), new QFilter("rptype", "=", (Object)"receivebill"), new QFilter("releatedcasbillentrys.rel_billid", "=", (Object)casCorrectId)});
        if (EmptyUtil.isEmpty((Object[])recBills)) {
            recBills = BusinessDataServiceHelper.load((String)"cdm_payablebill", (String)"id,releatedcasbillentrys,releatedcasbillentrys.rel_billtype,releatedcasbillentrys.rel_billno,releatedcasbillentrys.rel_billid,releatedcasbillentrys.rel_bizdate,releatedcasbillentrys.rel_billamount,releatedcasbillentrys.rel_modifytime,releatedcasbillentrys.rel_isrefuse", (QFilter[])new QFilter[]{new QFilter("id", "in", draftIdSet), new QFilter("rptype", "=", (Object)"paybill"), new QFilter("releatedcasbillentrys.rel_billid", "=", (Object)casCorrectId)});
        }
        if (EmptyUtil.isNoEmpty((Object[])recBills)) {
            Object recBill = recBills[0];
            DynamicObjectCollection releatedcasbillentrys = recBill.getDynamicObjectCollection("releatedcasbillentrys");
            boolean needUpdate = false;
            for (DynamicObject releatedcasbillentry : releatedcasbillentrys) {
                long rel_billid = releatedcasbillentry.getLong("rel_billid");
                if (casCorrectId != rel_billid) continue;
                releatedcasbillentry.set("rel_isrefuse", (Object)refuse);
                releatedcasbillentry.set("rel_modifytime", (Object)new Date());
                needUpdate = true;
                break;
            }
            if (needUpdate) {
                return recBill;
            }
        }
        return null;
    }

    public static Set<DynamicObject> getPayBillDatas(Set<Long> recBillSet, long sourCasBillId, boolean needCheckPayStatus, boolean needCheckNotPayStatus) {
        DynamicObjectCollection casPayDatas = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billstatus,billno,bizdate,draftbill.fbasedataid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourCasBillId)});
        HashSet<DynamicObject> payBillDatas = new HashSet<DynamicObject>(8);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)casPayDatas)) {
            boolean isNotPayStatus;
            boolean isPayStatus = needCheckPayStatus && !"D".equals(((DynamicObject)casPayDatas.get(0)).getString("bizdate"));
            boolean bl = isNotPayStatus = needCheckNotPayStatus && "D".equals(((DynamicObject)casPayDatas.get(0)).getString("bizdate"));
            if (isPayStatus && isNotPayStatus) {
                return payBillDatas;
            }
            Set billIdSet = casPayDatas.stream().map(e -> e.getLong("draftbill.fbasedataid")).collect(Collectors.toSet());
            if (EmptyUtil.isNoEmpty(billIdSet)) {
                Object[] payBillArr;
                billIdSet.removeAll(recBillSet);
                if (EmptyUtil.isNoEmpty(billIdSet) && EmptyUtil.isNoEmpty((Object[])(payBillArr = BusinessDataServiceHelper.load((String)"cdm_payablebill", (String)"id,releatedcasbillentrys,releatedcasbillentrys.rel_billtype,releatedcasbillentrys.rel_billno,releatedcasbillentrys.rel_billid,releatedcasbillentrys.rel_bizdate,releatedcasbillentrys.rel_billamount,releatedcasbillentrys.rel_isrefuse,releatedcasbillentrys.rel_modifytime,releatedcasbillentrys.rel_createtime", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet), new QFilter("rptype", "=", (Object)"paybill")})))) {
                    payBillDatas.addAll(Arrays.stream(payBillArr).collect(Collectors.toSet()));
                }
            }
        }
        return payBillDatas;
    }

    public static Set<DynamicObject> getSourceSuccDraftBillWhenRepay(boolean rejectRefund, boolean isrepayrecall, DynamicObject data) {
        Set<Object> sourceRecBillSet = new HashSet<DynamicObject>(8);
        boolean isrepaygen = data.getBoolean("isrepaygen");
        if (isrepaygen && !isrepayrecall && !rejectRefund) {
            HashSet sourceDraftTradeBillSet;
            Map sourceBillIdMap = BFTrackerServiceHelper.findSourceBills((String)"cdm_drafttradebill", (Long[])new Long[]{data.getLong("id")});
            if (EmptyUtil.isNoEmpty((Object)sourceBillIdMap) && EmptyUtil.isNoEmpty((Object)(sourceDraftTradeBillSet = (HashSet)sourceBillIdMap.get("cdm_drafttradebill")))) {
                DynamicObject[] draftTradeArr = BusinessDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id,entrys,entrys.transtatus,entrys.billlogid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)sourceDraftTradeBillSet)});
                HashSet<Long> sourceNeedUpdateDraftIdSet = new HashSet<Long>(8);
                for (DynamicObject draftTrade : draftTradeArr) {
                    DynamicObjectCollection tradeBillEntrys = draftTrade.getDynamicObjectCollection("entrys");
                    HashSet<Long> draftLogSet = new HashSet<Long>(8);
                    for (DynamicObject tradeBillEntry : tradeBillEntrys) {
                        String tranStatus = tradeBillEntry.getString("transtatus");
                        if (!"success".equalsIgnoreCase(tranStatus)) continue;
                        long draftbillLogId = tradeBillEntry.getLong("billlogid");
                        draftLogSet.add(draftbillLogId);
                    }
                    if (!EmptyUtil.isNoEmpty(draftLogSet)) continue;
                    DynamicObjectCollection draftBillLogColl = QueryServiceHelper.query((String)"cdm_draftbill_log", (String)"id,deleteflag,issplit,draftid,splitedsubbillid", (QFilter[])new QFilter[]{new QFilter("id", "in", draftLogSet), new QFilter("deleteflag", "=", (Object)"0")});
                    for (DynamicObject draftBillLog : draftBillLogColl) {
                        long draftBillId = draftBillLog.getLong("draftid");
                        boolean isSplit = draftBillLog.getBoolean("issplit");
                        if (isSplit) {
                            long splitSubBillId = draftBillLog.getLong("splitedsubbillid");
                            sourceNeedUpdateDraftIdSet.add(splitSubBillId);
                            continue;
                        }
                        sourceNeedUpdateDraftIdSet.add(draftBillId);
                    }
                }
                if (EmptyUtil.isNoEmpty(sourceNeedUpdateDraftIdSet)) {
                    DynamicObject[] sourceRecBillArr = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,releatedcasbillentrys,releatedcasbillentrys.rel_billtype,releatedcasbillentrys.rel_billno,releatedcasbillentrys.rel_billid,releatedcasbillentrys.rel_bizdate,releatedcasbillentrys.rel_billamount,releatedcasbillentrys.rel_isrefuse,releatedcasbillentrys.rel_modifytime,releatedcasbillentrys.rel_createtime", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceNeedUpdateDraftIdSet), new QFilter("rptype", "=", (Object)"receivebill")});
                    sourceRecBillSet = Arrays.stream(sourceRecBillArr).collect(Collectors.toSet());
                }
            }
        } else if (rejectRefund) {
            Set draftBillIdSet = data.getDynamicObjectCollection("entrys").stream().map(e -> e.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet());
            DynamicObjectCollection splitSupperBillColl = QueryServiceHelper.query((String)"cdm_receivablebill", (String)"id,supperbillid", (QFilter[])new QFilter[]{new QFilter("supperbillid", "in", draftBillIdSet), new QFilter("equaltradebillid", "=", (Object)data.getLong("id"))});
            Set<Object> supperbillidSet = new HashSet(16);
            Set<Object> subbillidSet = new HashSet(16);
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)splitSupperBillColl) && splitSupperBillColl.size() > 0) {
                supperbillidSet = splitSupperBillColl.stream().map(e -> e.getLong("supperbillid")).collect(Collectors.toSet());
                subbillidSet = splitSupperBillColl.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            }
            if (EmptyUtil.isNoEmpty(supperbillidSet) && supperbillidSet.size() > 0 && EmptyUtil.isNoEmpty(subbillidSet) && subbillidSet.size() > 0) {
                draftBillIdSet.addAll(subbillidSet);
            }
            if (EmptyUtil.isNoEmpty(supperbillidSet) && supperbillidSet.size() > 0) {
                draftBillIdSet.removeAll(supperbillidSet);
            }
            if (EmptyUtil.isNoEmpty(draftBillIdSet) && draftBillIdSet.size() > 0) {
                DynamicObject[] sourceRecBillByReFundArr = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,supperbillid,releatedcasbillentrys,releatedcasbillentrys.rel_billtype,releatedcasbillentrys.rel_billno,releatedcasbillentrys.rel_billid,releatedcasbillentrys.rel_bizdate,releatedcasbillentrys.rel_billamount,releatedcasbillentrys.rel_isrefuse,releatedcasbillentrys.rel_modifytime,releatedcasbillentrys.rel_createtime", (QFilter[])new QFilter[]{new QFilter("id", "in", draftBillIdSet)});
                sourceRecBillSet = Arrays.stream(sourceRecBillByReFundArr).collect(Collectors.toSet());
            }
        }
        return sourceRecBillSet;
    }

    public static String callIfmTransBillPayStatus(DynamicObject data, String paidstatusStr) {
        String errorMsg = "";
        String sourceBillId = data.getString("sourcebillid");
        long draftId = data.getLong("id");
        String draftBillno = data.getString("draftbillno");
        Object[] ifmTransBills = BusinessDataServiceHelper.load((String)"ifm_transhandlebill", (String)"id,paidstatus,settletnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(sourceBillId))});
        if (EmptyUtil.isNoEmpty((Object[])ifmTransBills) && ifmTransBills.length > 0) {
            List resultList;
            List hasFailSet;
            Object ifmTransBill = ifmTransBills[0];
            if (paidstatusStr.equalsIgnoreCase(ifmTransBill.getString("paidstatus"))) {
                String settletnumber = ifmTransBill.getString("settletnumber");
                if (draftBillno.equals(settletnumber)) {
                    return errorMsg;
                }
                ifmTransBill.set("settletnumber", (Object)draftBillno);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ifmTransBill});
                return errorMsg;
            }
            long ifmTransBillId = ifmTransBill.getLong("id");
            logger.info("casll ifmTransBillId is:" + ifmTransBillId + ",paidstatus is:" + paidstatusStr);
            ArrayList<TransBillUpdatePaidInfo> infos = new ArrayList<TransBillUpdatePaidInfo>(8);
            TransBillUpdatePaidInfo info = new TransBillUpdatePaidInfo();
            info.setBizBillId(Long.valueOf(draftId));
            info.setDraftBillno(draftBillno);
            info.setPaidStatus(paidstatusStr);
            info.setTransBillId(Long.valueOf(ifmTransBillId));
            infos.add(info);
            Object result = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"ifm", (String)"tranBillCdmWritebackService", (String)"updatePaidStatus", (Object[])new Object[]{infos});
            if (EmptyUtil.isNoEmpty((Object)result) && EmptyUtil.isNoEmpty(hasFailSet = (resultList = (List)result).stream().filter(e -> !e.isSuccess()).collect(Collectors.toList()))) {
                String errorMsgStr = ((TransBillUpdatePaidInfo)hasFailSet.get(0)).getErrorMsg();
                return errorMsgStr;
            }
        }
        return errorMsg;
    }

    public static long getMainCurrByOrg(DynamicObject orgDy) {
        long standardCurrency = 0L;
        DynamicObject initOrg = QueryServiceHelper.queryOne((String)"cas_cashmgtinit", (String)"id,standardcurrency", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgDy.getLong("id"))});
        if (initOrg != null) {
            standardCurrency = initOrg.getLong("standardcurrency");
        }
        return standardCurrency;
    }

    public static void setSubBillInfo(DynamicObject targetBill, BigDecimal actpayamt) {
        boolean issplit = targetBill.getBoolean("issplit");
        if (issplit) {
            targetBill.set("standardbillamount", (Object)new BigDecimal("0.01"));
            String subbillrange = targetBill.getString("subbillrange");
            if (EmptyUtil.isEmpty((String)subbillrange) || "0".equals(subbillrange)) {
                long subEndFlag = actpayamt.multiply(new BigDecimal("100")).longValue();
                long subStartFlag = 1L;
                targetBill.set("subbillrange", (Object)(subStartFlag + "-" + subEndFlag));
                targetBill.set("subbillquantity", (Object)subEndFlag);
                targetBill.set("subbillstartflag", (Object)1L);
                targetBill.set("subbillendflag", (Object)subEndFlag);
            }
        }
    }

    public static CreditLimitInfo getCreditLimitUseInfos(DynamicObject bill, DynamicObject entry, boolean preOccupy, String creditLimitNumber, Long creditId, BigDecimal creditAmount) {
        DynamicObject draftbill = entry.getDynamicObject("draftbill");
        CreditLimitUseBean useBean = new CreditLimitUseBean();
        useBean.setPkId(Long.valueOf(entry.getLong("id")));
        useBean.setEntityName("cdm_receivablebill");
        useBean.setOrgId((Long)bill.getDynamicObject("company").getPkValue());
        useBean.setCurrencyId((Long)bill.getDynamicObject("currency").getPkValue());
        DynamicObject draftbilltype = bill.getDynamicObject("drafttype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltype)) {
            useBean.setFinOrgId(Long.valueOf(bill.getDynamicObject("recbody").getLong("id")));
            useBean.setCreditFinType("bd_finorginfo");
            DynamicObject credittypeDO = draftbilltype.getDynamicObject("credittype");
            if (EmptyUtil.isNoEmpty((DynamicObject)credittypeDO)) {
                useBean.setCreditTypeId((Long)credittypeDO.getPkValue());
            }
            useBean.setCreditVariety(draftbilltype.getString("name"));
        }
        useBean.setMaxAmt(creditAmount);
        useBean.setStartDate(draftbill.getDate("issuedate"));
        useBean.setEndDate(draftbill.getDate("draftbillexpiredate"));
        useBean.setBizAmt(creditAmount);
        useBean.setSourceBillId(Long.valueOf(entry.getLong("id")));
        useBean.setPreOccupy(Boolean.valueOf(preOccupy));
        useBean.setCreditLimitNo(creditLimitNumber);
        useBean.setCreditLimitId(creditId);
        CreditLimitServiceHelper.autoUseCreditLimit((CreditLimitUseBean)useBean);
        CreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)draftbill, null, (boolean)true, (Date)draftbill.getDate("bizdate"));
        return creditLimitInfo;
    }

    public static BigDecimal calRoughlyInterest(DynamicObject targetBill) {
        BigDecimal sumAmount = targetBill.getBigDecimal("amount");
        Date bizDate = DateUtils.getDataFormat((Date)targetBill.getDate("bizdate"), (boolean)true);
        int discountDays = targetBill.getInt("discountdays");
        double rate = targetBill.getBigDecimal("rate").doubleValue() * 0.01;
        int interestDay = targetBill.getInt("interestday");
        if (sumAmount == null || sumAmount.floatValue() == 0.0f || EmptyUtil.isEmpty((Object)bizDate) || rate == 0.0 || interestDay == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal roughlyInterest = Constants.ZERO;
        int entryCurAmtPrecision = 2;
        DynamicObjectCollection entrys = targetBill.getDynamicObjectCollection("entrys");
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
            for (DynamicObject entry : entrys) {
                DynamicObject draft;
                boolean isinvalid = entry.getBoolean("isinvalid");
                if (isinvalid || EmptyUtil.isEmpty((DynamicObject)(draft = entry.getDynamicObject("draftbill")))) continue;
                Date expireDate = DateUtils.getDataFormat((Date)draft.getDate("draftbillexpiredate"), (boolean)true);
                BigDecimal amount = entry.getBigDecimal("billamt");
                if (null != draft.getDynamicObject("currency")) {
                    entryCurAmtPrecision = draft.getDynamicObject("currency").getInt("amtprecision");
                }
                int day = DateUtils.getDiffDays((Date)bizDate, (Date)expireDate) - 1 + discountDays;
                BigDecimal entryRoughlyInterest = amount.multiply(BigDecimal.valueOf(rate * (double)day / (double)interestDay)).setScale(entryCurAmtPrecision, RoundingMode.HALF_UP);
                roughlyInterest = roughlyInterest.add(entryRoughlyInterest);
            }
        }
        return DraftHelper.getScalaInterest(targetBill, roughlyInterest, entryCurAmtPrecision);
    }

    public static BigDecimal getScalaInterest(DynamicObject targetBill, BigDecimal disInt, Integer entryCurAmtprec) {
        BigDecimal interest;
        DynamicObject currency = targetBill.getDynamicObject("currency");
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            int amtprecision = currency.getInt("amtprecision");
            interest = disInt.setScale(amtprecision, 4);
        } else {
            interest = null != entryCurAmtprec ? disInt.setScale((int)entryCurAmtprec, 4) : disInt;
        }
        return interest;
    }

    public static BigDecimal calDiscAmt(DynamicObject targetBill) {
        BigDecimal discAmount;
        BigDecimal sumAmount = targetBill.getBigDecimal("amount");
        if (sumAmount == null || sumAmount.floatValue() == 0.0f) {
            return BigDecimal.ZERO;
        }
        BigDecimal bankCharge = targetBill.getBigDecimal("bankcharge");
        BigDecimal roughlyInterest = targetBill.getBigDecimal("roughlyinterest");
        BigDecimal discAmt = sumAmount.subtract(bankCharge).subtract(roughlyInterest);
        DynamicObject currency = targetBill.getDynamicObject("currency");
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            int amtprecision = currency.getInt("amtprecision");
            discAmount = new BigDecimal(TmcBusinessBaseHelper.formatDecimal((BigDecimal)discAmt, (int)amtprecision).replaceAll(",", ""));
        } else {
            discAmount = discAmt;
        }
        return discAmount;
    }

    public static Map<Long, Map<Date, Date>> getDraftBillDefaultExpireDate(ExtendedDataEntity[] validDatas, DynamicObject[] needSetExpreDataDataList, boolean isSave) {
        HashMap<Long, Map<Date, Date>> dealMap;
        block3: {
            block2: {
                dealMap = new HashMap<Long, Map<Date, Date>>(16);
                if (isSave || null == validDatas) break block2;
                for (ExtendedDataEntity extendedDataEntity : validDatas) {
                    DynamicObject data = extendedDataEntity.getDataEntity();
                    DynamicObject draftbilltypeDO = data.getDynamicObject("draftbilltype");
                    Date issuedate = data.getDate("issuedate");
                    DraftHelper.dealDate(dealMap, draftbilltypeDO, issuedate, isSave);
                }
                break block3;
            }
            if (!isSave || null == needSetExpreDataDataList) break block3;
            for (DynamicObject needSetExpreDataData : needSetExpreDataDataList) {
                Date issueDate = needSetExpreDataData.getDate("issuedate");
                Date draftbillEpiredate = needSetExpreDataData.getDate("draftbillexpiredate");
                if (null == issueDate || null != draftbillEpiredate) continue;
                DynamicObject draftbilltypeDO = needSetExpreDataData.getDynamicObject("draftbilltype");
                DraftHelper.dealDate(dealMap, draftbilltypeDO, issueDate, isSave);
            }
        }
        return dealMap;
    }

    public static void dealDate(Map<Long, Map<Date, Date>> dealMap, DynamicObject draftbilltypeDO, Date issuedate, boolean isSave) {
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltypeDO)) {
            Map<Date, Date> map;
            Date draftbillexpiredate = null;
            int validitytime = draftbilltypeDO.getInt("defaulttime");
            String unit = draftbilltypeDO.getString("defaultunit");
            if (!isSave) {
                validitytime = draftbilltypeDO.getInt("validitytime");
                unit = draftbilltypeDO.getString("unit");
            }
            if (EmptyUtil.isEmpty(map = dealMap.get(draftbilltypeDO.getLong("id"))) || map.size() == 0) {
                boolean defaultDayContion;
                boolean defaultMonthContion = StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.MONTH.getValue()) && issuedate != null;
                boolean bl = defaultDayContion = StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.DAY.getValue()) && issuedate != null;
                if (!isSave) {
                    defaultMonthContion = defaultMonthContion && EmptyUtil.isNoEmpty((Integer)validitytime);
                    boolean bl2 = defaultDayContion = defaultDayContion && EmptyUtil.isNoEmpty((Integer)validitytime);
                }
                if (defaultMonthContion) {
                    draftbillexpiredate = DateUtils.getNextMonth((Date)issuedate, (int)validitytime);
                    if (draftbillexpiredate.getDate() != issuedate.getDate()) {
                        draftbillexpiredate = DateUtils.getNextDay((Date)draftbillexpiredate, (int)(-draftbillexpiredate.getDate()));
                    }
                } else if (defaultDayContion) {
                    draftbillexpiredate = DateUtils.getNextDay((Date)issuedate, (int)validitytime);
                }
                if (null != draftbillexpiredate) {
                    HashMap<Date, Date> dateMap = new HashMap<Date, Date>(16);
                    dateMap.put(issuedate, draftbillexpiredate);
                    dealMap.put(draftbilltypeDO.getLong("id"), dateMap);
                }
            }
        }
    }

    public static Date dealDateByImport(DynamicObject draftbilltypeDO, Date issuedate) {
        boolean defaultDayContion;
        Date draftbillexpiredate = null;
        int validitytime = draftbilltypeDO.getInt("defaulttime");
        String unit = draftbilltypeDO.getString("defaultunit");
        boolean defaultMonthContion = StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.MONTH.getValue()) && issuedate != null;
        boolean bl = defaultDayContion = StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.DAY.getValue()) && issuedate != null;
        if (defaultMonthContion) {
            draftbillexpiredate = DateUtils.getNextMonth((Date)issuedate, (int)validitytime);
            if (draftbillexpiredate.getDate() != issuedate.getDate()) {
                draftbillexpiredate = DateUtils.getNextDay((Date)draftbillexpiredate, (int)(-draftbillexpiredate.getDate()));
            }
        } else if (defaultDayContion) {
            draftbillexpiredate = DateUtils.getNextDay((Date)issuedate, (int)validitytime);
        }
        return draftbillexpiredate;
    }

    public static List<String> checkDate(Date draftbillexpireDate, Date issueDate, Date acceptDate, String settlementtype, boolean isApply) {
        ArrayList<String> errorMsgList = new ArrayList<String>(16);
        if ((StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue()) || StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BANK.getValue())) && EmptyUtil.isNoEmpty((Object)acceptDate)) {
            CdmBizResource cdmBizResource = new CdmBizResource();
            Date issueDateNew = DateUtils.stringToDate((String)DateUtils.formatString((Date)issueDate, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
            Date draftbillexpireDateNew = DateUtils.stringToDate((String)DateUtils.formatString((Date)draftbillexpireDate, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
            Date acceptDateNew = DateUtils.stringToDate((String)DateUtils.formatString((Date)acceptDate, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
            if (acceptDateNew.before(issueDateNew)) {
                errorMsgList.add(cdmBizResource.geAccDateCheck());
            }
            if (draftbillexpireDateNew.before(acceptDateNew)) {
                errorMsgList.add(cdmBizResource.geDraftExpirDateCheck());
            }
        }
        return errorMsgList;
    }

    public static String getNeedPreRecButNotRec(DynamicObjectCollection draftBillColl, boolean isLoad) {
        String errorMsg = "";
        HashMap orgIdAndDrftIdMap = new HashMap(16);
        HashMap<Long, String> draftIdAndDrfBillnoMap = new HashMap<Long, String>(16);
        for (DynamicObject draftDy : draftBillColl) {
            String rptype = draftDy.getString("rptype");
            if (!"receivebill".equalsIgnoreCase(rptype)) continue;
            draftIdAndDrfBillnoMap.put(draftDy.getLong("id"), draftDy.getString("billno"));
            long companyId = 0L;
            companyId = isLoad ? draftDy.getDynamicObject("company").getLong("id") : draftDy.getLong("company");
            Set draftBillIdSet = (Set)orgIdAndDrftIdMap.get(companyId);
            if (EmptyUtil.isNoEmpty((Object)draftBillIdSet)) {
                draftBillIdSet.add(draftDy.getLong("id"));
                continue;
            }
            HashSet<Long> draftBillIdSetNew = new HashSet<Long>(1);
            draftBillIdSetNew.add(draftDy.getLong("id"));
            orgIdAndDrftIdMap.put(companyId, draftBillIdSetNew);
        }
        HashSet<Long> needCheckDraftIdSet = new HashSet<Long>(16);
        for (Map.Entry entry : orgIdAndDrftIdMap.entrySet()) {
            Set draftIds;
            Long orgId = (Long)entry.getKey();
            String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
            boolean isneedrecfirst = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)orgId, (String)"isneedrecfirst");
            if (!isneedrecfirst || !EmptyUtil.isNoEmpty((Object)(draftIds = (Set)entry.getValue()))) continue;
            needCheckDraftIdSet.addAll(draftIds);
        }
        if (EmptyUtil.isNoEmpty(needCheckDraftIdSet)) {
            errorMsg = DraftHelper.getNeedPreRecButNotErrorMsg(draftIdAndDrfBillnoMap, needCheckDraftIdSet);
        }
        return errorMsg;
    }

    public static String getNeedPreRecButNotErrorMsg(Map<Long, String> draftIdAndDrfBillnoMap, Set<Long> needCheckDraftIdSet) {
        String errorMsg = "";
        if (EmptyUtil.isNoEmpty(needCheckDraftIdSet)) {
            QFilter filter = new QFilter("draftbill.fbasedataid.id", "in", needCheckDraftIdSet);
            filter.and("billstatus", "=", (Object)BillStatusEnum.PAY.getValue());
            DynamicObjectCollection cas_recbills = QueryServiceHelper.query((String)"cas_recbill", (String)"draftbill.fbasedataid.id as draftid", (QFilter[])new QFilter[]{filter});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)cas_recbills)) {
                Set haRecDraftIdSet = cas_recbills.stream().map(e -> e.getLong("draftid")).collect(Collectors.toSet());
                boolean bl = needCheckDraftIdSet.removeAll(haRecDraftIdSet);
            }
            if (EmptyUtil.isNoEmpty(needCheckDraftIdSet)) {
                StringJoiner stringJoiner = new StringJoiner("\r\n");
                for (Long draftid : needCheckDraftIdSet) {
                    String drfatbillnoStr = draftIdAndDrfBillnoMap.get(draftid);
                    String msg = ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e \u201c%s\u201d \u672a\u5b8c\u6210\u7968\u636e\u6536\u6b3e\u4e1a\u52a1\u95ed\u73af\uff0c\u8bf7\u5148\u5b8c\u6210\u7968\u636e\u6536\u6b3e\u540e\u518d\u7528\u4e8e\u4ed8\u6b3e\u3002", (String)"DraftHelper_9_1", (String)"tmc-cdm-common", (Object[])new Object[]{drfatbillnoStr});
                    stringJoiner.add(msg);
                }
                if (EmptyUtil.isNoEmpty((Object)stringJoiner)) {
                    errorMsg = stringJoiner.toString();
                }
            }
        }
        return errorMsg;
    }
}

