/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillAmountHelper {
    private static Log logger = LogFactory.getLog(TradeBillAmountHelper.class);
    private static final BigDecimal PERCENT = new BigDecimal("0.01");
    private static final int PRESION = 10;

    public static void calcTradeBillAmount(DynamicObject targetBill) {
        Tuple<Integer, BigDecimal> integerBigDecimalTuple = TradeBillAmountHelper.sumDraftAmtAndCount(targetBill);
        targetBill.set("draftcount", integerBigDecimalTuple.item1);
        targetBill.set("amount", integerBigDecimalTuple.item2);
        Map<String, BigDecimal> stringBigDecimalMap = TradeBillAmountHelper.calcDiscountInterest(targetBill);
        BigDecimal interest = stringBigDecimalMap.getOrDefault("discount_interest", BigDecimal.ZERO);
        BigDecimal payinterestamount = stringBigDecimalMap.getOrDefault("payinterestamount", BigDecimal.ZERO);
        BigDecimal roughlyInterest = stringBigDecimalMap.getOrDefault("roughly_interest", BigDecimal.ZERO);
        boolean ispaybyagree = targetBill.getBoolean("ispaybyagree");
        if (ispaybyagree) {
            targetBill.set("payinterestamount", (Object)payinterestamount);
        }
        targetBill.set("discount_interest", (Object)interest);
        targetBill.set("roughly_interest", (Object)roughlyInterest);
        targetBill.set("discamt", (Object)TradeBillAmountHelper.calcDiscAmt(targetBill));
        targetBill.set("alldiscountinterest", (Object)interest.add(payinterestamount));
        targetBill.set("collection", (Object)TradeBillAmountHelper.calcCollection(targetBill));
    }

    public static Tuple<Integer, BigDecimal> sumDraftAmtAndCount(DynamicObject targetBill) {
        boolean isSubmitEle = targetBill.getBoolean("electag");
        DynamicObjectCollection entryList = targetBill.getDynamicObjectCollection("entrys");
        BigDecimal amount = BigDecimal.ZERO;
        for (DynamicObject entry : entryList) {
            boolean isNoEmpty = EmptyUtil.isNoEmpty((DynamicObject)entry.getDynamicObject("draftbill"));
            boolean isNotSubmitEleOrSucc = !isSubmitEle || DraftTranStatusEnum.SUCCESS.getValue().equals(entry.getString("transtatus"));
            BigDecimal splitAmount = entry.getBigDecimal("billamt");
            if (!isNoEmpty || !isNotSubmitEleOrSucc) continue;
            BigDecimal billAmount = entry.getDynamicObject("draftbill").getBigDecimal("availableamount");
            if (EmptyUtil.isNoEmpty((BigDecimal)splitAmount)) {
                amount = amount.add(splitAmount);
                continue;
            }
            amount = amount.add(billAmount);
        }
        int count = entryList.stream().filter(v -> !EmptyUtil.isEmpty((DynamicObject)v.getDynamicObject("draftbill"))).toArray().length;
        return Tuple.create((Object)count, (Object)amount);
    }

    public static BigDecimal calcDiscAmt(DynamicObject targetBill) {
        BigDecimal discAmount;
        BigDecimal sumAmt = targetBill.getBigDecimal("amount");
        if (sumAmt == null || sumAmt.floatValue() == 0.0f) {
            return BigDecimal.ZERO;
        }
        BigDecimal disInt = targetBill.getBigDecimal("discount_interest");
        BigDecimal payinterestamount = targetBill.getBigDecimal("payinterestamount");
        BigDecimal poundage = targetBill.getBigDecimal("poundage");
        BigDecimal discAmt = sumAmt.subtract(disInt).subtract(poundage);
        DynamicObject currency = targetBill.getDynamicObject("currency");
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            int amtprecision = currency.getInt("amtprecision");
            discAmount = new BigDecimal(TmcBusinessBaseHelper.formatDecimal((BigDecimal)discAmt, (int)amtprecision).replaceAll(",", ""));
        } else {
            discAmount = discAmt;
        }
        return discAmount;
    }

    public static Map<String, BigDecimal> calcDiscountInterest(DynamicObject targetBill) {
        boolean isEdit = targetBill.getBoolean("iseditdiscountentry");
        HashMap<String, BigDecimal> mapOfInterestAmout = new HashMap<String, BigDecimal>(4);
        DynamicObjectCollection entrys = new DynamicObjectCollection();
        int discountDays = 0;
        if (isEdit) {
            entrys = targetBill.getDynamicObjectCollection("discountentry");
        } else {
            entrys = targetBill.getDynamicObjectCollection("entrys");
            discountDays = targetBill.getInt("discount_days");
        }
        Date bizDate = DateUtils.getDataFormat((Date)targetBill.getDate("bizdate"), (boolean)true);
        int interestDay = targetBill.getInt("interestday");
        BigDecimal rate = targetBill.getBigDecimal("rate").multiply(PERCENT).setScale(10, RoundingMode.HALF_UP);
        BigDecimal agreerate = targetBill.getBigDecimal("agreerate").multiply(PERCENT);
        boolean ispaybyagree = targetBill.getBoolean("ispaybyagree");
        logger.info("discountDays is:" + discountDays + ",ispaybyagree:" + ispaybyagree + ",agreerate" + agreerate);
        BigDecimal sumAmt = targetBill.getBigDecimal("amount");
        if (EmptyUtil.isEmpty((Object)bizDate) || interestDay == 0 || BigDecimal.ZERO.compareTo(rate) == 0 || sumAmt == null || sumAmt.floatValue() == 0.0f) {
            return mapOfInterestAmout;
        }
        BigDecimal ownInt = Constants.ZERO;
        BigDecimal payInt = Constants.ZERO;
        BigDecimal roughlyInt = Constants.ZERO;
        Integer entryCurAmtprec = null;
        Integer amtprecision = TradeBillAmountHelper.getScalaInterest(targetBill);
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
            for (DynamicObject entry : entrys) {
                DynamicObject draft = null;
                BigDecimal amount = BigDecimal.ZERO;
                if (isEdit) {
                    draft = entry.getDynamicObject("dis_selectbillid");
                    amount = entry.getBigDecimal("dis_subamount");
                } else {
                    draft = entry.getDynamicObject("draftbill");
                    amount = entry.getBigDecimal("billamt");
                }
                if (EmptyUtil.isEmpty((DynamicObject)draft)) continue;
                boolean isSubmitEle = draft.getBoolean("electag");
                String transStatus = draft.getString("draftbilltranstatus");
                logger.info("isSubmitEle :" + isSubmitEle + ",succ is:" + transStatus);
                if (isSubmitEle && !"success".equalsIgnoreCase(transStatus)) continue;
                Date expireDate = DateUtils.getDataFormat((Date)draft.getDate("draftbillexpiredate"), (boolean)true);
                if (null == entryCurAmtprec && null != draft.getDynamicObject("currency")) {
                    entryCurAmtprec = draft.getDynamicObject("currency").getInt("amtprecision");
                }
                if (isEdit) {
                    discountDays = entry.getInt("dis_days");
                    DynamicObject dynamicObject = targetBill.getDynamicObject("company");
                }
                int day = DateUtils.getDiffDays((Date)bizDate, (Date)expireDate) - 1 + discountDays;
                logger.info("bizDate is:" + bizDate + ",expireDate is:" + expireDate + ",day is:" + day + ",rate :" + rate + ",amount:" + amount + ",interestDay:" + interestDay);
                BigDecimal entryAmount = amount.multiply(rate).multiply(new BigDecimal(day)).divide(new BigDecimal(interestDay), (int)amtprecision, 4);
                if (ispaybyagree) {
                    BigDecimal dis_payAmount = entryAmount.multiply(agreerate).setScale((int)amtprecision, RoundingMode.HALF_UP);
                    BigDecimal dis_ownAmount = entryAmount.subtract(dis_payAmount);
                    payInt = payInt.add(dis_payAmount);
                    ownInt = ownInt.add(dis_ownAmount);
                } else {
                    BigDecimal bigDecimal = entryAmount.setScale((int)amtprecision, RoundingMode.HALF_UP);
                    ownInt = ownInt.add(bigDecimal);
                }
                roughlyInt = roughlyInt.add(entryAmount);
                logger.info("roughlyInt is:" + roughlyInt);
            }
        }
        mapOfInterestAmout.put("discount_interest", ownInt);
        mapOfInterestAmout.put("payinterestamount", payInt);
        mapOfInterestAmout.put("roughly_interest", roughlyInt);
        return mapOfInterestAmout;
    }

    public static BigDecimal calcCollection(DynamicObject targetBill) {
        BigDecimal collection;
        BigDecimal sumAmt = targetBill.getBigDecimal("amount");
        if (sumAmt == null || sumAmt.floatValue() == 0.0f) {
            return BigDecimal.ZERO;
        }
        BigDecimal poundage = targetBill.getBigDecimal("poundage");
        BigDecimal discColl = sumAmt.subtract(poundage);
        DynamicObject currency = targetBill.getDynamicObject("currency");
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            int amtprecision = currency.getInt("amtprecision");
            collection = new BigDecimal(TmcBusinessBaseHelper.formatDecimal((BigDecimal)discColl, (int)amtprecision).replaceAll(",", ""));
        } else {
            collection = discColl;
        }
        return collection;
    }

    public static BigDecimal calcEleDiscountInterest(DynamicObject targetBill, DynamicObject draft) {
        Integer amtprecision = TradeBillAmountHelper.getScalaInterest(targetBill);
        Date bizDate = targetBill.getDate("bizdate");
        int interestDay = targetBill.getInt("interestday");
        int discountDays = targetBill.getInt("discount_days");
        BigDecimal rate = targetBill.getBigDecimal("rate").multiply(PERCENT).setScale(10, RoundingMode.HALF_UP);
        BigDecimal amount = draft.getBigDecimal("amount");
        if (EmptyUtil.isEmpty((Object)bizDate) || interestDay == 0 || BigDecimal.ZERO.compareTo(rate) == 0 || amount == null || amount.floatValue() == 0.0f) {
            return BigDecimal.ZERO;
        }
        Date expireDate = draft.getDate("draftbillexpiredate");
        int day = DateUtils.getDiffDays((Date)bizDate, (Date)expireDate) - 1 + discountDays;
        BigDecimal disInt = amount.subtract(amount.multiply(rate).multiply(new BigDecimal(day)).divide(new BigDecimal(interestDay), (int)amtprecision, 4));
        return disInt.setScale((int)amtprecision, 4);
    }

    public static Integer getScalaInterest(DynamicObject targetBill) {
        DynamicObject currency = targetBill.getDynamicObject("currency");
        Integer entryCurAmtprec = 0;
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            entryCurAmtprec = currency.getInt("amtprecision");
            logger.info("amtprecision is:" + entryCurAmtprec);
        } else {
            DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entrys");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entry)) {
                DynamicObject draft = ((DynamicObject)entry.get(0)).getDynamicObject("draftbill");
                entryCurAmtprec = draft.getDynamicObject("currency").getInt("amtprecision");
            }
        }
        logger.info("interest is that:" + entryCurAmtprec);
        return entryCurAmtprec;
    }

    public static boolean notConfirmDisounctInterest(DynamicObject tradeBill) {
        BigDecimal payInteramount_bank = tradeBill.getBigDecimal("payinteramount_bank");
        BigDecimal ownDiscountInterest = tradeBill.getBigDecimal("owndiscountinterest");
        if (BigDecimal.ZERO.compareTo(payInteramount_bank) != 0 || BigDecimal.ZERO.compareTo(ownDiscountInterest) != 0) {
            boolean iseditdiscountentry = tradeBill.getBoolean("iseditdiscountentry");
            BigDecimal payinterestamount = tradeBill.getBigDecimal("payinterestamount");
            BigDecimal discount_interest = tradeBill.getBigDecimal("discount_interest");
            boolean ownInterestBalance = discount_interest.compareTo(ownDiscountInterest) == 0;
            boolean payInterestBalance = payinterestamount.compareTo(payInteramount_bank) == 0;
            boolean isNotNeedConfirm = ownInterestBalance && payInterestBalance;
            logger.info("isNotNeedConfirm is\uff1a" + isNotNeedConfirm);
            if (!isNotNeedConfirm) {
                return false;
            }
            if (iseditdiscountentry) {
                DynamicObjectCollection discountentrys = tradeBill.getDynamicObjectCollection("discountentry");
                for (DynamicObject discountentry : discountentrys) {
                    boolean isDisOwnInteretBalance;
                    BigDecimal dis_owninterest_bank = discountentry.getBigDecimal("dis_owninterest_bank");
                    BigDecimal dis_payinterest_bank = discountentry.getBigDecimal("dis_payinterest_bank");
                    BigDecimal dis_payinterestamount = discountentry.getBigDecimal("dis_payinterestamount");
                    BigDecimal dis_interest = discountentry.getBigDecimal("dis_interest");
                    boolean isDisPayInteretBalance = dis_payinterestamount.compareTo(dis_payinterest_bank) == 0;
                    boolean bl = isDisOwnInteretBalance = dis_interest.compareTo(dis_owninterest_bank) == 0;
                    if (isDisPayInteretBalance && isDisOwnInteretBalance) continue;
                    return false;
                }
            }
            return true;
        }
        logger.info("not need Confirm");
        return true;
    }

    public static Map<String, Object> addSecondSplitEntry(DynamicObject draftBillDy, BigDecimal preSplitAmount) {
        boolean isByEqualDifferent = BigDecimal.ZERO.compareTo(preSplitAmount) != 0;
        long subbillquantity_Sec = 1L;
        if (isByEqualDifferent) {
            long allQuantity = draftBillDy.getBigDecimal("availableamount").multiply(new BigDecimal("100")).longValue();
            long preQuantity = preSplitAmount.multiply(new BigDecimal("100")).longValue();
            subbillquantity_Sec = allQuantity - preQuantity;
        }
        long subbillstartflag_Sec = draftBillDy.getLong("subbillstartflag");
        BigDecimal subbillamount_Sec = draftBillDy.getBigDecimal("standardbillamount");
        if (isByEqualDifferent) {
            subbillamount_Sec = new BigDecimal(subbillquantity_Sec).multiply(subbillamount_Sec);
        }
        long subbillendflag_Sec = subbillstartflag_Sec + subbillquantity_Sec - 1L;
        String subbillsrange_Sec = subbillstartflag_Sec + "-" + subbillendflag_Sec;
        Map<String, Object> mapSec = TradeBillAmountHelper.getSubDataMap(subbillendflag_Sec, subbillstartflag_Sec, subbillquantity_Sec, subbillsrange_Sec, subbillamount_Sec);
        return mapSec;
    }

    public static Map<String, Object> addFisrtSplitEntry(DynamicObject draftBillDy, BigDecimal preSplitAmount) {
        boolean isByEqualDifferent = BigDecimal.ZERO.compareTo(preSplitAmount) != 0;
        long subbillendflag = draftBillDy.getLong("subbillendflag");
        long minuend = 1L;
        if (isByEqualDifferent) {
            long allQuantity = draftBillDy.getBigDecimal("availableamount").multiply(new BigDecimal("100")).longValue();
            long preQuantity = preSplitAmount.multiply(new BigDecimal("100")).longValue();
            minuend = allQuantity - preQuantity;
        }
        long subbillstartflag = draftBillDy.getLong("subbillstartflag") + minuend;
        long subbillquantity = subbillendflag + 1L - subbillstartflag;
        String subbillsrange = subbillstartflag + "-" + subbillendflag;
        BigDecimal standardAmount = draftBillDy.getBigDecimal("standardbillamount");
        BigDecimal subbillamount = standardAmount.multiply(new BigDecimal(subbillquantity));
        Map<String, Object> map = TradeBillAmountHelper.getSubDataMap(subbillendflag, subbillstartflag, subbillquantity, subbillsrange, subbillamount);
        return map;
    }

    public static Map<String, Object> getSubDataMap(long subbillendflag, long subbillstartflag, long subbillquantity, String subbillsrange, BigDecimal subbillamount) {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("subbillendflag", subbillendflag);
        map.put("subbillstartflag", subbillstartflag);
        map.put("subbillquantity", subbillquantity);
        map.put("subbillsrange", subbillsrange);
        map.put("subbillamount", subbillamount);
        return map;
    }

    public static void setAllBillAmount(DynamicObject billTradeBill) {
        BigDecimal allBillAmunt = billTradeBill.getBigDecimal("allbillsamount");
        BigDecimal tradeBillAmunt = billTradeBill.getBigDecimal("amount");
        if (BigDecimal.ZERO.compareTo(allBillAmunt) == 0 || tradeBillAmunt.compareTo(allBillAmunt) != 0) {
            BigDecimal newAllBillAmount = BigDecimal.ZERO;
            DynamicObjectCollection entrys = billTradeBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entrys) {
                BigDecimal billamt = entry.getBigDecimal("billamt");
                if (null == billamt || BigDecimal.ZERO.compareTo(billamt) == 0) {
                    BigDecimal billAmount = entry.getDynamicObject("draftbill").getBigDecimal("amount");
                    newAllBillAmount = newAllBillAmount.add(billAmount);
                    continue;
                }
                newAllBillAmount = newAllBillAmount.add(billamt);
            }
            billTradeBill.set("allbillsamount", (Object)newAllBillAmount);
        }
    }
}

