/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.opplugin.payablebill;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.helper.BaseDataHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.SystemParameterHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillImportOp
extends BatchImportPlugin {
    private static final String NEW = "new";
    private static final String OVERRIDE = "override";
    private static final String IMPORT_TYPE = "importtype";
    private static final String KEY_FIELDS = "KeyFields";
    private static final Log LOGGERTOOL = LogFactory.getLog(PayableBillImportOp.class);
    private Map<Long, Set<String>> openParamCOmpanyIdAndMap = new HashMap<Long, Set<String>>(16);
    private Map<String, List<DynamicObject>> customerNumberMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<String, List<DynamicObject>> customerNameMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<String, List<DynamicObject>> userNumberMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<String, List<DynamicObject>> userNameMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<String, List<DynamicObject>> orgNumberMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<String, List<DynamicObject>> orgNameMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<String, List<DynamicObject>> supplyNumberMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<String, List<DynamicObject>> supplyNameMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<String, List<DynamicObject>> billtypeNumberMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<String, List<DynamicObject>> billtypeNameMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<String, List<DynamicObject>> accountNumberAndAccMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<Long, List<DynamicObject>> am_accountIdAndAmDyMap = new HashMap<Long, List<DynamicObject>>(16);
    private Map<Long, DynamicObject> bank_idAndDyMap = new HashMap<Long, DynamicObject>(16);
    private Map<String, List<DynamicObject>> bdFinorgNumberMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<String, List<DynamicObject>> bdFinorgNameMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<String, List<DynamicObject>> draftbillnoAndDyMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<Long, String> accountAndBankMap = new HashMap<Long, String>(16);
    private Set<String> draftTypeSet = Stream.of(SettleMentTypeEnum.BUSINESS.getValue(), SettleMentTypeEnum.BANK.getValue()).collect(Collectors.toSet());
    private Long drawerId;
    private Map<String, Set<Long>> numToContractMap = new HashMap<String, Set<Long>>(16);
    private Map<String, Long> customerNumberToIdMap = new HashMap<String, Long>(16);
    private Map<String, Long> customerNameToIdMap = new HashMap<String, Long>(16);
    private Map<String, Long> supplyNumberToIdMap = new HashMap<String, Long>(16);
    private Map<String, Long> supplyNameToIdMap = new HashMap<String, Long>(16);

    protected boolean isForceBatch() {
        return true;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        LOGGERTOOL.info("super.beforeSave >>> start...");
        super.beforeSave(billdatas, logger);
        LOGGERTOOL.info("super.beforeSave >>> end...");
        Map options = this.ctx.getOption();
        this.dealData(billdatas, logger, options);
        LOGGERTOOL.info("beforeSave >>> end...");
    }

    private void dealData(List<ImportBillData> billdatas, ImportLogger logger, Map<String, Object> options) {
        Object importType = options.get(IMPORT_TYPE);
        Object keyFields = options.get(KEY_FIELDS);
        if (EmptyUtil.isNoEmpty(billdatas)) {
            this.getDraweraccount(billdatas);
            LOGGERTOOL.info("dealData >>> importType is:" + importType + ",billdatas.size is:" + billdatas.size());
            if (NEW.equals(String.valueOf(importType))) {
                this.handleAddData(billdatas, logger);
                LOGGERTOOL.info("handleAddData >>> end...");
            } else if (OVERRIDE.equals(String.valueOf(importType))) {
                this.handleUpdateData(billdatas, logger, keyFields);
                LOGGERTOOL.info("handleUpdateData >>> end...");
            } else {
                this.handleUpdateAddData(billdatas, logger, keyFields);
                LOGGERTOOL.info("handleUpdateAddData >>> end...");
            }
        }
    }

    private List<ImportBillData> handleAddData(List<ImportBillData> billdatas, ImportLogger logger) {
        LOGGERTOOL.info("handleAddData >>> checkParams start...");
        List<ImportBillData> checkedBillDatas = this.checkParams(billdatas, logger);
        LOGGERTOOL.info("handleAddData >>> checkImportRepeatDraftBillNo start...");
        checkedBillDatas = this.checkImportRepeatDraftBillNo(checkedBillDatas, logger);
        LOGGERTOOL.info("handleAddData >>> checkDBRepeatDraftBillNo start...");
        this.checkDBRepeatDraftBillNo(checkedBillDatas, logger);
        return checkedBillDatas;
    }

    private List<ImportBillData> handleUpdateData(List<ImportBillData> billdatas, ImportLogger logger, Object keyFields) {
        LOGGERTOOL.info("handleUpdateData >>> checkUpdateParams start...");
        List<ImportBillData> checkedBillDatas = this.checkUpdateParams(billdatas, logger);
        LOGGERTOOL.info("handleUpdateData >>> getNeedCheckRepeatData start...");
        List<ImportBillData> needCheckRepeatList = this.getNeedCheckRepeatData(checkedBillDatas, logger, keyFields);
        LOGGERTOOL.info("handleUpdateData >>> checkDBRepeatDraftBillNo start...");
        List<ImportBillData> repeatDataList = this.checkDBRepeatDraftBillNo(needCheckRepeatList, logger);
        LOGGERTOOL.info("handleUpdateData >>> removeErrorData start...");
        this.removeErrorData(checkedBillDatas, repeatDataList);
        return checkedBillDatas;
    }

    private void handleUpdateAddData(List<ImportBillData> billdatas, ImportLogger logger, Object keyFields) {
        ArrayList<ImportBillData> needUpdateDataList = new ArrayList<ImportBillData>(billdatas.size());
        ArrayList<ImportBillData> needAddDataList = new ArrayList<ImportBillData>(billdatas.size());
        ArrayList<ImportBillData> errorDataList = new ArrayList<ImportBillData>(billdatas.size());
        for (ImportBillData rowData : billdatas) {
            JSONObject data = rowData.getData();
            Object[] payablebills = this.queryBillsByKeyFields(data, keyFields);
            if (!EmptyUtil.isEmpty((Object[])payablebills)) {
                needUpdateDataList.add(rowData);
                continue;
            }
            needAddDataList.add(rowData);
        }
        List<ImportBillData> updatedResultList = this.handleUpdateData(needUpdateDataList, logger, keyFields);
        List<ImportBillData> addedResultList = this.handleAddData(needAddDataList, logger);
        updatedResultList.addAll(addedResultList);
        errorDataList.addAll(billdatas);
        errorDataList.removeAll(updatedResultList);
        this.removeErrorData(billdatas, errorDataList);
    }

    private DynamicObject[] queryBillsByKeyFields(JSONObject data, Object keyFields) {
        List<Object> uniqueKeyFields = new ArrayList(8);
        if (!EmptyUtil.isEmpty((Object)keyFields)) {
            String fieldStrs = String.valueOf(keyFields);
            String[] fields = fieldStrs.split(",");
            uniqueKeyFields = Arrays.asList(fields).stream().filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(uniqueKeyFields.size());
        for (String field : uniqueKeyFields) {
            Map fieldMap;
            Object fieldObject = data.get((Object)field);
            if (fieldObject instanceof JSONObject) {
                fieldMap = (Map)fieldObject;
                filters.add(new QFilter(field + ".number", "=", fieldMap.get("number")));
                continue;
            }
            if (fieldObject instanceof String) {
                if (StringUtils.equals((CharSequence)"amount", (CharSequence)field)) {
                    BigDecimal bigDecimal = new BigDecimal(String.valueOf(fieldObject));
                    filters.add(new QFilter(field, "=", (Object)bigDecimal));
                    continue;
                }
                if (StringUtils.contains((CharSequence)field, (CharSequence)"date")) {
                    Date fieldDate = DateUtils.stringToDate((String)String.valueOf(fieldObject), (String)"yyyy-MM-dd");
                    filters.add(new QFilter(field, "=", (Object)fieldDate));
                    continue;
                }
                String fieldStr = String.valueOf(fieldObject);
                filters.add(new QFilter(field, "=", (Object)fieldStr));
                continue;
            }
            if (fieldObject instanceof Map) {
                if (!StringUtils.equals((CharSequence)"description", (CharSequence)field)) continue;
                fieldMap = (Map)fieldObject;
                filters.add(new QFilter(field, "=", fieldMap.get("zh_CN")));
                continue;
            }
            if (fieldObject instanceof Integer || fieldObject instanceof Double || fieldObject instanceof BigDecimal) {
                filters.add(new QFilter(field, "=", fieldObject));
                continue;
            }
            if (!(fieldObject instanceof Boolean)) continue;
            Boolean fieldFlag = (Boolean)fieldObject;
            if (fieldFlag.booleanValue()) {
                filters.add(new QFilter(field, "=", (Object)1));
                continue;
            }
            filters.add(new QFilter(field, "=", (Object)0));
        }
        return BusinessDataServiceHelper.load((String)"cdm_payablebill", (String)"id,draftbillno", (QFilter[])filters.toArray(new QFilter[0]));
    }

    private void removeErrorData(List<ImportBillData> checkedBillDatas, List<ImportBillData> errorDataList) {
        for (ImportBillData rowData : errorDataList) {
            checkedBillDatas.remove(rowData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImportBillData> checkParams(List<ImportBillData> billdatas, ImportLogger logger) {
        Iterator<ImportBillData> it = billdatas.iterator();
        HashMap<Long, Map<Date, Date>> draftTypeIdAndValidDataMap = new HashMap<Long, Map<Date, Date>>(16);
        while (it.hasNext()) {
            String errorMessage = null;
            ImportBillData rowData = it.next();
            JSONObject data = rowData.getData();
            try {
                this.checkDraweraccount(data);
                this.checkSplitInfoAndAmount(data);
                this.checkDraftBillTypeAndSettlementType(data);
                this.checkDrawer(data);
                this.checkReceiver(data);
                this.checkAccepter(data);
                this.checkAcceptPromiser(data);
                this.checkIssuePromiser(data);
                this.checkCompanyEnablePayableApply(data);
                this.backgroundInfoClear(data);
                this.setAcceptDate(data);
                this.checkEntryGcontract(data);
                this.checkSurety(data);
                this.setDraftExpireDate(data, draftTypeIdAndValidDataMap);
            }
            catch (Exception exc) {
                errorMessage = exc.getMessage();
            }
            finally {
                if (!StringUtils.isNotEmpty((CharSequence)errorMessage)) continue;
                logger.log(Integer.valueOf(rowData.getStartIndex()), errorMessage).fail();
                it.remove();
            }
        }
        return billdatas;
    }

    private void checkEntryGcontract(JSONObject data) {
        BigDecimal amount = data.getBigDecimal("amount");
        String payBillType = data.getString("paybilltype");
        boolean isNotGuaranteeType = EmptyUtil.isEmpty((String)payBillType) || !payBillType.contains("assure") && !payBillType.contains("pledge") && !payBillType.contains("mortgage");
        JSONArray gContracts = data.getJSONArray("entry_gcontract");
        if (gContracts == null || gContracts.size() == 0) {
            return;
        }
        if (gContracts != null && gContracts.size() > 0 && isNotGuaranteeType) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62c5\u4fdd\u65b9\u5f0f\u4e0d\u5305\u542b\u62c5\u4fdd\uff0c\u65e0\u6cd5\u5bfc\u5165\u62c5\u4fdd\u5355\u636e\u7f16\u53f7", (String)"CdmBizResource_139", (String)"tmc-cdm-common", (Object[])new Object[0]));
        }
        this.checkDrawerWithContract(data);
        data.put("guarantee", (Object)",2,4,5,");
        for (int i = 0; i < gContracts.size(); ++i) {
            Object gratio;
            JSONObject gContract = gContracts.getJSONObject(i);
            BigDecimal gamount = gContract.getBigDecimal("gamount");
            if (EmptyUtil.isEmpty((BigDecimal)gamount)) {
                gContract.put("gamount", (Object)amount);
            }
            if (EmptyUtil.isEmpty((Object)(gratio = gContract.get((Object)"gratio")))) {
                gContract.put("gratio", (Object)100);
            }
            gContract.put("gstatus", (Object)"A");
        }
    }

    private void checkSurety(JSONObject data) {
        BigDecimal suretyMoney;
        JSONArray surety_Entrys = data.getJSONArray("entry_surety");
        if (surety_Entrys != null && surety_Entrys.size() > 0 && EmptyUtil.isEmpty((BigDecimal)(suretyMoney = data.getBigDecimal("suretymoney")))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7968\u636e\u5305\u542b\u4fdd\u8bc1\u91d1\u5206\u5f55\uff0c\u5374\u672a\u5f55\u5165\u4fdd\u8bc1\u91d1\u91d1\u989d\u3002", (String)"CdmBizResource_139_1", (String)"tmc-cdm-common", (Object[])new Object[0]));
        }
    }

    private void checkDrawerWithContract(JSONObject data) {
        String rowNum = data.getString("rowNum");
        Set<Long> guaranteedOrgIds = this.numToContractMap.get(rowNum);
        if (guaranteedOrgIds.size() == 0) {
            return;
        }
        if (this.drawerId != -1L && !guaranteedOrgIds.contains(this.drawerId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51fa\u7968\u4eba\u4e0d\u5728\u5bf9\u5e94\u62c5\u4fdd\u5408\u540c\u7684\u88ab\u62c5\u4fdd\u4eba\u8303\u56f4\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"CdmBizResource_139_2", (String)"tmc-cdm-opplugin", (Object[])new Object[0]));
        }
    }

    private Map<String, DynamicObject> queryBatchBillTypeByNumber(List<ImportBillData> billBatchQueryList) {
        HashSet<String> numberSet = new HashSet<String>(billBatchQueryList.size());
        for (ImportBillData rowData : billBatchQueryList) {
            String draftBillTypeNumber;
            JSONObject data = rowData.getData();
            JSONObject draftBillTypeNumberJSON = data.getJSONObject("draftbilltype");
            if (null == draftBillTypeNumberJSON || !EmptyUtil.isNotEmpty((CharSequence)(draftBillTypeNumber = draftBillTypeNumberJSON.getString("number")))) continue;
            numberSet.add(draftBillTypeNumber);
        }
        Map<String, Object> numberBillTypeMap = new HashMap<String, DynamicObject>();
        if (!EmptyUtil.isEmpty(numberSet)) {
            QFilter draftBillTypeNumberFilter = new QFilter("number", "in", numberSet);
            DynamicObject[] dynamicObjects = TmcDataServiceHelper.load((String)"cdm_billtype", (String)"id,settlementtype", (QFilter[])new QFilter[]{draftBillTypeNumberFilter});
            numberBillTypeMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(v -> v.getString("number"), o -> o, (o1, o2) -> o1, HashMap::new));
        }
        return numberBillTypeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImportBillData> checkUpdateParams(List<ImportBillData> billdatas, ImportLogger logger) {
        HashMap<Long, Map<Date, Date>> draftTypeIdAndValidDataMap = new HashMap<Long, Map<Date, Date>>(16);
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            String errorMessage = null;
            ImportBillData rowData = it.next();
            JSONObject data = rowData.getData();
            try {
                JSONObject bankAccountNumberJSON = data.getJSONObject("draweraccount");
                if (bankAccountNumberJSON != null && StringUtils.isNotEmpty((CharSequence)bankAccountNumberJSON.getString("bankaccountnumber"))) {
                    this.checkDraweraccount(data);
                }
                if (EmptyUtil.isNotEmpty((CharSequence)data.getString("amount"))) {
                    this.checkSplitInfoAndAmount(data);
                }
                if (!EmptyUtil.isEmpty((Object)data.getJSONObject("draftbilltype"))) {
                    this.checkDraftBillTypeAndSettlementType(data);
                }
                this.checkDrawer(data);
                this.checkReceiver(data);
                this.checkAccepter(data);
                this.checkAcceptPromiser(data);
                this.checkIssuePromiser(data);
                this.backgroundInfoClear(data);
                this.setAcceptDate(data);
                this.checkDrawerWithContract(data);
                this.checkSurety(data);
                this.setDraftExpireDate(data, draftTypeIdAndValidDataMap);
            }
            catch (Exception exc) {
                errorMessage = exc.getMessage();
            }
            finally {
                if (!StringUtils.isNotEmpty((CharSequence)errorMessage)) continue;
                logger.log(Integer.valueOf(rowData.getStartIndex()), errorMessage).fail();
                it.remove();
            }
        }
        return billdatas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImportBillData> getNeedCheckRepeatData(List<ImportBillData> billdatas, ImportLogger logger, Object keyFields) {
        Iterator<ImportBillData> it = billdatas.iterator();
        ArrayList<ImportBillData> needCheckRepeatList = new ArrayList<ImportBillData>(billdatas.size());
        while (it.hasNext()) {
            String errorMessage = null;
            ImportBillData rowData = it.next();
            JSONObject data = rowData.getData();
            try {
                boolean isUpdateDraftBillNoFlag = false;
                Object[] payablebills = this.queryBillsByKeyFields(data, keyFields);
                if (!EmptyUtil.isEmpty((Object[])payablebills)) {
                    String draftbillnoUpdate = data.getString("draftbillno");
                    String draftbillnoDB = payablebills[0].getString("draftbillno");
                    if (EmptyUtil.isNotEmpty((CharSequence)draftbillnoUpdate)) {
                        boolean bl = isUpdateDraftBillNoFlag = !StringUtils.equals((CharSequence)draftbillnoUpdate, (CharSequence)draftbillnoDB);
                    }
                }
                if (!isUpdateDraftBillNoFlag) continue;
                needCheckRepeatList.add(rowData);
            }
            catch (Exception exc) {
                errorMessage = exc.getMessage();
            }
            finally {
                if (!StringUtils.isNotEmpty((CharSequence)errorMessage)) continue;
                logger.log(Integer.valueOf(rowData.getStartIndex()), errorMessage).fail();
                it.remove();
            }
        }
        return needCheckRepeatList;
    }

    private void getDraweraccount(List<ImportBillData> billdatas) {
        HashSet<String> bankAccountNumberSet = new HashSet<String>(16);
        HashSet<String> draftBillTypeNumberSet = new HashSet<String>(16);
        HashSet<String> draftBillTypeNameSet = new HashSet<String>(16);
        HashSet<String> bdFinorgNameSet = new HashSet<String>(16);
        HashSet<String> bdFinorgNumberSet = new HashSet<String>(16);
        HashSet<String> orgNameSet = new HashSet<String>(16);
        HashSet<String> orgNumberSet = new HashSet<String>(16);
        HashSet<String> supplyNameSet = new HashSet<String>(16);
        HashSet<String> supplyNumberSet = new HashSet<String>(16);
        HashSet<String> customerNameSet = new HashSet<String>(16);
        HashSet<String> customerNumberSet = new HashSet<String>(16);
        HashSet<String> userNameSet = new HashSet<String>(16);
        HashSet<String> userNumberSet = new HashSet<String>(16);
        HashSet<String> companyNameSet = new HashSet<String>(16);
        HashSet<String> companyNumberSet = new HashSet<String>(16);
        HashSet<String> contractNoList = new HashSet<String>(16);
        Set<Object> guaranteedOrgIds = new HashSet(16);
        for (ImportBillData billdata : billdatas) {
            JSONObject companyJSON;
            JSONObject drawercompanyJSON;
            String drawerName;
            JSONObject drawerorgJSON;
            String bankAccountNumber;
            JSONObject data = billdata.getData();
            JSONArray contractEntrys = data.getJSONArray("entry_gcontract");
            String rowNum = data.getString("rowNum");
            if (contractEntrys != null && contractEntrys.size() > 0) {
                for (int i = 0; i < contractEntrys.size(); ++i) {
                    JSONObject contractEntry = contractEntrys.getJSONObject(i);
                    String contranctNo = contractEntry.getJSONObject("gcontract").getString("billno");
                    if (contranctNo == null || contranctNo.equals("")) continue;
                    contractNoList.add(contranctNo);
                }
                QFilter qFilter = new QFilter("billno", "in", contractNoList);
                qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
                DynamicObjectCollection guaranteeContracts = QueryServiceHelper.query((String)"gm_guaranteecontract", (String)"id,billno,entry_guaranteedorg.b_guaranteedorg", (QFilter[])new QFilter[]{qFilter});
                guaranteedOrgIds = guaranteeContracts.stream().map(o -> o.getLong("entry_guaranteedorg.b_guaranteedorg")).collect(Collectors.toSet());
            }
            this.numToContractMap.put(rowNum, guaranteedOrgIds);
            JSONObject bankAccountNumberJSON = data.getJSONObject("draweraccount");
            if (bankAccountNumberJSON != null && EmptyUtil.isNoEmpty((String)(bankAccountNumber = bankAccountNumberJSON.getString("bankaccountnumber")))) {
                bankAccountNumberSet.add(bankAccountNumber);
            }
            JSONObject draftBillTypeNumberJSON = data.getJSONObject("draftbilltype");
            String draftBillTypeNumber = draftBillTypeNumberJSON.getString("number");
            String draftBillTypeName = draftBillTypeNumberJSON.getString("name");
            if (EmptyUtil.isNotEmpty((CharSequence)draftBillTypeNumber)) {
                draftBillTypeNumberSet.add(draftBillTypeNumber);
            }
            if (EmptyUtil.isNotEmpty((CharSequence)draftBillTypeName)) {
                draftBillTypeNameSet.add(draftBillTypeName);
            }
            if (EmptyUtil.isNoEmpty((Object)(drawerorgJSON = data.getJSONObject("drawerorg")))) {
                String drawerorgNumber = drawerorgJSON.getString("number");
                String drawerorgName = drawerorgJSON.getString("name");
                if (EmptyUtil.isNotEmpty((CharSequence)drawerorgNumber)) {
                    bdFinorgNumberSet.add(drawerorgNumber);
                }
                if (EmptyUtil.isNotEmpty((CharSequence)drawerorgName)) {
                    bdFinorgNameSet.add(drawerorgName);
                }
            }
            if (EmptyUtil.isNotEmpty((CharSequence)(drawerName = data.getString("drawername")))) {
                bdFinorgNameSet.add(drawerName);
                orgNameSet.add(drawerName);
            }
            if (!EmptyUtil.isEmpty((Object)(drawercompanyJSON = data.getJSONObject("drawercompany")))) {
                String drawercompanyNumber = drawercompanyJSON.getString("number");
                String drawercompanyName = drawercompanyJSON.getString("name");
                if (EmptyUtil.isNotEmpty((CharSequence)drawercompanyNumber)) {
                    orgNumberSet.add(drawercompanyNumber);
                }
                if (EmptyUtil.isNotEmpty((CharSequence)drawercompanyName)) {
                    orgNameSet.add(drawercompanyName);
                }
            }
            String payeeType = data.getString("payeetype");
            String receiveName = data.getString("receivername");
            if (EmptyUtil.isNotEmpty((CharSequence)payeeType)) {
                JSONObject receiverJSON = data.getJSONObject("receiver");
                if (EmptyUtil.isNoEmpty((Object)receiverJSON)) {
                    String receiverNumber = receiverJSON.getString("number");
                    String receiverName = receiverJSON.getString("name");
                    switch (payeeType) {
                        case "bd_supplier": {
                            if (EmptyUtil.isNoEmpty((String)receiverNumber)) {
                                supplyNumberSet.add(receiverNumber);
                            }
                            if (!EmptyUtil.isNoEmpty((String)receiverName)) break;
                            supplyNameSet.add(receiverName);
                            break;
                        }
                        case "bos_org": {
                            if (EmptyUtil.isNoEmpty((String)receiverNumber)) {
                                orgNumberSet.add(receiverNumber);
                            }
                            if (!EmptyUtil.isNoEmpty((String)receiverName)) break;
                            orgNameSet.add(receiverName);
                            break;
                        }
                        case "bd_customer": {
                            if (EmptyUtil.isNoEmpty((String)receiverNumber)) {
                                customerNumberSet.add(receiverNumber);
                            }
                            if (!EmptyUtil.isNoEmpty((String)receiverName)) break;
                            customerNameSet.add(receiverName);
                            break;
                        }
                        case "bos_user": {
                            if (EmptyUtil.isNoEmpty((String)receiverNumber)) {
                                userNumberSet.add(receiverNumber);
                            }
                            if (!EmptyUtil.isNoEmpty((String)receiverName)) break;
                            userNameSet.add(receiverName);
                            break;
                        }
                    }
                } else if (EmptyUtil.isNotEmpty((CharSequence)receiveName)) {
                    switch (payeeType) {
                        case "bd_supplier": {
                            supplyNameSet.add(receiveName);
                            break;
                        }
                        case "bos_org": {
                            orgNameSet.add(receiveName);
                            break;
                        }
                        case "bd_customer": {
                            customerNameSet.add(receiveName);
                            break;
                        }
                        case "bos_user": {
                            userNameSet.add(receiveName);
                            break;
                        }
                    }
                }
            }
            JSONObject accepterfinorgJSON = data.getJSONObject("accepterfinorg");
            JSONObject acceptercompanyJSON = data.getJSONObject("acceptercompany");
            String accepterName = data.getString("acceptername");
            if (!EmptyUtil.isEmpty((Object)accepterfinorgJSON)) {
                String accepterfinorgNumber = accepterfinorgJSON.getString("number");
                String accepterfinorgName = accepterfinorgJSON.getString("name");
                if (EmptyUtil.isNotEmpty((CharSequence)accepterfinorgNumber)) {
                    bdFinorgNumberSet.add(accepterfinorgNumber);
                }
                if (EmptyUtil.isNotEmpty((CharSequence)accepterfinorgName)) {
                    bdFinorgNameSet.add(accepterfinorgName);
                }
            }
            if (!EmptyUtil.isEmpty((Object)acceptercompanyJSON)) {
                String acceptercompanyNumber = acceptercompanyJSON.getString("number");
                String acceptercompanyName = acceptercompanyJSON.getString("name");
                if (EmptyUtil.isNotEmpty((CharSequence)acceptercompanyNumber)) {
                    orgNumberSet.add(acceptercompanyNumber);
                }
                if (EmptyUtil.isNotEmpty((CharSequence)acceptercompanyName)) {
                    orgNameSet.add(acceptercompanyName);
                }
            }
            if (EmptyUtil.isNotEmpty((CharSequence)accepterName)) {
                String billTypeNumber = data.getJSONObject("draftbilltype").getString("number");
                draftBillTypeNumberSet.add(billTypeNumber);
                orgNameSet.add(accepterName);
                bdFinorgNameSet.add(accepterName);
            }
            String acceptpromiserType = data.getString("acceptpromisertype");
            JSONObject acceptpromiserJSON = data.getJSONObject("acceptpromiser");
            String acceptpromiseName = data.getString("acceptpromisername");
            if (EmptyUtil.isNotEmpty((CharSequence)acceptpromiserType)) {
                if (!EmptyUtil.isEmpty((Object)acceptpromiserJSON)) {
                    String acceptpromiserNumber = acceptpromiserJSON.getString("number");
                    String acceptpromiserName = acceptpromiserJSON.getString("name");
                    switch (acceptpromiserType) {
                        case "bd_supplier": {
                            if (EmptyUtil.isNoEmpty((String)acceptpromiserNumber)) {
                                supplyNumberSet.add(acceptpromiserNumber);
                            }
                            if (!EmptyUtil.isNoEmpty((String)acceptpromiserName)) break;
                            supplyNameSet.add(acceptpromiserName);
                            break;
                        }
                        case "bos_org": {
                            if (EmptyUtil.isNoEmpty((String)acceptpromiserNumber)) {
                                orgNumberSet.add(acceptpromiserNumber);
                            }
                            if (!EmptyUtil.isNoEmpty((String)acceptpromiserName)) break;
                            orgNameSet.add(acceptpromiserName);
                            break;
                        }
                        case "bd_customer": {
                            if (EmptyUtil.isNoEmpty((String)acceptpromiserNumber)) {
                                customerNumberSet.add(acceptpromiserNumber);
                            }
                            if (!EmptyUtil.isNoEmpty((String)acceptpromiserName)) break;
                            customerNameSet.add(acceptpromiserName);
                            break;
                        }
                        case "bos_user": {
                            if (EmptyUtil.isNoEmpty((String)acceptpromiserNumber)) {
                                userNumberSet.add(acceptpromiserNumber);
                            }
                            if (!EmptyUtil.isNoEmpty((String)acceptpromiserName)) break;
                            userNameSet.add(acceptpromiserName);
                            break;
                        }
                    }
                } else if (EmptyUtil.isNotEmpty((CharSequence)acceptpromiseName)) {
                    switch (acceptpromiserType) {
                        case "bd_supplier": {
                            supplyNameSet.add(acceptpromiseName);
                            break;
                        }
                        case "bos_org": {
                            orgNameSet.add(acceptpromiseName);
                            break;
                        }
                        case "bd_customer": {
                            customerNameSet.add(acceptpromiseName);
                            break;
                        }
                        case "bos_user": {
                            userNameSet.add(acceptpromiseName);
                            break;
                        }
                    }
                }
            }
            String issuepromiserType = data.getString("issuepromisertype");
            JSONObject issuepromiserJSON = data.getJSONObject("issuepromiser");
            String issuepromiseName = data.getString("issuepromisername");
            if (EmptyUtil.isNotEmpty((CharSequence)issuepromiserType)) {
                if (!EmptyUtil.isEmpty((Object)issuepromiserJSON)) {
                    String issuepromiserNumber = issuepromiserJSON.getString("number");
                    String issuepromiserName = issuepromiserJSON.getString("name");
                    switch (issuepromiserType) {
                        case "bd_supplier": {
                            if (EmptyUtil.isNoEmpty((String)issuepromiserNumber)) {
                                supplyNumberSet.add(issuepromiserNumber);
                            }
                            if (!EmptyUtil.isNoEmpty((String)issuepromiserName)) break;
                            supplyNameSet.add(issuepromiserName);
                            break;
                        }
                        case "bos_org": {
                            if (EmptyUtil.isNoEmpty((String)issuepromiserNumber)) {
                                orgNumberSet.add(issuepromiserNumber);
                            }
                            if (!EmptyUtil.isNoEmpty((String)issuepromiserName)) break;
                            orgNameSet.add(issuepromiserName);
                            break;
                        }
                        case "bd_customer": {
                            if (EmptyUtil.isNoEmpty((String)issuepromiserNumber)) {
                                customerNumberSet.add(issuepromiserNumber);
                            }
                            if (!EmptyUtil.isNoEmpty((String)issuepromiserName)) break;
                            customerNameSet.add(issuepromiserName);
                            break;
                        }
                        case "bos_user": {
                            if (EmptyUtil.isNoEmpty((String)issuepromiserNumber)) {
                                userNumberSet.add(issuepromiserNumber);
                            }
                            if (!EmptyUtil.isNoEmpty((String)issuepromiserName)) break;
                            userNameSet.add(issuepromiserName);
                            break;
                        }
                    }
                } else if (EmptyUtil.isNotEmpty((CharSequence)issuepromiseName)) {
                    switch (issuepromiserType) {
                        case "bd_supplier": {
                            supplyNameSet.add(issuepromiseName);
                            break;
                        }
                        case "bos_org": {
                            orgNameSet.add(issuepromiseName);
                            break;
                        }
                        case "bd_customer": {
                            customerNameSet.add(issuepromiseName);
                            break;
                        }
                        case "bos_user": {
                            userNameSet.add(issuepromiseName);
                            break;
                        }
                    }
                }
            }
            if ((companyJSON = data.getJSONObject("company")) == null) continue;
            String companyNumber = companyJSON.getString("number");
            String companyName = companyJSON.getString("name");
            if (EmptyUtil.isNotEmpty((CharSequence)companyNumber)) {
                companyNumberSet.add(companyNumber);
                orgNumberSet.add(companyNumber);
            }
            if (!EmptyUtil.isNotEmpty((CharSequence)companyName)) continue;
            companyNameSet.add(companyName);
            orgNameSet.add(companyName);
        }
        if (EmptyUtil.isNoEmpty(bankAccountNumberSet)) {
            HashSet<Long> allBankIdSet = new HashSet<Long>(16);
            DynamicObjectCollection drawerAccountColl = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,bank,bank.bank_cate,bankaccountnumber,bank.bebank.number", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "in", bankAccountNumberSet)});
            for (Object drawerAccount : drawerAccountColl) {
                String bankaccountnumber = drawerAccount.getString("bankaccountnumber");
                List<DynamicObject> dynamicObjectList = this.accountNumberAndAccMap.get(bankaccountnumber);
                if (EmptyUtil.isNoEmpty(dynamicObjectList)) {
                    dynamicObjectList.add((DynamicObject)drawerAccount);
                } else {
                    ArrayList<Object> list = new ArrayList<Object>(1);
                    list.add(drawerAccount);
                    this.accountNumberAndAccMap.put(bankaccountnumber, list);
                }
                long bankId = drawerAccount.getLong("bank");
                allBankIdSet.add(bankId);
            }
            DynamicObjectCollection am_accountsColl = QueryServiceHelper.query((String)"am_accountmaintenance", (String)"id,billbank,billbankname,account", (QFilter[])new QFilter[]{new QFilter("account.bankaccountnumber", "in", bankAccountNumberSet)});
            for (DynamicObject am_accounts : am_accountsColl) {
                long billbankId = am_accounts.getLong("billbank");
                long accountId = am_accounts.getLong("account");
                List<DynamicObject> amDyList = this.am_accountIdAndAmDyMap.get(accountId);
                if (EmptyUtil.isNoEmpty(amDyList)) {
                    amDyList.add(am_accounts);
                } else {
                    ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(1);
                    list.add(am_accounts);
                    this.am_accountIdAndAmDyMap.put(accountId, list);
                }
                allBankIdSet.add(billbankId);
            }
            DynamicObjectCollection bankColls = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id,bebank,bebank.number,bank_cate,name,number,union_number", (QFilter[])new QFilter[]{new QFilter("id", "in", allBankIdSet)});
            for (DynamicObject bankColl : bankColls) {
                long id = bankColl.getLong("id");
                this.bank_idAndDyMap.put(id, bankColl);
            }
        }
        if (EmptyUtil.isNoEmpty(bdFinorgNumberSet) || EmptyUtil.isNoEmpty(bdFinorgNameSet)) {
            DynamicObjectCollection bdFinorgNumberColl = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("number", "in", bdFinorgNumberSet)});
            this.bdFinorgNumberMap = bdFinorgNumberColl.stream().collect(Collectors.groupingBy(e -> e.getString("number")));
            DynamicObjectCollection bdFinorgNameColl = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("name", "in", bdFinorgNameSet)});
            this.bdFinorgNameMap = bdFinorgNameColl.stream().collect(Collectors.groupingBy(e -> e.getString("name")));
        }
        if (EmptyUtil.isNoEmpty(draftBillTypeNumberSet) || EmptyUtil.isNoEmpty(draftBillTypeNameSet)) {
            DynamicObjectCollection bebankCollByNumberColl = QueryServiceHelper.query((String)"cdm_billtype", (String)"id,name,number,settlementtype,defaulttime,defaultunit", (QFilter[])new QFilter[]{new QFilter("number", "in", draftBillTypeNumberSet)});
            this.billtypeNumberMap = bebankCollByNumberColl.stream().collect(Collectors.groupingBy(e -> e.getString("number")));
            DynamicObjectCollection bebankCollByNameColl = QueryServiceHelper.query((String)"cdm_billtype", (String)"id,name,number,settlementtype,defaulttime,defaultunit", (QFilter[])new QFilter[]{new QFilter("name", "in", draftBillTypeNameSet)});
            this.billtypeNameMap = bebankCollByNameColl.stream().collect(Collectors.groupingBy(e -> e.getString("name")));
        }
        if (EmptyUtil.isNoEmpty(supplyNumberSet) || EmptyUtil.isNoEmpty(supplyNameSet)) {
            DynamicObjectCollection supplyNumberColl = QueryServiceHelper.query((String)"bd_supplier", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("number", "in", supplyNumberSet)});
            this.supplyNumberMap = supplyNumberColl.stream().collect(Collectors.groupingBy(e -> e.getString("number")));
            this.supplyNumberToIdMap = supplyNumberColl.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v.getLong("id"), (o1, o2) -> o1));
            DynamicObjectCollection supplyNameCollByNameColl = QueryServiceHelper.query((String)"bd_supplier", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("name", "in", supplyNameSet)});
            this.supplyNameMap = supplyNameCollByNameColl.stream().collect(Collectors.groupingBy(e -> e.getString("name")));
            this.supplyNameToIdMap = supplyNameCollByNameColl.stream().collect(Collectors.toMap(k -> k.getString("name"), v -> v.getLong("id"), (o1, o2) -> o1));
        }
        if (EmptyUtil.isNoEmpty(orgNumberSet) || EmptyUtil.isNoEmpty(orgNameSet)) {
            DynamicObjectCollection orgNumberColl = QueryServiceHelper.query((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("number", "in", orgNumberSet)});
            this.orgNumberMap = orgNumberColl.stream().collect(Collectors.groupingBy(e -> e.getString("number")));
            DynamicObjectCollection orgNameColl = QueryServiceHelper.query((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("name", "in", orgNameSet)});
            this.orgNameMap = orgNameColl.stream().collect(Collectors.groupingBy(e -> e.getString("name")));
        }
        if (EmptyUtil.isNoEmpty(userNumberSet) || EmptyUtil.isNoEmpty(userNameSet)) {
            DynamicObjectCollection userNumberColl = QueryServiceHelper.query((String)"bos_user", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("number", "in", userNumberSet)});
            this.userNumberMap = userNumberColl.stream().collect(Collectors.groupingBy(e -> e.getString("number")));
            DynamicObjectCollection userNameColl = QueryServiceHelper.query((String)"bos_user", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("name", "in", userNameSet)});
            this.userNameMap = userNameColl.stream().collect(Collectors.groupingBy(e -> e.getString("name")));
        }
        if (EmptyUtil.isNoEmpty(customerNumberSet) || EmptyUtil.isNoEmpty(customerNameSet)) {
            DynamicObjectCollection customerNumberColl = QueryServiceHelper.query((String)"bd_customer", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("number", "in", customerNumberSet)});
            this.customerNumberMap = customerNumberColl.stream().collect(Collectors.groupingBy(e -> e.getString("number")));
            this.customerNumberToIdMap = customerNumberColl.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v.getLong("id"), (o1, o2) -> o1));
            DynamicObjectCollection customerNameColl = QueryServiceHelper.query((String)"bd_customer", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("name", "in", customerNameSet)});
            this.customerNameMap = customerNameColl.stream().collect(Collectors.groupingBy(e -> e.getString("name")));
            this.customerNameToIdMap = customerNameColl.stream().collect(Collectors.toMap(k -> k.getString("name"), v -> v.getLong("id"), (o1, o2) -> o1));
        }
        this.getCompanySystemParam(companyNameSet, companyNumberSet);
    }

    private void getCompanySystemParam(Set<String> companyNameSet, Set<String> companyNumberSet) {
        if (EmptyUtil.isNoEmpty(companyNumberSet) || EmptyUtil.isNoEmpty(companyNameSet)) {
            HashSet companyIdSet = new HashSet(16);
            DynamicObjectCollection companyNumberColl = QueryServiceHelper.query((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("number", "in", companyNumberSet)});
            Set idByNumber = companyNumberColl.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            DynamicObjectCollection companyNameColl = QueryServiceHelper.query((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("name", "in", companyNameSet)});
            Set idByName = companyNameColl.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            if (EmptyUtil.isNoEmpty(idByNumber) && idByNumber.size() > 0) {
                companyIdSet.addAll(idByNumber);
            }
            if (EmptyUtil.isNoEmpty(idByName) && idByName.size() > 0) {
                companyIdSet.addAll(idByName);
            }
            if (EmptyUtil.isNoEmpty(idByName) && idByName.size() > 0) {
                Map paraMaps = SystemParameterHelper.getSysParamMap(companyIdSet);
                for (Map.Entry paraMap : paraMaps.entrySet()) {
                    String applybilltype;
                    long companyId;
                    boolean isapply;
                    String keyId = (String)paraMap.getKey();
                    Map valueMap = (Map)paraMap.getValue();
                    if (!EmptyUtil.isNoEmpty((Object)valueMap) || !(isapply = ((Boolean)valueMap.get("isapply")).booleanValue()) || this.openParamCOmpanyIdAndMap.containsKey(companyId = Long.parseLong(keyId)) || !EmptyUtil.isNoEmpty((String)(applybilltype = (String)valueMap.get("applybilltype")))) continue;
                    Set applybilltypeArr = Arrays.stream(applybilltype.split(",", -1)).collect(Collectors.toSet());
                    this.openParamCOmpanyIdAndMap.put(Long.parseLong(keyId), applybilltypeArr);
                }
            }
        }
    }

    private void checkDraweraccount(JSONObject data) {
        JSONObject bankAccountNumberJSON = data.getJSONObject("draweraccount");
        if (bankAccountNumberJSON == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CdmBizResource_120", (String)"tmc-cdm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u51fa\u7968\u4eba\u8d26\u53f7.\u94f6\u884c\u8d26\u53f7", (String)"CdmBizResource_127", (String)"tmc-cdm-common", (Object[])new Object[0])));
        }
        String bankAccountNumber = bankAccountNumberJSON.getString("bankaccountnumber");
        if (StringUtils.isEmpty((CharSequence)bankAccountNumber)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CdmBizResource_120", (String)"tmc-cdm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u51fa\u7968\u4eba\u8d26\u53f7.\u94f6\u884c\u8d26\u53f7", (String)"CdmBizResource_127", (String)"tmc-cdm-common", (Object[])new Object[0])));
        }
        List<DynamicObject> drawerAccounts = this.accountNumberAndAccMap.get(bankAccountNumber);
        if (EmptyUtil.isEmpty(drawerAccounts)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u7684\u503c\u201c%2$s\u201d\u4e0d\u5408\u6cd5\u3002", (String)"CdmBizResource_121", (String)"tmc-cdm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u51fa\u7968\u4eba\u8d26\u53f7.\u94f6\u884c\u8d26\u53f7", (String)"CdmBizResource_127", (String)"tmc-cdm-common", (Object[])new Object[0]), bankAccountNumber));
        }
        long accountId = drawerAccounts.get(0).getLong("id");
        List<DynamicObject> accountmaintenances = this.am_accountIdAndAmDyMap.get(accountId);
        if (!EmptyUtil.isEmpty(accountmaintenances)) {
            DynamicObject billbankDy;
            long billbankId = accountmaintenances.get(0).getLong("billbank");
            if (!EmptyUtil.isEmpty((Long)billbankId) && EmptyUtil.isNoEmpty((DynamicObject)(billbankDy = this.bank_idAndDyMap.get(billbankId)))) {
                data.put("drawerbankname", (Object)billbankDy.getString("name"));
            }
            data.put("drawerbankno", (Object)accountmaintenances.get(0).getString("billbankname"));
        } else {
            long bankId = drawerAccounts.get(0).getLong("bank");
            if (EmptyUtil.isEmpty((Long)bankId)) {
                return;
            }
            DynamicObject finOrgInfoDO = this.bank_idAndDyMap.get(bankId);
            data.put("drawerbankname", (Object)finOrgInfoDO.getString("name"));
            if (EmptyUtil.isEmpty((Long)finOrgInfoDO.getLong("bebank"))) {
                data.put("drawerbankno", (Object)finOrgInfoDO.getString("union_number"));
            } else {
                String bebankNumber = finOrgInfoDO.getString("bebank.number");
                if (EmptyUtil.isNoEmpty((String)bebankNumber)) {
                    data.put("drawerbankno", (Object)bebankNumber);
                }
            }
        }
    }

    private void checkSplitInfoAndAmount(JSONObject data) {
        if (EmptyUtil.isEmpty((String)data.getString("amount"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u4e2d\u5fc5\u987b\u914d\u7f6e\u7968\u9762\u91d1\u989d(\u5b50\u7968\u5305\u91d1\u989d)\u8fd9\u4e2a\u5b57\u6bb5\u4e14\u8be5\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (String)"CdmBizResource_134_1", (String)"tmc-cdm-common", (Object[])new Object[0]));
        }
        Boolean issplit = data.getBoolean("issplit");
        BigDecimal supperBillAmount = data.getBigDecimal("supperbillamount");
        BigDecimal amount = data.getBigDecimal("amount");
        String subbillquantity = data.getString("subbillquantity");
        String subbillstartflag = data.getString("subbillstartflag");
        String subbillendflag = data.getString("subbillendflag");
        if (issplit == null) {
            issplit = false;
            data.put("issplit", (Object)false);
        }
        if (issplit.booleanValue() && (EmptyUtil.isEmpty((String)subbillquantity) || EmptyUtil.isEmpty((String)subbillstartflag) || EmptyUtil.isEmpty((String)subbillendflag))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u80fd\u5426\u62c6\u5206\u201d\u4e3a\u662f\u65f6\uff0c\u5b50\u7968\u5305\u6570\u91cf\u3001\u5b50\u7968\u5305\u5f00\u59cb\u6807\u8bc6\u3001\u5b50\u7968\u5305\u7ed3\u675f\u6807\u8bc6\u5fc5\u586b\u3002", (String)"CdmBizResource_135_1", (String)"tmc-cdm-common", (Object[])new Object[0]));
        }
        if (issplit.booleanValue()) {
            long quantity;
            data.put("subbillrange", (Object)(subbillstartflag + "-" + subbillendflag));
            if (data.getBigDecimal("subbillquantity").multiply(new BigDecimal("0.01").setScale(2, 4)).compareTo(amount) != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u80fd\u5426\u62c6\u5206\u4e3a\u662f\u65f6\uff0c\u7968\u9762\u91d1\u989d(\u5b50\u7968\u5305\u91d1\u989d)\u548c\u5b50\u7968\u5305\u6570\u91cf\u4e24\u8005\u4e4b\u95f4\u4e0d\u6ee1\u8db3\u8ba1\u7b97\u5173\u7cfb", (String)"CdmBizResource_137_1", (String)"tmc-cdm-common", (Object[])new Object[0]));
            }
            long calQuantity = data.getLong("subbillendflag") - data.getLong("subbillstartflag") + 1L;
            if (calQuantity != (quantity = data.getLong("subbillquantity").longValue())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u80fd\u5426\u62c6\u5206\u4e3a\u662f\u65f6\uff0c\u5b50\u7968\u5305\u6570\u91cf\u548c\u5b50\u7968\u5305\u5f00\u59cb\u6807\u8bc6\u3001\u5b50\u7968\u5305\u7ed3\u675f\u6807\u8bc6\u4e4b\u95f4\u4e0d\u6ee1\u8db3\u8ba1\u7b97\u5173\u7cfb\u3002", (String)"PayableBillImportOp_0", (String)"tmc-cdm-opplugin", (Object[])new Object[0]));
            }
        }
        if (Boolean.FALSE.equals(issplit) || EmptyUtil.isEmpty((String)data.getString("supperbillamount"))) {
            data.put("supperbillamount", (Object)data.getBigDecimal("amount"));
        } else if (issplit.booleanValue() && amount.compareTo(supperBillAmount) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u80fd\u5426\u62c6\u5206\u4e3a\u662f\u65f6\uff0c\u7968\u9762\u91d1\u989d(\u5b50\u7968\u5305\u91d1\u989d)\u4e0d\u80fd\u5927\u4e8e\u6bcd\u7968\u91d1\u989d", (String)"CdmBizResource_136_1", (String)"tmc-cdm-common", (Object[])new Object[0]));
        }
        if (!issplit.booleanValue()) {
            data.put("standardbillamount", (Object)0.01);
            data.put("subbillquantity", (Object)0);
            data.put("subbillrange", (Object)0);
            data.put("subbillstartflag", (Object)0);
            data.put("subbillendflag", (Object)0);
            data.put("billidentitycode", (Object)"");
        } else {
            String subDraftBillRange = data.getString("subbillrange");
            data.put("originalsubbillrang", (Object)subDraftBillRange);
            data.put("originalsubbillamount", (Object)amount);
            data.put("availableamount", (Object)amount);
            String draftBillNo = data.getString("draftbillno");
            data.put("billidentitycode", (Object)(StringUtils.isNotEmpty((CharSequence)draftBillNo) ? draftBillNo + "-" + subDraftBillRange : ""));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkDraftBillTypeAndSettlementType(JSONObject data) {
        JSONObject draftBillTypeNumberJSON = data.getJSONObject("draftbilltype");
        if (draftBillTypeNumberJSON == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%s\u201d\u4e0d\u80fd\u5168\u90fd\u4e3a\u7a7a\u3002", (String)"CdmBizResource_170", (String)"tmc-cdm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b.\u7f16\u7801\u548c\u7968\u636e\u7c7b\u578b.\u540d\u79f0", (String)"CdmBizResource_130", (String)"tmc-cdm-common", (Object[])new Object[0])));
        }
        String draftBillTypeNumber = draftBillTypeNumberJSON.getString("number");
        String draftBillTypeName = draftBillTypeNumberJSON.getString("name");
        List<Object> draftBillTypes = new ArrayList(16);
        if (EmptyUtil.isNotEmpty((CharSequence)draftBillTypeNumber)) {
            draftBillTypes = this.billtypeNumberMap.get(draftBillTypeNumber);
            if (EmptyUtil.isEmpty(draftBillTypes)) {
                if (!EmptyUtil.isNotEmpty((CharSequence)draftBillTypeName)) throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u7684\u503c\u201c%2$s\u201d\u4e0d\u5408\u6cd5\u3002", (String)"CdmBizResource_121", (String)"tmc-cdm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b.\u7f16\u7801", (String)"CdmBizResource_172", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillTypeNumber));
                draftBillTypes = this.billtypeNameMap.get(draftBillTypeName);
                if (EmptyUtil.isEmpty(draftBillTypes)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u7684\u503c\u201c%2$s\u201d\u548c\u5b57\u6bb5\u201c%3$s\u201d\u7684\u503c\u201c%4$s\u201d\u90fd\u4e0d\u5408\u6cd5\u3002", (String)"CdmBizResource_171", (String)"tmc-cdm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b.\u7f16\u7801", (String)"CdmBizResource_172", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillTypeNumber, ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b.\u540d\u79f0", (String)"CdmBizResource_173", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillTypeName));
                }
                if (draftBillTypes.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u3010%1$s\u3011\u7684\u503c\u3010%2$s\u3011\u4e0d\u5408\u6cd5\uff0c\u5339\u914d\u591a\u6761\u7ed3\u679c", (String)"CdmBizResource_174", (String)"tmc-cdm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b.\u540d\u79f0", (String)"CdmBizResource_173", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillTypeName));
                }
            }
        } else if (EmptyUtil.isNotEmpty((CharSequence)draftBillTypeName)) {
            draftBillTypes = this.billtypeNameMap.get(draftBillTypeName);
            if (EmptyUtil.isEmpty(draftBillTypes)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u7684\u503c\u201c%2$s\u201d\u4e0d\u5408\u6cd5\u3002", (String)"CdmBizResource_121", (String)"tmc-cdm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b.\u540d\u79f0", (String)"CdmBizResource_173", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillTypeName));
            }
            if (draftBillTypes.size() > 1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u3010%1$s\u3011\u7684\u503c\u3010%2$s\u3011\u4e0d\u5408\u6cd5\uff0c\u5339\u914d\u591a\u6761\u7ed3\u679c", (String)"CdmBizResource_174", (String)"tmc-cdm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b.\u540d\u79f0", (String)"CdmBizResource_173", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillTypeName));
            }
        }
        if (EmptyUtil.isEmpty(draftBillTypes)) return;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)((DynamicObject)draftBillTypes.get(0)).getString("name"));
        jsonObject.put("number", (Object)((DynamicObject)draftBillTypes.get(0)).getString("number"));
        data.put("draftbilltype", (Object)jsonObject);
        String settlementType = ((DynamicObject)draftBillTypes.get(0)).getString("settlementtype");
        boolean isSupportSplit = settlementType.equals(SettleMentTypeEnum.BUSINESS.getValue()) || settlementType.equals(SettleMentTypeEnum.BANK.getValue());
        Boolean issplit = data.getBoolean("issplit");
        if (!issplit.booleanValue() || isSupportSplit) return;
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b.\u7f16\u7801\u201c%s\u201d\u80fd\u5426\u62c6\u5206\u7684\u503c\u4e0d\u5408\u6cd5\uff0c\u53ea\u6709\u627f\u5151\u6c47\u7968\u624d\u652f\u6301\u7968\u636e\u62c6\u5206\u3002", (String)"CdmBizResource_133", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillTypeNumber));
    }

    private void checkDrawer(JSONObject data) {
        JSONObject drawercompanyJSON = data.getJSONObject("drawercompany");
        JSONObject drawerorgJSON = data.getJSONObject("drawerorg");
        String drawerName = data.getString("drawername");
        List<Object> drawers = new ArrayList(16);
        this.drawerId = -1L;
        if (!EmptyUtil.isEmpty((Object)drawercompanyJSON)) {
            String drawercompanyNumber = drawercompanyJSON.getString("number");
            String drawercompanyName = drawercompanyJSON.getString("name");
            if (EmptyUtil.isNotEmpty((CharSequence)drawercompanyNumber)) {
                drawers = this.orgNumberMap.get(drawercompanyNumber);
                if (EmptyUtil.isEmpty(drawers) && EmptyUtil.isNotEmpty((CharSequence)drawercompanyName)) {
                    drawers = this.orgNameMap.get(drawercompanyName);
                }
                if (EmptyUtil.isNoEmpty(drawers) && drawers.size() > 0) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("name", (Object)((DynamicObject)drawers.get(0)).getString("name"));
                    jsonObject.put("number", (Object)((DynamicObject)drawers.get(0)).getString("number"));
                    data.put("drawercompany", (Object)jsonObject);
                    data.put("drawername", (Object)((DynamicObject)drawers.get(0)).getString("name"));
                    this.drawerId = ((DynamicObject)drawers.get(0)).getLong("id");
                }
            } else if (EmptyUtil.isNotEmpty((CharSequence)drawercompanyName) && EmptyUtil.isNoEmpty(drawers = this.orgNameMap.get(drawercompanyName)) && drawers.size() > 0) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("name", (Object)((DynamicObject)drawers.get(0)).getString("name"));
                jsonObject.put("number", (Object)((DynamicObject)drawers.get(0)).getString("number"));
                data.put("drawercompany", (Object)jsonObject);
                data.put("drawername", (Object)((DynamicObject)drawers.get(0)).getString("name"));
                this.drawerId = ((DynamicObject)drawers.get(0)).getLong("id");
            }
        } else if (!EmptyUtil.isEmpty((Object)drawerorgJSON)) {
            String drawerorgNumber = drawerorgJSON.getString("number");
            String drawerorgName = drawerorgJSON.getString("name");
            if (EmptyUtil.isNotEmpty((CharSequence)drawerorgNumber)) {
                drawers = this.bdFinorgNumberMap.get(drawerorgNumber);
                if (EmptyUtil.isEmpty(drawers) && EmptyUtil.isNotEmpty((CharSequence)drawerorgName)) {
                    drawers = this.bdFinorgNameMap.get(drawerorgNumber);
                }
                if (EmptyUtil.isNoEmpty(drawers) && drawers.size() > 0) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("name", (Object)((DynamicObject)drawers.get(0)).getString("name"));
                    jsonObject.put("number", (Object)((DynamicObject)drawers.get(0)).getString("number"));
                    data.put("drawerorg", (Object)jsonObject);
                    data.put("drawername", (Object)((DynamicObject)drawers.get(0)).getString("name"));
                    this.drawerId = ((DynamicObject)drawers.get(0)).getLong("id");
                }
            } else if (EmptyUtil.isNotEmpty((CharSequence)drawerorgName) && EmptyUtil.isNoEmpty(drawers = this.bdFinorgNameMap.get(drawerorgName)) && drawers.size() > 0) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("name", (Object)((DynamicObject)drawers.get(0)).getString("name"));
                jsonObject.put("number", (Object)((DynamicObject)drawers.get(0)).getString("number"));
                data.put("drawerorg", (Object)jsonObject);
                data.put("drawername", (Object)((DynamicObject)drawers.get(0)).getString("name"));
                this.drawerId = ((DynamicObject)drawers.get(0)).getLong("id");
            }
        } else if (EmptyUtil.isNotEmpty((CharSequence)drawerName)) {
            boolean isCheckBill;
            String draftBillTypeNumber = data.getJSONObject("draftbilltype").getString("number");
            List<DynamicObject> draftBillTypes = this.billtypeNumberMap.get(draftBillTypeNumber);
            String settlementType = "";
            if (EmptyUtil.isNoEmpty(draftBillTypes) && draftBillTypes.size() > 0) {
                settlementType = draftBillTypes.get(0).getString("settlementtype");
            }
            if (isCheckBill = settlementType.equals(SettleMentTypeEnum.CHECK.getValue())) {
                drawers = this.bdFinorgNameMap.get(drawerName);
                if (EmptyUtil.isNoEmpty(drawers) && drawers.size() > 0) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("name", (Object)((DynamicObject)drawers.get(0)).getString("name"));
                    jsonObject.put("number", (Object)((DynamicObject)drawers.get(0)).getString("number"));
                    data.put("drawerorg", (Object)jsonObject);
                    this.drawerId = ((DynamicObject)drawers.get(0)).getLong("id");
                }
            } else {
                drawers = this.orgNameMap.get(drawerName);
                if (EmptyUtil.isNoEmpty(drawers) && drawers.size() > 0) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("name", (Object)((DynamicObject)drawers.get(0)).getString("name"));
                    jsonObject.put("number", (Object)((DynamicObject)drawers.get(0)).getString("number"));
                    data.put("drawercompany", (Object)jsonObject);
                    this.drawerId = ((DynamicObject)drawers.get(0)).getLong("id");
                }
            }
        }
    }

    private void checkReceiver(JSONObject data) {
        String payeeType = data.getString("payeetype");
        JSONObject receiverJSON = data.getJSONObject("receiver");
        String receiveName = data.getString("receivername");
        if (EmptyUtil.isNotEmpty((CharSequence)payeeType)) {
            if (!EmptyUtil.isEmpty((Object)receiverJSON)) {
                String receiverNumber = receiverJSON.getString("number");
                String receiverName = receiverJSON.getString("name");
                if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bd_supplier")) {
                    this.setBaseDataAndText(data, receiverNumber, receiverName, "bd_supplier", "receiver", "receivername", "receivertype");
                } else if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bos_org")) {
                    this.setBaseDataAndText(data, receiverNumber, receiverName, "bos_org", "receiver", "receivername", "receivertype");
                } else if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bd_customer")) {
                    this.setBaseDataAndText(data, receiverNumber, receiverName, "bd_customer", "receiver", "receivername", "receivertype");
                } else if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bos_user")) {
                    this.setBaseDataAndText(data, receiverNumber, receiverName, "bos_user", "receiver", "receivername", "receivertype");
                }
            } else if (EmptyUtil.isNotEmpty((CharSequence)receiveName)) {
                if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bd_supplier")) {
                    this.setBaseDataByText(data, receiveName, "bd_supplier", "receiver", "receivertype");
                } else if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bos_org")) {
                    this.setBaseDataByText(data, receiveName, "bos_org", "receiver", "receivertype");
                } else if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bd_customer")) {
                    this.setBaseDataByText(data, receiveName, "bd_customer", "receiver", "receivertype");
                } else if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bos_user")) {
                    this.setBaseDataByText(data, receiveName, "bos_user", "receiver", "receivertype");
                }
            }
        }
    }

    private void setBaseDataAndText(JSONObject data, String number, String name, String entityName, String baseDataName, String sameNameText, String baseDataType) {
        List<Object> dynamicObjects = new ArrayList(16);
        Long customerId = 0L;
        Long supplyId = 0L;
        if (EmptyUtil.isNotEmpty((CharSequence)number)) {
            switch (entityName) {
                case "bd_supplier": {
                    dynamicObjects = this.supplyNumberMap.get(number);
                    if (!BaseDataHelper.isNeedCheckProperty((String)entityName, (String)baseDataName)) break;
                    supplyId = this.supplyNumberToIdMap.get(number);
                    BaseDataHelper.checkCustomerOrSupplyAuth((String)"PayableBill", (String)"bd_supplier", (Long)supplyId, (Long)this.drawerId);
                    break;
                }
                case "bos_org": {
                    dynamicObjects = this.orgNumberMap.get(number);
                    break;
                }
                case "bd_customer": {
                    dynamicObjects = this.customerNumberMap.get(number);
                    if (!BaseDataHelper.isNeedCheckProperty((String)entityName, (String)baseDataName)) break;
                    customerId = this.customerNumberToIdMap.get(number);
                    BaseDataHelper.checkCustomerOrSupplyAuth((String)"PayableBill", (String)"bd_customer", (Long)customerId, (Long)this.drawerId);
                    break;
                }
                case "bos_user": {
                    dynamicObjects = this.userNumberMap.get(number);
                    break;
                }
            }
            if (EmptyUtil.isEmpty(dynamicObjects) && EmptyUtil.isNotEmpty((CharSequence)name)) {
                switch (entityName) {
                    case "bd_supplier": {
                        dynamicObjects = this.supplyNameMap.get(name);
                        if (!BaseDataHelper.isNeedCheckProperty((String)entityName, (String)baseDataName)) break;
                        supplyId = this.supplyNameToIdMap.get(name);
                        BaseDataHelper.checkCustomerOrSupplyAuth((String)"PayableBill", (String)"bd_supplier", (Long)supplyId, (Long)this.drawerId);
                        break;
                    }
                    case "bos_org": {
                        dynamicObjects = this.orgNameMap.get(name);
                        break;
                    }
                    case "bd_customer": {
                        dynamicObjects = this.customerNameMap.get(name);
                        if (!BaseDataHelper.isNeedCheckProperty((String)entityName, (String)baseDataName)) break;
                        customerId = this.customerNameToIdMap.get(name);
                        BaseDataHelper.checkCustomerOrSupplyAuth((String)"PayableBill", (String)"bd_customer", (Long)customerId, (Long)this.drawerId);
                        break;
                    }
                    case "bos_user": {
                        dynamicObjects = this.userNameMap.get(name);
                        break;
                    }
                }
            }
            if (EmptyUtil.isNoEmpty(dynamicObjects) && dynamicObjects.size() > 0) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("name", (Object)((DynamicObject)dynamicObjects.get(0)).getString("name"));
                jsonObject.put("number", (Object)((DynamicObject)dynamicObjects.get(0)).getString("number"));
                data.put(baseDataName, (Object)jsonObject);
                data.put(sameNameText, (Object)((DynamicObject)dynamicObjects.get(0)).getString("name"));
                data.put(baseDataType, (Object)entityName);
            }
        } else if (EmptyUtil.isNotEmpty((CharSequence)name)) {
            switch (entityName) {
                case "bd_supplier": {
                    dynamicObjects = this.supplyNameMap.get(name);
                    if (!BaseDataHelper.isNeedCheckProperty((String)entityName, (String)baseDataName)) break;
                    supplyId = this.supplyNameToIdMap.get(name);
                    BaseDataHelper.checkCustomerOrSupplyAuth((String)"PayableBill", (String)"bd_supplier", (Long)supplyId, (Long)this.drawerId);
                    break;
                }
                case "bos_org": {
                    dynamicObjects = this.orgNameMap.get(name);
                    break;
                }
                case "bd_customer": {
                    dynamicObjects = this.customerNameMap.get(name);
                    if (!BaseDataHelper.isNeedCheckProperty((String)entityName, (String)baseDataName)) break;
                    customerId = this.customerNameToIdMap.get(name);
                    BaseDataHelper.checkCustomerOrSupplyAuth((String)"PayableBill", (String)"bd_customer", (Long)customerId, (Long)this.drawerId);
                    break;
                }
                case "bos_user": {
                    dynamicObjects = this.userNameMap.get(name);
                    break;
                }
            }
            if (EmptyUtil.isNoEmpty(dynamicObjects) && dynamicObjects.size() > 0) {
                String jsonObject = new JSONObject();
                jsonObject.put("name", (Object)((DynamicObject)dynamicObjects.get(0)).getString("name"));
                jsonObject.put("number", (Object)((DynamicObject)dynamicObjects.get(0)).getString("number"));
                data.put(baseDataName, (Object)jsonObject);
                data.put(sameNameText, (Object)((DynamicObject)dynamicObjects.get(0)).getString("name"));
                data.put(baseDataType, (Object)entityName);
            }
        }
    }

    private void setBaseDataByText(JSONObject data, String name, String entityName, String baseDataName, String baseDataType) {
        List<Object> dynamicObjects = new ArrayList(16);
        Long supplyId = 0L;
        Long customerId = 0L;
        if (EmptyUtil.isNotEmpty((CharSequence)name)) {
            switch (entityName) {
                case "bd_supplier": {
                    dynamicObjects = this.supplyNameMap.get(name);
                    if (!BaseDataHelper.isNeedCheckProperty((String)entityName, (String)baseDataName)) break;
                    supplyId = this.supplyNameToIdMap.get(name);
                    BaseDataHelper.checkCustomerOrSupplyAuth((String)"PayableBill", (String)"bd_supplier", (Long)supplyId, (Long)this.drawerId);
                    break;
                }
                case "bos_org": {
                    dynamicObjects = this.orgNameMap.get(name);
                    break;
                }
                case "bd_customer": {
                    dynamicObjects = this.customerNameMap.get(name);
                    if (!BaseDataHelper.isNeedCheckProperty((String)entityName, (String)baseDataName)) break;
                    customerId = this.customerNameToIdMap.get(name);
                    BaseDataHelper.checkCustomerOrSupplyAuth((String)"PayableBill", (String)"bd_customer", (Long)customerId, (Long)this.drawerId);
                    break;
                }
                case "bos_user": {
                    dynamicObjects = this.userNameMap.get(name);
                    break;
                }
            }
            if (EmptyUtil.isNoEmpty(dynamicObjects) && dynamicObjects.size() > 0) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("name", (Object)((DynamicObject)dynamicObjects.get(0)).getString("name"));
                jsonObject.put("number", (Object)((DynamicObject)dynamicObjects.get(0)).getString("number"));
                data.put(baseDataName, (Object)jsonObject);
                data.put(baseDataType, (Object)entityName);
            }
        }
    }

    private void checkAccepter(JSONObject data) {
        JSONObject accepterfinorgJSON = data.getJSONObject("accepterfinorg");
        JSONObject acceptercompanyJSON = data.getJSONObject("acceptercompany");
        String accepterName = data.getString("acceptername");
        List<Object> accepters = new ArrayList(16);
        if (!EmptyUtil.isEmpty((Object)accepterfinorgJSON)) {
            String accepterfinorgNumber = accepterfinorgJSON.getString("number");
            String accepterfinorgName = accepterfinorgJSON.getString("name");
            if (EmptyUtil.isNotEmpty((CharSequence)accepterfinorgNumber)) {
                accepters = this.bdFinorgNumberMap.get(accepterfinorgNumber);
                if (EmptyUtil.isEmpty(accepters) && EmptyUtil.isNotEmpty((CharSequence)accepterfinorgName)) {
                    accepters = this.bdFinorgNameMap.get(accepterfinorgName);
                }
                if (EmptyUtil.isNoEmpty(accepters) && accepters.size() > 0) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("name", (Object)((DynamicObject)accepters.get(0)).getString("name"));
                    jsonObject.put("number", (Object)((DynamicObject)accepters.get(0)).getString("number"));
                    data.put("accepterfinorg", (Object)jsonObject);
                    data.put("acceptername", (Object)((DynamicObject)accepters.get(0)).getString("name"));
                }
            } else if (EmptyUtil.isNotEmpty((CharSequence)accepterfinorgName) && EmptyUtil.isNoEmpty(accepters = this.bdFinorgNameMap.get(accepterfinorgName)) && accepters.size() > 0) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("name", (Object)((DynamicObject)accepters.get(0)).getString("name"));
                jsonObject.put("number", (Object)((DynamicObject)accepters.get(0)).getString("number"));
                data.put("accepterfinorg", (Object)jsonObject);
                data.put("acceptername", (Object)((DynamicObject)accepters.get(0)).getString("name"));
            }
        } else if (!EmptyUtil.isEmpty((Object)acceptercompanyJSON)) {
            String acceptercompanyNumber = acceptercompanyJSON.getString("number");
            String acceptercompanyName = acceptercompanyJSON.getString("name");
            if (EmptyUtil.isNotEmpty((CharSequence)acceptercompanyNumber)) {
                accepters = this.orgNumberMap.get(acceptercompanyNumber);
                if (EmptyUtil.isEmpty(accepters) && EmptyUtil.isNotEmpty((CharSequence)acceptercompanyName)) {
                    accepters = this.orgNameMap.get(acceptercompanyName);
                }
                if (EmptyUtil.isNoEmpty(accepters) && accepters.size() > 0) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("name", (Object)((DynamicObject)accepters.get(0)).getString("name"));
                    jsonObject.put("number", (Object)((DynamicObject)accepters.get(0)).getString("number"));
                    data.put("acceptercompany", (Object)jsonObject);
                    data.put("acceptername", (Object)((DynamicObject)accepters.get(0)).getString("name"));
                }
            } else if (EmptyUtil.isNotEmpty((CharSequence)acceptercompanyName) && EmptyUtil.isNoEmpty(accepters = this.orgNameMap.get(acceptercompanyName)) && accepters.size() > 0) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("name", (Object)((DynamicObject)accepters.get(0)).getString("name"));
                jsonObject.put("number", (Object)((DynamicObject)accepters.get(0)).getString("number"));
                data.put("acceptercompany", (Object)jsonObject);
                data.put("acceptername", (Object)((DynamicObject)accepters.get(0)).getString("name"));
            }
        } else if (EmptyUtil.isNotEmpty((CharSequence)accepterName)) {
            String draftBillTypeNumber = data.getJSONObject("draftbilltype").getString("number");
            QFilter draftBillTypeNumberFilter = new QFilter("number", "=", (Object)draftBillTypeNumber);
            DynamicObject[] draftBillTypes = TmcDataServiceHelper.load((String)"cdm_billtype", (String)"id,settlementtype", (QFilter[])new QFilter[]{draftBillTypeNumberFilter});
            String settlementType = "";
            if (draftBillTypes.length > 0) {
                settlementType = draftBillTypes[0].getString("settlementtype");
            }
            if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                accepters = this.bdFinorgNameMap.get(accepterName);
                if (EmptyUtil.isNoEmpty(accepters) && accepters.size() > 0) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("name", (Object)((DynamicObject)accepters.get(0)).getString("name"));
                    jsonObject.put("number", (Object)((DynamicObject)accepters.get(0)).getString("number"));
                    data.put("accepterfinorg", (Object)jsonObject);
                }
            } else if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue()) && EmptyUtil.isNoEmpty(accepters = this.orgNameMap.get(accepterName)) && accepters.size() > 0) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("name", (Object)((DynamicObject)accepters.get(0)).getString("name"));
                jsonObject.put("number", (Object)((DynamicObject)accepters.get(0)).getString("number"));
                data.put("acceptercompany", (Object)jsonObject);
            }
        }
    }

    private void checkAcceptPromiser(JSONObject data) {
        String acceptpromiserType = data.getString("acceptpromisertype");
        JSONObject acceptpromiserJSON = data.getJSONObject("acceptpromiser");
        String acceptpromiseName = data.getString("acceptpromisername");
        if (EmptyUtil.isNotEmpty((CharSequence)acceptpromiserType)) {
            if (!EmptyUtil.isEmpty((Object)acceptpromiserJSON)) {
                String acceptpromiserNumber = acceptpromiserJSON.getString("number");
                String acceptpromiserName = acceptpromiserJSON.getString("name");
                if (StringUtils.equals((CharSequence)acceptpromiserType, (CharSequence)"bd_supplier")) {
                    this.setBaseDataAndText(data, acceptpromiserNumber, acceptpromiserName, "bd_supplier", "acceptpromiser", "acceptpromisername", "accpromisetype");
                } else if (StringUtils.equals((CharSequence)acceptpromiserType, (CharSequence)"bos_org")) {
                    this.setBaseDataAndText(data, acceptpromiserNumber, acceptpromiserName, "bos_org", "acceptpromiser", "acceptpromisername", "accpromisetype");
                } else if (StringUtils.equals((CharSequence)acceptpromiserType, (CharSequence)"bd_customer")) {
                    this.setBaseDataAndText(data, acceptpromiserNumber, acceptpromiserName, "bd_customer", "acceptpromiser", "acceptpromisername", "accpromisetype");
                } else if (StringUtils.equals((CharSequence)acceptpromiserType, (CharSequence)"bos_user")) {
                    this.setBaseDataAndText(data, acceptpromiserNumber, acceptpromiserName, "bos_user", "acceptpromiser", "acceptpromisername", "accpromisetype");
                }
            } else if (EmptyUtil.isNotEmpty((CharSequence)acceptpromiseName)) {
                if (StringUtils.equals((CharSequence)acceptpromiserType, (CharSequence)"bd_supplier")) {
                    this.setBaseDataByText(data, acceptpromiseName, "bd_supplier", "acceptpromiser", "accpromisetype");
                } else if (StringUtils.equals((CharSequence)acceptpromiserType, (CharSequence)"bos_org")) {
                    this.setBaseDataByText(data, acceptpromiseName, "bos_org", "acceptpromiser", "accpromisetype");
                } else if (StringUtils.equals((CharSequence)acceptpromiserType, (CharSequence)"bd_customer")) {
                    this.setBaseDataByText(data, acceptpromiseName, "bd_customer", "acceptpromiser", "accpromisetype");
                } else if (StringUtils.equals((CharSequence)acceptpromiserType, (CharSequence)"bos_user")) {
                    this.setBaseDataByText(data, acceptpromiseName, "bos_user", "acceptpromiser", "accpromisetype");
                }
            }
        }
    }

    private void checkIssuePromiser(JSONObject data) {
        String issuepromiserType = data.getString("issuepromisertype");
        JSONObject issuepromiserJSON = data.getJSONObject("issuepromiser");
        String issuepromiseName = data.getString("issuepromisername");
        if (EmptyUtil.isNotEmpty((CharSequence)issuepromiserType)) {
            if (!EmptyUtil.isEmpty((Object)issuepromiserJSON)) {
                String issuepromiserNumber = issuepromiserJSON.getString("number");
                String issuepromiserName = issuepromiserJSON.getString("name");
                if (StringUtils.equals((CharSequence)issuepromiserType, (CharSequence)"bd_supplier")) {
                    this.setBaseDataAndText(data, issuepromiserNumber, issuepromiserName, "bd_supplier", "issuepromiser", "issuepromisername", "isspromisetype");
                } else if (StringUtils.equals((CharSequence)issuepromiserType, (CharSequence)"bos_org")) {
                    this.setBaseDataAndText(data, issuepromiserNumber, issuepromiserName, "bos_org", "issuepromiser", "issuepromisername", "isspromisetype");
                } else if (StringUtils.equals((CharSequence)issuepromiserType, (CharSequence)"bd_customer")) {
                    this.setBaseDataAndText(data, issuepromiserNumber, issuepromiserName, "bd_customer", "issuepromiser", "issuepromisername", "isspromisetype");
                } else if (StringUtils.equals((CharSequence)issuepromiserType, (CharSequence)"bos_user")) {
                    this.setBaseDataAndText(data, issuepromiserNumber, issuepromiserName, "bos_user", "issuepromiser", "issuepromisername", "isspromisetype");
                }
            } else if (EmptyUtil.isNotEmpty((CharSequence)issuepromiseName)) {
                if (StringUtils.equals((CharSequence)issuepromiserType, (CharSequence)"bd_supplier")) {
                    this.setBaseDataByText(data, issuepromiseName, "bd_supplier", "issuepromiser", "isspromisetype");
                } else if (StringUtils.equals((CharSequence)issuepromiserType, (CharSequence)"bos_org")) {
                    this.setBaseDataByText(data, issuepromiseName, "bos_org", "issuepromiser", "isspromisetype");
                } else if (StringUtils.equals((CharSequence)issuepromiserType, (CharSequence)"bd_customer")) {
                    this.setBaseDataByText(data, issuepromiseName, "bd_customer", "issuepromiser", "isspromisetype");
                } else if (StringUtils.equals((CharSequence)issuepromiserType, (CharSequence)"bos_user")) {
                    this.setBaseDataByText(data, issuepromiseName, "bos_user", "issuepromiser", "isspromisetype");
                }
            }
        }
    }

    private void checkCompanyEnablePayableApply(JSONObject data) {
        JSONObject companyJSON = data.getJSONObject("company");
        if (companyJSON != null) {
            String settlementtype;
            boolean needContorlApply;
            Set<String> paramStrSet;
            boolean needApply;
            List<DynamicObject> bosOrgs;
            String companyNumber = companyJSON.getString("number");
            String companyName = companyJSON.getString("name");
            JSONObject draftBillTypeNumberJSON = data.getJSONObject("draftbilltype");
            if (EmptyUtil.isNotEmpty((CharSequence)companyNumber)) {
                String settlementtype2;
                boolean needContorlApply2;
                Set<String> paramStrSet2;
                boolean needApply2;
                List<DynamicObject> bosOrgs2 = this.orgNumberMap.get(companyNumber);
                if (!EmptyUtil.isEmpty(bosOrgs2)) {
                    String settlementtype3;
                    boolean needContorlApply3;
                    Set<String> paramStrSet3 = this.openParamCOmpanyIdAndMap.get(bosOrgs2.get(0).getLong("id"));
                    boolean needApply3 = EmptyUtil.isNoEmpty(paramStrSet3);
                    if (needApply3 && (needContorlApply3 = DraftHelper.isNeedContorlApply(paramStrSet3, (String)(settlementtype3 = this.getBillTypeSettleType(draftBillTypeNumberJSON))))) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7.\u7f16\u7801\u201c%s\u201d\u5df2\u5f00\u542f\u201c\u542f\u7528\u5f00\u7968\u7533\u8bf7\u201d\u53c2\u6570\uff0c\u8bf7\u5148\u8fdb\u884c\u5f00\u7968\u7533\u8bf7\u3002", (String)"CdmBizResource_162", (String)"tmc-cdm-common", (Object[])new Object[0]), companyNumber));
                    }
                } else if (EmptyUtil.isNotEmpty((CharSequence)companyName) && !EmptyUtil.isEmpty(bosOrgs2 = this.orgNameMap.get(companyName)) && (needApply2 = EmptyUtil.isNoEmpty(paramStrSet2 = this.openParamCOmpanyIdAndMap.get(bosOrgs2.get(0).getLong("id")))) && (needContorlApply2 = DraftHelper.isNeedContorlApply(paramStrSet2, (String)(settlementtype2 = this.getBillTypeSettleType(draftBillTypeNumberJSON))))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7.\u540d\u79f0\u201c%s\u201d\u5df2\u5f00\u542f\u201c\u542f\u7528\u5f00\u7968\u7533\u8bf7\u201d\u53c2\u6570\uff0c\u8bf7\u5148\u8fdb\u884c\u5f00\u7968\u7533\u8bf7\u3002", (String)"CdmBizResource_163", (String)"tmc-cdm-common", (Object[])new Object[0]), companyName));
                }
            } else if (EmptyUtil.isNotEmpty((CharSequence)companyName) && !EmptyUtil.isEmpty(bosOrgs = this.orgNameMap.get(companyName)) && (needApply = EmptyUtil.isNoEmpty(paramStrSet = this.openParamCOmpanyIdAndMap.get(bosOrgs.get(0).getLong("id")))) && (needContorlApply = DraftHelper.isNeedContorlApply(paramStrSet, (String)(settlementtype = this.getBillTypeSettleType(draftBillTypeNumberJSON))))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7.\u540d\u79f0\u201c%s\u201d\u5df2\u5f00\u542f\u201c\u542f\u7528\u5f00\u7968\u7533\u8bf7\u201d\u53c2\u6570\uff0c\u8bf7\u5148\u8fdb\u884c\u5f00\u7968\u7533\u8bf7\u3002", (String)"CdmBizResource_163", (String)"tmc-cdm-common", (Object[])new Object[0]), companyName));
            }
        }
    }

    private String getBillTypeSettleType(JSONObject draftBillTypeNumberJSON) {
        String settlementtype = "";
        String draftBillTypeNumber = draftBillTypeNumberJSON.getString("number");
        String draftBillTypeName = draftBillTypeNumberJSON.getString("name");
        if (EmptyUtil.isNoEmpty((String)draftBillTypeNumber)) {
            List<DynamicObject> billTypeList = this.billtypeNumberMap.get(draftBillTypeNumber);
            settlementtype = billTypeList.get(0).getString("settlementtype");
        } else if (EmptyUtil.isNoEmpty((String)draftBillTypeName)) {
            List<DynamicObject> billTypeList = this.billtypeNameMap.get(draftBillTypeName);
            settlementtype = billTypeList.get(0).getString("settlementtype");
        }
        return settlementtype;
    }

    private boolean needReCalAmount(String subbillquantity, String subbillstartflag, String subbillendflag) {
        return EmptyUtil.isNotEmpty((CharSequence)subbillquantity) || EmptyUtil.isNotEmpty((CharSequence)subbillstartflag) && EmptyUtil.isNotEmpty((CharSequence)subbillendflag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImportBillData> checkImportRepeatDraftBillNo(List<ImportBillData> checkedBillDatas, ImportLogger logger) {
        if (EmptyUtil.isNoEmpty(checkedBillDatas)) {
            ImportBillData[] importBillDatas = checkedBillDatas.toArray(new ImportBillData[checkedBillDatas.size()]);
            int length = importBillDatas.length;
            HashSet<Integer> hasCheckIndex = new HashSet<Integer>(16);
            for (int i = 0; i < length; ++i) {
                for (int j = 0; j < length - 1 - i; ++j) {
                    int startIndex;
                    ImportBillData after;
                    String errorMessage;
                    block11: {
                        errorMessage = null;
                        after = null;
                        try {
                            ImportBillData before = importBillDatas[i];
                            after = importBillDatas[j + i + 1];
                            if (!this.isRepeatImportData(before, after)) break block11;
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801\u201c%s\u201d\u91cd\u590d\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"CdmBizResource_119", (String)"tmc-cdm-common", (Object[])new Object[0]), after.getData().getString("draftbillno")));
                        }
                        catch (Exception exc) {
                            int startIndex2;
                            try {
                                errorMessage = exc.getMessage();
                            }
                            catch (Throwable throwable) {
                                if (StringUtils.isNotEmpty(errorMessage)) {
                                    int startIndex3;
                                    if (after != null && hasCheckIndex.add(startIndex3 = after.getStartIndex())) {
                                        logger.log(Integer.valueOf(startIndex3), errorMessage).fail();
                                    }
                                    checkedBillDatas.remove(after);
                                }
                                throw throwable;
                            }
                            if (!StringUtils.isNotEmpty((CharSequence)errorMessage)) continue;
                            if (after != null && hasCheckIndex.add(startIndex2 = after.getStartIndex())) {
                                logger.log(Integer.valueOf(startIndex2), errorMessage).fail();
                            }
                            checkedBillDatas.remove(after);
                            continue;
                        }
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)errorMessage)) continue;
                    if (after != null && hasCheckIndex.add(startIndex = after.getStartIndex())) {
                        logger.log(Integer.valueOf(startIndex), errorMessage).fail();
                    }
                    checkedBillDatas.remove(after);
                    continue;
                }
            }
        }
        return checkedBillDatas;
    }

    private boolean isRepeatImportData(ImportBillData before, ImportBillData after) {
        String afterDraftBillNo;
        String beforeDraftBillNo;
        if (before == null || after == null) {
            return false;
        }
        JSONObject beforeData = before.getData();
        JSONObject afterData = after.getData();
        boolean isSettlementTypeSame = false;
        boolean isBankAccountNumberSame = false;
        boolean isDraftBillNoSame = false;
        boolean isSubBillRangeSame = false;
        String beforeNumber = beforeData.getJSONObject("draftbilltype").getString("number");
        List<DynamicObject> beforeDraftBillTypeList = this.billtypeNumberMap.get(beforeNumber);
        String beforeSettlementType = beforeDraftBillTypeList.get(0).getString("settlementtype");
        String afterNumber = afterData.getJSONObject("draftbilltype").getString("number");
        List<DynamicObject> afterDraftBillTypeList = this.billtypeNumberMap.get(afterNumber);
        String afterSettlementType = afterDraftBillTypeList.get(0).getString("settlementtype");
        if ((beforeSettlementType.equals(SettleMentTypeEnum.BUSINESS.getValue()) || beforeSettlementType.equals(SettleMentTypeEnum.BANK.getValue())) && (afterSettlementType.equals(SettleMentTypeEnum.BUSINESS.getValue()) || afterSettlementType.equals(SettleMentTypeEnum.BANK.getValue()))) {
            isSettlementTypeSame = true;
        } else if (beforeSettlementType.equals(afterSettlementType)) {
            isSettlementTypeSame = true;
        }
        String beforeBankAccountNumber = beforeData.getJSONObject("draweraccount").getString("bankaccountnumber");
        String afterBankAccountNumber = afterData.getJSONObject("draweraccount").getString("bankaccountnumber");
        if (beforeBankAccountNumber.equals(afterBankAccountNumber)) {
            isBankAccountNumberSame = true;
        }
        if ((beforeDraftBillNo = beforeData.getString("draftbillno")).equals(afterDraftBillNo = afterData.getString("draftbillno"))) {
            isDraftBillNoSame = true;
        }
        boolean beforeIssplit = beforeData.getBoolean("issplit");
        boolean afterIssplit = afterData.getBoolean("issplit");
        if (beforeIssplit && afterIssplit) {
            Long endFlag;
            String afterSubBillRange;
            Long startFlag;
            String beforeSubBillRange = beforeData.getString("subbillrange");
            if (this.isRepeatDraftBillNo(beforeSubBillRange, startFlag = Long.valueOf((afterSubBillRange = afterData.getString("subbillrange")).split("-")[0]), endFlag = Long.valueOf(afterSubBillRange.split("-")[1]))) {
                isSubBillRangeSame = true;
            }
        } else {
            isSubBillRangeSame = !beforeIssplit && !afterIssplit;
        }
        return isSettlementTypeSame && isBankAccountNumberSame && isDraftBillNoSame && isSubBillRangeSame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImportBillData> checkDBRepeatDraftBillNo(List<ImportBillData> checkedBillDatas, ImportLogger logger) {
        this.getPayBillData(checkedBillDatas);
        Iterator<ImportBillData> it = checkedBillDatas.iterator();
        ArrayList<ImportBillData> repeatDataList = new ArrayList<ImportBillData>(checkedBillDatas.size());
        while (it.hasNext()) {
            String errorMessage = null;
            ImportBillData rowData = it.next();
            JSONObject data = rowData.getData();
            try {
                boolean isSupportSplit;
                String bankAccountNumber = data.getJSONObject("draweraccount").getString("bankaccountnumber");
                List<DynamicObject> drawerAccounts = this.accountNumberAndAccMap.get(bankAccountNumber);
                long bankCate = EmptyUtil.isNoEmpty(drawerAccounts) ? this.getBankProperty(drawerAccounts.get(0), "bank_cate") : 0L;
                String draftBillNo = data.getString("draftbillno");
                String subBillRange = data.getString("subbillrange");
                boolean issplit = data.getBoolean("issplit");
                String draftBillTypeNumber = data.getJSONObject("draftbilltype").getString("number");
                List<DynamicObject> draftBillTypes = this.billtypeNumberMap.get(draftBillTypeNumber);
                String settlementType = draftBillTypes.get(0).getString("settlementtype");
                boolean bl = isSupportSplit = settlementType.equals(SettleMentTypeEnum.BUSINESS.getValue()) || settlementType.equals(SettleMentTypeEnum.BANK.getValue());
                if (!StringUtils.isNotEmpty((CharSequence)draftBillNo)) continue;
                if (EmptyUtil.isEmpty((Long)bankCate)) {
                    if (!this.isExist(drawerAccounts.get(0), data)) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801\u201c%s\u201d\u91cd\u590d\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"CdmBizResource_119", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillNo));
                }
                List<Object> payableBills = new ArrayList(16);
                List<DynamicObject> payableBillsDb = this.draftbillnoAndDyMap.get(draftBillNo);
                if (EmptyUtil.isNoEmpty(payableBillsDb)) {
                    payableBills = settlementType.equals(SettleMentTypeEnum.BUSINESS.getValue()) || settlementType.equals(SettleMentTypeEnum.BANK.getValue()) ? payableBillsDb.stream().filter(e -> this.draftTypeSet.contains(e.getString("draftbilltype.settlementtype")) && bankCate == e.getLong("draweraccount.bank.bank_cate")).collect(Collectors.toList()) : payableBillsDb.stream().filter(e -> settlementType.equals(e.getString("draftbilltype.settlementtype"))).collect(Collectors.toList());
                }
                if (!isSupportSplit && EmptyUtil.isNoEmpty(payableBills) && payableBills.size() > 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801\u201c%s\u201d\u91cd\u590d\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"CdmBizResource_119", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillNo));
                }
                if (isSupportSplit && !issplit && EmptyUtil.isNoEmpty(payableBills) && payableBills.size() > 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801\u201c%s\u201d\u91cd\u590d\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"CdmBizResource_119", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillNo));
                }
                boolean isExistNoSplit = false;
                for (DynamicObject dynamicObject : payableBills) {
                    boolean isSplitDb = dynamicObject.getBoolean("issplit");
                    if (isSplitDb) continue;
                    isExistNoSplit = true;
                    break;
                }
                if (isSupportSplit && issplit && isExistNoSplit) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801\u201c%s\u201d\u91cd\u590d\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"CdmBizResource_119", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillNo));
                }
                if (!isSupportSplit || !issplit || !StringUtils.isNotEmpty((CharSequence)subBillRange)) continue;
                Long startFlag = Long.valueOf(subBillRange.split("-")[0]);
                Long endFlag = Long.valueOf(subBillRange.split("-")[1]);
                for (DynamicObject payableBill : payableBills) {
                    String subBillRangeDb = payableBill.getString("subbillrange");
                    if (!this.isRepeatDraftBillNo(subBillRangeDb, startFlag, endFlag)) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801\u201c%s\u201d\u91cd\u590d\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"CdmBizResource_119", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillNo));
                }
            }
            catch (Exception exc) {
                errorMessage = exc.getMessage();
            }
            finally {
                if (!StringUtils.isNotEmpty((CharSequence)errorMessage)) continue;
                logger.log(Integer.valueOf(rowData.getStartIndex()), errorMessage).fail();
                repeatDataList.add(rowData);
                it.remove();
            }
        }
        return repeatDataList;
    }

    private Map<String, List<DynamicObject>> getPayBillData(List<ImportBillData> checkedBillDatas) {
        HashSet<String> billnoSet = new HashSet<String>(16);
        for (ImportBillData checkedBillData : checkedBillDatas) {
            JSONObject data = checkedBillData.getData();
            String draftBillNo = data.getString("draftbillno");
            billnoSet.add(draftBillNo);
        }
        QFilter draftBillNoFilter = new QFilter("draftbillno", "in", billnoSet);
        QFilter draftBillStatusFilter = new QFilter("draftbillstatus", "=", (Object)DraftBillStatusEnum.REGISTERED.getValue());
        QFilter payBillFilter = new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.PAYBILL.getValue());
        DynamicObjectCollection payableBillsColl = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id,issplit,subbillrange,draftbillno,draftbilltype,draweraccount,draftbilltype.settlementtype,draweraccount.bank.bank_cate", (QFilter[])new QFilter[]{draftBillNoFilter, draftBillStatusFilter, payBillFilter});
        Map<String, List<DynamicObject>> draftbillnoAndDyMap = payableBillsColl.stream().collect(Collectors.groupingBy(e -> e.getString("draftbillno")));
        Set draweraccountIdSet = payableBillsColl.stream().map(e -> e.getLong("draweraccount")).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(draweraccountIdSet) && draweraccountIdSet.size() > 0) {
            DynamicObjectCollection drawerAccountColl = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,bank,bank.bebank,bank.bebank.number", (QFilter[])new QFilter[]{new QFilter("id", "in", draweraccountIdSet)});
            for (DynamicObject drawerAccount : drawerAccountColl) {
                long id = drawerAccount.getLong("id");
                String bebankNumber = drawerAccount.getString("bank.bebank.number");
                if (!EmptyUtil.isNoEmpty((String)bebankNumber)) continue;
                this.accountAndBankMap.put(id, bebankNumber);
            }
        }
        return draftbillnoAndDyMap;
    }

    private long getBankProperty(DynamicObject drawerAccount, String propName) {
        DynamicObject bank;
        long prop = 0L;
        if (Objects.isNull(drawerAccount)) {
            return prop;
        }
        long bankId = drawerAccount.getLong("bank");
        if (EmptyUtil.isNoEmpty((Long)bankId) && null != (bank = this.bank_idAndDyMap.get(bankId))) {
            prop = bank.getLong(propName);
        }
        return prop;
    }

    private boolean isExist(DynamicObject drawerAccount, JSONObject data) {
        String beBankNumber = drawerAccount.getString("bank.bebank.number");
        String drawerBankno = data.getString("drawerbankno");
        String subBillRange = data.getString("subbillrange");
        boolean isSplit = data.getBoolean("issplit");
        String draftBillNo = data.getString("draftbillno");
        String draftBillTypeNumber = data.getJSONObject("draftbilltype").getString("number");
        List<DynamicObject> draftBillTypes = this.billtypeNumberMap.get(draftBillTypeNumber);
        String settlementType = draftBillTypes.get(0).getString("settlementtype");
        boolean isSupportSplit = settlementType.equals(SettleMentTypeEnum.BUSINESS.getValue()) || settlementType.equals(SettleMentTypeEnum.BANK.getValue());
        String number = "";
        if (EmptyUtil.isEmpty((String)beBankNumber)) {
            if (Objects.isNull(drawerBankno)) {
                return true;
            }
            number = drawerBankno;
        } else {
            number = beBankNumber;
        }
        String substring = number.substring(0, Math.min(3, number.length()));
        List<Object> payableBills = new ArrayList(16);
        List<DynamicObject> payableBillsDb = this.draftbillnoAndDyMap.get(draftBillNo);
        if (EmptyUtil.isNoEmpty(payableBillsDb) && payableBillsDb.size() > 0) {
            payableBills = settlementType.equals(SettleMentTypeEnum.BUSINESS.getValue()) || settlementType.equals(SettleMentTypeEnum.BANK.getValue()) ? payableBillsDb.stream().filter(e -> this.draftTypeSet.contains(e.getString("draftbilltype.settlementtype"))).collect(Collectors.toList()) : payableBillsDb.stream().filter(e -> settlementType.equals(e.getString("draftbilltype.settlementtype"))).collect(Collectors.toList());
        }
        if (!isSupportSplit && EmptyUtil.isNoEmpty(payableBills) && payableBills.size() > 0) {
            return true;
        }
        if (isSupportSplit && !isSplit && EmptyUtil.isNoEmpty(payableBills) && payableBills.size() > 0) {
            return true;
        }
        boolean isExistNoSplit = false;
        for (DynamicObject dynamicObject : payableBills) {
            boolean isSplitDb = dynamicObject.getBoolean("issplit");
            if (isSplitDb) continue;
            isExistNoSplit = true;
            break;
        }
        if (isSupportSplit && isSplit && isExistNoSplit) {
            return true;
        }
        if (isSupportSplit && isSplit && StringUtils.isNotEmpty((CharSequence)subBillRange)) {
            Long startFlag = Long.valueOf(subBillRange.split("-")[0]);
            Long endFlag = Long.valueOf(subBillRange.split("-")[1]);
            for (DynamicObject dynamicObject : payableBills) {
                long drawerAccountId = dynamicObject.getLong("draweraccount");
                String drawerAccountFromDB = this.accountAndBankMap.get(drawerAccountId);
                String subBillRangeFrombase = dynamicObject.getString("subbillrange");
                if (!EmptyUtil.isNoEmpty((String)drawerAccountFromDB)) continue;
                boolean isSameSubBillRange = this.isRepeatDraftBillNo(subBillRangeFrombase, startFlag, endFlag);
                if (!drawerAccountFromDB.startsWith(substring) || !isSameSubBillRange) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRepeatDraftBillNo(String subBillRangeDb, Long startFlag, Long endFlag) {
        if (StringUtils.isEmpty((CharSequence)subBillRangeDb) || !subBillRangeDb.contains("-")) {
            return false;
        }
        Long startFlagDb = Long.valueOf(subBillRangeDb.split("-")[0]);
        Long endFlagDb = Long.valueOf(subBillRangeDb.split("-")[1]);
        boolean isRepeat = startFlag >= startFlagDb && startFlag <= endFlagDb || endFlag >= startFlagDb && endFlag <= endFlagDb || startFlag <= startFlagDb && endFlag >= endFlagDb;
        return isRepeat;
    }

    private void backgroundInfoClear(JSONObject data) {
        Boolean backgroundInfo = data.getBoolean("backgroundinfo");
        if (EmptyUtil.isEmpty((Object)backgroundInfo) || !EmptyUtil.isEmpty((Object)backgroundInfo) && !backgroundInfo.booleanValue()) {
            data.put("backgroundinfodate", null);
            data.put("backgroundinfotransferee", null);
            data.put("backgroundinfocontent", null);
        }
    }

    private void setAcceptDate(JSONObject data) {
        JSONObject draftBillTypeNumberJSON;
        String draftBillTypeNumber;
        List<DynamicObject> draftBillTypes;
        String acceptDate = data.getString("acceptdate");
        if (EmptyUtil.isEmpty((String)acceptDate) && !EmptyUtil.isEmpty(draftBillTypes = this.billtypeNumberMap.get(draftBillTypeNumber = (draftBillTypeNumberJSON = data.getJSONObject("draftbilltype")).getString("number")))) {
            boolean flag;
            String settlementType = draftBillTypes.get(0).getString("settlementtype");
            boolean bl = flag = settlementType.equals(SettleMentTypeEnum.BUSINESS.getValue()) || settlementType.equals(SettleMentTypeEnum.BANK.getValue());
            if (flag) {
                data.put("acceptdate", (Object)data.getString("issuedate"));
            }
        }
    }

    private void setDraftExpireDate(JSONObject data, Map<Long, Map<Date, Date>> draftTypeIdAndValidDataMap) {
        JSONObject draftBillTypeNumberJSON;
        String draftBillTypeNumber;
        List<DynamicObject> draftBillTypes;
        String draftExpireDate = data.getString("draftbillexpiredate");
        String issueDateStr = data.getString("issuedate");
        if (EmptyUtil.isEmpty((String)draftExpireDate) && EmptyUtil.isNoEmpty((String)issueDateStr) && !EmptyUtil.isEmpty(draftBillTypes = this.billtypeNumberMap.get(draftBillTypeNumber = (draftBillTypeNumberJSON = data.getJSONObject("draftbilltype")).getString("number")))) {
            DynamicObject drafttypeDy = draftBillTypes.get(0);
            Map<Date, Date> map = draftTypeIdAndValidDataMap.get(drafttypeDy.getLong("id"));
            Date issueDate = DateUtils.stringToDate((String)issueDateStr, (String)"yyyy-MM-dd");
            if (EmptyUtil.isEmpty(map) || map.size() == 0) {
                Date draftExpireDateNew = DraftHelper.dealDateByImport((DynamicObject)drafttypeDy, (Date)issueDate);
                if (null != draftExpireDateNew) {
                    data.put("draftbillexpiredate", (Object)draftExpireDateNew);
                    HashMap<Date, Date> dateMap = new HashMap<Date, Date>(16);
                    dateMap.put(issueDate, draftExpireDateNew);
                    draftTypeIdAndValidDataMap.put(drafttypeDy.getLong("id"), dateMap);
                }
            } else {
                Date draftExpireDateNew = map.get(issueDate);
                if (null != draftExpireDateNew) {
                    data.put("draftbillexpiredate", (Object)draftExpireDateNew);
                }
            }
        }
    }
}

