/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.opplugin.receivablebill;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.constant.CdmBizConstant;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.helper.CasHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class Receivable2RecConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log LOG = LogFactory.getLog(Receivable2RecConvertPlugin.class);

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        Map opVarMap = this.getOption().getVariables();
        String fromGenRecBill = opVarMap.getOrDefault("fromGenRecBill", "false");
        boolean fromGenRecBillFlag = EmptyUtil.isNoEmpty((Object)opVarMap) && "true".equals(fromGenRecBill);
        for (ExtendedDataEntity billDataEntity : billDataEntities) {
            DynamicObject recBill = billDataEntity.getDataEntity();
            List srcData = (List)billDataEntity.getValue("ConvertSource");
            Object id = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcData.get(0));
            DynamicObject receivableBill = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cdm_receivablebill");
            Object eSettleType = opVarMap.get("e_settletype");
            if (fromGenRecBillFlag && EmptyUtil.isNoEmpty(eSettleType) && Long.parseLong(eSettleType.toString()) > 0L) {
                DynamicObject[] eSettleTypeDb = BusinessDataServiceHelper.load((Object[])new Object[]{Long.parseLong(eSettleType.toString())}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_settlementtype"));
                recBill.set("settletype", (Object)(eSettleTypeDb.length == 0 ? Integer.valueOf(0) : eSettleTypeDb[0]));
            } else {
                DynamicObject draftBillType = receivableBill.getDynamicObject("draftbilltype");
                draftBillType = BusinessDataServiceHelper.loadSingle((Object)draftBillType.getPkValue(), (String)"cdm_billtype", (String)"settlementtype, settlementtypebd");
                DynamicObject settletypeDyn = recBill.getDynamicObject("settletype");
                if (Objects.nonNull(draftBillType) && EmptyUtil.isEmpty((DynamicObject)settletypeDyn)) {
                    DynamicObjectCollection settlementTypeMulti = draftBillType.getDynamicObjectCollection("settlementtypebd");
                    if (settlementTypeMulti.isEmpty()) {
                        String settlementType = draftBillType.getString("settlementtype");
                        if (Objects.equals(settlementType, SettleMentTypeEnum.BANK.getValue())) {
                            recBill.set("settletype", (Object)BusinessDataServiceHelper.loadSingle((Object)CdmBizConstant.SETTLEMENTTYPE_BANK, (String)"bd_settlementtype"));
                        } else if (Objects.equals(settlementType, SettleMentTypeEnum.BUSINESS.getValue())) {
                            recBill.set("settletype", (Object)BusinessDataServiceHelper.loadSingle((Object)CdmBizConstant.SETTLEMENTTYPE_BUSINESS, (String)"bd_settlementtype"));
                        }
                    } else {
                        recBill.set("settletype", ((DynamicObject)settlementTypeMulti.get(0)).get("fbasedataid"));
                    }
                }
            }
            DynamicObjectCollection draftBillMulti = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)recBill, (String)"draftbill", (DynamicObject[])new DynamicObject[]{receivableBill});
            recBill.set("draftbill", (Object)draftBillMulti);
            DynamicObject deliver = receivableBill.getDynamicObject("deliver");
            recBill.set("payer", deliver == null ? null : deliver.getPkValue());
            recBill.set("itempayer", (Object)(deliver == null ? Integer.valueOf(0) : deliver));
            recBill.set("payername", deliver == null ? "" : deliver.get("name"));
            recBill.set("billstatus", (Object)"D");
            String deliverType = receivableBill.getString("delivertype");
            LOG.info("is start to set data:" + deliverType);
            if ("other".equals(deliverType)) {
                recBill.set("payeracctbanknum", (Object)receivableBill.getString("deliveraccounttext"));
            } else {
                recBill.set("payeracctbanknum", (Object)receivableBill.getString("deliveraccountbase"));
                DynamicObject dynamicObject = receivableBill.getDynamicObject("deliveropenbank");
                if (EmptyUtil.isNoEmpty((DynamicObject)dynamicObject)) {
                    String openBank = dynamicObject.getString("name");
                    LOG.info("openBank is:" + openBank);
                    if (EmptyUtil.isNoEmpty((String)openBank)) {
                        DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((String)"bd_bebank", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)openBank)});
                        if (EmptyUtil.isNoEmpty((DynamicObject)bdBebankDO)) {
                            recBill.set("f7_payerbank", bdBebankDO.getPkValue());
                        }
                        recBill.set("payerbankname", (Object)openBank);
                    }
                }
            }
            if (fromGenRecBillFlag) {
                boolean isAlloc;
                String txt_description;
                Object eExplain;
                Object eFundFlowItem;
                Object eReceivingType = opVarMap.get("e_receivingtype");
                if (!ObjectUtils.isEmpty(eReceivingType)) {
                    DynamicObject[] eReceivingTypeDb = BusinessDataServiceHelper.load((Object[])new Object[]{Long.parseLong(eReceivingType.toString())}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_receivingbilltype"));
                    recBill.set("receivingtype", (Object)(eReceivingTypeDb.length == 0 ? Integer.valueOf(0) : eReceivingTypeDb[0]));
                }
                Object ePayerType = opVarMap.get("e_payertype");
                Object ePayerBaseType = opVarMap.get("e_payerbasetype");
                Object ePayer = opVarMap.get("e_payer");
                Object ePayerId = opVarMap.get("e_payerid");
                recBill.set("payertype", ObjectUtils.isEmpty(ePayerType) ? recBill.get("payertype") : ePayerType.toString());
                recBill.set("itempayertype", ObjectUtils.isEmpty(ePayerBaseType) ? recBill.get("itempayertype") : ePayerBaseType.toString());
                recBill.set("payername", ObjectUtils.isEmpty(ePayer) ? recBill.get("payername") : ePayer.toString());
                if (!(ObjectUtils.isEmpty(ePayerId) || Long.parseLong(ePayerId.toString()) <= 0L || ObjectUtils.isEmpty(ePayerType) || "other".equals(ePayerType))) {
                    DynamicObject[] ePayerIdDb = BusinessDataServiceHelper.load((Object[])new Object[]{Long.parseLong(ePayerId.toString())}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)(ePayerType == null ? "" : ePayerType.toString())));
                    recBill.set("itempayer", (Object)(ePayerIdDb.length == 0 ? Integer.valueOf(0) : ePayerIdDb[0]));
                    recBill.set("payer", (Object)(ePayerIdDb.length == 0 ? 0L : ePayerIdDb[0].getLong("id")));
                    recBill.set("payername", ePayerIdDb.length == 0 ? receivableBill.getString("delivername") : ePayerIdDb[0].get("name"));
                }
                if (!ObjectUtils.isEmpty(eFundFlowItem = opVarMap.get("e_fundflowitem"))) {
                    DynamicObject[] eFundFlowItemDb = BusinessDataServiceHelper.load((Object[])new Object[]{Long.parseLong(eFundFlowItem.toString())}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_fundflowitem"));
                    DynamicObjectCollection dynamicObjects = recBill.getDynamicObjectCollection("entry");
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        dynamicObject.set("e_fundflowitem", (Object)(eFundFlowItemDb.length == 0 ? Integer.valueOf(0) : eFundFlowItemDb[0]));
                    }
                }
                if (EmptyUtil.isNoEmpty(eExplain = opVarMap.get("e_explain"))) {
                    recBill.set("txt_description", (Object)eExplain.toString());
                }
                if (EmptyUtil.isNoEmpty((String)(txt_description = recBill.getString("txt_description"))) && (isAlloc = ResManager.loadKDString((String)"\u7968\u636e\u6c60\u5185\u80cc\u4e66", (String)"Receivable2RecConvertPlugin_1", (String)"tmc-cdm-opplugin", (Object[])new Object[0]).equals(txt_description))) {
                    recBill.set("txt_description", (Object)ResManager.loadKDString((String)"\u7968\u636e\u751f\u5355", (String)"Receivable2RecConvertPlugin_2", (String)"tmc-cdm-opplugin", (Object[])new Object[0]));
                }
                recBill.set("billstatus", (Object)"A");
                recBill.set("payertype", ObjectUtils.isEmpty(ePayerType) ? receivableBill.getString("payeetype") : recBill.get("payertype"));
                recBill.set("payeracctbanknum", (Object)receivableBill.getString("deliveraccountbase"));
                DynamicObject receivingType = recBill.getDynamicObject("receivingtype");
                if (!ObjectUtils.isEmpty((Object)receivingType)) {
                    boolean isPartReceivable = receivingType.getBoolean("ispartreceivable");
                    if (isPartReceivable) {
                        recBill.set("biztype", (Object)"SalesRec");
                    } else {
                        recBill.set("biztype", (Object)"OtherRec");
                    }
                }
            }
            DynamicObjectCollection draftInfoEntries = recBill.getDynamicObjectCollection("cas_draftinfo");
            CasHelper.addCasRecDraftInfoEntry((DynamicObjectCollection)draftInfoEntries, (DynamicObject[])new DynamicObject[]{receivableBill});
            LOG.info("set data end");
        }
    }
}

