/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.opplugin.receivablebill;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.helper.BaseDataHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReceivableBillImportOp
extends BatchImportPlugin {
    private static Log LOGGERTOOL = LogFactory.getLog(ReceivableBillImportOp.class);
    private static final String NEW = "new";
    private static final String OVERRIDE = "override";
    private static final String OVERRIDE_NEW = "overridenew";
    private static final int MAX_IMPORT_SIZE = 10000000;
    private static final String IMPORT_TYPE = "importtype";
    private static final String KEY_FIELDS = "KeyFields";
    private Long companyId;

    protected int getBatchImportSize() {
        return 10000000;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        LOGGERTOOL.info("super.beforeSave >>> start...");
        super.beforeSave(billdatas, logger);
        LOGGERTOOL.info("super.beforeSave >>> end...");
        Map options = this.ctx.getOption();
        this.dealData(billdatas, logger, options);
        LOGGERTOOL.info("beforeSave >>> end...");
    }

    private void dealData(List<ImportBillData> billdatas, ImportLogger logger, Map<String, Object> options) {
        Object importType = options.get(IMPORT_TYPE);
        Object keyFields = options.get(KEY_FIELDS);
        LOGGERTOOL.info("dealData >>> importType is:" + importType + ",billdatas.size is:" + billdatas.size());
        if (EmptyUtil.isNoEmpty(billdatas)) {
            if (NEW.equals(String.valueOf(importType))) {
                this.handleAddData(billdatas, logger);
                LOGGERTOOL.info("handleAddData >>> end...");
            } else if (OVERRIDE.equals(String.valueOf(importType))) {
                this.handleUpdateData(billdatas, logger, keyFields);
                LOGGERTOOL.info("handleUpdateData >>> end...");
            } else {
                this.handleUpdateAddData(billdatas, logger, keyFields);
                LOGGERTOOL.info("handleUpdateAddData >>> end...");
            }
        }
    }

    private List<ImportBillData> handleAddData(List<ImportBillData> billdatas, ImportLogger logger) {
        LOGGERTOOL.info("handleAddData >>> checkParams start...");
        List<ImportBillData> checkedBillDatas = this.checkParams(billdatas, logger);
        ArrayList<ImportBillData> billBatchQueryList = new ArrayList<ImportBillData>(checkedBillDatas.size());
        billBatchQueryList.addAll(checkedBillDatas);
        Map<String, DynamicObject> numberBillTypeMap = this.queryBatchBillTypeByNumber(billBatchQueryList);
        LOGGERTOOL.info("handleAddData >>> checkImportRepeatDraftBillNo start...");
        checkedBillDatas = this.checkImportRepeatDraftBillNo(checkedBillDatas, logger, numberBillTypeMap);
        LOGGERTOOL.info("handleAddData >>> checkDBRepeatDraftBillNo start...");
        this.checkDBRepeatDraftBillNo(checkedBillDatas, logger);
        return checkedBillDatas;
    }

    private List<ImportBillData> handleUpdateData(List<ImportBillData> billdatas, ImportLogger logger, Object keyFields) {
        LOGGERTOOL.info("handleUpdateData >>> checkUpdateParams start...");
        List<ImportBillData> checkedBillDatas = this.checkUpdateParams(billdatas, logger);
        LOGGERTOOL.info("handleUpdateData >>> getNeedCheckRepeatData start...");
        List<ImportBillData> needCheckRepeatList = this.getNeedCheckRepeatData(checkedBillDatas, logger, keyFields);
        LOGGERTOOL.info("handleUpdateData >>> checkDBRepeatDraftBillNo start...");
        List<ImportBillData> repeatDataList = this.checkDBRepeatDraftBillNo(needCheckRepeatList, logger);
        LOGGERTOOL.info("handleUpdateData >>> removeErrorData start...");
        this.removeErrorData(checkedBillDatas, repeatDataList);
        return checkedBillDatas;
    }

    private void handleUpdateAddData(List<ImportBillData> billdatas, ImportLogger logger, Object keyFields) {
        ArrayList<ImportBillData> needUpdateDataList = new ArrayList<ImportBillData>(billdatas.size());
        ArrayList<ImportBillData> needAddDataList = new ArrayList<ImportBillData>(billdatas.size());
        ArrayList<ImportBillData> errorDataList = new ArrayList<ImportBillData>(billdatas.size());
        for (ImportBillData rowData : billdatas) {
            JSONObject data = rowData.getData();
            Object[] receivablebills = this.queryBillsByKeyFields(data, keyFields);
            if (!EmptyUtil.isEmpty((Object[])receivablebills)) {
                needUpdateDataList.add(rowData);
                continue;
            }
            needAddDataList.add(rowData);
        }
        List<ImportBillData> updatedResultList = this.handleUpdateData(needUpdateDataList, logger, keyFields);
        List<ImportBillData> addedResultList = this.handleAddData(needAddDataList, logger);
        updatedResultList.addAll(addedResultList);
        errorDataList.addAll(billdatas);
        errorDataList.removeAll(updatedResultList);
        this.removeErrorData(billdatas, errorDataList);
    }

    private DynamicObject[] queryBillsByKeyFields(JSONObject data, Object keyFields) {
        List<Object> uniqueKeyFields = new ArrayList(8);
        if (!EmptyUtil.isEmpty((Object)keyFields)) {
            String fieldStrs = String.valueOf(keyFields);
            String[] fields = fieldStrs.split(",");
            uniqueKeyFields = Arrays.asList(fields).stream().filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(uniqueKeyFields.size());
        for (String field : uniqueKeyFields) {
            Map fieldMap;
            Object fieldObject = data.get((Object)field);
            if (fieldObject instanceof JSONObject) {
                fieldMap = (Map)fieldObject;
                filters.add(new QFilter(field + ".number", "=", fieldMap.get("number")));
                continue;
            }
            if (fieldObject instanceof String) {
                if (StringUtils.equals((CharSequence)"amount", (CharSequence)field)) {
                    BigDecimal bigDecimal = new BigDecimal(String.valueOf(fieldObject));
                    filters.add(new QFilter(field, "=", (Object)bigDecimal));
                    continue;
                }
                if (StringUtils.contains((CharSequence)field, (CharSequence)"date")) {
                    Date fieldDate = DateUtils.stringToDate((String)String.valueOf(fieldObject), (String)"yyyy-MM-dd");
                    filters.add(new QFilter(field, "=", (Object)fieldDate));
                    continue;
                }
                String fieldStr = String.valueOf(fieldObject);
                filters.add(new QFilter(field, "=", (Object)fieldStr));
                continue;
            }
            if (fieldObject instanceof Map) {
                if (!StringUtils.equals((CharSequence)"description", (CharSequence)field)) continue;
                fieldMap = (Map)fieldObject;
                filters.add(new QFilter(field, "=", fieldMap.get("zh_CN")));
                continue;
            }
            if (fieldObject instanceof Integer || fieldObject instanceof Double || fieldObject instanceof BigDecimal) {
                filters.add(new QFilter(field, "=", fieldObject));
                continue;
            }
            if (!(fieldObject instanceof Boolean)) continue;
            Boolean fieldFlag = (Boolean)fieldObject;
            if (fieldFlag.booleanValue()) {
                filters.add(new QFilter(field, "=", (Object)1));
                continue;
            }
            filters.add(new QFilter(field, "=", (Object)0));
        }
        return BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,draftbillno", (QFilter[])filters.toArray(new QFilter[0]));
    }

    private void removeErrorData(List<ImportBillData> checkedBillDatas, List<ImportBillData> errorDataList) {
        for (ImportBillData rowData : errorDataList) {
            checkedBillDatas.remove(rowData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImportBillData> checkParams(List<ImportBillData> billdatas, ImportLogger logger) {
        HashMap<Long, Map<Date, Date>> draftTypeIdAndValidDataMap = new HashMap<Long, Map<Date, Date>>(16);
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            String errorMessage = null;
            ImportBillData rowData = it.next();
            JSONObject data = rowData.getData();
            try {
                this.setDrawerbank(data);
                this.checkSplitInfoAndAmount(data);
                this.checkDraftBillTypeAndSettlementType(data, draftTypeIdAndValidDataMap);
                this.setValueBySysParam(data);
                this.checkDeliver(data);
                this.checkAccepter(data);
                this.checkAcceptPromiser(data);
                this.checkIssuePromiser(data);
                this.checkDraftbillno(data);
                this.setDefaultValue(data);
                this.setAcceptDate(data);
            }
            catch (Exception exc) {
                errorMessage = exc.getMessage();
            }
            finally {
                if (!StringUtils.isNotEmpty((CharSequence)errorMessage)) continue;
                logger.log(Integer.valueOf(rowData.getStartIndex()), errorMessage).fail();
                it.remove();
            }
        }
        return billdatas;
    }

    private Map<String, DynamicObject> queryBatchBillTypeByNumber(List<ImportBillData> billBatchQueryList) {
        HashSet<String> numberSet = new HashSet<String>(billBatchQueryList.size());
        for (ImportBillData rowData : billBatchQueryList) {
            String draftBillTypeNumber;
            JSONObject data = rowData.getData();
            JSONObject draftBillTypeNumberJSON = data.getJSONObject("draftbilltype");
            if (null == draftBillTypeNumberJSON || !EmptyUtil.isNotEmpty((CharSequence)(draftBillTypeNumber = draftBillTypeNumberJSON.getString("number")))) continue;
            numberSet.add(draftBillTypeNumber);
        }
        Map<String, Object> numberBillTypeMap = new HashMap<String, DynamicObject>();
        if (!EmptyUtil.isEmpty(numberSet)) {
            QFilter draftBillTypeNumberFilter = new QFilter("number", "in", numberSet);
            DynamicObject[] dynamicObjects = TmcDataServiceHelper.load((String)"cdm_billtype", (String)"id,settlementtype", (QFilter[])new QFilter[]{draftBillTypeNumberFilter});
            numberBillTypeMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(v -> v.getString("number"), o -> o, (o1, o2) -> o1, HashMap::new));
        }
        return numberBillTypeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImportBillData> checkUpdateParams(List<ImportBillData> billdatas, ImportLogger logger) {
        HashMap<Long, Map<Date, Date>> draftTypeIdAndValidDataMap = new HashMap<Long, Map<Date, Date>>(16);
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            String errorMessage = null;
            ImportBillData rowData = it.next();
            JSONObject data = rowData.getData();
            try {
                this.setDrawerbank(data);
                if (EmptyUtil.isNotEmpty((CharSequence)data.getString("amount"))) {
                    this.checkSplitInfoAndAmount(data);
                }
                if (!EmptyUtil.isEmpty((Object)data.getJSONObject("draftbilltype"))) {
                    this.checkDraftBillTypeAndSettlementType(data, draftTypeIdAndValidDataMap);
                }
                this.setValueBySysParam(data);
                this.checkDeliver(data);
                this.checkAccepter(data);
                this.checkAcceptPromiser(data);
                this.checkIssuePromiser(data);
                this.setAcceptDate(data);
            }
            catch (Exception exc) {
                errorMessage = exc.getMessage();
            }
            finally {
                if (!StringUtils.isNotEmpty((CharSequence)errorMessage)) continue;
                logger.log(Integer.valueOf(rowData.getStartIndex()), errorMessage).fail();
                it.remove();
            }
        }
        return billdatas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImportBillData> getNeedCheckRepeatData(List<ImportBillData> billdatas, ImportLogger logger, Object keyFields) {
        Iterator<ImportBillData> it = billdatas.iterator();
        ArrayList<ImportBillData> needCheckRepeatList = new ArrayList<ImportBillData>(billdatas.size());
        while (it.hasNext()) {
            String errorMessage = null;
            ImportBillData rowData = it.next();
            JSONObject data = rowData.getData();
            try {
                boolean isUpdateDraftBillNoFlag = false;
                Object[] receivablebills = this.queryBillsByKeyFields(data, keyFields);
                if (!EmptyUtil.isEmpty((Object[])receivablebills)) {
                    String draftbillnoUpdate = data.getString("draftbillno");
                    String draftbillnoDB = receivablebills[0].getString("draftbillno");
                    if (EmptyUtil.isNotEmpty((CharSequence)draftbillnoUpdate)) {
                        boolean bl = isUpdateDraftBillNoFlag = !StringUtils.equals((CharSequence)draftbillnoUpdate, (CharSequence)draftbillnoDB);
                    }
                }
                if (!isUpdateDraftBillNoFlag) continue;
                needCheckRepeatList.add(rowData);
            }
            catch (Exception exc) {
                errorMessage = exc.getMessage();
            }
            finally {
                if (!StringUtils.isNotEmpty((CharSequence)errorMessage)) continue;
                logger.log(Integer.valueOf(rowData.getStartIndex()), errorMessage).fail();
                it.remove();
            }
        }
        return needCheckRepeatList;
    }

    private void checkSplitInfoAndAmount(JSONObject data) {
        if (EmptyUtil.isEmpty((String)data.getString("amount"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u4e2d\u5fc5\u987b\u914d\u7f6e\u7968\u9762\u91d1\u989d(\u5b50\u7968\u5305\u91d1\u989d)\u8fd9\u4e2a\u5b57\u6bb5\u4e14\u8be5\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReceivableBillImportOp_0", (String)"tmc-cdm-opplugin", (Object[])new Object[0]));
        }
        Boolean issplit = data.getBoolean("issplit");
        BigDecimal supperBillAmount = data.getBigDecimal("supperbillamount");
        BigDecimal amount = data.getBigDecimal("amount");
        String subBillRange = data.getString("subbillrange");
        String subbillquantity = data.getString("subbillquantity");
        String subbillstartflag = data.getString("subbillstartflag");
        String subbillendflag = data.getString("subbillendflag");
        if (issplit == null) {
            issplit = false;
            data.put("issplit", (Object)false);
        }
        if (issplit.booleanValue() && (EmptyUtil.isEmpty((String)subbillquantity) || EmptyUtil.isEmpty((String)subbillstartflag) || EmptyUtil.isEmpty((String)subbillendflag))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u80fd\u5426\u62c6\u5206\u4e3a\u662f\u65f6\uff0c\u5bfc\u5165\u6587\u4ef6\u4e2d\u5b50\u7968\u5305\u6570\u91cf\u3001\u5b50\u7968\u5305\u5f00\u59cb\u6807\u8bc6\u3001\u5b50\u7968\u5305\u7ed3\u675f\u6807\u8bc6\u5fc5\u987b\u914d\u7f6e\u4e14\u5fc5\u586b\u3002", (String)"ReceivableBillImportOp_3", (String)"tmc-cdm-opplugin", (Object[])new Object[0]));
        }
        if (issplit.booleanValue()) {
            long quantity;
            data.put("subbillrange", (Object)(subbillstartflag + "-" + subbillendflag));
            if (data.getBigDecimal("subbillquantity").multiply(new BigDecimal("0.01").setScale(2, 4)).compareTo(amount) != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u80fd\u5426\u62c6\u5206\u4e3a\u662f\u65f6\uff0c\u7968\u9762\u91d1\u989d(\u5b50\u7968\u5305\u91d1\u989d)\u548c\u5b50\u7968\u5305\u6570\u91cf\u4e24\u8005\u4e4b\u95f4\u4e0d\u6ee1\u8db3\u8ba1\u7b97\u5173\u7cfb\u3002", (String)"ReceivableBillImportOp_1", (String)"tmc-cdm-opplugin", (Object[])new Object[0]));
            }
            long calQuantity = data.getLong("subbillendflag") - data.getLong("subbillstartflag") + 1L;
            if (calQuantity != (quantity = data.getLong("subbillquantity").longValue())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u80fd\u5426\u62c6\u5206\u4e3a\u662f\u65f6\uff0c\u5b50\u7968\u5305\u6570\u91cf\u548c\u5b50\u7968\u5305\u5f00\u59cb\u6807\u8bc6\u3001\u5b50\u7968\u5305\u7ed3\u675f\u6807\u8bc6\u4e4b\u95f4\u4e0d\u6ee1\u8db3\u8ba1\u7b97\u5173\u7cfb\u3002", (String)"ReceivableBillImportOp_2", (String)"tmc-cdm-opplugin", (Object[])new Object[0]));
            }
        }
        if (Boolean.FALSE.equals(issplit) || EmptyUtil.isEmpty((String)data.getString("supperbillamount"))) {
            data.put("supperbillamount", (Object)data.getBigDecimal("amount"));
        } else if (issplit.booleanValue() && amount.compareTo(supperBillAmount) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u80fd\u5426\u62c6\u5206\u4e3a\u662f\u65f6\uff0c\u7968\u9762\u91d1\u989d(\u5b50\u7968\u5305\u91d1\u989d)\u4e0d\u80fd\u5927\u4e8e\u6bcd\u7968\u91d1\u989d\u3002", (String)"ReceivableBillImportOp_4", (String)"tmc-cdm-opplugin", (Object[])new Object[0]));
        }
        if (!issplit.booleanValue()) {
            data.put("standardbillamount", (Object)0.01);
            data.put("subbillquantity", (Object)0);
            data.put("subbillrange", (Object)0);
            data.put("subbillstartflag", (Object)0);
            data.put("subbillendflag", (Object)0);
            data.put("billidentitycode", (Object)"");
        } else {
            String subDraftBillRange = data.getString("subbillrange");
            data.put("originalsubbillrang", (Object)subDraftBillRange);
            data.put("originalsubbillamount", (Object)amount);
            data.put("availableamount", (Object)amount);
            String draftBillNo = data.getString("draftbillno");
            data.put("billidentitycode", (Object)(StringUtils.isNotEmpty((CharSequence)draftBillNo) ? draftBillNo + "-" + subDraftBillRange : ""));
        }
    }

    private void checkDraftbillno(JSONObject data) {
        String draftBillNo = data.getString("draftbillno");
        if (StringUtils.isEmpty((CharSequence)draftBillNo)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CdmBizResource_120", (String)"tmc-cdm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801", (String)"CdmBizResource_132", (String)"tmc-cdm-common", (Object[])new Object[0])));
        }
    }

    private void setDefaultValue(JSONObject data) {
        String poolLockStatus = data.getString("poollockstatus");
        if (EmptyUtil.isEmpty((String)poolLockStatus)) {
            data.put("poollockstatus", (Object)"0");
        }
    }

    private void setValueBySysParam(JSONObject data) {
        this.setReceivernameByCompany(data);
        this.setDrawernameByDeliver(data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkDraftBillTypeAndSettlementType(JSONObject data, Map<Long, Map<Date, Date>> draftTypeIdAndValidDataMap) {
        JSONObject draftBillTypeNumberJSON = data.getJSONObject("draftbilltype");
        if (draftBillTypeNumberJSON == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%s\u201d\u4e0d\u80fd\u5168\u90fd\u4e3a\u7a7a\u3002", (String)"CdmBizResource_170", (String)"tmc-cdm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b.\u7f16\u7801\u548c\u7968\u636e\u7c7b\u578b.\u540d\u79f0", (String)"CdmBizResource_130", (String)"tmc-cdm-common", (Object[])new Object[0])));
        }
        String draftBillTypeNumber = draftBillTypeNumberJSON.getString("number");
        String draftBillTypeName = draftBillTypeNumberJSON.getString("name");
        Object[] draftBillTypes = new DynamicObject[]{};
        if (EmptyUtil.isNotEmpty((CharSequence)draftBillTypeNumber)) {
            QFilter draftBillTypeNumberFilter = new QFilter("number", "=", (Object)draftBillTypeNumber);
            draftBillTypes = TmcDataServiceHelper.load((String)"cdm_billtype", (String)"id,settlementtype,defaulttime,defaultunit", (QFilter[])new QFilter[]{draftBillTypeNumberFilter});
            if (draftBillTypes.length < 1) {
                if (!EmptyUtil.isNotEmpty((CharSequence)draftBillTypeName)) throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u7684\u503c\u201c%2$s\u201d\u4e0d\u5408\u6cd5\u3002", (String)"CdmBizResource_121", (String)"tmc-cdm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b.\u7f16\u7801", (String)"CdmBizResource_172", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillTypeNumber));
                QFilter draftBillTypeNameFilter = new QFilter("name", "=", (Object)draftBillTypeName);
                draftBillTypes = TmcDataServiceHelper.load((String)"cdm_billtype", (String)"id,settlementtype,defaulttime,defaultunit", (QFilter[])new QFilter[]{draftBillTypeNameFilter});
                if (draftBillTypes.length < 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u7684\u503c\u201c%2$s\u201d\u548c\u5b57\u6bb5\u201c%3$s\u201d\u7684\u503c\u201c%4$s\u201d\u90fd\u4e0d\u5408\u6cd5\u3002", (String)"CdmBizResource_171", (String)"tmc-cdm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b.\u7f16\u7801", (String)"CdmBizResource_172", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillTypeNumber, ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b.\u540d\u79f0", (String)"CdmBizResource_173", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillTypeName));
                }
                if (draftBillTypes.length > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u3010%1$s\u3011\u7684\u503c\u3010%2$s\u3011\u4e0d\u5408\u6cd5\uff0c\u5339\u914d\u591a\u6761\u7ed3\u679c", (String)"CdmBizResource_174", (String)"tmc-cdm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b.\u540d\u79f0", (String)"CdmBizResource_173", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillTypeName));
                }
            }
        } else if (EmptyUtil.isNotEmpty((CharSequence)draftBillTypeName)) {
            QFilter draftBillTypeNameFilter = new QFilter("name", "=", (Object)draftBillTypeName);
            draftBillTypes = TmcDataServiceHelper.load((String)"cdm_billtype", (String)"id,settlementtype,defaulttime,defaultunit", (QFilter[])new QFilter[]{draftBillTypeNameFilter});
            if (draftBillTypes.length < 1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u7684\u503c\u201c%2$s\u201d\u4e0d\u5408\u6cd5\u3002", (String)"CdmBizResource_121", (String)"tmc-cdm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b.\u540d\u79f0", (String)"CdmBizResource_173", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillTypeName));
            }
            if (draftBillTypes.length > 1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u3010%1$s\u3011\u7684\u503c\u3010%2$s\u3011\u4e0d\u5408\u6cd5\uff0c\u5339\u914d\u591a\u6761\u7ed3\u679c", (String)"CdmBizResource_174", (String)"tmc-cdm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b.\u540d\u79f0", (String)"CdmBizResource_173", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillTypeName));
            }
        }
        if (EmptyUtil.isEmpty((Object[])draftBillTypes)) return;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)draftBillTypes[0].getString("name"));
        jsonObject.put("number", (Object)draftBillTypes[0].getString("number"));
        data.put("draftbilltype", (Object)jsonObject);
        String settlementType = draftBillTypes[0].getString("settlementtype");
        boolean isSupportSplit = settlementType.equals(SettleMentTypeEnum.BUSINESS.getValue()) || settlementType.equals(SettleMentTypeEnum.BANK.getValue());
        Boolean issplit = data.getBoolean("issplit");
        if (issplit.booleanValue() && !isSupportSplit) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b.\u7f16\u7801\u201c%s\u201d\u80fd\u5426\u62c6\u5206\u7684\u503c\u4e0d\u5408\u6cd5\uff0c\u53ea\u6709\u627f\u5151\u6c47\u7968\u624d\u652f\u6301\u7968\u636e\u62c6\u5206\u3002", (String)"CdmBizResource_133", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillTypeNumber));
        }
        this.setDraftExpireDate(data, draftTypeIdAndValidDataMap, (DynamicObject)draftBillTypes[0]);
    }

    private void setDraftExpireDate(JSONObject data, Map<Long, Map<Date, Date>> draftTypeIdAndValidDataMap, DynamicObject drafttypeDy) {
        String draftExpireDate = data.getString("draftbillexpiredate");
        String issueDateStr = data.getString("issuedate");
        if (EmptyUtil.isEmpty((String)draftExpireDate) && EmptyUtil.isNoEmpty((String)issueDateStr) && !EmptyUtil.isEmpty((DynamicObject)drafttypeDy)) {
            Map<Date, Date> map = draftTypeIdAndValidDataMap.get(drafttypeDy.getLong("id"));
            Date issueDate = DateUtils.stringToDate((String)issueDateStr, (String)"yyyy-MM-dd");
            if (EmptyUtil.isEmpty(map) || map.size() == 0) {
                Date draftExpireDateNew = DraftHelper.dealDateByImport((DynamicObject)drafttypeDy, (Date)issueDate);
                if (null != draftExpireDateNew) {
                    data.put("draftbillexpiredate", (Object)draftExpireDateNew);
                    HashMap<Date, Date> dateMap = new HashMap<Date, Date>(16);
                    dateMap.put(issueDate, draftExpireDateNew);
                    draftTypeIdAndValidDataMap.put(drafttypeDy.getLong("id"), dateMap);
                }
            } else {
                Date draftExpireDateNew = map.get(issueDate);
                if (null != draftExpireDateNew) {
                    data.put("draftbillexpiredate", (Object)draftExpireDateNew);
                }
            }
        }
    }

    private void setReceivernameByCompany(JSONObject data) {
        JSONObject companyJSON = data.getJSONObject("company");
        DynamicObject[] companies = new DynamicObject[]{};
        this.companyId = -1L;
        if (!EmptyUtil.isEmpty((Object)companyJSON)) {
            QFilter companyNameFilter;
            String companyNumber = companyJSON.getString("number");
            String companyName = companyJSON.getString("name");
            if (EmptyUtil.isNotEmpty((CharSequence)companyNumber)) {
                QFilter companyNumberFilter = new QFilter("number", "=", (Object)companyNumber);
                companies = TmcDataServiceHelper.load((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{companyNumberFilter});
                if (companies.length < 1 && EmptyUtil.isNotEmpty((CharSequence)companyName)) {
                    QFilter companyNameFilter2 = new QFilter("name", "=", (Object)companyName);
                    companies = TmcDataServiceHelper.load((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{companyNameFilter2});
                }
                if (companies.length > 0) {
                    boolean isSecondHandBill = DraftHelper.getCdmParameterBoolean((long)companies[0].getLong("id"), (String)"issecondhandbill");
                    if (!isSecondHandBill) {
                        data.put("receivername", (Object)companies[0].getString("name"));
                    }
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("name", (Object)companies[0].getString("name"));
                    jsonObject.put("number", (Object)companies[0].getString("number"));
                    data.put("company", (Object)jsonObject);
                    this.companyId = companies[0].getLong("id");
                }
            } else if (EmptyUtil.isNotEmpty((CharSequence)companyName) && (companies = TmcDataServiceHelper.load((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{companyNameFilter = new QFilter("name", "=", (Object)companyName)})).length > 0) {
                boolean isSecondHandBill = DraftHelper.getCdmParameterBoolean((long)companies[0].getLong("id"), (String)"issecondhandbill");
                if (!isSecondHandBill) {
                    data.put("receivername", (Object)companies[0].getString("name"));
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("name", (Object)companies[0].getString("name"));
                jsonObject.put("number", (Object)companies[0].getString("number"));
                data.put("company", (Object)jsonObject);
                this.companyId = companies[0].getLong("id");
            }
        }
    }

    private void setDrawernameByDeliver(JSONObject data) {
        String payeeType = data.getString("payeetype");
        JSONObject deliverJSON = data.getJSONObject("deliver");
        if (EmptyUtil.isNotEmpty((CharSequence)payeeType) && !EmptyUtil.isEmpty((Object)deliverJSON)) {
            String deliverNumber = deliverJSON.getString("number");
            String deliverName = deliverJSON.getString("name");
            if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bd_supplier")) {
                this.setDrawer(data, deliverNumber, deliverName, "bd_supplier");
            } else if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bos_org")) {
                this.setDrawer(data, deliverNumber, deliverName, "bos_org");
            } else if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bd_customer")) {
                this.setDrawer(data, deliverNumber, deliverName, "bd_customer");
            } else if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bos_user")) {
                this.setDrawer(data, deliverNumber, deliverName, "bos_user");
            }
        }
    }

    private void setDrawer(JSONObject data, String number, String name, String entityName) {
        QFilter nameFilter;
        QFilter companyNumberFilter;
        String companyNumber;
        JSONObject companyJSON = data.getJSONObject("company");
        DynamicObject[] companies = new DynamicObject[]{};
        boolean isSecondHandBill = false;
        if (!EmptyUtil.isEmpty((Object)companyJSON) && EmptyUtil.isNotEmpty((CharSequence)(companyNumber = companyJSON.getString("number"))) && (companies = TmcDataServiceHelper.load((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{companyNumberFilter = new QFilter("number", "=", (Object)companyNumber)})).length > 0) {
            isSecondHandBill = DraftHelper.getCdmParameterBoolean((long)companies[0].getLong("id"), (String)"issecondhandbill");
        }
        DynamicObject[] dynamicObjects = new DynamicObject[]{};
        if (EmptyUtil.isNotEmpty((CharSequence)number)) {
            QFilter numberFilter = new QFilter("number", "=", (Object)number);
            dynamicObjects = TmcDataServiceHelper.load((String)entityName, (String)"id,name,number", (QFilter[])new QFilter[]{numberFilter});
            if (dynamicObjects.length < 1 && EmptyUtil.isNotEmpty((CharSequence)name)) {
                QFilter nameFilter2 = new QFilter("name", "=", (Object)name);
                dynamicObjects = TmcDataServiceHelper.load((String)entityName, (String)"id,name,number", (QFilter[])new QFilter[]{nameFilter2});
            }
            if (dynamicObjects.length > 0 && !isSecondHandBill) {
                data.put("drawername", (Object)dynamicObjects[0].getString("name"));
            }
        } else if (EmptyUtil.isNotEmpty((CharSequence)name) && (dynamicObjects = TmcDataServiceHelper.load((String)entityName, (String)"id,name,number", (QFilter[])new QFilter[]{nameFilter = new QFilter("name", "=", (Object)name)})).length > 0 && !isSecondHandBill) {
            data.put("drawername", (Object)dynamicObjects[0].getString("name"));
        }
    }

    private void checkDeliver(JSONObject data) {
        String payeeType = data.getString("payeetype");
        JSONObject deliverJSON = data.getJSONObject("deliver");
        String deliveName = data.getString("delivername");
        if (EmptyUtil.isNotEmpty((CharSequence)payeeType)) {
            if (!EmptyUtil.isEmpty((Object)deliverJSON)) {
                String deliverNumber = deliverJSON.getString("number");
                String deliverName = deliverJSON.getString("name");
                if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bd_supplier")) {
                    this.setBaseDataAndText(data, deliverNumber, deliverName, "bd_supplier", "deliver", "delivername", "delivertype");
                } else if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bos_org")) {
                    this.setBaseDataAndText(data, deliverNumber, deliverName, "bos_org", "deliver", "delivername", "delivertype");
                } else if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bd_customer")) {
                    this.setBaseDataAndText(data, deliverNumber, deliverName, "bd_customer", "deliver", "delivername", "delivertype");
                } else if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bos_user")) {
                    this.setBaseDataAndText(data, deliverNumber, deliverName, "bos_user", "deliver", "delivername", "delivertype");
                }
            } else if (EmptyUtil.isNotEmpty((CharSequence)deliveName)) {
                if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bd_supplier")) {
                    this.setBaseDataByText(data, deliveName, "bd_supplier", "deliver", "delivertype");
                } else if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bos_org")) {
                    this.setBaseDataByText(data, deliveName, "bos_org", "deliver", "delivertype");
                } else if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bd_customer")) {
                    this.setBaseDataByText(data, deliveName, "bd_customer", "deliver", "delivertype");
                } else if (StringUtils.equals((CharSequence)payeeType, (CharSequence)"bos_user")) {
                    this.setBaseDataByText(data, deliveName, "bos_user", "deliver", "delivertype");
                }
            }
        }
    }

    private void setBaseDataAndText(JSONObject data, String number, String name, String entityName, String baseDataName, String sameNameText, String baseDataType) {
        QFilter nameFilter;
        DynamicObject[] dynamicObjects = new DynamicObject[]{};
        Long baseDataId = 0L;
        if (EmptyUtil.isNotEmpty((CharSequence)number)) {
            QFilter numberFilter = new QFilter("number", "=", (Object)number);
            dynamicObjects = TmcDataServiceHelper.load((String)entityName, (String)"id,name,number", (QFilter[])new QFilter[]{numberFilter});
            if (dynamicObjects.length < 1 && EmptyUtil.isNotEmpty((CharSequence)name)) {
                QFilter nameFilter2 = new QFilter("name", "=", (Object)name);
                dynamicObjects = TmcDataServiceHelper.load((String)entityName, (String)"id,name,number", (QFilter[])new QFilter[]{nameFilter2});
            }
            if (dynamicObjects.length > 0) {
                if (BaseDataHelper.isNeedCheckProperty((String)entityName, (String)baseDataName)) {
                    baseDataId = dynamicObjects[0].getLong("id");
                    BaseDataHelper.checkCustomerOrSupplyAuth((String)"ReceivableBill", (String)entityName, (Long)baseDataId, (Long)this.companyId);
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("name", (Object)dynamicObjects[0].getString("name"));
                jsonObject.put("number", (Object)dynamicObjects[0].getString("number"));
                data.put(baseDataName, (Object)jsonObject);
                data.put(sameNameText, (Object)dynamicObjects[0].getString("name"));
                data.put(baseDataType, (Object)entityName);
            }
        } else if (EmptyUtil.isNotEmpty((CharSequence)name) && (dynamicObjects = TmcDataServiceHelper.load((String)entityName, (String)"id,name,number", (QFilter[])new QFilter[]{nameFilter = new QFilter("name", "=", (Object)name)})).length > 0) {
            if (BaseDataHelper.isNeedCheckProperty((String)entityName, (String)baseDataName)) {
                baseDataId = dynamicObjects[0].getLong("id");
                BaseDataHelper.checkCustomerOrSupplyAuth((String)"ReceivableBill", (String)entityName, (Long)baseDataId, (Long)this.companyId);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", (Object)dynamicObjects[0].getString("name"));
            jsonObject.put("number", (Object)dynamicObjects[0].getString("number"));
            data.put(baseDataName, (Object)jsonObject);
            data.put(sameNameText, (Object)dynamicObjects[0].getString("name"));
            data.put(baseDataType, (Object)entityName);
        }
    }

    private void setBaseDataByText(JSONObject data, String name, String entityName, String baseDataName, String baseDataType) {
        DynamicObject[] dynamicObjects = new DynamicObject[]{};
        if (EmptyUtil.isNotEmpty((CharSequence)name)) {
            QFilter nameFilter = new QFilter("name", "=", (Object)name);
            dynamicObjects = TmcDataServiceHelper.load((String)entityName, (String)"id,name,number", (QFilter[])new QFilter[]{nameFilter});
            if (dynamicObjects.length > 0) {
                if (BaseDataHelper.isNeedCheckProperty((String)entityName, (String)baseDataName)) {
                    Long baseDataId = dynamicObjects[0].getLong("id");
                    BaseDataHelper.checkCustomerOrSupplyAuth((String)"ReceivableBill", (String)entityName, (Long)baseDataId, (Long)this.companyId);
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("name", (Object)dynamicObjects[0].getString("name"));
                jsonObject.put("number", (Object)dynamicObjects[0].getString("number"));
                data.put(baseDataName, (Object)jsonObject);
                data.put(baseDataType, (Object)entityName);
            }
        }
    }

    private void checkAccepter(JSONObject data) {
        QFilter accepternameFilter;
        JSONObject accepterbebankJSON = data.getJSONObject("accepterbebank");
        String accepterName = data.getString("acceptername");
        DynamicObject[] accepters = new DynamicObject[]{};
        if (!EmptyUtil.isEmpty((Object)accepterbebankJSON)) {
            QFilter accepterbebankNameFilter;
            String accepterbebankNumber = accepterbebankJSON.getString("number");
            String accepterbebankName = accepterbebankJSON.getString("name");
            if (EmptyUtil.isNotEmpty((CharSequence)accepterbebankNumber)) {
                QFilter accepterbebankNumberFilter = new QFilter("number", "=", (Object)accepterbebankNumber);
                accepters = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,name,number", (QFilter[])new QFilter[]{accepterbebankNumberFilter});
                if (accepters.length < 1 && EmptyUtil.isNotEmpty((CharSequence)accepterbebankName)) {
                    QFilter drawerorgNameFilter = new QFilter("name", "=", (Object)accepterbebankName);
                    accepters = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,name,number", (QFilter[])new QFilter[]{drawerorgNameFilter});
                }
                if (accepters.length > 0) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("name", (Object)accepters[0].getString("name"));
                    jsonObject.put("number", (Object)accepters[0].getString("number"));
                    data.put("accepterbebank", (Object)jsonObject);
                    data.put("acceptername", (Object)accepters[0].getString("name"));
                }
            } else if (EmptyUtil.isNotEmpty((CharSequence)accepterbebankName) && (accepters = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,name,number", (QFilter[])new QFilter[]{accepterbebankNameFilter = new QFilter("name", "=", (Object)accepterbebankName)})).length > 0) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("name", (Object)accepters[0].getString("name"));
                jsonObject.put("number", (Object)accepters[0].getString("number"));
                data.put("accepterbebank", (Object)jsonObject);
                data.put("acceptername", (Object)accepters[0].getString("name"));
            }
        } else if (EmptyUtil.isNotEmpty((CharSequence)accepterName) && (accepters = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,name,number", (QFilter[])new QFilter[]{accepternameFilter = new QFilter("name", "=", (Object)accepterName)})).length > 0) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", (Object)accepters[0].getString("name"));
            jsonObject.put("number", (Object)accepters[0].getString("number"));
            data.put("accepterbebank", (Object)jsonObject);
        }
    }

    private void checkAcceptPromiser(JSONObject data) {
        String acceptpromiserType = data.getString("acceptpromisertype");
        JSONObject acceptpromiserJSON = data.getJSONObject("acceptpromiser");
        String acceptpromiseName = data.getString("acceptpromisername");
        if (EmptyUtil.isNotEmpty((CharSequence)acceptpromiserType)) {
            if (!EmptyUtil.isEmpty((Object)acceptpromiserJSON)) {
                String acceptpromiserNumber = acceptpromiserJSON.getString("number");
                String acceptpromiserName = acceptpromiserJSON.getString("name");
                if (StringUtils.equals((CharSequence)acceptpromiserType, (CharSequence)"bd_supplier")) {
                    this.setBaseDataAndText(data, acceptpromiserNumber, acceptpromiserName, "bd_supplier", "acceptpromiser", "acceptpromisername", "accpromisetype");
                } else if (StringUtils.equals((CharSequence)acceptpromiserType, (CharSequence)"bos_org")) {
                    this.setBaseDataAndText(data, acceptpromiserNumber, acceptpromiserName, "bos_org", "acceptpromiser", "acceptpromisername", "accpromisetype");
                } else if (StringUtils.equals((CharSequence)acceptpromiserType, (CharSequence)"bd_customer")) {
                    this.setBaseDataAndText(data, acceptpromiserNumber, acceptpromiserName, "bd_customer", "acceptpromiser", "acceptpromisername", "accpromisetype");
                } else if (StringUtils.equals((CharSequence)acceptpromiserType, (CharSequence)"bos_user")) {
                    this.setBaseDataAndText(data, acceptpromiserNumber, acceptpromiserName, "bos_user", "acceptpromiser", "acceptpromisername", "accpromisetype");
                }
            } else if (EmptyUtil.isNotEmpty((CharSequence)acceptpromiseName)) {
                if (StringUtils.equals((CharSequence)acceptpromiserType, (CharSequence)"bd_supplier")) {
                    this.setBaseDataByText(data, acceptpromiseName, "bd_supplier", "acceptpromiser", "accpromisetype");
                } else if (StringUtils.equals((CharSequence)acceptpromiserType, (CharSequence)"bos_org")) {
                    this.setBaseDataByText(data, acceptpromiseName, "bos_org", "acceptpromiser", "accpromisetype");
                } else if (StringUtils.equals((CharSequence)acceptpromiserType, (CharSequence)"bd_customer")) {
                    this.setBaseDataByText(data, acceptpromiseName, "bd_customer", "acceptpromiser", "accpromisetype");
                } else if (StringUtils.equals((CharSequence)acceptpromiserType, (CharSequence)"bos_user")) {
                    this.setBaseDataByText(data, acceptpromiseName, "bos_user", "acceptpromiser", "accpromisetype");
                }
            }
        }
    }

    private void checkIssuePromiser(JSONObject data) {
        String issuepromiserType = data.getString("issuepromisertype");
        JSONObject issuepromiserJSON = data.getJSONObject("issuepromiser");
        String issuepromiseName = data.getString("issuepromisername");
        if (EmptyUtil.isNotEmpty((CharSequence)issuepromiserType)) {
            if (!EmptyUtil.isEmpty((Object)issuepromiserJSON)) {
                String issuepromiserNumber = issuepromiserJSON.getString("number");
                String issuepromiserName = issuepromiserJSON.getString("name");
                if (StringUtils.equals((CharSequence)issuepromiserType, (CharSequence)"bd_supplier")) {
                    this.setBaseDataAndText(data, issuepromiserNumber, issuepromiserName, "bd_supplier", "issuepromiser", "issuepromisername", "isspromisetype");
                } else if (StringUtils.equals((CharSequence)issuepromiserType, (CharSequence)"bos_org")) {
                    this.setBaseDataAndText(data, issuepromiserNumber, issuepromiserName, "bos_org", "issuepromiser", "issuepromisername", "isspromisetype");
                } else if (StringUtils.equals((CharSequence)issuepromiserType, (CharSequence)"bd_customer")) {
                    this.setBaseDataAndText(data, issuepromiserNumber, issuepromiserName, "bd_customer", "issuepromiser", "issuepromisername", "isspromisetype");
                } else if (StringUtils.equals((CharSequence)issuepromiserType, (CharSequence)"bos_user")) {
                    this.setBaseDataAndText(data, issuepromiserNumber, issuepromiserName, "bos_user", "issuepromiser", "issuepromisername", "isspromisetype");
                }
            } else if (EmptyUtil.isNotEmpty((CharSequence)issuepromiseName)) {
                if (StringUtils.equals((CharSequence)issuepromiserType, (CharSequence)"bd_supplier")) {
                    this.setBaseDataByText(data, issuepromiseName, "bd_supplier", "issuepromiser", "isspromisetype");
                } else if (StringUtils.equals((CharSequence)issuepromiserType, (CharSequence)"bos_org")) {
                    this.setBaseDataByText(data, issuepromiseName, "bos_org", "issuepromiser", "isspromisetype");
                } else if (StringUtils.equals((CharSequence)issuepromiserType, (CharSequence)"bd_customer")) {
                    this.setBaseDataByText(data, issuepromiseName, "bd_customer", "issuepromiser", "isspromisetype");
                } else if (StringUtils.equals((CharSequence)issuepromiserType, (CharSequence)"bos_user")) {
                    this.setBaseDataByText(data, issuepromiseName, "bos_user", "issuepromiser", "isspromisetype");
                }
            }
        }
    }

    private void setDrawerbank(JSONObject data) {
        QFilter drawerbankNoFilter;
        DynamicObject[] drawerBankObjs;
        JSONObject drawerBankJSON = data.getJSONObject("drawerbank");
        String drawerbankNo = data.getString("drawerbankno");
        if (drawerBankJSON == null && EmptyUtil.isEmpty((String)drawerbankNo)) {
            return;
        }
        if (null != drawerBankJSON) {
            QFilter drawerbankNameFilter;
            DynamicObject[] drawerBankObjs2;
            String drawerBankNumber = drawerBankJSON.getString("number");
            if (EmptyUtil.isNotEmpty((CharSequence)drawerBankNumber)) {
                QFilter drawerbankNameFilter2;
                QFilter drawerBankNumberFilter = new QFilter("number", "=", (Object)drawerBankNumber);
                DynamicObject[] drawerBankObjs3 = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,number,union_number", (QFilter[])new QFilter[]{drawerBankNumberFilter});
                if (drawerBankObjs3.length > 0) {
                    data.getJSONObject("drawerbank").put("name", (Object)drawerBankObjs3[0].getString("name"));
                    data.put("drawerbankno", (Object)drawerBankObjs3[0].getString("union_number"));
                } else if (EmptyUtil.isNotEmpty((CharSequence)drawerbankNo)) {
                    QFilter drawerbankNoFilter2 = new QFilter("union_number", "=", (Object)drawerbankNo);
                    drawerBankObjs3 = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,number,union_number", (QFilter[])new QFilter[]{drawerbankNoFilter2});
                    if (drawerBankObjs3.length > 0) {
                        data.getJSONObject("drawerbank").put("number", (Object)drawerBankObjs3[0].getString("number"));
                        data.getJSONObject("drawerbank").put("name", (Object)drawerBankObjs3[0].getString("name"));
                    } else {
                        QFilter drawerbankNameFilter3;
                        String drawerBankName = drawerBankJSON.getString("name");
                        if (EmptyUtil.isNotEmpty((CharSequence)drawerBankName) && (drawerBankObjs3 = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,number,union_number", (QFilter[])new QFilter[]{drawerbankNameFilter3 = new QFilter("name", "=", (Object)drawerBankName)})).length > 0) {
                            data.getJSONObject("drawerbank").put("number", (Object)drawerBankObjs3[0].getString("number"));
                            data.put("drawerbankno", (Object)drawerBankObjs3[0].getString("union_number"));
                        }
                    }
                } else if (EmptyUtil.isNotEmpty((CharSequence)drawerBankJSON.getString("name")) && (drawerBankObjs3 = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,number,union_number", (QFilter[])new QFilter[]{drawerbankNameFilter2 = new QFilter("name", "=", (Object)drawerBankJSON.getString("name"))})).length > 0) {
                    data.getJSONObject("drawerbank").put("number", (Object)drawerBankObjs3[0].getString("number"));
                    data.put("drawerbankno", (Object)drawerBankObjs3[0].getString("union_number"));
                }
            } else if (EmptyUtil.isNotEmpty((CharSequence)drawerbankNo)) {
                QFilter drawerbankNoFilter3 = new QFilter("union_number", "=", (Object)drawerbankNo);
                DynamicObject[] drawerBankObjs4 = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,number,union_number", (QFilter[])new QFilter[]{drawerbankNoFilter3});
                if (drawerBankObjs4.length > 0) {
                    data.getJSONObject("drawerbank").put("number", (Object)drawerBankObjs4[0].getString("number"));
                    data.getJSONObject("drawerbank").put("name", (Object)drawerBankObjs4[0].getString("name"));
                } else {
                    QFilter drawerbankNameFilter4;
                    String drawerBankName = drawerBankJSON.getString("name");
                    if (EmptyUtil.isNotEmpty((CharSequence)drawerBankName) && (drawerBankObjs4 = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,number,union_number", (QFilter[])new QFilter[]{drawerbankNameFilter4 = new QFilter("name", "=", (Object)drawerBankName)})).length > 0) {
                        data.getJSONObject("drawerbank").put("number", (Object)drawerBankObjs4[0].getString("number"));
                        data.put("drawerbankno", (Object)drawerBankObjs4[0].getString("union_number"));
                    }
                }
            } else if (EmptyUtil.isNotEmpty((CharSequence)drawerBankJSON.getString("name")) && (drawerBankObjs2 = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,number,union_number", (QFilter[])new QFilter[]{drawerbankNameFilter = new QFilter("name", "=", (Object)drawerBankJSON.getString("name"))})).length > 0) {
                data.getJSONObject("drawerbank").put("number", (Object)drawerBankObjs2[0].getString("number"));
                data.put("drawerbankno", (Object)drawerBankObjs2[0].getString("union_number"));
            }
        } else if (EmptyUtil.isNotEmpty((CharSequence)drawerbankNo) && (drawerBankObjs = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,number,name,union_number", (QFilter[])new QFilter[]{drawerbankNoFilter = new QFilter("union_number", "=", (Object)drawerbankNo)})).length > 0) {
            JSONObject dataJSONObject = new JSONObject();
            dataJSONObject.put("number", (Object)drawerBankObjs[0].getString("number"));
            dataJSONObject.put("name", (Object)drawerBankObjs[0].getString("name"));
            data.put("drawerbank", (Object)dataJSONObject);
        }
    }

    private boolean needReCalAmount(String subbillquantity, String subbillstartflag, String subbillendflag) {
        return EmptyUtil.isNotEmpty((CharSequence)subbillquantity) || EmptyUtil.isNotEmpty((CharSequence)subbillstartflag) && EmptyUtil.isNotEmpty((CharSequence)subbillendflag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImportBillData> checkImportRepeatDraftBillNo(List<ImportBillData> checkedBillDatas, ImportLogger logger, Map<String, DynamicObject> numberBillTypeMap) {
        if (EmptyUtil.isNoEmpty(checkedBillDatas)) {
            ImportBillData[] importBillDatas = checkedBillDatas.toArray(new ImportBillData[checkedBillDatas.size()]);
            int length = importBillDatas.length;
            HashSet<Integer> hasCheckIndex = new HashSet<Integer>(16);
            for (int i = 0; i < length; ++i) {
                for (int j = 0; j < length - 1 - i; ++j) {
                    String errorMessage = null;
                    ImportBillData after = null;
                    try {
                        ImportBillData before = importBillDatas[i];
                        after = importBillDatas[j + i + 1];
                        if (!this.isRepeatImportData(before, after, numberBillTypeMap)) continue;
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801\u201c%s\u201d\u91cd\u590d\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"CdmBizResource_119", (String)"tmc-cdm-common", (Object[])new Object[0]), after.getData().getString("draftbillno")));
                    }
                    catch (Exception exc) {
                        errorMessage = exc.getMessage();
                        continue;
                    }
                    finally {
                        if (StringUtils.isNotEmpty((CharSequence)errorMessage)) {
                            int startIndex = after.getStartIndex();
                            if (hasCheckIndex.add(startIndex)) {
                                hasCheckIndex.add(startIndex);
                                logger.log(Integer.valueOf(startIndex), errorMessage).fail();
                            }
                            checkedBillDatas.remove(after);
                        }
                    }
                }
            }
        }
        return checkedBillDatas;
    }

    private boolean isRepeatImportData(ImportBillData before, ImportBillData after, Map<String, DynamicObject> numberBillTypeMap) {
        String afterDraftBillNo;
        String beforeDraftBillNo;
        if (before == null || after == null) {
            return false;
        }
        JSONObject beforeData = before.getData();
        JSONObject afterData = after.getData();
        boolean isSettlementTypeSame = false;
        boolean isDrawerBankNumberSame = false;
        boolean isDraftBillNoSame = false;
        boolean isSubBillRangeSame = false;
        String beforeNumber = beforeData.getJSONObject("draftbilltype").getString("number");
        DynamicObject beforeDraftBillType = numberBillTypeMap.get(beforeNumber);
        String beforeSettlementType = beforeDraftBillType.getString("settlementtype");
        String afterNumber = afterData.getJSONObject("draftbilltype").getString("number");
        DynamicObject afterDraftBillType = numberBillTypeMap.get(afterNumber);
        String afterSettlementType = afterDraftBillType.getString("settlementtype");
        if ((beforeSettlementType.equals(SettleMentTypeEnum.BUSINESS.getValue()) || beforeSettlementType.equals(SettleMentTypeEnum.BANK.getValue())) && (afterSettlementType.equals(SettleMentTypeEnum.BUSINESS.getValue()) || afterSettlementType.equals(SettleMentTypeEnum.BANK.getValue())) || beforeSettlementType.equals(afterSettlementType)) {
            isSettlementTypeSame = true;
        }
        JSONObject beforeJSONObject = beforeData.getJSONObject("drawerbank");
        JSONObject afterJSONObject = afterData.getJSONObject("drawerbank");
        if (beforeJSONObject == null && afterJSONObject == null) {
            isDrawerBankNumberSame = true;
        }
        if (beforeJSONObject != null && afterJSONObject != null) {
            String beforeDrawerBankNumber = beforeJSONObject.getString("number");
            String afterDrawerBankNumber = afterJSONObject.getString("number");
            if (EmptyUtil.isNotEmpty((CharSequence)beforeDrawerBankNumber) && EmptyUtil.isNotEmpty((CharSequence)afterDrawerBankNumber) && beforeDrawerBankNumber.equals(afterDrawerBankNumber)) {
                isDrawerBankNumberSame = true;
            }
        }
        if ((beforeDraftBillNo = beforeData.getString("draftbillno")).equals(afterDraftBillNo = afterData.getString("draftbillno"))) {
            isDraftBillNoSame = true;
        }
        boolean beforeIssplit = beforeData.getBoolean("issplit");
        boolean afterIssplit = afterData.getBoolean("issplit");
        if (beforeIssplit && afterIssplit) {
            Long endFlag;
            String afterSubBillRange;
            Long startFlag;
            String beforeSubBillRange = beforeData.getString("subbillrange");
            if (this.isRepeatDraftBillNo(beforeSubBillRange, startFlag = Long.valueOf((afterSubBillRange = afterData.getString("subbillrange")).split("-")[0]), endFlag = Long.valueOf(afterSubBillRange.split("-")[1]))) {
                isSubBillRangeSame = true;
            }
        } else {
            isSubBillRangeSame = !beforeIssplit && !afterIssplit;
        }
        return isSettlementTypeSame && isDrawerBankNumberSame && isDraftBillNoSame && isSubBillRangeSame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImportBillData> checkDBRepeatDraftBillNo(List<ImportBillData> checkedBillDatas, ImportLogger logger) {
        Iterator<ImportBillData> it = checkedBillDatas.iterator();
        ArrayList<ImportBillData> repeatDataList = new ArrayList<ImportBillData>(checkedBillDatas.size());
        while (it.hasNext()) {
            String errorMessage = null;
            ImportBillData rowData = it.next();
            JSONObject data = rowData.getData();
            try {
                String draftBillTypeNumber = data.getJSONObject("draftbilltype").getString("number");
                QFilter settlementTypeFilter = new QFilter("number", "=", (Object)draftBillTypeNumber);
                DynamicObject[] draftBillTypes = TmcDataServiceHelper.load((String)"cdm_billtype", (String)"id,settlementtype,defaulttime,defaultunit", (QFilter[])new QFilter[]{settlementTypeFilter});
                String settlementType = draftBillTypes[0].getString("settlementtype");
                boolean isSupportSplit = settlementType.equals(SettleMentTypeEnum.BUSINESS.getValue()) || settlementType.equals(SettleMentTypeEnum.BANK.getValue());
                String draftBillNo = data.getString("draftbillno");
                String subBillRange = data.getString("subbillrange");
                boolean issplit = data.getBoolean("issplit");
                if (EmptyUtil.isEmpty((Object)data.getJSONObject("drawerbank")) || EmptyUtil.isEmpty((String)data.getJSONObject("drawerbank").getString("number"))) continue;
                String drawerBankNumber = data.getJSONObject("drawerbank").getString("number");
                QFilter drawerBankNumberFilter = new QFilter("number", "=", (Object)drawerBankNumber);
                Object[] drawerBankObjs = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,number", (QFilter[])new QFilter[]{drawerBankNumberFilter});
                if (EmptyUtil.isEmpty((Object[])drawerBankObjs)) continue;
                QFilter filters = new QFilter("draftbillno", "=", (Object)draftBillNo);
                if (SettleMentTypeEnum.BUSINESS.getValue().equals(settlementType) || SettleMentTypeEnum.BANK.getValue().equals(settlementType)) {
                    String[] types = new String[]{SettleMentTypeEnum.BUSINESS.getValue(), SettleMentTypeEnum.BANK.getValue()};
                    filters.and(new QFilter("draftbilltype.settlementtype", "in", (Object)types));
                } else {
                    filters.and(new QFilter("draftbilltype.settlementtype", "=", (Object)settlementType));
                }
                filters.and(new QFilter("draftbillstatus", "=", (Object)DraftBillStatusEnum.REGISTERED.getValue()));
                filters.and(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue()));
                DynamicObject[] bills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,issplit,drawerbank,subbillrange", (QFilter[])new QFilter[]{filters});
                if (!isSupportSplit && bills.length > 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801\u201c%s\u201d\u91cd\u590d\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"CdmBizResource_119", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillNo));
                }
                if (isSupportSplit && !issplit && bills.length > 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801\u201c%s\u201d\u91cd\u590d\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"CdmBizResource_119", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillNo));
                }
                boolean isExistNoSplit = false;
                for (DynamicObject dynamicObject : bills) {
                    boolean isSplitDb = dynamicObject.getBoolean("issplit");
                    if (isSplitDb) continue;
                    isExistNoSplit = true;
                    break;
                }
                if (isSupportSplit && issplit && isExistNoSplit) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801\u201c%s\u201d\u91cd\u590d\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"CdmBizResource_119", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillNo));
                }
                if (!isSupportSplit || !issplit || !StringUtils.isNotEmpty((CharSequence)subBillRange)) continue;
                Long startFlag = Long.valueOf(subBillRange.split("-")[0]);
                Long endFlag = Long.valueOf(subBillRange.split("-")[1]);
                for (DynamicObject bill : bills) {
                    Long idDo;
                    DynamicObject[] finOrgInfoBills = BusinessDataServiceHelper.load((String)"bd_finorginfo", (String)"id,bank_cate", (QFilter[])new QFilter[]{new QFilter("bebank", "=", drawerBankObjs[0].getPkValue())});
                    String subBillRangeFrombase = bill.getString("subbillrange");
                    boolean isSameSubBillRange = this.isRepeatDraftBillNo(subBillRangeFrombase, startFlag, endFlag);
                    if (finOrgInfoBills.length == 0) {
                        String number = drawerBankObjs[0].getString("number");
                        number = number.substring(0, Math.min(number.length(), 3));
                        DynamicObject billdrawerbank = bill.getDynamicObject("drawerbank");
                        if (null == billdrawerbank || null == billdrawerbank.getString("number") || !billdrawerbank.getString("number").startsWith(number) || !isSameSubBillRange) continue;
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801\u201c%s\u201d\u91cd\u590d\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"CdmBizResource_119", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillNo));
                    }
                    DynamicObject bankCate = finOrgInfoBills[0].getDynamicObject("bank_cate");
                    if (EmptyUtil.isEmpty((DynamicObject)bankCate)) continue;
                    Long id = bankCate.getLong("id");
                    DynamicObject drawerBankDo = bill.getDynamicObject("drawerbank");
                    DynamicObject[] finOrgInfoBillDos = BusinessDataServiceHelper.load((String)"bd_finorginfo", (String)"id,bank_cate", (QFilter[])new QFilter[]{new QFilter("bebank", "=", drawerBankDo.getPkValue())});
                    DynamicObject bankCateDo = null;
                    if (finOrgInfoBillDos != null && finOrgInfoBillDos.length > 0) {
                        bankCateDo = finOrgInfoBillDos[0].getDynamicObject("bank_cate");
                    }
                    if (bankCateDo == null || id.compareTo(idDo = Long.valueOf(bankCateDo.getLong("id"))) != 0 || !isSameSubBillRange) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801\u201c%s\u201d\u91cd\u590d\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"CdmBizResource_119", (String)"tmc-cdm-common", (Object[])new Object[0]), draftBillNo));
                }
            }
            catch (Exception exc) {
                errorMessage = exc.getMessage();
            }
            finally {
                if (!StringUtils.isNotEmpty((CharSequence)errorMessage)) continue;
                logger.log(Integer.valueOf(rowData.getStartIndex()), errorMessage).fail();
                repeatDataList.add(rowData);
                it.remove();
            }
        }
        return repeatDataList;
    }

    private boolean isRepeatDraftBillNo(String subBillRangeDb, Long startFlag, Long endFlag) {
        if (StringUtils.isEmpty((CharSequence)subBillRangeDb) || !subBillRangeDb.contains("-")) {
            return false;
        }
        Long startFlagDb = Long.valueOf(subBillRangeDb.split("-")[0]);
        Long endFlagDb = Long.valueOf(subBillRangeDb.split("-")[1]);
        boolean isRepeat = startFlag >= startFlagDb && startFlag <= endFlagDb || endFlag >= startFlagDb && endFlag <= endFlagDb || startFlag <= startFlagDb && endFlag >= endFlagDb;
        return isRepeat;
    }

    private void setAcceptDate(JSONObject data) {
        JSONObject draftBillTypeNumberJSON;
        String draftBillTypeNumber;
        QFilter draftBillTypeNumberFilter;
        Object[] draftBillTypes;
        String acceptDate = data.getString("acceptdate");
        if (EmptyUtil.isEmpty((String)acceptDate) && !EmptyUtil.isEmpty((Object[])(draftBillTypes = TmcDataServiceHelper.load((String)"cdm_billtype", (String)"id,settlementtype,defaulttime,defaultunit", (QFilter[])new QFilter[]{draftBillTypeNumberFilter = new QFilter("number", "=", (Object)(draftBillTypeNumber = (draftBillTypeNumberJSON = data.getJSONObject("draftbilltype")).getString("number")))})))) {
            boolean flag;
            String settlementType = draftBillTypes[0].getString("settlementtype");
            boolean bl = flag = settlementType.equals(SettleMentTypeEnum.BUSINESS.getValue()) || settlementType.equals(SettleMentTypeEnum.BANK.getValue());
            if (flag) {
                data.put("acceptdate", (Object)data.getString("issuedate"));
            }
        }
    }
}

