/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.report.plugin;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.report.helper.ReportDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class PayableBillSumReportListDataPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final Log logger = LogFactory.getLog(PayableBillSumReportListDataPlugin.class);
    private String sumType;
    private Field[] rowMetaFields;

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map transQueryParam = this.transQueryParam(queryParam);
        return this.getPayDataSet(transQueryParam);
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        if (dataSet == null || dataSet.isEmpty()) {
            return dataSet;
        }
        return dataSet.addField("statcurrency", "reportcurrency");
    }

    private DataSet getPayDataSet(Map<String, Object> transQueryParam) {
        DataSet payableBillDataSet31;
        String[] rightSelector;
        String[] leftSelector;
        DataSet payableBillDataSet310;
        DataSet payableBillDataSet30;
        DataSet payableBillDataSet300;
        DataSet payableBillDataSet2;
        DataSet payableBillDataSet202;
        DataSet payableBillDataSet201;
        DataSet payableBillDataSet200;
        DataSet payableBillDataSet01;
        DataSet payableBillDataSet011;
        DataSet payableBillDataSet010;
        DataSet payableBillDataSet00;
        DataSet payableBillDataSet002;
        DataSet payableBillDataSet001;
        this.setDefaultDateInit(transQueryParam);
        QFilter[] periodBeginQFilter = this.getPeriodBeginQFilter(transQueryParam);
        QFilter[] periodOutQFilter = this.getPeriodOutQFilter(transQueryParam);
        QFilter[] periodCashQFilter = this.getPeriodCashQFilter(transQueryParam);
        this.sumType = (String)transQueryParam.get("filter_sumtype");
        this.sumType = "currency".equals(this.sumType) ? "" : this.sumType + ",";
        String calUnits = "1";
        if (!ObjectUtils.isEmpty((Object)transQueryParam.get("filter_currencyunit"))) {
            calUnits = (String)transQueryParam.get("filter_currencyunit");
        }
        List companyIds = this.getQueryOrgIds(this.getQueryParam());
        Date filterStartDate = (Date)transQueryParam.get("filter_querydate_start");
        Date filterEndDate = (Date)transQueryParam.get("filter_querydate_end");
        QFilter startDateQFilter = new QFilter("bizdate", ">=", (Object)filterStartDate);
        QFilter endDateQFilter = new QFilter("bizdate", "<=", (Object)filterEndDate);
        QFilter payOffFilter = new QFilter("tradetype", "=", (Object)"payoff");
        payOffFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        payOffFilter.and(new QFilter("draftbilltranstatus", "=", (Object)"success"));
        payOffFilter.and(new QFilter("company", "in", (Object)companyIds));
        QFilter bizFinishDateFilter = new QFilter("bizfinishdate", ">=", (Object)filterStartDate);
        DynamicObject[] payOffTradeBills = BusinessDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id,entrys.draftbill", (QFilter[])new QFilter[]{payOffFilter, bizFinishDateFilter});
        HashSet payOffBillIds = new HashSet(4);
        if (payOffTradeBills.length > 0) {
            for (DynamicObject payOffTradeBill : payOffTradeBills) {
                DynamicObjectCollection dynamicObjects = payOffTradeBill.getDynamicObjectCollection("entrys");
                if (dynamicObjects == null || dynamicObjects.size() == 0) continue;
                Set payOffBillId00 = dynamicObjects.stream().filter(o -> o.getDynamicObject("draftbill") != null).filter(o -> o.getDynamicObject("draftbill").getDate("issuedate").before(filterStartDate)).map(o -> o.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet());
                payOffBillIds.addAll(payOffBillId00);
            }
        }
        List<QFilter> periodBeginQFilterPlus00 = Arrays.stream(periodBeginQFilter).collect(Collectors.toList());
        periodBeginQFilterPlus00.add(new QFilter("id", "in", payOffBillIds));
        periodBeginQFilterPlus00.add(new QFilter("draftbillstatus", "=", (Object)"payoffed"));
        if (this.sumType.contains("paybilltype")) {
            payableBillDataSet001 = QueryServiceHelper.queryDataSet((String)"PayData001", (String)"cdm_payablebill", (String)("" + this.sumType + "draftbilltype.name draftbilltype,id,guarantee,currency,amount,0 amount2,0 suretyamount2,0 amount3,0 returnamount,0 suretyamount3,0 amount4,0 suretyamount4"), (QFilter[])periodBeginQFilterPlus00.toArray(new QFilter[0]), null);
            payableBillDataSet002 = QueryServiceHelper.queryDataSet((String)"PayData002", (String)"fbd_suretybill", (String)"entry.debtbillid debtbillid,entry.suretyamount suretyamount,case when entry.suretysource ='linkgen' then 'linkgen' else '' end as suretysource", (QFilter[])new QFilter[]{new QFilter("entry.debttype", "in", Arrays.asList("cdm_payablebill", "cdm_payablebill_ap_manual"))}, null);
            String[] leftSelector5 = (String[])Arrays.stream(payableBillDataSet001.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            String[] rightSelector5 = (String[])Arrays.stream(payableBillDataSet002.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            payableBillDataSet00 = payableBillDataSet001.leftJoin(payableBillDataSet002).on("id", "debtbillid").select(leftSelector5, rightSelector5).finish();
        } else {
            payableBillDataSet001 = QueryServiceHelper.queryDataSet((String)"PayData001", (String)"cdm_payablebill", (String)("" + this.sumType + "draftbilltype.name draftbilltype,id,currency,amount,0 amount2,0 suretyamount2,0 amount3,0 returnamount,0 suretyamount3,0 amount4,0 suretyamount4"), (QFilter[])periodBeginQFilterPlus00.toArray(new QFilter[0]), null);
            payableBillDataSet002 = QueryServiceHelper.queryDataSet((String)"PayData002", (String)"fbd_suretybill", (String)"entry.debtbillid debtbillid,entry.suretyamount suretyamount", (QFilter[])new QFilter[]{new QFilter("entry.debttype", "in", Arrays.asList("cdm_payablebill", "cdm_payablebill_ap_manual"))}, null);
            String[] leftSelector2 = (String[])Arrays.stream(payableBillDataSet001.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            String[] rightSelector2 = (String[])Arrays.stream(payableBillDataSet002.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            payableBillDataSet00 = payableBillDataSet001.leftJoin(payableBillDataSet002).on("id", "debtbillid").select(leftSelector2, rightSelector2).finish();
        }
        List<QFilter> periodBeginQFilterPlus01 = Arrays.stream(periodBeginQFilter).collect(Collectors.toList());
        periodBeginQFilterPlus01.add(new QFilter("draftbillstatus", "=", (Object)"registered"));
        if (this.sumType.contains("paybilltype")) {
            payableBillDataSet010 = QueryServiceHelper.queryDataSet((String)"PayData010", (String)"cdm_payablebill", (String)("" + this.sumType + "draftbilltype.name draftbilltype, id,guarantee,currency,amount,0 amount2,0 suretyamount2,0 amount3,0 returnamount,0 suretyamount3,0 amount4,0 suretyamount4"), (QFilter[])periodBeginQFilterPlus01.toArray(new QFilter[0]), null);
            payableBillDataSet011 = QueryServiceHelper.queryDataSet((String)"PayData011", (String)"fbd_suretybill", (String)"entry.debtbillid debtbillid,entry.suretyamount suretyamount,case when entry.suretysource ='linkgen' then 'linkgen' else '' end as suretysource", (QFilter[])new QFilter[]{new QFilter("entry.debttype", "in", Arrays.asList("cdm_payablebill", "cdm_payablebill_ap_manual"))}, null);
            String[] leftSelector4 = (String[])Arrays.stream(payableBillDataSet010.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            String[] rightSelector4 = (String[])Arrays.stream(payableBillDataSet011.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            payableBillDataSet01 = payableBillDataSet010.leftJoin(payableBillDataSet011).on("id", "debtbillid").select(leftSelector4, rightSelector4).finish();
        } else {
            payableBillDataSet010 = QueryServiceHelper.queryDataSet((String)"PayData010", (String)"cdm_payablebill", (String)("" + this.sumType + "draftbilltype.name draftbilltype, id,currency,amount,0 amount2,0 suretyamount2,0 amount3,0 returnamount,0 suretyamount3,0 amount4,0 suretyamount4"), (QFilter[])periodBeginQFilterPlus01.toArray(new QFilter[0]), null);
            payableBillDataSet011 = QueryServiceHelper.queryDataSet((String)"PayData011", (String)"fbd_suretybill", (String)"entry.debtbillid debtbillid,entry.suretyamount suretyamount", (QFilter[])new QFilter[]{new QFilter("entry.debttype", "in", Arrays.asList("cdm_payablebill", "cdm_payablebill_ap_manual"))}, null);
            String[] leftSelector3 = (String[])Arrays.stream(payableBillDataSet010.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            String[] rightSelector3 = (String[])Arrays.stream(payableBillDataSet011.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            payableBillDataSet01 = payableBillDataSet010.leftJoin(payableBillDataSet011).on("id", "debtbillid").select(leftSelector3, rightSelector3).finish();
        }
        DataSet payableBillDataSet = this.sumType.contains("paybilltype") ? payableBillDataSet00.union(payableBillDataSet01).select("case when contains(paybilltype, 'guarantee') and suretysource ='linkgen' then 'linkgen'when contains(paybilltype, 'guarantee') and contains(guarantee, '4') then '4'when contains(paybilltype, 'guarantee') and contains(guarantee, '5') then '5'when contains(paybilltype, 'guarantee') and contains(guarantee, '2') then '2'when contains(paybilltype, 'credit') then 'credit'when contains(paybilltype, 'credit') then 'credit'when contains(paybilltype, 'other') then 'other' else paybilltype end paybilltype,draftbilltype,currency,amount,suretyamount,amount2,suretyamount2,amount3,returnamount,suretyamount3,amount4,suretyamount4") : payableBillDataSet00.union(payableBillDataSet01).select("" + this.sumType + "draftbilltype,currency,amount,suretyamount,amount2,suretyamount2,amount3,returnamount,suretyamount3,amount4,suretyamount4");
        if (this.sumType.contains("paybilltype")) {
            payableBillDataSet200 = QueryServiceHelper.queryDataSet((String)"PayData200", (String)"cdm_payablebill", (String)("" + this.sumType + "draftbilltype.name draftbilltype, id,guarantee,currency,0 amount,0 suretyamount,amount amount2,0 amount3,0 returnamount,0 suretyamount3,0 amount4,0 suretyamount4"), (QFilter[])periodOutQFilter, null);
            payableBillDataSet201 = QueryServiceHelper.queryDataSet((String)"PayData201", (String)"fbd_suretybill", (String)"entry.debtbillid debtbillid,entry.suretyamount suretyamount2,case when entry.suretysource ='linkgen' then 'linkgen' else '' end as suretysource", (QFilter[])new QFilter[]{new QFilter("entry.debttype", "in", Arrays.asList("cdm_payablebill", "cdm_payablebill_ap_manual"))}, null);
            String[] leftSelector3 = (String[])Arrays.stream(payableBillDataSet200.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            String[] rightSelector3 = (String[])Arrays.stream(payableBillDataSet201.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            payableBillDataSet202 = payableBillDataSet200.leftJoin(payableBillDataSet201).on("id", "debtbillid").select(leftSelector3, rightSelector3).finish();
            payableBillDataSet2 = payableBillDataSet202.select("case when contains(paybilltype, 'guarantee') and suretysource ='linkgen' then 'linkgen'when contains(paybilltype, 'guarantee') and contains(guarantee, '4') then '4'when contains(paybilltype, 'guarantee') and contains(guarantee, '5') then '5'when contains(paybilltype, 'guarantee') and contains(guarantee, '2') then '2'when contains(paybilltype, 'credit') then 'credit'when contains(paybilltype, 'credit') then 'credit'when contains(paybilltype, 'other') then 'other' else paybilltype end paybilltype,draftbilltype,currency,amount,suretyamount,amount2,suretyamount2,amount3,returnamount,suretyamount3,amount4,suretyamount4");
        } else {
            payableBillDataSet200 = QueryServiceHelper.queryDataSet((String)"PayData200", (String)"cdm_payablebill", (String)("" + this.sumType + "draftbilltype.name draftbilltype, id,currency,0 amount,0 suretyamount,amount amount2,0 amount3,0 returnamount,0 suretyamount3,0 amount4,0 suretyamount4"), (QFilter[])periodOutQFilter, null);
            payableBillDataSet201 = QueryServiceHelper.queryDataSet((String)"PayData201", (String)"fbd_suretybill", (String)"entry.debtbillid debtbillid,entry.suretyamount suretyamount2", (QFilter[])new QFilter[]{new QFilter("entry.debttype", "in", Arrays.asList("cdm_payablebill", "cdm_payablebill_ap_manual"))}, null);
            String[] leftSelector4 = (String[])Arrays.stream(payableBillDataSet200.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            String[] rightSelector4 = (String[])Arrays.stream(payableBillDataSet201.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            payableBillDataSet202 = payableBillDataSet200.leftJoin(payableBillDataSet201).on("id", "debtbillid").select(leftSelector4, rightSelector4).finish();
            payableBillDataSet2 = payableBillDataSet202.select("" + this.sumType + "draftbilltype,currency,amount,suretyamount,amount2,suretyamount2,amount3,returnamount,suretyamount3,amount4,suretyamount4");
        }
        QFilter refundFilter = new QFilter("tradetype", "=", (Object)"refund");
        refundFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        refundFilter.and(new QFilter("draftbilltranstatus", "=", (Object)"success"));
        refundFilter.and(new QFilter("company", "in", (Object)companyIds));
        DynamicObject[] refundTradeBills = BusinessDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id,entrys.draftbill", (QFilter[])new QFilter[]{refundFilter, startDateQFilter, endDateQFilter});
        logger.info("PayableBillSumReportListDataPlugin refundFilter = {},refundTradeBills.length = {}", (Object)refundFilter.toString(), (Object)refundTradeBills.length);
        HashSet refundBillIds = new HashSet(4);
        if (refundTradeBills.length > 0) {
            for (String string : refundTradeBills) {
                DynamicObjectCollection dynamicObjects = string.getDynamicObjectCollection("entrys");
                if (dynamicObjects == null || dynamicObjects.size() == 0) continue;
                Set refundBillId00 = dynamicObjects.stream().filter(o -> o.getDynamicObject("draftbill") != null).map(o -> o.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet());
                refundBillIds.addAll(refundBillId00);
            }
            logger.info("PayableBillSumReportListDataPlugin refundBillIds = {}", refundBillIds);
        }
        List<QFilter> periodCashRefundQFilter = Arrays.stream(periodCashQFilter).collect(Collectors.toList());
        periodCashRefundQFilter.add(new QFilter("id", "in", refundBillIds));
        logger.info("PayableBillSumReportListDataPlugin periodCashRefundQFilter = {}", (Object)periodCashRefundQFilter.toString());
        if (this.sumType.contains("paybilltype")) {
            payableBillDataSet300 = QueryServiceHelper.queryDataSet((String)"PayData300", (String)"cdm_payablebill", (String)("" + this.sumType + "draftbilltype.name draftbilltype, id,guarantee,currency,0 amount,0 suretyamount,0 amount2,0 suretyamount2,0 amount3,amount returnamount,0 amount4,0 suretyamount4"), (QFilter[])periodCashRefundQFilter.toArray(new QFilter[0]), null);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PayData301", (String)"fbd_suretybill", (String)"entry.debtbillid debtbillid,surplusamount suretyamount3,case when entry.suretysource ='linkgen' then 'linkgen' else '' end as suretysource", (QFilter[])new QFilter[]{new QFilter("entry.debttype", "in", Arrays.asList("cdm_payablebill", "cdm_payablebill_ap_manual"))}, null);
            String[] leftSelector2 = (String[])Arrays.stream(payableBillDataSet300.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            String[] rightSelector2 = (String[])Arrays.stream(dataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            payableBillDataSet30 = payableBillDataSet300.leftJoin(dataSet).on("id", "debtbillid").select(leftSelector2, rightSelector2).finish();
        } else {
            payableBillDataSet300 = QueryServiceHelper.queryDataSet((String)"PayData300", (String)"cdm_payablebill", (String)("" + this.sumType + "draftbilltype.name draftbilltype, id,currency,0 amount,0 suretyamount,0 amount2,0 suretyamount2,0 amount3,amount returnamount,0 amount4,0 suretyamount4"), (QFilter[])periodCashRefundQFilter.toArray(new QFilter[0]), null);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PayData301", (String)"fbd_suretybill", (String)"entry.debtbillid debtbillid,entry.suretyamount suretyamount3", (QFilter[])new QFilter[]{new QFilter("entry.debttype", "in", Arrays.asList("cdm_payablebill", "cdm_payablebill_ap_manual"))}, null);
            String[] leftSelector5 = (String[])Arrays.stream(payableBillDataSet300.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            String[] rightSelector5 = (String[])Arrays.stream(dataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            payableBillDataSet30 = payableBillDataSet300.leftJoin(dataSet).on("id", "debtbillid").select(leftSelector5, rightSelector5).finish();
        }
        HashSet payOffCashBillIds = new HashSet(4);
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id,entrys.draftbill", (QFilter[])new QFilter[]{payOffFilter, startDateQFilter, endDateQFilter});
        if (dynamicObjectArray.length > 0) {
            for (String string : dynamicObjectArray) {
                DynamicObjectCollection dynamicObjects = string.getDynamicObjectCollection("entrys");
                if (dynamicObjects == null || dynamicObjects.size() == 0) continue;
                Set payOffCashBillId00 = dynamicObjects.stream().filter(o -> o.getDynamicObject("draftbill") != null).map(o -> o.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet());
                payOffCashBillIds.addAll(payOffCashBillId00);
            }
        }
        List<QFilter> periodCashQFilterPlus = Arrays.stream(periodCashQFilter).collect(Collectors.toList());
        periodCashQFilterPlus.add(new QFilter("id", "in", payOffCashBillIds));
        if (this.sumType.contains("paybilltype")) {
            payableBillDataSet310 = QueryServiceHelper.queryDataSet((String)"PayData310", (String)"cdm_payablebill", (String)("" + this.sumType + "draftbilltype.name draftbilltype, id,guarantee,currency,0 amount,0 suretyamount,0 amount2,0 suretyamount2,amount amount3,0 returnamount,0 amount4,0 suretyamount4"), (QFilter[])periodCashQFilterPlus.toArray(new QFilter[0]), null);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PayData311", (String)"fbd_suretybill", (String)"entry.debtbillid debtbillid,entry.suretyamount suretyamount3,case when entry.suretysource ='linkgen' then 'linkgen' else '' end as suretysource", (QFilter[])new QFilter[]{new QFilter("entry.debttype", "in", Arrays.asList("cdm_payablebill", "cdm_payablebill_ap_manual"))}, null);
            leftSelector = (String[])Arrays.stream(payableBillDataSet310.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            rightSelector = (String[])Arrays.stream(dataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            payableBillDataSet31 = payableBillDataSet310.leftJoin(dataSet).on("id", "debtbillid").select(leftSelector, rightSelector).finish();
        } else {
            payableBillDataSet310 = QueryServiceHelper.queryDataSet((String)"PayData310", (String)"cdm_payablebill", (String)("" + this.sumType + "draftbilltype.name draftbilltype, id,currency,0 amount,0 suretyamount,0 amount2,0 suretyamount2,amount amount3,0 returnamount,0 amount4,0 suretyamount4"), (QFilter[])periodCashQFilterPlus.toArray(new QFilter[0]), null);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PayData311", (String)"fbd_suretybill", (String)"entry.debtbillid debtbillid,entry.suretyamount suretyamount3", (QFilter[])new QFilter[]{new QFilter("entry.debttype", "in", Arrays.asList("cdm_payablebill", "cdm_payablebill_ap_manual"))}, null);
            leftSelector = (String[])Arrays.stream(payableBillDataSet310.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            rightSelector = (String[])Arrays.stream(dataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            payableBillDataSet31 = payableBillDataSet310.leftJoin(dataSet).on("id", "debtbillid").select(leftSelector, rightSelector).finish();
        }
        DataSet payableBillDataSet3 = this.sumType.contains("paybilltype") ? payableBillDataSet30.union(payableBillDataSet31).select("case when contains(paybilltype, 'guarantee') and suretysource ='linkgen' then 'linkgen'when contains(paybilltype, 'guarantee') and contains(guarantee, '4') then '4'when contains(paybilltype, 'guarantee') and contains(guarantee, '5') then '5'when contains(paybilltype, 'guarantee') and contains(guarantee, '2') then '2'when contains(paybilltype, 'credit') then 'credit'when contains(paybilltype, 'credit') then 'credit'when contains(paybilltype, 'other') then 'other' else paybilltype end paybilltype,draftbilltype,currency,amount,suretyamount,amount2,suretyamount2,amount3,returnamount,suretyamount3,amount4,suretyamount4").updateField("amount3", "amount3 - returnamount") : payableBillDataSet30.union(payableBillDataSet31).select("" + this.sumType + "draftbilltype,currency,amount,suretyamount,amount2,suretyamount2,amount3,returnamount,suretyamount3,amount4,suretyamount4").updateField("amount3", "amount3 - returnamount");
        payableBillDataSet = this.dealDataSetNull(payableBillDataSet);
        payableBillDataSet2 = this.dealDataSetNull(payableBillDataSet2);
        payableBillDataSet3 = this.dealDataSetNull(payableBillDataSet3);
        DataSet dataSet = payableBillDataSet.union(payableBillDataSet2).union(payableBillDataSet3).select("" + this.sumType + "draftbilltype,currency,amount,suretyamount,amount2,suretyamount2,amount3,returnamount,suretyamount3").addField("amount - suretyamount", "pureamount").addField("amount2 - suretyamount2", "pureamount2").addField("amount3 + returnamount - suretyamount3", "pureamount3").addField("amount + amount2 - amount3 - returnamount", "amount4").addField("suretyamount+suretyamount2-suretyamount3", "suretyamount4").addField("amount + amount2 - amount3 - returnamount - suretyamount - suretyamount2 + suretyamount3", "pureamount4").groupBy(this.getGroupByArray(new String[]{this.sumType.replace(",", ""), "draftbilltype", "currency"})).sum("amount / " + calUnits, "amount").sum("suretyamount / " + calUnits, "suretyamount").sum("pureamount / " + calUnits, "pureamount").sum("amount2 / " + calUnits, "amount2").sum("suretyamount2 / " + calUnits, "suretyamount2").sum("pureamount2 / " + calUnits, "pureamount2").sum("amount3 / " + calUnits, "amount3").sum("returnamount / " + calUnits, "returnamount").sum("suretyamount3 / " + calUnits, "suretyamount3").sum("pureamount3 / " + calUnits, "pureamount3").sum("amount4 / " + calUnits, "amount4").sum("suretyamount4 / " + calUnits, "suretyamount4").sum("pureamount4 / " + calUnits, "pureamount4").finish();
        DataSet returnDataSet = dataSet.select("" + this.sumType + "draftbilltype,currency,amount,suretyamount,pureamount,amount2,suretyamount2,pureamount2,amount3,returnamount,suretyamount3,pureamount3,amount4,suretyamount4,pureamount4").orderBy(new String[]{"draftbilltype", "currency"});
        this.rowMetaFields = returnDataSet.getRowMeta().getFields();
        HashMap<String, String> fieldsMap = new HashMap<String, String>(10);
        for (String string : this.rowMetaFields) {
            if (!(string.getDataType() instanceof BigDecimalType)) continue;
            fieldsMap.put(string.getName(), "report" + string.getName());
        }
        DynamicObjectCollection filterCurrencies = !EmptyUtil.isEmpty((Object)transQueryParam.get("filter_currency")) ? (DynamicObjectCollection)transQueryParam.get("filter_currency") : QueryServiceHelper.query((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        DynamicObject reportCurrency = (DynamicObject)transQueryParam.get("filter_statcurrency");
        DynamicObject rateTable = (DynamicObject)transQueryParam.get("filter_exratetable");
        return ReportDataHelper.exchangeRate((DataSet)returnDataSet, (DynamicObjectCollection)filterCurrencies, (DynamicObject)reportCurrency, (DynamicObject)rateTable, fieldsMap);
    }

    private DataSet dealDataSetNull(DataSet dataSet) {
        return dataSet.updateFields(new String[]{"returnamount", "suretyamount", "suretyamount2", "suretyamount3", "suretyamount4", "amount", "amount2", "amount3", "amount4"}, new String[]{"case when returnamount is null then 0 else returnamount end", "case when suretyamount is null then 0 else suretyamount end", "case when suretyamount2 is null then 0 else suretyamount2 end", "case when suretyamount3 is null then 0 else suretyamount3 end", "case when suretyamount4 is null then 0 else suretyamount4 end", "case when amount is null then 0 else amount end", "case when amount2 is null then 0 else amount2 end", "case when amount3 is null then 0 else amount3 end", "case when amount4 is null then 0 else amount4 end"});
    }

    protected boolean isNeedCurrencyUnit() {
        return false;
    }

    protected boolean isNeedDimCurrency() {
        return false;
    }

    public String sumNameField() {
        return "draftbilltype";
    }

    public List<String> groupFields() {
        List<String> groupFields = StringUtils.isEmpty((CharSequence)this.sumType) ? Collections.singletonList("currency") : Arrays.asList("currency", this.sumType.replace(",", ""));
        return new ArrayList<String>(groupFields);
    }

    public List<String> subAmountFields() {
        ArrayList<String> sumFields = new ArrayList<String>(10);
        for (Field field : this.rowMetaFields) {
            if (!(field.getDataType() instanceof BigDecimalType)) continue;
            sumFields.add(field.getName());
            sumFields.add("report" + field.getName());
        }
        return sumFields;
    }

    public List<String> sumAmountFields() {
        List<String> sumFields = this.subAmountFields();
        return sumFields.stream().filter(o -> o.contains("report")).collect(Collectors.toList());
    }

    private QFilter[] getPeriodBeginQFilter(Map<String, Object> transQueryParam) {
        List<QFilter> commonFilterList = this.commonFilter(transQueryParam);
        Date startDate = (Date)transQueryParam.get("filter_querydate_start");
        QFilter startDateQFilter = new QFilter("issuedate", "<", (Object)startDate);
        commonFilterList.add(startDateQFilter);
        return commonFilterList.toArray(new QFilter[0]);
    }

    private QFilter[] getPeriodOutQFilter(Map<String, Object> transQueryParam) {
        List<QFilter> commonFilterList = this.commonFilter(transQueryParam);
        Date filterStartDate = (Date)transQueryParam.get("filter_querydate_start");
        Date filterEndDate = (Date)transQueryParam.get("filter_querydate_end");
        QFilter startDateQFilter = new QFilter("issuedate", ">=", (Object)filterStartDate);
        QFilter endDateQFilter = new QFilter("issuedate", "<=", (Object)filterEndDate);
        QFilter draftBillStatusQFilter = new QFilter("draftbillstatus", "in", Arrays.asList("registered", "payoffed"));
        commonFilterList.add(startDateQFilter);
        commonFilterList.add(endDateQFilter);
        commonFilterList.add(draftBillStatusQFilter);
        return commonFilterList.toArray(new QFilter[0]);
    }

    private QFilter[] getPeriodCashQFilter(Map<String, Object> transQueryParam) {
        List<QFilter> commonFilterList = this.commonFilter(transQueryParam);
        return commonFilterList.toArray(new QFilter[0]);
    }

    private List<QFilter> commonFilter(Map<String, Object> transQueryParam) {
        DynamicObjectCollection filterCurrency;
        ArrayList<QFilter> resList = new ArrayList<QFilter>(4);
        QFilter companyQFilter = new QFilter("company", "in", (Object)this.getQueryOrgIds(this.getQueryParam()));
        resList.add(companyQFilter);
        String acceptorType = (String)transQueryParam.get("filter_acceptortype");
        if ("finorg".equals(acceptorType)) {
            DynamicObjectCollection filterAcceptorOrg = (DynamicObjectCollection)transQueryParam.get("filter_acceptororg");
            if (null != filterAcceptorOrg && filterAcceptorOrg.size() > 0) {
                Set filterAcceptorOrgIdSet = filterAcceptorOrg.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                QFilter acceptorQFilter = new QFilter("accepterfinorg", "in", filterAcceptorOrgIdSet);
                resList.add(acceptorQFilter);
            }
        } else if ("nonfinorginfo".equals(acceptorType)) {
            String acceptorText = (String)transQueryParam.get("filter_acceptortext");
            Set filterAcceptorTextSet = Arrays.stream(acceptorText.split(",")).collect(Collectors.toSet());
            QFilter acceptorQFilter = new QFilter("acceptername", "in", filterAcceptorTextSet);
            resList.add(acceptorQFilter);
        }
        DynamicObjectCollection filterDraftBillType = (DynamicObjectCollection)transQueryParam.get("filter_draftbilltype");
        if (null != filterDraftBillType && filterDraftBillType.size() > 0) {
            Set filterDraftBillTypeIdSet = filterDraftBillType.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            QFilter draftBillTypeQFilter = new QFilter("draftbilltype", "in", filterDraftBillTypeIdSet);
            resList.add(draftBillTypeQFilter);
        }
        if (null != (filterCurrency = (DynamicObjectCollection)transQueryParam.get("filter_currency")) && filterCurrency.size() > 0) {
            Set filterCurrencyIdSet = filterCurrency.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            QFilter currencyQFilter = new QFilter("currency", "in", filterCurrencyIdSet);
            resList.add(currencyQFilter);
        }
        String draftMedium = (String)transQueryParam.get("filter_draftmedium");
        QFilter draftMediumQFilter = new QFilter("1", "=", (Object)1);
        if ("1".equals(draftMedium)) {
            draftMediumQFilter.and(new QFilter("draftbilltype.billmedium", "=", (Object)"1"));
            resList.add(draftMediumQFilter);
        } else if ("2".equals(draftMedium)) {
            draftMediumQFilter.and(new QFilter("draftbilltype.billmedium", "=", (Object)"2"));
            resList.add(draftMediumQFilter);
        }
        QFilter draftBillTranStatusQFilter = new QFilter("draftbilltranstatus", "=", (Object)"success");
        QFilter rpTypeQFilter = new QFilter("rptype", "=", (Object)"paybill");
        resList.add(draftBillTranStatusQFilter);
        resList.add(rpTypeQFilter);
        return resList;
    }

    private String[] getGroupByArray(String[] sumArray) {
        HashSet<String> set = new HashSet<String>();
        for (String s : sumArray) {
            if (StringUtils.isEmpty((CharSequence)s)) continue;
            set.add(s);
        }
        return set.toArray(new String[0]);
    }

    private void setDefaultDateInit(Map<String, Object> transQueryParam) {
        String filterDateRanges = (String)transQueryParam.get("filter_dateranges");
        transQueryParam.put("filter_querydate_start", PayableBillSumReportListDataPlugin.explainStartDate(filterDateRanges, transQueryParam));
        transQueryParam.put("filter_querydate_end", PayableBillSumReportListDataPlugin.explainEndDate(filterDateRanges, transQueryParam));
    }

    private static Date explainStartDate(String dateStr, Map<String, Object> transQueryParam) {
        Date startDate = new Date();
        Timestamp currentTime = DateUtils.getCurrentTime();
        switch (dateStr) {
            case "thismonth": {
                startDate = DateUtils.getMinMonthDate((Date)new Date());
                break;
            }
            case "thisquarter": {
                startDate = DateUtils.getFirstSeasonDate((Date)DateUtils.getCurrentDate());
                break;
            }
            case "sixmonth": {
                startDate = DateUtils.getLastMonth((Date)currentTime, (int)6);
                break;
            }
            case "oneyear": {
                startDate = DateUtils.getLastYear((Date)currentTime, (int)1);
                break;
            }
            case "twoyear": {
                startDate = DateUtils.getLastYear((Date)currentTime, (int)2);
                break;
            }
            case "": 
            case "custom": {
                Object filterStartDate = transQueryParam.get("filter_querydate_start");
                if (ObjectUtils.isEmpty((Object)filterStartDate)) break;
                startDate = (Date)transQueryParam.get("filter_querydate_start");
                break;
            }
        }
        return DateUtils.getDataFormat((Date)startDate, (boolean)true);
    }

    private static Date explainEndDate(String dateStr, Map<String, Object> transQueryParam) {
        Date endDate = new Date();
        switch (dateStr) {
            case "thismonth": {
                endDate = DateUtils.getMaxMonthDate((Date)DateUtils.getCurrentDate());
                break;
            }
            case "thisquarter": {
                endDate = DateUtils.getLastSeasonDate((Date)DateUtils.getCurrentDate());
                break;
            }
            case "": 
            case "custom": {
                Object filterStartDate = transQueryParam.get("filter_querydate_end");
                if (ObjectUtils.isEmpty((Object)filterStartDate)) break;
                endDate = (Date)transQueryParam.get("filter_querydate_end");
                break;
            }
        }
        return DateUtils.getDataFormat((Date)endDate, (boolean)true);
    }
}

