/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.billpoolbiz;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.BizBusinessTypeEnum;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.helper.BillPoolHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.BooleanEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BillPoolBizEdit
extends AbstractBillPlugIn {
    public static final String SELECT_DRAFT_CLOSE_CALL_BACK = "select_draft_close_call_back";
    public static final String BILLAMT_CHANGE = "billamtChange";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setCompanyFilter();
        this.setBillPoolFilter();
        this.setSelectDraftFilter();
    }

    private void setSelectDraftFilter() {
        BasedataEdit draftBillEdit = (BasedataEdit)this.getControl("e_draftbill");
        draftBillEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            List<QFilter> draftQFilters = this.getDraftQFilters();
            parameter.getListFilterParameter().setQFilters(draftQFilters);
            parameter.setCaption(ResManager.loadKDString((String)"\u6536\u7968\u767b\u8bb0", (String)"BillPoolBizEdit_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
        });
    }

    private List<QFilter> getDraftQFilters() {
        DynamicObjectCollection entryEntity;
        List selectedDaftIds;
        DynamicObject company;
        IDataModel model = this.getModel();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        DynamicObject billPoolBiz = model.getDataEntity();
        QFilter statusFilter = new QFilter("draftbillstatus", "=", (Object)DraftBillStatusEnum.REGISTERED.getValue());
        qFilters.add(statusFilter);
        if (Objects.equals(this.getModel().getValue("businesstype"), BizBusinessTypeEnum.JOIN.getValue())) {
            qFilters.add(new QFilter("billpool", "is null", null).or(new QFilter("billpool", "=", (Object)0)));
        } else {
            Object billPool = this.getModel().getValue("billpool");
            if (Objects.nonNull(billPool)) {
                qFilters.add(new QFilter("billpool", "=", ((DynamicObject)billPool).getPkValue()));
                qFilters.add(new QFilter("poollockstatus", "=", (Object)"0"));
            }
        }
        qFilters.add(new QFilter("isendorsepay", "!=", (Object)"1"));
        qFilters.add(new QFilter("draftbilltype.settlementtype", "in", (Object)new String[]{SettleMentTypeEnum.BANK.getValue(), SettleMentTypeEnum.BUSINESS.getValue()}));
        DynamicObject currency = billPoolBiz.getDynamicObject("currency");
        if (Objects.nonNull(currency)) {
            qFilters.add(new QFilter("currency", "=", currency.getPkValue()));
        }
        if (Objects.nonNull(company = billPoolBiz.getDynamicObject("company"))) {
            qFilters.add(new QFilter("company", "in", company.getPkValue()));
        }
        if (!(selectedDaftIds = (entryEntity = model.getEntryEntity("entryentity")).stream().filter(row -> Objects.nonNull(row.getDynamicObject("e_draftbill"))).map(d -> d.getDynamicObject("e_draftbill").getPkValue()).collect(Collectors.toList())).isEmpty()) {
            qFilters.add(new QFilter("id", "not in", selectedDaftIds));
        }
        qFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilters.add(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue()));
        return qFilters;
    }

    private void setBillPoolFilter() {
        BasedataEdit billPoolEdit = (BasedataEdit)this.getControl("billpool");
        billPoolEdit.addBeforeF7SelectListener(evt -> {
            DynamicObject company = this.getModel().getDataEntity().getDynamicObject("company");
            if (Objects.isNull(company)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u8d44\u91d1\u7ec4\u7ec7\u201d\u3002", (String)"BillPoolBizEdit_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter billPoolFilter = BillPoolHelper.getBillPoolQFilter(Collections.singletonList((Long)company.getPkValue()));
            parameter.setCustomParam("isfrompoolselect", (Object)"1");
            parameter.getListFilterParameter().setFilter(billPoolFilter);
        });
    }

    private void setCompanyFilter() {
        BasedataEdit company = (BasedataEdit)this.getControl("company");
        company.addBeforeF7SelectListener(evt -> {
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"cdm_billpoolbiz", (String)"47150e89000000ac");
            QFilter filter = new QFilter("id", "in", (Object)authOrgIds);
            parameter.getListFilterParameter().setFilter(filter);
        });
    }

    public void afterCreateNewData(EventObject e) {
        Object businessType = this.getView().getFormShowParameter().getCustomParam("businesstype");
        Object poolDraftId = this.getView().getFormShowParameter().getCustomParam("poolDraftId");
        this.getModel().setValue("businesstype", businessType);
        if (!Objects.isNull(poolDraftId)) {
            DynamicObject poolDraftBillObject = BusinessDataServiceHelper.loadSingle((Object)poolDraftId, (String)"cdm_pooldraftbill");
            DynamicObject companyObject = poolDraftBillObject.getDynamicObject("company");
            DynamicObject poolDraftObject = poolDraftBillObject.getDynamicObject("billpool");
            DynamicObject currencyObject = poolDraftBillObject.getDynamicObject("currency");
            if (companyObject != null) {
                this.getModel().setValue("company", companyObject.getPkValue());
            }
            if (poolDraftObject != null) {
                this.getModel().setValue("billpool", poolDraftObject.getPkValue());
            }
            if (currencyObject != null) {
                this.getModel().setValue("currency", currencyObject.getPkValue());
            }
            this.getModel().setValue("draftbillcount", (Object)1);
            this.getModel().setValue("amount", poolDraftBillObject.get("amount"));
            this.getModel().setValue("e_draftbill", poolDraftBillObject.getPkValue(), this.getModel().createNewEntryRow("entryentity"));
        }
        this.getView().getFormShowParameter().setCustomParam("poolDraftId", null);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection draftBills = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < draftBills.size(); ++i) {
            DynamicObject draftBill = ((DynamicObject)draftBills.get(i)).getDynamicObject("e_draftbill");
            if (!Objects.nonNull(draftBill)) continue;
            this.getModel().setValue("e_billamt", draftBill.get("amount"), i);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String billAmtChange = this.getPageCache().get(BILLAMT_CHANGE);
        if (!StringUtils.isEmpty((CharSequence)billAmtChange)) {
            e.setCheckDataChange(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (Objects.equals(propName, "e_draftbill")) {
            DynamicObjectCollection entry = (DynamicObjectCollection)this.getModel().getValue("entryentity");
            Object newValue = e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (newValue == null) {
                this.getModel().setValue("e_billamt", null);
                AbstractFormDataModel dateModel = (AbstractFormDataModel)this.getModel();
                dateModel.deleteEntryRow("entryentity", rowIndex);
            } else {
                DynamicObject draftBill = (DynamicObject)newValue;
                this.getModel().setValue("e_billamt", (Object)draftBill.getBigDecimal("amount"), e.getChangeSet()[0].getRowIndex());
            }
            this.setBillHeader();
            Object[] draftBillIds = entry.stream().filter(row -> Objects.nonNull(row.getDynamicObject("e_draftbill"))).map(row -> row.getDynamicObject("e_draftbill").getPkValue()).toArray();
            DynamicObject[] drafts = TmcDataServiceHelper.load((String)"cdm_draftbillf7", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)draftBillIds)});
            this.checkCurrency(drafts);
        } else if (Objects.equals(propName, "billpool") && Objects.equals(this.getModel().getValue("businesstype"), BizBusinessTypeEnum.OUT.getValue())) {
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            int[] ints = new int[entryRowCount];
            for (int i = 0; i < ints.length; ++i) {
                ints[i] = i;
            }
            this.getModel().deleteEntryRows("entryentity", ints);
        }
        if (Objects.equals(propName, "e_billamt")) {
            this.getPageCache().put(BILLAMT_CHANGE, BooleanEnum.TRUE.getName());
        } else {
            this.getPageCache().remove(BILLAMT_CHANGE);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        EntryGrid entryBank;
        int[] selectRows;
        super.beforeDoOperation(args);
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (Objects.equals(operateKey, "selectdraft") || Objects.equals("newentry", operateKey)) {
            DynamicObject billPool = this.getModel().getDataEntity().getDynamicObject("billpool");
            Object businessType = this.getModel().getDataEntity().get("businesstype");
            if (Objects.equals(businessType, BizBusinessTypeEnum.OUT.getValue()) && Objects.isNull(billPool)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7968\u636e\u6c60\u3002", (String)"BillPoolBizEdit_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (Objects.equals(operateKey, "viewback") && (selectRows = (entryBank = (EntryGrid)this.getControl("entryentity")).getSelectRows()).length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5206\u5f55\u6570\u636e\u67e5\u770b\u80cc\u9762\u4fe1\u606f\u3002", (String)"BillPoolBizEdit_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (Objects.equals("selectdraft", evt.getOperateKey())) {
            ListShowParameter param = ShowFormHelper.createShowListForm((String)"cdm_draftbillf7", (boolean)true, (int)2, (boolean)true);
            param.setShowTitle(false);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELECT_DRAFT_CLOSE_CALL_BACK));
            param.setCaption(ResManager.loadKDString((String)"\u6536\u7968\u767b\u8bb0", (String)"BillPoolBizEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            param.getListFilterParameter().setQFilters(this.getDraftQFilters());
            this.getView().showForm((FormShowParameter)param);
        } else if (Objects.equals("viewback", evt.getOperateKey())) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setAppId("cdm");
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setFormId("cdm_draftbillback");
            Object draftBillId = this.getDraftBillId();
            parameter.setCustomParam("draftBillId", draftBillId);
            if (draftBillId != null) {
                this.getView().showForm(parameter);
            }
        }
    }

    private Object getDraftBillId() {
        EntryGrid entryBank = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryBank.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject selectRow = (DynamicObject)entryEntity.get(selectRows[0]);
        DynamicObject draftBill = selectRow.getDynamicObject("e_draftbill");
        return draftBill == null ? null : draftBill.getPkValue();
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.setBillHeader();
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (actionId.equals(SELECT_DRAFT_CLOSE_CALL_BACK)) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            if (EmptyUtil.isEmpty((Collection)rows)) {
                return;
            }
            List selectPks = rows.stream().filter(o -> Objects.nonNull(o.getPrimaryKeyValue())).map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            DynamicObject[] drafts = TmcDataServiceHelper.load((String)"cdm_draftbillf7", (String)String.join((CharSequence)",", "amount", "currency"), (QFilter[])new QFilter[]{new QFilter("id", "in", selectPks)});
            this.checkCurrency(drafts);
            this.batchFillEntry(drafts);
        }
    }

    private void checkCurrency(DynamicObject[] drafts) {
        Set currencyIds = Arrays.stream(drafts).filter(d -> Objects.nonNull(d.getDynamicObject("currency"))).map(d -> d.getDynamicObject("currency").getPkValue()).collect(Collectors.toSet());
        if (currencyIds.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u5e01\u79cd\u7684\u7968\u636e\u3002", (String)"BillPoolBizEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void batchFillEntry(DynamicObject[] drafts) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.forceClearNoDataRow();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("e_draftbill", new Object[0]);
        vs.addField("e_billamt", new Object[0]);
        for (int i = 0; i < drafts.length; ++i) {
            if (i == 0) {
                this.getModel().setValue("currency", drafts[i].get("currency"));
            }
            vs.addRow(new Object[]{drafts[i].getPkValue(), drafts[i].getBigDecimal("amount")});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        this.setBillHeader();
    }

    private void setBillHeader() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        BigDecimal amountCount = entryEntity.stream().map(d -> d.getBigDecimal("e_billamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        long count = entryEntity.stream().filter(d -> Objects.nonNull(d.getDynamicObject("e_draftbill"))).count();
        this.getModel().setValue("amount", (Object)amountCount);
        this.getModel().setValue("draftbillcount", (Object)count);
        if (entryEntity.isEmpty()) {
            this.getModel().setValue("currency", null);
        }
    }
}

