/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.billpoolbiz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.BizBusinessTypeEnum;
import kd.tmc.cdm.common.helper.BillPoolHelper;
import kd.tmc.cdm.common.helper.OperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PoolDraftList
extends AbstractListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("billpool.")) continue;
            String appId = this.getView().getFormShowParameter().getAppId();
            Long userId = RequestContext.get().getCurrUserId();
            List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgIdList((Long)userId, (String)appId, (String)"cdm_pooldraftbill_query", (String)"47150e89000000ac");
            Map billPools = BillPoolHelper.getAuthorizedBillPool((List)authOrgIds);
            if (!EmptyUtil.isNoEmpty((Object)billPools)) continue;
            commonFilterColumn.setComboItems(BillPoolHelper.initBillPoolList((Map)billPools));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection pkValues;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (operateKey.equals("out") && (pkValues = this.getSelectedRows()).size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8fdb\u884c\u5904\u7406\uff01", (String)"AbstractTmcListPlugin_1", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            args.setCancel(Boolean.TRUE.booleanValue());
        }
        if (operateKey.equals("pooldraftlock")) {
            args.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        switch (itemKey = evt.getItemKey()) {
            case "tbllock": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("cdm_lockbilluser_select");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cdm_lockbilluser_select"));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
                return;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("cdm_lockbilluser_select".equals(actionId)) {
            DynamicObject[] dynamicObjects;
            HashMap returnData = (HashMap)e.getReturnData();
            if (returnData == null) {
                return;
            }
            DynamicObject lockBillUser = (DynamicObject)returnData.get("lockBillUser");
            if (lockBillUser == null) {
                return;
            }
            List<Long> selectIds = this.getSelectedIdList();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cdm_pooldraftbill");
            for (DynamicObject dyobj : dynamicObjects = BusinessDataServiceHelper.load((Object[])selectIds.toArray(), (DynamicObjectType)type)) {
                Long userPK = Long.valueOf(RequestContext.get().getUserId());
                dyobj.set("lockbilluser", (Object)userPK);
                dyobj.set("poollockorg", (Object)lockBillUser);
            }
            OperationResult execOperate = null;
            execOperate = OperateServiceHelper.executeOperate((String)"pooldraftlock", (String)"cdm_pooldraftbill", (DynamicObject[])dynamicObjects, (OperateOption)OperateOption.create());
            String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u52a0\u9501\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20", (String)"PoolDraft_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), dynamicObjects.length, execOperate.getSuccessPkIds().size(), dynamicObjects.length - execOperate.getSuccessPkIds().size());
            if (execOperate != null && !execOperate.isSuccess()) {
                FormShowParameter parameters = new FormShowParameter();
                parameters.getOpenStyle().setShowType(ShowType.Modal);
                parameters.setFormId("bos_operationresult");
                parameters.setShowTitle(false);
                parameters.setCustomParam("operateName", (Object)"");
                parameters.setCustomParam("title", (Object)title);
                String decodeMultiErrorMsg = TmcOperateServiceHelper.decodeMultiErrorMsg((OperationResult)execOperate);
                parameters.setCustomParam("errorMsg", (Object)decodeMultiErrorMsg);
                execOperate.setSuccess(true);
                this.getView().showForm(parameters);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u52a0\u9501\u6210\u529f\u3002", (String)"PoolDraft_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refresh();
            }
        }
    }

    protected List<Long> getSelectedIdList() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        ArrayList<Long> idList = new ArrayList<Long>(selectedRows.size());
        if (selectedRows.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e!", (String)"AbstractTmcListPlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
        } else {
            for (ListSelectedRow listSelectedRowValue : selectedRows) {
                idList.add((Long)listSelectedRowValue.getPrimaryKeyValue());
            }
        }
        return idList;
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        OperationResult operationResult = evt.getOperationResult();
        if (operateKey.equals("pooldraftlock")) {
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u52a0\u9501\u6210\u529f\u3002", (String)"PoolDraft_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            }
        } else if (operateKey.equals("pooldraftunlock")) {
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u89e3\u9501\u6210\u529f\u3002", (String)"PoolDraft_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            }
        } else if (operateKey.equals("join")) {
            this.showPoolBizBill(BizBusinessTypeEnum.JOIN, OperationStatus.ADDNEW, null);
        } else if (operateKey.equals("out") && operationResult.isSuccess()) {
            List pkValues = operationResult.getSuccessPkIds();
            this.showPoolBizBill(BizBusinessTypeEnum.OUT, OperationStatus.ADDNEW, pkValues.get(0));
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    private void showPoolBizBill(BizBusinessTypeEnum bizBusinessTypeEnum, OperationStatus operationStatus, Object pkValue) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setAppId("cdm");
        parameter.setStatus(operationStatus);
        parameter.setFormId("cdm_billpoolbiz");
        parameter.setCustomParam("businesstype", (Object)bizBusinessTypeEnum.getValue());
        parameter.setCustomParam("poolDraftId", pkValue);
        parameter.setCaption(bizBusinessTypeEnum.getName());
        parameter.setPkId(null);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void setFilter(SetFilterEvent e) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter filter = new QFilter("billpool", ">", (Object)0);
        String appId = this.getView().getFormShowParameter().getAppId();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"cdm_pooldraftbill", (String)"47150e89000000ac");
        filter.and(new QFilter("company", "in", (Object)authOrgIds));
        filterList.add(filter);
        e.setCustomQFilters(filterList);
    }
}

