/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.elcDraft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.cdm.business.ebservice.api.IEBServiceFacade;
import kd.tmc.cdm.business.service.ViewElectContractService;
import kd.tmc.cdm.business.writeback.ElcDraftBillWriteBackDraftBill;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftExistCatEnum;
import kd.tmc.cdm.common.enums.SignOpinionEnum;
import kd.tmc.cdm.common.helper.OperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;
import org.apache.commons.lang3.StringUtils;

public class EleDraftBillHandleList
extends AbstractTmcBillBaseList {
    private static final Log logger = LogFactory.getLog(EleDraftBillHandleList.class);
    private static final List<String> TRAN_TYPE = Arrays.asList("02", "03", "10", "18", "19", "20");
    private static final List<String> DRAFT_TYPES = Arrays.asList("AC01", "AC02");

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        this.cacheQFilter(e.getQFilters());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "noteendorse": 
            case "notediscount": 
            case "removepledge": 
            case "pledgenote": 
            case "presentpayment": {
                DynamicObject[] electronicBills;
                QFilter idsFilter = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
                for (DynamicObject electronicBill : electronicBills = TmcDataServiceHelper.load((String)"cdm_electronic_rec_deal", (String)"id,ebstatus,tradetype,backflag", (QFilter[])new QFilter[]{idsFilter})) {
                    String ebstatus = electronicBill.getString("ebstatus");
                    boolean backflag = electronicBill.getBoolean("backflag");
                    String tradetype = electronicBill.getString("tradetype");
                    if (EbStatus.BANK_FAIL.getName().equals(ebstatus) && !backflag && operateKey.equals(tradetype)) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u4ea4\u6613\u5931\u8d25\u5e76\u672a\u6253\u56de\u4e14\u64cd\u4f5c\u7c7b\u578b\u4e0e\u73b0\u5728\u64cd\u4f5c\u4e00\u81f4\u7684\u624d\u5141\u8bb8\u8fdb\u884c\u64cd\u4f5c", (String)"EleDraftRecList_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                break;
            }
            case "viewcontract": {
                Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
                if (EmptyUtil.isEmpty((Object[])primaryKeyValues) || primaryKeyValues.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c", (String)"EleDraftRecList_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ViewElectContractService viewElectContractService = new ViewElectContractService();
                viewElectContractService.openEleContractById(this.getView(), primaryKeyValues[0]);
            }
        }
    }

    private void cacheQFilter(List<QFilter> qFilterList) {
        ArrayList<String> qFilterStrList = new ArrayList<String>(qFilterList.size());
        for (QFilter qFilter : qFilterList) {
            qFilterStrList.add(qFilter.toSerializedString());
        }
        this.getPageCache().put("qfilters", SerializationUtils.toJsonString(qFilterStrList));
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        FormOperate formOperate = (FormOperate)event.getSource();
        OperationResult opResult = event.getOperationResult();
        String operateKey = formOperate.getOperateKey();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", "true");
        operateOption.setVariableValue("opType", operateKey);
        if ("querywaitingsign".equals(operateKey)) {
            OperationResult operationResult;
            ControlFilters controlFilters = this.getControlFilters();
            List companyIdList = controlFilters.getFilter("company.id");
            if (companyIdList == null || companyIdList.size() == 0 || "".equals(companyIdList.get(0))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u8d44\u91d1\u7ec4\u7ec7\u83b7\u53d6\u5f85\u7b7e\u6536\u6570\u636e\u3002", (String)"EleDraftBillHandleList_6", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (companyIdList.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u8d44\u91d1\u7ec4\u7ec7\u83b7\u53d6\u5f85\u7b7e\u6536\u6570\u636e\u3002", (String)"EleDraftBillHandleList_7", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                return;
            }
            String account = this.getIdAccounts();
            logger.info("EleDraftBillHandleList.afterDoOperation getIdAccounts = {}", (Object)account);
            if (StringUtils.isEmpty((CharSequence)account)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u94f6\u4f01\u76f4\u8fde\u8d26\u53f7\u672a\u7ef4\u62a4", (String)"EleDraftBillHandleList_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                return;
            }
            String[] accounts = account.split(",");
            List<Long> bankList = Arrays.stream(accounts).map(Long::valueOf).collect(Collectors.toList());
            List draftAccountList = controlFilters.getFilter("draftaccount.id");
            logger.info("EleDraftBillHandleList.afterDoOperation draftAccountList size = {}", (Object)draftAccountList.size());
            if (draftAccountList.size() > 0 && !"".equals(draftAccountList.get(0))) {
                bankList = bankList.stream().filter(o -> draftAccountList.contains(o.toString())).collect(Collectors.toList());
            }
            logger.info("EleDraftBillHandleList.afterDoOperation filter draftAccountList bankList = {}", bankList);
            List interfaceTypeList = controlFilters.getFilter("interfacetype");
            HashMap<String, List<String>> interfaceTypeMap = new HashMap<String, List<String>>(2);
            List tranType = controlFilters.getFilter("trantype");
            List<String> tranTypeList = tranType == null || tranType.size() == 0 || "".equals(tranType.get(0)) ? TRAN_TYPE : tranType.stream().map(Object::toString).collect(Collectors.toList());
            if (interfaceTypeList == null || interfaceTypeList.size() == 0 || "".equals(interfaceTypeList.get(0))) {
                interfaceTypeMap.put("0", tranTypeList);
                interfaceTypeMap.put("1", tranTypeList);
            } else {
                for (Object interfaceType : interfaceTypeList) {
                    interfaceTypeMap.put(String.valueOf(interfaceType), tranTypeList);
                }
            }
            List draftTypes = controlFilters.getFilter("drafttype");
            List<String> draftTypeEnums = draftTypes == null || draftTypes.size() == 0 || "".equals(draftTypes.get(0)) ? DRAFT_TYPES : draftTypes.stream().map(Object::toString).collect(Collectors.toList());
            List qFilterList = this.getQFilterFromPagCache();
            Optional<QFilter> bizTimeOptional = qFilterList.stream().filter(i -> i.getProperty().equals("bizdate")).findFirst();
            Date startDate = null;
            Date endDate = null;
            if (bizTimeOptional.isPresent()) {
                QFilter startDateQFilter = bizTimeOptional.get();
                List nests = startDateQFilter.getNests(true);
                QFilter endDateQFilter = ((QFilter.QFilterNest)nests.get(0)).getFilter();
                startDate = (Date)startDateQFilter.getValue();
                endDate = EleDraftBillHandleList.getNextSeconds((Date)endDateQFilter.getValue(), -1);
            }
            if ((operationResult = this.queryOp(bankList, event, interfaceTypeMap, draftTypeEnums, startDate, endDate, EleDraftExistCatEnum.REPLY.getValue())).isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"EleDraftBillHandleList_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            }
        }
        String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
        if ("notesigninreject".equals(operateKey) || "offlinereject".equals(operateKey)) {
            if (!event.getOperationResult().isSuccess()) {
                return;
            }
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            Object[] pkValues = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
            DynamicObject[] rejectDealBills = TmcDataServiceHelper.load((Object[])pkValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronic_sign_deal"));
            boolean checkSignNotice = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)rejectDealBills[0].getDynamicObject("company").getLong("id"), (String)"checksignnotice");
            String rejectOpinion = rejectDealBills[0].getString("signopinion");
            if (checkSignNotice && !SignOpinionEnum.REJECT.getValue().equals(rejectOpinion)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u63a7\u5236\u53ea\u6709\u5728\u7b7e\u6536\u901a\u77e5\u5355\u7968\u636e\u62d2\u6536\u65f6\u624d\u80fd\u62d2\u6536\u7968\u636e\u3002", (String)"EleDraftBillHandleList_8", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setAppId("cdm");
            showParameter.setFormId("cdm_electronic_reject");
            showParameter.setCustomParam("selectData", (Object)SerializationUtils.toJsonString((Object)pkValues));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            if ("notesigninreject".equals(operateKey)) {
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "notesigninreject"));
            } else {
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "offlinereject"));
            }
            this.getView().showForm(showParameter);
            return;
        }
        if ("querysigned".equals(operateKey)) {
            logger.info("querySigned is start that");
            ControlFilters controlFilters = this.getControlFilters();
            List companyIdList = controlFilters.getFilter("company.id");
            if (companyIdList == null || companyIdList.size() == 0 || "".equals(companyIdList.get(0))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u8d44\u91d1\u7ec4\u7ec7\u83b7\u53d6\u5f85\u7b7e\u6536\u6570\u636e\u3002", (String)"EleDraftBillHandleList_6", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (companyIdList.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u8d44\u91d1\u7ec4\u7ec7\u83b7\u53d6\u5f85\u7b7e\u6536\u6570\u636e\u3002", (String)"EleDraftBillHandleList_7", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                return;
            }
            String account = this.getIdAccounts();
            if (StringUtils.isEmpty((CharSequence)account)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u94f6\u4f01\u76f4\u8fde\u8d26\u53f7\u672a\u7ef4\u62a4", (String)"EleDraftBillHandleList_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                return;
            }
            String[] accounts = account.split(",");
            List<Long> bankList = Arrays.stream(accounts).map(Long::valueOf).collect(Collectors.toList());
            logger.info("querySigned bankList = " + bankList.toString());
            HashMap<String, List<String>> interfaceTypeMap = new HashMap<String, List<String>>(2);
            List<String> ticStatusEnums = Collections.singletonList("100006");
            interfaceTypeMap.put("0", ticStatusEnums);
            interfaceTypeMap.put("1", ticStatusEnums);
            List<String> draftTypeEnums = Arrays.asList("AC01", "AC02");
            logger.info("querySigned ticStatusEnums {},draftTypeEnums {} ", (Object)ticStatusEnums.toString(), (Object)draftTypeEnums.toString());
            OperationResult operationResult = this.queryOp(bankList, event, interfaceTypeMap, draftTypeEnums, null, null, EleDraftExistCatEnum.HOLD.getValue());
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"EleDraftBillHandleList_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            }
            logger.info("querySigned is end");
        }
        if ("backinfo".equals(operateKey)) {
            FormShowParameter formParameter = new FormShowParameter();
            formParameter.setFormId("cdm_electronic_backinfo");
            formParameter.getOpenStyle().setShowType(ShowType.Modal);
            List pkValues = event.getOperationResult().getSuccessPkIds();
            if (pkValues.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u80cc\u9762\u4fe1\u606f\u67e5\u8be2\u64cd\u4f5c", (String)"EleDraftBillHandleList_9", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            } else {
                formParameter.setCustomParam("eleBillId", pkValues.get(0));
                this.getView().showForm(formParameter);
            }
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Map popWindowInfo = (Map)closedCallBackEvent.getReturnData();
        if ("notesigninreject".equals(closedCallBackEvent.getActionId()) && popWindowInfo != null) {
            DynamicObject[] signDealBills;
            Object selectedRowsDatas = popWindowInfo.get("selectData");
            String rejectOpinion = (String)popWindowInfo.get("rejectOpinion");
            Set pkValues = (Set)SerializationUtils.fromJsonString((String)selectedRowsDatas.toString(), Set.class);
            for (DynamicObject signDealBill : signDealBills = TmcDataServiceHelper.load((Object[])pkValues.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronic_sign_deal"))) {
                signDealBill.set("remark", (Object)rejectOpinion);
            }
            SaveServiceHelper.save((DynamicObject[])signDealBills);
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ishasright", "true");
            operateOption.setVariableValue("opType", closedCallBackEvent.getActionId());
            String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
            boolean checkSignNotice = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)signDealBills[0].getDynamicObject("company").getLong("id"), (String)"checksignnotice");
            if (checkSignNotice) {
                String signOpinion = signDealBills[0].getString("signopinion");
                if (!SignOpinionEnum.SIGN.getValue().equals(signOpinion)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u63a7\u5236\u53ea\u6709\u5728\u7b7e\u6536\u901a\u77e5\u5355\u7968\u636e\u62d2\u6536\u65f6\u624d\u80fd\u62d2\u6536\u7968\u636e\u3002", (String)"EleDraftBillHandleList_13", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                } else {
                    OperationResult operationResult = OperateServiceHelper.execOperate((String)"receiveop", (String)"cdm_electronic_sign_deal", (Object[])pkValues.toArray(), (OperateOption)operateOption);
                    if (operationResult.isSuccess()) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"EleDraftBillHandleList_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    }
                    ((IListView)this.getView()).refresh();
                }
            } else {
                OperationResult operationResult = OperateServiceHelper.execOperate((String)"receiveop", (String)"cdm_electronic_sign_deal", (Object[])pkValues.toArray(), (OperateOption)operateOption);
                if (operationResult.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"EleDraftBillHandleList_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                }
                ((IListView)this.getView()).refresh();
            }
        }
        if ("offlinereject".equals(closedCallBackEvent.getActionId()) && popWindowInfo != null) {
            try (TXHandle tx = TX.requiresNew();){
                try {
                    DynamicObject[] rejectDealBills;
                    Object selectedRowsDatas = popWindowInfo.get("selectData");
                    String rejectOpinion = (String)popWindowInfo.get("rejectOpinion");
                    Set pkValues = (Set)SerializationUtils.fromJsonString((String)selectedRowsDatas.toString(), Set.class);
                    for (DynamicObject rejectDealBill : rejectDealBills = TmcDataServiceHelper.load((Object[])pkValues.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronic_sign_deal"))) {
                        DynamicObject[] recBills;
                        rejectDealBill.set("tradetype", (Object)"notesigninreject");
                        rejectDealBill.set("remark", (Object)rejectOpinion);
                        rejectDealBill.set("ebstatus", (Object)EbStatus.BANK_FAIL.getName());
                        rejectDealBill.set("bankmsg", (Object)(RequestContext.get().getUserName() + " " + ResManager.loadKDString((String)"\u79bb\u7ebf\u62d2\u6536", (String)"EleDraftBillHandleList_11", (String)"tmc-cdm-formplugin", (Object[])new Object[0])));
                        if (rejectDealBill.getLong("sourceid") <= 0L || (recBills = TmcDataServiceHelper.load((Object[])new Object[]{rejectDealBill.getString("sourceid")}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill"))) == null || recBills.length <= 0) continue;
                        recBills[0].set("draftbilltranstatus", (Object)DraftTranStatusEnum.FAILING.getValue());
                        SaveServiceHelper.save((DynamicObject[])recBills);
                        ElcDraftBillWriteBackDraftBill.validateAndWriteBack((Long)Long.parseLong(rejectDealBill.getString("sourceid")));
                    }
                    SaveServiceHelper.save((DynamicObject[])rejectDealBills);
                }
                catch (Exception e) {
                    logger.error("\u624b\u5de5\u62d2\u6536\u4fdd\u5b58\u5f02\u5e38\uff1a" + e);
                    tx.markRollback();
                    throw e;
                }
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"EleDraftBillHandleList_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            ((IListView)this.getView()).refresh();
        }
    }

    private OperationResult queryOp(List<Long> accountIdSet, AfterDoOperationEventArgs event, Map<String, List<String>> interfaceTypeMap, List<String> draftTypeEnums, Date startDate, Date endDate, String querySignal) {
        OperationResult operationResult = event.getOperationResult();
        IEBServiceFacade bankService = EBServiceFacadeFactory.getBankService();
        List noteResults = bankService.queryDraftBill(draftTypeEnums, interfaceTypeMap, accountIdSet, startDate, endDate, querySignal);
        ArrayList<Long> successBillIdList = new ArrayList<Long>(10);
        for (NoteResult noteResult : noteResults) {
            if (EBResultStatusCode.SUCCESS.equals((Object)noteResult.getStatusCode())) {
                successBillIdList.add(noteResult.getBillId());
                continue;
            }
            logger.error(String.format("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0cerrCode:{%s}\uff0cerrMsg:{%s}\u3002", noteResult.getErrCode(), noteResult.getErrMsg()));
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfo.setMessage(noteResult.getErrMsg());
            operationResult.addErrorInfo(operateErrorInfo);
        }
        operationResult.setBillCount(noteResults.size());
        operationResult.setSuccessPkIds(successBillIdList);
        return operationResult;
    }

    private String getIdAccounts() {
        DynamicObject[] dynamicObjects = this.getEleTicInfo();
        Object[] accountIdSet = Stream.of(dynamicObjects).map(i -> String.valueOf(i.getLong("defaultaccount.id"))).toArray();
        return StringUtils.join((Object[])accountIdSet, (String)",");
    }

    private DynamicObject[] getEleTicInfo() {
        ControlFilters controlFilters = this.getControlFilters();
        List companyIdList = controlFilters.getFilter("company.id");
        ArrayList<Long> companyIdListL = new ArrayList<Long>(companyIdList.size());
        QFilter orgFilter = new QFilter("company.id", "in", (Object)companyIdList);
        if (companyIdList.size() > 0 && companyIdList.get(0) instanceof String) {
            for (Object obj : companyIdList) {
                companyIdListL.add(Long.valueOf(obj.toString()));
            }
            orgFilter = new QFilter("company.id", "in", companyIdListL);
        }
        logger.info("EleDraftBillHandleList.getEleTicInfo companyIdList size = {}", (Object)companyIdListL.size());
        DynamicObjectCollection eleTicIdColl = QueryServiceHelper.query((String)"cdm_electicdirconset", (String)"id", (QFilter[])new QFilter[]{orgFilter});
        return TmcDataServiceHelper.load((Object[])eleTicIdColl.stream().map(i -> i.get("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electicdirconset"));
    }

    private static Date getNextSeconds(Date date, int second) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(13, second);
        return c.getTime();
    }
}

