/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.payablebill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.business.opservice.payablebill.PledgeApplySaveService;
import kd.tmc.cdm.common.enums.BillMediumEnum;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.PayeeTypeEnum;
import kd.tmc.cdm.common.helper.BankAccountHelper;
import kd.tmc.cdm.common.helper.BaseDataHelper;
import kd.tmc.cdm.common.helper.ListConstructorHelper;
import kd.tmc.cdm.common.helper.PayerHelper;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class PledgeApplyBillEdit
extends AbstractTmcBillEdit {
    private static final BigDecimal STANDARAMOUNT = new BigDecimal("0.01");
    private static Log logger = LogFactory.getLog(PledgeApplySaveService.class);
    private boolean skipPropChange;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((TextEdit)this.getView().getControl("pledgeeaccount")).addButtonClickListener((ClickListener)this);
        this.addPledgeRegisterListener();
        this.fillVisibleAndDataForPledge();
    }

    private void addPledgeRegisterListener() {
        if (this.getModel().getProperty("pledgeebase") != null) {
            BasedataEdit pledgee = (BasedataEdit)this.getControl("pledgeebase");
            String pledgetype = this.getModel().getValue("pledgeetype").toString();
            if (pledgee != null) {
                pledgee.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                    ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    if (StringUtils.equals((CharSequence)pledgetype, (CharSequence)PayeeTypeEnum.BOS_ORG.getValue())) {
                        QFilter filter = new QFilter("fisbankroll", "=", (Object)"1");
                        showParameter.setCustomParam("orgFuncId", (Object)"08");
                        List qfilter = showParameter.getListFilterParameter().getQFilters();
                        qfilter.add(filter);
                    }
                });
            }
        }
    }

    private void fillVisibleAndDataForPledge() {
        Object pledgeType = this.getModel().getValue("pledgeetype");
        if ("other".equals(pledgeType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"pledgeeaccount", "pledgeebase"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"pledgeeaccounttext", "pledgeetext"});
        } else if ("bd_finorginfo".equals(pledgeType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"pledgeeaccount", "pledgeetext"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"pledgeebase", "pledgeeaccounttext"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"pledgeeaccounttext", "pledgeetext"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"pledgeeaccount", "pledgeebase"});
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("pledgeetypebase"))) {
            this.getModel().setValue("pledgeetypebase", (Object)"bd_finorginfo");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
        int size = entrys.size();
        ArrayList<Object> draftBillIds = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            DynamicObject draftBill = ((DynamicObject)entrys.get(i)).getDynamicObject("draftbill");
            BigDecimal billAmt = ((DynamicObject)entrys.get(i)).getBigDecimal("billamt");
            if (EmptyUtil.isEmpty((BigDecimal)billAmt)) {
                this.getModel().setValue("billamt", (Object)draftBill.getBigDecimal("amount"), i);
            }
            draftBillIds.add(draftBill.getPkValue());
        }
        this.getPageCache().put("selectedDraft", JSON.toJSONString(draftBillIds));
        this.fillVisibleAndDataForPledge();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyKey = e.getProperty().getName();
        if (this.skipPropChange) {
            this.skipPropChange = false;
            return;
        }
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int rowIndex = changeData[0].getRowIndex();
        IDataModel model = this.getModel();
        DynamicObject pledgeApplyBill = model.getDataEntity(true);
        block9 : switch (propertyKey) {
            case "pledgeetype": {
                model.setValue("pledgeebase", null);
                this.setPledgeeor();
                model.setValue("pledgeetext", null);
                model.setValue("pledgeebase", null);
                model.setValue("pledgeeopenbank", null);
                model.setValue("pledgeeopenbanknumber", null);
                break;
            }
            case "pledgeeaccount": {
                if (EmptyUtil.isEmpty((Object)newValue)) {
                    this.fillBankDataWhenAccountChange(null, null);
                    break;
                }
                DynamicObject pledgeer = pledgeApplyBill.getDynamicObject("pledgeebase");
                String pledgeType = pledgeApplyBill.getString("pledgeetype");
                if (!EmptyUtil.isEmpty((DynamicObject)pledgeer)) {
                    if (pledgeType.equals("bd_supplier") || pledgeType.equals("bd_customer")) {
                        DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)pledgeer);
                        if (internalOrg != null) {
                            DynamicObject bankAccount = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"bank", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", newValue)});
                            if (!EmptyUtil.isNoEmpty((DynamicObject)bankAccount)) break;
                            DynamicObject bank = bankAccount.getDynamicObject("bank");
                            if (EmptyUtil.isNoEmpty((DynamicObject)bank) && EmptyUtil.isNoEmpty((DynamicObject)bank.getDynamicObject("bebank"))) {
                                Object pkValue = bank.getDynamicObject("bebank").getPkValue();
                                String bankNum = bank.getDynamicObject("bebank").getString("number");
                                this.fillBankDataWhenAccountChange(pkValue, bankNum);
                                break;
                            }
                            this.fillBankDataWhenAccountChange(null, null);
                            break;
                        }
                        DynamicObject pledgeData = TmcDataServiceHelper.loadSingle((Object)pledgeer.getPkValue(), (String)pledgeer.getDataEntityType().getName());
                        DynamicObjectCollection banks = pledgeData.getDynamicObjectCollection("entry_bank");
                        for (DynamicObject bank : banks) {
                            if (bank.getString("bankaccount").equals(newValue.toString())) {
                                Object bankObj = bank.getDynamicObject("bank").getPkValue();
                                String bankNum = bank.getDynamicObject("bank").getString("number");
                                this.fillBankDataWhenAccountChange(bankObj, bankNum);
                                break block9;
                            }
                            this.fillBankDataWhenAccountChange(null, null);
                        }
                        break;
                    }
                    if (pledgeType.equals("bos_org")) {
                        DynamicObject bankAccount = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"bank", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", newValue).and(BankAccountHelper.getNormalBankStatusFilter())});
                        if (!EmptyUtil.isNoEmpty((DynamicObject)bankAccount)) break;
                        DynamicObject bank = bankAccount.getDynamicObject("bank");
                        if (EmptyUtil.isNoEmpty((DynamicObject)bank) && EmptyUtil.isNoEmpty((DynamicObject)bank.getDynamicObject("bebank"))) {
                            Object pkValue = bank.getDynamicObject("bebank").getPkValue();
                            String bankNum = bank.getDynamicObject("bebank").getString("number");
                            this.fillBankDataWhenAccountChange(pkValue, bankNum);
                            break;
                        }
                        this.fillBankDataWhenAccountChange(null, null);
                        break;
                    }
                    if (pledgeType.equals("bos_user")) {
                        DynamicObject erPayeer = TmcDataServiceHelper.loadSingle((String)"er_payeer", (String)"payerbank", (QFilter[])new QFilter[]{new QFilter("payeraccount", "=", newValue), new QFilter("payer.id", "=", pledgeer.getPkValue())});
                        Object pkvalue = erPayeer.getDynamicObject("payerbank").getPkValue();
                        String bankNum = erPayeer.getDynamicObject("payerbank").getString("number");
                        this.fillBankDataWhenAccountChange(pkvalue, bankNum);
                        break;
                    }
                    this.fillBankDataWhenAccountChange(null, null);
                    break;
                }
                this.fillBankDataWhenAccountChange(null, null);
                break;
            }
            case "pledgeeopenbank": {
                if (EmptyUtil.isEmpty((Object)newValue)) break;
                String number = ((DynamicObject)newValue).getString("union_number");
                this.getModel().setValue("pledgeeopenbanknumber", (Object)number);
                break;
            }
            case "pledgeebase": {
                if (EmptyUtil.isEmpty((Object)newValue)) break;
                Object pledgeeType = this.getModel().getValue("pledgeetype");
                if (null == pledgeeType) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d28\u6743\u4eba\u7c7b\u578b", (String)"TradeBillTplEdit_22", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                }
                if (pledgeeType.equals("bd_supplier") || pledgeeType.equals("bd_customer")) {
                    DynamicObject pledgee = TmcDataServiceHelper.loadSingle((Object)((DynamicObject)newValue).getPkValue(), (String)((DynamicObject)newValue).getDataEntityType().getName());
                    DynamicObjectCollection banks = pledgee.getDynamicObjectCollection("entry_bank");
                    if (!EmptyUtil.isEmpty((DynamicObjectCollection)banks)) {
                        boolean hasDefault = false;
                        for (DynamicObject bank : banks) {
                            if (!bank.getBoolean("isdefault_bank") || bank.getDynamicObject("bank") == null) continue;
                            model.setValue("pledgeeaccount", (Object)bank.getString("bankaccount"));
                            Object bankId = bank.getDynamicObject("bank").getPkValue();
                            model.setValue("pledgeeopenbank", bankId);
                            this.queryBebankAndSetUnionNumber(bankId);
                            hasDefault = true;
                            break;
                        }
                        if (hasDefault) break;
                        model.setValue("pledgeeaccount", null);
                        model.setValue("pledgeeopenbank", null);
                        model.setValue("pledgeeopenbanknumber", null);
                        break;
                    }
                    model.setValue("pledgeeaccount", null);
                    model.setValue("pledgeeopenbank", null);
                    model.setValue("pledgeeopenbanknumber", null);
                    break;
                }
                if (pledgeeType.equals("bos_org")) {
                    DynamicObject beendorsor = (DynamicObject)newValue;
                    Object[] bankAccts = TmcDataServiceHelper.load((String)"bd_accountbanks", (String)"bankaccountnumber,bank", (QFilter[])new QFilter[]{new QFilter("company", "in", beendorsor.getPkValue()).and(BankAccountHelper.getNormalBankStatusFilter())});
                    if (!EmptyUtil.isEmpty((Object[])bankAccts)) {
                        model.setValue("pledgeeaccount", (Object)bankAccts[0].getString("bankaccountnumber"));
                        DynamicObject bank = bankAccts[0].getDynamicObject("bank");
                        if (null == bank || !EmptyUtil.isNoEmpty((DynamicObject)bank.getDynamicObject("bebank"))) break;
                        long bebankId = bank.getDynamicObject("bebank").getLong("id");
                        model.setValue("pledgeeopenbank", bank.getDynamicObject("bebank").getPkValue());
                        DynamicObjectCollection bebankDyColl = QueryServiceHelper.query((String)bank.getDynamicObject("bebank").getDataEntityType().getName(), (String)"id,union_number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bebankId)});
                        model.setValue("pledgeeopenbanknumber", (Object)((DynamicObject)bebankDyColl.get(0)).getString("union_number"));
                        break;
                    }
                    model.setValue("pledgeeaccount", null);
                    model.setValue("pledgeeopenbank", null);
                    model.setValue("pledgeeopenbanknumber", null);
                    break;
                }
                if (pledgeeType.equals("bos_user")) {
                    DynamicObject[] erPayers = TmcDataServiceHelper.load((String)"er_payeer", (String)"payeraccount,payerbank", (QFilter[])new QFilter[]{new QFilter("payer.id", "=", pledgeApplyBill.getDynamicObject("pledgeebase").getPkValue()), PayerHelper.getEnablePayerFilter()}, (String)"isdefault desc");
                    if (erPayers.length > 0 && null != erPayers[0].getDynamicObject("payerbank")) {
                        model.setValue("pledgeeaccount", (Object)erPayers[0].getString("payeraccount"));
                        Object payerbankId = erPayers[0].getDynamicObject("payerbank").getPkValue();
                        model.setValue("pledgeeopenbank", payerbankId);
                        this.queryBebankAndSetUnionNumber(payerbankId);
                        break;
                    }
                    model.setValue("pledgeeaccount", null);
                    model.setValue("pledgeeopenbank", null);
                    model.setValue("pledgeeopenbanknumber", null);
                    break;
                }
                if (!pledgeeType.equals("bd_finorginfo")) break;
                DynamicObject[] erPayers = TmcDataServiceHelper.load((String)"bd_finorginfo", (String)"bebank", (QFilter[])new QFilter[]{new QFilter("id", "=", pledgeApplyBill.getDynamicObject("pledgeebase").getPkValue())});
                if (erPayers.length > 0 && null != erPayers[0].getDynamicObject("bebank")) {
                    model.setValue("pledgeeopenbank", erPayers[0].getDynamicObject("bebank").getPkValue());
                    model.setValue("pledgeeopenbanknumber", (Object)erPayers[0].getDynamicObject("bebank").getString("union_number"));
                    break;
                }
                model.setValue("pledgeeopenbank", null);
                model.setValue("pledgeeopenbanknumber", null);
                break;
            }
            case "billamt": {
                DynamicObject draftbill = (DynamicObject)this.getModel().getValue("draftbill", rowIndex);
                if (EmptyUtil.isEmpty((DynamicObject)draftbill)) {
                    this.getView().showErrorNotification(new CdmBizResource().getTipSelectDraftBillShort());
                    return;
                }
                BigDecimal billAmount = draftbill.getBigDecimal("amount");
                if (EmptyUtil.isNoEmpty((Object)newValue)) {
                    BigDecimal splitAmt = (BigDecimal)newValue;
                    if (STANDARAMOUNT.compareTo(splitAmt) > 0 || billAmount.compareTo(splitAmt) < 0) {
                        this.validateSplitAmount(oldValue, rowIndex, billAmount);
                        return;
                    }
                } else {
                    this.validateSplitAmount(oldValue, rowIndex, billAmount);
                    return;
                }
                DynamicObjectCollection selectEntrys = (DynamicObjectCollection)this.getModel().getValue("entrys");
                BigDecimal sumAmount = BigDecimal.ZERO;
                for (DynamicObject selectEntry : selectEntrys) {
                    boolean isInvalid = selectEntry.getBoolean("isinvalid");
                    if (isInvalid) continue;
                    BigDecimal billamt = selectEntry.getBigDecimal("billamt");
                    sumAmount = sumAmount.add(billamt);
                }
                this.getModel().setValue("amount", (Object)sumAmount);
                break;
            }
            case "currency": 
            case "drafttype": {
                this.getModel().deleteEntryData("entrys");
                break;
            }
        }
    }

    private void validateSplitAmount(Object oldValue, int rowIndex, BigDecimal billAmount) {
        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b50\u7968\u5305\u91d1\u989d\u4fee\u6539\u8303\u56f4\u5728 0.01 ~ %s\u4e4b\u95f4\u3002", (String)"TradeBillTplEdit_29", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), billAmount));
        this.skipPropChange = true;
        this.getModel().setValue("billamt", oldValue, rowIndex);
    }

    private void setPledgeeor() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String pledgeeType = model.getDataEntity().getString("pledgeetype");
        if (EmptyUtil.isNoEmpty((String)pledgeeType)) {
            model.setValue("pledgeetypebase", (Object)pledgeeType);
            model.setValue("pledgeeaccount", null);
            this.getModel().setValue("pledgeeaccounttext", (Object)0);
            if (PayeeTypeEnum.OTHER.getValue().equals(pledgeeType) || "bd_finorginfo".equals(pledgeeType)) {
                if ("bd_finorginfo".equals(pledgeeType)) {
                    view.setVisible(Boolean.FALSE, new String[]{"pledgeetext"});
                    view.setVisible(Boolean.TRUE, new String[]{"pledgeebase"});
                } else {
                    view.setVisible(Boolean.TRUE, new String[]{"pledgeetext"});
                    view.setVisible(Boolean.FALSE, new String[]{"pledgeebase"});
                }
                view.setVisible(Boolean.TRUE, new String[]{"pledgeeaccounttext"});
                view.setVisible(Boolean.FALSE, new String[]{"pledgeeaccount"});
            } else {
                view.setVisible(Boolean.TRUE, new String[]{"pledgeebase"});
                view.setVisible(Boolean.TRUE, new String[]{"pledgeeaccount"});
                view.setVisible(Boolean.FALSE, new String[]{"pledgeetext"});
                view.setVisible(Boolean.FALSE, new String[]{"pledgeeaccounttext"});
            }
            DynamicObject draftBillType = (DynamicObject)this.getModel().getValue("drafttype");
            if (null != draftBillType && Objects.equals(draftBillType.get("billmedium"), BillMediumEnum.ELECTRIC.getValue())) {
                boolean isOther = "other".equals(pledgeeType);
                if ("bd_finorginfo".equals(pledgeeType) || "other".equals(pledgeeType)) {
                    this.setPledgeAccountBankMustInput(false, true, true, isOther);
                } else {
                    this.setPledgeAccountBankMustInput(true, false, true, isOther);
                }
            }
        }
    }

    private void setPledgeAccountBankMustInput(boolean isAccountBase, boolean isAccountTxt, boolean isOpenBank, boolean isOther) {
        TextEdit pledgeeCountBase = (TextEdit)this.getControl("pledgeeaccount");
        pledgeeCountBase.setMustInput(isAccountBase);
        TextEdit pledgeAccountTxt = (TextEdit)this.getControl("pledgeeaccounttext");
        pledgeAccountTxt.setMustInput(isAccountTxt);
        BasedataEdit pledgeeopenbankBase = (BasedataEdit)this.getControl("pledgeeopenbank");
        pledgeeopenbankBase.setMustInput(isOpenBank);
    }

    private void fillBankDataWhenAccountChange(Object pkValue, String bankNum) {
        this.getModel().setValue("pledgeeopenbank", pkValue);
        if (EmptyUtil.isNoEmpty((Object)pkValue)) {
            this.queryBebankAndSetUnionNumber(pkValue);
        } else {
            this.getModel().setValue("pledgeeopenbanknumber", (Object)bankNum);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        IDataModel model = this.getModel();
        DynamicObject pledgeApplyBill = model.getDataEntity(true);
        if ("selectdraft".equals(opKey)) {
            DynamicObject company = pledgeApplyBill.getDynamicObject("company");
            if (EmptyUtil.isEmpty((DynamicObject)company)) {
                this.getView().showTipNotification(new CdmBizResource().getTipCompany(), Integer.valueOf(2000));
                args.setCancel(true);
                return;
            }
            DynamicObject draftType = pledgeApplyBill.getDynamicObject("drafttype");
            if (EmptyUtil.isEmpty((DynamicObject)draftType)) {
                this.getView().showTipNotification(new CdmBizResource().getTipDrafttypeShort(), Integer.valueOf(2000));
                args.setCancel(true);
                return;
            }
            DynamicObject currency = pledgeApplyBill.getDynamicObject("currency");
            if (EmptyUtil.isEmpty((DynamicObject)currency)) {
                this.getView().showTipNotification(new CdmBizResource().getTipCurrCheck(), Integer.valueOf(2000));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("selectdraft".equals(operateKey)) {
            ListShowParameter param = ShowFormHelper.createShowListForm((String)"cdm_draftbillf7", (boolean)true, (int)2, (boolean)true);
            param.setShowTitle(false);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectdraft_pledge_action_id"));
            String caption = ResManager.loadKDString((String)"\u6536\u7968\u767b\u8bb0", (String)"TradeBillTplEdit_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
            param.setCaption(caption);
            param.setMultiSelect(true);
            param.getListFilterParameter().setQFilters(this.getPledgeApplyQFilters());
            this.getView().showForm((FormShowParameter)param);
        } else if ("deleteentry".equals(operateKey)) {
            this.sumDraftAmtAndCount();
        } else if (operateKey.equals("save")) {
            ArrayList draftBillIds = new ArrayList();
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
            entrys.stream().filter(p -> !EmptyUtil.isEmpty((DynamicObject)p.getDynamicObject("draftbill"))).forEach(v -> draftBillIds.add(v.getDynamicObject("draftbill").getPkValue()));
            if (!CollectionUtils.isEmpty(draftBillIds)) {
                this.getPageCache().put("selectedDraft", JSON.toJSONString(draftBillIds));
            }
        } else if ("beforeinvalidentry".equals(operateKey)) {
            boolean issubmittrade = (Boolean)this.getModel().getValue("ispushtradebill");
            if (issubmittrade) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u672a\u8fdb\u884c\u63d0\u4ea4\u4e1a\u52a1\u5904\u7406\u7684\u5355\u636e\u7684\u5206\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DiscountApplyBillEdit_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl("entrys");
            int[] selectRows = entryGrid.getSelectRows();
            if (null == selectRows || selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u4f5c\u5e9f\u7684\u5206\u5f55\u3002", (String)"DiscountApplyBillEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entrys");
            boolean hasPayable = false;
            HashSet<Long> draftIdSet = new HashSet<Long>(16);
            for (int selectRow : selectRows) {
                DynamicObject entryData = (DynamicObject)entity.get(selectRow);
                long draftId = entryData.getDynamicObject("draftbill").getLong("id");
                draftIdSet.add(draftId);
                hasPayable = entryData.getBoolean("isinvalid");
                if (hasPayable) break;
            }
            if (hasPayable) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u672a\u8fdb\u884c\u4f5c\u5e9f\u7684\u5206\u5f55\u64cd\u4f5c\u4f5c\u5e9f", (String)"DiscountApplyBillEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            } else if (EmptyUtil.isNoEmpty(draftIdSet)) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("invalidDraftId", SerializationUtils.toJsonString(draftIdSet));
                OperationResult operationResult = this.getView().invokeOperation("invalidentry", operateOption);
                if (!operationResult.isSuccess()) {
                    logger.info("edit operationResult.getMessage:" + operationResult.getMessage());
                }
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        IDataModel model = this.getModel();
        if ("selectdraft_pledge_action_id".equals(actionId)) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            if (EmptyUtil.isEmpty((Collection)rows)) {
                return;
            }
            ArrayList<Object> pks = new ArrayList<Object>();
            rows.stream().filter(o -> EmptyUtil.isNoEmpty((Object)o.getPrimaryKeyValue())).forEach(v -> pks.add(v.getPrimaryKeyValue()));
            this.batchFillEntry(pks);
        } else if (returnData != null && "pledgeBank".equals(actionId)) {
            ListSelectedRowCollection data = (ListSelectedRowCollection)returnData;
            String pledgeeType = this.getModel().getDataEntity().getString("pledgeetype");
            DynamicObject beendorsor = model.getDataEntity().getDynamicObject("pledgeebase");
            String bankAcct = "";
            if (pledgeeType.equals("bd_supplier") || pledgeeType.equals("bd_customer")) {
                Object entryKey = data.getEntryPrimaryKeyValues()[0];
                DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)beendorsor);
                boolean isInternalOrg = BaseDataHelper.isInternalOrg((DynamicObject)this.getModel().getDataEntity().getDynamicObject("company"));
                if (internalOrg != null) {
                    if (isInternalOrg) {
                        DynamicObjectCollection entryBank;
                        DynamicObject bank = TmcDataServiceHelper.loadSingle((String)beendorsor.getDataEntityType().getName(), (String)"bankaccount,bank", (QFilter[])new QFilter[]{new QFilter("entry_bank.id", "=", (Object)Long.valueOf(entryKey.toString()))});
                        if (!EmptyUtil.isEmpty((DynamicObject)bank) && !EmptyUtil.isEmpty((DynamicObjectCollection)(entryBank = bank.getDynamicObjectCollection("entry_bank")))) {
                            for (DynamicObject entry : entryBank) {
                                if (!entry.getPkValue().equals(entryKey)) continue;
                                bankAcct = entry.getString("bankaccount");
                                break;
                            }
                        }
                    } else {
                        Object pkValue = data.getPrimaryKeyValues()[0];
                        DynamicObject bankAccount = TmcDataServiceHelper.loadSingle((Object)pkValue, (String)"bd_accountbanks");
                        bankAcct = bankAccount.getString("bankaccountnumber");
                    }
                } else {
                    DynamicObjectCollection entryBank;
                    DynamicObject bank = TmcDataServiceHelper.loadSingle((String)beendorsor.getDataEntityType().getName(), (String)"bankaccount,bank", (QFilter[])new QFilter[]{new QFilter("entry_bank.id", "=", (Object)Long.valueOf(entryKey.toString()))});
                    if (!EmptyUtil.isEmpty((DynamicObject)bank) && !EmptyUtil.isEmpty((DynamicObjectCollection)(entryBank = bank.getDynamicObjectCollection("entry_bank")))) {
                        for (DynamicObject entry : entryBank) {
                            if (!entry.getPkValue().equals(entryKey)) continue;
                            bankAcct = entry.getString("bankaccount");
                            break;
                        }
                    }
                }
            } else if (pledgeeType.equals("bos_org")) {
                Object pkValue = data.getPrimaryKeyValues()[0];
                DynamicObject bankAccount = TmcDataServiceHelper.loadSingle((Object)pkValue, (String)"bd_accountbanks");
                bankAcct = bankAccount.getString("bankaccountnumber");
            } else if (pledgeeType.equals("bos_user")) {
                Object pkValue = data.getPrimaryKeyValues()[0];
                DynamicObject erPayeer = TmcDataServiceHelper.loadSingle((Object)pkValue, (String)"er_payeer");
                bankAcct = erPayeer.getString("payeraccount");
            }
            model.setValue("pledgeeaccount", (Object)bankAcct);
        }
    }

    private void batchFillEntry(List<Object> draftIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        List draftListIds = draftIds.stream().filter(Objects::nonNull).map(o -> Long.valueOf(o.toString())).collect(Collectors.toList());
        DynamicObject[] drafts = TmcDataServiceHelper.load((String)"cdm_draftbillf7", (String)"acceptername,supperbillamount,amount,draftbilltype,currency,company,draftbillstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", draftListIds)});
        model.forceClearNoDataRow();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("draftbill", new Object[0]);
        vs.addField("billamt", new Object[0]);
        vs.addField("oldstatus", new Object[0]);
        for (int i = 0; i < drafts.length; ++i) {
            DynamicObject draft = drafts[i];
            if (i == 0) {
                model.setValue("drafttype", draft.getDynamicObject("draftbilltype").getPkValue());
                model.setValue("company", draft.getDynamicObject("company").getPkValue());
                this.getView().setEnable(Boolean.FALSE, new String[]{"company"});
            }
            vs.addRow(new Object[]{draft.getPkValue(), draft.getBigDecimal("amount"), draft.getString("draftbillstatus")});
        }
        model.batchCreateNewEntryRow("entrys", vs);
        this.sumDraftAmtAndCount();
    }

    private void sumDraftAmtAndCount() {
        DynamicObject targetBill = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryList = targetBill.getDynamicObjectCollection("entrys");
        BigDecimal totalAmount = entryList.stream().filter(Objects::nonNull).filter(o -> !EmptyUtil.isEmpty((BigDecimal)o.getBigDecimal("billamt")) && !o.getBoolean("isinvalid")).map(o -> o.getBigDecimal("billamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        int count = entryList.stream().filter(v -> !EmptyUtil.isEmpty((DynamicObject)v.getDynamicObject("draftbill"))).toArray().length;
        if (0 == count) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"company"});
        }
        this.getModel().setValue("amount", (Object)totalAmount);
        this.getModel().setValue("draftcount", (Object)count);
    }

    private List<QFilter> getPledgeApplyQFilters() {
        DynamicObject currency;
        DynamicObject draftType;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        IDataModel model = this.getModel();
        DynamicObject pledgeApplyBill = model.getDataEntity(true);
        DynamicObject company = pledgeApplyBill.getDynamicObject("company");
        if (EmptyUtil.isNoEmpty((DynamicObject)company)) {
            qFilters.add(new QFilter("company", "in", company.getPkValue()));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(draftType = pledgeApplyBill.getDynamicObject("drafttype")))) {
            qFilters.add(new QFilter("draftbilltype", "in", draftType.getPkValue()));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(currency = pledgeApplyBill.getDynamicObject("currency")))) {
            qFilters.add(new QFilter("currency", "=", currency.getPkValue()));
        }
        qFilters.add(new QFilter("billpool", "is null", null).or(new QFilter("billpool", "=", (Object)0)));
        ArrayList selectedDaftIds = new ArrayList();
        DynamicObjectCollection selectDraftEntrys = model.getEntryEntity("entrys");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)selectDraftEntrys)) {
            selectDraftEntrys.stream().filter(v -> !EmptyUtil.isEmpty((DynamicObject)v.getDynamicObject("draftbill"))).forEach(v -> selectedDaftIds.add(v.getDynamicObject("draftbill").getPkValue()));
        }
        if (selectedDaftIds.size() > 0) {
            qFilters.add(new QFilter("id", "not in", selectedDaftIds));
        }
        qFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        List draftIds = (List)JSON.parseObject((String)this.getPageCache().get("selectedDraft"), List.class);
        ArrayList targetIds = new ArrayList();
        draftIds.stream().filter(v -> !selectedDaftIds.contains(v)).forEach(o -> targetIds.add(o));
        qFilters.add(new QFilter("availableamount", ">", (Object)0));
        qFilters.add(new QFilter("rptype", "=", (Object)"receivebill"));
        qFilters.add(new QFilter("draftbillstatus", "in", (Object)new String[]{"registered", "collocated"}));
        qFilters.add(new QFilter("draftbilltranstatus", "=", (Object)DraftTranStatusEnum.SUCCESS.getValue()));
        return qFilters;
    }

    public void click(EventObject evt) {
        String keyName;
        super.click(evt);
        Control key = (Control)evt.getSource();
        switch (keyName = key.getKey()) {
            case "pledgeeaccount": {
                this.showBankInfo();
                break;
            }
        }
    }

    private void showBankInfo() {
        IDataModel model = this.getModel();
        DynamicObject pledgeApplyBill = model.getDataEntity(true);
        DynamicObject pledgeeBase = pledgeApplyBill.getDynamicObject("pledgeebase");
        String payeeTypeText = pledgeApplyBill.getString("pledgeetype");
        DynamicObject beendorsor = pledgeApplyBill.getDynamicObject("pledgeebase");
        if (PayeeTypeEnum.OTHER.getValue().equals(payeeTypeText)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u624b\u52a8\u586b\u5199\u8d28\u6743\u4eba\u94f6\u884c\u8d26\u53f7", (String)"TradeBillTplEdit_23", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (EmptyUtil.isEmpty((DynamicObject)pledgeeBase)) {
            this.getView().showTipNotification(new CdmBizResource().getTipPledgeShort());
            return;
        }
        String pledgeEntityType = pledgeeBase.getDataEntityType().getName();
        Object pledgeId = pledgeeBase.getPkValue();
        DynamicObject entity = TmcDataServiceHelper.loadSingle((Object)pledgeId, (String)pledgeEntityType);
        DynamicObjectCollection entryBank = null;
        String msg = "";
        DynamicObject internalOrg = null;
        if ("bd_supplier".equals(payeeTypeText) || "bd_customer".equals(payeeTypeText)) {
            internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)beendorsor);
        }
        ListShowParameter lsp = new ListShowParameter();
        boolean isInternalOrg = BaseDataHelper.isInternalOrg((DynamicObject)pledgeApplyBill.getDynamicObject("company"));
        switch (pledgeEntityType) {
            case "bd_supplier": {
                entryBank = entity.getDynamicObjectCollection("entry_bank");
                if (entryBank.size() < 1 && internalOrg == null) {
                    msg = ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u4f9b\u5e94\u5546\u94f6\u884c\u4fe1\u606f", (String)"TradeBillTplEdit_6", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
                    break;
                }
                if (internalOrg != null) {
                    if (isInternalOrg) {
                        lsp = ListConstructorHelper.getSupplierBankInfoShowParameter((Object)pledgeId);
                        break;
                    }
                    long orgID = internalOrg.getPkValue() == null ? 0L : Long.parseLong(internalOrg.getPkValue().toString());
                    QFilter filter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgID);
                    boolean isExists = TmcDataServiceHelper.exists((String)"bd_accountbanks", (QFilter[])new QFilter[]{filter});
                    if (isExists) {
                        lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((QFilter)filter);
                        break;
                    }
                    msg = ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u94f6\u884c\u4fe1\u606f", (String)"TradeBillTplEdit_9", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
                    break;
                }
                lsp = ListConstructorHelper.getSupplierBankInfoShowParameter((Object)pledgeId);
                break;
            }
            case "bd_customer": {
                entryBank = entity.getDynamicObjectCollection("entry_bank");
                if (entryBank.size() < 1 && internalOrg == null) {
                    msg = ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u5ba2\u6237\u94f6\u884c\u4fe1\u606f", (String)"TradeBillTplEdit_7", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
                    break;
                }
                if (internalOrg != null) {
                    if (isInternalOrg) {
                        lsp = ListConstructorHelper.getCustomerBankInfoShowParameter((Object)pledgeId);
                        break;
                    }
                    long orgID = internalOrg.getPkValue() == null ? 0L : Long.parseLong(internalOrg.getPkValue().toString());
                    QFilter filter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgID);
                    boolean isExists = TmcDataServiceHelper.exists((String)"bd_accountbanks", (QFilter[])new QFilter[]{filter});
                    if (isExists) {
                        lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((QFilter)filter);
                        break;
                    }
                    msg = ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u94f6\u884c\u4fe1\u606f", (String)"TradeBillTplEdit_9", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
                    break;
                }
                lsp = ListConstructorHelper.getCustomerBankInfoShowParameter((Object)pledgeId);
                break;
            }
            case "bos_org": {
                long orgID = beendorsor == null ? 0L : Long.parseLong(beendorsor.getPkValue().toString());
                QFilter filter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgID).and(BankAccountHelper.getNormalBankStatusFilter());
                boolean isExists = TmcDataServiceHelper.exists((String)"bd_accountbanks", (QFilter[])new QFilter[]{filter});
                if (isExists) {
                    lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((QFilter)filter);
                    break;
                }
                msg = ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u94f6\u884c\u4fe1\u606f", (String)"TradeBillTplEdit_9", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "bos_user": {
                boolean exists = TmcDataServiceHelper.exists((String)"er_payeer", (QFilter[])new QFilter[]{new QFilter("payer.id", "in", pledgeId)});
                if (exists) {
                    lsp = ListConstructorHelper.getErPayeerAcctShowParameter((Object)pledgeId);
                    break;
                }
                msg = ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u804c\u5458\u6536\u6b3e\u4fe1\u606f", (String)"TradeBillTplEdit_10", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "other": {
                lsp = null;
                break;
            }
        }
        if (!EmptyUtil.isEmpty((String)msg)) {
            this.getView().showTipNotification(msg, Integer.valueOf(2000));
        } else if (lsp != null) {
            String actionId = "pledgeBank";
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    private void queryBebankAndSetUnionNumber(Object pkValue) {
        Object[] bd_bebankArr;
        if (EmptyUtil.isNoEmpty((Object)pkValue) && EmptyUtil.isNoEmpty((Object[])(bd_bebankArr = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,number,union_number", (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)})))) {
            String union_number = bd_bebankArr[0].getString("union_number");
            this.getModel().setValue("pledgeeopenbanknumber", (Object)union_number);
        }
    }
}

