/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.receivablebill;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.cdm.common.constant.CdmBizConstant;
import kd.tmc.cdm.common.enums.BillEndorseTypeEnum;
import kd.tmc.cdm.common.enums.BillMediumEnum;
import kd.tmc.cdm.common.enums.BillTypeUnitEnum;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.PayeeTypeEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.helper.BankAccountHelper;
import kd.tmc.cdm.common.helper.BaseDataHelper;
import kd.tmc.cdm.common.helper.CdmCommonHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.GuaranteeHelper;
import kd.tmc.cdm.common.helper.ListConstructorHelper;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.common.enums.AcctClassifyEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class ReceivableBillEdit
extends AbstractTmcBillEdit {
    private static Log logger = LogFactory.getLog(ReceivableBillEdit.class);
    private boolean skip = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((TextEdit)this.getView().getControl("deliveraccountbase")).addButtonClickListener((ClickListener)this);
        this.companyRegisterListener();
        this.deliverRegisterListener();
        this.drawerRegisterListener();
        this.draweraccountnameRegisterListener();
        this.receiveraccountRegisterListener();
        this.deliverAccountBaseRegisterListener();
        this.bankAccountRegisterListener();
        this.subbillRegisterListener();
        DynamicObject draftbilltypeDO = (DynamicObject)this.getModel().getValue("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltypeDO)) {
            String settlementtype = draftbilltypeDO.getString("settlementtype");
            if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue()) || StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue())) {
                this.getModel().setValue("issplit", (Object)Character.valueOf('0'));
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"issplit"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"issplit"});
            }
        }
    }

    private void subbillRegisterListener() {
        this.fillBillAmount();
        Object issplit = this.getModel().getValue("issplit");
        if (Boolean.parseBoolean(issplit.toString())) {
            this.setFlagData();
        } else {
            this.setSubBillInfoWhenCannotSplit();
        }
    }

    private void setSubBillInfoWhenCannotSplit() {
        this.getModel().setValue("supperbillamount", this.getModel().getValue("amount"));
        this.getModel().setValue("subbillrange", (Object)0);
        this.getModel().setValue("subbillquantity", (Object)0L);
        this.skip = true;
        this.getModel().setValue("subbillstartflag", (Object)0L);
        this.skip = true;
        this.getModel().setValue("subbillendflag", (Object)0L);
        this.skip = false;
        ((FieldEdit)this.getView().getControl("subbillstartflag")).setMustInput(false);
        ((FieldEdit)this.getView().getControl("subbillendflag")).setMustInput(false);
        this.setOriginalInfo();
    }

    private void setOtherSubData() {
        long subbillstartflag = (Long)this.getModel().getValue("subbillstartflag");
        long subbillEndflag = (Long)this.getModel().getValue("subbillendflag");
        if (subbillEndflag < subbillstartflag) {
            return;
        }
        this.getModel().setValue("subbillrange", (Object)(subbillstartflag + "-" + subbillEndflag));
        this.getModel().setValue("subbillquantity", (Object)(subbillEndflag - subbillstartflag + 1L));
        BigDecimal standardbillamount = new BigDecimal(this.getModel().getValue("standardbillamount").toString());
        BigDecimal subbillquantity = new BigDecimal(this.getModel().getValue("subbillquantity").toString());
        BigDecimal subbillamount = standardbillamount.multiply(subbillquantity);
        this.skip = true;
        this.getModel().setValue("amount", (Object)subbillamount);
        this.getModel().setValue("supperbillamount", (Object)subbillamount);
        this.setOriginalInfo();
    }

    private void setFlagData() {
        Object subbillEndflag = this.getModel().getValue("subbillendflag");
        Object subbillstartflag = this.getModel().getValue("subbillstartflag");
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        BigDecimal standardbillamount = (BigDecimal)this.getModel().getValue("standardbillamount");
        if (EmptyUtil.isEmpty((Object)subbillstartflag)) {
            this.skip = true;
            this.getModel().setValue("subbillstartflag", (Object)1L);
        }
        if (EmptyUtil.isEmpty((Object)subbillEndflag) && standardbillamount.compareTo(amount) <= 0) {
            long endFlag = amount.multiply(new BigDecimal("100")).longValue() - (Long)this.getModel().getValue("subbillstartflag") + 1L;
            this.skip = true;
            this.getModel().setValue("subbillendflag", (Object)endFlag);
        }
        ((FieldEdit)this.getView().getControl("subbillstartflag")).setMustInput(true);
        ((FieldEdit)this.getView().getControl("subbillendflag")).setMustInput(true);
    }

    private void bankAccountRegisterListener() {
        BasedataEdit bankAccountEdit = (BasedataEdit)this.getControl("bankaccount");
        if (bankAccountEdit != null) {
            bankAccountEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                DynamicObject company = this.getModel().getDataEntity().getDynamicObject("company");
                QFilter innerAcctFilter = new QFilter("acctclassify", "!=", (Object)AcctClassifyEnum.INNER_ACCOUNT.getValue());
                QFilter companyFilter = new QFilter("acctstatus", "not in", (Object)new String[]{"closed", "changing"});
                long orgID = company == null ? 0L : Long.parseLong(company.getPkValue().toString());
                QFilter accountAuthAssignFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgID);
                showParameter.getListFilterParameter().setFilter(innerAcctFilter.and(companyFilter).and(accountAuthAssignFilter));
            });
        }
    }

    public void afterBindData(EventObject e) {
        Object modifyData;
        Object onlyView;
        super.afterBindData(e);
        this.fillBillAmount();
        if (SourceEnum.CAS.getValue().equals(this.getModel().getValue("source")) && (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus()) || OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus()))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"amount"});
            Object casAmount = this.getModel().getValue("casamount");
            if (EmptyUtil.isEmpty((Object)casAmount)) {
                this.getModel().setValue("casamount", (Object)"amount");
            }
        }
        if (SourceEnum.CAS.getValue().equals(this.getModel().getValue("source")) && OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            Object value = this.getModel().getValue("draftbillexpiredate");
            if (EmptyUtil.isEmpty((Object)value)) {
                this.issuedateChange();
            }
            this.fillAccepterAccountDataEnable(this.getModel().getValue("draftbilltype"));
        }
        if ((onlyView = this.getView().getFormShowParameter().getCustomParams().get("onlyView")) != null && "onlyView".equals(onlyView)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_del", "bar_save", "bar_submit", "bar_print", "bar_refresh"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"contentpanelflex"});
        }
        if ((modifyData = this.getView().getFormShowParameter().getCustomParams().get("modifydata")) != null && ((Boolean)modifyData).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"draftbillno"});
        }
        this.setVisible(this.getModel().getValue("draftbilltype"));
        this.setAcceptDate();
        if (this.getView().getFormShowParameter().getCustomParam("modifydata") != null) {
            this.setBillStatus();
        }
        this.setEleStatus();
        if (DraftHelper.needToHideToolForRecAndPayBill((String)((String)this.getView().getFormShowParameter().getCustomParam("sourceBill")))) {
            this.setToolBarVisible();
        }
    }

    private void setToolBarVisible() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_del", "bar_save", "bar_submit", "bar_unsubmit", "bar_audit", "bar_unaudit", "generatevoucher", "bar_process", "bar_endorse", "bar_print", "bar_refresh"});
    }

    private void fillBillAmount() {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("supperbillamount"))) {
            this.getModel().setValue("supperbillamount", this.getModel().getValue("amount"));
        }
    }

    private void fillAccepterAccountData(Object draftbilltype) {
        if (EmptyUtil.isNoEmpty((Object)draftbilltype)) {
            DynamicObject draftbilltypeDO = (DynamicObject)draftbilltype;
            String settlementtype = draftbilltypeDO.getString("settlementtype");
            Object accpterAcc = this.getModel().getValue("accepteraccount");
            DynamicObject accpterBase = (DynamicObject)this.getModel().getValue("accepterbebank");
            if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                if (EmptyUtil.isEmpty((Object)accpterAcc)) {
                    this.getModel().setValue("accepteraccount", (Object)"0");
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)accpterBase)) {
                    this.getModel().setValue("accepterbank", accpterBase.getPkValue());
                }
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"accepterbank"});
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) {
                Object drawerAcc = this.getModel().getValue("draweraccountname");
                this.getModel().setValue("accepteraccount", drawerAcc);
                Object drawerBank = this.getModel().getValue("drawerbank");
                this.getModel().setValue("accepterbank", drawerBank);
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"accepterbank"});
                if (EmptyUtil.isNoEmpty((Object)drawerBank)) {
                    DynamicObject drawerBankdy = (DynamicObject)drawerBank;
                    String number = drawerBankdy.getString("union_number");
                    this.getModel().setValue("accepterbankno", (Object)number);
                    this.getModel().setValue("accepterbankname", (Object)drawerBankdy.getString("name"));
                }
            }
        }
    }

    private void fillAccepterAccountDataEnable(Object draftbilltype) {
        if (EmptyUtil.isNoEmpty((Object)draftbilltype)) {
            DynamicObject draftbilltypeDO = (DynamicObject)draftbilltype;
            String settlementtype = draftbilltypeDO.getString("settlementtype");
            if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"accepterbank"});
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"accepterbank"});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        switch (operateKey) {
            case "transer": {
                Boolean isTransfer = (Boolean)this.getModel().getValue("istransfer");
                if (isTransfer == null || !isTransfer.booleanValue()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u80fd\u5426\u8f6c\u8ba9\u201d\u4e3a\u5426\u7684\u7968\u636e\u4e0d\u5141\u8bb8\u8fdb\u884c\u80cc\u4e66\u8f6c\u8ba9\u64cd\u4f5c\u3002", (String)"ReceivableBillEdit_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.transerOperate(operationResult, "endorse");
                break;
            }
            case "discount": {
                this.transerOperate(operationResult, "discount");
                break;
            }
            case "pledge": {
                this.transerOperate(operationResult, "pledge");
                break;
            }
            case "collect": {
                this.transerOperate(operationResult, "collect");
                break;
            }
            case "mandator": {
                this.transerOperate(operationResult, "trusteeship");
                break;
            }
            case "refund": {
                this.transerOperate(operationResult, "refund");
                break;
            }
            case "retrieve": {
                this.transerOperate(operationResult, "retrieve");
                break;
            }
            case "rlspledge": {
                this.transerOperate(operationResult, "rlspledge");
                break;
            }
            case "audit": {
                this.setButtonView();
                break;
            }
            case "unaduit": {
                this.rebackButtonView();
                break;
            }
            case "billsplitsub": {
                Boolean isSplit = (Boolean)this.getModel().getValue("issplit");
                if (isSplit == null || !isSplit.booleanValue()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7968\u636e\u62c6\u5206\u3002", (String)"ReceivableBillEdit_15", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.transerOperate(operationResult, "billsplit");
                break;
            }
            case "payinterestdeal": {
                Boolean isPayInterest = (Boolean)this.getModel().getValue("ispayinterest");
                if (isPayInterest != null && isPayInterest.booleanValue()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e70\u65b9\u4ed8\u606f\u7684\u7968\u636e\u4e0d\u80fd\u518d\u8fdb\u884c\u4e70\u65b9\u4ed8\u606f\u64cd\u4f5c\u3002", (String)"ReceivableBillEdit_16", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.transerOperate(operationResult, "payinterest");
                break;
            }
            case "guarantee": 
            case "unguarantee": {
                DynamicObject bill = this.getModel().getDataEntity(true);
                HashMap<String, Object> param = new HashMap<String, Object>();
                HashMap<String, Object> customParam = new HashMap<String, Object>();
                customParam.put("biztype", operateKey);
                customParam.put("billIds", Collections.singletonList(bill.getPkValue()));
                customParam.put("sourceBillId", bill.getPkValue());
                param.put("customParam", customParam);
                param.put("formId", "cdm_guarantee_discount");
                param.put("showType", ShowType.MainNewTabPage);
                CdmCommonHelper.showWebBill(param, (AbstractFormPlugin)this);
                break;
            }
        }
        if (SourceEnum.CAS.getValue().equals(this.getModel().getValue("source")) && "A".equalsIgnoreCase((String)this.getModel().getValue("billstatus"))) {
            Object object = (Boolean)this.getModel().getValue("issplit");
        }
        if (EmptyUtil.isNoEmpty((Object)operationResult) && operationResult.isSuccess() && ("save".equals(operateKey) || "submit".equals(operateKey))) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "endorseadd": {
                this.dialogEndorseInfoWindow(false);
                args.setCancel(true);
                break;
            }
            case "endorseedit": {
                this.dialogEndorseInfoWindow(true);
                args.setCancel(true);
                break;
            }
            case "guarantee": 
            case "unguarantee": {
                DynamicObject bill = this.getModel().getDataEntity(true);
                Object id = bill.getPkValue();
                HashSet<Object> idSet = new HashSet<Object>(8);
                idSet.add(id);
                String result = GuaranteeHelper.validatedGuaranteeTrade(idSet, (String)ReceivePayTypeEnum.RECEIVEBILL.getValue(), (String)operateKey);
                if (EmptyUtil.isNoEmpty((String)result)) {
                    this.getView().showTipNotification(result);
                    args.setCancel(true);
                    break;
                }
                result = GuaranteeHelper.validatedIsReleaseGuaranteeBill(idSet, (String)operateKey);
                if (!EmptyUtil.isNoEmpty((String)result)) break;
                this.getView().showTipNotification(result);
                args.setCancel(true);
                break;
            }
        }
    }

    private void rebackButtonView() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_transer", "bar_disount", "bar_pledge", "bar_collect", "bar_refund", "bar_mandator", "bar_billsplit"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)"bar_save", (CharSequence)itemKey)) {
            evt.setCancel(true);
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("op_from_edit", "y");
            this.getView().invokeOperation("save", operateOption);
        } else if (StringUtils.equals((CharSequence)"bar_unaudit", (CharSequence)itemKey)) {
            Boolean isVoucherGen = (Boolean)this.getModel().getValue("isvoucher");
            logger.info("isVoucher is:" + isVoucherGen);
            if (isVoucherGen.booleanValue()) {
                String billnoStr = this.getModel().getValue("billno").toString();
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"(%s)\u5355\u636e\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1 ,\u662f\u5426\u7ee7\u7eed\u53cd\u5ba1\u6838\uff1f", (String)"ReceivableBillEdit_17", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), billnoStr), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_UNAUDITBILLREC_CALLBACK", (IFormPlugin)this));
                evt.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"delete", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("delete");
        } else if ("CONFIRM_UNAUDITBILLREC_CALLBACK".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getView().invokeOperation("unaudit");
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("btnendorseadd".equals(actionId)) {
            this.endorseInfoCloseCallBack(e, false);
        } else if ("btnendorseedit".equals(actionId)) {
            this.endorseInfoCloseCallBack(e, true);
        } else {
            ListSelectedRow row;
            ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
            if (rows != null && EmptyUtil.isNoEmpty((Object)(row = rows.get(0)))) {
                switch (actionId) {
                    case "company": {
                        this.companyCloseCallBack(row);
                        break;
                    }
                    case "deliver": {
                        this.deliverCloseCallBack(row);
                        break;
                    }
                    case "drawer": {
                        this.drawerCloseCallBack(row);
                        break;
                    }
                    case "draweraccountname": {
                        this.draweraccountnameCloseCallBack(row, false);
                        break;
                    }
                    case "receiveraccount": {
                        this.receiveraccountCloseCallBack(row);
                        break;
                    }
                    case "deliveraccountbase": {
                        this.draweraccountnameCloseCallBack(row, true);
                    }
                }
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setButtonView();
        this.setEndorseInfo();
        this.setBankAccountMustInput();
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject bdBebankDO;
        this.issuedateChange();
        DynamicObject companyDO = this.getModel().getDataEntity().getDynamicObject("company");
        if (EmptyUtil.isNoEmpty((DynamicObject)companyDO)) {
            DynamicObject baseCurrency;
            boolean isSecondHandBill = DraftHelper.getCdmParameterBoolean((long)companyDO.getLong("id"), (String)"issecondhandbill");
            if (!isSecondHandBill) {
                this.getModel().setValue("receivername", (Object)companyDO.getString("name"));
            }
            if (!EmptyUtil.isEmpty((DynamicObject)(baseCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)((Long)companyDO.getPkValue()))))) {
                this.getModel().setValue("currency", baseCurrency.getPkValue());
            }
        }
        ((FieldEdit)this.getView().getControl("deliver")).setMustInput(true);
        Object draftbilltype = this.getModel().getValue("draftbilltype");
        FormShowParameter sp = this.getView().getFormShowParameter();
        OperationStatus status = sp.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.fillAccepterAccountData(draftbilltype);
        }
        Object accpterBankName = this.getModel().getValue("accepterbankname");
        Object accpterBankBase = this.getModel().getValue("accepterbank");
        if (EmptyUtil.isNoEmpty((Object)accpterBankName) && EmptyUtil.isEmpty((Object)accpterBankBase) && EmptyUtil.isNoEmpty((DynamicObject)(bdBebankDO = TmcDataServiceHelper.loadSingle((String)"bd_bebank", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", accpterBankName)})))) {
            this.getModel().setValue("accepterbank", bdBebankDO.getPkValue());
        }
        this.setAcceptDateMust(draftbilltype);
        this.setEleStatus();
    }

    private void setEleStatus() {
        DynamicObject draftbilltype = (DynamicObject)this.getModel().getValue("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltype)) {
            String billMedium = draftbilltype.getString("billmedium");
            if (BillMediumEnum.ELECTRIC.getValue().equals(billMedium)) {
                boolean issplit = (Boolean)this.getModel().getValue("issplit");
                if (issplit) {
                    Object eledraftstatusnew = this.getModel().getValue("eledraftstatusnew");
                    Object elccirculatestatus = this.getModel().getValue("elccirculatestatus");
                    if (EmptyUtil.isEmpty((Object)eledraftstatusnew)) {
                        this.getModel().setValue("eledraftstatusnew", (Object)"CS03");
                    }
                    if (EmptyUtil.isEmpty((Object)elccirculatestatus)) {
                        this.getModel().setValue("elccirculatestatus", (Object)"TF0301");
                    }
                }
            } else {
                this.getModel().setValue("eledraftstatusnew", null);
                this.getModel().setValue("elccirculatestatus", null);
            }
        }
    }

    private void setAcceptDateMust(Object draftBillTypeObj) {
        if (!EmptyUtil.isEmpty((Object)draftBillTypeObj)) {
            DynamicObject draftBillType = (DynamicObject)draftBillTypeObj;
            String settlementType = draftBillType.getString("settlementtype");
            Date issueDate = (Date)this.getModel().getValue("issuedate");
            if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue()) || StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"acceptdate"});
                this.getModel().setValue("acceptdate", (Object)issueDate);
                ((DateEdit)this.getView().getControl("acceptdate")).setMustInput(true);
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"acceptdate"});
                ((DateEdit)this.getView().getControl("acceptdate")).setMustInput(false);
            }
        }
    }

    private void setAcceptDate() {
        DynamicObject draftBillType = this.getModel().getDataEntity().getDynamicObject("draftbilltype");
        long sourceBillId = (Long)this.getModel().getValue("sourcebillid");
        if (!EmptyUtil.isEmpty((DynamicObject)draftBillType)) {
            String settlementType;
            if (!EmptyUtil.isEmpty((Long)sourceBillId) && sourceBillId > 0L && EmptyUtil.isEmpty((Object)this.getModel().getValue("acceptdate"))) {
                this.setAcceptDateMust(draftBillType);
            }
            if (StringUtils.equals((CharSequence)(settlementType = draftBillType.getString("settlementtype")), (CharSequence)SettleMentTypeEnum.BUSINESS.getValue()) || StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"acceptdate"});
                ((DateEdit)this.getView().getControl("acceptdate")).setMustInput(true);
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"acceptdate"});
                ((DateEdit)this.getView().getControl("acceptdate")).setMustInput(false);
            }
        }
    }

    private void setBankAccountMustInput() {
        DynamicObject draftBillType = (DynamicObject)this.getModel().getValue("draftbilltype");
        if (Objects.nonNull(draftBillType)) {
            FieldEdit bankAccountEdit = (FieldEdit)this.getControl("bankaccount");
            if (Objects.equals(draftBillType.get("billmedium"), BillMediumEnum.ELECTRIC.getValue())) {
                bankAccountEdit.setMustInput(true);
            } else {
                bankAccountEdit.setMustInput(false);
            }
        }
    }

    private void setButtonView() {
        String draftbillstatus = this.getModel().getValue("draftbillstatus").toString();
        DynamicObject draftbilltypeDO = this.getModel().getDataEntity().getDynamicObject("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltypeDO)) {
            String settlementtype = draftbilltypeDO.getString("settlementtype");
            if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BANK.getValue()) || StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) {
                if (StringUtils.equals((CharSequence)draftbillstatus, (CharSequence)DraftBillStatusEnum.REGISTERED.getValue())) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_retrieve", "bar_rlspledge"});
                } else if (StringUtils.equals((CharSequence)draftbillstatus, (CharSequence)DraftBillStatusEnum.COLLOCATED.getValue())) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_rlspledge", "bar_mandator", "bar_refund"});
                } else if (StringUtils.equals((CharSequence)draftbillstatus, (CharSequence)DraftBillStatusEnum.PLEDGED.getValue())) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_transer", "bar_disount", "bar_pledge", "bar_retrieve", "bar_refund", "bar_mandator"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_process"});
                }
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue()) || StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue())) {
                if (StringUtils.equals((CharSequence)draftbillstatus, (CharSequence)DraftBillStatusEnum.REGISTERED.getValue())) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_disount", "bar_retrieve", "bar_rlspledge", "bar_mandator", "bar_billsplit"});
                } else if (StringUtils.equals((CharSequence)draftbillstatus, (CharSequence)DraftBillStatusEnum.PLEDGED.getValue())) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_transer", "bar_disount", "bar_pledge", "bar_retrieve", "bar_refund", "bar_mandator", "bar_billsplit"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_process"});
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] valSet = e.getChangeSet();
        Object propValue = valSet[0].getNewValue();
        Object oldPropValue = valSet[0].getOldValue();
        Object draftbilltype = this.getModel().getValue("draftbilltype");
        boolean isModifyData = false;
        if (this.getView().getFormShowParameter().getCustomParam("modifydata") != null) {
            isModifyData = true;
        }
        if ("locamt".equals(key)) {
            return;
        }
        if (this.skip) {
            this.skip = false;
            return;
        }
        switch (key) {
            case "issuedate": {
                this.issuedateChange();
                break;
            }
            case "draftbilltype": {
                this.setVisible(draftbilltype);
                this.draftbilltypeChange(e, draftbilltype);
                this.setBankAccountMustInput();
                this.fillAccepterAccountData(draftbilltype);
                this.setAcceptDateMust(draftbilltype);
                this.setEleStatus();
                break;
            }
            case "draftbillexpiredate": {
                this.draftbillexpiredateChange(e);
                break;
            }
            case "deliver": {
                this.deliverChange(draftbilltype);
                break;
            }
            case "deliveraccountbase": {
                if (EmptyUtil.isEmpty((Object)propValue)) {
                    this.fillBankDataWhenAccountChange(null, null);
                    break;
                }
                this.fillOpenBankAndNum(propValue);
                break;
            }
            case "drawer": {
                this.drawerChange(draftbilltype);
                break;
            }
            case "drawerbank": {
                this.drawerbankChange(draftbilltype);
                break;
            }
            case "receiverbank": {
                this.receiverbankChange(draftbilltype);
                break;
            }
            case "drawername": {
                this.drawernameChange(draftbilltype);
                break;
            }
            case "payeetype": {
                this.payeetypeChange();
                break;
            }
            case "receivername": {
                this.getModel().setValue("receiveraccount", null);
                this.getModel().setValue("receiverbank", null);
                this.getModel().setValue("receiverbankno", null);
                break;
            }
            case "accepterbebank": {
                DynamicObject accepterBeBank = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (!Objects.nonNull(accepterBeBank)) break;
                this.getModel().setValue("accepterbankname", accepterBeBank.get("name"));
                this.getModel().setValue("accepterbank", accepterBeBank.getPkValue());
                this.getModel().setValue("accepterbankno", accepterBeBank.get("union_number"));
                this.getModel().setValue("acceptername", accepterBeBank.get("name"));
                break;
            }
            case "accepterbank": {
                DynamicObject accepterBank = (DynamicObject)propValue;
                if (!Objects.nonNull(accepterBank)) break;
                this.getModel().setValue("accepterbankname", accepterBank.get("name"));
                this.getModel().setValue("accepterbankno", accepterBank.get("union_number"));
                break;
            }
            case "subbillstartflag": {
                if (isModifyData) {
                    long subbillstartflag = (Long)this.getModel().getValue("subbillstartflag");
                    long subbillEndflag = (Long)this.getModel().getValue("subbillendflag");
                    this.getModel().setValue("subbillrange", (Object)(subbillstartflag + "-" + subbillEndflag));
                    this.getModel().setValue("subbillquantity", (Object)(subbillEndflag - subbillstartflag + 1L));
                    break;
                }
                long endFlag = (Long)this.getModel().getValue("subbillendflag");
                long value = (Long)propValue;
                if (value > endFlag) {
                    this.skip = true;
                    this.getModel().setValue("subbillstartflag", (Object)0L);
                    this.setLockSubInfo();
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b50\u7968\u5305\u5f00\u59cb\u6807\u8bc6\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6807\u8bc6\u3002", (String)"ReceivableEdit_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (value < 1L) {
                    this.skip = true;
                    this.getModel().setValue("subbillstartflag", (Object)0L);
                    this.setLockSubInfo();
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b50\u7968\u5305\u5f00\u59cb\u6807\u8bc6\u53ea\u80fd\u662f\u5927\u4e8e0\u7684\u6574\u6570\u3002", (String)"ReceivableEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.setOtherSubData();
                break;
            }
            case "subbillendflag": {
                long endValue;
                if (null == propValue) break;
                if (isModifyData) {
                    long subbillstartflag = (Long)this.getModel().getValue("subbillstartflag");
                    long subbillEndflag = (Long)this.getModel().getValue("subbillendflag");
                    this.getModel().setValue("subbillrange", (Object)(subbillstartflag + "-" + subbillEndflag));
                    this.getModel().setValue("subbillquantity", (Object)(subbillEndflag - subbillstartflag + 1L));
                    break;
                }
                long startFlag = (Long)this.getModel().getValue("subbillstartflag");
                if (startFlag > (endValue = ((Long)propValue).longValue())) {
                    this.skip = true;
                    this.getModel().setValue("subbillendflag", (Object)0L);
                    this.setLockSubInfo();
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b50\u7968\u5305\u5f00\u59cb\u6807\u8bc6\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6807\u8bc6\u3002", (String)"ReceivableEdit_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (endValue < 1L) {
                    this.skip = true;
                    this.getModel().setValue("subbillendflag", (Object)0L);
                    this.setLockSubInfo();
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b50\u7968\u5305\u7ed3\u675f\u6807\u8bc6\u53ea\u80fd\u662f\u5927\u4e8e0\u7684\u6574\u6570\u3002", (String)"ReceivableEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.setOtherSubData();
                break;
            }
            case "issplit": {
                if (null == propValue) break;
                Object source = this.getModel().getValue("source");
                if (((Boolean)propValue).booleanValue()) {
                    this.setFlagData();
                    this.setOtherSubData();
                    this.setEleStatus();
                    if (!EmptyUtil.isNoEmpty((Object)source) || !"cas".equalsIgnoreCase(source.toString())) break;
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"supperbillamount"});
                    break;
                }
                this.setSubBillInfoWhenCannotSplit();
                if (!EmptyUtil.isNoEmpty((Object)source) || !"cas".equalsIgnoreCase(source.toString())) break;
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"supperbillamount"});
                break;
            }
            case "amount": {
                BigDecimal propValueAmount;
                if (null == propValue) break;
                this.getModel().setValue("supperbillamount", this.getModel().getValue("amount"));
                boolean isSplit = (Boolean)this.getModel().getValue("issplit");
                if (!isSplit) {
                    this.getModel().setValue("supperbillamount", this.getModel().getValue("amount"));
                    this.setOriginalInfo();
                    break;
                }
                Object subStandAmount = this.getModel().getValue("standardbillamount");
                BigDecimal standardbillamount = new BigDecimal(subStandAmount.toString());
                if (standardbillamount.compareTo(propValueAmount = new BigDecimal(propValue.toString())) <= 0) {
                    BigDecimal amount = new BigDecimal(propValue.toString()).divide(standardbillamount);
                    this.skip = true;
                    this.getModel().setValue("subbillstartflag", (Object)1L);
                    this.skip = true;
                    this.getModel().setValue("subbillendflag", (Object)amount.longValue());
                    this.setOtherSubData();
                    break;
                }
                this.skip = true;
                this.getModel().setValue("amount", null);
                this.getModel().setValue("supperbillamount", null);
                this.setOriginalInfo();
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7968\u9762\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u5b50\u7968\u5305\u6807\u51c6\u91d1\u989d %s\u3002", (String)"ReceivableEdit_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), subStandAmount));
                break;
            }
            case "deliveropenbank": {
                if (null == propValue) {
                    this.getModel().setValue("deliveropenbanknum", null);
                    break;
                }
                DynamicObject deliveropenbank = (DynamicObject)propValue;
                String union_numberStr = deliveropenbank.getString("number");
                this.getModel().setValue("deliveropenbanknum", (Object)union_numberStr);
                break;
            }
            case "draweraccountname": {
                if (!EmptyUtil.isNoEmpty((Object)propValue)) break;
                this.fillAccepterAccountData(draftbilltype);
                break;
            }
            case "draftbillno": {
                this.setOriginalInfo();
                break;
            }
        }
    }

    private void setLockSubInfo() {
        this.getModel().setValue("amount", (Object)0);
        this.getModel().setValue("subbillrange", (Object)0);
        this.getModel().setValue("subbillquantity", (Object)0L);
    }

    private void fillOpenBankAndNum(Object propValue) {
        DynamicObject deliverDO = this.getModel().getDataEntity().getDynamicObject("deliver");
        Object deliverType = this.getModel().getValue("delivertype");
        if (!EmptyUtil.isEmpty((DynamicObject)deliverDO)) {
            if (deliverType.equals("bd_supplier") || deliverType.equals("bd_customer")) {
                DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)deliverDO);
                if (internalOrg != null) {
                    DynamicObject bankAccount = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"bank", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", propValue)});
                    if (EmptyUtil.isNoEmpty((DynamicObject)bankAccount)) {
                        DynamicObject bank = bankAccount.getDynamicObject("bank");
                        if (EmptyUtil.isNoEmpty((DynamicObject)bank) && EmptyUtil.isNoEmpty((DynamicObject)bank.getDynamicObject("bebank"))) {
                            Object pkValue = bank.getDynamicObject("bebank").getPkValue();
                            String bankNum = bank.getDynamicObject("bebank").getString("number");
                            this.fillBankDataWhenAccountChange(pkValue, bankNum);
                        } else {
                            this.fillBankDataWhenAccountChange(null, null);
                        }
                    }
                } else {
                    DynamicObject pledgeData = TmcDataServiceHelper.loadSingle((Object)deliverDO.getPkValue(), (String)deliverDO.getDataEntityType().getName());
                    DynamicObjectCollection banks = pledgeData.getDynamicObjectCollection("entry_bank");
                    for (DynamicObject bank : banks) {
                        if (bank.getString("bankaccount").equals(propValue.toString())) {
                            DynamicObject entry_bankInfo = bank.getDynamicObject("bank");
                            if (EmptyUtil.isNoEmpty((DynamicObject)entry_bankInfo)) {
                                Object bankObj = entry_bankInfo.getPkValue();
                                String bankNum = entry_bankInfo.getString("number");
                                this.fillBankDataWhenAccountChange(bankObj, bankNum);
                            } else {
                                this.fillBankDataWhenAccountChange(null, null);
                            }
                            break;
                        }
                        this.fillBankDataWhenAccountChange(null, null);
                    }
                }
            } else if (deliverType.equals("bos_org")) {
                DynamicObject bankAccount = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"bank", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", propValue).and(BankAccountHelper.getNormalBankStatusFilter())});
                if (EmptyUtil.isNoEmpty((DynamicObject)bankAccount)) {
                    DynamicObject bank = bankAccount.getDynamicObject("bank");
                    if (EmptyUtil.isNoEmpty((DynamicObject)bank) && EmptyUtil.isNoEmpty((DynamicObject)bank.getDynamicObject("bebank"))) {
                        Object pkValue = bank.getDynamicObject("bebank").getPkValue();
                        String bankNum = bank.getDynamicObject("bebank").getString("number");
                        this.fillBankDataWhenAccountChange(pkValue, bankNum);
                    } else {
                        this.fillBankDataWhenAccountChange(null, null);
                    }
                }
            } else if (deliverType.equals("bos_user")) {
                DynamicObject erPayeer = TmcDataServiceHelper.loadSingle((String)"er_payeer", (String)"payerbank", (QFilter[])new QFilter[]{new QFilter("payeraccount", "=", propValue), new QFilter("payer.id", "=", deliverDO.getPkValue())});
                DynamicObject payerbankInfo = null;
                if (erPayeer != null) {
                    payerbankInfo = erPayeer.getDynamicObject("payerbank");
                }
                if (payerbankInfo != null && erPayeer != null) {
                    Object pkvalue = erPayeer.getDynamicObject("payerbank").getPkValue();
                    String bankNum = erPayeer.getDynamicObject("payerbank").getString("number");
                    this.fillBankDataWhenAccountChange(pkvalue, bankNum);
                } else {
                    this.fillBankDataWhenAccountChange(null, null);
                }
            } else {
                this.fillBankDataWhenAccountChange(null, null);
            }
        } else {
            this.fillBankDataWhenAccountChange(null, null);
        }
    }

    private void setVisible(Object draftBillType) {
        if (EmptyUtil.isNoEmpty((Object)draftBillType)) {
            String settlementType = ((DynamicObject)draftBillType).getString("settlementtype");
            this.getView().setVisible(Boolean.valueOf(StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BANK.getValue())), new String[]{"accepterbebank"});
            this.getView().setVisible(Boolean.valueOf(!StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BANK.getValue()) && !StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.CHECK.getValue())), new String[]{"acceptername"});
        }
    }

    private void payeetypeChange() {
        this.getModel().setValue("deliver", null);
        this.getModel().setValue("deliveraccountbase", null);
        this.getModel().setValue("deliveraccounttext", null);
        this.getModel().setValue("deliveropenbank", null);
        this.getModel().setValue("deliveropenbanknum", null);
        this.getView().updateView();
        String payeetype = this.getModel().getValue("payeetype").toString();
        if (StringUtils.equals((CharSequence)payeetype, (CharSequence)PayeeTypeEnum.OTHER.getValue())) {
            ((FieldEdit)this.getView().getControl("deliver")).setMustInput(false);
        } else {
            ((FieldEdit)this.getView().getControl("deliver")).setMustInput(true);
        }
    }

    private void drawernameChange(Object draftbilltype) {
        if (EmptyUtil.isNoEmpty((Object)draftbilltype)) {
            DynamicObject draftbilltypeDO = (DynamicObject)draftbilltype;
            String settlementtype = draftbilltypeDO.getString("settlementtype");
            if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) {
                this.getModel().setValue("acceptername", this.getModel().getValue("drawername"));
            }
            this.getModel().setValue("draweraccountname", null);
            this.getModel().setValue("drawerbank", null);
            this.getModel().setValue("drawerbankno", null);
            DynamicObject deliverDO = this.getModel().getDataEntity().getDynamicObject("deliver");
            String drawername = this.getModel().getValue("drawername").toString();
            if (EmptyUtil.isNoEmpty((DynamicObject)deliverDO) && StringUtils.equals((CharSequence)deliverDO.getString("name"), (CharSequence)drawername)) {
                String deliverType;
                block5 : switch (deliverType = deliverDO.getDataEntityType().getName()) {
                    case "bd_supplier": 
                    case "bd_customer": {
                        DynamicObject bank = TmcDataServiceHelper.loadSingle((String)deliverType, (String)"bankaccount,bank,isdefault_bank", (QFilter[])new QFilter[]{new QFilter("id", "=", deliverDO.getPkValue())});
                        if (EmptyUtil.isEmpty((DynamicObject)bank)) break;
                        DynamicObjectCollection entryBank = bank.getDynamicObjectCollection("entry_bank");
                        for (DynamicObject entry : entryBank) {
                            if (!entry.getBoolean("isdefault_bank")) continue;
                            this.getModel().setValue("draweraccountname", (Object)entry.getString("bankaccount"));
                            DynamicObject bankDO = entry.getDynamicObject("bank");
                            if (!EmptyUtil.isEmpty((DynamicObject)bankDO)) {
                                this.getModel().setValue("drawerbank", bankDO.getPkValue());
                            }
                            if (!EmptyUtil.isNoEmpty((DynamicObject)bankDO)) break block5;
                            DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)entry.getDynamicObject("bank").getPkValue(), (String)entry.getDynamicObject("bank").getDataEntityType().getName());
                            this.getModel().setValue("drawerbankno", (Object)bdBebankDO.getString("union_number"));
                            break block5;
                        }
                        break;
                    }
                    case "bos_user": {
                        DynamicObject bdBebankDO;
                        DynamicObject payeerDO = TmcDataServiceHelper.loadSingle((String)"er_payeer", (String)"payerbank,payeraccount", (QFilter[])new QFilter[]{new QFilter("payer.id", "=", deliverDO.getPkValue()), new QFilter("isdefault", "=", (Object)"1")});
                        if (!EmptyUtil.isNoEmpty((DynamicObject)payeerDO)) break;
                        this.getModel().setValue("draweraccountname", (Object)payeerDO.getString("payeraccount"));
                        DynamicObject payerbankDO = payeerDO.getDynamicObject("payerbank");
                        if (!EmptyUtil.isEmpty((DynamicObject)payerbankDO)) {
                            this.getModel().setValue("drawerbank", payerbankDO.getPkValue());
                        }
                        if (EmptyUtil.isEmpty((DynamicObject)(bdBebankDO = TmcDataServiceHelper.loadSingle((Object)payerbankDO.getPkValue(), (String)payerbankDO.getDataEntityType().getName())))) break;
                        this.getModel().setValue("drawerbankno", (Object)bdBebankDO.getString("union_number"));
                        break;
                    }
                }
            }
        }
    }

    private void receiverbankChange(Object draftbilltype) {
        if (EmptyUtil.isNoEmpty((Object)draftbilltype)) {
            DynamicObject draftbilltypeDO = (DynamicObject)draftbilltype;
            String settlementtype = draftbilltypeDO.getString("settlementtype");
            Object value = this.getModel().getValue("receiverbank");
            if (EmptyUtil.isNoEmpty((Object)value)) {
                DynamicObject receiverbankDO = (DynamicObject)value;
                DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)receiverbankDO.getPkValue(), (String)receiverbankDO.getDataEntityType().getName());
                this.getModel().setValue("receiverbankno", bdBebankDO.get("union_number"));
            }
        }
    }

    private void draweraccountnameRegisterListener() {
        TextEdit draweraccountname = (TextEdit)this.getControl("draweraccountname");
        draweraccountname.addButtonClickListener(new ClickListener(){

            public void click(EventObject evt) {
                IDataModel model = ReceivableBillEdit.this.getModel();
                DynamicObject draftTradeBill = model.getDataEntity();
                DynamicObject deliver = draftTradeBill.getDynamicObject("deliver");
                String drawername = model.getValue("drawername").toString();
                if (EmptyUtil.isNoEmpty((DynamicObject)deliver)) {
                    if (StringUtils.equals((CharSequence)drawername, (CharSequence)deliver.getString("name"))) {
                        String receiverEntityType = deliver.getDataEntityType().getName();
                        Object receiverId = deliver.getPkValue();
                        Object innerOrgId = null;
                        if (StringUtils.equals((CharSequence)receiverEntityType, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)receiverEntityType, (CharSequence)"bd_customer")) {
                            DynamicObject innerOrg = BaseDataHelper.getInternalOrg((DynamicObject)deliver);
                            if (innerOrg == null) {
                                String qFilter = new QFilter("id", "=", receiverId);
                                DynamicObject entryBankDO = TmcDataServiceHelper.loadSingle((String)receiverEntityType, (String)"entry_bank", (QFilter[])qFilter.toArray());
                                if (entryBankDO.getDynamicObjectCollection("entry_bank").size() == 0) {
                                    ReceivableBillEdit.this.getView().showTipNotification(new CdmBizResource().getTipCsNull());
                                    return;
                                }
                            } else {
                                innerOrgId = innerOrg.getPkValue();
                            }
                        }
                        ListShowParameter lsp = new ListShowParameter();
                        switch (receiverEntityType) {
                            case "bd_supplier": {
                                if (innerOrgId != null) {
                                    lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                                    break;
                                }
                                lsp = ListConstructorHelper.getSupplierBankInfoShowParameter((Object)receiverId);
                                break;
                            }
                            case "bd_customer": {
                                if (innerOrgId != null) {
                                    lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                                    break;
                                }
                                lsp = ListConstructorHelper.getCustomerBankInfoShowParameter((Object)receiverId);
                                break;
                            }
                            case "bos_org": {
                                lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)receiverId);
                                break;
                            }
                            case "bos_user": {
                                lsp = ListConstructorHelper.getPayeerInfoShowParameter((Object)receiverId);
                                break;
                            }
                        }
                        if (lsp != null) {
                            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)ReceivableBillEdit.this, "draweraccountname");
                            lsp.setCloseCallBack(closeCallBack);
                            ReceivableBillEdit.this.getView().showForm((FormShowParameter)lsp);
                        }
                    }
                } else {
                    String payeetype;
                    DynamicObject dynamicObject = ReceivableBillEdit.this.getModel().getDataEntity().getDynamicObject("draftbilltype");
                    if (dynamicObject != null && !StringUtils.equals((CharSequence)dynamicObject.getString("settlementtype"), (CharSequence)SettleMentTypeEnum.CHECK.getValue()) && !StringUtils.equals((CharSequence)(payeetype = ReceivableBillEdit.this.getModel().getValue("payeetype").toString()), (CharSequence)PayeeTypeEnum.OTHER.getValue())) {
                        ReceivableBillEdit.this.getView().showTipNotification(new CdmBizResource().getTipDeliverShort());
                        return;
                    }
                }
            }
        });
    }

    private void deliverAccountBaseRegisterListener() {
        TextEdit deliverAccount = (TextEdit)this.getControl("deliveraccountbase");
        deliverAccount.addButtonClickListener(new ClickListener(){

            public void click(EventObject evt) {
                IDataModel model = ReceivableBillEdit.this.getModel();
                DynamicObject draftTradeBill = model.getDataEntity();
                DynamicObject deliver = draftTradeBill.getDynamicObject("deliver");
                String drawername = model.getValue("drawername").toString();
                if (EmptyUtil.isNoEmpty((DynamicObject)deliver)) {
                    if (StringUtils.equals((CharSequence)drawername, (CharSequence)deliver.getString("name"))) {
                        String receiverEntityType = deliver.getDataEntityType().getName();
                        Object receiverId = deliver.getPkValue();
                        Object innerOrgId = null;
                        if (StringUtils.equals((CharSequence)receiverEntityType, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)receiverEntityType, (CharSequence)"bd_customer")) {
                            DynamicObject innerOrg = BaseDataHelper.getInternalOrg((DynamicObject)deliver);
                            if (innerOrg == null) {
                                QFilter qFilter = new QFilter("id", "=", receiverId);
                                String entryBankDO = TmcDataServiceHelper.loadSingle((String)receiverEntityType, (String)"entry_bank", (QFilter[])qFilter.toArray());
                                if (entryBankDO.getDynamicObjectCollection("entry_bank").size() == 0) {
                                    ReceivableBillEdit.this.getView().showTipNotification(new CdmBizResource().getTipCsNull());
                                    return;
                                }
                            } else {
                                innerOrgId = innerOrg.getPkValue();
                            }
                        }
                        ListShowParameter lsp = new ListShowParameter();
                        boolean isInternalOrg = BaseDataHelper.isInternalOrg((DynamicObject)draftTradeBill.getDynamicObject("company"));
                        switch (receiverEntityType) {
                            case "bd_supplier": {
                                if (innerOrgId != null) {
                                    if (isInternalOrg) {
                                        lsp = ListConstructorHelper.getSupplierBankInfoShowParameter((Object)receiverId);
                                        break;
                                    }
                                    lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                                    break;
                                }
                                lsp = ListConstructorHelper.getSupplierBankInfoShowParameter((Object)receiverId);
                                break;
                            }
                            case "bd_customer": {
                                if (innerOrgId != null) {
                                    if (isInternalOrg) {
                                        lsp = ListConstructorHelper.getCustomerBankInfoShowParameter((Object)receiverId);
                                        break;
                                    }
                                    lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                                    break;
                                }
                                lsp = ListConstructorHelper.getCustomerBankInfoShowParameter((Object)receiverId);
                                break;
                            }
                            case "bos_org": {
                                lsp = ListConstructorHelper.getBankAccountShowParameter((Object)receiverId);
                                break;
                            }
                            case "bos_user": {
                                lsp = ListConstructorHelper.getPayeerInfoShowParameter((Object)receiverId);
                                break;
                            }
                        }
                        if (lsp != null) {
                            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)ReceivableBillEdit.this, "deliveraccountbase");
                            lsp.setCloseCallBack(closeCallBack);
                            ReceivableBillEdit.this.getView().showForm((FormShowParameter)lsp);
                        }
                    }
                } else {
                    String payeetype;
                    DynamicObject dynamicObject = ReceivableBillEdit.this.getModel().getDataEntity().getDynamicObject("draftbilltype");
                    if (dynamicObject != null && !StringUtils.equals((CharSequence)dynamicObject.getString("settlementtype"), (CharSequence)SettleMentTypeEnum.CHECK.getValue()) && !StringUtils.equals((CharSequence)(payeetype = ReceivableBillEdit.this.getModel().getValue("payeetype").toString()), (CharSequence)PayeeTypeEnum.OTHER.getValue())) {
                        ReceivableBillEdit.this.getView().showTipNotification(new CdmBizResource().getTipDeliverShort());
                        return;
                    }
                }
            }
        });
    }

    private void receiveraccountRegisterListener() {
        TextEdit receiveraccount = (TextEdit)this.getControl("receiveraccount");
        receiveraccount.addButtonClickListener(new ClickListener(){

            public void click(EventObject evt) {
                DynamicObject company = ReceivableBillEdit.this.getModel().getDataEntity().getDynamicObject("company");
                ListShowParameter lsp = null;
                String receiver = ReceivableBillEdit.this.getModel().getDataEntity().getString("receivername");
                if (StringUtils.equals((CharSequence)company.getString("name"), (CharSequence)receiver)) {
                    lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)company.getPkValue());
                    ListFilterParameter lfp = lsp.getListFilterParameter();
                    String[] temp = new String[]{"normal", "freeze"};
                    lfp.setFilter(new QFilter("acctstatus", "in", (Object)temp).and(VisibleVirtualAcctHelper.notVirtualAcctQf()));
                    lsp.setListFilterParameter(lfp);
                }
                if (lsp != null) {
                    CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)ReceivableBillEdit.this, "receiveraccount");
                    lsp.setCloseCallBack(closeCallBack);
                    ReceivableBillEdit.this.getView().showForm((FormShowParameter)lsp);
                }
            }
        });
    }

    private void drawerRegisterListener() {
        BasedataEdit drawer;
        if (this.getModel().getProperty("drawer") != null && (drawer = (BasedataEdit)this.getControl("drawer")) != null) {
            drawer.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "drawer");
                showParameter.setCloseCallBack(closeCallBack);
            });
        }
    }

    private void deliverRegisterListener() {
        if (this.getModel().getProperty("deliver") != null) {
            BasedataEdit deliver = (BasedataEdit)this.getControl("deliver");
            String payeetype = this.getModel().getValue("payeetype").toString();
            if (deliver != null) {
                deliver.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                    ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    if (StringUtils.equals((CharSequence)payeetype, (CharSequence)PayeeTypeEnum.BOS_ORG.getValue())) {
                        QFilter filter = new QFilter("fisbankroll", "=", (Object)"1");
                        showParameter.setCustomParam("orgFuncId", (Object)"08");
                        List qfilter = showParameter.getListFilterParameter().getQFilters();
                        qfilter.add(filter);
                    }
                    CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "deliver");
                    showParameter.setCloseCallBack(closeCallBack);
                });
            }
        }
    }

    private void companyRegisterListener() {
        BasedataEdit company;
        if (this.getModel().getProperty("company") != null && (company = (BasedataEdit)this.getControl("company")) != null) {
            company.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "company");
                showParameter.setCloseCallBack(closeCallBack);
            });
        }
    }

    private void receiveraccountCloseCallBack(ListSelectedRow row) {
        DynamicObject bankDO;
        this.getModel().setValue("receiveraccount", (Object)row.getNumber());
        this.getModel().setValue("receiverbankno", null);
        this.getModel().setValue("receiverbank", null);
        DynamicObject accountbanksDO = TmcDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"bd_accountbanks");
        if (!EmptyUtil.isEmpty((DynamicObject)accountbanksDO) && !EmptyUtil.isEmpty((DynamicObject)(bankDO = accountbanksDO.getDynamicObject("bank")))) {
            this.getModel().setValue("receiverbankno", (Object)bankDO.getString("union_number"));
            DynamicObject bebankDO = bankDO.getDynamicObject("bebank");
            if (!EmptyUtil.isEmpty((DynamicObject)bebankDO)) {
                this.getModel().setValue("receiverbank", bebankDO.getPkValue());
            }
        }
    }

    private void draweraccountnameCloseCallBack(ListSelectedRow row, boolean isDeliver) {
        DynamicObjectCollection entryBank;
        DynamicObject bank;
        String account = "draweraccountname";
        String openBank = "drawerbank";
        String bankNum = "drawerbankno";
        if (isDeliver) {
            account = "deliveraccountbase";
            openBank = "deliveropenbank";
            bankNum = "deliveropenbanknum";
        }
        Object entryKey = row.getEntryPrimaryKeyValue();
        DynamicObject deliver = this.getModel().getDataEntity().getDynamicObject("deliver");
        String entityName = deliver.getDataEntityType().getName();
        DynamicObject innerOrg = null;
        boolean isInternalOrg = false;
        if ("bd_supplier".equals(entityName) || "bd_customer".equals(entityName)) {
            innerOrg = BaseDataHelper.getInternalOrg((DynamicObject)deliver);
            IDataModel model = this.getModel();
            DynamicObject draftTradeBill = model.getDataEntity();
            if (isDeliver) {
                isInternalOrg = BaseDataHelper.isInternalOrg((DynamicObject)draftTradeBill.getDynamicObject("company"));
            }
        }
        if ((StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_customer")) && innerOrg == null) {
            bank = TmcDataServiceHelper.loadSingle((String)deliver.getDataEntityType().getName(), (String)"bankaccount,bank", (QFilter[])new QFilter[]{new QFilter("entry_bank.id", "=", (Object)Long.valueOf(entryKey.toString()))});
            if (!EmptyUtil.isEmpty((DynamicObject)bank) && !EmptyUtil.isEmpty((DynamicObjectCollection)(entryBank = bank.getDynamicObjectCollection("entry_bank")))) {
                for (DynamicObject entry : entryBank) {
                    if (!entry.getPkValue().equals(entryKey)) continue;
                    this.getModel().setValue(account, (Object)entry.getString("bankaccount"));
                    DynamicObject bankDO = entry.getDynamicObject("bank");
                    if (EmptyUtil.isNoEmpty((DynamicObject)bankDO)) {
                        this.getModel().setValue(openBank, bankDO.getPkValue());
                        DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)bankDO.getPkValue(), (String)bankDO.getDataEntityType().getName());
                        if (!EmptyUtil.isEmpty((DynamicObject)bdBebankDO)) {
                            this.getModel().setValue(bankNum, (Object)bdBebankDO.getString("union_number"));
                        }
                    }
                    break;
                }
            }
        } else if ((StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_customer")) && innerOrg != null && isInternalOrg) {
            bank = TmcDataServiceHelper.loadSingle((String)deliver.getDataEntityType().getName(), (String)"bankaccount,bank", (QFilter[])new QFilter[]{new QFilter("entry_bank.id", "=", (Object)Long.valueOf(entryKey.toString()))});
            if (!EmptyUtil.isEmpty((DynamicObject)bank) && !EmptyUtil.isEmpty((DynamicObjectCollection)(entryBank = bank.getDynamicObjectCollection("entry_bank")))) {
                for (DynamicObject entry : entryBank) {
                    if (!entry.getPkValue().equals(entryKey)) continue;
                    this.getModel().setValue(account, (Object)entry.getString("bankaccount"));
                    DynamicObject bankDO = entry.getDynamicObject("bank");
                    if (EmptyUtil.isNoEmpty((DynamicObject)bankDO)) {
                        this.getModel().setValue(openBank, bankDO.getPkValue());
                        DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)bankDO.getPkValue(), (String)bankDO.getDataEntityType().getName());
                        if (!EmptyUtil.isEmpty((DynamicObject)bdBebankDO)) {
                            this.getModel().setValue(bankNum, (Object)bdBebankDO.getString("union_number"));
                        }
                    }
                    break;
                }
            }
        } else if (StringUtils.equals((CharSequence)entityName, (CharSequence)"bos_user")) {
            DynamicObject payerbankDO;
            this.getModel().setValue(account, (Object)row.getNumber());
            DynamicObject payeerDO = TmcDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"er_payeer");
            if (EmptyUtil.isNoEmpty((DynamicObject)payeerDO) && !EmptyUtil.isEmpty((DynamicObject)(payerbankDO = payeerDO.getDynamicObject("payerbank")))) {
                this.getModel().setValue(openBank, payerbankDO.getPkValue());
                DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)payerbankDO.getPkValue(), (String)payerbankDO.getDataEntityType().getName());
                if (!EmptyUtil.isEmpty((DynamicObject)bdBebankDO)) {
                    this.getModel().setValue(bankNum, (Object)bdBebankDO.getString("union_number"));
                }
            }
        } else {
            DynamicObject bankDO;
            this.getModel().setValue(account, (Object)row.getNumber());
            DynamicObject accountbanksDO = TmcDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"bd_accountbanks");
            if (!EmptyUtil.isEmpty((DynamicObject)accountbanksDO) && !EmptyUtil.isEmpty((DynamicObject)(bankDO = accountbanksDO.getDynamicObject("bank")))) {
                this.getModel().setValue(bankNum, (Object)bankDO.getString("union_number"));
                DynamicObject bebankDO = bankDO.getDynamicObject("bebank");
                if (!EmptyUtil.isEmpty((DynamicObject)bebankDO)) {
                    this.getModel().setValue(openBank, bebankDO.getPkValue());
                }
            }
        }
    }

    private void drawerCloseCallBack(ListSelectedRow row) {
        this.getModel().setValue("drawername", (Object)row.getName());
        this.getModel().setValue("drawer", row.getPrimaryKeyValue());
    }

    private void deliverCloseCallBack(ListSelectedRow row) {
        this.getModel().setValue("delivername", (Object)row.getName());
        this.getModel().setValue("deliver", row.getPrimaryKeyValue());
    }

    private void companyCloseCallBack(ListSelectedRow row) {
        boolean isSecondHandBill = DraftHelper.getCdmParameterBoolean((long)((Long)row.getPrimaryKeyValue()), (String)"issecondhandbill");
        if (!isSecondHandBill) {
            this.getModel().setValue("receivername", (Object)row.getName());
        }
        this.getModel().setValue("company", row.getPrimaryKeyValue());
        DynamicObject baseCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)((Long)row.getPrimaryKeyValue()));
        if (!EmptyUtil.isEmpty((DynamicObject)baseCurrency)) {
            this.getModel().setValue("currency", baseCurrency.getPkValue());
        }
    }

    private void drawerbankChange(Object draftbilltype) {
        if (EmptyUtil.isNoEmpty((Object)draftbilltype)) {
            Object value;
            DynamicObject bdBebankDO;
            DynamicObject draftbilltypeDO = (DynamicObject)draftbilltype;
            String settlementtype = draftbilltypeDO.getString("settlementtype");
            DynamicObject drawerbank = (DynamicObject)this.getModel().getValue("drawerbank");
            if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"accepterbank"});
                if (EmptyUtil.isNoEmpty((DynamicObject)drawerbank)) {
                    this.getModel().setValue("acceptername", (Object)drawerbank.getString("name"));
                    this.getModel().setValue("accepterbankname", (Object)drawerbank.getString("name"));
                    this.getModel().setValue("accepterbank", drawerbank.getPkValue());
                    bdBebankDO = TmcDataServiceHelper.loadSingle((Object)drawerbank.getPkValue(), (String)drawerbank.getDataEntityType().getName());
                    this.getModel().setValue("accepterbankno", (Object)bdBebankDO.getString("union_number"));
                    this.getModel().setValue("accepterbebank", (Object)drawerbank);
                }
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"accepterbank"});
                if (EmptyUtil.isNoEmpty((DynamicObject)drawerbank)) {
                    this.getModel().setValue("accepterbank", drawerbank.getPkValue());
                    this.getModel().setValue("accepterbankname", (Object)drawerbank.getString("name"));
                    bdBebankDO = TmcDataServiceHelper.loadSingle((Object)drawerbank.getPkValue(), (String)drawerbank.getDataEntityType().getName());
                    this.getModel().setValue("accepterbankno", (Object)bdBebankDO.getString("union_number"));
                }
            }
            if (EmptyUtil.isNoEmpty((Object)(value = this.getModel().getValue("drawerbank")))) {
                DynamicObject drawerbankDO = (DynamicObject)value;
                DynamicObject bdBebankDO2 = TmcDataServiceHelper.loadSingle((Object)drawerbankDO.getPkValue(), (String)drawerbankDO.getDataEntityType().getName());
                this.getModel().setValue("drawerbankno", (Object)bdBebankDO2.getString("union_number"));
            }
        }
    }

    private void deliverChange(Object draftbilltype) {
        String settlementType;
        DynamicObject deliverDO = this.getModel().getDataEntity().getDynamicObject("deliver");
        DynamicObject draftbilltypeDO = (DynamicObject)this.getModel().getValue("draftbilltype");
        boolean ischeck = false;
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltypeDO) && EmptyUtil.isNoEmpty((String)(settlementType = draftbilltypeDO.getString("settlementtype"))) && StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.CHECK.getValue())) {
            ischeck = true;
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)deliverDO)) {
            Object deliverType;
            DynamicObject company = (DynamicObject)this.getModel().getValue("company");
            boolean isSecondHandBill = DraftHelper.getCdmParameterBoolean((long)company.getLong("id"), (String)"issecondhandbill");
            this.getModel().setValue("delivername", (Object)deliverDO.getString("name"));
            if (!isSecondHandBill && !ischeck) {
                this.getModel().setValue("drawername", (Object)deliverDO.getString("name"));
            }
            if (!EmptyUtil.isEmpty((Object)(deliverType = this.getModel().getValue("delivertype")))) {
                if (deliverType.equals("bd_supplier") || deliverType.equals("bd_customer")) {
                    DynamicObject deliver = TmcDataServiceHelper.loadSingle((Object)deliverDO.getPkValue(), (String)deliverDO.getDataEntityType().getName());
                    DynamicObjectCollection banks = deliver.getDynamicObjectCollection("entry_bank");
                    if (!EmptyUtil.isEmpty((DynamicObjectCollection)banks)) {
                        boolean hasDefault = false;
                        for (DynamicObject bank : banks) {
                            if (!bank.getBoolean("isdefault_bank") || bank.getDynamicObject("bank") == null) continue;
                            this.getModel().setValue("deliveraccountbase", (Object)bank.getString("bankaccount"));
                            this.skip = true;
                            this.getModel().setValue("deliveropenbank", bank.getDynamicObject("bank").getPkValue());
                            this.getModel().setValue("deliveropenbanknum", (Object)bank.getDynamicObject("bank").getString("number"));
                            hasDefault = true;
                            break;
                        }
                        if (!hasDefault) {
                            this.getModel().setValue("deliveraccountbase", null);
                            this.getModel().setValue("deliveropenbank", null);
                            this.getModel().setValue("deliveropenbanknum", null);
                        }
                    } else {
                        this.getModel().setValue("deliveraccountbase", null);
                        this.getModel().setValue("deliveropenbank", null);
                        this.getModel().setValue("deliveropenbanknum", null);
                    }
                } else if (deliverType.equals("bos_org")) {
                    Object[] bankAccts = TmcDataServiceHelper.load((String)"bd_accountbanks", (String)"bankaccountnumber,bank", (QFilter[])new QFilter[]{new QFilter("company", "in", deliverDO.getPkValue()).and(BankAccountHelper.getNormalBankStatusFilter())});
                    if (!EmptyUtil.isEmpty((Object[])bankAccts)) {
                        this.getModel().setValue("deliveraccountbase", (Object)bankAccts[0].getString("bankaccountnumber"));
                        DynamicObject bank = bankAccts[0].getDynamicObject("bank");
                        if (null != bank && EmptyUtil.isNoEmpty((DynamicObject)bank.getDynamicObject("bebank"))) {
                            this.skip = true;
                            this.getModel().setValue("deliveropenbank", bank.getDynamicObject("bebank").getPkValue());
                            this.getModel().setValue("deliveropenbanknum", (Object)bank.getDynamicObject("bebank").getString("number"));
                        }
                    } else {
                        this.getModel().setValue("deliveraccountbase", null);
                        this.getModel().setValue("deliveropenbank", null);
                        this.getModel().setValue("deliveropenbanknum", null);
                    }
                } else if (deliverType.equals("bos_user")) {
                    DynamicObject[] erPayers = TmcDataServiceHelper.load((String)"er_payeer", (String)"payeraccount,payerbank", (QFilter[])new QFilter[]{new QFilter("payer.id", "=", deliverDO.getPkValue()), new QFilter("enable", "=", (Object)"1")}, (String)"isdefault desc");
                    if (erPayers.length > 0 && null != erPayers[0].getDynamicObject("payerbank")) {
                        this.getModel().setValue("deliveraccountbase", (Object)erPayers[0].getString("payeraccount"));
                        this.skip = true;
                        this.getModel().setValue("deliveropenbank", erPayers[0].getDynamicObject("payerbank").getPkValue());
                        this.getModel().setValue("deliveropenbanknum", (Object)erPayers[0].getDynamicObject("payerbank").getString("number"));
                    } else {
                        this.getModel().setValue("deliveraccountbase", null);
                        this.getModel().setValue("deliveropenbank", null);
                        this.getModel().setValue("deliveropenbanknum", null);
                    }
                }
            }
        }
    }

    private void drawerChange(Object draftbilltype) {
        if (EmptyUtil.isNoEmpty((Object)draftbilltype)) {
            Object value;
            DynamicObject draftbilltypeDO = (DynamicObject)draftbilltype;
            String settlementtype = draftbilltypeDO.getString("settlementtype");
            if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) {
                Object value2 = this.getModel().getValue("drawer");
                if (EmptyUtil.isEmpty((Object)value2)) {
                    this.getModel().setValue("acceptername", this.getModel().getValue("drawername"));
                } else {
                    DynamicObject drawerDO = (DynamicObject)value2;
                    this.getModel().setValue("acceptername", (Object)drawerDO.getString("name"));
                }
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue()) && !EmptyUtil.isEmpty((Object)(value = this.getModel().getValue("drawer")))) {
                DynamicObject drawerDO = (DynamicObject)value;
                this.getModel().setValue("drawerbank", drawerDO.getPkValue());
            }
        }
    }

    private void draftbillexpiredateChange(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        Date newValue = (Date)changeSet[0].getNewValue();
        Date oldValue = (Date)changeSet[0].getOldValue();
        if (oldValue != null) {
            Date draftBillExpiredate = this.getDraftBillExpireDate();
            Date issuedate = this.getModel().getDataEntity().getDate("issuedate");
            if (draftBillExpiredate != null && newValue != null && newValue.after(draftBillExpiredate)) {
                this.getView().showErrorNotification(new CdmBizResource().getRbDraftBillExpiredateCheck());
                this.getModel().setValue("draftbillexpiredate", (Object)draftBillExpiredate);
            } else if (draftBillExpiredate != null && newValue != null && issuedate != null && !newValue.after(issuedate)) {
                this.getView().showErrorNotification(new CdmBizResource().getRbDraftBillExpiredateCheck2());
                this.getModel().setValue("draftbillexpiredate", (Object)draftBillExpiredate);
            }
        }
    }

    private void draftbilltypeChange(PropertyChangedArgs e, Object draftbilltype) {
        if (EmptyUtil.isNoEmpty((Object)draftbilltype)) {
            String settlementtype;
            DynamicObject draftbilltypeDO = (DynamicObject)draftbilltype;
            Date draftBillExpireDate = this.getDraftBillDefaultExpireDate();
            if (draftBillExpireDate != null) {
                this.getModel().setValue("draftbillexpiredate", (Object)draftBillExpireDate);
            }
            if (StringUtils.equals((CharSequence)(settlementtype = draftbilltypeDO.getString("settlementtype")), (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                this.getModel().setValue("billtype", (Object)CdmBizConstant.RECEIVABLEBILL_BANK);
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) {
                this.getModel().setValue("billtype", (Object)CdmBizConstant.RECEIVABLEBILL_BUSINESS);
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue())) {
                this.getModel().setValue("billtype", (Object)CdmBizConstant.RECEIVABLEBILL_CHECK);
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue())) {
                this.getModel().setValue("billtype", (Object)CdmBizConstant.RECEIVABLEBILL_PROMISSORY);
            }
            if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue()) || StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue())) {
                this.getModel().setValue("issplit", (Object)Character.valueOf('0'));
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"issplit"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"issplit"});
            }
            this.getModel().setValue("draftbilltype", (Object)((DynamicObject)e.getChangeSet()[0].getNewValue()));
            this.getView().updateView();
        }
    }

    private void issuedateChange() {
        Date draftBillExpireDate = this.getDraftBillDefaultExpireDate();
        Date date = this.getModel().getDataEntity().getDate("draftbillexpiredate");
        if (date == null && draftBillExpireDate != null || draftBillExpireDate != null && date != null && date.after(draftBillExpireDate)) {
            this.getModel().setValue("draftbillexpiredate", (Object)draftBillExpireDate);
        }
    }

    private void transerOperate(OperationResult operationResult, String type) {
        if (operationResult != null && operationResult.isSuccess()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("tradeType", type);
            this.getView().invokeOperation("pushtradebill", option);
        }
    }

    private Date getDraftBillExpireDate() {
        DynamicObject draftbilltypeDO = this.getModel().getDataEntity().getDynamicObject("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltypeDO)) {
            Date draftbillexpiredate = null;
            int validitytime = draftbilltypeDO.getInt("validitytime");
            String unit = draftbilltypeDO.getString("unit");
            Date issuedate = (Date)this.getModel().getValue("issuedate");
            if (StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.MONTH.getValue()) && EmptyUtil.isNoEmpty((Object)issuedate) && EmptyUtil.isNoEmpty((Integer)validitytime)) {
                draftbillexpiredate = DateUtils.getNextMonth((Date)issuedate, (int)validitytime);
                if (draftbillexpiredate.getDate() != issuedate.getDate()) {
                    draftbillexpiredate = DateUtils.getNextDay((Date)draftbillexpiredate, (int)(-draftbillexpiredate.getDate()));
                }
            } else if (StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.DAY.getValue()) && EmptyUtil.isNoEmpty((Object)issuedate) && EmptyUtil.isNoEmpty((Integer)validitytime)) {
                draftbillexpiredate = DateUtils.getNextDay((Date)issuedate, (int)validitytime);
            }
            return draftbillexpiredate;
        }
        return null;
    }

    private Date getDraftBillDefaultExpireDate() {
        DynamicObject draftbilltypeDO = this.getModel().getDataEntity().getDynamicObject("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltypeDO)) {
            Date draftbillexpiredate = null;
            int validitytime = draftbilltypeDO.getInt("defaulttime");
            String unit = draftbilltypeDO.getString("defaultunit");
            Date issuedate = (Date)this.getModel().getValue("issuedate");
            if (StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.MONTH.getValue()) && issuedate != null) {
                draftbillexpiredate = DateUtils.getNextMonth((Date)issuedate, (int)validitytime);
                if (draftbillexpiredate.getDate() != issuedate.getDate()) {
                    draftbillexpiredate = DateUtils.getNextDay((Date)draftbillexpiredate, (int)(-draftbillexpiredate.getDate()));
                }
            } else if (StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.DAY.getValue()) && issuedate != null) {
                draftbillexpiredate = DateUtils.getNextDay((Date)issuedate, (int)validitytime);
            }
            return draftbillexpiredate;
        }
        return null;
    }

    private void dialogEndorseInfoWindow(Boolean isEdit) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cdm_billcheckinendorinfo");
        if (isEdit.booleanValue()) {
            showParameter.setCustomParam("endorsetype", this.getModel().getValue("endorsetype"));
            showParameter.setCustomParam("initiatorname", this.getModel().getValue("initiatorname"));
            showParameter.setCustomParam("opponentname", this.getModel().getValue("opponentname"));
            showParameter.setCustomParam("endorseistransfer", this.getModel().getValue("endorseistransfer"));
            showParameter.setCustomParam("signdate", this.getModel().getValue("signdate"));
            showParameter.setCustomParam("pledgereleasedate", this.getModel().getValue("pledgereleasedate"));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btnendorseedit"));
        } else {
            showParameter.setCustomParam("endorseistransfer", this.getModel().getValue("istransfer"));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btnendorseadd"));
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void endorseInfoCloseCallBack(ClosedCallBackEvent closedCallBackEvent, Boolean isEdit) {
        DynamicObject returnData = (DynamicObject)closedCallBackEvent.getReturnData();
        if (returnData != null) {
            if (!isEdit.booleanValue()) {
                this.getView().invokeOperation("newentry");
            }
            Object endorseType = returnData.get("endortype");
            Object isTransfer = returnData.get("istransfer");
            this.getModel().setValue("endorsetype", endorseType);
            this.getModel().setValue("initiatorname", returnData.get("initiatorname"));
            this.getModel().setValue("opponentname", returnData.get("opponentname"));
            this.getModel().setValue("endorseistransfer", isTransfer);
            this.getModel().setValue("signdate", returnData.get("signdate"));
            this.getModel().setValue("pledgereleasedate", returnData.get("pledgereleasedate"));
            this.buildEndorseTitleInfo(endorseType, isTransfer, null);
        }
    }

    private void setEndorseInfo() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("endorseentry");
        for (DynamicObject endorseInfo : entryEntity) {
            this.buildEndorseTitleInfo(endorseInfo.get("endorsetype"), endorseInfo.get("endorseistransfer"), endorseInfo);
        }
    }

    private void buildEndorseTitleInfo(Object endorseType, Object isTransfer, DynamicObject db) {
        String isTransferTitle = ResManager.loadKDString((String)"\u5426", (String)"ReceivableBillEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
        if (Boolean.TRUE.equals(isTransfer)) {
            isTransferTitle = ResManager.loadKDString((String)"\u662f", (String)"ReceivableBillEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
        }
        String initiatorNameTitle = "";
        String opponentNameTitle = ResManager.loadKDString((String)"\u5426", (String)"ReceivableBillEdit_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
        String signDateTitle = ResManager.loadKDString((String)"\u5426", (String)"ReceivableBillEdit_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
        String endorseTypeTitle = ResManager.loadKDString((String)"\u5426", (String)"ReceivableBillEdit_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
        if (BillEndorseTypeEnum.TRANSFER.getValue().equals(endorseType)) {
            initiatorNameTitle = ResManager.loadKDString((String)"\u80cc\u4e66\u4eba\uff1a", (String)"ReceivableBillEdit_6", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
            opponentNameTitle = ResManager.loadKDString((String)"\u88ab\u80cc\u4e66\u4eba\uff1a", (String)"ReceivableBillEdit_7", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
            signDateTitle = ResManager.loadKDString((String)"\u80cc\u4e66\u65e5\u671f\uff1a", (String)"ReceivableBillEdit_8", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
            endorseTypeTitle = BillEndorseTypeEnum.TRANSFER.getName();
        } else if (BillEndorseTypeEnum.NOTEDISCOUNT.getValue().equals(endorseType)) {
            initiatorNameTitle = ResManager.loadKDString((String)"\u80cc\u4e66\u4eba\uff1a", (String)"ReceivableBillEdit_6", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
            opponentNameTitle = ResManager.loadKDString((String)"\u88ab\u80cc\u4e66\u4eba\uff1a", (String)"ReceivableBillEdit_7", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
            signDateTitle = ResManager.loadKDString((String)"\u80cc\u4e66\u65e5\u671f\uff1a", (String)"ReceivableBillEdit_8", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
            endorseTypeTitle = BillEndorseTypeEnum.NOTEDISCOUNT.getName();
        } else if (BillEndorseTypeEnum.PLEDGE.getValue().equals(endorseType)) {
            initiatorNameTitle = ResManager.loadKDString((String)"\u51fa\u8d28\u4eba\uff1a", (String)"ReceivableBillEdit_9", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
            opponentNameTitle = ResManager.loadKDString((String)"\u8d28\u6743\u4eba\uff1a", (String)"ReceivableBillEdit_10", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
            signDateTitle = ResManager.loadKDString((String)"\u51fa\u8d28\u65e5\u671f\uff1a", (String)"ReceivableBillEdit_11", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
            endorseTypeTitle = BillEndorseTypeEnum.PLEDGE.getName();
        } else if (BillEndorseTypeEnum.PROMISE.getValue().equals(endorseType)) {
            initiatorNameTitle = ResManager.loadKDString((String)"\u88ab\u4fdd\u8bc1\u4eba\uff1a", (String)"ReceivableBillEdit_12", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
            opponentNameTitle = ResManager.loadKDString((String)"\u4fdd\u8bc1\u4eba\uff1a", (String)"ReceivableBillEdit_13", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
            signDateTitle = ResManager.loadKDString((String)"\u4fdd\u8bc1\u65e5\u671f\uff1a", (String)"ReceivableBillEdit_14", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
            endorseTypeTitle = BillEndorseTypeEnum.PROMISE.getName();
        } else if (BillEndorseTypeEnum.ACCEPTANCE.getValue().equals(endorseType)) {
            initiatorNameTitle = ResManager.loadKDString((String)"\u80cc\u4e66\u4eba\uff1a", (String)"ReceivableBillEdit_6", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
            opponentNameTitle = ResManager.loadKDString((String)"\u88ab\u80cc\u4e66\u4eba\uff1a", (String)"ReceivableBillEdit_7", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
            signDateTitle = ResManager.loadKDString((String)"\u80cc\u4e66\u65e5\u671f\uff1a", (String)"ReceivableBillEdit_8", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
            endorseTypeTitle = BillEndorseTypeEnum.ACCEPTANCE.getName();
        } else if (BillEndorseTypeEnum.INVOICE.getValue().equals(endorseType)) {
            initiatorNameTitle = ResManager.loadKDString((String)"\u80cc\u4e66\u4eba\uff1a", (String)"ReceivableBillEdit_6", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
            opponentNameTitle = ResManager.loadKDString((String)"\u88ab\u80cc\u4e66\u4eba\uff1a", (String)"ReceivableBillEdit_7", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
            signDateTitle = ResManager.loadKDString((String)"\u80cc\u4e66\u65e5\u671f\uff1a", (String)"ReceivableBillEdit_8", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
            endorseTypeTitle = BillEndorseTypeEnum.INVOICE.getName();
        }
        if (db != null) {
            db.set("labelinitiatorname", (Object)initiatorNameTitle);
            db.set("labelopponentname", (Object)opponentNameTitle);
            db.set("labelsigndate", (Object)signDateTitle);
            db.set("labelendorsetype", (Object)endorseTypeTitle);
            db.set("labelendorseistransfer", (Object)isTransferTitle);
        } else {
            this.getModel().setValue("labelinitiatorname", (Object)initiatorNameTitle);
            this.getModel().setValue("labelopponentname", (Object)opponentNameTitle);
            this.getModel().setValue("labelsigndate", (Object)signDateTitle);
            this.getModel().setValue("labelendorsetype", (Object)endorseTypeTitle);
            this.getModel().setValue("labelendorseistransfer", (Object)isTransferTitle);
        }
    }

    private void fillBankDataWhenAccountChange(Object pkValue, String bankNum) {
        this.skip = true;
        this.getModel().setValue("deliveropenbank", pkValue);
        this.getModel().setValue("deliveropenbanknum", (Object)bankNum);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("ispayinterest", (Object)0);
        this.getModel().setValue("whitelist", (Object)false);
        this.getModel().setValue("blacklist", (Object)false);
        this.getModel().setValue("listinformation", null);
        this.getModel().setValue("isequalbill", (Object)false);
        this.getModel().setValue("isfromequalspilt", (Object)false);
        this.getModel().setValue("euqaldifferetype", null);
        this.getModel().setValue("elccirculatestatus", null);
        this.getModel().setValue("description", null);
        this.getModel().setValue("supperbillid", (Object)0L);
        this.getModel().setValue("billidentitycode", null);
        this.getModel().setValue("equaltradebilltype", null);
        this.getModel().setValue("equaltradebillid", (Object)0L);
        this.getModel().setValue("lockedamount", null);
        this.getModel().setValue("usedamount", null);
        this.getModel().setValue("originalsubbillamount", null);
        this.getModel().setValue("originalsubbillrang", null);
        this.getModel().setValue("supperbillamount", null);
        this.getModel().setValue("isrefund", (Object)false);
        this.getModel().setValue("endorseentry", null);
        this.getModel().setValue("beendorsor", null);
        DraftHelper.resetGuaranteeInfo((IDataModel)this.getModel());
        this.getModel().deleteEntryData("releatedcasbillentrys");
    }

    private void setBillStatus() {
        IDataEntityProperty property = this.getModel().getProperty("billstatus");
        if (property != null && this.getView() instanceof IBillView) {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            logger.info("BillStatus:" + status.toString());
            if (status == OperationStatus.ADDNEW) {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
                this.getModel().setValue("modifytag", (Object)"done");
            }
        }
    }

    private void setOriginalInfo() {
        Object source = this.getModel().getValue("source");
        BigDecimal subBillAmount = (BigDecimal)this.getModel().getValue("amount");
        BigDecimal lockedAmount = (BigDecimal)this.getModel().getValue("lockedamount");
        Object subbillrange = this.getModel().getValue("subbillrange");
        Object draftbillno = this.getModel().getValue("draftbillno");
        long billId = this.getModel().getDataEntity().getLong("id");
        boolean issplit = (Boolean)this.getModel().getValue("issplit");
        if (0L == billId) {
            this.getModel().setValue("originalsubbillrang", subbillrange);
            this.getModel().setValue("originalsubbillamount", (Object)subBillAmount);
            this.getModel().setValue("availableamount", (Object)subBillAmount);
            if (issplit) {
                this.getModel().setValue("billidentitycode", (Object)(EmptyUtil.isNoEmpty((Object)draftbillno) ? draftbillno + "-" + subbillrange : ""));
            } else {
                this.getModel().setValue("billidentitycode", draftbillno);
            }
        } else if (EmptyUtil.isNoEmpty((Object)source) && SourceEnum.HANDREGISTER.getValue().equals(source)) {
            this.getModel().setValue("originalsubbillrang", subbillrange);
            this.getModel().setValue("originalsubbillamount", (Object)subBillAmount);
            if (lockedAmount.compareTo(BigDecimal.ZERO) > 0) {
                this.getModel().setValue("availableamount", (Object)subBillAmount.subtract(lockedAmount));
            } else {
                this.getModel().setValue("availableamount", (Object)subBillAmount);
            }
            if (issplit) {
                this.getModel().setValue("billidentitycode", (Object)(EmptyUtil.isNoEmpty((Object)draftbillno) ? draftbillno + "-" + subbillrange : ""));
            } else {
                this.getModel().setValue("billidentitycode", draftbillno);
            }
        }
    }
}

