/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.tradebill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.business.abstracts.guarantee.AbstractGuaranteeTrade;
import kd.tmc.cdm.business.abstracts.guarantee.GuaranteeTradeFactory;
import kd.tmc.cdm.common.bean.CreditLimitF7ResBean;
import kd.tmc.cdm.common.enums.GuaranteeTradeTypeEnum;
import kd.tmc.cdm.common.enums.PersonnelTypeEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class GuaranteeEdit
extends AbstractTmcBillEdit {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addGuarantorF7SelectListener();
        this.addDraftBillF7SelectListener();
        this.addCreditLimitF7SelectListener();
        this.addDraftTypeF7SelectListener();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeDataArray = e.getChangeSet();
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity(true);
        Object propVal = changeDataArray[0].getNewValue();
        Object oldValue = changeDataArray[0].getOldValue();
        int rowIndex = changeDataArray[0].getRowIndex();
        switch (key) {
            case "currency": 
            case "rptype": 
            case "guarantor": 
            case "guarantortext": {
                model.deleteEntryData("billentries");
                this.sumDraftAmtAndCount();
                this.processCreditLimit();
                break;
            }
            case "supportbankdraft": {
                if (((Boolean)propVal).booleanValue()) break;
                DynamicObjectCollection entries = data.getDynamicObjectCollection("billentries");
                if (EmptyUtil.isEmpty((DynamicObjectCollection)entries)) {
                    return;
                }
                DynamicObject draft = ((DynamicObject)entries.get(0)).getDynamicObject("draftbill");
                if (!EmptyUtil.isNoEmpty((DynamicObject)draft)) break;
                DynamicObject draftDb = TmcDataServiceHelper.loadSingle((Object)draft.getPkValue(), (String)"cdm_draftbillf7");
                if (EmptyUtil.isEmpty((DynamicObject)draftDb)) {
                    return;
                }
                DynamicObject draftType = draftDb.getDynamicObject("draftbilltype");
                String settlementType = draftType.getString("settlementtype");
                if (!StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BANK.getValue())) break;
                this.initDraftType();
                break;
            }
            case "biztype": {
                this.initBizTypeRelease();
                model.deleteEntryData("billentries");
                this.sumDraftAmtAndCount();
                this.processCreditLimit();
                break;
            }
            case "guaranteetype": {
                this.processGuarantor();
                model.deleteEntryData("billentries");
                this.sumDraftAmtAndCount();
                this.processCreditLimit();
                break;
            }
            case "discountorg": {
                model.setValue("creditlimitorg", propVal);
                break;
            }
            case "drafttype": {
                model.deleteEntryData("billentries");
                this.sumDraftAmtAndCount();
                this.processCreditLimit();
                this.initCreditType();
                break;
            }
            case "creditamount": {
                DynamicObject draftBill = (DynamicObject)this.getModel().getValue("draftbill", rowIndex);
                if (this.validateCreditAmount(draftBill, oldValue, propVal, rowIndex)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u884c\u5360\u7528\u6388\u4fe1\u91d1\u989d\u4fee\u6539\u8303\u56f4\u57280 ~ %s\u4e4b\u95f4\u3002", (String)"GuaranteeEdit_7", (String)"tmc-cdm-formplugin", (Object[])new Object[]{draftBill.getBigDecimal("amount")}));
                    this.getModel().setValue("creditamount", oldValue, rowIndex);
                    return;
                }
                this.sumCreditTotalAmount();
                break;
            }
            case "draftbill": {
                this.sumDraftAmtAndCount();
                this.processCreditLimit();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCurrency();
        this.initDraftType();
        this.initDataFromBillPage();
        this.initCreditType();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initBizTypeRelease();
        this.initCreditUse();
        this.initDataForDetails();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        IDataModel model = this.getModel();
        DynamicObject guaranteeDiscountDy = model.getDataEntity(true);
        if ("selectdraft".equals(opKey)) {
            if (EmptyUtil.isEmpty((DynamicObject)guaranteeDiscountDy.getDynamicObject("company"))) {
                this.getView().showTipNotification(new CdmBizResource().getTipCompanyShort(), Integer.valueOf(2000));
                args.setCancel(true);
                return;
            }
            if (EmptyUtil.isEmpty((DynamicObject)guaranteeDiscountDy.getDynamicObject("currency"))) {
                this.getView().showTipNotification(new CdmBizResource().getTipCurrCheck(), Integer.valueOf(2000));
                args.setCancel(true);
                return;
            }
            if (EmptyUtil.isEmpty((DynamicObject)guaranteeDiscountDy.getDynamicObject("drafttype"))) {
                this.getView().showTipNotification(new CdmBizResource().getTipDrafttypeShort(), Integer.valueOf(2000));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "selectdraft": {
                this.selectDraftBill();
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String key;
        super.afterDeleteRow(e);
        switch (key = e.getEntryProp().getName()) {
            case "billentries": {
                this.sumDraftAmtAndCount();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        switch (actionId) {
            case "selectdraft": {
                ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
                if (EmptyUtil.isEmpty((Collection)rows)) {
                    return;
                }
                this.batchFillBillEntry(rows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList()));
                this.sumDraftAmtAndCount();
                break;
            }
            case "creditlimit": {
                if (!(returnData instanceof String)) break;
                CreditLimitF7ResBean res = (CreditLimitF7ResBean)SerializationUtils.fromJsonString((String)((String)returnData), CreditLimitF7ResBean.class);
                Long creditLimitId = res.getCreditLimitId();
                model.setValue("creditlimit", (Object)creditLimitId);
                model.setValue("creditcurrency", (Object)res.getTargetCurrencyId());
                if (dataEntity.getBigDecimal("credittotalamount").compareTo(res.getRealBizAmt()) != 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u5360\u7528\u6388\u4fe1\u91d1\u989d\u5fc5\u987b\u548c\u5360\u7528\u6388\u4fe1\u989d\u5ea6\u5408\u8ba1\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u5360\u7528\u6388\u4fe1\u3002", (String)"GuaranteeEdit_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                model.setValue("creditactualamount", (Object)res.getRealBizAmt());
            }
        }
    }

    private void addGuarantorF7SelectListener() {
        BasedataEdit guarantor = (BasedataEdit)this.getControl("guarantor");
        if (EmptyUtil.isNoEmpty((Object)guarantor)) {
            guarantor.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                String guaranteeType = (String)this.getModel().getValue("guaranteetype");
                if (StringUtils.equals((CharSequence)guaranteeType, (CharSequence)PersonnelTypeEnum.BOS_ORG.getValue())) {
                    QFilter filter = new QFilter("fisbankroll", "=", (Object)"1");
                    showParameter.setCustomParam("orgFuncId", (Object)"08");
                    List filters = showParameter.getListFilterParameter().getQFilters();
                    filters.add(filter);
                }
            });
        }
    }

    private void addDraftBillF7SelectListener() {
        BasedataEdit draftBillF7 = (BasedataEdit)this.getControl("draftbill");
        draftBillF7.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.setCaption(this.getDraftBillShowFormCaption());
            showParameter.setMultiSelect(true);
            showParameter.getListFilterParameter().setQFilters(this.getDraftQFilters());
        });
    }

    private void addCreditLimitF7SelectListener() {
        BasedataEdit creditLimitEdit = (BasedataEdit)this.getControl("creditlimit");
        creditLimitEdit.addBeforeF7SelectListener(evt -> {
            String message = this.creditLimitValidator();
            if (EmptyUtil.isNoEmpty((String)message)) {
                this.getView().showTipNotification(message);
                evt.setCancel(true);
                return;
            }
            FormShowParameter sp = evt.getFormShowParameter();
            sp.setCustomParam("KEY_F7PARAM", (Object)this.createCreditLimitUseBean());
            sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "creditlimit"));
        });
    }

    private String creditLimitValidator() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (EmptyUtil.isEmpty((DynamicObject)dataEntity.getDynamicObject("company"))) {
            return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"GuaranteeEdit_6", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
        }
        if (EmptyUtil.isEmpty((BigDecimal)dataEntity.getBigDecimal("credittotalamount"))) {
            return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7968\u636e\u3002", (String)"GuaranteeEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
        }
        if (EmptyUtil.isEmpty((DynamicObject)dataEntity.getDynamicObject("creditlimitorg"))) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d34\u73b0\u673a\u6784\u6216\u6388\u4fe1\u673a\u6784\u3002", (String)"GuaranteeEdit_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
        }
        if (EmptyUtil.isEmpty((DynamicObject)dataEntity.getDynamicObject("credittype"))) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6388\u4fe1\u7c7b\u522b\u3002", (String)"GuaranteeEdit_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private CreditLimitUseBean createCreditLimitUseBean() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        CreditLimitUseBean useBean = new CreditLimitUseBean();
        Long id = (Long)dataEntity.getPkValue();
        if (EmptyUtil.isEmpty((Long)id)) {
            id = DB.genLongId((String)dataEntity.getDataEntityType().getAlias());
            dataEntity.set("id", (Object)id);
        }
        useBean.setPkId(id);
        useBean.setEntityName("cdm_guarantee_discount");
        useBean.setOrgId((Long)dataEntity.getDynamicObject("company").getPkValue());
        useBean.setCurrencyId((Long)dataEntity.getDynamicObject("currency").getPkValue());
        DynamicObject creditLimitOrg = dataEntity.getDynamicObject("creditlimitorg");
        useBean.setFinOrgId((Long)creditLimitOrg.getPkValue());
        DynamicObject creditTypeDy = dataEntity.getDynamicObject("credittype");
        useBean.setCreditTypeId((Long)creditTypeDy.getPkValue());
        DynamicObject draftType = dataEntity.getDynamicObject("drafttype");
        useBean.setCreditVariety(draftType.getString("name"));
        useBean.setBizAmt(dataEntity.getBigDecimal("credittotalamount"));
        useBean.setMaxAmt(dataEntity.getBigDecimal("credittotalamount"));
        useBean.setStartDate(dataEntity.getDate("bizdate"));
        DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("billentries");
        DynamicObject maxDateDy = entries.stream().max(Comparator.comparing(e -> e.getDynamicObject("draftbill").getDate("draftbillexpiredate"))).orElseGet(null);
        if (EmptyUtil.isNoEmpty((DynamicObject)maxDateDy)) {
            useBean.setEndDate(maxDateDy.getDynamicObject("draftbill").getDate("draftbillexpiredate"));
        }
        return useBean;
    }

    private void addDraftTypeF7SelectListener() {
        BasedataEdit draftTypeEdit = (BasedataEdit)this.getControl("drafttype");
        draftTypeEdit.addBeforeF7SelectListener(event -> {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            QFilter settlementTypeFilter = new QFilter("settlementtype", "=", (Object)SettleMentTypeEnum.BUSINESS.getValue());
            if (((Boolean)this.getModel().getValue("supportbankdraft")).booleanValue()) {
                settlementTypeFilter.or(new QFilter("settlementtype", "=", (Object)SettleMentTypeEnum.BANK.getValue()));
            }
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            showParameter.getListFilterParameter().setFilter(enableFilter.and(settlementTypeFilter));
        });
    }

    private void initCurrency() {
        DynamicObject baseCurrency;
        DynamicObject companyDO = this.getModel().getDataEntity().getDynamicObject("company");
        if (EmptyUtil.isNoEmpty((DynamicObject)companyDO) && EmptyUtil.isNoEmpty((DynamicObject)(baseCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)((Long)companyDO.getPkValue()))))) {
            this.getModel().setValue("currency", baseCurrency.getPkValue());
        }
    }

    private void initDraftType() {
        Object[] draftTypes = BusinessDataServiceHelper.load((String)"cdm_billtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("settlementtype", "=", (Object)SettleMentTypeEnum.BUSINESS.getValue()), new QFilter("enable", "=", (Object)"1")}, (String)"number asc", (int)0, (int)1);
        if (EmptyUtil.isNoEmpty((Object[])draftTypes)) {
            Object draftTypeDy = draftTypes[0];
            this.getModel().setValue("drafttype", draftTypeDy.getPkValue());
        }
    }

    private void initCreditType() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject draftTypeDy = dataEntity.getDynamicObject("drafttype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftTypeDy)) {
            DynamicObject creditType = draftTypeDy.getDynamicObject("credittype");
            this.getModel().setValue("credittype", EmptyUtil.isNoEmpty((DynamicObject)creditType) ? creditType : null);
        }
    }

    private void initDataFromBillPage() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List billIds = (List)customParams.get("billIds");
        if (EmptyUtil.isEmpty((Collection)billIds)) {
            return;
        }
        Object sourceBillId = customParams.get("sourceBillId");
        if (EmptyUtil.isNoEmpty(sourceBillId)) {
            this.getModel().setValue("sourcebillid", sourceBillId);
        }
        this.getModel().setValue("biztype", customParams.get("biztype"));
        this.batchFillBillEntry(billIds);
        this.sumDraftAmtAndCount();
        DynamicObject draft = this.getModel().getEntryRowEntity("billentries", 0).getDynamicObject("draftbill");
        if (EmptyUtil.isNoEmpty((DynamicObject)draft)) {
            long companyId = draft.getDynamicObject("company").getLong("id");
            GuaranteeEdit.setValWithoutPropChgEvt(this.getView(), this.getModel(), "company", companyId);
            GuaranteeEdit.setValWithoutPropChgEvt(this.getView(), this.getModel(), "currency", draft.getDynamicObject("currency").getPkValue());
            DynamicObject draftDb = TmcDataServiceHelper.loadSingle((Object)draft.getPkValue(), (String)"cdm_draftbillf7");
            DynamicObject draftType = draftDb.getDynamicObject("draftbilltype");
            String settlementType = draftType.getString("settlementtype");
            if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                GuaranteeEdit.setValWithoutPropChgEvt(this.getView(), this.getModel(), "supportbankdraft", true);
            }
            GuaranteeEdit.setValWithoutPropChgEvt(this.getView(), this.getModel(), "drafttype", draftType.getPkValue());
            GuaranteeEdit.setValWithoutPropChgEvt(this.getView(), this.getModel(), "rptype", draft.getString("rptype"));
        }
    }

    private void initDataForDetails() {
        DynamicObject data = this.getModel().getDataEntity(true);
        if (!data.getDataEntityState().getFromDatabase()) {
            return;
        }
        DynamicObjectCollection entries = this.getModel().getEntryEntity("billentries");
        Set draftBillIds = entries.stream().map(e -> e.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection draftList = QueryServiceHelper.query((String)"cdm_draftbillf7", (String)"id,amount,subbillrange,subbillquantity,subbillstartflag,subbillendflag,lockedamount,usedamount,availableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftBillIds)});
        Map<Object, Object> draftMap = new HashMap(8);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)draftList)) {
            draftMap = draftList.stream().collect(Collectors.toMap(d -> d.getLong("id"), x -> x));
        }
        for (DynamicObject e2 : entries) {
            DynamicObject draft = (DynamicObject)draftMap.get(e2.getDynamicObject("draftbill").getLong("id"));
            if (EmptyUtil.isEmpty((DynamicObject)draft)) continue;
            e2.set("billamountfield", (Object)draft.getBigDecimal("amount"));
            e2.set("subbillrangefield", (Object)draft.getString("subbillrange"));
            e2.set("subbillquantityfield", (Object)draft.getLong("subbillquantity"));
            e2.set("subbillstartflagfield", (Object)draft.getLong("subbillstartflag"));
            e2.set("subbillendflagfield", (Object)draft.getLong("subbillendflag"));
        }
        this.getView().updateView("billentries");
    }

    private void batchFillBillEntry(List<Object> draftIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject[] drafts = TmcDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id,availableamount,amount,currency,subbillrange,subbillquantity,subbillstartflag,subbillendflag,guarantcreditamount,guarantcreditlimit,guarantcreditlimitorg,guarantortext,guaranttype,guarantbizdate,guaranteeid", (QFilter[])new QFilter[]{new QFilter("id", "in", draftIds)});
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("draftbill", new Object[0]);
        boolean isGuarantee = StringUtils.equals((CharSequence)((String)model.getValue("biztype")), (CharSequence)GuaranteeTradeTypeEnum.GUARANTEE.getValue());
        if (isGuarantee) {
            vs.addField("creditamount", new Object[0]);
        } else {
            vs.addField("entrycreditamount", new Object[0]);
            vs.addField("entrycreditlimitorg", new Object[0]);
            vs.addField("entrycreditlimit", new Object[0]);
            vs.addField("entryguaranttype", new Object[0]);
            vs.addField("entryguarantortext", new Object[0]);
            vs.addField("entrybizdate", new Object[0]);
            vs.addField("guaranteeid", new Object[0]);
        }
        vs.addField("billamountfield", new Object[0]);
        vs.addField("subbillrangefield", new Object[0]);
        vs.addField("subbillquantityfield", new Object[0]);
        vs.addField("subbillstartflagfield", new Object[0]);
        vs.addField("subbillendflagfield", new Object[0]);
        Arrays.stream(drafts).filter(Objects::nonNull).forEach(draft -> {
            BigDecimal availableAmount = draft.getBigDecimal("availableamount");
            BigDecimal draftAmount = draft.getBigDecimal("amount");
            String subRange = draft.getString("subbillrange");
            long quantity = draft.getLong("subbillquantity");
            long startFlag = draft.getLong("subbillstartflag");
            long endFlag = draft.getLong("subbillendflag");
            if (isGuarantee) {
                BigDecimal creditAmount = EmptyUtil.isEmpty((BigDecimal)availableAmount) ? draft.getBigDecimal("amount") : availableAmount;
                vs.addRow(new Object[]{draft.getPkValue(), creditAmount, draftAmount, subRange, quantity, startFlag, endFlag});
            } else {
                vs.addRow(new Object[]{draft.getPkValue(), draft.getBigDecimal("guarantcreditamount"), draft.getString("guarantcreditlimitorg"), draft.getString("guarantcreditlimit"), draft.getString("guaranttype"), draft.getString("guarantortext"), draft.getDate("guarantbizdate"), draft.getLong("guaranteeid"), draftAmount, subRange, quantity, startFlag, endFlag});
            }
        });
        model.batchCreateNewEntryRow("billentries", vs);
    }

    private void sumCreditTotalAmount() {
        IDataModel model = this.getModel();
        DynamicObject dynamicObject = model.getDataEntity(true);
        if (StringUtils.equals((CharSequence)dynamicObject.getString("bizdate"), (CharSequence)GuaranteeTradeTypeEnum.UN_GUARANTEE.getValue())) {
            model.setValue("credittotalamount", (Object)BigDecimal.ZERO);
            return;
        }
        DynamicObjectCollection entries = dynamicObject.getDynamicObjectCollection("billentries");
        BigDecimal creditTotalAmount = entries.stream().map(o -> o.getBigDecimal("creditamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        model.setValue("credittotalamount", (Object)creditTotalAmount);
    }

    private void sumDraftAmtAndCount() {
        IDataModel model = this.getModel();
        DynamicObject dynamicObject = model.getDataEntity(true);
        DynamicObjectCollection entries = dynamicObject.getDynamicObjectCollection("billentries");
        BigDecimal totalAmount = entries.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("draftbill"))).map(o -> o.getDynamicObject("draftbill").getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        int count = entries.toArray().length;
        model.setValue("amount", (Object)totalAmount);
        model.setValue("count", (Object)count);
        this.sumCreditTotalAmount();
    }

    private void processCreditLimit() {
        IDataModel model = this.getModel();
        model.setValue("creditlimitorg", null);
        model.setValue("discountorg", null);
        model.setValue("credittype", null);
        model.setValue("creditcurrency", null);
        model.setValue("creditlimit", null);
    }

    private void selectDraftBill() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"cdm_draftbillf7", (boolean)true, (int)2, (boolean)true);
        listShowParameter.setShowTitle(false);
        listShowParameter.setCaption(this.getDraftBillShowFormCaption());
        listShowParameter.getListFilterParameter().setQFilters(this.getDraftQFilters());
        listShowParameter.setMultiSelect(true);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectdraft"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private String getDraftBillShowFormCaption() {
        return StringUtils.equals((CharSequence)((String)this.getModel().getValue("rptype")), (CharSequence)ReceivePayTypeEnum.RECEIVEBILL.getValue()) ? ResManager.loadKDString((String)"\u6536\u7968\u767b\u8bb0", (String)"TradeBillTplEdit_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f00\u7968\u767b\u8bb0", (String)"TradeBillTplEdit_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
    }

    private List<QFilter> getDraftQFilters() {
        AbstractGuaranteeTrade guaranteeTradeType = GuaranteeTradeFactory.getGuaranteeTradeType((String)((String)this.getModel().getValue("biztype")));
        return guaranteeTradeType.getDraftQFilters(this.getModel());
    }

    private void processGuarantor() {
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)((String)this.getModel().getValue("biztype")), (CharSequence)GuaranteeTradeTypeEnum.UN_GUARANTEE.getValue())) {
            return;
        }
        String guaranteeType = (String)model.getValue("guaranteetype");
        if (EmptyUtil.isNotEmpty((CharSequence)guaranteeType)) {
            if (StringUtils.equals((CharSequence)guaranteeType, (CharSequence)PersonnelTypeEnum.OTHER.getValue())) {
                model.setValue("guaranteebasetype", null);
            } else {
                model.setValue("guaranteebasetype", (Object)guaranteeType);
                model.setValue("guarantortext", null);
            }
        }
        this.initGuarantor();
    }

    private void initGuarantor() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String guaranteeType = (String)model.getValue("guaranteetype");
        if (EmptyUtil.isNotEmpty((CharSequence)guaranteeType)) {
            boolean isOther = StringUtils.equals((CharSequence)guaranteeType, (CharSequence)PersonnelTypeEnum.OTHER.getValue());
            view.setVisible(Boolean.valueOf(isOther), new String[]{"guarantortext"});
            view.setVisible(Boolean.valueOf(!isOther), new String[]{"guarantor"});
        }
    }

    private void initBizTypeRelease() {
        AbstractGuaranteeTrade guaranteeTradeType = GuaranteeTradeFactory.getGuaranteeTradeType((String)((String)this.getModel().getValue("biztype")));
        guaranteeTradeType.initBizTypeReleaseControl(this.getView());
        this.processGuarantor();
    }

    private void initCreditUse() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObject creditLimit = dataEntity.getDynamicObject("creditlimit");
        if (EmptyUtil.isNoEmpty((DynamicObject)creditLimit)) {
            long billId = dataEntity.getLong("id");
            if (EmptyUtil.isEmpty((Long)billId)) {
                return;
            }
            Object[] creditUses = TmcDataServiceHelper.load((String)"cfm_credituse", (String)"sourcebillentryid, currency, realamt", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)billId), new QFilter("isrelease", "=", (Object)"0")});
            if (EmptyUtil.isNoEmpty((Object[])creditUses)) {
                Object creditUs = creditUses[0];
                Long currency = creditUs.getDynamicObject("currency").getLong("id");
                model.setValue("creditcurrency", (Object)currency);
                model.setValue("credittotalamount", (Object)creditUs.getBigDecimal("realamt"));
            }
        }
    }

    private boolean validateCreditAmount(DynamicObject draftBill, Object oldValue, Object newValue, int rowIndex) {
        BigDecimal billAmount = draftBill.getBigDecimal("amount");
        boolean reset = false;
        if (EmptyUtil.isNoEmpty((Object)newValue)) {
            BigDecimal creditAmount = (BigDecimal)newValue;
            if (creditAmount.compareTo(BigDecimal.ZERO) <= 0 || creditAmount.compareTo(billAmount) > 0) {
                reset = true;
            }
        } else {
            reset = true;
        }
        return reset;
    }

    public static void setValWithoutPropChgEvt(IFormView view, IDataModel model, String key, Object value) {
        model.beginInit();
        model.setValue(key, value);
        model.endInit();
        view.updateView(key);
    }
}

