/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.bean.CostCalRequest;
import kd.tmc.cfm.common.helper.InterestCalcHelper;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.ListUtils;

public class FinCostCalCommonHelper {
    private static final Log logger = LogFactory.getLog(FinCostCalCommonHelper.class);
    public static final String SELECT_FIELDS = "case when loantype = 'entrust' or loantype = 'ec' then 2 when loantype = 'bond' then 1 when ( loantype = 'loan' or loantype = 'sl' ) and creditortype = 'bank' then 0 else 3 end as financetype,org.id as orgid,org.id as company,org.name companyname,currency.id as currency,currency.number as currencynumber,currency.name as currencyname,finproduct.name as finproductname,finproduct.id as finproductid,finproduct.perpetualbond as perpetualbond,isnofixedterm,region,loantype,textcreditor,interesttype,drawamount,startintdate,endinstdate,drawtype,cleardate,interestsettledplan.intereststpd as intereststpd,case when renewalexpiredate is null then expiredate else renewalexpiredate end as expiredate,expiredate as srcexpiredate,billno,contractno,loancontractbill.number  contractbillno,creditortype,creditor,id";
    private static final String[] INT_FIELD_NAMES = new String[]{"principle", "intrate", "begindate", "enddate", "daynum", "dayweight", "term", "residueterm", "inststartdate", "instenddate"};
    private static final String[] INT_JOIN_FIELDS = new String[]{"interestbegindate", "interestenddate", "interestprinciple", "interestrate"};
    private static final DataType[] INT_DATA_TYPES = new DataType[]{DataType.BigDecimalType, DataType.BigDecimalType, DataType.DateType, DataType.DateType, DataType.IntegerType, DataType.BigDecimalType, DataType.StringType, DataType.StringType, DataType.DateType, DataType.DateType};

    public static DataSet getAllViewData(CostCalRequest request, Map<String, Object> paramMap) {
        QFilter filter = request.getFilter();
        DataSet financeCostDataSet = FinCostCalCommonHelper.queryLoanBillDs(filter, paramMap);
        HashSet<Long> loanBillIds = new HashSet<Long>(16);
        HashSet<Long> bankCreditorIds = new HashSet<Long>(16);
        HashSet<Long> companyCreditorIds = new HashSet<Long>(16);
        HashSet<Long> currencys = new HashSet<Long>(16);
        ArrayList<Object[]> currencyRow = new ArrayList<Object[]>(10);
        DataSet copyDataSet = financeCostDataSet.copy();
        for (Row row : copyDataSet) {
            Long loanBillid = row.getLong("id");
            loanBillIds.add(loanBillid);
            Long currency = row.getLong("currency");
            if (currencys.add(currency)) {
                currencyRow.add(new Object[]{currency});
            }
            if (CreditorTypeEnum.BANK.getValue().equals(row.getString("creditortype")) || CreditorTypeEnum.FINORG.getValue().equals(row.getString("creditortype"))) {
                bankCreditorIds.add(row.getLong("creditor"));
            }
            if (!CreditorTypeEnum.CUSTOM.getValue().equals(row.getString("creditortype"))) continue;
            companyCreditorIds.add(row.getLong("creditor"));
        }
        QFilter qFilter = new QFilter("id", "in", bankCreditorIds);
        DataSet finOrgInfos = QueryServiceHelper.queryDataSet((String)"financecostdatahelper.getfinorginfo", (String)"bd_finorginfo", (String)"id,org.id as finorgid,bank_cate.id as bankcate,bank_cate.name as bankcatename", (QFilter[])qFilter.toArray(), null);
        QFilter companyCreditorFilter = new QFilter("id", "in", companyCreditorIds);
        DataSet partnerUnits = QueryServiceHelper.queryDataSet((String)"financecostdatahelper.getpartner", (String)"bd_bizpartner", (String)"id,internal_company.id as partnerorgid", (QFilter[])companyCreditorFilter.toArray(), null);
        String[] fieldNames = financeCostDataSet.getRowMeta().getFieldNames();
        financeCostDataSet = financeCostDataSet.leftJoin(finOrgInfos).on("creditor", "id").select(fieldNames, new String[]{"finorgid", "bankcate", "bankcatename"}).finish();
        String[] fieldNames2 = financeCostDataSet.getRowMeta().getFieldNames();
        financeCostDataSet = financeCostDataSet.leftJoin(partnerUnits).on("creditor", "id").select(fieldNames2, new String[]{"partnerorgid"}).finish();
        financeCostDataSet = financeCostDataSet.addField("case when finorgid is not null then finorgid when creditortype = 'innerunit' then creditor when partnerorgid is not null then partnerorgid else 0 end", "creditorinnerorg");
        long startTime = System.currentTimeMillis();
        DataSet interestDataSet = FinCostCalCommonHelper.getInterestDataSet(request.getQueryStartDate(), request.getQueryEndDate(), new ArrayList<Long>(loanBillIds));
        logger.info("getInterestDataSet()\u5229\u606f\u8ba1\u7b97\uff0c\u603b\u5171\u6267\u884c\u65f6\u95f4\uff1a{}", (Object)((System.currentTimeMillis() - startTime) / 1000L));
        String[] fieldNames4 = financeCostDataSet.getRowMeta().getFieldNames();
        financeCostDataSet = financeCostDataSet.leftJoin(interestDataSet).on("id", "loanbillid").select(fieldNames4, INT_JOIN_FIELDS).finish().filter("interestprinciple is not null");
        financeCostDataSet = financeCostDataSet.addFields(new String[]{"drawamount", "interestprinciple"}, new String[]{"srcdrawamount", "srcprinciple"});
        if (EmptyUtil.isNoEmpty((Long)request.getOrgViewId())) {
            DataSet currencyDs = FinCostCalCommonHelper.createCurrencyDs(currencyRow);
            financeCostDataSet = AmountTransHelper.tranDataSetRate((DataSet)financeCostDataSet, (DataSet)currencyDs, (Long)request.getOrgViewId(), (Long)request.getBaseCurrency(), (String)"currency", Collections.emptySet(), (Date)request.getQueryEndDate());
        }
        financeCostDataSet = FinCostCalCommonHelper.handleIntCalc(financeCostDataSet, request.getQueryStartDate(), request.getQueryEndDate());
        financeCostDataSet = financeCostDataSet.addFields(new String[]{"principle * dayweight", "principle * dayweight * intrate / 100"}, new String[]{"avgbalance", "interest"});
        return financeCostDataSet;
    }

    private static DataSet queryLoanBillDs(QFilter filter, Map<String, Object> paramMap) {
        ArrayList<DataSet> dataDS = new ArrayList<DataSet>();
        FinCostCalCommonHelper.addDataSet(dataDS, paramMap, filter, FinCostCalCommonHelper.initCriditorFilter(paramMap), Arrays.asList("sl", "bond"), false, "cfm_loanbill");
        FinCostCalCommonHelper.addDataSet(dataDS, paramMap, filter, FinCostCalCommonHelper.initSlCriditorFilter(paramMap), Collections.singletonList("sl"), true, "cfm_loanbill");
        FinCostCalCommonHelper.addDataSet(dataDS, paramMap, filter, FinCostCalCommonHelper.initBondCriditorFilter(paramMap), Collections.singletonList("bond"), true, "cfm_loanbill_bond");
        return (DataSet)dataDS.stream().reduce(DataSet::union).get();
    }

    public static void addDataSet(List<DataSet> dataDS, Map<String, Object> paramMap, QFilter filter, QFilter selfFilter, List<String> loanTypeList, boolean isIn, String entityName) {
        QFilter loanTypeFilter = new QFilter("loantype", isIn ? "in" : "not in", loanTypeList);
        String loantype = (String)paramMap.get("filter_loantype");
        QFilter loanFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (EmptyUtil.isNoEmpty((String)loantype)) {
            List loantypeList = Arrays.stream(loantype.split(",")).filter(EmptyUtil::isNoEmpty).filter(r -> isIn ? loanTypeList.contains(r) : !loanTypeList.contains(r)).collect(Collectors.toList());
            loanFilter = new QFilter("loantype", "in", loantypeList);
        }
        DataSet loanDs = QueryServiceHelper.queryDataSet((String)"cfm_loanbill.getLoanDs", (String)entityName, (String)SELECT_FIELDS, (QFilter[])new QFilter[]{filter, selfFilter, loanTypeFilter, loanFilter}, null);
        dataDS.add(loanDs);
    }

    public static QFilter initBondCriditorFilter(Map<String, Object> paramMap) {
        String creditorType = (String)paramMap.get("filter_creditortype");
        String creditorId = (String)paramMap.get("filter_creditorid");
        QFilter typeQFilter = null;
        if (EmptyUtil.isNoEmpty((String)creditorType)) {
            typeQFilter = new QFilter("investor_entry.e_investortype", "in", Arrays.asList(creditorType.split(";")));
        }
        QFilter creditorQFilter = null;
        String creditorStr = (String)paramMap.get("filter_creditor");
        if (EmptyUtil.isNoEmpty((String)creditorType) || EmptyUtil.isEmpty((String)creditorType) && EmptyUtil.isNoEmpty((String)creditorStr)) {
            if (CreditorTypeEnum.OTHER.getValue().equals(creditorType)) {
                creditorQFilter = new QFilter("investor_entry.e_investorname", "like", (Object)("%" + creditorStr + "%"));
            } else if (EmptyUtil.isNoEmpty((String)creditorId)) {
                long[] creditorIds = Arrays.asList(creditorId.split(";")).stream().mapToLong(Long::parseLong).toArray();
                creditorQFilter = new QFilter("investor_entry.e_investorid", "in", (Object)creditorIds);
            }
        }
        return typeQFilter != null ? typeQFilter.and(creditorQFilter) : creditorQFilter;
    }

    public static QFilter initSlCriditorFilter(Map<String, Object> paramMap) {
        String creditorType = (String)paramMap.get("filter_creditortype");
        String creditorId = (String)paramMap.get("filter_creditorid");
        QFilter typeQFilter = null;
        if (EmptyUtil.isNoEmpty((String)creditorType)) {
            typeQFilter = new QFilter("creditortype", "=", (Object)creditorType);
        }
        QFilter creditorQFilter = null;
        String creditorStr = (String)paramMap.get("filter_creditor");
        if (EmptyUtil.isNoEmpty((String)creditorType) || EmptyUtil.isEmpty((String)creditorType) && EmptyUtil.isNoEmpty((String)creditorStr)) {
            if (CreditorTypeEnum.OTHER.getValue().equals(creditorType)) {
                creditorQFilter = new QFilter("banksyndicate_entry.e_bank.name", "like", (Object)("%" + creditorStr + "%"));
            } else if (EmptyUtil.isNoEmpty((String)creditorId)) {
                long[] creditorIds = Arrays.asList(creditorId.split(";")).stream().mapToLong(Long::parseLong).toArray();
                creditorQFilter = new QFilter("banksyndicate_entry.e_bank.id", "in", (Object)creditorIds);
            }
        }
        return typeQFilter != null ? typeQFilter.and(creditorQFilter) : creditorQFilter;
    }

    private static DataSet createCurrencyDs(List<Object[]> currencyRow) {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[]{"currency"}, (DataType[])new DataType[]{DataType.LongType});
        CollectionInput inputs = new CollectionInput(rowMeta, currencyRow);
        return Algo.create((String)"financecostcommonhelper.new").createDataSet(new Input[]{inputs});
    }

    private static DataSet getInterestDataSet(Date beginDate, Date endDate, List<Long> loanBillIds) {
        DataSetBuilder datasetBuilder = Algo.create((String)"intBill").createDataSetBuilder(FinCostCalCommonHelper.getRowMeta());
        List loanBillIdLists = ListUtils.splitList(loanBillIds, (long)100L);
        for (List loanBillids : loanBillIdLists) {
            Map intBillInfoMap = InterestCalcHelper.batchCallInt((List)loanBillids, (Date)beginDate, (Date)endDate, (boolean)true);
            for (Long loanId : loanBillIds) {
                List details;
                Object billInfo = intBillInfoMap.get(loanId);
                IntBillInfo intBill = billInfo == null || billInfo instanceof IntBillInfo ? (IntBillInfo)billInfo : (IntBillInfo)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(billInfo), IntBillInfo.class);
                if (null == intBill || !EmptyUtil.isNoEmpty((Object)(details = intBill.getDetails()))) continue;
                for (IntBillDetailInfo detail : details) {
                    Date intStartDate = detail.getBeginDate();
                    Date intEndDate = detail.getEndDate();
                    BigDecimal principle = detail.getPrinciple();
                    BigDecimal yearrate = detail.getRate();
                    Object[] row = new Object[]{loanId, intStartDate, intEndDate, principle, yearrate};
                    datasetBuilder.append(row);
                }
            }
        }
        return datasetBuilder.build();
    }

    private static RowMeta getRowMeta() {
        ArrayList<Field> field = new ArrayList<Field>();
        field.add(new Field("loanbillid", (DataType)DataType.LongType));
        field.add(new Field("interestbegindate", (DataType)DataType.DateType));
        field.add(new Field("interestenddate", (DataType)DataType.DateType));
        field.add(new Field("interestprinciple", (DataType)DataType.BigDecimalType));
        field.add(new Field("interestrate", (DataType)DataType.BigDecimalType));
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        return rowMeta;
    }

    public static DataSet handleIntCalc(DataSet unionDataSet, Date queryBeginDate, Date queryDate) {
        DataType[] dataTypes = unionDataSet.getRowMeta().getDataTypes();
        String[] fieldNames = unionDataSet.getRowMeta().getFieldNames();
        String[] newFieldNames = new String[fieldNames.length + INT_FIELD_NAMES.length];
        DataType[] newDataTypes = new DataType[dataTypes.length + INT_DATA_TYPES.length];
        System.arraycopy(fieldNames, 0, newFieldNames, 0, fieldNames.length);
        System.arraycopy(INT_FIELD_NAMES, 0, newFieldNames, fieldNames.length, INT_FIELD_NAMES.length);
        System.arraycopy(dataTypes, 0, newDataTypes, 0, dataTypes.length);
        System.arraycopy(INT_DATA_TYPES, 0, newDataTypes, dataTypes.length, INT_DATA_TYPES.length);
        RowMeta builderMeta = RowMetaFactory.createRowMeta((String[])newFieldNames, (DataType[])newDataTypes);
        DataSetBuilder builder = Algo.create((String)"FinanceCostDataHelper.handleIntCalc").createDataSetBuilder(builderMeta);
        for (Row row : unionDataSet) {
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{row.getDate("interestbegindate"), row.getDate("interestenddate"), row.getBigDecimal("interestprinciple"), row.getBigDecimal("interestrate")})) continue;
            FinCostCalCommonHelper.dealQueryDate(queryBeginDate, fieldNames, builder, row, queryDate);
        }
        return builder.build();
    }

    public static void dealQueryDate(Date queryBeginDate, String[] fieldNames, DataSetBuilder builder, Row row, Date queryEndDate) {
        Date intBeginDate = row.getDate("interestbegindate");
        Date intEndDate = row.getDate("interestenddate");
        if (intBeginDate.compareTo(queryEndDate) <= 0 && intEndDate.compareTo(queryBeginDate) >= 0) {
            ArrayList<Object> appendRow = new ArrayList<Object>(fieldNames.length + INT_FIELD_NAMES.length);
            Date lastBeginDate = intBeginDate.compareTo(queryBeginDate) >= 0 ? intBeginDate : queryBeginDate;
            Date lastEndDate = intEndDate.compareTo(queryEndDate) <= 0 ? intEndDate : queryEndDate;
            int realDays = DateUtils.getDiffDays((Date)lastBeginDate, (Date)lastEndDate);
            int queryDays = DateUtils.getDiffDays((Date)queryBeginDate, (Date)queryEndDate) - 1;
            for (int j = 0; j < fieldNames.length; ++j) {
                appendRow.add(row.get(j));
            }
            appendRow.add(row.get("interestprinciple"));
            appendRow.add(row.get("interestrate"));
            appendRow.add(lastBeginDate);
            appendRow.add(lastEndDate);
            appendRow.add(realDays);
            appendRow.add(new BigDecimal(realDays).divide(new BigDecimal(queryDays), 10, RoundingMode.HALF_UP));
            appendRow.add(DateUtils.getDiff_ymd((Date)row.getDate("startintdate"), (Date)row.getDate("expiredate")));
            appendRow.add(DateUtils.getDiff_ymd((Date)queryEndDate, (Date)row.getDate("expiredate")));
            appendRow.add(intBeginDate);
            appendRow.add(intEndDate);
            builder.append(appendRow.toArray());
        }
    }

    public static Set<Long> getDataSetIds(DataSet ds, String field) {
        HashSet<Long> slBillIds = new HashSet<Long>(16);
        for (Row row : ds.copy()) {
            Long loanBillid = row.getLong(field);
            slBillIds.add(loanBillid);
        }
        return slBillIds;
    }

    public static QFilter initCriditorFilter(Map<String, Object> paramMap) {
        String creditorType = (String)paramMap.get("filter_creditortype");
        String creditorId = (String)paramMap.get("filter_creditorid");
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (EmptyUtil.isNoEmpty((String)creditorType)) {
            qFilter = new QFilter("creditortype", "in", Arrays.asList(creditorType.split(";")));
            if (CreditorTypeEnum.OTHER.getValue().equals(creditorType)) {
                String creditorStr = (String)paramMap.get("filter_creditor");
                qFilter.and("textcreditor", "like", (Object)("%" + creditorStr + "%"));
            }
            if (EmptyUtil.isNoEmpty((String)creditorId)) {
                long[] creditorIds = Arrays.stream(creditorId.split(";")).mapToLong(Long::parseLong).toArray();
                qFilter.and("creditor", "in", (Object)creditorIds);
            }
        }
        return qFilter;
    }
}

