/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.common.service.writeback;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.cfm.common.bean.LoanBillIntBillInfo;
import kd.tmc.cfm.common.bean.LoanWriteParam;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.repository.bean.LoanBillPreIntEndDate;
import kd.tmc.cfm.common.service.writeback.AbstractLoanBillWriteService;

public class LoanBillPreIntBillWriteService
extends AbstractLoanBillWriteService {
    public void doWrite(List<DynamicObject> loanBills, LoanWriteParam param) {
        this.logger.info("\u5229\u606f\u9884\u63d0\u5355\u4fdd\u5b58\u548c\u5220\u9664\u53cd\u5199\u63d0\u6b3e\u5355\u4e0a\u4e00\u9884\u63d0\u7ed3\u606f\u65e5, param:{}", (Object)param);
        Map preInstEndDateMap = this.getLoanBillLastPreInstEndDate(loanBills);
        for (DynamicObject loanBill : loanBills) {
            LoanBillPreIntEndDate preIntEndDate = (LoanBillPreIntEndDate)preInstEndDateMap.get(loanBill.getLong("id"));
            this.setLastPreEndDate(loanBill, preIntEndDate);
        }
    }

    public void doWrite(DynamicObject loanBill, LoanWriteParam param) {
        this.doWrite(Collections.singletonList(loanBill), param);
    }

    public boolean doFiter(DynamicObject loanBill, LoanWriteParam param) {
        return param.isReSaveLoan() || LoanWBTypeEnum.PREINTEREST == param.getLoanWBType();
    }

    protected void setLastPreEndDate(DynamicObject loanBill, LoanBillPreIntEndDate preIntBean) {
        Date preInstEndDate = preIntBean.getPreInstEndDate();
        Date initEndPreInstDate = loanBill.getDate("initendpreinstdate");
        if (!preIntBean.isRedWriteOffParam()) {
            Date lastPreIntDate = Optional.ofNullable(preInstEndDate).orElse(initEndPreInstDate);
            loanBill.set("endpreinstdate", (Object)lastPreIntDate);
            return;
        }
        LoanBillIntBillInfo intBillInfo = preIntBean.getIntBillInfo();
        Date instEndDate = intBillInfo != null ? intBillInfo.getEndIntDate() : null;
        this.setEndPreInstDate(loanBill, preInstEndDate, instEndDate);
    }
}

