/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.contractbill;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.AdjustEleEnum;
import kd.tmc.cfm.common.enums.ApplyBizStatusEnum;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.BondTypeEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.ContractStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.ProductFactoryCcyRuleEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.enums.RateSignEnum;
import kd.tmc.cfm.common.enums.RelationTypeEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.helper.ContractPushHelper;
import kd.tmc.cfm.common.helper.ExtendHelper;
import kd.tmc.cfm.common.helper.FormParameterHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.helper.RateHelper;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.cfm.formplugin.loanbill.LoanBillFormHelper;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.GuaUseStatusEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.GuaranteeEntryHelper;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.WorkCalendarHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.helper.IntcalMethodChgHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ContractBaseEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(ContractBaseEdit.class);
    private static final String[] GCProps = new String[]{"gcontract", "gratio", "gamount", "gsrcbillid", "gexchrate", "gcomment", "gdebtbalance", "gcontract.amount", "gcontract.currency", "gcreditortype", "gcreditor", "gcreditortext"};
    private static String[] BASE_PROPS = new String[]{"finproduct", "productfactory", "currency", "accountbank", "loaneracctbank", "referencerate", "clientorg", "e_drawacctbank"};

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        CfmBillCommonHelper.PreOpenPageDeal((PreOpenFormEventArgs)e, (boolean)false);
    }

    public void afterBindData(EventObject e) {
        Boolean isSyncDraw;
        BigDecimal bindStartInterestRate;
        DynamicObject finProduct;
        DynamicObject pf;
        super.afterBindData(e);
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        LoanBillFormHelper.initEnableMustInputBySofr((IDataModel)this.getModel(), (IFormView)this.getView());
        if (OperationStatus.VIEW != opStatus && "cfm_loancontractbill".equals(this.getModel().getDataEntityType().getName())) {
            String loanType = (String)this.getModel().getValue("loantype");
            this.initLoanTypeCombo();
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"loantype", (Object)loanType);
            this.initCreditorTypeCombo();
        }
        Boolean isCalInterest = (Boolean)this.getModel().getValue("iscallint");
        String bizType = (String)this.getModel().getValue("loantype");
        if (isCalInterest.booleanValue() && !BizTypeEnum.BOND.getValue().equals(bizType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"interesttype", "basis", "repaymentway"});
            this.registerMustInputByInterestType();
            this.registerMustInputByAdustStyle();
            this.registerMustInputByRepaymentway();
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entity = this.getModel().getDataEntity().getDataEntityType().getName();
        if (customParams.containsKey("confirm") && "cfm_loancontractbill".equals(entity) && EmptyUtil.isEmpty((Object)this.getModel().getValue("finproduct")) && (pf = (DynamicObject)this.getModel().getValue("productfactory")) != null && (finProduct = pf.getDynamicObject("finproduct")) != null) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"finproduct", (Object)finProduct);
        }
        this.initPayWayComb();
        this.setLoanAmount();
        if (BillStatusEnum.AUDIT.getValue().equals(this.getModel().getValue("billstatus"))) {
            this.appendLoanBillGcBills(this.queryLoanBillGcBills());
            this.getView().getPageCache().put("isDeleteEntry", "false");
        }
        if (EmptyUtil.isEmpty((BigDecimal)(bindStartInterestRate = (BigDecimal)this.getModel().getValue("startinterestrate")))) {
            this.setContractInterestRate();
        }
        this.setLatestRate();
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (BillStatusEnum.SAVE.getValue().equals(this.getModel().getValue("billstatus")) && pkValue == 0L) {
            this.intcalMethodChgEvt();
            LoanBillFormHelper.initIntCalBox((IDataModel)this.getModel(), (IFormView)this.getView());
        }
        if ((isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw")).booleanValue()) {
            this.syncdrawChangedEvent(true);
        }
        this.loadUnWriteOffAmt();
    }

    private void loadUnWriteOffAmt() {
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        String entityName = this.getModel().getDataEntityType().getName();
        if (entityName.startsWith("fl_") || operationStatus == OperationStatus.ADDNEW) {
            return;
        }
        BigDecimal noWriteOffPreInstAmt = LoanBillHelper.getNoWriteOffPreInstAmt((DynamicObject)this.getModel().getDataEntity(), (boolean)true);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"unwriteoffamt", (Object)noWriteOffPreInstAmt);
    }

    private void setLoanAmount() {
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"loanamount", (Object)amount);
        this.getModel().setDataChanged(false);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if ("cfm_loancontractbill".equals(this.getModel().getDataEntityType().getName())) {
            String defLoanType = (String)this.getModel().getValue("loantype");
            if (EmptyUtil.isEmpty((String)defLoanType)) {
                Set bizTypes = FormParameterHelper.getBizTypes((IFormView)this.getView());
                if (bizTypes.contains(BizTypeEnum.LOAN.getValue()) || bizTypes.contains(BizTypeEnum.SL.getValue())) {
                    defLoanType = BizTypeEnum.LOAN.getValue();
                } else if (bizTypes.contains(BizTypeEnum.EC.getValue()) || bizTypes.contains(BizTypeEnum.ENTRUST.getValue())) {
                    defLoanType = BizTypeEnum.EC.getValue();
                }
            }
            this.getModel().setValue("loantype", (Object)defLoanType);
            if (BizTypeEnum.LOAN.getValue().equals(defLoanType) || BizTypeEnum.SL.getValue().equals(defLoanType)) {
                this.getModel().setValue("creditortype", (Object)CreditorTypeEnum.BANK.getValue());
            }
            if (BizTypeEnum.EC.getValue().equals(defLoanType) || BizTypeEnum.ENTRUST.getValue().equals(defLoanType)) {
                this.getModel().setValue("creditortype", (Object)CreditorTypeEnum.INNERUNIT.getValue());
            }
        }
        this.intcalMethodChgEvt();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.copyDataByProduct();
        Date startDate = DateUtils.getCurrentDate();
        this.getModel().setValue("startdate", (Object)startDate);
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (EmptyUtil.isNoEmpty((Object)endDate)) {
            String term = DateUtils.getDiff_ymd((Date)startDate, (Date)endDate);
            this.getModel().setValue("term", (Object)term);
        }
        this.getModel().setValue("interestrate", this.getModel().getValue("startinterestrate"));
        String interestType = (String)this.getModel().getValue("interesttype");
        if (InterestTypeEnum.isAgree((String)interestType)) {
            this.getModel().setValue("interesttype", (Object)InterestTypeEnum.FIXED.getValue());
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("drawdownplan_entry");
        entrys.clear();
        this.checkAcctBank("accountbank");
        this.checkAcctBank("loaneracctbank");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar b = (Toolbar)this.getControl("tbmain");
        b.addItemClickListener((ItemClickListener)this);
        for (String prop : BASE_PROPS) {
            BasedataEdit control = (BasedataEdit)this.getControl(prop);
            if (control == null) continue;
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!BillStatusEnum.SAVE.getValue().equals(billStatus) || billShowParameter.getStatus() == OperationStatus.VIEW) {
            e.setCheckDataChange(false);
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        switch (key) {
            case "rateadjustdate": {
                if (EmptyUtil.isEmpty((Object)value)) {
                    return;
                }
                this.validateFirstRateAdjustDate(e, key, value.toString());
                break;
            }
            case "term": {
                if (TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString())) break;
                e.setCancel(true);
                this.getView().updateView(key);
                break;
            }
            case "startdate": {
                if (value == null) {
                    return;
                }
                Date endDateYet = (Date)this.getModel().getValue("enddate");
                if (endDateYet == null) {
                    return;
                }
                String fmtStrYet = ((DateEdit)this.getControl("startdate")).getFormatString();
                Date startDateYet = DateUtils.stringToDate((String)value.toString(), (String)fmtStrYet);
                if (!startDateYet.after(endDateYet)) break;
                e.setCancel(true);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u5c0f\u4e8e%2$s\u3002", (String)"ContractBaseEdit_07", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)"enddate"), CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)"startdate")));
                this.getView().updateView(key);
                break;
            }
            case "enddate": {
                if (value == null) {
                    return;
                }
                Date startDate = (Date)this.getModel().getValue("startdate");
                if (startDate == null) {
                    return;
                }
                String fmtStr = ((DateEdit)this.getControl("enddate")).getFormatString();
                Date endDate = DateUtils.stringToDate((String)value.toString(), (String)fmtStr);
                if (!startDate.after(endDate)) break;
                e.setCancel(true);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u5c0f\u4e8e%2$s\u3002", (String)"ContractBaseEdit_07", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)"enddate"), CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)"startdate")));
                this.getView().updateView(key);
                break;
            }
            case "syncterm": {
                if (!EmptyUtil.isNoEmpty((String)value.toString()) || TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString())) break;
                e.setCancel(true);
                this.getView().updateView(key);
                break;
            }
            case "expiredate": {
                if (EmptyUtil.isEmpty((Object)value)) {
                    return;
                }
                Date startIntDate = (Date)this.getModel().getValue("startintdate");
                if (startIntDate == null) {
                    return;
                }
                String formatStr = ((DateEdit)this.getControl("expiredate")).getFormatString();
                Date expireDate = DateUtils.stringToDate((String)value.toString(), (String)formatStr);
                if (!startIntDate.after(expireDate)) break;
                e.setCancel(true);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u5c0f\u4e8e%2$s\u3002", (String)"ContractBaseEdit_07", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)"expiredate"), CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)"startintdate")));
                this.getView().updateView(key);
                break;
            }
            case "rateresetdays": {
                if (EmptyUtil.isEmpty((Object)value)) break;
                Integer rateResetDays = Integer.valueOf((String)value);
                if (rateResetDays > 365) {
                    e.setCancel(true);
                    this.getModel().setValue("rateresetdays", (Object)365);
                    this.getView().updateView(key);
                }
                if (rateResetDays >= 0) break;
                e.setCancel(true);
                this.getModel().setValue("rateresetdays", (Object)0);
                this.getView().updateView(key);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "accountbank": 
            case "loaneracctbank": 
            case "e_drawacctbank": {
                this.accountBankF7Evt(e);
                break;
            }
            case "clientorg": {
                this.clientOrgF7Evt(e);
                break;
            }
            case "finproduct": {
                this.finproductF7Evt(e);
                break;
            }
            case "currency": {
                LoanBillFormHelper.currencyF7Evt((BeforeF7SelectEvent)e, (IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "referencerate": {
                RateHelper.referenceRateF7Evt((BeforeF7SelectEvent)e, (IDataModel)this.getModel(), (IFormView)this.getView(), (String)"startdate");
                break;
            }
            case "productfactory": {
                this.productFactoryF7Evt(e);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "org": {
                this.orgChgEvt();
                break;
            }
            case "loantype": {
                this.loanTypeChgEvt();
                break;
            }
            case "finproduct": {
                this.finproductChgEvt(e);
                this.showSyncCreditLimit(false);
                break;
            }
            case "term": {
                this.termChgEvt();
                break;
            }
            case "startdate": 
            case "enddate": {
                LoanBillFormHelper.resetRateResetCycleDate((IDataModel)this.getModel(), (String)"startdate");
                this.startDateChgEvt();
                this.endDateChgEvt();
                this.setContractInterestRate();
                break;
            }
            case "productfactory": {
                LoanBillFormHelper.initIntCalBox((IDataModel)this.getModel(), (IFormView)this.getView());
                this.productFactoryChgEvt();
                this.showSyncCreditLimit(false);
                LoanBillFormHelper.resetRateResetCycleDate((IDataModel)this.getModel(), (String)"startdate");
                break;
            }
            case "bondtype": {
                this.bondtypeChgEvt(e);
                break;
            }
            case "interesttype": {
                this.interestTypeChgEvt();
                this.setSyncDrawFloatRate();
                LoanBillFormHelper.initIntCalBox((IDataModel)this.getModel(), (IFormView)this.getView());
                this.setInterestSettledPlan();
                break;
            }
            case "rateadjuststyle": {
                this.rateadjuststyleChgEvt();
                this.setSyncDrawFloatRate();
                LoanBillFormHelper.resetRateResetCycleDate((IDataModel)this.getModel(), (String)"startdate");
                break;
            }
            case "repaymentway": {
                this.repaymentwayChgEvt();
                this.setSyncDrawMustInput();
                break;
            }
            case "interestrate": {
                this.initPayWayComb();
                this.setSettleIntModeByRepayWay();
                break;
            }
            case "startinterestrate": {
                this.setInterestRate();
                this.setInterestSettledPlan();
                if (BigDecimal.ZERO.compareTo((BigDecimal)this.getModel().getValue("startinterestrate")) != 0) break;
                LoanBillFormHelper.initIntCalBox((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "referencerate": 
            case "ratefloatpoint": 
            case "ratesign": {
                this.setContractInterestRate();
                break;
            }
            case "intcalmethod": {
                this.intcalMethodChgEvt();
                break;
            }
            case "issyncdraw": {
                this.syncdrawChangedEvent(false);
                this.setInterestSettledPlan();
                break;
            }
            case "settleintmode": {
                this.settlementChangeEvent();
                break;
            }
            case "currency": {
                this.contractCurrencyChg(e);
                break;
            }
            case "workcalendar": {
                LoanBillFormHelper.resetRateResetCycleDate((IDataModel)this.getModel(), (String)"startdate");
                break;
            }
            case "startintdate": {
                this.calSyncTerm();
                break;
            }
            case "syncterm": {
                this.calExprieDate();
                break;
            }
            case "expiredate": {
                this.calSyncTerm();
                break;
            }
            case "accountbank": {
                this.acctBankChgEvt();
                break;
            }
            case "loaneracctbank": {
                this.acctBankChgEvt();
                break;
            }
            case "rateadjustdate": {
                LoanBillFormHelper.rateAdjustDateChgEvt((IDataModel)this.getModel(), (String)"startdate");
                break;
            }
            case "isnofixedterm": {
                this.isNofixedTermChgEvt();
                this.setInterestSettledPlan();
                break;
            }
            case "rateresetdays": {
                this.setContractInterestRate();
                break;
            }
            case "issofrrate": {
                LoanBillFormHelper.isSofrRateChgEvt((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "iscallcompint": {
                LoanBillFormHelper.isCallCompIntEvt((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "rateresetadjustrule": {
                LoanBillFormHelper.rateResetAdjustRule((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "amount": {
                this.amountChgEvt();
                break;
            }
        }
    }

    private void isNofixedTermChgEvt() {
        IDataModel model = this.getModel();
        boolean isNofixedTerm = (Boolean)model.getValue("isnofixedterm");
        if (isNofixedTerm) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"term", (Object)"1y");
            Date startDate = (Date)model.getValue("startdate");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"enddate", (Object)DateUtils.getNextYear((Date)startDate, (int)1));
        }
    }

    private void contractCurrencyChg(PropertyChangedArgs e) {
        Boolean isSyncDraw;
        DynamicObject currency = (DynamicObject)e.getChangeSet()[0].getNewValue();
        DynamicObject oldCurrency = (DynamicObject)e.getChangeSet()[0].getOldValue();
        if (EmptyUtil.isEmpty((DynamicObject)currency) || EmptyUtil.isEmpty((DynamicObject)oldCurrency) || !currency.getPkValue().equals(oldCurrency.getPkValue())) {
            this.getModel().setValue("referencerate", null);
            String datasource = (String)this.getModel().getValue("datasource");
            if (!DataSourceEnum.IFM.getValue().equals(datasource)) {
                this.getModel().setValue("accountbank", null);
                this.getModel().setValue("loaneracctbank", null);
            }
        }
        if ((isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw")).booleanValue()) {
            IDataModel model = this.getModel();
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"syncdrawcurrency", (Object)model.getValue("currency"));
            int entryRowCount = this.getModel().getEntryRowCount("banksyndicate_entry");
            this.getView().updateView("banksyndicate_entry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue("e_creditlimit", null, i);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "draw": {
                this.beforeDoDraw(args);
                break;
            }
            case "extend": {
                this.beforeDoExtend(args);
                break;
            }
            case "save": 
            case "submit": {
                if (!CfmContractBillHelper.mayUseCreditLimit((IDataModel)this.getModel())) {
                    this.getModel().setValue("creditlimit", null);
                }
                this.setContractInterestRate();
                this.setInterestRate();
                this.checkExpireDate(args);
                break;
            }
            case "endcontract": 
            case "activatecontract": {
                formOperate.getOption().setVariableValue("CONTRACTBILL_FORMID", this.getView().getFormShowParameter().getFormId());
                break;
            }
            case "rateadjustop": {
                this.checkContract(args);
                break;
            }
            case "pushrepayment": {
                this.beforeRepay(args);
                break;
            }
            case "audit": {
                this.getModel().setValue("contractstatus", (Object)LoanContractStatusEnum.REGISTER.getValue());
                this.getModel().setValue("confirmstatus", (Object)ConfirmStatusEnum.REGISTRYING.getValue());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "draw": {
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) break;
                this.pushDraw();
                break;
            }
            case "pushrepayment": {
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) break;
                this.getPageCache().put("operationKey", operateKey);
                CfmContractBillHelper.contractRepay((Long)((Long)this.getModel().getValue("id")), (IFormView)this.getView());
                break;
            }
            case "extend": {
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) break;
                this.pushExtend();
                break;
            }
            case "submit": {
                break;
            }
            case "audit": {
                this.afterAuditOperation(args);
                break;
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        if ("cim_invest_contract".equals(this.getModel().getDataEntityType().getName())) {
            this.setDebtorOrgWhenImport(sourceData);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        this.validateImportData(e);
        if (!e.isCancel()) {
            if ("cfm_loancontractbill".equals(this.getModel().getDataEntityType().getName()) || "fl_leasecontractbill_init".equals(this.getModel().getDataEntityType().getName())) {
                String textCreditor = (String)this.getModel().getValue("textcreditor");
                String creditorType = (String)this.getModel().getValue("creditortype");
                DynamicObjectCollection tradeFinEntrs = this.getModel().getEntryEntity("tradefin_entry");
                if (EmptyUtil.isEmpty((String)textCreditor)) {
                    this.getModel().setValue("creditor", (Object)0L);
                } else {
                    this.setCreditDebtorId(e, creditorType, "creditor", "textcreditor", textCreditor);
                }
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)tradeFinEntrs)) {
                    this.setTradefinEntrsInfo(e, tradeFinEntrs);
                }
            }
            if ("cim_invest_contract".equals(this.getModel().getDataEntityType().getName())) {
                String textDebtor = (String)this.getModel().getValue("textdebtor");
                String debtorType = (String)this.getModel().getValue("debtortype");
                this.setCreditDebtorId(e, debtorType, "debtor", "textdebtor", textDebtor);
            }
            Object interestRate = this.getModel().getValue("interestrate");
            Object startIntereStrate = this.getModel().getValue("startinterestrate");
            if (EmptyUtil.isEmpty((Object)interestRate) && EmptyUtil.isNoEmpty((Object)startIntereStrate)) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"interestrate", (Object)startIntereStrate);
            }
            this.complementDrawInfo();
            this.getModel().setValue("interestrate", this.getModel().getValue("startinterestrate"));
            this.calSyncTerm();
        }
    }

    private void pushExtend() {
        Long contractId = (Long)this.getModel().getValue("id");
        ContractPushHelper.pushExtend((IFormView)this.getView(), (Long)contractId);
    }

    private void pushDraw() {
        Long contractId = (Long)this.getModel().getValue("id");
        CfmContractBillHelper.pushLoanBill((IFormView)this.getView(), (Long)contractId);
    }

    private boolean validateStatus(DynamicObject contract, AbstractBizResource biz2Resource) {
        if (!StringUtils.equals((CharSequence)BillStatusEnum.AUDIT.getValue(), (CharSequence)contract.getString("billstatus"))) {
            this.getView().showTipNotification(biz2Resource.getCbStatusError());
            return false;
        }
        String contractStatus = contract.getString("contractstatus");
        if (!StringUtils.equals((CharSequence)contractStatus, (CharSequence)LoanContractStatusEnum.REGISTERED.getValue()) && !StringUtils.equals((CharSequence)contractStatus, (CharSequence)LoanContractStatusEnum.EXECUTING.getValue())) {
            if (LoanTypeEnum.isBond((String)contract.getString("loantype"))) {
                this.getView().showTipNotification(biz2Resource.getCbBondContractStatusError());
            } else {
                this.getView().showTipNotification(biz2Resource.getCbContractStatusError());
            }
            return false;
        }
        String loanType = contract.getString("loantype");
        if ((BizTypeEnum.EC.getValue().equals(loanType) || BizTypeEnum.ENTRUST.getValue().equals(loanType)) && !CfmBillCommonHelper.pushOpConfirmStatusValid((DynamicObject)contract)) {
            this.getView().showTipNotification(biz2Resource.getConfirmStatusError());
            return false;
        }
        return true;
    }

    private boolean isBankLoan() {
        Set biztypes = FormParameterHelper.getBizTypes((IFormView)this.getView());
        return biztypes.contains(BizTypeEnum.LOAN.getValue()) || biztypes.contains(BizTypeEnum.SL.getValue());
    }

    private boolean isECLoan() {
        Set biztypes = FormParameterHelper.getBizTypes((IFormView)this.getView());
        return biztypes.contains(BizTypeEnum.EC.getValue()) || biztypes.contains(BizTypeEnum.ENTRUST.getValue());
    }

    private void initLoanTypeCombo() {
        List<Object> comboItemValues = new ArrayList(10);
        if (this.isBankLoan()) {
            comboItemValues = Arrays.asList(LoanTypeEnum.BANKLOAN.getValue(), LoanTypeEnum.BANKSLOAN.getValue());
        } else if (this.isECLoan()) {
            comboItemValues = Arrays.asList(LoanTypeEnum.LINKLEND.getValue(), LoanTypeEnum.ENTRUSTLOAN.getValue());
        }
        if (comboItemValues.size() > 0) {
            TmcViewInputHelper.resetComboItems(comboItemValues, (String)"loantype", (IFormView)this.getView());
        }
    }

    private void initCreditorTypeCombo() {
        String creditType = (String)this.getModel().getValue("creditortype");
        ArrayList<String> comboItemValues = new ArrayList<String>();
        if (this.isBankLoan()) {
            comboItemValues.addAll(Arrays.asList(CreditorTypeEnum.BANK.getValue(), CreditorTypeEnum.FINORG.getValue(), CreditorTypeEnum.SETTLECENTER.getValue()));
        }
        if (this.isECLoan()) {
            comboItemValues.addAll(Arrays.asList(CreditorTypeEnum.INNERUNIT.getValue(), CreditorTypeEnum.CUSTOM.getValue(), CreditorTypeEnum.OTHER.getValue()));
        }
        if (comboItemValues.size() > 0) {
            TmcViewInputHelper.resetComboItems(comboItemValues, (String)"creditortype", (IFormView)this.getView());
        }
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"creditortype", (Object)creditType);
    }

    private void clientOrgF7Evt(BeforeF7SelectEvent evt) {
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        sp.getListFilterParameter().getQFilters().add(new QFilter("finorgtype.type", "in", (Object)new String[]{FinOrgTypeEnum.BANK.getValue(), FinOrgTypeEnum.FINCOMP.getValue()}));
    }

    private void accountBankF7Evt(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("cim_invest_contract".equals(this.getModel().getDataEntityType().getName()) && key.equals("accountbank")) {
            return;
        }
        if ("cfm_loancontractbill".equals(this.getModel().getDataEntityType().getName()) && key.equals("loaneracctbank")) {
            return;
        }
        String mainOrg = this.getModel().getDataEntityType().getMainOrg();
        if ("ifm_loancontractbill".equals(this.getModel().getDataEntityType().getName())) {
            mainOrg = "org";
        }
        DynamicObject company = (DynamicObject)this.getModel().getValue(mainOrg);
        if (!this.isSetCreditorByAccount(key) && EmptyUtil.isEmpty((DynamicObject)company)) {
            evt.setCancel(true);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9%s\u3002", (String)"ContractBaseEdit_04", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)mainOrg)));
            return;
        }
        QFilter accQF = this.getBankAcctFilter(company);
        String creditorType = (String)this.getModel().getValue("creditortype");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) {
            accQF.and(new QFilter("acctclassify", "=", (Object)"I"));
            if (EmptyUtil.isEmpty((DynamicObject)currency)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u79cd\u3002", (String)"ContractBaseEdit_02", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            accQF.and(new QFilter("currency.fbasedataid", "=", currency.getPkValue()));
        } else {
            accQF.and(new QFilter("acctclassify", "!=", (Object)"I"));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            accQF.and(new QFilter("currency.fbasedataid.enable", "=", (Object)Character.valueOf('1')));
            if (!StringUtils.equals((CharSequence)"cfm_loancontract_bl_l", (CharSequence)this.getView().getFormShowParameter().getFormId())) {
                accQF.and(new QFilter("currency.fbasedataid.id", "=", currency.getPkValue()));
            }
        }
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        sp.getListFilterParameter().getQFilters().add(accQF);
    }

    private QFilter getBankAcctFilter(DynamicObject fundOrg) {
        QFilter acctFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)(fundOrg == null ? 0L : fundOrg.getLong("id")));
        QFilter statusFilter = new QFilter("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        return statusFilter.and(acctFilter);
    }

    private void initPayWayComb() {
        BigDecimal interestRate = (BigDecimal)this.getModel().getValue("interestrate");
        ComboEdit rePaymentWayComb = (ComboEdit)this.getControl("repaymentway");
        if (EmptyUtil.isEmpty((Object)rePaymentWayComb)) {
            return;
        }
        ArrayList<String> comboItemValues = new ArrayList<String>(10);
        comboItemValues.add(RepaymentWayEnum.bqhblsbq.getValue());
        comboItemValues.add(RepaymentWayEnum.dqhblsbq.getValue());
        comboItemValues.add(RepaymentWayEnum.bqhbdqhx.getValue());
        comboItemValues.add(RepaymentWayEnum.dqhbdqhx.getValue());
        comboItemValues.add(RepaymentWayEnum.zdyhk.getValue());
        String interestType = (String)this.getModel().getValue("interesttype");
        if (!LoanBillFormHelper.isSofr((IDataModel)this.getModel()) && (EmptyUtil.isEmpty((String)interestType) || InterestTypeEnum.isFloat((String)interestType) || EmptyUtil.isNoEmpty((BigDecimal)interestRate))) {
            comboItemValues.add(RepaymentWayEnum.debx.getValue());
            comboItemValues.add(RepaymentWayEnum.debj.getValue());
            comboItemValues.add(RepaymentWayEnum.dbdx.getValue());
        }
        TmcViewInputHelper.resetComboItems(comboItemValues, (String)"repaymentway", (IFormView)this.getView());
        String repayWay = (String)this.getModel().getValue("repaymentway");
        if (!comboItemValues.contains(repayWay)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"repaymentway", null);
        }
        this.getModel().setDataChanged(false);
    }

    private void orgChgEvt() {
        this.getModel().setValue("accountbank", null);
    }

    private void finproductChgEvt(PropertyChangedArgs e) {
        DynamicObject finproduct;
        DynamicObject newProduct = (DynamicObject)e.getChangeSet()[0].getNewValue();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("confirm")) {
            return;
        }
        DynamicObject productFactoty = (DynamicObject)this.getModel().getValue("productfactory");
        if (EmptyUtil.isNoEmpty((DynamicObject)productFactoty) && EmptyUtil.isNoEmpty((DynamicObject)(finproduct = productFactoty.getDynamicObject("finproduct"))) && (EmptyUtil.isEmpty((DynamicObject)newProduct) || !finproduct.getPkValue().equals(newProduct))) {
            this.getModel().setValue("productfactory", null);
        }
    }

    private void finproductF7Evt(BeforeF7SelectEvent evt) {
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        QFilter specQF = this.getFinProductF7QF(evt);
        if (evt.isCancel()) {
            return;
        }
        if (specQF != null) {
            sp.getListFilterParameter().setFilter(specQF);
        }
    }

    private QFilter getFinProductF7QF(BeforeF7SelectEvent evt) {
        DynamicObject finproduct;
        DynamicObject pf;
        Map customParams;
        QFilter qFilter = null;
        Object loanType = this.getModel().getValue("loantype");
        if (EmptyUtil.isEmpty((Object)loanType)) {
            evt.setCancel(true);
            IDataEntityProperty loanTypeProp = this.getModel().getProperty("loantype");
            LocaleString loanTypePropDislayName = loanTypeProp.getDisplayName();
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9%s\u3002", (String)"ContractBaseEdit_04", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), loanTypePropDislayName.toString()));
            return null;
        }
        String entityName = this.getModel().getDataEntityType().getName();
        if ("ifm_loancontractbill".equals(entityName)) {
            return qFilter;
        }
        qFilter = BizTypeEnum.BOND.getValue().equals(loanType) ? new QFilter("finsource", "=", (Object)"bond") : new QFilter("finsource", "!=", (Object)"bond");
        if (!entityName.equals("fl_leasecontractbill") && !entityName.equals("fl_leasecontractbill_init")) {
            qFilter.and("isfinancelease", "=", (Object)"0");
        }
        if ((customParams = this.getView().getFormShowParameter().getCustomParams()).containsKey("confirm") && (pf = (DynamicObject)this.getModel().getValue("productfactory")) != null && (finproduct = pf.getDynamicObject("finproduct")) != null) {
            qFilter.and(new QFilter("id", "=", (Object)finproduct.getLong("id")));
        }
        return qFilter;
    }

    private void productFactoryF7Evt(BeforeF7SelectEvent evt) {
        String applyNo;
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        String entityTypeName = this.getModel().getDataEntityType().getName();
        String loantype = (String)this.getModel().getValue("loantype");
        if (EmptyUtil.isEmpty((String)loantype)) {
            evt.setCancel(true);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9%s\u3002", (String)"ContractBaseEdit_04", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)"loantype")));
            return;
        }
        DynamicObject finproduct = (DynamicObject)this.getModel().getValue("finproduct");
        QFilter qf = new QFilter("biztype", "=", (Object)loantype);
        if (!"cim_invest_contract".equals(entityTypeName) && EmptyUtil.isNoEmpty((DynamicObject)finproduct)) {
            QFilter fpQFilter = new QFilter("finproduct", "=", finproduct.getPkValue());
            fpQFilter.or(new QFilter("finproduct", "=", (Object)0));
            qf.and(fpQFilter);
        }
        if (EmptyUtil.isNotEmpty((CharSequence)(applyNo = (String)this.getModel().getValue("lenderapplyno")))) {
            String rateType = (String)this.getModel().getValue("interesttype");
            String repayWay = (String)this.getModel().getValue("repaymentway");
            QFilter rateQF = new QFilter("ratetype", "=", (Object)rateType);
            if (EmptyUtil.isNotEmpty((CharSequence)repayWay)) {
                rateQF.and(new QFilter("repaymentmode", "=", (Object)repayWay).or("repaymentmode", "=", (Object)" ").or("repaymentmode", "=", (Object)""));
            }
            qf.and(rateQF);
        }
        if (BizTypeEnum.BOND.getValue().equals(loantype)) {
            String bondtype = (String)this.getModel().getValue("bondtype");
            if ("fixedratebond".equals(bondtype)) {
                qf.and(new QFilter("ratetype", "in", (Object)new String[]{InterestTypeEnum.FIXED.getValue(), InterestTypeEnum.AGREE.getValue()}));
            }
            if ("floatratebond".equals(bondtype)) {
                qf.and(new QFilter("ratetype", "=", (Object)InterestTypeEnum.FLOAT.getValue()));
            }
        }
        logger.info("\u878d\u8d44\u6a21\u578b\u7684\u8fc7\u6ee4\u6761\u4ef6qf={}", (Object)qf.toString());
        sp.getListFilterParameter().setFilter(qf);
    }

    private void bondtypeChgEvt(PropertyChangedArgs e) {
        this.getModel().setValue("productfactory", null);
        Boolean isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw");
        if (!isSyncDraw.booleanValue()) {
            return;
        }
        String bondType = (String)e.getChangeSet()[0].getNewValue();
        if (BondTypeEnum.FLOATRATEBOND.getValue().equals(bondType)) {
            this.getModel().setValue("interesttype", (Object)InterestTypeEnum.FLOAT.getValue());
        } else {
            this.getModel().setValue("interesttype", (Object)InterestTypeEnum.FIXED.getValue());
        }
    }

    private void loanTypeChgEvt() {
        this.getModel().setValue("finproduct", null);
        this.getModel().setValue("productfactory", null);
        String loanType = (String)this.getModel().getValue("loantype");
        if (BizTypeEnum.ENTRUST.getValue().equals(loanType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"clientorg"});
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"clientorg"});
        }
    }

    private void productFactoryChgEvt() {
        IDataModel model = this.getModel();
        DynamicObject pf = (DynamicObject)model.getValue("productfactory");
        if (pf == null) {
            this.productFactoryCleared();
            this.productFactorySofrChgEvt();
            return;
        }
        DynamicObject finProduct = (pf = TmcDataServiceHelper.loadSingle((Object)pf.getPkValue(), (String)pf.getDynamicObjectType().getName())).getDynamicObject("finproduct");
        if (EmptyUtil.isNoEmpty((DynamicObject)finProduct)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"finproduct", (Object)finProduct);
        }
        model.setValue("drawway", pf.get("drawway"));
        model.setValue("iscandefer", pf.get("iscandefer"));
        Boolean iscalInt = (Boolean)pf.get("iscallint");
        model.setValue("iscallint", pf.get("iscallint"));
        model.setValue("iscycleloan", pf.get("iscycleloan"));
        String bizType = (String)model.getValue("loantype");
        if (!BizTypeEnum.isBond((String)bizType)) {
            String applyNo = (String)model.getValue("lenderapplyno");
            if (iscalInt.booleanValue()) {
                if (EmptyUtil.isEmpty((String)applyNo)) {
                    model.setValue("interesttype", pf.get("ratetype"));
                    model.setValue("repaymentway", pf.get("repaymentmode"));
                }
                String rateAdjustMethod = pf.getString("rateadjustmethod");
                model.setValue("rateadjuststyle", (Object)rateAdjustMethod);
                if (RateAdjustStyleEnum.isCycle((String)rateAdjustMethod) || RateAdjustStyleEnum.isAfterint((String)rateAdjustMethod)) {
                    model.setValue("rateresetdays", (Object)pf.getInt("rateresetdays"));
                }
                model.setValue("rateadjustcycletype", (Object)pf.getString("rateresetcycle"));
                model.setValue("rateadjustcycle", (Object)pf.getString("rateresetcycleday"));
            } else {
                if (EmptyUtil.isEmpty((String)applyNo)) {
                    model.setValue("interesttype", null);
                    model.setValue("repaymentway", pf.get("repaymentmode"));
                }
                model.setValue("rateadjuststyle", null);
                model.setValue("basis", null);
            }
        }
        if (iscalInt.booleanValue()) {
            model.setValue("basis", pf.get("basis"));
            model.setValue("intcalmethod", pf.get("intcalmethod"));
            model.setValue("settleintmode", pf.get("settleintmode"));
        }
        this.getModel().setValue("issofrrate", pf.get("issofrrate"));
        this.getModel().setValue("iscallcompint", pf.get("iscallcompint"));
        model.setValue("payintadjustrule", (Object)pf.getString("payintadjustrule"));
        model.setValue("rateresetadjustrule", (Object)pf.getString("rateresetadjustrule"));
        this.setDefCCYAfterProdFactoryChanged();
        this.productFactorySofrChgEvt();
    }

    private void setDefCCYAfterProdFactoryChanged() {
        DynamicObject pf = (DynamicObject)this.getModel().getValue("productfactory");
        String applyNo = (String)this.getModel().getValue("lenderapplyno");
        if (EmptyUtil.isNoEmpty((String)applyNo)) {
            return;
        }
        if (pf != null) {
            DynamicObjectCollection multCurrency;
            String currencyRule = pf.getString("currencyrule");
            if (ProductFactoryCcyRuleEnum.isNoCurrency((String)currencyRule) || ProductFactoryCcyRuleEnum.isBaseCurrency((String)currencyRule)) {
                String mainOrgProp = this.getModel().getDataEntityType().getMainOrg();
                DynamicObject company = (DynamicObject)this.getModel().getValue(mainOrgProp);
                DynamicObject currency = TmcBusinessBaseHelper.getCasBaseCurrency((long)((Long)company.getPkValue()));
                this.getModel().setValue("currency", (Object)currency);
            } else if (ProductFactoryCcyRuleEnum.isAssignCurrency((String)currencyRule) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(multCurrency = pf.getDynamicObjectCollection("currency")))) {
                this.getModel().setValue("currency", ((DynamicObject)multCurrency.get(0)).getDynamicObject("fbasedataid").getPkValue());
            }
        }
    }

    private void productFactoryCleared() {
        this.getModel().setValue("iscallint", (Object)Boolean.TRUE);
        this.getModel().setValue("iscandefer", (Object)Boolean.TRUE);
        this.getModel().setValue("issofrrate", (Object)Boolean.FALSE);
        this.getModel().setValue("iscallcompint", (Object)Boolean.FALSE);
        this.setDefCCYAfterProdFactoryChanged();
    }

    private void rateadjuststyleChgEvt() {
        String loanType = (String)this.getModel().getValue("loantype");
        if (BizTypeEnum.BOND.getValue().equals(loanType)) {
            return;
        }
        this.registerMustInputByAdustStyle();
    }

    private void termChgEvt() {
        String term = (String)this.getModel().getValue("term");
        if (!TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)term)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", null);
        } else {
            Date startDate = (Date)this.getModel().getValue("startdate");
            if (term != null && startDate != null) {
                DynamicObject productFactory = (DynamicObject)this.getModel().getValue("productfactory");
                Date endDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)startDate);
                String loanExpireRule = AdjustMethodEnum.no_adjust.getValue();
                if (EmptyUtil.isNoEmpty((DynamicObject)productFactory)) {
                    loanExpireRule = productFactory.getString("loanexpireadjustrule");
                }
                endDate = TermHelper.callAdjustSettleDate((DynamicObjectCollection)((DynamicObjectCollection)this.getModel().getValue("workcalendar")), (Date)endDate, (AdjustMethodEnum)AdjustMethodEnum.valueOf((String)loanExpireRule));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", (Object)endDate);
                Boolean isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw");
                if (isSyncDraw.booleanValue()) {
                    if (this.getView().getControl("syncterm") != null && EmptyUtil.isEmpty((Object)this.getModel().getValue("syncterm"))) {
                        this.getModel().setValue("syncterm", (Object)term);
                    }
                    Date expiredate = (Date)this.getModel().getValue("expiredate");
                    if (EmptyUtil.isNoEmpty((Object)endDate) && EmptyUtil.isEmpty((Object)expiredate)) {
                        this.getModel().setValue("expiredate", (Object)endDate);
                    }
                }
            }
        }
    }

    private void endDateChgEvt() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (startDate != null && endDate != null) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)DateUtils.getDiff_ymd((Date)startDate, (Date)endDate));
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", null);
        }
        Boolean isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw");
        Date expiredate = (Date)this.getModel().getValue("expiredate");
        if (isSyncDraw.booleanValue() && EmptyUtil.isNoEmpty((Object)endDate) && EmptyUtil.isEmpty((Object)expiredate)) {
            this.getModel().setValue("expiredate", (Object)endDate);
        }
    }

    private void startDateChgEvt() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        Boolean isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw");
        IDataModel model = this.getModel();
        if (isSyncDraw.booleanValue() && EmptyUtil.isNoEmpty((Object)startDate)) {
            Date startintdate;
            Date syncdrawdate = (Date)this.getModel().getValue("syncdrawdate");
            if (EmptyUtil.isEmpty((Object)syncdrawdate)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"syncdrawdate", (Object)startDate);
            }
            if (EmptyUtil.isEmpty((Object)(startintdate = (Date)this.getModel().getValue("startintdate")))) {
                this.getModel().setValue("startintdate", (Object)startDate);
            }
        }
    }

    private void repaymentwayChgEvt() {
        Boolean isSyncDraw;
        String loanType = (String)this.getModel().getValue("loantype");
        if (BizTypeEnum.BOND.getValue().equals(loanType) && !(isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw")).booleanValue()) {
            return;
        }
        this.getModel().setValue("interestsettledplan", null);
        this.getModel().setValue("stageplan", null);
        this.registerMustInputByRepaymentway();
        this.setSettleIntModeByRepayWay();
    }

    private void setSettleIntModeByRepayWay() {
        String repayWay = (String)this.getModel().getValue("repaymentway");
        HashSet<String> repayWayLSBQ = new HashSet<String>(5);
        repayWayLSBQ.add(RepaymentWayEnum.bqhblsbq.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.dqhblsbq.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.debx.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.debj.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.dbdx.getValue());
        HashSet<String> repayWayFIX = new HashSet<String>(2);
        repayWayFIX.add(RepaymentWayEnum.dqhbdqhx.getValue());
        repayWayFIX.add(RepaymentWayEnum.bqhbdqhx.getValue());
        if (repayWayLSBQ.contains(repayWay)) {
            this.getModel().setValue("settleintmode", (Object)SettleIntModeEnum.lsbq.getValue());
        } else if (repayWayFIX.contains(repayWay)) {
            this.getModel().setValue("settleintmode", (Object)SettleIntModeEnum.gdpljx.getValue());
        }
    }

    private void registerMustInputByRepaymentway() {
        String repayWay = (String)this.getModel().getValue("repaymentway");
        HashSet<String> repayWaysShowStageplan = new HashSet<String>(5);
        repayWaysShowStageplan.add(RepaymentWayEnum.debx.getValue());
        repayWaysShowStageplan.add(RepaymentWayEnum.debj.getValue());
        repayWaysShowStageplan.add(RepaymentWayEnum.dbdx.getValue());
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)repayWaysShowStageplan.contains(repayWay), (String[])new String[]{"stageplan"});
        String settleMode = (String)this.getModel().getValue("settleintmode");
        boolean isGdpljx = SettleIntModeEnum.gdpljx.getValue().equals(settleMode);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isGdpljx, (String[])new String[]{"interestsettledplan"});
    }

    private void interestTypeChgEvt() {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"issofrrate", (Object)Boolean.FALSE);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"iscallcompint", (Object)Boolean.FALSE);
        String loanType = (String)this.getModel().getValue("loantype");
        if (BizTypeEnum.BOND.getValue().equals(loanType)) {
            return;
        }
        DynamicObject pfDO = (DynamicObject)this.getModel().getValue("productfactory");
        if (!EmptyUtil.isEmpty((DynamicObject)pfDO)) {
            this.resetIntRateRelatedValue();
        }
        this.registerMustInputByInterestType();
        this.initPayWayComb();
    }

    private void registerMustInputByInterestType() {
        String intRateType = (String)this.getModel().getValue("interesttype");
        if (InterestTypeEnum.FIXED.getValue().equals(intRateType) || InterestTypeEnum.AGREE.getValue().equals(intRateType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"startinterestrate"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"referencerate", "ratesign", "ratefloatpoint", "rateadjuststyle"});
        } else if (InterestTypeEnum.FLOAT.getValue().equals(intRateType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"referencerate", "ratesign", "ratefloatpoint", "rateadjuststyle"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"startinterestrate"});
        }
        this.registerMustInputByAdustStyle();
    }

    private void registerMustInputByAdustStyle() {
        String intRateType = (String)this.getModel().getValue("interesttype");
        String adjustStyle = (String)this.getModel().getValue("rateadjuststyle");
        boolean isRateCycle = RateAdjustStyleEnum.isCycle((String)adjustStyle) && InterestTypeEnum.FLOAT.getValue().equals(intRateType);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isRateCycle, (String[])new String[]{"rateadjustcycletype", "rateadjustcycle"});
    }

    private void resetIntRateRelatedValue() {
        this.getModel().setValue("startinterestrate", null);
        this.getModel().setValue("referencerate", null);
        this.getModel().setValue("ratefloatpoint", null);
        this.getModel().setValue("rateadjustcycle", null);
        this.getModel().setValue("interestsettledplan", null);
        this.getModel().setValue("floatingratio", null);
        this.getModel().setValue("basis", null);
    }

    private void beforeDoDraw(BeforeDoOperationEventArgs evtArgs) {
        AbstractBizResource biz2Resource;
        Object contractId = this.getModel().getDataEntity().getPkValue();
        DynamicObject contract = TmcDataServiceHelper.loadSingle((Object)contractId, (String)"cfm_loancontractbill", (String)String.join((CharSequence)",", "billno", "isnofixedterm", "loantype", "datasource", "billstatus", "contractstatus", "confirmstatus", "notdrawamount", "drawdownplan_entry"));
        if (!this.validateStatus(contract, biz2Resource = new BizResourceFactory().getBizResource(contract.getString("datasource")))) {
            evtArgs.setCancel(true);
            return;
        }
        BigDecimal noDrawAmount = contract.getBigDecimal("notdrawamount");
        if (noDrawAmount.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showTipNotification(biz2Resource.getCbNotDrawamount());
            evtArgs.setCancel(true);
        }
        LoanBillFormHelper.validateIsDrawByPlan((DynamicObject)contract, (BeforeDoOperationEventArgs)evtArgs, (IFormView)this.getView());
    }

    private void beforeDoExtend(BeforeDoOperationEventArgs evtArgs) {
        AbstractBizResource biz2Resource;
        Object contractId = this.getModel().getDataEntity().getPkValue();
        DynamicObject contract = TmcDataServiceHelper.loadSingle((Object)contractId, (String)"cfm_loancontractbill", (String)String.join((CharSequence)",", "billno", "isnofixedterm", "loantype", "datasource", "billstatus", "contractstatus", "productfactory", "confirmstatus", "notdrawamount"));
        if (!this.validateStatus(contract, biz2Resource = new BizResourceFactory().getBizResource(contract.getString("datasource")))) {
            evtArgs.setCancel(true);
            return;
        }
        Pair result = ExtendHelper.isExtendAllowed((DynamicObject)contract);
        if (!((Boolean)result.getLeft()).booleanValue()) {
            this.getView().showTipNotification((String)result.getRight());
            evtArgs.setCancel(true);
        }
    }

    private void setCreditDebtorId(ImportDataEventArgs e, String type, String idProp, String textProp, String textVal) {
        QFilter baseDataQF = new QFilter("name", "=", (Object)textVal);
        Long idPropVal = 0L;
        DynamicObject baseDataDO = null;
        if (CreditorTypeEnum.BANK.getValue().equals(type) || CreditorTypeEnum.FINORG.getValue().equals(type) || CreditorTypeEnum.SETTLECENTER.getValue().equals(type)) {
            baseDataDO = TmcDataServiceHelper.loadSingleFromCache((String)"bd_finorginfo", (QFilter[])baseDataQF.toArray());
        } else if (CreditorTypeEnum.INNERUNIT.getValue().equals(type)) {
            baseDataDO = TmcDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])baseDataQF.toArray());
        } else if (CreditorTypeEnum.CUSTOM.getValue().equals(type)) {
            baseDataDO = TmcDataServiceHelper.loadSingleFromCache((String)"bd_bizpartner", (QFilter[])baseDataQF.toArray());
        }
        if (baseDataDO == null && !CreditorTypeEnum.OTHER.getValue().equals(type)) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5339\u914d%1$s %2$s \u7684\u57fa\u7840\u8d44\u6599\u6570\u636e\u3002", (String)"ContractBaseEdit_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)textProp), textVal));
            return;
        }
        if (baseDataDO != null) {
            idPropVal = baseDataDO.getLong("id");
        }
        this.getModel().setValue(idProp, (Object)idPropVal);
    }

    private void setTradefinEntrsInfo(ImportDataEventArgs e, DynamicObjectCollection tradefinEntrs) {
        StringBuilder errorMesssage;
        Map<String, DynamicObject> ilBillMap = new HashMap<String, DynamicObject>(4);
        Map<String, DynamicObject> elBillMap = new HashMap<String, DynamicObject>(4);
        Set<String> ilBillNo = tradefinEntrs.stream().filter(o -> RelationTypeEnum.IL.getValue().equals(o.getString("e_tf_relationtype"))).map(o -> o.getString("e_tf_relatebillno")).collect(Collectors.toSet());
        Set<String> elBillNo = tradefinEntrs.stream().filter(o -> RelationTypeEnum.EL.getValue().equals(o.getString("e_tf_relationtype"))).map(o -> o.getString("e_tf_relatebillno")).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(ilBillNo)) {
            ilBillMap = this.findBills(ilBillNo, "lc_arrival", ilBillMap);
        }
        if (EmptyUtil.isNoEmpty(elBillNo)) {
            elBillMap = this.findBills(elBillNo, "lc_present", elBillMap);
        }
        if ((errorMesssage = this.setRelationBillNoInfos(tradefinEntrs, ilBillMap, elBillMap)) != null && errorMesssage.length() > 0) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), errorMesssage.toString());
            return;
        }
    }

    private Map<String, DynamicObject> findBills(Set<String> billNo, String billType, Map<String, DynamicObject> map) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        QFilter qFilter = new QFilter("billno", "in", (Object)billNo.toArray(new String[0]));
        if ("lc_arrival".equals(billType)) {
            qFilter.and(CfmContractBillHelper.getLcArrivalQfilter((DynamicObject)org));
        } else if ("lc_present".equals(billType)) {
            qFilter.and(CfmContractBillHelper.getLcPresentQfilter((DynamicObject)org));
        }
        Object[] bills = TmcDataServiceHelper.load((String)billType, (String)"id,billno,org,benefiterother,endpaydate,todoamount,arrivalcurrency", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isNoEmpty((Object[])bills)) {
            map = Arrays.stream(bills).collect(Collectors.toMap(o -> o.getString("billno"), o -> o, (k1, k2) -> k1));
        }
        return map;
    }

    private StringBuilder setRelationBillNoInfos(DynamicObjectCollection tradefinEntrs, Map<String, DynamicObject> ilBillMap, Map<String, DynamicObject> elBillMap) {
        StringBuilder errorMessage = new StringBuilder();
        for (DynamicObject tradefinEntr : tradefinEntrs) {
            DynamicObject bill;
            String etfRelationType = tradefinEntr.getString("e_tf_relationtype");
            if (!RelationTypeEnum.IL.getValue().equals(etfRelationType) && !RelationTypeEnum.EL.getValue().equals(etfRelationType)) continue;
            String etfRelateBillNo = tradefinEntr.getString("e_tf_relatebillno");
            DynamicObject dynamicObject = bill = RelationTypeEnum.IL.getValue().equals(etfRelationType) ? ilBillMap.get(etfRelateBillNo) : elBillMap.get(etfRelateBillNo);
            if (EmptyUtil.isNoEmpty((DynamicObject)bill)) {
                String letter = RelationTypeEnum.IL.getValue().equals(etfRelationType) ? bill.getDynamicObject("org").getString("name") : bill.getString("benefiterother");
                String beneficiaryer = RelationTypeEnum.EL.getValue().equals(etfRelationType) ? bill.getDynamicObject("org").getString("name") : bill.getString("benefiterother");
                tradefinEntr.set("e_tf_letter", (Object)letter);
                tradefinEntr.set("e_tf_beneficiary", (Object)beneficiaryer);
                tradefinEntr.set("e_tf_expiredate", (Object)bill.getDate("endpaydate"));
                tradefinEntr.set("e_tf_unpaidamount", (Object)bill.getBigDecimal("todoamount"));
                tradefinEntr.set("e_tf_description", null);
                tradefinEntr.set("e_tf_currency", (Object)bill.getDynamicObject("arrivalcurrency"));
                tradefinEntr.set("e_tf_relatebillid", bill.getPkValue());
                continue;
            }
            if (errorMessage != null && errorMessage.length() > 0) {
                errorMessage.append("\n");
            }
            errorMessage.append(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u878d\u8d38\u5206\u5f55\u7684\u5173\u8054\u5355\u636e\u53f7%1$s\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5355\u636e\u6216\u8005\u4e0d\u6ee1\u8db3\u6761\u4ef6\u3002", (String)"ContractBaseEdit_22", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), etfRelateBillNo));
        }
        return errorMessage;
    }

    private void productFactorySofrChgEvt() {
        if (LoanBillFormHelper.isSofr((IDataModel)this.getModel())) {
            this.getModel().setValue("ratesign", (Object)kd.tmc.fbp.common.enums.RateSignEnum.ADD.getValue());
        }
        this.getView().setEnable(Boolean.valueOf(!LoanBillFormHelper.isSofr((IDataModel)this.getModel())), new String[]{"ratesign"});
        this.initPayWayComb();
    }

    private void setContractInterestRate() {
        String interestType = (String)this.getModel().getValue("interesttype");
        if (!InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
            return;
        }
        this.getModel().setValue("startinterestrate", (Object)this.getRate());
    }

    private BigDecimal getRate() {
        DynamicObject referenceRate = (DynamicObject)this.getModel().getValue("referencerate");
        Date startDate = (Date)this.getModel().getValue("startdate");
        BigDecimal rateFloatPoint = (BigDecimal)this.getModel().getValue("ratefloatpoint");
        String rateSign = (String)this.getModel().getValue("ratesign");
        if (EmptyUtil.isNoEmpty((DynamicObject)referenceRate) && EmptyUtil.isNoEmpty((Object)startDate)) {
            BigDecimal rate;
            if (!EmptyUtil.isEmpty((Object)this.getModel().getValue("rateresetdays"))) {
                Integer rateResetDays = (Integer)this.getModel().getValue("rateresetdays");
                startDate = DateUtils.getLastDay((Date)startDate, (int)rateResetDays);
            }
            if (EmptyUtil.isEmpty((BigDecimal)(rate = MarketDataServiceHelper.referRate((String)referenceRate.getString("number"), (Date)startDate, (boolean)false)))) {
                return BigDecimal.ZERO;
            }
            BigDecimal rateFloat = new BigDecimal(BigInteger.ZERO);
            if (EmptyUtil.isNoEmpty((BigDecimal)rateFloatPoint) && EmptyUtil.isNoEmpty((String)rateSign)) {
                rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
                if (kd.tmc.fbp.common.enums.RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
                    rateFloat = rateFloat.negate();
                }
            }
            return rate.add(rateFloat);
        }
        return BigDecimal.ZERO;
    }

    private void setInterestRate() {
        this.getModel().setValue("interestrate", this.getModel().getValue("startinterestrate"));
    }

    private void checkExpireDate(BeforeDoOperationEventArgs args) {
        String dataSource = (String)this.getModel().getValue("datasource");
        Date bizDate = (Date)this.getModel().getValue("syncdrawdate");
        if (DataSourceEnum.isBond((String)dataSource)) {
            bizDate = (Date)this.getModel().getValue("syncbizdate");
        }
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        boolean isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw");
        if (isSyncDraw && bizDate != null && expireDate != null && expireDate.compareTo(bizDate) <= 0) {
            if (DataSourceEnum.isBond((String)dataSource)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5230\u671f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u53d1\u884c\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"LoanBillEdit_20", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5230\u671f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u653e\u6b3e\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"LoanBillEdit_21", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
            args.setCancel(true);
        }
    }

    private void setLatestRate() {
        BigDecimal rate;
        IDataModel model = this.getModel();
        if (!InterestTypeEnum.FLOAT.getValue().equals(model.getValue("interesttype"))) {
            BigDecimal effectiveRate = this.getExtendAndRateAdjustRate();
            if (EmptyUtil.isNoEmpty((BigDecimal)effectiveRate)) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"latestrate", (Object)effectiveRate);
            } else {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"latestrate", (Object)model.getValue("interestrate"));
            }
            return;
        }
        DynamicObject referenceRate = (DynamicObject)model.getValue("referencerate");
        if (EmptyUtil.isEmpty((DynamicObject)referenceRate)) {
            return;
        }
        Date date = DateUtils.getCurrentDate();
        if (ContractStatusEnum.DONE.getValue().equals(model.getValue("contractstatus"))) {
            date = (Date)this.getModel().getValue("closeoffdate");
        }
        try {
            rate = MarketDataServiceHelper.referRate((String)referenceRate.getString("number"), (Date)date, (boolean)false);
            logger.info("\u83b7\u53d6\u7684\u6d6e\u52a8\u5229\u7387\uff1a{}", (Object)rate);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"latestrate", (Object)model.getValue("startinterestrate"));
            return;
        }
        if (EmptyUtil.isEmpty((BigDecimal)rate)) {
            return;
        }
        BigDecimal rateFloatPoint = (BigDecimal)model.getValue("ratefloatpoint");
        String rateSign = (String)model.getValue("ratesign");
        BigDecimal rateFloat = new BigDecimal(BigInteger.ZERO);
        if (EmptyUtil.isNoEmpty((BigDecimal)rateFloatPoint) && EmptyUtil.isNoEmpty((String)rateSign)) {
            rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 20, RoundingMode.HALF_UP);
            if (RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
                rateFloat = rateFloat.negate();
            }
        }
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"latestrate", (Object)rate.add(rateFloat));
    }

    private BigDecimal getExtendAndRateAdjustRate() {
        Long id = (Long)this.getModel().getValue("id");
        QFilter extentBillFilter = new QFilter("sourcebillid", "=", (Object)id).and("prevrenewalexpiredate", "<=", (Object)DateUtils.getCurrentDate()).and("isadjustinterestrate", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection extendBillDatas = QueryServiceHelper.query((String)"cfm_contractextendbill", (String)"id,sourcebillid,prevrenewalexpiredate,renewalinterestrate", (QFilter[])extentBillFilter.toArray());
        Map extendBillMap = extendBillDatas.stream().collect(Collectors.toMap(o -> o.getLong("sourcebillid"), Function.identity(), (a, b) -> a.getDate("prevrenewalexpiredate").compareTo(b.getDate("prevrenewalexpiredate")) >= 0 ? a : b));
        QFilter rateAdjustFilter = new QFilter("loancontractbill", "=", (Object)id).and("adjusteffectdate", "<=", (Object)DateUtils.getCurrentDate()).and("adjustele", "=", (Object)AdjustEleEnum.ADJUSTCONTRACT.getValue());
        DynamicObjectCollection rateAdjustDatas = QueryServiceHelper.query((String)"cfm_rateadjustbill", (String)"id,loancontractbill,adjusteffectdate,afterinterestrate", (QFilter[])rateAdjustFilter.toArray());
        Map rateAdjustMap = rateAdjustDatas.stream().collect(Collectors.toMap(o -> o.getLong("loancontractbill"), Function.identity(), (a, b) -> a.getDate("adjusteffectdate").compareTo(b.getDate("adjusteffectdate")) >= 0 ? a : b));
        boolean hasRenewalinterestrate = EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)extendBillMap.get(id))) && EmptyUtil.isNoEmpty((BigDecimal)((DynamicObject)extendBillMap.get(id)).getBigDecimal("renewalinterestrate"));
        boolean hasAfterinterestrate = EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)rateAdjustMap.get(id))) && EmptyUtil.isNoEmpty((BigDecimal)((DynamicObject)rateAdjustMap.get(id)).getBigDecimal("afterinterestrate"));
        Date effectiveDate = null;
        BigDecimal effectiveRate = null;
        if (hasRenewalinterestrate) {
            effectiveDate = ((DynamicObject)extendBillMap.get(id)).getDate("prevrenewalexpiredate");
            effectiveRate = ((DynamicObject)extendBillMap.get(id)).getBigDecimal("renewalinterestrate");
        }
        if (hasAfterinterestrate && (effectiveDate != null && effectiveDate.before(((DynamicObject)rateAdjustMap.get(id)).getDate("adjusteffectdate")) || effectiveDate == null)) {
            effectiveDate = ((DynamicObject)rateAdjustMap.get(id)).getDate("adjusteffectdate");
            effectiveRate = ((DynamicObject)rateAdjustMap.get(id)).getBigDecimal("afterinterestrate");
        }
        return effectiveRate;
    }

    private void intcalMethodChgEvt() {
        String intcalMethod = (String)this.getModel().getValue("intcalmethod");
        String billStatus = (String)this.getModel().getValue("billstatus");
        ComboEdit basis = (ComboEdit)this.getControl("basis");
        if (basis == null) {
            return;
        }
        List comboItems = IntcalMethodChgHelper.getBasisComboItem((String)intcalMethod, (String)billStatus);
        basis.setComboItems(comboItems);
        if (EmptyUtil.isNoEmpty((Object)comboItems)) {
            this.getModel().setValue("basis", (Object)((ComboItem)comboItems.get(0)).getValue());
        }
    }

    private void syncdrawChangedEvent(boolean isBindData) {
        String formId;
        Boolean isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw");
        switch (formId = this.getView().getFormShowParameter().getFormId()) {
            case "cfm_loancontract_bl_l": 
            case "cfm_loancontract_ic_l": 
            case "cim_invest_contract": 
            case "ifm_loancontractbill": 
            case "fl_leasecontractbill": 
            case "fl_leasecontractbill_init": {
                this.fillOrClearSyncDrawInfo(isSyncDraw, isBindData);
            }
        }
    }

    private void fillOrClearSyncDrawInfo(boolean isSyncDraw, boolean isBindData) {
        IDataModel model = this.getModel();
        if (isSyncDraw) {
            OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
            if (operationStatus == OperationStatus.ADDNEW || operationStatus == OperationStatus.EDIT && (!isBindData || isBindData && "fl_leasecontractbill".equals(this.getModel().getDataEntityType().getName()) && EmptyUtil.isNoEmpty((String)"lenderapplyno"))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"syncdrawcurrency", (Object)model.getValue("currency"));
                BigDecimal amount = (BigDecimal)model.getValue("amount");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"syncdrawamount", (Object)amount);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"syncdrawdate", (Object)model.getValue("startdate"));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"startintdate", (Object)model.getValue("startdate"));
                this.getModel().setValue("expiredate", model.getValue("enddate"));
                this.setSlbankEntryLoanamt(isSyncDraw);
            }
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"syncdrawcurrency", "syncdrawamount", "syncdrawdate", "startintdate", "expiredate"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!LoanTypeEnum.isBanksLoan((String)((String)this.getModel().getValue("loantype"))) ? 1 : 0) != 0, (String[])new String[]{"synccreditlimit"});
            this.showSyncCreditLimit(isBindData);
            this.setSyncDrawMustInput();
            this.setSyncDrawFloatRate();
            if (this.getView().getControl("syncterm") != null) {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"syncterm"});
            }
        } else {
            this.disableSyncDrawEvt();
            this.setSlbankEntryLoanamt(isSyncDraw);
        }
    }

    private void setSlbankEntryLoanamt(boolean isSync) {
        int entryRowCount = this.getModel().getEntryRowCount("banksyndicate_entry");
        if (entryRowCount == 0) {
            return;
        }
        for (int i = 0; i < entryRowCount; ++i) {
            BigDecimal shareAmt = (BigDecimal)this.getModel().getValue("e_shareamount", i);
            if (EmptyUtil.isEmpty((BigDecimal)shareAmt)) continue;
            this.getModel().setValue("e_loanamount", (Object)(isSync ? shareAmt : BigDecimal.ZERO), i);
        }
        this.getView().updateView("banksyndicate_entry");
    }

    private void showSyncCreditLimit(boolean isBindata) {
        IDataModel model = this.getModel();
        if (!isBindata) {
            this.getModel().setValue("synccreditlimit", null);
        }
        if (!this.validSyncDrawAndForm()) {
            return;
        }
        DynamicObject productFactory = (DynamicObject)model.getValue("productfactory");
        String loanType = (String)model.getValue("loantype");
        boolean isBankLoan = LoanTypeEnum.isBanksLoan((String)loanType);
        if (isBankLoan) {
            return;
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)productFactory)) {
            boolean isLoanCon = productFactory.getBoolean("isloancommit");
            if (productFactory.getBoolean("iscreditlimit")) {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!isLoanCon ? 1 : 0) != 0, (String[])new String[]{"synccreditlimit"});
            } else {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"synccreditlimit"});
            }
            if (isLoanCon) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"synccreditlimit"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"synccreditlimit"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"synccreditlimit"});
        }
    }

    private void setSyncDrawMustInput() {
        if (!this.validSyncDrawAndForm()) {
            return;
        }
        String repaymentWay = (String)this.getModel().getValue("repaymentway");
        RepaymentWayEnum repayWayEnum = RepaymentWayEnum.getByValue((String)repaymentWay);
        String settleIntMode = (String)this.getModel().getValue("settleintmode");
        boolean interestSettledPlanMustInput = repayWayEnum == RepaymentWayEnum.bqhbdqhx || repayWayEnum == RepaymentWayEnum.dqhbdqhx || repayWayEnum == RepaymentWayEnum.zdyhk && SettleIntModeEnum.gdpljx.getValue().equals(settleIntMode);
        boolean stagePlanMustInput = repayWayEnum == RepaymentWayEnum.dqhblsbq || repayWayEnum == RepaymentWayEnum.dqhbdqhx || repayWayEnum == RepaymentWayEnum.debx || repayWayEnum == RepaymentWayEnum.debj || repayWayEnum == RepaymentWayEnum.dbdx;
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)interestSettledPlanMustInput, (String[])new String[]{"interestsettledplan"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)stagePlanMustInput, (String[])new String[]{"stageplan"});
    }

    private void afterAuditOperation(AfterDoOperationEventArgs args) {
        DynamicObject dataFromDB;
        Long pkValue;
        if (args.getOperationResult().isSuccess() && (pkValue = (Long)this.getModel().getDataEntity().getPkValue()) != null && pkValue != 0L && (dataFromDB = TmcDataServiceHelper.loadSingle((Object)pkValue, (String)this.getModel().getDataEntityType().getName())).getBoolean("issyncdraw")) {
            String formId = this.getView().getFormShowParameter().getFormId();
            if ("cfm_loancontract_bo".equals(formId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c\u8ba1\u5212\u5ba1\u6838\u5b8c\u6210\u540e\uff0c\u7cfb\u7edf\u5c06\u540c\u6b65\u751f\u6210\u503a\u5238\u53d1\u884c\u5355\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"ContractBaseEdit_09", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            } else if ("cfm_loancontract_bl_l".equals(formId) || "cfm_loancontract_ic_l".equals(formId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u5ba1\u6838\u786e\u8ba4\u5b8c\u6210\u540e\uff0c\u7cfb\u7edf\u5c06\u540c\u6b65\u751f\u6210\u63d0\u6b3e\u5355\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"ContractBaseEdit_08", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            } else if ("cim_invest_contract".equals(formId) || "ifm_loancontractbill".equals(formId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u5ba1\u6838\u786e\u8ba4\u5b8c\u6210\u540e\uff0c\u7cfb\u7edf\u5c06\u540c\u6b65\u751f\u6210\u653e\u6b3e\u5355\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"ContractBaseEdit_13", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void settlementChangeEvent() {
        String settleMode = (String)this.getModel().getValue("settleintmode");
        boolean isGdpljx = SettleIntModeEnum.gdpljx.getValue().equals(settleMode);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isGdpljx, (String[])new String[]{"interestsettledplan"});
    }

    private boolean validSyncDrawAndForm() {
        Boolean isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw");
        String formId = this.getView().getFormShowParameter().getFormId();
        ArrayList<String> enableFormList = new ArrayList<String>();
        enableFormList.add("cfm_loancontract_bl_l");
        enableFormList.add("cfm_loancontract_ic_l");
        enableFormList.add("cim_invest_contract");
        enableFormList.add("ifm_loancontractbill");
        enableFormList.add("fl_leasecontractbill");
        enableFormList.add("fl_leasecontractbill_init");
        return enableFormList.contains(formId) && isSyncDraw != false;
    }

    private void setSyncDrawFloatRate() {
        if (!this.validSyncDrawAndForm()) {
            return;
        }
        String interestType = (String)this.getModel().getValue("interesttype");
        String adjustStyle = (String)this.getModel().getValue("rateadjuststyle");
        if (RateAdjustStyleEnum.CYCLE.getValue().equals(adjustStyle) && InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"rateadjustdate"});
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"rateadjustdate"});
        }
    }

    private void disableSyncDrawEvt() {
        IDataModel model = this.getModel();
        TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String[])new String[]{"syncdrawcurrency", "syncdrawamount", "syncdrawdate", "startintdate", "expiredate", "irr", "fixedrepayamount"});
        if (!EmptyUtil.isEmpty((Object)this.getModel().getValue("synccreditlimit"))) {
            this.getModel().setValue("synccreditlimit", null);
        }
        if (this.getView().getControl("syncterm") != null) {
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String[])new String[]{"syncterm"});
        }
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"interestsettledplan", "stageplan"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"syncdrawcurrency", "syncdrawamount", "syncdrawdate", "startintdate", "expiredate", "synccreditlimit"});
        if (this.getView().getControl("syncterm") != null) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"syncterm"});
        }
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"rateadjustdate"});
    }

    private void beforeRepay(BeforeDoOperationEventArgs evtArgs) {
        this.validateDiffCurrency(evtArgs);
        this.validateContractApply(evtArgs);
    }

    private void validateContractApply(BeforeDoOperationEventArgs evtArgs) {
        QFilter qFilter = new QFilter("loancontractbill", "=", this.getModel().getDataEntity().getPkValue());
        qFilter.and("bizstatus", "in", (Object)new String[]{ApplyBizStatusEnum.APPLYING.getValue(), ApplyBizStatusEnum.HANDING.getValue()});
        boolean exists = QueryServiceHelper.exists((String)"cfm_contract_apply", (QFilter[])qFilter.toArray());
        if (exists) {
            String entityName = this.getModel().getDataEntityType().getName();
            String tipMsg = StringUtils.equals((CharSequence)entityName, (CharSequence)"fl_leasecontractbill") ? CfmFormResourceEnum.ContractBaseEdit_21.loadKDString() : CfmFormResourceEnum.ContractBaseEdit_20.loadKDString();
            this.getView().showTipNotification(tipMsg);
            evtArgs.setCancel(true);
        }
    }

    private void validateDiffCurrency(BeforeDoOperationEventArgs evtArgs) {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        QFilter qFilter = new QFilter("loancontractbill", "=", this.getModel().getDataEntity().getPkValue());
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilter.and(new QFilter("currency", "!=", currency.getPkValue()));
        boolean exists = TmcDataServiceHelper.exists((String)"cfm_loanbill", (QFilter[])qFilter.toArray());
        if (exists) {
            String dataSource = this.getModel().getDataEntity().getString("datasource");
            AbstractBizResource biz2Resource = new BizResourceFactory().getBizResource(dataSource);
            this.getView().showTipNotification(biz2Resource.getDiffCurrencyRepayMsg());
            evtArgs.setCancel(true);
        }
    }

    private void checkContract(BeforeDoOperationEventArgs args) {
        String billFormId = this.getView().getFormShowParameter().getFormId();
        String dataSource = (String)this.getModel().getValue("datasource");
        AbstractBizResource biz2Resource = new BizResourceFactory().getBizResource(dataSource);
        if (StringUtils.equals((CharSequence)"cfm_loancontract_ic_l", (CharSequence)billFormId) && StringUtils.equals((CharSequence)DataSourceEnum.INVEST.getValue(), (CharSequence)dataSource)) {
            this.getView().showTipNotification(biz2Resource.checkContractBillsAdjustOp());
            args.setCancel(true);
        }
    }

    private void copyDataByProduct() {
        DynamicObject pfDO = (DynamicObject)this.getModel().getValue("productfactory");
        if (EmptyUtil.isNoEmpty((DynamicObject)pfDO)) {
            Boolean isCalInterest = pfDO.getBoolean("iscallint");
            this.getModel().setValue("iscallint", (Object)isCalInterest);
            this.getModel().setValue("iscandefer", (Object)pfDO.getBoolean("iscandefer"));
            this.getModel().setValue("iscycleloan", pfDO.get("iscycleloan"));
            if (!"cfm_loancontract_bo".equals(this.getModel().getDataEntityType().getName())) {
                this.getModel().setValue("repaymentway", (Object)pfDO.getString("repaymentmode"));
                if (pfDO.getBoolean("iscallint")) {
                    this.getModel().setValue("interesttype", (Object)pfDO.getString("ratetype"));
                    this.getModel().setValue("basis", (Object)pfDO.getString("basis"));
                    this.getModel().setValue("settleintmode", (Object)pfDO.getString("settleintmode"));
                    this.getModel().setValue("rateadjuststyle", (Object)pfDO.getString("rateadjustmethod"));
                    this.getModel().setValue("rateadjustcycletype", (Object)pfDO.getString("rateresetcycle"));
                    this.getModel().setValue("rateadjustcycle", (Object)pfDO.getString("rateresetcycleday"));
                    this.getModel().setValue("payintadjustrule", (Object)pfDO.getString("payintadjustrule"));
                    this.getModel().setValue("rateresetadjustrule", (Object)pfDO.getString("rateresetadjustrule"));
                    this.getModel().setValue("intcalmethod", (Object)pfDO.getString("intcalmethod"));
                    this.getModel().setValue("issofrrate", (Object)pfDO.getString("issofrrate"));
                    this.getModel().setValue("iscallcompint", (Object)pfDO.getString("iscallcompint"));
                }
            }
        }
    }

    private List<DynamicObject> queryLoanBillGcBills() {
        ArrayList<DynamicObject> gcBills = new ArrayList<DynamicObject>();
        Object id = this.getModel().getValue("id");
        DynamicObjectCollection loanBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id,creditlimit", (QFilter[])new QFilter("loancontractbill", "=", id).and("billstatus", "in", (Object)new String[]{BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue()}).and("creditlimit", "is not null", null).toArray());
        if (LoanTypeEnum.isBanksLoan((String)((String)this.getModel().getValue("loantype")))) {
            loanBills = LoanBillRepository.getBanksCreditByContractId((Long)((Long)id));
            Set loanBillIds = loanBills.stream().map(o -> o.get("id")).filter(r -> EmptyUtil.isNoEmpty((Long)((Long)r))).collect(Collectors.toSet());
            Set creditLimitIds = loanBills.stream().map(o -> o.get("banksyndicate_entry.e_bankcreditlimit")).filter(r -> EmptyUtil.isNoEmpty((Long)((Long)r))).collect(Collectors.toSet());
            loanBills = QueryServiceHelper.query((String)"cfm_credituse", (String)"sourcebillid as id,creditlimit", (QFilter[])new QFilter("sourcebillid", "in", loanBillIds).and("creditlimit", "in", creditLimitIds).and("billstatus", "in", (Object)new String[]{BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue()}).toArray());
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)loanBills)) {
            Set creditLimitIds = loanBills.stream().map(o -> o.get("creditlimit")).filter(r -> EmptyUtil.isNoEmpty((Long)((Long)r))).collect(Collectors.toSet());
            if (EmptyUtil.isEmpty(creditLimitIds)) {
                return gcBills;
            }
            DynamicObjectCollection creditLimitGcBills = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", GCProps), (QFilter[])new QFilter("gsrcbillid", "in", creditLimitIds).toArray());
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)creditLimitGcBills)) {
                Map<Object, List<DynamicObject>> creditLimitGcBillMap = creditLimitGcBills.stream().collect(Collectors.groupingBy(o -> o.get("gsrcbillid")));
                QFilter filter = null;
                for (DynamicObject loanBill : loanBills) {
                    Object loanBillId = loanBill.get("id");
                    Object creditLimitId = loanBill.get("creditlimit");
                    List<DynamicObject> GcBills = creditLimitGcBillMap.get(creditLimitId);
                    if (EmptyUtil.isEmpty(GcBills)) continue;
                    QFilter appendFilter = new QFilter("gsrcbillid", "=", loanBillId).and("gcontract", "in", GcBills.stream().map(o -> o.get("gcontract")).collect(Collectors.toSet()));
                    if (filter == null) {
                        filter = appendFilter;
                        continue;
                    }
                    filter.or(appendFilter);
                }
                DynamicObjectCollection loanBillGcBills = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", GCProps), (QFilter[])new QFilter[]{filter}, (String)"createtime asc");
                HashMap<String, DynamicObject> guaranteeContractMap = new HashMap<String, DynamicObject>(loanBillGcBills.size());
                for (DynamicObject loanBillGcBill : loanBillGcBills) {
                    Long gContractId = loanBillGcBill.getLong("gcontract");
                    String creditorType = loanBillGcBill.getString("gcreditortype");
                    Long creditor = loanBillGcBill.getLong("gcreditor");
                    BigDecimal curAmount = loanBillGcBill.getBigDecimal("gamount");
                    BigDecimal curRatio = loanBillGcBill.getBigDecimal("gratio");
                    BigDecimal curBizAmount = curAmount.multiply(Constants.ONE_HUNDRED).divide(curRatio, 6, RoundingMode.HALF_UP);
                    DynamicObject guaranteeContract = (DynamicObject)guaranteeContractMap.get(gContractId + creditorType + creditor);
                    if (guaranteeContract != null) {
                        BigDecimal lastAmount = guaranteeContract.getBigDecimal("gamount");
                        BigDecimal lastRatio = guaranteeContract.getBigDecimal("gratio");
                        BigDecimal lastBizAmount = lastAmount.multiply(Constants.ONE_HUNDRED).divide(lastRatio, 6, RoundingMode.HALF_UP);
                        loanBillGcBill.set("gamount", (Object)curAmount.add(lastAmount));
                        loanBillGcBill.set("gratio", (Object)curAmount.add(lastAmount).multiply(Constants.ONE_HUNDRED).divide(curBizAmount.add(lastBizAmount), 6, RoundingMode.HALF_UP));
                    }
                    guaranteeContractMap.put(gContractId + creditorType + creditor, loanBillGcBill);
                }
                gcBills.addAll(guaranteeContractMap.values());
            }
        }
        return gcBills;
    }

    private void appendLoanBillGcBills(List<DynamicObject> loanBillGcBills) {
        if (EmptyUtil.isNoEmpty(loanBillGcBills)) {
            for (DynamicObject gcBIll : loanBillGcBills) {
                int index = this.getModel().createNewEntryRow("entry_gcontract");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gcontract", (Object)gcBIll.get("gcontract"), (int)index);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gratio", (Object)gcBIll.get("gratio"), (int)index);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gamount", (Object)gcBIll.getBigDecimal("gamount"), (int)index);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gexchrate", (Object)gcBIll.get("gexchrate"), (int)index);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gcomment", (Object)gcBIll.get("gcomment"), (int)index);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gcontractamount", (Object)gcBIll.get("gcontract.amount"), (int)index);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gcontractcurrency", (Object)gcBIll.get("gcontract.currency"), (int)index);
                if (gcBIll.getBigDecimal("gratio").compareTo(BigDecimal.ZERO) == 0) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gstatus", (Object)GuaUseStatusEnum.RELIEVED.getValue(), (int)index);
                } else if (gcBIll.getBigDecimal("gdebtbalance").compareTo(BigDecimal.ZERO) == 0 || LoanContractStatusEnum.isClosed((String)((String)this.getModel().getValue("contractstatus")))) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gstatus", (Object)GuaUseStatusEnum.SETTLED.getValue(), (int)index);
                } else {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gstatus", (Object)GuaUseStatusEnum.GUARANTEEING.getValue(), (int)index);
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gcreditortype", (Object)gcBIll.get("gcreditortype"), (int)index);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gcreditor", (Object)gcBIll.get("gcreditor"), (int)index);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gcreditortext", (Object)gcBIll.get("gcreditortext"), (int)index);
            }
            GuaranteeEntryHelper.setCreditGuarantee((IDataModel)this.getModel());
            this.getView().updateView("entry_gcontract");
            this.getModel().setDataChanged(false);
        }
    }

    private void calSyncTerm() {
        if (this.getView().getControl("syncterm") == null) {
            return;
        }
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        Date bizDate = (Date)this.getModel().getValue("startintdate");
        if (EmptyUtil.isNoEmpty((Object)bizDate) && EmptyUtil.isNoEmpty((Object)expireDate)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"syncterm", (Object)DateUtils.getDiff_ymd((Date)bizDate, (Date)expireDate));
        }
    }

    protected void calExprieDate() {
        Date bizDate = (Date)this.getModel().getValue("startintdate");
        String term = (String)this.getModel().getValue("syncterm");
        if (EmptyUtil.isNoEmpty((Object)bizDate) && EmptyUtil.isNoEmpty((String)term)) {
            Date expireDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)bizDate);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", (Object)expireDate);
        }
    }

    private void acctBankChgEvt() {
        String formId = this.getView().getFormShowParameter().getFormId();
        DynamicObject accountBank = (DynamicObject)this.getModel().getValue("accountbank");
        if (!EmptyUtil.isEmpty((DynamicObject)accountBank)) {
            DynamicObject company;
            if ("ifm_loancontractbill".equals(this.getModel().getDataEntityType().getName()) && EmptyUtil.isEmpty((DynamicObject)(company = (DynamicObject)this.getModel().getValue("org")))) {
                DynamicObject openOrg = accountBank.getDynamicObject("openorg");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"org", (Object)openOrg);
            }
            if ("cfm_loancontract_bl_l".equals(formId)) {
                DynamicObject creditOrg = (DynamicObject)this.getModel().getValue("creditorg");
                String creditText = (String)this.getModel().getValue("textcreditor");
                if (EmptyUtil.isEmpty((DynamicObject)creditOrg) && EmptyUtil.isEmpty((String)creditText)) {
                    DynamicObject bank = accountBank.getDynamicObject("bank");
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"creditor", (Object)bank.getLong("id"));
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"textcreditor", (Object)bank.getString("name"));
                }
            }
        }
    }

    private boolean isSetCreditorByAccount(String key) {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("ifm_loancontractbill".equals(this.getModel().getDataEntityType().getName()) && key.equals("accountbank")) {
            return true;
        }
        String creditorType = (String)this.getModel().getValue("creditortype");
        return "cfm_loancontract_bl_l".equals(formId) && key.equals("accountbank") && (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType) || CreditorTypeEnum.BANK.getValue().equals(creditorType));
    }

    private void validateFirstRateAdjustDate(BeforeFieldPostBackEvent e, String key, String value) {
        if (!LoanBillFormHelper.isSofr((IDataModel)this.getModel())) {
            return;
        }
        String timeFormStr = ((DateEdit)this.getControl("rateadjustdate")).getFormatString();
        Date rateAdjustDate = DateUtils.stringToDate((String)value, (String)timeFormStr);
        Date startIntDate = (Date)this.getModel().getValue("startdate");
        if (EmptyUtil.isNoEmpty((Object)startIntDate) && rateAdjustDate.compareTo(startIntDate) > 0) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5728sofr\u5229\u7387\u60c5\u51b5\u4e0b,\u9996\u6b21\u5229\u7387\u786e\u5b9a\u65e5\u4e0d\u80fd\u5927\u4e8e\u5408\u540c\u5f00\u59cb\u65e5\u3002", (String)"ContractBaseEdit_01", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            this.getView().updateView(key);
            return;
        }
        DynamicObjectCollection workCalendar = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)workCalendar)) {
            return;
        }
        if (!WorkCalendarHelper.isWorkDay((DynamicObjectCollection)workCalendar, (Date)rateAdjustDate)) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5728sofr\u5229\u7387\u60c5\u51b5\u4e0b,\u9996\u6b21\u5229\u7387\u786e\u5b9a\u65e5\u5fc5\u987b\u662f\u5de5\u4f5c\u65e5,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ContractBaseEdit_12", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            this.getView().updateView(key);
        }
    }

    private void validateImportData(ImportDataEventArgs e) {
        String lenderApplyNo;
        ArrayList<String> errorMsg = new ArrayList<String>(16);
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!BillStatusEnum.isSave((String)billStatus)) {
            errorMsg.add(ResManager.loadKDString((String)"\u53ea\u80fd\u5bfc\u5165\u6682\u5b58\u72b6\u6001\u7684\u5408\u540c\u5355\u636e\u3002", (String)"ContractBaseEdit_19", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        }
        String entityName = this.getModel().getDataEntityType().getName();
        String creditorType = (String)this.getModel().getValue("creditortype");
        if (!Objects.equals("ifm_loancontractbill", entityName) && Objects.equals(creditorType, CreditorTypeEnum.SETTLECENTER.getValue())) {
            errorMsg.add(ResManager.loadKDString((String)"\u503a\u6743\u4eba\u7c7b\u578b\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\uff0c\u4e0d\u5141\u8bb8\u901a\u8fc7\u6a21\u677f\u5bfc\u5165\u3002", (String)"ContractBaseEdit_15", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        }
        if (EmptyUtil.isNoEmpty((String)(lenderApplyNo = (String)this.getModel().getValue("lenderapplyno")))) {
            String field = "id,company,loantype,finproduct,creditortype,creditor,textcreditor,currency,amount,billstatus,businessstatus";
            DynamicObject loanApplyBill = TmcDataServiceHelper.loadSingleFromCache((String)"cfm_loan_apply", (String)field, (QFilter[])new QFilter("billno", "=", (Object)lenderApplyNo).toArray());
            if (null == loanApplyBill) {
                errorMsg.add(ResManager.loadKDString((String)"\u878d\u8d44\u7533\u8bf7\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"ContractBaseEdit_14", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            } else {
                if (!BillStatusEnum.isAudit((String)loanApplyBill.getString("billstatus"))) {
                    errorMsg.add(ResManager.loadKDString((String)"\u878d\u8d44\u7533\u8bf7\u7684\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u5df2\u5ba1\u6838\u3002", (String)"ContractBaseEdit_16", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                }
                if (!ApplyBusinessStatusEnum.isNotHand((String)loanApplyBill.getString("businessstatus"))) {
                    errorMsg.add(ResManager.loadKDString((String)"\u878d\u8d44\u7533\u8bf7\u7684\u4e1a\u52a1\u72b6\u6001\u4e0d\u7b49\u4e8e\u672a\u529e\u7406\u3002", (String)"ContractBaseEdit_17", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                }
                List<String> specialProps = Arrays.asList("creditorg", "org", "creditor", "debtor");
                for (Map.Entry<String, String> entry : this.getPropMatchMap().entrySet()) {
                    Object importData = this.getModel().getValue(entry.getKey());
                    Object applyData = loanApplyBill.get(entry.getValue());
                    if (specialProps.contains(entry.getKey()) && EmptyUtil.isEmpty((Object)importData)) continue;
                    if ("creditorg".equals(entry.getKey()) && EmptyUtil.isNoEmpty((Object)importData)) {
                        importData = ((DynamicObject)importData).getPkValue();
                    }
                    if ("debtor".equals(entry.getKey())) {
                        applyData = ((DynamicObject)applyData).getPkValue();
                    }
                    if (this.isEqual(importData, applyData)) continue;
                    errorMsg.add(ResManager.loadKDString((String)"\u878d\u8d44\u7533\u8bf7\u4e0e\u501f\u6b3e\u5408\u540c\u4e2d\u7684%s\u4e0d\u4e00\u81f4\u3002", (String)"ContractBaseEdit_18", (String)"tmc-cfm-formplugin", (Object[])new Object[]{CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)entry.getKey())}));
                }
            }
        }
        if (EmptyUtil.isNoEmpty(errorMsg)) {
            e.setCancel(true);
            e.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), errorMsg);
        }
    }

    private void complementDrawInfo() {
        this.getModel().setValue("confirmstatus", (Object)ConfirmStatusEnum.REGISTRYING.getValue());
        this.getModel().setValue("contractstatus", (Object)ContractStatusEnum.REGISTRATION.getValue());
        String lenderApplyNo = (String)this.getModel().getValue("lenderapplyno");
        if (EmptyUtil.isNoEmpty((String)lenderApplyNo)) {
            DynamicObject loanApplyBill = TmcDataServiceHelper.loadSingleFromCache((String)"cfm_loan_apply", (String)"id,creditor", (QFilter[])new QFilter("billno", "=", (Object)lenderApplyNo).toArray());
            Object id = loanApplyBill.getPkValue();
            this.getModel().setValue("loanapply", id);
            this.getModel().setValue("sourcebillid", id);
            Long sTableId = TmcBotpHelper.getTableIdByEntityKey((String)"cfm_loan_apply");
            DynamicObjectCollection lkEntry = this.getModel().getEntryEntity("billhead_lk");
            DynamicObject addNew = lkEntry.addNew();
            addNew.set("seq", (Object)1);
            addNew.set("billhead_lk_stableid", (Object)sTableId);
            addNew.set("billhead_lk_sbillid", id);
            addNew.set("billhead_lk_sid", id);
        }
    }

    private boolean isEqual(Object args1, Object args2) {
        if (EmptyUtil.isEmpty((Object)args1) || EmptyUtil.isEmpty((Object)args2)) {
            return false;
        }
        if (args1 instanceof BigDecimal && args2 instanceof BigDecimal) {
            return ((BigDecimal)args1).compareTo((BigDecimal)args2) == 0;
        }
        if (args1 instanceof DynamicObject && args2 instanceof DynamicObject) {
            return ((DynamicObject)args1).getPkValue().equals(((DynamicObject)args2).getPkValue());
        }
        return Objects.equals(args1, args2);
    }

    private Map<String, String> getPropMatchMap() {
        HashMap<String, String> propMatchMap = new HashMap<String, String>(16);
        propMatchMap.put("loantype", "loantype");
        propMatchMap.put("finproduct", "finproduct");
        propMatchMap.put("creditortype", "creditortype");
        propMatchMap.put("textcreditor", "textcreditor");
        propMatchMap.put("currency", "currency");
        propMatchMap.put("amount", "amount");
        propMatchMap.put("creditorg", "creditor");
        propMatchMap.put("creditor", "creditor");
        propMatchMap.put("org", "company");
        propMatchMap.put("debtor", "company");
        return propMatchMap;
    }

    private void setInterestSettledPlan() {
        boolean isNot0Rate = BigDecimal.ZERO.compareTo((BigDecimal)this.getModel().getValue("startinterestrate")) != 0;
        LoanBillFormHelper.setInterestSettledPlan((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)isNot0Rate);
    }

    private void amountChgEvt() {
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        Boolean isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw");
        BigDecimal syncDrawAmount = (BigDecimal)this.getModel().getValue("syncdrawamount");
        IDataModel model = this.getModel();
        if (isSyncDraw.booleanValue() && EmptyUtil.isNoEmpty((BigDecimal)amount) && EmptyUtil.isEmpty((BigDecimal)syncDrawAmount)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"syncdrawamount", (Object)amount);
        }
    }

    private void checkAcctBank(String acctBankField) {
        QFilter statusFilter = new QFilter("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        DynamicObject accountBank = (DynamicObject)this.getModel().getValue(acctBankField);
        if (EmptyUtil.isNoEmpty((DynamicObject)accountBank)) {
            statusFilter.and("id", "=", accountBank.getPkValue());
            accountBank = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"id", (QFilter[])statusFilter.toArray());
            if (EmptyUtil.isEmpty((DynamicObject)accountBank)) {
                this.getModel().setValue(acctBankField, null);
            }
        }
    }

    private void setDebtorOrgWhenImport(Map<String, Object> sourceData) {
        String debtType = Optional.ofNullable((String)sourceData.get("debtortype")).orElse("");
        if (!CreditorTypeEnum.isInnerUnit((String)debtType)) {
            return;
        }
        String debtText = (String)sourceData.get("textdebtor");
        DynamicObject debtOrg = TmcDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)debtText)});
        if (EmptyUtil.isEmpty((DynamicObject)debtOrg)) {
            return;
        }
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"debtor", (Object)debtOrg.getPkValue());
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"org", (Object)debtOrg);
    }
}

