/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.contractbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.helper.CfmFinVarietyHelper;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.AbstractCreditLimitEditPlugin;

public class ContractCreditLimitPlugin
extends AbstractCreditLimitEditPlugin {
    protected static final String SYNC_CREDITLIMIT = "synccreditlimit";
    private final String[] GUARANTEE_USE_PROPS = new String[]{"gcomment", "gcontract", "gamount", "gcontract.amount", "gcontract.currency", "gratio", "gexchrate", "gsrcbilltype", "gsrcbillid"};

    protected Map<String, String> getBizPropertys() {
        HashMap<String, String> propertys = new HashMap<String, String>();
        propertys.put("org", this.getOrgField());
        propertys.put("finorg", this.getFinOrgField());
        propertys.put("amount", "amount");
        propertys.put("currency", "currency");
        propertys.put("startDate", "startdate");
        propertys.put("endDate", "enddate");
        return propertys;
    }

    protected Long getCreditTypeId() {
        DynamicObject finProduct = (DynamicObject)this.getModel().getValue("finproduct");
        if (null == finProduct) {
            return 0L;
        }
        return CfmFinVarietyHelper.getCreditTypeByFinVarietyId((Long)((Long)finProduct.getPkValue()));
    }

    protected BigDecimal setCreditRatio() {
        DynamicObject finProduct = (DynamicObject)this.getModel().getValue("finproduct");
        BigDecimal creditRatio = finProduct != null && finProduct.containsProperty("creditratio") ? finProduct.getBigDecimal("creditratio") : Constants.ONE_HUNDRED;
        creditRatio = this.dealSuretyRatio(creditRatio);
        DynamicObject creditLimit = (DynamicObject)this.getModel().getValue("creditlimit");
        DynamicObject syncCreditLimit = (DynamicObject)this.getModel().getValue(SYNC_CREDITLIMIT);
        if (creditLimit == null && syncCreditLimit == null) {
            return creditRatio;
        }
        if (this.getPageCache().get("ratio") != null) {
            return new BigDecimal(this.getPageCache().get("ratio"));
        }
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("id"))) {
            DynamicObject creditUseBill;
            String entityName = this.getModel().getDataEntityType().getName();
            if ("fl_leasecontractbill_init".equals(entityName)) {
                entityName = "fl_leasecontractbill";
            }
            if ((creditUseBill = CreditLimitHelper.getCreditUseBill((Long)((Long)this.getModel().getValue("id")), (String)entityName)) != null) {
                return creditUseBill.getBigDecimal("creditratio");
            }
        }
        return creditRatio;
    }

    private BigDecimal dealSuretyRatio(BigDecimal creditRatio) {
        DynamicObjectCollection sureties = this.getModel().getEntryEntity("entry_surety");
        BigDecimal suretyRatio = sureties.stream().filter(d -> EmptyUtil.isNoEmpty((DynamicObject)d.getDynamicObject("suretybill"))).map(d -> d.getDynamicObject("suretybill").getBigDecimal("suretyrate")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal ratio = creditRatio.subtract(suretyRatio);
        return ratio.compareTo(BigDecimal.ZERO) > 0 ? ratio : BigDecimal.ZERO;
    }

    protected String getCreditVariety() {
        DynamicObject finProduct = (DynamicObject)this.getModel().getValue("finproduct");
        return null == finProduct ? "" : finProduct.getString("name");
    }

    protected BigDecimal getAmount() {
        return (BigDecimal)this.getModel().getValue("amount");
    }

    public boolean isSubmitReCreate() {
        DynamicObject contractDO = this.getModel().getDataEntity();
        if (CfmContractBillHelper.mayUseCreditLimit((DynamicObject)contractDO)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected void setCreditUseFields() {
        String loanType = (String)this.getModel().getValue("loantype");
        if (!LoanTypeEnum.isBanksLoan((String)loanType)) {
            super.setCreditUseFields();
        }
    }

    protected Long getSourceBillId() {
        DynamicObject apply = (DynamicObject)this.getModel().getValue("loanapply");
        if (apply == null) {
            this.getPageCache().remove("sourceType");
            return null;
        }
        this.getPageCache().put("sourceType", "cfm_loan_apply");
        return apply.getLong("id");
    }

    protected String getSourceType() {
        return this.getPageCache().get("sourceType");
    }

    public void afterBindData(EventObject e) {
        DynamicObject contractDO;
        super.afterBindData(e);
        String applyNo = (String)this.getModel().getValue("lenderapplyno");
        if (EmptyUtil.isNoEmpty((String)applyNo)) {
            DynamicObject applyF7DO = (DynamicObject)this.getModel().getValue("loanapply");
            Object applyID = applyF7DO.getPkValue();
            DynamicObject applyDO = TmcDataServiceHelper.loadSingle((Object)applyID, (String)"cfm_loan_apply");
            DynamicObject applyCreditLimitF7DO = applyDO.getDynamicObject("creditlimit");
            if (applyCreditLimitF7DO != null) {
                DynamicObject contractCreditLimitF7DO = (DynamicObject)this.getModel().getValue("creditlimit");
                if (contractCreditLimitF7DO != null && applyCreditLimitF7DO.getPkValue().equals(contractCreditLimitF7DO.getPkValue())) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"creditlimit"});
                    return;
                }
                this.controlCreditLimit();
                this.controlSyncDrawCreditLimit();
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"creditlimit"});
        }
        if (CfmContractBillHelper.mustUseCreditLimit((DynamicObject)(contractDO = this.getModel().getDataEntity())) && !LoanTypeEnum.isBanksLoan((String)contractDO.getString("loantype"))) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"creditlimit"});
        }
        this.setEcreditLimitCapiton();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "lenderapplyno": {
                String applyNo = (String)this.getModel().getValue("lenderapplyno");
                if (EmptyUtil.isEmpty((String)applyNo)) {
                    this.getModel().setValue("loanapply", (Object)0L);
                    this.getModel().setValue("creditlimit", null);
                    this.getView().setEnable(Boolean.TRUE, new String[]{"creditlimit"});
                    this.getModel().setValue(SYNC_CREDITLIMIT, null);
                    this.getView().setEnable(Boolean.TRUE, new String[]{SYNC_CREDITLIMIT});
                } else {
                    this.controlCreditLimit();
                    this.controlSyncDrawCreditLimit();
                }
                this.removeCreditLimit();
                this.removeSyncCreditLimit();
                break;
            }
            case "productfactory": 
            case "creditortype": 
            case "debtortype": {
                DynamicObject contractDO = this.getModel().getDataEntity();
                this.controlCreditLimit();
                boolean isCredit = CfmContractBillHelper.mustUseCreditLimit((DynamicObject)contractDO);
                boolean isBankSloan = LoanTypeEnum.isBanksLoan((String)contractDO.getString("loantype"));
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (isCredit && !isBankSloan ? 1 : 0) != 0, (String[])new String[]{"creditlimit"});
                this.removeCreditLimit();
                this.removeSyncCreditLimit();
                this.setEcreditLimitCapiton();
                break;
            }
            case "amount": 
            case "creditor": {
                this.removeCreditLimit();
                break;
            }
            case "currency": {
                this.removeCreditLimit();
                this.removeSyncCreditLimit();
                break;
            }
            case "expiredate": 
            case "syncdrawdate": {
                this.removeSyncCreditLimit();
                break;
            }
            case "syncdrawamount": {
                this.removeSyncCreditLimit();
                this.setBankLoandAmount();
                break;
            }
            case "synccreditlimit": {
                Object creditLimit = this.getModel().getValue(SYNC_CREDITLIMIT);
                if (creditLimit != null) break;
                this.getPageCache().remove("CREDITCHOOSE");
                break;
            }
            case "issyncdraw": {
                Boolean isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw");
                if (isSyncDraw.booleanValue()) {
                    this.controlSyncDrawCreditLimit();
                } else {
                    this.clearSyncDrawCreditLimit();
                }
                this.controlSyncDrawGuaranteeEntry();
                this.setEcreditLimitCapiton();
                break;
            }
            case "e_loanamount": {
                this.setLoanAmount(e);
                break;
            }
            case "loantype": {
                this.setEcreditLimitCapiton();
                break;
            }
        }
    }

    private void controlSyncDrawGuaranteeEntry() {
        if (!"cfm_loancontractbill".equals(this.getModel().getDataEntityType().getName()) || !LoanTypeEnum.BANKSLOAN.getValue().equals(this.getModel().getValue("loantype"))) {
            return;
        }
        this.getModel().deleteEntryData("entry_gcontract");
        DynamicObjectCollection bankSyndicateEntry = this.getModel().getEntryEntity("banksyndicate_entry");
        Map<Long, DynamicObject> bankSyndicateMaps = bankSyndicateEntry.stream().filter(e -> EmptyUtil.isNoEmpty((Object)e.get("e_creditlimit"))).collect(Collectors.toMap(k -> k.getDynamicObject("e_creditlimit").getLong("id"), v -> v));
        DynamicObjectCollection guaranteeUseBills = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", this.GUARANTEE_USE_PROPS), (QFilter[])new QFilter[]{new QFilter("gsrcbillid", "in", bankSyndicateMaps.keySet())}, (String)"id");
        HashMap<Long, ArrayList<DynamicObject>> guaranteeUseMaps = new HashMap<Long, ArrayList<DynamicObject>>(guaranteeUseBills.size());
        for (DynamicObject guaranteeUseBill : guaranteeUseBills) {
            ArrayList<DynamicObject> listTemp = (ArrayList<DynamicObject>)guaranteeUseMaps.get(guaranteeUseBill.getLong("gsrcbillid"));
            if (listTemp == null) {
                listTemp = new ArrayList<DynamicObject>(10);
            }
            listTemp.add(guaranteeUseBill);
            guaranteeUseMaps.put(guaranteeUseBill.getLong("gsrcbillid"), listTemp);
        }
        for (Map.Entry<Long, DynamicObject> bankSyndicateDo : bankSyndicateMaps.entrySet()) {
            List gcUseList = (List)guaranteeUseMaps.get(bankSyndicateDo.getKey());
            this.createOrUpdateSlEntryRow(gcUseList, bankSyndicateDo.getValue());
        }
    }

    private void createOrUpdateSlEntryRow(List<DynamicObject> guaranteeUseBills, DynamicObject bankSyndicate) {
        if (EmptyUtil.isEmpty(guaranteeUseBills)) {
            return;
        }
        DynamicObject bizCcy = (DynamicObject)this.getModel().getValue(GuaranteeUseHelper.getBizPropName((String)this.getModel().getDataEntityType().getName(), (String)"bizcurrency"));
        BigDecimal sumRatio = BigDecimal.ZERO;
        for (DynamicObject guaranteeUseBill : guaranteeUseBills) {
            DynamicObject creditUseDo;
            BigDecimal gRatio = guaranteeUseBill.getBigDecimal("gratio");
            if (EmptyUtil.isNoEmpty((DynamicObject)bankSyndicate.getDynamicObject("e_creditlimit")) && EmptyUtil.isNoEmpty((DynamicObject)(creditUseDo = QueryServiceHelper.queryOne((String)"cfm_credituse", (String)"creditratio", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)bankSyndicate.getDynamicObject("e_creditlimit").getLong("id")), new QFilter("sourcetype", "=", (Object)"cfm_creditlimit")})))) {
                gRatio = gRatio.multiply(creditUseDo.getBigDecimal("creditratio")).divide(Constants.ONE_HUNDRED);
            }
            guaranteeUseBill.set("gratio", (Object)gRatio);
            sumRatio = sumRatio.add(gRatio);
        }
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (int rowIdx = 0; rowIdx < guaranteeUseBills.size(); ++rowIdx) {
            BigDecimal gAmount;
            DynamicObject productFactory = (DynamicObject)this.getModel().getValue("productfactory");
            boolean isContractOccupy = EmptyUtil.isNoEmpty((DynamicObject)productFactory) && productFactory.getBoolean("isloancommit");
            boolean isLoanAmount = (Boolean)this.getModel().getValue("issyncdraw") != false && !isContractOccupy;
            BigDecimal amount = bankSyndicate.getBigDecimal(isLoanAmount ? "e_loanamount" : "e_shareamount");
            BigDecimal gRatio = guaranteeUseBills.get(rowIdx).getBigDecimal("gratio");
            if (Constants.ONE_HUNDRED.compareTo(sumRatio) == 0 && rowIdx == guaranteeUseBills.size() - 1) {
                gAmount = amount.subtract(sumAmount);
            } else {
                gAmount = amount.multiply(gRatio).divide(Constants.ONE_HUNDRED, bizCcy.getInt("amtprecision"), RoundingMode.HALF_UP);
                sumAmount = sumAmount.add(gAmount);
            }
            if (this.updateHasSlEntryRow(guaranteeUseBills.get(rowIdx), gRatio, amount)) continue;
            this.createNewSlEntryRow(guaranteeUseBills.get(rowIdx), bizCcy, gRatio, gAmount);
        }
    }

    private boolean updateHasSlEntryRow(DynamicObject guaranteeUseBill, BigDecimal gRatio, BigDecimal amount) {
        DynamicObjectCollection gContractUseEntry = this.getModel().getEntryEntity("entry_gcontract");
        for (int index = 0; index < gContractUseEntry.size(); ++index) {
            DynamicObject gContractUse = (DynamicObject)gContractUseEntry.get(index);
            Long gContractId = gContractUse.getDynamicObject("gcontract").getLong("id");
            if (!gContractId.equals(guaranteeUseBill.getLong("gcontract"))) continue;
            BigDecimal curEntryAmount = amount.multiply(gRatio).divide(Constants.ONE_HUNDRED);
            BigDecimal gEntryAmount = gContractUse.getBigDecimal("gamount");
            BigDecimal gEntryRatio = gContractUse.getBigDecimal("gratio");
            BigDecimal gElementAmt = gEntryAmount.multiply(gEntryRatio).add(curEntryAmount.multiply(gEntryRatio));
            BigDecimal gDenominatorAmt = gEntryAmount.add(amount.multiply(gEntryRatio).divide(Constants.ONE_HUNDRED));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gamount", (Object)gEntryAmount.add(curEntryAmount), (int)index);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gratio", (Object)gElementAmt.divide(gDenominatorAmt, 6, RoundingMode.HALF_UP), (int)index);
            return true;
        }
        return false;
    }

    private void createNewSlEntryRow(DynamicObject guaranteeUseBill, DynamicObject bizCcy, BigDecimal gRatio, BigDecimal gAmount) {
        BigDecimal rate;
        boolean diffCurrency;
        int index = this.getModel().createNewEntryRow("entry_gcontract");
        this.getModel().setValue("gcontract", guaranteeUseBill.get("gcontract"), index);
        this.getModel().setValue("gsrcbilltype", guaranteeUseBill.get("gsrcbilltype"), index);
        this.getModel().setValue("gsrcbillid", guaranteeUseBill.get("gsrcbillid"), index);
        this.getModel().setValue("gratio", (Object)gRatio, index);
        this.getModel().setValue("gamount", (Object)gAmount, index);
        this.getModel().setValue("gcomment", guaranteeUseBill.get("gcomment"), index);
        Long gCcyId = guaranteeUseBill.getLong("gcontract.currency");
        boolean bl = diffCurrency = bizCcy != null && !gCcyId.equals(bizCcy.getPkValue());
        if (diffCurrency) {
            String gOrgPropName = GuaranteeUseHelper.getBizPropName((String)this.getModel().getDataEntityType().getName(), (String)"debtor");
            DynamicObject company = (DynamicObject)this.getModel().getValue(gOrgPropName);
            Long debtorId = EmptyUtil.isNoEmpty((DynamicObject)company) ? Long.valueOf(company.getLong("id")) : (Long)this.getModel().getValue("debtor");
            rate = TmcBusinessBaseHelper.getExchangeRate((long)bizCcy.getLong("id"), (long)gCcyId, (long)debtorId, (Date)DateUtils.getCurrentDate());
        } else {
            rate = BigDecimal.ONE;
        }
        this.getModel().setValue("gexchrate", (Object)rate, index);
    }

    private void setLoanAmount(PropertyChangedArgs e) {
        if (this.getPageCache().getAll().containsKey("e_shareamount")) {
            return;
        }
        ChangeData[] changeSet = e.getChangeSet();
        Object oldValue = changeSet[0].getOldValue();
        int bankCurrIndex = this.getModel().getEntryCurrentRowIndex("banksyndicate_entry");
        this.getModel().setValue("e_creditlimit", null, bankCurrIndex);
        TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (int)bankCurrIndex, (String[])new String[]{"e_creditcurrency", "e_creditamt"});
        int entryRowCount = this.getModel().getEntryRowCount("banksyndicate_entry");
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("banksyndicate_entry", bankCurrIndex);
        Boolean isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw");
        BigDecimal syncAmount = (BigDecimal)this.getModel().getValue("syncdrawamount");
        BigDecimal currLoanAmount = rowEntity.getBigDecimal("e_loanamount");
        BigDecimal currShareAmount = rowEntity.getBigDecimal("e_shareamount");
        if (currLoanAmount != null && (isSyncDraw.booleanValue() && currLoanAmount.compareTo(syncAmount) > 0 || currLoanAmount.compareTo(currShareAmount) > 0)) {
            this.getPageCache().put("e_shareamount", "e_shareamount");
            rowEntity.set("e_loanamount", oldValue);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d0\u6b3e\u4efd\u989d\u4e0d\u80fd\u8d85\u8fc7\u63d0\u6b3e\u91d1\u989d\u548c\u5408\u540c\u4efd\u989d\u3002", (String)"ContractCreditLimitPlugin_02", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            this.getPageCache().remove("e_shareamount");
            return;
        }
        BigDecimal loanTotalAmt = BigDecimal.ZERO;
        for (int i = 0; i < entryRowCount; ++i) {
            BigDecimal loanAmount = (BigDecimal)this.getModel().getValue("e_loanamount", i);
            loanTotalAmt = loanTotalAmt.add(EmptyUtil.isEmpty((BigDecimal)loanAmount) ? BigDecimal.ZERO : loanAmount);
        }
        if (loanTotalAmt.compareTo(syncAmount) != 0) {
            BigDecimal subAmount = syncAmount.subtract(loanTotalAmt);
            int nextIdx = bankCurrIndex + 1 == entryRowCount ? 0 : entryRowCount - 1;
            BigDecimal loAmt = (BigDecimal)this.getModel().getValue("e_loanamount", nextIdx);
            BigDecimal conAmt = (BigDecimal)this.getModel().getValue("e_shareamount", nextIdx);
            if (subAmount.compareTo(BigDecimal.ZERO) > 0 && conAmt.subtract(loAmt).compareTo(subAmount) < 0) {
                return;
            }
            BigDecimal amt = loAmt.add(subAmount);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_loanamount", (Object)(amt.compareTo(BigDecimal.ZERO) > 0 ? amt : BigDecimal.ZERO), (int)nextIdx);
            this.getModel().setValue("e_creditlimit", null, nextIdx);
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (int)nextIdx, (String[])new String[]{"e_creditcurrency", "e_creditamt"});
        }
    }

    private void controlCreditLimit() {
        DynamicObject finProduct = (DynamicObject)this.getModel().getValue("finproduct");
        if (EmptyUtil.isEmpty((DynamicObject)finProduct)) {
            this.getModel().setValue("creditlimit", null);
            return;
        }
        DynamicObject apply = (DynamicObject)this.getModel().getValue("loanapply");
        if (apply != null && apply.getDynamicObject("creditlimit") != null && CfmContractBillHelper.mayUseCreditLimit((IDataModel)this.getModel())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"creditlimit"});
            DynamicObject creditUseBill = CreditLimitHelper.getCreditUseBill((Long)apply.getLong("id"), (String)this.getBillType());
            this.getPageCache().put("ratio", String.valueOf(creditUseBill.getBigDecimal("creditratio")));
            this.getPageCache().put("creditlimit", "creditlimit");
            HashMap<String, Object> valMap = new HashMap<String, Object>();
            valMap.put("creditlimit", apply.getDynamicObject("creditlimit").getPkValue());
            String creditorType = (String)this.getModel().getValue("creditortype");
            String loanType = (String)this.getModel().getValue("loantype");
            String billStatus = (String)this.getModel().getValue("billstatus");
            if (BillStatusEnum.SAVE.getValue().equals(billStatus) && (CfmContractBillHelper.creditPreUse((String)loanType, (String)creditorType) || StringUtils.equals((CharSequence)this.getModel().getDataEntityType().getName(), (CharSequence)"fl_leasecontractbill"))) {
                valMap.put("creditamt", creditUseBill.getBigDecimal("realamt"));
                valMap.put("creditcurrency", creditUseBill.getDynamicObject("currency").getPkValue());
            }
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), valMap);
        } else if (!StringUtils.equals((CharSequence)this.getModel().getDataEntityType().getName(), (CharSequence)"fl_leasecontractbill")) {
            this.getModel().setValue("creditlimit", null);
        }
    }

    private String getBillType() {
        return "fl_leasecontractbill".equals(this.getModel().getDataEntityType().getName()) ? "fl_financelease_apply" : "cfm_loan_apply";
    }

    protected void controlSyncDrawCreditLimit() {
        IDataModel model = this.getModel();
        DynamicObject finProduct = (DynamicObject)model.getValue("finproduct");
        if (EmptyUtil.isEmpty((DynamicObject)finProduct)) {
            model.setValue(SYNC_CREDITLIMIT, null);
            return;
        }
        Boolean isSyncDraw = (Boolean)model.getValue("issyncdraw");
        if (!isSyncDraw.booleanValue()) {
            return;
        }
        DynamicObject apply = (DynamicObject)model.getValue("loanapply");
        boolean showSyncDrawCreditLimit = true;
        DynamicObject productFactory = (DynamicObject)model.getValue("productfactory");
        if (StringUtils.equals((CharSequence)this.getModel().getDataEntityType().getName(), (CharSequence)"fl_leasecontractbill") && EmptyUtil.isEmpty((DynamicObject)productFactory) || !EmptyUtil.isEmpty((DynamicObject)productFactory) && productFactory.getBoolean("isloancommit")) {
            showSyncDrawCreditLimit = false;
        }
        this.getView().setVisible(Boolean.valueOf(showSyncDrawCreditLimit), new String[]{SYNC_CREDITLIMIT});
        this.getView().setEnable(Boolean.TRUE, new String[]{SYNC_CREDITLIMIT});
        if (apply != null && apply.getDynamicObject("creditlimit") != null && showSyncDrawCreditLimit) {
            this.getView().setEnable(Boolean.FALSE, new String[]{SYNC_CREDITLIMIT});
            DynamicObject creditUseBill = CreditLimitHelper.getCreditUseBill((Long)apply.getLong("id"), (String)this.getBillType());
            this.getPageCache().put("ratio", String.valueOf(creditUseBill.getBigDecimal("creditratio")));
            this.getPageCache().put("creditlimit", "creditlimit");
            HashMap<String, Object> valMap = new HashMap<String, Object>();
            valMap.put(SYNC_CREDITLIMIT, apply.getDynamicObject("creditlimit").getPkValue());
            String creditorType = (String)this.getModel().getValue("creditortype");
            String loanType = (String)this.getModel().getValue("loantype");
            String billStatus = (String)this.getModel().getValue("billstatus");
            if (BillStatusEnum.SAVE.getValue().equals(billStatus) && CfmContractBillHelper.creditPreUse((String)loanType, (String)creditorType)) {
                valMap.put("creditamt", creditUseBill.getBigDecimal("realamt"));
                valMap.put("creditcurrency", creditUseBill.getDynamicObject("currency").getPkValue());
            }
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), valMap);
        } else {
            this.getModel().setValue(SYNC_CREDITLIMIT, null);
        }
    }

    private void clearSyncDrawCreditLimit() {
        IDataModel model = this.getModel();
        DynamicObject apply = (DynamicObject)model.getValue("loanapply");
        boolean showSyncDrawCreditLimit = true;
        DynamicObject productFactory = (DynamicObject)model.getValue("productfactory");
        if (!EmptyUtil.isEmpty((DynamicObject)productFactory) && productFactory.getBoolean("isloancommit")) {
            showSyncDrawCreditLimit = false;
        }
        if (apply != null && apply.getDynamicObject("creditlimit") != null && showSyncDrawCreditLimit) {
            HashMap<String, Object> valMap = new HashMap<String, Object>();
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)SYNC_CREDITLIMIT, null);
            valMap.put("creditamt", null);
            valMap.put("creditcurrency", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), valMap);
        }
    }

    private void removeCreditLimit() {
        if (this.getPageCache().get("creditlimit") == null) {
            this.getModel().setValue("creditlimit", null);
        }
    }

    private void removeSyncCreditLimit() {
        Boolean isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw");
        if (this.getPageCache().get("creditlimit") == null || !isSyncDraw.booleanValue()) {
            this.getModel().setValue(SYNC_CREDITLIMIT, null);
        }
    }

    protected String creditType() {
        String loanType = (String)this.getModel().getValue("loantype");
        if (LoanTypeEnum.ENTRUSTLOAN.getValue().equals(loanType) || LoanTypeEnum.LINKLEND.getValue().equals(loanType)) {
            return CreditFinTypeEnum.ORG.getValue();
        }
        return CreditFinTypeEnum.FINORG.getValue();
    }

    protected String getOrgField() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("cim_invest_contract".equals(formId)) {
            return "debtor";
        }
        return "org";
    }

    protected String getFinOrgField() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("cim_invest_contract".equals(formId)) {
            return "creditorg";
        }
        return "creditor";
    }

    public boolean checkCreditlimitParams() {
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{this.getOrgText(), this.getFinOrgText(), this.getBizPropertys().get("currency"), this.getBizPropertys().get("amount")});
    }

    private String getOrgText() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("cim_invest_contract".equals(formId)) {
            return "textdebtor";
        }
        return "org";
    }

    private String getFinOrgText() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("cim_invest_contract".equals(formId)) {
            return "creditorg";
        }
        return "textcreditor";
    }

    protected String getCreditUseAmtField() {
        Object creditLimit = this.getModel().getValue("creditlimit");
        if (EmptyUtil.isEmpty((Object)creditLimit)) {
            return null;
        }
        return "creditamt";
    }

    protected String getCreditUseCurrencyField() {
        return "creditcurrency";
    }

    protected Long getCreditUseSrcBillId() {
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("creditlimit"))) {
            DynamicObject loanApply = (DynamicObject)this.getModel().getValue("loanapply");
            return EmptyUtil.isNoEmpty((DynamicObject)loanApply) ? Long.valueOf(loanApply.getLong("id")) : null;
        }
        return null;
    }

    protected Map<String, String> getCreditlimiFieldMap() {
        Map fieldMap = super.getCreditlimiFieldMap();
        fieldMap.put(SYNC_CREDITLIMIT, "");
        return fieldMap;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("submit".equals(op.getOperateKey()) || "save".equals(op.getOperateKey())) {
            DynamicObject creditLimit = (DynamicObject)this.getModel().getValue("creditlimit");
            DynamicObject syncCreditLimit = (DynamicObject)this.getModel().getValue(SYNC_CREDITLIMIT);
            if (EmptyUtil.isNoEmpty((DynamicObject)syncCreditLimit) && EmptyUtil.isEmpty((DynamicObject)creditLimit) && this.getPageCache().get("CREDITCHOOSE") == null) {
                if (EmptyUtil.isEmpty((Object)this.getModel().getValue("id"))) {
                    this.getModel().setValue("id", (Object)DBServiceHelper.genGlobalLongId());
                }
                QFilter filter = new QFilter("creditlimit", "=", syncCreditLimit.getPkValue());
                filter.and(new QFilter("sourcebillid", "=", this.getModel().getValue("id")));
                boolean isExist = TmcDataServiceHelper.exists((String)"cfm_credituse", (QFilter[])filter.toArray());
                if (!isExist || this.isSubmitReCreate()) {
                    CreditLimitUseBean useBean = this.getCreditLimitUseInfo("creditlimit");
                    useBean.setPreOccupy(Boolean.valueOf(false));
                    useBean.setCreditLimitNo(syncCreditLimit.getString("number"));
                    CreditLimitServiceHelper.autoUseCreditLimit((CreditLimitUseBean)useBean);
                }
            }
        }
    }

    protected CreditLimitUseBean getCreditLimitUseInfo(String fieldF7) {
        boolean fromLoanApply;
        CreditLimitUseBean useBean = super.getCreditLimitUseInfo(fieldF7);
        boolean bl = fromLoanApply = this.getPageCache().get("CREDITCHOOSE") == null && this.getModel().getValue(SYNC_CREDITLIMIT) != null;
        if (SYNC_CREDITLIMIT.equals(fieldF7) || fromLoanApply) {
            BigDecimal amount = (BigDecimal)this.getModel().getValue("syncdrawamount");
            useBean.setMaxAmt(amount);
            useBean.setBizAmt(amount);
            useBean.setStartDate((Date)this.getModel().getValue("syncdrawdate"));
            useBean.setEndDate((Date)this.getModel().getValue("expiredate"));
        }
        if ("fl_leasecontractbill_init".equals(this.getModel().getDataEntityType().getName())) {
            useBean.setEntityName("fl_leasecontractbill");
            useBean.setSourceType("fl_leasecontractbill");
        }
        return useBean;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObjectCollection sureties;
        BigDecimal suretyRatio;
        BigDecimal creditRatio;
        boolean isCheck;
        super.beforeF7Select(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (!this.getCreditlimiFieldMap().containsKey(key)) {
            return;
        }
        if (SYNC_CREDITLIMIT.equals(key) && !(isCheck = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"syncdrawamount", "syncdrawdate", "expiredate"}))) {
            evt.setCancel(true);
            return;
        }
        DynamicObject finProduct = (DynamicObject)this.getModel().getValue("finproduct");
        BigDecimal bigDecimal = creditRatio = finProduct != null && finProduct.containsProperty("creditratio") ? finProduct.getBigDecimal("creditratio") : Constants.ONE_HUNDRED;
        if (EmptyUtil.isEmpty((BigDecimal)creditRatio)) {
            creditRatio = Constants.ONE_HUNDRED;
        }
        if (creditRatio.compareTo(suretyRatio = (sureties = this.getModel().getEntryEntity("entry_surety")).stream().filter(d -> EmptyUtil.isNoEmpty((DynamicObject)d.getDynamicObject("suretybill"))).map(d -> d.getDynamicObject("suretybill").getBigDecimal("suretyrate")).reduce(BigDecimal.ZERO, BigDecimal::add)) <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6388\u4fe1\u5360\u6bd4\u4e3a0\uff0c\u65e0\u6cd5\u9009\u62e9\u6388\u4fe1\u989d\u5ea6\u5355\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ContractCreditLimitPlugin_01", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private void setBankLoandAmount() {
        if (!((Boolean)this.getModel().getValue("issyncdraw")).booleanValue() || !BizTypeEnum.SL.getValue().equals(this.getModel().getValue("loantype"))) {
            return;
        }
        DynamicObjectCollection bankCateEntrys = this.getModel().getEntryEntity("banksyndicate_entry");
        BigDecimal syncAmount = (BigDecimal)this.getModel().getValue("syncdrawamount");
        BigDecimal shareTotalAmt = bankCateEntrys.stream().map(o -> o.getBigDecimal("e_shareamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal totalAmount = BigDecimal.ZERO;
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        int amtPrecision = EmptyUtil.isNoEmpty((DynamicObject)currency) ? currency.getInt("amtprecision") : 2;
        for (int i = 0; i < bankCateEntrys.size(); ++i) {
            DynamicObject bankCateEntry = (DynamicObject)bankCateEntrys.get(i);
            BigDecimal shareAmount = bankCateEntry.getBigDecimal("e_shareamount");
            BigDecimal loanAmount = BigDecimal.ZERO;
            if (EmptyUtil.isNoEmpty((BigDecimal)shareTotalAmt)) {
                loanAmount = shareAmount.multiply(syncAmount).divide(shareTotalAmt, amtPrecision, RoundingMode.HALF_UP);
            }
            if (shareAmount.compareTo(loanAmount) < 0) {
                loanAmount = shareAmount;
            }
            totalAmount = totalAmount.add(loanAmount);
            BigDecimal loanAmt = bankCateEntry.getBigDecimal("e_loanamount");
            if (loanAmount.compareTo(loanAmt) == 0) continue;
            bankCateEntry.set("e_loanamount", (Object)loanAmount);
            this.getModel().setValue("e_creditlimit", null, i);
            bankCateEntry.set("e_creditcurrency", null);
            bankCateEntry.set("e_creditamt", (Object)BigDecimal.ZERO);
        }
        BigDecimal subAmount = syncAmount.subtract(totalAmount);
        List entryList = bankCateEntrys.stream().filter(o -> "MB".equals(o.getString("e_bankrole"))).collect(Collectors.toList());
        if (BigDecimal.ZERO.compareTo(subAmount) != 0 && EmptyUtil.isNoEmpty(entryList)) {
            BigDecimal loanAmount;
            DynamicObject mbEntry = (DynamicObject)entryList.get(0);
            BigDecimal shareAmount = mbEntry.getBigDecimal("e_shareamount");
            if (shareAmount.subtract(loanAmount = mbEntry.getBigDecimal("e_loanamount")).compareTo(subAmount) > 0) {
                mbEntry.set("e_loanamount", (Object)loanAmount.add(subAmount));
            } else {
                this.setScaleAmount(bankCateEntrys, subAmount);
            }
        }
        this.getView().updateView("banksyndicate_entry");
    }

    private void setScaleAmount(DynamicObjectCollection bankCateEntrys, BigDecimal subAmount) {
        for (DynamicObject bankCateEntry : bankCateEntrys) {
            if (EmptyUtil.isEmpty((BigDecimal)subAmount)) break;
            if ("MB".equals(bankCateEntry.getString("e_bankrole"))) continue;
            BigDecimal shareAmount = bankCateEntry.getBigDecimal("e_shareamount");
            BigDecimal loanAmount = bankCateEntry.getBigDecimal("e_loanamount");
            BigDecimal eAmount = shareAmount.subtract(loanAmount);
            if (subAmount.compareTo(BigDecimal.ZERO) > 0 && eAmount.compareTo(subAmount) < 0) {
                subAmount = subAmount.subtract(eAmount);
                bankCateEntry.set("e_loanamount", (Object)shareAmount.add(eAmount));
                continue;
            }
            bankCateEntry.set("e_loanamount", (Object)shareAmount.add(subAmount));
            break;
        }
    }

    private void setEcreditLimitCapiton() {
        FieldEdit eCreditLimit;
        String loanType = (String)this.getModel().getValue("loantype");
        if (!LoanTypeEnum.isBanksLoan((String)loanType)) {
            return;
        }
        DynamicObject productFact = (DynamicObject)this.getModel().getValue("productfactory");
        boolean isSyncDraw = (Boolean)this.getModel().getValue("issyncdraw");
        boolean isBanksLoanLimit = CreditLimitHelper.isBanksLoanLimit((DynamicObject)productFact, (String)((String)this.getModel().getValue("loantype")));
        boolean isSave = BillStatusEnum.isSave((String)((String)this.getModel().getValue("billstatus")));
        this.getView().setVisible(Boolean.valueOf(!isSyncDraw || isSave || !isBanksLoanLimit), new String[]{"e_creditcurrency", "e_creditamt"});
        MainEntityType loanContract = EntityMetadataCache.getDataEntityType((String)"cfm_loancontractbill");
        EntryProp entryProperty = (EntryProp)loanContract.getProperties().get((Object)"banksyndicate_entry");
        LocaleString caption = new LocaleString(CfmFormResourceEnum.BankContractCreditLimitPlugin_0.loadKDString());
        LocaleString localeString = caption = entryProperty != null ? ((IDataEntityProperty)entryProperty.getDynamicCollectionItemPropertyType().getProperties().get((Object)"e_creditlimit")).getDisplayName() : caption;
        if (CreditLimitHelper.isBanksLoanLimit((DynamicObject)productFact, (String)loanType) && isSyncDraw) {
            caption = new LocaleString(CfmFormResourceEnum.BankContractCreditLimitPlugin_1.loadKDString());
        }
        if ((eCreditLimit = (FieldEdit)this.getView().getControl("e_creditlimit")) != null) {
            eCreditLimit.setCaption(caption);
        }
    }
}

