/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.contractbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.DecimalProp;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.AdjustEleEnum;
import kd.tmc.cfm.common.enums.ContractStatusEnum;
import kd.tmc.cfm.common.enums.RateSignEnum;
import kd.tmc.cfm.mservice.compcost.CompCostServiceImpl;
import kd.tmc.fbp.common.bean.CompCostRateBean;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.MarketDataHelper;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class ContractRateList
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(ContractRateList.class);

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                long t1 = System.currentTimeMillis();
                DynamicObjectCollection collection = super.getData(start, limit);
                if (EmptyUtil.isEmpty((DynamicObjectCollection)collection)) {
                    return collection;
                }
                Set listFields = this.getListFields().stream().map(ListField::getFieldName).collect(Collectors.toSet());
                DynamicObject dynamicObject = (DynamicObject)collection.get(0);
                DataEntityPropertyCollection properties = dynamicObject.getDynamicObjectType().getProperties();
                boolean containLastRate = listFields.contains("latestrate");
                containLastRate = containLastRate && properties.containsKey((Object)"latestrate") && properties.containsKey((Object)"interesttype");
                Map<Long, BigDecimal> idRateMap = null;
                HashMap<String, Map<Date, BigDecimal>> doneReferRateMap = new HashMap<String, Map<Date, BigDecimal>>();
                Map referRateMapTmp = null;
                if (containLastRate) {
                    idRateMap = this.getRateByExtendAndAdjust(collection);
                    doneReferRateMap = new HashMap();
                    referRateMapTmp = ContractRateList.this.getLatestReferRateNum(collection, properties, doneReferRateMap);
                }
                String entityName = this.getEntityType().getName();
                Map<Long, BigDecimal> rateMap = null;
                boolean containCostrate = listFields.contains("compcostrate");
                if (containCostrate) {
                    if (!properties.containsKey((Object)"compcostrate")) {
                        this.addDynamicProp(collection);
                    }
                    List ids = collection.stream().map(v -> v.get("id")).collect(Collectors.toList());
                    Iterator compCostService = new CompCostServiceImpl();
                    List costBeans = compCostService.calcCompCostForContract(ids);
                    List rateBeans = compCostService.calCompCostRateForContract(costBeans);
                    rateMap = rateBeans.stream().collect(Collectors.toMap(CompCostRateBean::getBillId, CompCostRateBean::getRateAmt));
                }
                boolean isLoanContractBond = StringUtils.equals((CharSequence)"cfm_loancontract_bo", (CharSequence)entityName);
                for (DynamicObject v2 : collection) {
                    if (!isLoanContractBond) {
                        if (containLastRate) {
                            this.setLatestRate(v2, properties, idRateMap, referRateMapTmp, doneReferRateMap);
                        }
                        this.setNoFixedTerm(v2, properties);
                    }
                    if (isLoanContractBond) {
                        this.perpetualBond(v2, properties);
                    }
                    if (!containCostrate) continue;
                    this.calcCompCostRate(v2, rateMap);
                }
                long t2 = System.currentTimeMillis();
                logger.info("\u6700\u65b0\u5229\u7387\u67e5\u8be2\u7528\u65f6\uff1a {} ms", (Object)(t2 - t1));
                return collection;
            }

            private void calcCompCostRate(DynamicObject bill, Map<Long, BigDecimal> rateMap) {
                bill.set("compcostrate", (Object)rateMap.get(bill.getLong("id")));
            }

            private void addDynamicProp(DynamicObjectCollection rows) {
                DataEntityPropertyCollection properties = rows.getDynamicObjectType().getProperties();
                DecimalProp addProp = new DecimalProp();
                addProp.setName("compcostrate");
                addProp.setDisplayName(new LocaleString("compcostrate"));
                properties.add((Object)addProp);
            }

            private void setNoFixedTerm(DynamicObject v, DataEntityPropertyCollection properties) {
                if (!ContractRateList.this.getBillFormId().equals("fl_leasecontractbill") && !ContractRateList.this.getBillFormId().equals("cfm_loancontract_bo") && properties.containsKey((Object)"isnofixedterm") && v.getBoolean("isnofixedterm")) {
                    if (properties.containsKey((Object)"enddate")) {
                        v.set("enddate", null);
                    }
                    if (properties.containsKey((Object)"term")) {
                        v.set("term", (Object)" ");
                    }
                }
            }

            private void setLatestRate(DynamicObject v, DataEntityPropertyCollection properties, Map<Long, BigDecimal> idRateMap, Map<String, Map<Date, BigDecimal>> referRateMapTmp, Map<String, Map<Date, BigDecimal>> doneReferRateMap) {
                Date date = DateUtils.getCurrentDate();
                if (properties.containsKey((Object)"contractstatus") && ContractStatusEnum.isDone((String)v.getString("contractstatus"))) {
                    date = v.getDate("closeoffdate");
                }
                if (!InterestTypeEnum.isFloat((String)v.getString("interesttype"))) {
                    if (v.containsProperty("renewalexpiredate") && EmptyUtil.isNoEmpty((Object)v.getDate("renewalexpiredate")) && EmptyUtil.isNoEmpty((BigDecimal)idRateMap.get(v.getLong("id")))) {
                        v.set("latestrate", (Object)idRateMap.get(v.getLong("id")));
                    } else {
                        v.set("latestrate", v.get("interestrate"));
                    }
                    return;
                }
                if (!properties.containsKey((Object)"referencerate")) {
                    return;
                }
                DynamicObject referenceRate = v.getDynamicObject("referencerate");
                if (EmptyUtil.isEmpty((DynamicObject)referenceRate)) {
                    v.set("latestrate", null);
                    return;
                }
                BigDecimal rate = BigDecimal.ZERO;
                try {
                    Map<Date, BigDecimal> refermap;
                    Map<Date, BigDecimal> dateBigDecimalMap;
                    rate = ContractStatusEnum.isDone((String)v.getString("contractstatus")) ? ((dateBigDecimalMap = doneReferRateMap.get(referenceRate.getString("number"))) != null ? dateBigDecimalMap.get(date) : BigDecimal.ZERO) : ((refermap = referRateMapTmp.get(referenceRate.getString("number"))) != null ? refermap.values().stream().findFirst().orElse(BigDecimal.ZERO) : BigDecimal.ZERO);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    v.set("latestrate", v.get("startinterestrate"));
                    return;
                }
                if (EmptyUtil.isEmpty((BigDecimal)rate)) {
                    v.set("latestrate", null);
                    return;
                }
                BigDecimal rateFloatPoint = properties.containsKey((Object)"ratefloatpoint") ? v.getBigDecimal("ratefloatpoint") : BigDecimal.ZERO;
                String rateSign = properties.containsKey((Object)"ratesign") ? v.getString("ratesign") : RateSignEnum.ADD.getValue();
                BigDecimal rateFloat = BigDecimal.ZERO;
                if (EmptyUtil.isNoEmpty((BigDecimal)rateFloatPoint) && EmptyUtil.isNoEmpty((String)rateSign)) {
                    rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 20, RoundingMode.HALF_UP);
                    if (RateSignEnum.isSubtract((String)rateSign)) {
                        rateFloat = rateFloat.negate();
                    }
                }
                v.set("latestrate", (Object)rate.add(rateFloat));
            }

            private void perpetualBond(DynamicObject v, DataEntityPropertyCollection properties) {
                if (!properties.containsKey((Object)"finproduct")) {
                    return;
                }
                Boolean isPerpetual = Optional.ofNullable(v.getDynamicObject("finproduct")).map(r -> r.getBoolean("perpetualbond")).orElse(Boolean.FALSE);
                if (!isPerpetual.booleanValue()) {
                    return;
                }
                if (properties.containsKey((Object)"term")) {
                    v.set("term", null);
                }
                if (properties.containsKey((Object)"enddate")) {
                    v.set("enddate", null);
                }
            }

            private Map<Long, BigDecimal> getRateByExtendAndAdjust(DynamicObjectCollection collection) {
                HashMap<Long, BigDecimal> idRateMap = new HashMap<Long, BigDecimal>();
                Object[] contractIds = collection.stream().map(o -> o.getLong("id")).toArray();
                QFilter extentBillFilter = new QFilter("sourcebillid", "in", (Object)contractIds).and("prevrenewalexpiredate", "<=", (Object)DateUtils.getCurrentDate()).and("isadjustinterestrate", "=", (Object)Boolean.TRUE);
                DynamicObjectCollection extendBillDatas = QueryServiceHelper.query((String)"cfm_contractextendbill", (String)"id,sourcebillid,prevrenewalexpiredate,renewalinterestrate", (QFilter[])extentBillFilter.toArray());
                Map extendBillMap = extendBillDatas.stream().collect(Collectors.toMap(o -> o.getLong("sourcebillid"), Function.identity(), (a, b) -> a.getDate("prevrenewalexpiredate").compareTo(b.getDate("prevrenewalexpiredate")) >= 0 ? a : b));
                QFilter rateAdjustFilter = new QFilter("loancontractbill", "in", (Object)contractIds).and("adjusteffectdate", "<=", (Object)DateUtils.getCurrentDate()).and("adjustele", "=", (Object)AdjustEleEnum.ADJUSTCONTRACT.getValue());
                DynamicObjectCollection rateAdjustDatas = QueryServiceHelper.query((String)"cfm_rateadjustbill", (String)"id,loancontractbill,adjusteffectdate,afterinterestrate", (QFilter[])rateAdjustFilter.toArray());
                Map rateAdjustMap = rateAdjustDatas.stream().collect(Collectors.toMap(o -> o.getLong("loancontractbill"), Function.identity(), (a, b) -> a.getDate("adjusteffectdate").compareTo(b.getDate("adjusteffectdate")) >= 0 ? a : b));
                extendBillMap.forEach((k, v) -> {
                    boolean hasRenewalinterestrate = EmptyUtil.isNoEmpty((DynamicObject)v) && EmptyUtil.isNoEmpty((BigDecimal)v.getBigDecimal("renewalinterestrate"));
                    boolean hasAfterinterestrate = EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)rateAdjustMap.get(k))) && EmptyUtil.isNoEmpty((BigDecimal)((DynamicObject)rateAdjustMap.get(k)).getBigDecimal("afterinterestrate"));
                    idRateMap.put((Long)k, hasRenewalinterestrate && hasAfterinterestrate && v.getDate("prevrenewalexpiredate").before(((DynamicObject)rateAdjustMap.get(k)).getDate("adjusteffectdate")) ? ((DynamicObject)rateAdjustMap.get(k)).getBigDecimal("afterinterestrate") : v.getBigDecimal("renewalinterestrate"));
                    rateAdjustMap.remove(k);
                });
                rateAdjustMap.forEach((k, v) -> {
                    if (EmptyUtil.isNoEmpty((BigDecimal)v.getBigDecimal("afterinterestrate"))) {
                        idRateMap.put((Long)k, v.getBigDecimal("afterinterestrate"));
                    }
                });
                return idRateMap;
            }
        });
    }

    private Map<String, Map<Date, BigDecimal>> getLatestReferRateNum(DynamicObjectCollection collection, DataEntityPropertyCollection properties, Map<String, Map<Date, BigDecimal>> doneReferRateMap) {
        HashSet referNumSet = new HashSet();
        HashMap doneContractMap = new HashMap();
        collection.forEach(v -> {
            if (!properties.containsKey((Object)"latestrate") || !properties.containsKey((Object)"interesttype")) {
                return;
            }
            if (!properties.containsKey((Object)"contractstatus")) {
                return;
            }
            if (!InterestTypeEnum.FLOAT.getValue().equals(v.get("interesttype"))) {
                return;
            }
            if (!properties.containsKey((Object)"referencerate")) {
                return;
            }
            DynamicObject referenceRate = v.getDynamicObject("referencerate");
            if (EmptyUtil.isEmpty((DynamicObject)referenceRate)) {
                return;
            }
            if (ContractStatusEnum.DONE.getValue().equals(v.get("contractstatus"))) {
                List dateList = doneContractMap.getOrDefault(referenceRate.getString("number"), new ArrayList());
                dateList.add(v.getDate("closeoffdate"));
                doneContractMap.put(referenceRate.getString("number"), dateList);
                return;
            }
            referNumSet.add(referenceRate.getString("number"));
        });
        Date now = DateUtils.getCurrentDate();
        Map<String, Map<Date, BigDecimal>> referRateMap = new HashMap<String, Map<Date, BigDecimal>>();
        if (EmptyUtil.isNoEmpty(referNumSet)) {
            referRateMap = MarketDataHelper.batchReferRate(referNumSet, (Date)now, (Date)now);
        }
        if (!doneContractMap.isEmpty()) {
            for (Map.Entry doneContract : doneContractMap.entrySet()) {
                String referNum = (String)doneContract.getKey();
                List dateList = (List)doneContract.getValue();
                for (Date date : dateList) {
                    BigDecimal rate = MarketDataServiceHelper.referRate((String)referNum, (Date)date, (boolean)false);
                    Map dateBigDecimalMap = doneReferRateMap.getOrDefault(referNum, new HashMap());
                    dateBigDecimalMap.put(date, rate);
                    doneReferRateMap.put(referNum, dateBigDecimalMap);
                }
            }
        }
        return referRateMap;
    }

    private String getBillFormId() {
        BillList billList = (BillList)this.getControl("billlistap");
        return billList.getBillFormId();
    }
}

