/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.interestbill.batch;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cfm.common.enums.BatchIntViewInfoEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.cfm.formplugin.common.BatchEntryAddNewHelper;
import kd.tmc.cfm.formplugin.interestbill.batch.AbstractIntBillBatchEdit;
import kd.tmc.cfm.formplugin.loanbill.LoanBillFormHelper;
import kd.tmc.fbp.common.bean.BizBalanceModelBean;
import kd.tmc.fbp.common.enums.BalanceTypeEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.BizBalanceModelHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailExtInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.entitymap.helper.EntityMapBizHelper;

public class InterestBillBatchEdit
extends AbstractIntBillBatchEdit
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final String queryFields = "id, billno, org, creditorg, textdebtor, textcreditor, loantype, currency, loaneracctbank, repayacctbank, accountbank, isrelcash, loancontractbill, notrepayamount, drawtype, interest_entry, intstartdate, intenddate, interesdate, interestcalamount, intstate, intaccount, interest_subentry, intereststartdate, interestenddate, interestdate, interestbalance, benchmarkrate, benchmarkint, floatrate, floatint, interestrate, interestamount, interestdays, banksyndicate_entry.e_bankrole, banksyndicate_entry.e_bank, banksyndicate_entry.e_shareamount";
    private static final Log logger = LogFactory.getLog(InterestBillBatchEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit currency = (BasedataEdit)this.getControl("currency");
        this.addBeforeF7Select(currency);
        BasedataEdit accountBank = (BasedataEdit)this.getControl("accountbank");
        this.addBeforeF7Select(accountBank);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"entry", (CharSequence)entryGrid.getKey())) {
            int index = evt.getRow();
            if (index < 0) {
                return;
            }
            this.loanIntEntry(index);
        }
    }

    private void loanIntEntry(int index) {
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", index);
        if (EmptyUtil.isEmpty((DynamicObject)entry)) {
            return;
        }
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"intnum", (Object)entry.getString("intdetailnum"));
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"loannum", (Object)entry.getString("loanbillno"));
        if (this.getIntDetailFormId(entry).equals("ifm_intbillsofr_detail")) {
            BatchIntBillHelper.loanSofrIntDetailInfo((DynamicObject)entry, (AbstractFormPlugin)this, (IDataModel)this.getModel());
        } else {
            BatchIntBillHelper.loanIntDetailInfo((DynamicObject)entry, (AbstractFormPlugin)this, (IDataModel)this.getModel());
        }
    }

    private void addBeforeF7Select(BasedataEdit basedataEdit) {
        if (EmptyUtil.isNoEmpty((Object)basedataEdit)) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("deleteentryloans".equals(operateKey)) {
            String errMsg = this.checkLoansEntry();
            if (EmptyUtil.isNoEmpty((String)errMsg)) {
                args.setCancel(true);
                this.getView().showTipNotification(errMsg);
                return;
            }
            this.dealInterest();
        } else if ("addentryloans".equals(operateKey)) {
            args.setCancel(true);
            BatchEntryAddNewHelper.openAddNewNavigateForm((AbstractFormPlugin)this, (FormShowParameter)this.initParams());
        }
    }

    private FormShowParameter initParams() {
        HashMap<String, Object> initParams = new HashMap<String, Object>();
        FormShowParameter showParameter = new FormShowParameter();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        if (entrys.size() == 0) {
            return showParameter;
        }
        List loanIds = entrys.stream().map(dny -> dny.getLong("loanbillid")).collect(Collectors.toList());
        DynamicObject settleCenter = (DynamicObject)this.getModel().getValue("settlecenter");
        if (EmptyUtil.isNoEmpty((DynamicObject)settleCenter)) {
            showParameter.getCustomParams().put("settlecenter", settleCenter.getPkValue());
            initParams.put("settlecenter", settleCenter.getPkValue());
        }
        showParameter.getCustomParams().put("loanIds", loanIds);
        DynamicObject loan = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)entrys.get(0)).getLong("loanbillid"), (String)"cfm_loanbill", (String)"creditortype, datasource, creditorg, org");
        if (EmptyUtil.isNoEmpty((DynamicObject)loan)) {
            initParams.put("settlecenterloan", CreditorTypeEnum.SETTLECENTER.getValue().equals(loan.getString("creditortype")));
            initParams.put("payplan", CfmContractBillHelper.isPayIntByPlan((DynamicObject)loan));
        }
        initParams.put("calcOverInt", ((DynamicObject)entrys.get(0)).getBoolean("calcoverint"));
        initParams.put("endintdate", this.getModel().getValue("bizdate"));
        HashSet<String> orgIds = new HashSet<String>(entrys.size());
        HashSet<String> currenyIds = new HashSet<String>(entrys.size());
        HashSet<String> contractNums = new HashSet<String>(entrys.size());
        Set<Object> contractIds = new HashSet(entrys.size());
        String loanType = (String)this.getModel().getValue("loantype");
        for (DynamicObject dyn2 : entrys) {
            this.addOrgIds(loanType, dyn2, orgIds);
            currenyIds.add(dyn2.getDynamicObject("loancurrency").getPkValue().toString());
            contractNums.add(dyn2.getString("loancontractbillno"));
        }
        DynamicObject[] contractObject = BusinessDataServiceHelper.load((String)"cfm_loancontractbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "in", contractNums)});
        contractIds = Arrays.stream(contractObject).map(dyn -> dyn.getPkValue().toString()).collect(Collectors.toSet());
        initParams.put("orgs", orgIds);
        initParams.put("currencys", currenyIds);
        initParams.put("contracts", contractIds);
        showParameter.getCustomParams().put("initParams", initParams);
        return showParameter;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)"CLOSE_BAKE_KEY_FILTER", (CharSequence)evt.getActionId()) && null != evt.getReturnData()) {
            this.loadIntDetail((Map)evt.getReturnData());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("submit".equals(operateKey)) {
            this.getView().updateView();
        } else if ("deleteentryloans".equals(operateKey)) {
            this.getView().invokeOperation("save");
        }
        this.loanIntEntry(0);
        if (Arrays.asList("save", "submit", "unsubmit", "audit", "unaudit", "deleteentryloans").contains(args.getOperateKey())) {
            this.getModel().setDataChanged(false);
        }
    }

    private void dealInterest() {
        String datasource = (String)this.getModel().getValue("datasource");
        String targetEntity = DataSourceEnum.isIfm((String)datasource) ? "ifm_interestbill" : (String)BatchIntBillHelper.getBatchIntBotpPair((String)datasource).getRight();
        DynamicObjectCollection cl = this.getModel().getEntryEntity("entry");
        int[] indexs = ((EntryGrid)this.getControl("entry")).getSelectRows();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("WF", "TRUE");
        for (int i = 0; i < indexs.length; ++i) {
            Long id = ((DynamicObject)cl.get(indexs[i])).getLong("intbillid");
            if (!EmptyUtil.isNoEmpty((Long)id) || !TmcDataServiceHelper.exists((Object)id, (String)targetEntity)) continue;
            TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)targetEntity, (Object[])new Object[]{id}, (OperateOption)operateOption, (boolean)true);
            TmcOperateServiceHelper.execOperate((String)"delete", (String)targetEntity, (Object[])new Object[]{id}, (OperateOption)operateOption, (boolean)true);
        }
    }

    private String checkLoansEntry() {
        DynamicObjectCollection cl = this.getModel().getEntryEntity("entry");
        int[] indexs = ((EntryGrid)this.getControl("entry")).getSelectRows();
        if (cl.size() == indexs.length) {
            return ResManager.loadKDString((String)"\u81f3\u5c11\u6709\u4e00\u6761\u5206\u5f55\u3002", (String)"InterestBillBatchEdit_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        int entryRowCount = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", entryRowCount);
        switch (key) {
            case "currency": {
                DynamicObject loanBill = TmcDataServiceHelper.loadSingle((String)"cfm_loanbill", (String)"id, productfactory", (QFilter[])new QFilter[]{new QFilter("id", "=", entry.get("loanbillid"))});
                if (EmptyUtil.isEmpty((DynamicObject)loanBill)) {
                    return;
                }
                LoanBillFormHelper.currencyF7Evt((BeforeF7SelectEvent)evt, (IDataModel)this.getModel(), (IFormView)this.getView(), (DynamicObject)loanBill.getDynamicObject("productfactory"));
                break;
            }
            case "accountbank": {
                DynamicObject currency = entry.getDynamicObject("currency");
                if (!EmptyUtil.isNoEmpty((DynamicObject)currency)) break;
                QFilter qFilter = new QFilter("currency.fbasedataid", "=", currency.getPkValue());
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        }
    }

    protected void loadIntDetail() {
        this.getModel().deleteEntryData("entry");
        Map param = this.getView().getFormShowParameter().getCustomParams();
        Map navParam = (Map)SerializationUtils.fromJsonString((String)param.get("navparam").toString(), Map.class);
        this.loadIntDetail(navParam);
    }

    private void loadIntDetail(Map<?, ?> navParam) {
        boolean calcOverInt = true;
        if (navParam.containsKey("calcOverInt")) {
            calcOverInt = Boolean.parseBoolean((String)navParam.get("calcOverInt"));
        }
        List<Object> loanBillIds = new ArrayList(10);
        if (navParam.containsKey("loanbill")) {
            loanBillIds = (List)navParam.get("loanbill");
        }
        boolean isPayIntByPlan = false;
        if (navParam.containsKey("payplan")) {
            isPayIntByPlan = Boolean.parseBoolean((String)navParam.get("payplan"));
        }
        Map calcIntResult = (Map)JSON.parseObject((String)((String)navParam.get("calcIntResult")), (TypeReference)new TypeReference<Map<Object, IntBillExtInfo>>(){}, (Feature[])new Feature[0]);
        Set<Object> loanIds = calcIntResult.keySet();
        if (loanBillIds.size() == 0) {
            loanBillIds = loanIds.stream().collect(Collectors.toList());
        }
        DynamicObject[] loanBills = LoanBillRepository.getLoanBillById(loanBillIds, (String)queryFields);
        Map billMap = Arrays.stream(loanBills).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        Date bizDate = DateUtils.stringToDate((String)((String)navParam.get("endintdate")), (String)"yyyy-MM-dd");
        boolean isBankSloan = false;
        if (isPayIntByPlan && loanBillIds.size() > 0) {
            for (Object loanBillId : loanBillIds) {
                IntBillExtInfo extInfo;
                DynamicObject loanBill = (DynamicObject)billMap.get(loanBillId);
                if (LoanTypeEnum.isBanksLoan((String)loanBill.getString("loantype"))) {
                    isBankSloan = true;
                }
                if ((extInfo = this.getIntBillExtInfo(loanBill)) == null) continue;
                this.fillIntDetail(loanBill, extInfo, calcOverInt, isPayIntByPlan, bizDate);
            }
            loanIds = loanBillIds.stream().collect(Collectors.toSet());
        } else {
            for (Map.Entry entry : calcIntResult.entrySet()) {
                DynamicObject loanBill = (DynamicObject)billMap.get(entry.getKey());
                if (LoanTypeEnum.isBanksLoan((String)loanBill.getString("loantype"))) {
                    isBankSloan = true;
                }
                this.fillIntDetail(loanBill, (IntBillExtInfo)entry.getValue(), calcOverInt, isPayIntByPlan, bizDate);
            }
        }
        this.getView().setVisible(Boolean.valueOf(isBankSloan), new String[]{"sl_entry"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"convertrate"});
        EntityMapBizHelper.dealNoneBotpPush(loanIds, (String)"cfm_loanbill", (IDataModel)this.getModel());
    }

    protected int fillIntDetail(DynamicObject loanBill, IntBillExtInfo intDetail, boolean isCalcOverInt, boolean isPayIntByPlan, Date bizDate) {
        BizBalanceModelBean balance;
        DynamicObject intPlanEntry;
        List intPlans;
        DynamicObjectCollection intPlanEntrys;
        IDataModel model = this.getModel();
        int index = model.createNewEntryRow("entry");
        BigDecimal actualInstAmt = intDetail.getAmount();
        if (isPayIntByPlan && (intPlanEntrys = loanBill.getDynamicObjectCollection("interest_entry")).size() > 0 && (intPlans = intPlanEntrys.stream().filter(o -> o.getBigDecimal("interestcalamount").compareTo(BigDecimal.ZERO) > 0).filter(o -> o.getInt("intstate") == 0).collect(Collectors.toList())).size() > 0 && EmptyUtil.isNoEmpty((DynamicObject)(intPlanEntry = intPlans.stream().min(Comparator.comparing(c -> c.getDate("interesdate"))).orElseGet(null)))) {
            bizDate = intPlanEntry.getDate("interesdate");
            actualInstAmt = intPlanEntry.getBigDecimal("interestcalamount");
        }
        DynamicObject accountbank = this.getPayIntAccount(loanBill);
        DynamicObject currency = loanBill.getDynamicObject("currency");
        model.setValue("creditorg", (Object)loanBill.getDynamicObject("creditorg"), index);
        model.setValue("company", (Object)loanBill.getDynamicObject("org"), index);
        model.setValue("textdebtor", (Object)loanBill.getString("textdebtor"), index);
        model.setValue("currency", (Object)currency, index);
        model.setValue("loancurrency", (Object)currency, index);
        model.setValue("loancontractbillno", (Object)loanBill.getDynamicObject("loancontractbill").getString("number"), index);
        model.setValue("contractnum", (Object)loanBill.getDynamicObject("loancontractbill").getString("contractno"), index);
        model.setValue("loanbillno", (Object)loanBill.getString("billno"), index);
        model.setValue("loanbillid", (Object)loanBill.getLong("id"), index);
        model.setValue("e_isrelcash", (Object)loanBill.getBoolean("isrelcash"), index);
        String intComment = BatchIntBillHelper.genIntComment((DynamicObject)loanBill, (BatchIntViewInfoEnum)this.getBatchIntViewInfo(), (Date)bizDate, (BigDecimal)actualInstAmt, (DynamicObject)loanBill.getDynamicObject("currency"));
        model.setValue("intcomment", (Object)intComment, index);
        model.setValue("accountbank", (Object)accountbank, index);
        model.setValue("intdetail_tag", (Object)SerializationUtils.toJsonString((Object)intDetail), index);
        this.fillIntDetail(loanBill, intDetail, isCalcOverInt, index, actualInstAmt);
        model.setValue("payintdate", (Object)bizDate, index);
        this.getView().setEnable(Boolean.FALSE, index, new String[]{"convertrate"});
        this.fillSlBankEntrys(loanBill, actualInstAmt);
        if (EmptyUtil.isNoEmpty((DynamicObject)accountbank) && EmptyUtil.isNoEmpty((DynamicObject)currency) && this.getView().getControl("curbalance") != null && (balance = BizBalanceModelHelper.getRunningBalance((String)BalanceTypeEnum.BALANCE.getValue(), (long)accountbank.getLong("id"), (long)currency.getLong("id"))) != null && balance.getAmount() != null) {
            this.getModel().setValue("curbalance", (Object)balance.getAmount(), index);
        }
        return index;
    }

    private void fillSlBankEntrys(DynamicObject loanBill, BigDecimal intAmount) {
        if (!LoanTypeEnum.isBanksLoan((String)loanBill.getString("loantype"))) {
            return;
        }
        DynamicObjectCollection slBankEntrys = loanBill.getDynamicObjectCollection("banksyndicate_entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)slBankEntrys)) {
            return;
        }
        IDataModel model = this.getModel();
        AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("s_loanbillno", new Object[0]);
        vs.addField("s_bankrole", new Object[0]);
        vs.addField("s_bank", new Object[0]);
        vs.addField("s_loancurrency", new Object[0]);
        vs.addField("s_loanamount", new Object[0]);
        vs.addField("s_instcurrency", new Object[0]);
        for (DynamicObject slBankEntry : slBankEntrys) {
            long currencyId = loanBill.getDynamicObject("currency").getLong("id");
            vs.addRow(new Object[]{loanBill.getLong("id"), slBankEntry.getString("e_bankrole"), slBankEntry.getDynamicObject("e_bank").getLong("id"), currencyId, slBankEntry.getBigDecimal("e_shareamount"), currencyId});
        }
        dataModel.beginInit();
        dataModel.batchCreateNewEntryRow("slentryentity", vs);
        slBankEntrys = this.getModel().getEntryEntity("slentryentity");
        List slBankEntryList = slBankEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_loanbillno")) && loanBill.getLong("id") == o.getDynamicObject("s_loanbillno").getLong("id")).collect(Collectors.toList());
        DynamicObject currency = loanBill.getDynamicObject("currency");
        BatchIntBillHelper.setSlBankEntryAmount(slBankEntryList, (BigDecimal)intAmount, (String)"s_repayinst", (DynamicObject)currency, (boolean)true);
        dataModel.endInit();
        this.getView().updateView("slentryentity");
    }

    private DynamicObject getPayIntAccount(DynamicObject loanBill) {
        DynamicObject accountbank;
        switch (this.getParentFormId()) {
            case "cfm_intbill_batch_invest": {
                accountbank = loanBill.getDynamicObject("loaneracctbank");
                break;
            }
            case "ifm_intbill_batch_loan": {
                accountbank = loanBill.getDynamicObject("repayacctbank");
                break;
            }
            default: {
                accountbank = loanBill.getDynamicObject("accountbank");
                DynamicObjectCollection intPlanEntrys = loanBill.getDynamicObjectCollection("interest_entry");
                DynamicObject intPlan = intPlanEntrys.stream().filter(r -> r.getInt("intstate") == 0).findFirst().orElse(null);
                if (intPlan == null) break;
                accountbank = intPlan.getDynamicObject("intaccount");
            }
        }
        return accountbank;
    }

    private void fillIntDetail(DynamicObject loanBill, IntBillExtInfo intBill, boolean isCalcOverInt, int index, BigDecimal actualInstAmt) {
        IDataModel model = this.getModel();
        model.setValue("startdate", (Object)intBill.getBeginDate(), index);
        model.setValue("enddate", (Object)intBill.getEndDate(), index);
        List details = intBill.getExtDetails();
        int days = details.stream().mapToInt(IntBillDetailInfo::getDays).sum();
        model.setValue("intdays", (Object)days, index);
        details.sort((o1, o2) -> o2.getEndDate().compareTo(o1.getEndDate()));
        model.setValue("rate", (Object)((IntBillDetailExtInfo)details.get(0)).getRate(), index);
        model.setValue("interestamt", (Object)intBill.getAmount(), index);
        model.setValue("actualinstamt", (Object)actualInstAmt, index);
        model.setValue("convertrate", (Object)BigDecimal.ONE, index);
        model.setValue("convertintamt", (Object)actualInstAmt, index);
        model.setValue("principle", (Object)loanBill.getBigDecimal("notrepayamount"), index);
        model.setValue("textcreditor", (Object)loanBill.getString("textcreditor"), index);
        model.setValue("calcoverint", (Object)isCalcOverInt, index);
        model.setValue("intyearrate", (Object)intBill.calcIntYearRate(actualInstAmt), index);
        model.setValue("preintyearrate", (Object)intBill.calcIntYearRate(intBill.getAmount()), index);
    }

    protected String getEntityName() {
        return "ifm_intbill_batch_loan";
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)"actualinstamt")) {
            this.actalAmtChgEvt(e);
        }
        switch (propName = e.getProperty().getName()) {
            case "currency": {
                this.currencyChgEvt(e);
                break;
            }
            case "convertrate": {
                this.convertRateChgEvt(e);
                break;
            }
            case "actualinstamt": {
                this.actalAmtChgEvt(e);
                break;
            }
            case "accountbank": {
                this.setAccountBalance(e);
            }
        }
    }

    protected String getIntDetailFormId(DynamicObject entry) {
        long loanBillid;
        DynamicObject loanBill;
        String parentEntityName = entry.getDataEntityType().getParent().getName();
        if ("cfm_intbill_batch_loan".equals(parentEntityName) && (loanBill = TmcDataServiceHelper.loadSingle((Object)(loanBillid = entry.getLong("loanbillid")), (String)"cfm_loanbill", (String)"issofrrate")).getBoolean("issofrrate")) {
            return "ifm_intbillsofr_detail";
        }
        return "ifm_intbill_detail";
    }

    public void afterBindData(EventObject e) {
        this.initRateEnable();
        this.loanIntEntry(0);
        this.getModel().setDataChanged(false);
    }

    private void initRateEnable() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        for (int rowIndex = 0; rowIndex < entrys.size(); ++rowIndex) {
            BizBalanceModelBean balance;
            boolean isDiffCurrency;
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency", rowIndex);
            DynamicObject loanCurrency = (DynamicObject)this.getModel().getValue("loancurrency", rowIndex);
            boolean bl = isDiffCurrency = currency != null && loanCurrency != null && !currency.getPkValue().equals(loanCurrency.getPkValue());
            if (isDiffCurrency) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"convertrate"});
            } else {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"convertrate"});
            }
            DynamicObject accountbank = (DynamicObject)this.getModel().getValue("accountbank", rowIndex);
            if (this.getView().getControl("curbalance") == null) continue;
            this.getModel().setValue("curbalance", null, rowIndex);
            if (accountbank == null || currency == null || (balance = BizBalanceModelHelper.getRunningBalance((String)BalanceTypeEnum.BALANCE.getValue(), (long)accountbank.getLong("id"), (long)currency.getLong("id"))) == null || balance.getAmount() == null) continue;
            this.getModel().setValue("curbalance", (Object)balance.getAmount(), rowIndex);
        }
    }

    private void currencyChgEvt(PropertyChangedArgs e) {
        BigDecimal rate;
        boolean isDiffCurrency;
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject currency = (DynamicObject)e.getChangeSet()[0].getNewValue();
        DynamicObject oldCurrency = (DynamicObject)e.getChangeSet()[0].getOldValue();
        DynamicObject loanCurrency = (DynamicObject)this.getModel().getValue("loancurrency", rowIndex);
        boolean bl = isDiffCurrency = currency != null && loanCurrency != null && oldCurrency != null && !currency.getPkValue().equals(oldCurrency.getPkValue());
        if (isDiffCurrency) {
            DynamicObject creditOrg;
            DynamicObject company = (DynamicObject)this.getModel().getValue("company", rowIndex);
            String datasource = (String)this.getModel().getValue("datasource");
            if (DataSourceEnum.INVEST.getValue().equals(datasource) && EmptyUtil.isNoEmpty((DynamicObject)(creditOrg = (DynamicObject)this.getModel().getValue("creditorg", rowIndex)))) {
                company = creditOrg;
            }
            if (currency.getPkValue().equals(loanCurrency.getPkValue())) {
                rate = BigDecimal.ONE;
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"convertrate"});
            } else {
                rate = TmcBusinessBaseHelper.getExchangeRateNew((long)currency.getLong("id"), (long)loanCurrency.getLong("id"), (long)company.getLong("id"), (Date)DateUtils.getCurrentDate());
                if (rate == null) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4%1$s%2$s\u5151%3$s\u6c47\u7387\u3002", (String)"LoanBillEdit_15", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), company.getString("name"), loanCurrency.getString("name"), currency.getString("name")));
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"convertrate"});
                    return;
                }
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"convertrate"});
            }
        } else {
            rate = BigDecimal.ONE;
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"convertrate"});
        }
        this.getModel().setValue("convertrate", (Object)rate, rowIndex);
        this.getModel().setValue("accountbank", null, rowIndex);
    }

    private void convertRateChgEvt(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        BigDecimal newRate = (BigDecimal)e.getChangeSet()[0].getNewValue();
        if (newRate.compareTo(BigDecimal.ZERO) <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"LoanBillEdit_14", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            return;
        }
        String callIntStr = (String)this.getModel().getValue("intdetail_tag", rowIndex);
        if (EmptyUtil.isEmpty((String)callIntStr)) {
            return;
        }
        IntBillExtInfo intBillInfo = (IntBillExtInfo)SerializationUtils.fromJsonString((String)callIntStr, IntBillExtInfo.class);
        BigDecimal amount = intBillInfo.getAmount();
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency", rowIndex);
        BigDecimal actualInstAmt = amount;
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            actualInstAmt = amount.divide(newRate, currency.getInt("amtprecision"), RoundingMode.HALF_UP);
        }
        this.getModel().setValue("actualinstamt", (Object)actualInstAmt, rowIndex);
        this.getModel().setValue("convertintamt", (Object)amount, rowIndex);
    }

    private void actalAmtChgEvt(PropertyChangedArgs e) {
        this.updateConvertIntAmt(e);
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("entry");
        DynamicObject entry = model.getEntryRowEntity("entry", rowIndex);
        BigDecimal actualInstAmt = entry.getBigDecimal("actualinstamt");
        DynamicObject payCurrency = entry.getDynamicObject("currency");
        String selects = "id,loancontractbill,billno,currency";
        DynamicObject loanBill = TmcDataServiceHelper.loadSingle((String)"cfm_loanbill", (String)selects, (QFilter[])new QFilter[]{new QFilter("id", "=", entry.get("loanbillid"))});
        String intComment = BatchIntBillHelper.genIntComment((DynamicObject)loanBill, (BatchIntViewInfoEnum)this.getBatchIntViewInfo(), (Date)((Date)model.getValue("bizdate")), (BigDecimal)actualInstAmt, (DynamicObject)payCurrency);
        model.setValue("intcomment", (Object)intComment, rowIndex);
        String intDetailTag = entry.getString("intdetail_tag");
        if (EmptyUtil.isNoEmpty((String)intDetailTag)) {
            IntBillExtInfo intBillInfo = (IntBillExtInfo)SerializationUtils.fromJsonString((String)intDetailTag, IntBillExtInfo.class);
            model.setValue("intyearrate", (Object)intBillInfo.calcIntYearRate(actualInstAmt), rowIndex);
        }
    }

    private void updateConvertIntAmt(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        BigDecimal newActalAmt = (BigDecimal)e.getChangeSet()[0].getNewValue();
        BigDecimal convertRate = (BigDecimal)this.getModel().getValue("convertrate", rowIndex);
        BigDecimal convertIntAmt = newActalAmt;
        if (convertRate.compareTo(BigDecimal.ZERO) > 0) {
            convertIntAmt = newActalAmt.multiply(convertRate);
        }
        this.getModel().setValue("convertintamt", (Object)convertIntAmt, rowIndex);
    }

    private void setAccountBalance(PropertyChangedArgs e) {
        DynamicObject accountbank = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (this.getView().getControl("curbalance") != null) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (EmptyUtil.isNoEmpty((DynamicObject)accountbank)) {
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency", rowIndex);
                BizBalanceModelBean balance = BizBalanceModelHelper.getRunningBalance((String)BalanceTypeEnum.BALANCE.getValue(), (long)accountbank.getLong("id"), (long)currency.getLong("id"));
                if (balance != null && balance.getAmount() != null) {
                    this.getModel().setValue("curbalance", (Object)balance.getAmount(), rowIndex);
                }
            } else {
                this.getModel().setValue("curbalance", null, rowIndex);
            }
        }
    }

    private void addOrgIds(String loanType, DynamicObject dyn, Set<String> orgIds) {
        if (StringUtils.equals((CharSequence)"ec", (CharSequence)loanType) && dyn.containsProperty("creditorg") && EmptyUtil.isNoEmpty((DynamicObject)dyn.getDynamicObject("creditorg"))) {
            orgIds.add(dyn.getDynamicObject("creditorg").getPkValue().toString());
        } else if ((StringUtils.equals((CharSequence)"loan", (CharSequence)loanType) || StringUtils.equals((CharSequence)"entrust", (CharSequence)loanType)) && dyn.containsProperty("company") && EmptyUtil.isNoEmpty((DynamicObject)dyn.getDynamicObject("company"))) {
            orgIds.add(dyn.getDynamicObject("company").getPkValue().toString());
        }
    }

    private IntBillExtInfo getIntBillExtInfo(DynamicObject loanBill) {
        DynamicObjectCollection intPlanEntrys = loanBill.getDynamicObjectCollection("interest_entry");
        if (intPlanEntrys.size() > 0) {
            List intPlans = intPlanEntrys.stream().filter(o -> o.getBigDecimal("interestcalamount").compareTo(BigDecimal.ZERO) > 0).filter(o -> o.getInt("intstate") == 0).collect(Collectors.toList());
            if (intPlans.size() == 0) {
                return null;
            }
            DynamicObject intPlanEntry = intPlans.stream().min(Comparator.comparing(c -> c.getDate("interesdate"))).orElseGet(null);
            if (EmptyUtil.isNoEmpty((DynamicObject)intPlanEntry)) {
                DynamicObjectCollection interestSubEntrys = intPlanEntry.getDynamicObjectCollection("interest_subentry");
                logger.info("fillIntDetail  interestSubEntrys: " + interestSubEntrys.toString());
                if (interestSubEntrys.size() > 0) {
                    IntBillExtInfo extInfo = new IntBillExtInfo();
                    extInfo.setBeginDate(intPlanEntry.getDate("intstartdate"));
                    extInfo.setEndDate(intPlanEntry.getDate("intenddate"));
                    extInfo.setBizDate(intPlanEntry.getDate("interesdate"));
                    BigDecimal predictInstAmt = interestSubEntrys.stream().map(e -> e.getBigDecimal("interestamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    extInfo.setAmount(predictInstAmt);
                    BigDecimal floatInt = interestSubEntrys.stream().map(e -> e.getBigDecimal("floatint")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    BigDecimal benchmarkInt = interestSubEntrys.stream().map(e -> e.getBigDecimal("benchmarkint")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    if (benchmarkInt.compareTo(BigDecimal.ZERO) == 0) {
                        benchmarkInt = interestSubEntrys.stream().map(e -> e.getBigDecimal("interestamount").subtract(e.getBigDecimal("floatint"))).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    }
                    extInfo.setFloatInt(floatInt);
                    extInfo.setBenchmarkInt(benchmarkInt);
                    ArrayList<IntBillDetailExtInfo> extDetails = new ArrayList<IntBillDetailExtInfo>(interestSubEntrys.size());
                    for (DynamicObject entry : interestSubEntrys) {
                        IntBillDetailExtInfo extDetail = new IntBillDetailExtInfo();
                        extDetail.setBeginDate(entry.getDate("intereststartdate"));
                        extDetail.setEndDate(entry.getDate("interestenddate"));
                        extDetail.setDays(entry.getInt("interestdate"));
                        extDetail.setPrinciple(entry.getBigDecimal("interestbalance"));
                        extDetail.setBenchmarkInt(entry.getBigDecimal("benchmarkint"));
                        extDetail.setFloatRate(entry.getBigDecimal("floatrate"));
                        extDetail.setFloatInt(entry.getBigDecimal("floatint"));
                        extDetail.setRate(entry.getBigDecimal("interestrate"));
                        extDetail.setAmount(entry.getBigDecimal("interestamount"));
                        extDetail.setBasisDay(entry.getInt("interestdays"));
                        extDetails.add(extDetail);
                    }
                    extInfo.setExtDetails(extDetails);
                    logger.info("fillIntDetail  extInfo: " + extInfo.toString());
                    return extInfo;
                }
            }
        }
        return null;
    }
}

